{$F+}            { Use only FAR CALL Model }

Unit PSG;        { This unit used in PAS programs to play PSG music files }

{ --------------------------------------------------------------------------

  Function  Start_PSG_Play (StartArea : pointer; AreaSize : longint) : WORD
                         returns 0 if song playback initiated successfully,
                         returns 1 if playback initiation failed;

  Function  Stop_PSG_Play : word;
                         always returns zero (success);

  Function  Adlib_Detect : word;
                         returns 0 if Adlib found (okay),
                         returns 1 if no sound card found (failure);

  Function  Check_Status : word;
                         returns 0 if music is being played;
                         returns 1 if music is stopped (end of song reached);
                         returns 2 if music playback not yet initiated;
                         returns 3 if music playback temporary paused

  Procedure Enable_Loop;  Enable song looping;
  Procedure Disalbe_Loop; Disalbe song looping;

  Function Get_Volume : word;        Returned word bitfields:
                                     3-0  Channel A volume (0=min, 15=max)
                                     7-4  Channel B volume
                                     11-8 Channel C volume

  Function  Pause_Playback : word;   Temporary pause PSG playback
                                     Returns 0 if call was successfull

  Function  Resume_Playback : word;  Resume PSG playback after PAUSE
                                     Returns 0 if call wass successfull

  Function ReadFile (name:string; var Adr:pointer; var Size : longint):word;
                         Load specified file into heap. Returns:

                         0001 : File loading error;
                         0002 : Heap memory not enough to load that file;
                         0000 : File loaded okay (Adr - pointer to data,
                                                  Size - file length);

  Procedure ShutDown;     Stop PSG playback, release allocated heap.

 ------------------------------------------------------------------------- }

INTERFACE

Function  Start_PSG_Play (AreaStart:pointer; AreaSize:longint)        : word;
Function  Stop_PSG_Play                                               : word;
Function  Check_Status                                                : word;
Procedure Enable_Loop;
Procedure Disable_Loop;
Function  Pause_Playback                                              : word;
Function  Resume_Playback                                             : word;
Function  Adlib_Detect                                                : word;
Function  ReadFile (nme:string; var PPoint:pointer; var PSize:longint): word;
Procedure ShutDown;
Function Get_Volume                                                   : word;

IMPLEMENTATION

const    RecSize = 4096;                        { Internal types/const/etc }
type     BufType = array [1..RecSize] of byte;
var      SaveHeapState : pointer;

{$L PLAY_PSG.OBJ}

Function Start_PSG_Play (AreaStart:pointer; AreaSize:longint):word; external;
Function Stop_PSG_Play : word; external;
Function Check_Status : word; external;
Procedure Enable_Loop; external;
Procedure Disable_Loop; external;
Function Pause_Playback : word; external;
Function Resume_Playback : word; external;
Function  Adlib_Detect : word; external;
Function Get_Volume : word; external;


Function ReadFile (nme : string; var PPoint : pointer;
                   var PSize : longint) : word;


var dummy   : word;
    f       : file;
    p,p1    : ^BufType;
    Buf     : BufType;
    iocode  : integer;

begin
  Assign (f, nme);
  {$I-}
  Reset (f, 1);
  {$I+}

  iocode := IOResult;
  if IOcode <> 0 then ReadFile := 1;
  if IOcode <> 0 then Exit;

  PSize := FileSize (f);
  close (f);
  if PSize > MaxAvail then ReadFile := 2;
  if PSize > MaxAvail then Exit;

  Reset (f, RecSize);
  p := HeapPtr; p1 := p;
  Mark (SaveHeapState);
  while not EOF (f) do begin
    BlockRead (f, Buf, 1, dummy);
    GetMem (p, RecSize);
    p^ := Buf;
  end;
  close (f);
  PPoint := p1;
  ReadFile := 0;
end;


Procedure ShutDown;
begin
  Release (SaveHeapState);
  Stop_PSG_Play;
end;


END.
