{$i compile.inc}
unit files;
interface

{----- Tape -------}
type TapeInfo=record
               typ:String[15];
               name:String[10];
               code:String[4];
               Real,Data:record start,ends:longint; end;
              end;
      AsciiChars=Set of Char;

var Tapelist:array[1..100] of tapeinfo;
    anzEntry:Word;

function showtap(x,y:Word;Tape:array of TapeInfo;AnzEntry:Word;Max:Byte):Word;
function showbox(x,y,Max:Byte):Word;
procedure selectfile;
procedure readstr(x,y:WORD;chars: Asciichars;maxlen,col,back: byte;var str: string);
procedure saveSCREEN;
procedure savefile;
function choose(x,y,col,back: byte;M: array of string;C:byte;VAR LR:byte):Byte;
implementation

uses core,dos, grafx,lfn,dpmi,tape,vars,trdos,
     machine,z80mon,mf3;
{not the best listbox, but write a better one}
type s3=string[3];
const selfiles:array[0..4] of s3=('.TAP','.SNA','.Z80','.TRD','.ROM'); {<-- Hier ndern}
      maxfiles=1500;
type
     tfiles= record
        filename,ShortName: string[15];
        attr: string[9];
        datum: string[8];
        zeit: string[6];
       end;

var
          List         : Array[1..maxfiles] of tfiles;
          Numfiles     : Word;
          actdir       : String;  {Wo wir uns gerade befinden}

{------------------------------------------------------------------------}
function choose(x,y,col,back: byte;M: array of string;C:byte;VAR LR:byte):Byte;
var i: byte;
    color,wert: byte;
    ch: char;
    s:String;
    active:Boolean;
label again;
begin
 wert:=c;
 repeat
  for i:=low(m) to high(m) do
   begin
    s:=m[i];
    if
     s[1]='#' then begin delete(s,1,1);color:=116; end else color:=col;
    if i=wert then s:=' '+s else s:='  '+s;
    if m[i]<>'' then outtextxy(x,y-1+i*(maxy+4),s,color,back);
   end;
  ch:=readkey; if ch=#0 then ch:=readkey;
  again:
  case ch of
   #72: if wert>low(m) then dec(wert) else wert:=high(m);
   #80: if wert<high(m) then inc(wert) else wert:=low(m);
  end;
  if (m[wert]='') or (m[wert][1]='#') then goto again;
 until ch in [#13,#27,#75,#77];
 if ch=#27 then choose:=high(m) else choose:=wert;
 if ch=#77 then lr:=2 else
 if ch=#75 then lr:=1 else
 if ch=#27 then lr:=3 else
 lr:=0;
end;

{----- Tape -------}

procedure readTable(tapname:String;Var Tape:Array of TapeInfo;Var AnzEntry:Word);
var f:file;
    j,i,tapfile:byte;
    Temp:Array[1..10] of byte;
    len:word;
    counter:longint;
begin

  if pos('.TAP',tapname)>0 then tapfile:=2;
  assign(f,tapname);
  reset(f,1);
  counter:=0;AnzEntry:=0;
   while not eof(f) do
   begin
    with tape[AnzEntry] do
    begin
     name:='          ';code:='    ';typ:='               ';real.start:=0;
     real.ends:=0;data.start:=0;data.ends:=0;
    end;

    blockread(f,temp,2);
    tape[AnzEntry].real.start:=counter;inc(counter,2);
    len:=word(temp[1])+word(temp[2]) shl 8 - word(tapfile);
    tape[AnzEntry].real.ends:=len;
    blockread(f,temp,1);
    inc(counter,len+2);
    if (temp[1]=0) and (len=17) then
    begin
     blockread(f,temp,1);
     case temp[1] of
      3:tape[AnzEntry].typ:='Bytes';
      1:tape[AnzEntry].typ:='Number array';
      2:tape[AnzEntry].typ:='Character array';
      0:tape[AnzEntry].typ:='Program';
     end;
     if temp[1]<4 then
      begin
       j:=temp[1];
       blockread(f,temp,10);
       for i:=1 to 10 do tape[AnzEntry].name[i]:=chr(temp[i]);
       case j of
        0:begin
           blockread(f,temp,4);
           i:=temp[4] and $c0;
           if i=0 then
            with tape[AnzEntry] do
             begin
              code:='LINE';
              data.start:=temp[3]+word(temp[4]) shl 8;
             end;
            end;
         3:begin
            blockread(f,temp,4);
            with tape[AnzEntry] do
            begin
             code:='CODE';
             data.start:=temp[3]+word(temp[4]) shl 8;
             data.ends:=temp[1]+word(temp[2]) shl 8;
            end;
           end;
         end;
        end;
  end;
  seek(f,counter);
  inc(AnzEntry);
 end;
end;

function showtap(x,y:Word;Tape:array of TapeInfo;AnzEntry:Word;Max:Byte):Word;
var
  Pos, First   : Integer;
  C            : Char;
  Cont         : Integer;
  s            : string;
  col,back     : integer;
begin
  First := 1;
  Pos   := 1;
  Repeat
    For Cont := First To First + Max do
    begin
     If (Cont - First + 1 = Pos) Then
      begin
       col:=117;
       if tape[cont-1].typ='Program' then BACK:=120 else
       if tape[cont-1].typ='Bytes' then back:=118 else
        back:=119;

      end Else
       begin
       back:=117;
       if tape[cont-1].typ='Program' then col:=120 else
       if tape[cont-1].typ='Bytes' then col:=118 else
        col:=119;
       end;

     s:='';
     with tape[Cont-1] do if cont<=AnzEntry then
     begin
      s:=name+'    '+typ;while length(s)<30 do s:=s+' ';
      s:=s+i2s(real.ends,6,' ');
     end;
     while length(s)<36 do s:=s+' ';
     outtextxy(x,y+(cont-first)*(maxy+2),s,col,back);
    end;

    C := ReadKey;while keypressed do c:=Readkey;
    case c of
     #72: If (Pos > 1) Then Dec(Pos, 1) Else
          If (First > 1) Then Dec(First,1);
     #80: If (FIRST+Pos <= anzentry) and (pos<=max) Then Inc(Pos, 1) Else
          If (First + max < anzentry) Then Inc(First,1);
     #79: if integer(anzentry-max)>0 then
          begin
           first:=anzentry-max;pos:=max+1;
          end else
           begin
            first:=1;pos:=anzentry-first+1;
          end; {end}
     #71: begin first:=1;pos:=1; end;
     #81: {PgDown}
          if (first + max) >= anzentry then
            pos:=anzentry-first+1
           else
            begin
             inc(first,max);
             if first+pos>=anzentry then pos:=anzentry-first+1;
            end;

     #73: {PageUp} if (first - max) > 0 then dec(first,max) else
                   begin first := 1;pos:=1; end;
    end;

  Until (Ord(c) in [13,27]);
  if c=#27 then ShowTap:=anzentry+1 else ShowTap:=pos+first-{1}2;
end;

function upstring(S:String):String;
var i: byte;
begin
 for i:=1 to length(S) do s[i]:=upcase(s[i]);upstring:=s;
end;


procedure bubblesort;
var i,j: longint;
    temp : tfiles;
begin
       For i := 1 to numfiles do
       For j := 1 to numfiles do
        if (list[i].attr='UP--DIR')then
         begin
          temp := list[i];
          list[i] := list[j];
          list[j] := temp;
         end;  { if }

      For i := 1 to numfiles do
       For j := 1 to numfiles do
        begin
         if (list[j].filename='..') and (list[j].attr='UP--DIR') then
          begin // schreibe .. immer als ersten Eintrag !!
           temp := list[1];
           list[1] := list[j];
           list[j] := temp;
          end;

         if (list[i].attr=list[j].attr) then
         if (upstring(list[i].filename) < upstring(list[j].filename)) then
          begin
           temp := list[i];
           list[i] := list[j];
           list[j] := temp;
          end;  { if }
        end;
end;

{----------------------------------------------------------------------------}
Procedure LoadDir(path:String; filespec :array of s3; attribute :byte);far;
var DirInfo      : SearchRec;
    DT           : DateTime;
    i:integer;
    s:String;
begin
  actdir:=delback(path,-1);
  delete(actdir,length(actdir),1);
  fillchar(list,sizeof(list),0);
  NumFiles := 0;
  FindFirst(actdir+'\*.*', attribute, DirInfo);

  While DosError = 0 do
  begin
    if (dirinfo.name<>'.') and (dirinfo.attr and $8<>$8) then
    begin
     if dirinfo.attr and directory=directory Then
     begin
      Inc(NumFiles, 1);
      List[NumFiles].filename := dirinfo.name;
      List[NumFiles].shortname := dirinfo.name;
      list[numfiles].attr:='UP--DIR';

      unpacktime(dirinfo.time,dt);
      with dt do list[numfiles].datum:=i2s(day,2,'0')+'-'+i2s(month,2,'0')+'-'+copy(i2s(year,4,'0'),3,2);
      with dt do list[numfiles].zeit:=' '+i2s(hour,2,'0')+'.'+i2s(min,2,'0');

     end;
    end;
    FindNext(DirInfo);
  end;

  FindFirst(actdir+'\*.*', attribute, DirInfo);

  While DosError = 0 do
  begin
    if (dirinfo.name<>'.') and ((dirinfo.attr in [$8,$F])=false) then
    begin
     if (dirinfo.attr in [$10,$11,$16])=false Then
     for i:=low(filespec) to high(filespec) do
     if pos(filespec[i],upstring(dirinfo.name))>0 then
     begin
      Inc(NumFiles, 1);
      List[NumFiles].filename := downcase(dirinfo.name);
      List[NumFiles].shortname := downcase(dirinfo.name);
      list[numfiles].attr:=i2s(dirinfo.size,9,' ');

      unpacktime(dirinfo.time,dt);
      with dt do list[numfiles].datum:=i2s(day,2,'0')+'-'+i2s(month,2,'0')+'-'+copy(i2s(year,4,'0'),3,2);
      with dt do list[numfiles].zeit:=' '+i2s(hour,2,'0')+'.'+i2s(min,2,'0');
      break;
     end;
    end;
    FindNext(DirInfo);
  end;
  s:=drvlist;
  for i:=1 to length(s) do
   begin
     Inc(NumFiles, 1);
     list[numfiles].filename:='('+s[i]+':)';
     list[numfiles].attr:='   Drive ';
   end;
end;
{----------------------------------------------------------------------------}
Procedure LoadDir95(path:String; filespec :array of s3; attribute :byte);far;
{same as LoadDir but with LFN}
var DirInfo      : TLSearchRec;
    DT           : DateTime;
    i:integer;
    s:String;
begin
  actdir:=delback(path,-1);
  delete(actdir,length(actdir),1);
  fillchar(list,sizeof(list),0);
  NumFiles := 0;
  LFindFirst(actdir+'\*.*', attribute, DirInfo);
  While DosError = 0 do
  begin
    if (string(dirinfo.name)<>'.') and (dirinfo.attr and $8<>$8) then
    begin
     if dirinfo.attr and directory=directory Then
     begin
      Inc(NumFiles, 1);
      List[NumFiles].filename := string(dirinfo.name);
      List[NumFiles].shortname := dirinfo.Shortname;
      if dirinfo.shortname='' then
       List[NumFiles].shortname:=List[NumFiles].filename;
      list[numfiles].attr:='UP--DIR';

      unpacktime(dirinfo.creationtime.lo,dt);
      with dt do list[numfiles].datum:=i2s(day,2,'0')+'-'+i2s(month,2,'0')+'-'+copy(i2s(year,4,'0'),3,2);
      with dt do list[numfiles].zeit:=' '+i2s(hour,2,'0')+'.'+i2s(min,2,'0');

     end;
    end;
    LFindNext(DirInfo);
  end;
  LFindClose(Dirinfo);
  LFindFirst(actdir+'\*.*', attribute, DirInfo);
  While DosError = 0 do
  begin
    if (string(dirinfo.name)<>'.') and ((dirinfo.attr in [$8,$F])=false) then
    begin
     if (dirinfo.attr in [$10,$11,$16])=false Then
     for i:=low(filespec) to high(filespec) do
     if pos(filespec[i],upstring(dirinfo.name))>0 then
     begin
      Inc(NumFiles, 1);
      List[NumFiles].filename := downcase(dirinfo.name);
      List[NumFiles].shortname := downcase(dirinfo.shortname);
      if dirinfo.shortname='' then
       List[NumFiles].shortname:=List[NumFiles].filename;
      list[numfiles].attr:=i2s(dirinfo.Losize,9,' ');

      unpacktime(dirinfo.creationtime.lo,dt);
      with dt do list[numfiles].datum:=i2s(day,2,'0')+'-'+i2s(month,2,'0')+'-'+copy(i2s(year,4,'0'),3,2);
      with dt do list[numfiles].zeit:=' '+i2s(hour,2,'0')+'.'+i2s(min,2,'0');
     end;
    end;
    LFindNext(DirInfo);
  end;
  LFindClose(DirInfo);
  s:=drvlist;
  for i:=1 to length(s) do
   begin
     Inc(NumFiles, 1);
     list[numfiles].filename:='('+s[i]+':)';
     list[numfiles].attr:='   Drive ';
   end;
end;
{----------------------------------------------------------------------------}
function get_machine_type(Name:String):Byte;
var RomTyp:ZXModels;
begin
 name:=upstring(name);
 while pos('\',name)>0 do delete(name,1,pos('\',name));
 if (pos('MF',name)=1) or (POS('GEN',name)=1) then romTyp:=mMF128 else
 if pos('TRDOS',name)=1 then romTyp:=mTRDOS else
 if pos('PLUS2',name)=1 then romTyp:=mZXPlus2 else
 if pos('PLUS3',name)=1 then romTyp:=mZXPlus3 else
 if pos('SCOR',name)=1 then romTyp:=mScorpion else
 if pos('PEN',name)=1 then romTyp:=mPentagon else
 if pos('PLUS2',name)=1 then romTyp:=mZXPlus2 else
 if pos('DID',name)=1 then romTyp:=mDidaktik else
 if pos('128',name)=1 then romTyp:=mZX128 else
 romTyp:=mZX48;
 get_machine_type:=Byte(RomTyp);
end;

function checkROM(name:String):Byte;
const modell:array[0..10] of string=
      ('SPECTRUM 48k','SPECTRUM 128k','SPECTRUM +2',
       'SPECTRUM +3','DIDAKTIK 128k','PENTAGON 128k',
       'SCORPION 256k','','MF128 ROM','MF3 ROM','TRDOS ROM');
var c,lr:Byte;
begin
 box(110,60,240,162,117);
 souttextxy(130,65,'WHICH KIND OF ROM? ',118,119);
 h_line2(114,131,123,119,118);
 c:=get_machine_type(name);
 repeat
  c:=choose(125,75,119,117,modell,c,lr);
 until lr in [0,3];
 CheckROM:=c;
end;

{---------------------------------------------------------------------------}
procedure loadfile(Shortname:String);
const drive:STRING='ABCD';
var act:byte;
    color:String;
    ch:char;
    getuser:String;
begin
   if pos('.Z80',upstring(shortname))>0 then loadz80(shortname) else
   if pos('.ROM',upstring(shortname))>0 then
    begin
     getdir(0,getuser);
     getuser:=getuser+'\'+shortname;
     act:=checkrom(getuser);
      case ZXModels(Act) of
      mMF128:mf128init(getuser);
      mMF3:mf3init(getuser);
      else
       begin
        UserROM:=GetUser;UserRomTyp:=ZXModels(Act);
        set_spectrum_mode(mUser);
       end;
     end;
    end;
   if pos('.SNA',upstring(shortname))>0 then loadsna(shortname);
   if pos('.TAP',upstring(shortname))>0 then
    begin
     readtable(upstring(shortname),tapelist,anzentry);
     loadTAP(shortname);
    end;
   if pos('.VOC',upstring(shortname))>0 then
    begin
     loadVOC(shortname);
    end;
   if pos('.TRD',upstring(shortname))>0 then
    begin
     box(100,80,200,95,117);
     souttextxy(105,85,'SELECT DRIVE:',118,119);
     act:=1;
     repeat
      color:=#119+#119+#119+#119;color[act]:=#120;
      colouttextxy(175,85,drive,color,117);{TRDOS}
      ch:=readkey;while keypressed do ch:=readkey;
      case ch of
       #77: if act<4 then inc(act) else act:=1;
       #75: if act>1 then dec(act) else act:=4;
      end;
     until ch=#13;
     disks[act-1]:=shortname;
  end;
end;

const filename:string='';
function CreateNewImage:String;
{Gibt ein okay zurck, wenn eine neue Datei erstellt wird}
var dir,s:String;

begin
 box(0,0,319,20,117);
 souttextxy(4,4,'ENTER FILENAME TO LOAD/CREATE',118,119);
 outtextxy(5,13,'',119,119);
 s:='';readstr(10,13,['0'..'9','A'..'Z','a'..'z','.','\',':','_'],40,119,117,s);
 box(0,0,319,20,117);
 souttextxy(4,4,'SELECT SNAPSHOT FILE TO LOAD',118,119);
 {if s='' then box(0,30,83,178,117);}
 getdir(0,dir);if dir[length(dir)]<>'\' then dir:=dir+'\';
 while length(dir)<60 do dir:=dir+' ';dir:=copy(dir,1,60);
 outtextxy(4,12,dir,118,117);
 CreateNewImage:=S;
end;

function showbox(x,y,Max:Byte):Word;
var
  Pos, First   : Integer;
  C            : Char;
  Cont         : Integer;
  s            : string;
  col,back     : integer;
begin
  First := 1;
  Pos   := 1;
  Repeat
    For Cont := First To First + Max do
    begin
     If (Cont - First + 1 = Pos) Then
      begin
       col:=117;
       if list[cont].attr='   Drive ' then BACK:=120 else
       if list[cont].attr='UP--DIR' then back:=118 else
       if system.pos('.ROM',upstring(list[cont].shortname))>0 then back:=121 else
        back:=119;

      end Else
       begin
       back:=117;
       if list[cont].attr='   Drive ' then col:=120 else
       if list[cont].attr='UP--DIR' then col:=118 else
       if system.pos('.ROM',upstring(list[cont].shortname))>0 then col:=121 else
        col:=119;
       end;
     s:='';
     with list[Cont] do if cont<=numfiles then
     begin
      s:=COPY(FileName,1,15);
     end;
     while length(s)<15 do s:=s+' ';
     s:=copy(s,1,16);
     outtextxy(x,y+(cont-first)*(maxy+2),s,col,back);
    end;

    C := ReadKey;while keypressed do c:=Readkey;
    case c of
     #9: begin
          Filename:=CreateNewImage;  {TAB}
          If Filename<>'' then c:=#13;
         end;
     #72: If (Pos > 1) Then Dec(Pos, 1) Else
          If (First > 1) Then Dec(First,1);
     #80: If (FIRST+Pos <= numfiles) and (pos<=max) Then Inc(Pos, 1) Else
          If (First + max < NumFiles) Then Inc(First,1);
     #79: if integer(numfiles-max)>0 then
          begin
           first:=numfiles-max;pos:=max+1;
          end else
           begin
            first:=1;pos:=numfiles-first+1;
          end; {end}
     #71: begin first:=1;pos:=1; end;
     #81: {PgDown}
          if (first + max) >= numfiles then
            pos:=numfiles-first+1
           else
            begin
             inc(first,max);
             if first+pos>=numfiles then pos:=numfiles-first+1;
            end;
     #73: {PageUp} if (first - max) > 0 then dec(first,max) else
                   begin first := 1;pos:=1; end;
    end;

  Until (Ord(c) in [13,27]);
  if c=#27 then showbox:=0 else showbox:=pos+first-1;
end;

procedure selectfile;
const drive:STRING='ABCD';
var choosen:word;
    s,dir:String;
    color:String;
    act:byte;
    ch:char;
    olddir:string;
begin
filename:='';
 getdir(0,olddir);
 box(0,0,319,20,117);
 souttextxy(4,4,'SELECT SNAPSHOT FILE TO LOAD',118,119);
 box(0,30,83,178,117);
 repeat
  getdir(0,dir);if dir[length(dir)]<>'\' then dir:=dir+'\';
  if opsystem=0 then
   loaddir(dir,selfiles ,AnyFile) else loaddir95(dir,selfiles ,AnyFile);
  s:=dir;while length(s)<60 do s:=s+' ';s:=copy(s,1,60);
  outtextxy(4,12,s,118,117);
  bubblesort;
  choosen:=showbox(5,33,23);
  if filename<>'' then begin loadfile(filename);exit;end;

  if (choosen>0) then
  with list[choosen] do
  begin
  if attr='UP--DIR' then
  begin
    if shortname[1]<>'.' then s:=dir+shortname else s:=shortname;
    {$i-} chdir(s); {$i+}
  end;
  if (filename[1]='(') and (disksize(ord(filename[2])-ord('A')+1)>0)  then
   begin
    {$i-} chdir(filename[2]+':\'); {$i+}
   end;
   if ioresult<>0 then chdir(olddir);
  end;
 until (list[choosen].attr<>'UP--DIR') and
       (list[choosen].attr<>'   Drive ') or (choosen=0);
 if (choosen=0) and (filename='') then exit;
 with list[choosen] do loadfile(shortname);
end;
{---------------------------------------------------------------------------}
procedure readstr(x,y:WORD;chars: Asciichars;maxlen,col,back: byte;var str: string);
var ende,insertmode  : Boolean;
    ch               : Char;
    Posx,posy,curpos : Word;
    Curtype          : Integer;

 procedure writestr;
 var s:string;
 begin
  s:=str+'_'; while length(s)<=Maxlen do s:=s+' ';
  outtextxy(posx,posy,s,col,back);
 end;

begin
 ende:=false;
 {str:='';}
 posx:=x;
 posy:=y;
 curpos:=posx+length(str);
 writestr;
 insertmode:=true;
 repeat
  ch:=readkey;
  case ch of #32..#255:
  begin
  if ch in Chars then
   begin
    if (length(str)<maxlen) then
    begin
     if insertmode then
      str:=copy(str,1,curpos-posx)+ch+copy(str,curpos-posx+1,maxlen) else
      str:=copy(str,1,curpos-posx)+ch+copy(str,curpos-posx+2,maxlen);
      inc(curpos);
    end else
    if (not insertmode) and (curpos<length(str)+posx) then
    begin
     str:=copy(str,1,curpos-posx)+ch+copy(str,curpos-posx+2,maxlen);
     inc(curpos);
    end;
    writestr;
    end;
   end;
   #8 : if(Curpos>posx) then {Rcktaste}
        begin
         delete(str,curpos-posx,1);
         dec(curpos);
         writestr;
        end;
   #13: ende:=true; {Enter}
   #27,#9: begin; {Escape}
         str:='';
         curpos:=posx;
         writestr;
         ende:=true;
        end;
  end;
 until ende=true;
end;

procedure savefile;
var s:String;
begin
 box(1,1,319,20,117);
 souttextxy(10,4,'ENTER NAME OF SNAP FILE.',118,119);
 outtextxy(5,13,'',119,119);
 s:='';readstr(10,13,['0'..'9','A'..'Z','a'..'z','.','\',':','_'],40,119,117,s);
 if s<>'' then
  begin
   if pos('.SNA',upstring(s))>0 then savesna(s) else savez80(s);
  end;
end;

procedure saveSCREEN;
var s:String;
begin
 box(1,1,319,20,117);
 souttextxy(10,4,'ENTER NAME OF SCREENSHOT.',118,119);
 outtextxy(5,13,'',119,119);
 while keypressed do readkey;
 s:='';readstr(10,13,['0'..'9','A'..'Z','a'..'z','.','\',':','_'],40,119,117,s);
 if s<>'' then
  begin
   repaintall;
   if pos('.PCX',upstring(s))>0 then savepcx(s,0,0,319,199,320,200) else savescr(s);
  end;
end;
end.
