{$i compile.inc}
unit grafx;

interface
const
  GFXMode:array[0..7] of record sx,sy:word;name:string;Stretch:Boolean; end=(
     (sx:320;sy:200;name:'320,200';Stretch:False),
     (sx:372;sy:564;name:'372,564';stretch:False),
     (sx:320;sy:240;name:'320,240';Stretch:False),
     (sx:360;sy:240;name:'360,240';Stretch:False),
     (sx:400;sy:300;name:'400,300';Stretch:False),
     (sx:320;sy:400;name:'320,400';Stretch:False),
     (sx:320;sy:480;name:'320,480';Stretch:True),
     (sx:640;sy:480;name:'640,480';Stretch:True));

const maxx=4;maxy=4;maxchars=63;
      CHARS='ABCDEFGHIJKLMNOPQRSTUVWXYZ +-*/<>!?={}[]()1234567890.,#:\~_%''';

 procedure drawellipse(Color,deadline:Byte);
 function getpixel(x,y:Word):Byte;
 procedure putpixel(X,y:Word;c:Byte);
 Procedure H_LINE(x, y, Length : Word; Color : Byte);
 Procedure V_LINE(x, y, Length : Word; Color : Byte);
 procedure h_line2(x,y,length,color1,color2:Word);
 procedure box(x1,y1,x2,y2,col: word);
 procedure outtextxy(xp,yp:Word;S:String;c,back:Byte);
 procedure colouttextxy(xp,yp:Word;S,Col:String;Back:Byte);
 procedure souttextxy(xp,yp:Word;S:String;C,Shadow:Byte);
 procedure number_outtextxy(xp,yp:Word;S:String;C,Shadow:Byte);
 Procedure SavePCX (FN : String;MinX,MinY,MaxX,MaxY,ResX,Resy:Word);
 procedure Put_Line(x, y, Length : Word; Var Color);
 procedure Fill(Color : Byte);

 function Initgraph(mode:Word):Boolean;
 procedure closegraph;

 const vidmode:Word=0;

implementation uses dos,vbe2,core;

type TZeichen=array[0..maxx,0..maxy] of byte;
const hyperellipse:array[0..39] of byte=
                  (160,79,65,55,48,42,37,33,30,27,24,22,20, 18,
                    16,15,13,12,11,10, 9, 8, 7, 6, 5, 5, 4, 4,
                     3, 3, 3, 2, 2, 2, 1, 1,  1, 1, 1, 1);

Zeichen_Len:Array[0..maxchars] of byte=(3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,
3,3,3,4,2,3,3,3,4,2,2,2,3,3,2,2,2,2,2,2,2,3,3,2,3,3,3,3,3,3,1,2,4,2,4,2,2,3,4,4,1);

Zeichen:Array[0..maxchars] of TZeichen=(
((0,0,0,0,0),(0,0,0,0,0),(0,0,0,0,0),(0,0,0,0,0),(0,0,0,0,0)),
((0,1,1,1,1),(1,0,1,0,0),(1,0,1,0,0),(0,1,1,1,1),(0,0,0,0,0)),
((1,1,1,1,1),(1,0,1,0,1),(1,0,1,0,1),(0,1,0,1,0),(0,0,0,0,0)),
((0,1,1,1,0),(1,0,0,0,1),(1,0,0,0,1),(0,1,0,1,0),(0,0,0,0,0)),
((1,1,1,1,1),(1,0,0,0,1),(1,0,0,0,1),(0,1,1,1,0),(0,0,0,0,0)),
((1,1,1,1,1),(1,0,1,0,1),(1,0,1,0,1),(1,0,0,0,1),(0,0,0,0,0)),
((1,1,1,1,1),(1,0,1,0,0),(1,0,1,0,0),(1,0,0,0,0),(0,0,0,0,0)),
((0,1,1,1,0),(1,0,0,0,1),(1,0,1,0,1),(1,0,1,1,1),(0,0,0,0,0)),
((1,1,1,1,1),(0,0,1,0,0),(0,0,1,0,0),(1,1,1,1,1),(0,0,0,0,0)),
((0,0,0,0,0),(1,0,0,0,1),(1,1,1,1,1),(1,0,0,0,1),(0,0,0,0,0)),
((1,0,1,1,0),(1,0,0,0,1),(1,0,0,0,1),(1,1,1,1,0),(0,0,0,0,0)),
((1,1,1,1,1),(0,0,1,0,0),(0,1,0,1,0),(1,0,0,0,1),(0,0,0,0,0)),
((1,1,1,1,1),(0,0,0,0,1),(0,0,0,0,1),(0,0,0,0,1),(0,0,0,0,0)),
((1,1,1,1,1),(0,1,0,0,0),(0,1,0,0,0),(1,1,1,1,1),(0,0,0,0,0)),
((1,1,1,1,1),(0,1,0,0,0),(0,0,1,0,0),(1,1,1,1,1),(0,0,0,0,0)),
((0,1,1,1,0),(1,0,0,0,1),(1,0,0,0,1),(0,1,1,1,0),(0,0,0,0,0)),
((1,1,1,1,1),(1,0,1,0,0),(1,0,1,0,0),(0,1,0,0,0),(0,0,0,0,0)),
((0,1,1,1,0),(1,0,0,0,1),(1,0,0,1,1),(0,1,1,1,1),(0,0,0,0,0)),
((1,1,1,1,1),(1,0,1,0,0),(1,0,1,0,0),(0,1,0,1,1),(0,0,0,0,0)),
((0,1,0,0,1),(1,0,1,0,1),(1,0,1,0,1),(0,0,0,1,0),(0,0,0,0,0)),
((0,0,0,0,0),(1,0,0,0,0),(1,1,1,1,1),(1,0,0,0,0),(0,0,0,0,0)),
((1,1,1,1,0),(0,0,0,0,1),(0,0,0,0,1),(1,1,1,1,0),(0,0,0,0,0)),
((1,1,1,0,0),(0,0,0,1,0),(0,0,0,0,1),(0,0,0,1,0),(1,1,1,0,0)),
((1,1,1,1,1),(0,0,0,1,0),(0,0,0,1,0),(1,1,1,1,1),(0,0,0,0,0)),
((0,0,0,0,0),(1,1,0,1,1),(0,0,1,0,0),(1,1,0,1,1),(0,0,0,0,0)),
((0,0,0,0,0),(1,1,0,0,0),(0,0,1,1,1),(1,1,0,0,0),(0,0,0,0,0)),
((1,0,0,0,1),(1,0,0,1,1),(1,0,1,0,1),(1,1,0,0,1),(1,0,0,0,1)),
((0,0,0,0,0),(0,0,0,0,0),(0,0,0,0,0),(0,0,0,0,0),(0,0,0,0,0)),
((0,0,0,0,0),(0,0,1,0,0),(0,1,1,1,0),(0,0,1,0,0),(0,0,0,0,0)),
((0,0,0,0,0),(0,0,1,0,0),(0,0,1,0,0),(0,0,1,0,0),(0,0,0,0,0)),
((0,0,0,0,0),(0,1,0,1,0),(0,0,1,0,0),(0,1,0,1,0),(0,0,0,0,0)),
((0,0,0,0,1),(0,0,0,1,0),(0,0,1,0,0),(0,1,0,0,0),(1,0,0,0,0)),
((0,0,1,0,0),(0,1,0,1,0),(1,0,0,0,1),(0,0,0,0,0),(0,0,0,0,0)),
((1,0,0,0,1),(0,1,0,1,0),(0,0,1,0,0),(0,0,0,0,0),(0,0,0,0,0)),
((0,0,0,0,0),(0,0,0,0,0),(1,1,1,0,1),(0,0,0,0,0),(0,0,0,0,0)),
((0,1,0,0,0),(1,0,0,1,1),(1,0,1,0,0),(0,1,0,0,0),(0,0,0,0,0)),
((0,1,0,1,0),(0,1,0,1,0),(0,1,0,1,0),(0,1,0,1,0),(0,0,0,0,0)),
((0,0,1,0,0),(1,1,0,1,1),(1,0,0,0,1),(0,0,0,0,0),(0,0,0,0,0)),
((1,0,0,0,1),(1,1,0,1,1),(0,0,1,0,0),(0,0,0,0,0),(0,0,0,0,0)),
((1,1,1,1,1),(1,0,0,0,1),(1,0,0,0,1),(0,0,0,0,0),(0,0,0,0,0)),
((1,0,0,0,1),(1,0,0,0,1),(1,1,1,1,1),(0,0,0,0,0),(0,0,0,0,0)),
((0,1,1,1,0),(1,0,0,0,1),(1,0,0,0,1),(0,0,0,0,0),(0,0,0,0,0)),
((1,0,0,0,1),(1,0,0,0,1),(0,1,1,1,0),(0,0,0,0,0),(0,0,0,0,0)),
((0,1,0,0,1),(1,1,1,1,1),(0,0,0,0,1),(0,0,0,0,0),(0,0,0,0,0)),
((1,0,0,1,1),(1,0,1,0,1),(1,0,1,0,1),(0,1,0,0,1),(0,0,0,0,0)),
((1,0,0,0,1),(1,0,1,0,1),(1,0,1,0,1),(0,1,0,1,0),(0,0,0,0,0)),
((0,1,1,0,0),(0,0,1,0,0),(1,1,1,1,1),(0,0,0,0,0),(0,0,0,0,0)),
((1,1,1,0,1),(1,0,1,0,1),(1,0,1,0,1),(1,0,0,1,0),(0,0,0,0,0)),
((0,1,1,1,0),(1,0,1,0,1),(1,0,1,0,1),(0,0,0,1,0),(0,0,0,0,0)),
((1,0,0,0,0),(1,0,0,1,1),(1,0,1,0,0),(1,1,0,0,0),(0,0,0,0,0)),
((0,1,0,1,0),(1,0,1,0,1),(1,0,1,0,1),(0,1,0,1,0),(0,0,0,0,0)),
((0,1,0,0,0),(1,0,1,0,1),(1,0,1,0,1),(0,1,1,1,0),(0,0,0,0,0)),
((0,1,1,1,0),(1,0,0,0,1),(1,0,0,0,1),(0,1,1,1,0),(0,0,0,0,0)),
((0,0,0,0,0),(0,0,0,0,1),(0,0,0,0,0),(0,0,0,0,0),(0,0,0,0,0)),
((0,0,0,0,0),(0,0,0,0,1),(0,0,0,1,0),(0,0,0,0,0),(0,0,0,0,0)),
((0,1,0,1,0),(1,1,1,1,1),(0,1,0,1,0),(1,1,1,1,1),(0,1,0,1,0)),
((0,0,0,0,0),(0,1,0,1,0),(0,1,0,1,0),(0,0,0,0,0),(0,0,0,0,0)),
((1,0,0,0,0),(0,1,0,0,0),(0,0,1,0,0),(0,0,0,1,0),(0,0,0,0,1)),
((1,1,1,1,1),(0,1,1,1,0),(0,0,1,0,0),(0,0,0,0,0),(0,0,0,0,0)),
((0,0,1,0,0),(0,1,1,1,0),(1,1,1,1,1),(0,0,0,0,0),(0,0,0,0,0)),
((0,1,0,0,0),(0,0,1,0,0),(0,1,0,0,0),(0,0,1,0,0),(0,0,0,0,0)),
((0,0,0,0,1),(0,0,0,0,1),(0,0,0,0,1),(0,0,0,0,1),(0,0,0,0,1)),
((1,1,0,0,1),(1,1,0,1,0),(0,0,1,0,0),(0,1,0,1,1),(1,0,0,1,1)),
((0,1,0,0,0),(1,0,0,0,0),(0,0,0,0,0),(0,0,0,0,0),(0,0,0,0,0)));

{--------------------------------- MENS ------------------------------------}

PROCEDURE putpixel(x, y : Word; c : BYTE);
BEGIN
  mem[longint(screenbuffer)+y*currentx+x]:=c;
END;

FUNCTION getpixel(x, y : Word):Byte;
BEGIN
  result:=mem[longint(screenbuffer)+y*currentx+x];
END;

procedure h_line(x, y, Length : Word; Color : Byte);
begin
 fillchar(mem[longint(screenbuffer)+X+Y*currentX],Length,Color);
end;


procedure V_LINE(x, y, Length : Word; Color : Byte);
var offset:longint;
    i:Word;
begin
 offset:=Y*CurrentX+X;
 for i:=0 to length-1 do
  begin
   mem[longint(screenbuffer)+offset]:=color;
   inc(offset,currentx);
  end;
end;

procedure Put_Line(x, y, Length : Word; Var Color);
begin
 move(color,mem[longint(screenbuffer)+x+y*currentx],length);
end;
function ofs(var P):longint;assembler;
asm
 mov eax, dword ptr [p]
end;

procedure Fill(Color : Byte);
begin
 fillchar(screenbuffer^,currentx*currenty,Color);
end;

procedure h_line2(x,y,length,color1,color2:Word);
begin
 h_line(x,y,length,color1);h_line(x,y+1,length,color2);
end;

procedure box(x1,y1,x2,y2,col: word);
var y:Word;
begin
 for y:=y1 to y2 do h_line(x1,y,x2-x1,col);
 if col=117 then
 begin
  v_line(x2,y1,y2-y1+1,0);h_line(x1+1,y2+1,x2-x1,0);
  v_line(x1,y1,y2-y1+2,col+1);h_line(x1,y1,x2-x1,col+1);
 end;
end;

{------------------------------------- FONT ---------------------------------}

(*procedure outtextxy(xp,yp:Word;S:String;c,back:Byte);
var x,y,l:word;
    offset:integer;
    ch:Byte;
begin
 offset:=0;
 for l:=1 to length(s) do
 begin
   s[l]:=upcase(s[l]);
   ch:=pos(s[l],chars);

   {if s[l-1] in ['M','W','V','X','Y','Z'] then inc(offset);
   if s[l] in ['I','T'] then dec(offset,1);}
    for y:=0 to maxy do for x:=0 to maxx do
     if zeichen[ch][x][y]<>0 then putpixel(xp+x+(l-1)*(maxx+1)+offset,y+yp,c)
      else if c<>back then putpixel(xp+x+(l-1)*(maxx+1)+offset,y+yp,back);
 end;
end;*)

procedure outtextxy(xp,yp:Word;S:String;c,back:Byte);
var x,y,l:word;
    ch:Byte;
begin
 for l:=1 to length(s) do
 begin
   s[l]:=upcase(s[l]);
   ch:=pos(s[l],chars);

    for y:=0 to maxy do for x:=0 to maxx do
     if zeichen[ch][x][y]<>0 then putpixel(xp+x,y+yp,c)
      else if c<>back then putpixel(xp+x,y+yp,back);
   inc(xp,5);
 end;
end;

procedure outtextxy2(xp,yp:Word;S:String;c,back:Byte);
var x,y,l:word;
    ch:Byte;
begin
 for l:=1 to length(s) do
 begin
   s[l]:=upcase(s[l]);
   ch:=pos(s[l],chars);

    for y:=0 to maxy do for x:=0 to maxx do
     if zeichen[ch][x][y]<>0 then putpixel(xp+x,y+yp,c)
      else if c<>back then putpixel(xp+x,y+yp,back);
   inc(xp,zeichen_len[ch]+2);
 end;
end;


procedure colouttextxy(xp,yp:Word;S,Col:String;Back:Byte);
var x,y,l:word;
    offset:integer;
    ch:Byte;
begin
 offset:=0;
 for l:=1 to length(s) do
 begin
   s[l]:=upcase(s[l]);
   ch:=pos(s[l],chars);
    for y:=0 to maxy do for x:=0 to maxx do
     if zeichen[ch][x][y]<>0 then putpixel(xp+x+(l-1)*(maxx+1)+offset,y+yp,ord(col[l]))
      else putpixel(xp+x+(l-1)*(maxx+1)+offset,y+yp,back);
 end;
end;

procedure souttextxy(xp,yp:Word;S:String;C,Shadow:Byte);
begin
 outtextxy(xp+1,yp+1,s,shadow,shadow);
 outtextxy(xp,yp,s,c,c);
end;

procedure number_outtextxy(xp,yp:Word;S:String;C,Shadow:Byte);
begin
 {outtextxy2(xp+1,yp+1,s,shadow,shadow);outtextxy2(xp,yp,s,c,c);}
 outtextxy2(xp+1,yp,s,shadow,shadow);outtextxy2(xp-1,yp,s,shadow,shadow);
 outtextxy2(xp,yp+1,s,shadow,shadow);outtextxy2(xp,yp-1,s,shadow,shadow);
 outtextxy2(xp,yp,s,c,c);
end;

{---------------------------------------------------------------------------}
Procedure GetPal (C: Byte; Var R,G,B : Byte);
Begin
  Port [$3c7] := C;
  Port [$3c8] := C;
  R := Port [$3c9];
  G := Port [$3c9];
  B := Port [$3c9];
End;


Procedure SavePCX (FN : String;MinX,MinY,MaxX,MaxY,ResX,Resy:Word);
Var
  F : File;
  Ln : Byte;

Procedure Write_Header;
type THeader=record
              Manufacturer,Version,Encoding,BPP:Byte;
              MinX,MinY,MaxX,MaxY,ResX,ResY:Word;
              OldPal:Array[1..48] of byte;
              Reserved,ColPlanes:Byte;
              BytesPerLine,PalTyp:Word;
             end;
Const
 header: theader=
           (Manufacturer:10;Version:5;Encoding:1;BPP:8;
            MinX:0;MinY:0;MaxX:319;MaxY:199;ResX:320;ResY:200;
            OldPal: (0,0,0,216,152,56,120,116,4,112,108,4,236,
                     172,76,248,196,128,64,36,36,36,40,20,248,
                     188,104,212,144,156,60,36,36,116,112,8,
                     120,116,8,124,120,8,52,48,4,240,196,136);
            Reserved:0;ColPlanes:1;BytesPerLine:320;PalTyp:0);
Var
  B,L : Byte;

Begin
  header.minx:=minx;header.miny:=miny;
  header.MaxX:=MaxX;Header.MaxY:=MaxY;
  header.ResX:=ResX;Header.ResY:=ResY;
  header.BytesPerLine:=ResX;

  blockwrite(F,Header,Sizeof(Theader));
  B := 0;
  For L := 1 to 58 Do BlockWrite (F,B,1);
End;

Procedure Encode_Line (Ln : Byte);
Var
  I,T : Word;
  P,Pack : Array [0..4000] of Byte;
  PackByte:Word;
Begin
  I := 0;
  T := 0;

  for i:=0 to MaxX-MinX do p[i]:=getpixel(i,ln);

  PackByte:=0;
  While T <= MaxX-MinX Do
  Begin
    I := 0;
    While ((P [T + I] = P [T + I + 1]) And ((T + I) <= MaxX-MinX) And (I < 63)) Do
      Inc (I);
    If I > 0 Then
    Begin
      pack[PackByte]:=I Or 192;inc(PackByte);
      pack[PackByte]:=P[T];inc(PackByte);
      Inc (T,I);
    End
    Else Begin
      If (((P [T]) And 192) = 192) Then
      Begin
         pack[PackByte]:=193;inc(PackByte);
      End;
      pack[PackByte]:=P[T];inc(PackByte);
      Inc (T);
    End;
  End;
  blockwrite(f,pack,packbyte);
End;

Procedure Write_Palette;
Var L:Byte;
    pal:array[0..255] of record R,G,B : Byte;end;
Begin
  L := 12;
  BlockWrite (F,L,1);
  For L := 0 to 255 Do
   with pal[l] do
    begin
     GetPal(L,R,G,B);r:=r shl 2;g:=g shl 2;b:=b shl 2;
    end;
  blockwrite(f,pal,sizeof(pal));
End;

Begin
  Assign (F,FN);
 {$I-} Rewrite (F,1); {$I+}
 if ioresult<>0 then exit;

 Write_Header;
 For Ln := MinY to MaxY Do Encode_Line (Ln);
 Write_Palette;
 Close (F);
End;

function Initgraph(mode:Word):Boolean;
begin
 if mode>high(gfxmode) then mode:=0;
 vidmode:=mode;
 with gfxmode[mode] do result:=vbe2.initgraph(sx,sy,8,true);
end;

procedure closegraph;
begin
 asm mov ax,3; int 10h; end;
 vbe2.closegraph;
end;
procedure drawellipse(Color,deadline:Byte);
var y,x,l:Word;
begin
 if currenty<=200 then exit; {only vesa}
 for y:=0 to 39 do
 begin
  l:=hyperellipse[y];
  h_line(0,y+deadline,l,color);        h_line(currentx-l,y+deadline,l,color);
  h_line(0,currenty-(y+deadline),l,color);h_line(currentx-l,currenty-y,l,color);
 end;
end;


begin
 initnew('GRAFX');
end.
