{TRDOSROM wird in ROM[2] geschrieben !!!!!!!!!!!!!!!!!!!}
unit pentagon;

interface

procedure pentagoninit(romname,trdosname:String);

implementation

uses core,vars,machine,z80CPU,sndDrv,trdos,mf3;

const version:string = '$Id: pentagon.pas,v 1.0';

procedure open_rom_pentagon(romname,trdosname:String);
var f: file;
    numread:longint;
begin
 assign(f,romname);reset(f,1);
 blockread(f,ROM[0]^,16384,numread);
 blockread(f,ROM[1]^,16384,numread);
 close(f);
 assign(f,trdosname);reset(f,1);
 blockread(f,ROM[2]^,16384,numread);
 close(f);
end;
{$f+}
function PentagonReadMem(Addr:Word):Byte;
begin
 PentagonReadMem:=SRAM[(addr and $C000) shr 14]^[addr and $3FFF]
end;

procedure PentagonWriteMem(addr:word;val:Byte);
var segm:Word;
begin
 segm:=(addr and $C000) shr 14;
 if (SEGM>0) or (SRAM[Segm]=ROM[4]) then SRAM[segm]^[addr and $3FFF]:=val;
end;

procedure PentagonNmi;
begin
	Z80_NMI;
        Inport(0,191);
end;

procedure PentagonHookTRD;
begin
   if (pc.w>=$4000) and (sram[0]=ROM[2]) then
    SRAM[0]:=ROM[byte(last_7ffd and 16>0)]
   else
    if (pc.w and $ff00=$3d00) and (sram[0]=ROM[1]) then
     SRAM[0]:=ROM[2];
end;

procedure PentagonInitPages;
begin
        SRAM[0]:=ROM[0];
	SRAM[1]:=RAM[5];
	SRAM[2]:=RAM[2];
	SRAM[3]:=RAM[0];
        SP_SCREEN:=RAM[5];
end;

procedure PentagonReset;
begin
	Z80_Reset;
        PentagonInitPages;
end;

function PentagonInPort(port_hi, port_lo:Byte):Byte;
var i,data: byte;
begin
     if (sram[0]=ROM[2]) and (port_lo and 31>0) then
      begin
        i:=(port_lo shr 4) and $e;
        if i<8 then diskvg(i,data) else
        if i=$E then diskvg(8,data);
        PentagonInPort:=data;exit;
      end;

        case port_lo of
                  31: PentagonInPort:=StickValue; (* Kempston *)
                63,191:PentagonInPort:=inMF128(port_lo);
                 253: (* Ay-3-8912 *) PentagonInPort:=PSG[last_fffd];
                 254: (* Keys *)
                    begin
                        data:=255;
                        if port_hi and 128=0 then
                                data:=data and SKey[7];
                        if port_hi and 64=0 then
                                data:=data and SKey[6];
                        if port_hi and 32=0 then
                                data:=data and SKey[5];
                        if port_hi and 16=0 then
                                data:=data and SKey[4];
                        if port_hi and 8=0 then
                                data:=data and SKey[3];
                        if port_hi and 4=0 then
                                data:=data and SKey[2];
                        if port_hi and 2=0 then
                                data:=data and SKey[1];
                        if port_hi and 1=0 then
                                data:=data and SKey[0];
                        {if (VOC_file_open) and (VOC_paused=false) then
                            data:=data xor return_next_bit;}
                        PentagonInPort:=data;
                       end;
                 255: (* Vertical Retrace (not on +3 or +2A) *)
                      PentagonInPort:=vline and 255; (* Temporary  *)
                else PentagonInPort:=255; (* Temporary *)
        end;
end;

procedure PentagonOutPort(portnum:word;val:Byte);
var btemp,port_hi,port_lo:Byte;
begin
  port_hi:=(portnum shr 8) and $FF;
  port_lo:=(portnum and $FF);

  if (sram[0]=ROM[2]) and (port_lo and 31>0) then
   begin
    btemp:=(port_lo shr 4);
    if btemp<8 then diskvg(btemp,val) else
    if btemp=$F then diskvg(9,val);
   end;

  if (port_lo and 1)=0 then border:=val and 7;(* ULA (border/48K sound) *)

  if (not(odd(portnum))) then
   Begin
    tune48k(val);exit;
   End;

    if port_lo=253 then
     begin
      btemp:=port_hi shr 6;
      case btemp of
      0,1: begin
            SRAM[3]:=RAM[val and 7];
            if (val and 8)>0 then SP_SCREEN:=RAM[7] else SP_SCREEN:=RAM[5];
            if SRAM[0]<>ROM[4] then SRAM[0]:=ROM[(val and 16) shr 4];
            last_7ffd:=val;
           end;

        2: sound.PSGOut(last_fffd,val);
        3: last_fffd:=val and 15;
      end;
     end;

end;


{$f-}

procedure PentagonInit(romname,trdosname:String);
var i:byte;
begin
        max_v_Line:=311;
        t_states_per_line:=228;{311; {???}

	Machine_reset:= PentagonReset;
	Machine_nmi:= PentagonNmi;
	Machine_HookTRD:= PentagonHookTRD;
        Machine_InitPages:=PentagonInitPages;;

	speekb:= PentagonReadMem;
	spokeb:= PentagonWriteMem;
	inPort:= PentagonInPort;
	outPort:= PentagonOutPort;
        open_rom_Pentagon(romname,trdosname);

        {Pentagonreset;}
        ROM[1]^[1386]:=237;
        ROM[1]^[1387]:=255;
end;

begin
 initnew(version);
end.
