unit plus2;

interface

procedure specplus2init(romname:String);

implementation

uses core,vars,machine,z80CPU,sndDrv,mf3;

const version:string = '$Id: plus2.pas,v 1.0';

procedure open_rom_plus2(romname:String);
var f: file;
    numread:longint;
begin
 assign(f,romname);reset(f,1);
 blockread(f,ROM[0]^,16384,numread);
 blockread(f,ROM[1]^,16384,numread);
 close(f);
end;
{$f+}
function specPlus2ReadMem(Addr:Word):Byte;
begin
 specPlus2ReadMem:=SRAM[(addr and $C000) shr 14]^[addr and $3FFF]
end;

procedure specPlus2WriteMem(addr:word;val:Byte);
var segm:Word;
begin
 segm:=(addr and $C000) shr 14;
 if (SEGM>0) or (SRAM[Segm]=ROM[4]) then SRAM[segm]^[addr and $3FFF]:=val;
 if (CONTENDED[segm]>0) and
    (t_state shr 7=0) and (vline and 192>0) then inc(t_state,4);
end;

procedure specPlus2Nmi;
begin
	Z80_NMI;
        inport(0,191);
end;

procedure specPlus2HookTrd;
begin
end;

procedure specPlus2InitPages;
begin
        SRAM[0]:=ROM[0];
	SRAM[1]:=RAM[5];
	SRAM[2]:=RAM[2];
	SRAM[3]:=RAM[0];
        SP_SCREEN:=RAM[5];
        CONTENDED[0]:=0;CONTENDED[1]:=0;
        CONTENDED[2]:=1;CONTENDED[3]:=1;
        CONTENDED[4]:=0;CONTENDED[5]:=0;
        CONTENDED[6]:=0;CONTENDED[7]:=0;

end;

procedure specPlus2Reset;
begin
	Z80_Reset;
        SpecPlus2InitPages;
end;

function specPlus2InPort(port_hi, port_lo:Byte):Byte;
var i,data: byte;
begin
        case port_lo of
                  31: specPlus2InPort:=StickValue; (* Kempston *)
                 63,191:specPlus2InPort:=inMF128(port_lo);
                 253: (* Ay-3-8912 *) specPlus2InPort:=PSG[last_fffd];
                 254: (* Keys *)
                    begin
                        data:=255;
                        if port_hi and 128=0 then
                                data:=data and SKey[7];
                        if port_hi and 64=0 then
                                data:=data and SKey[6];
                        if port_hi and 32=0 then
                                data:=data and SKey[5];
                        if port_hi and 16=0 then
                                data:=data and SKey[4];
                        if port_hi and 8=0 then
                                data:=data and SKey[3];
                        if port_hi and 4=0 then
                                data:=data and SKey[2];
                        if port_hi and 2=0 then
                                data:=data and SKey[1];
                        if port_hi and 1=0 then
                                data:=data and SKey[0];
                        {if (VOC_file_open) and (VOC_paused=false) then
                            data:=data xor return_next_bit;}
                        specPlus2InPort:=data;
                       end;
                 255: (* Vertical Retrace (not on +3 or +2A) *)
                      specPlus2InPort:=vline and 255; (* Temporary  *)
                else specPlus2InPort:=255; (* Temporary *)
        end;
end;


procedure SpecPlus2OutPort(portnum:word;val:Byte);
var btemp,port_hi,port_lo:Byte;
begin
  port_hi:=(portnum shr 8) and $FF;
  port_lo:=(portnum and $FF);

  if (port_lo and 1)=0 then border:=val and 7;(* ULA (border/48K sound) *)

  if (not(odd(portnum))) then
   Begin
    tune48k(val);exit;
   End;

    if port_lo=253 {0xfd} then
      case port_hi shr 6 of
      0,1: if (last_7ffd=val) or (Last_7FFD and $20=0) then
           begin
            CONTENDED[6]:=val and 4;CONTENDED[7]:=CONTENDED[6];

            { Screenrefresh }
             if (val and 8>0) then SP_SCREEN:=RAM[7] else SP_SCREEN:=RAM[5];

            last_7ffd:=val;

            SRAM[3]:=RAM[val and 7];
            if sram[0]<>rom[4] then SRAM[0]:=ROM[(val and 16) shr 4];
           end;
        2: sound.PSGOut(last_fffd,val);
        3: last_fffd:=val and 15;
     end;
end;


{$f-}

procedure SpecPlus2Init(romname:String);
var i:byte;
begin
        max_v_Line:=311;
        t_states_per_line:=228;{311; {???}

	Machine_reset:= specPlus2Reset;
	Machine_nmi:= specPlus2Nmi;
	Machine_hooktrd:= specPlus2HookTrd;
        Machine_InitPages:=specPlus2InitPages;;

	speekb:= specPlus2ReadMem;
	spokeb:= specPlus2WriteMem;
	inPort:= specPlus2InPort;
	outPort:= specPlus2OutPort;
        open_rom_Plus2(romname);

       {specPlus2reset;}
        ROM[1]^[1386]:=237;
        ROM[1]^[1387]:=255;
end;

begin
 initnew(version);
end.
