unit plus3;

interface

procedure specplus3init(romname:String);

implementation

uses core,vars,machine,z80CPU,sndDrv,mf3;

const version:string = '$Id: plus3.pas,v 1.0';
      last_fe:byte=0;

procedure open_rom_plus3(romname:String);
var f: file;
    numread:longint;
begin
 assign(f,romname);reset(f,1);
 blockread(f,ROM[0]^,16384,numread);
 blockread(f,ROM[1]^,16384,numread);
 blockread(f,ROM[2]^,16384,numread);
 blockread(f,ROM[3]^,16384,numread);
 close(f);

end;
{$f+}
function specplus3ReadMem(Addr:Word):Byte;
begin
 specplus3ReadMem:=SRAM[(addr and $C000) shr 14]^[addr and $3FFF]
end;

procedure specplus3WriteMem(addr:word;val:Byte);
var segm:Word;
begin
 segm:=(addr and $C000) shr 14;
 if (SEGM>0) or (SRAM[Segm]=ROM[5]) then SRAM[segm]^[addr and $3FFF]:=val;
 if (CONTENDED[segm]>0) and
    (t_state shr 7=0) and (vline and 192>0) then inc(t_state,4);
end;

procedure specplus3Nmi;
begin
	Z80_NMI;
        inPort(0,63);
end;

procedure specplus3HookTrd;
begin
end;

procedure specplus3InitPages;
begin
        SRAM[0]:=ROM[0];
	SRAM[1]:=RAM[5];
	SRAM[2]:=RAM[2];
	SRAM[3]:=RAM[0];
        SP_SCREEN:=RAM[5];

        CONTENDED[0]:=0;CONTENDED[1]:=0;
        CONTENDED[2]:=1;CONTENDED[3]:=1;
        CONTENDED[4]:=0;CONTENDED[5]:=0;
        CONTENDED[6]:=0;CONTENDED[7]:=0;

end;

procedure specplus3Reset;
begin
	Z80_Reset;
        Specplus3InitPages;
end;

function specplus3InPort(port_hi, port_lo:Byte):Byte;
var i,data: byte;
begin
        case port_lo of
                  31: specplus3InPort:=StickValue; (* Kempston *)
                  63,191:  specPlus3InPort:=inmf3(port_hi,port_lo);
                 253: (* Ay-3-8912 *) specplus3InPort:=PSG[last_fffd];
                 254: (* Keys *)
                    begin
                        data:=255;
                        if port_hi and 128=0 then
                                data:=data and SKey[7];
                        if port_hi and 64=0 then
                                data:=data and SKey[6];
                        if port_hi and 32=0 then
                                data:=data and SKey[5];
                        if port_hi and 16=0 then
                                data:=data and SKey[4];
                        if port_hi and 8=0 then
                                data:=data and SKey[3];
                        if port_hi and 4=0 then
                                data:=data and SKey[2];
                        if port_hi and 2=0 then
                                data:=data and SKey[1];
                        if port_hi and 1=0 then
                                data:=data and SKey[0];
                        {if (VOC_file_open) and (VOC_paused=false) then
                            data:=data xor return_next_bit;}
                        specplus3InPort:=data;
                       end;
                else specplus3InPort:=255; (* Temporary *)
        end;
end;

procedure plus3OutBankm128(val:Byte);
begin
	if (Last_7FFD = val) or (Last_7FFD and $20>0) then exit;
        if (val and 8>0) then SP_SCREEN:=RAM[7] else SP_SCREEN:=RAM[5];

	Last_7FFD:= val;
	if (Last_1FFD and 1=0) then
	begin
		SRAM[1]:=RAM[5];
		SRAM[2]:=RAM[2];
		SRAM[3]:=RAM[val and 7];
                if SRAM[0]<>ROM[5] {MF3} then SRAM[0]:=ROM[(((val and 16) shr 4) or ((Last_1FFD and 4) shr 1))];
	end;
end;

procedure plus3OutBank678(val:byte);
begin
	if (Last_1FFD = val) or (Last_7FFD and $20>0) then exit;
        CONTENDED[6]:=val and 4;CONTENDED[7]:=CONTENDED[6];
	if (Last_1FFD and 1=0) then
	begin
         if SRAM[0]<>ROM[5] then
			SRAM[0]:=ROM[(((Last_7FFD and 16) shr 4) or
							 ((val and 4) shr 1))];
	end
	else
	begin
		case (val and 6) shr 1 of
                 0: begin
		     SRAM[0]:=RAM[0];
		     SRAM[1]:=RAM[1];
		     SRAM[2]:=RAM[2];
		     SRAM[3]:=RAM[3];
                    end;
		 1: begin
		     SRAM[0]:=RAM[4];
		     SRAM[1]:=RAM[5];
		     SRAM[2]:=RAM[6];
		     SRAM[3]:=RAM[7];
                    end;
     	         2: begin
		     SRAM[0]:=RAM[4];
		     SRAM[1]:=RAM[5];
		     SRAM[2]:=RAM[6];
		     SRAM[3]:=RAM[3];
                    end;
		 3: begin
		     SRAM[0]:=RAM[4];
		     SRAM[1]:=RAM[7];
		     SRAM[2]:=RAM[6];
		     SRAM[3]:=RAM[3];
                    end;
              end;
	end;
	Last_1FFD:= val;
end;

procedure SpecPlus3OutPort(portnum:word;val:Byte);
var btemp,port_hi,port_lo:Byte;
begin
  port_hi:=(portnum shr 8) and $FF;
  port_lo:=(portnum and $FF);

  if (port_lo and 1)=0 then border:=val and 7;(* ULA (border/48K sound) *)

  if (not(odd(portnum))) then
   Begin
    tune48k(val);exit;
   End;

    if port_lo=253 {0xfd} then
      case port_hi shr 6 of
       0: plus3OutBank678(val);
       1: plus3OutBankm128(val);
       2: sound.PSGOut(last_fffd,val);
       3: last_fffd:=val and 15;
     end;
end;
procedure _Specplus3OutPort(portnum:word;val:Byte);
begin
	if (portnum and 1) = ($FE and 1) then
	begin
	 if ((val xor Last_FE) and 7)>0 then border:=val and 7;
	 tune48k(val);
	 Last_FE:= val;
	end;

	if (portnum and 2) = ($FD and 2) then
	begin
		case portnum and $c000 of
		 $fffd and $c000: Last_FFFD:= val;
		 $bffd and $c000: sound.PSGOut(last_fffd,val);
		 $7ffd and $c000: plus3OutBankm128(val);
		 else
		  case portnum and $3000 of
		   $1ffd and $3000: plus3OutBank678(val);
		   $2ffd and $3000: {FDC_Controller};
		   $3ffd and $3000: {FdcDataOutByte(val);}
		  end;
		end;
	end;
end;

{$f-}

procedure Specplus3Init(romname:String);
var i:byte;
begin
        max_v_Line:=311;
        t_states_per_line:=228;{311; {???}

	Machine_reset:= specplus3Reset;
	Machine_nmi:= specplus3Nmi;
	Machine_hooktrd:= specplus3HookTrd;
        Machine_InitPages:=specplus3InitPages;;

	speekb:= specplus3ReadMem;
	spokeb:= specplus3WriteMem;
	inPort:= specplus3InPort;
	outPort:= specplus3OutPort;
        open_rom_plus3(romname);

        {specplus3reset;}
        ROM[1]^[1386]:=237;
        ROM[1]^[1387]:=255;
end;

begin
 initnew(version);
end.
