{$g+}
unit snddrv;

interface

 type sound_drv=record
       PSGOut:procedure(r,v:Byte);
       MUTESound:Procedure;
       init: function:Boolean;
       done: procedure;
      end;

 var sound:Sound_Drv;
     NoSoundDRV: Sound_Drv;
     Tune48k: Procedure(val:Byte);

     position:array[0..2] of byte; {not used yet}
     SBAdr:Word;

 const
  SMode:Byte=1;
  SMode48k:Byte=1;
  white_noise:boolean=false;   {AY 8910}
  Soundblaster:Boolean=true;   {Needed in IOPORTS.INC}

procedure SpeakerTune(val:Byte);
procedure BlasterTune(val:Byte);
procedure SilenceTune(val:Byte);

const oldval:Byte=0;

implementation
uses dos,core,vars;

{Soundblaster detecting routine..............................................}

procedure writesb(addr,Val:byte);
begin
 while port[SBADR+$C] and 128>0 do;
 port[SBADR+$C]:=addr;
 while port[SBADR+$C] and 128>0 do;
 port[SBADR+$C]:=val;
end;

procedure SilenceTune(val:Byte);
begin
end;

function calcsound(val:Byte;gain:boolean):Byte;
begin
 oldval:=(val and 24) shl 3;
 if gain then dec(oldval,96);
 result:=oldval;
end;

function calcsounda(val:Byte;gain:boolean):Byte;assembler;
asm
 mov     ah,val
 mov     al,oldval
 ror     ah,03h
 and     ax,002FDh
 or      al,ah
 cmp     gain,false
 jz      @ende
 shl     al,1
 @ende:
 mov     oldval,al
end;

procedure SpeakerTune(val:Byte);
begin
{ if not hi then port[$61]:=port[$61] and $fc else port[$61]:=(port[$61] and $fc) or 2;}
{ asm in al,$61;and al,not 2;out $61,al end else asm in al,$61;or al,2;out $61,al end;}
port[$61]:=calcsound(val,false);
end;

procedure BlasterTune(val:Byte);
begin
 {if not hi then writesb($10,96) else writesb($10,159);}
 {if hi then writesb($10,$FF) else writesb($10,$bf);}
 writesb($10,calcsound(val,true));
end;

function Is_Blaster(Var sbport:Word):Boolean;
Var xbyte1, xbyte2, xbyte3, xbyte4: Byte;
    searcha:Word;
    dummy: integer;
    sbfound, portok: Boolean;
    s:String;
Begin
  sbfound:=False;
  s:=getenv('BLASTER');
  for dummy:=1 to length(s) do s[dummy]:=upcase(s[dummy]);

  if s<>'' then
   begin
    val('$'+copy(s,pos('A',s)+1,3),sbport,dummy);
    if dummy=0 then
     begin
      if (Port[sbport + $0C] And $80) = 0 then
      begin
       is_blaster:=true;
       exit;
      end;
     end;
    {Is there a correct Blaster-Variable then exit else search manually...}
   end;
  xbyte1:=1;
  While (xbyte1 < 7) And (Not sbfound) Do
  Begin
    sbport:=$200 + ($10 * xbyte1);
    searcha:=0;
    portok:=False;
    While (searcha < $201) And (Not portok) Do
    Begin
      If (Port[sbport + $0C] And $80) = 0 Then portok:=True;
      Inc(searcha)
    End;

    If portok Then
    Begin
      xbyte3:=Port[sbport + $0C];
      Port[sbport + $0C]:=$D3;
      For dummy:=1 To $1000 Do;
      xbyte4:=Port[sbport + 6];
      Port[sbport + 6]:=1;
      xbyte2:=Port[sbport + 6];
      xbyte2:=Port[sbport + 6];
      xbyte2:=Port[sbport + 6];
      xbyte2:=Port[sbport + 6];
      Port[sbport + 6]:=0;
      xbyte2:=0;
      Repeat
        searcha:=0;
        portok:=False;
        While (searcha < $201) And (Not portok) Do
        Begin
          If (Port[sbport + $0E] And $80) = $80 Then
            portok:=True;
          Inc(searcha)
        End;
        If portok Then
          If Port[sbport + $0A] = $AA Then
            sbfound:=True;
        Inc(xbyte2);
      Until (xbyte2 = $10) Or (portok);
      If Not portok Then
      Begin
        Port[sbport + $0C]:=xbyte3;
        Port[sbport + 6]:=xbyte4;
      End;
    End;
    If not sbfound Then Inc(xbyte1);
  End;
  is_blaster:=sbfound;
End;

{$f+}
procedure PSGOut(r,v:Byte);
begin
 psg[r]:=v;
end;

function Init:Boolean;
begin
 init:=True;
end;

procedure mutesound;
begin
end;

procedure done;
begin
end;
{$f-}

begin
 initnew('Sound Driver');
  soundblaster:=is_blaster(sbadr);
  if soundblaster then displaynew('Soundblaster found at '+word2hex(sbadr)+'h') else
  displaynew('no Soundblaster found');

 nosoundDRV.mutesound:=Mutesound;
 nosoundDRV.psgout:=psgout;
 nosoundDRV.init:=init;
 nosoundDRV.done:=done;
 sound:=NoSoundDRV;
 tune48k:=speakerTune;
end.
