unit trdos;

interface

type DatVG=record
        RegStatus,
        RegCom:Byte;
        RegTrack:Shortint;
        RegSect,
        RegData,
        System:Byte;
        StepDirect:Shortint;
        TrackReal:array[0..3] of byte;
        reserved:array[0..2] of byte;
      end;

var VG:DatVG;

const Disks:array[0..3] of string=('','','','');

procedure DiskVG(OperIO:Byte;Var DataIO:Byte);

implementation uses core,dos;

const
      FormatDatLen             = 1;
      Ready          : Boolean = True;
      ReadIndexTrack : Boolean = False;
      DskStatus      : Byte    = 00;

      DskIndex       : array[0..4] of byte = (0,1,1,0,0);


var DiskBuf                         : array[0..$FF] of byte;
    DskFileName                     : String;
    Str                             : File;

    DskIndexCounter,DskCountDatLost : Byte;
    CntData,DskDataSize             : Integer;
    CntReady                        : Word;

function getfa(S:String):integer;
var f:file;
    attr:word;
begin
 assign(f,s);
 getfattr(f,attr);
 if doserror>0 then result:=-1 else result:=attr;
end;

function DiskPosition(Sect:Word):Longint;
begin
 DiskPosition:=((VG.RegTrack shl 5) or (VG.System and $10 xor $10) or Sect) shl $08;
end;

procedure SetStateStep;
begin
        if VG.RegTrack<0 then
              begin
                VG.TrackReal[VG.System and $03]:=0;
                VG.RegTrack:=0;
              end;
        if VG.RegTrack>$4F then
              begin
                VG.TrackReal[VG.System and $03]:=$4F;
                VG.RegTrack:=$4F;
              end;

        VG.RegStatus:=DskStatus and $40;
        if VG.RegCom and $08>0 then VG.RegStatus:=VG.RegStatus or $20;
        if VG.RegTrack=0 then VG.RegStatus:=VG.RegStatus or $04;
end;
procedure OpCom;
begin
 DskCountDatLost:=$00;
 CntData:=$0000;
 VG.RegStatus:=$03;
 if not Ready then
  begin
   VG.RegStatus:=$01;
   CntReady:=$10;
  end;
end;

procedure StepRear;
begin
 if VG.RegTrack>0 then
  begin
   dec(VG.RegTrack);
   VG.TrackReal[VG.System and $03]:=VG.RegTrack;
  end;
  VG.StepDirect:=-1;
  SetStateStep;
end;

procedure OpReadSector;
var numread:integer;
	Position:longint;
begin
 if (VG.RegSect>$10) or (VG.RegTrack<>VG.TrackReal[VG.System and $03]) or
    (DskStatus and $04=0) then
  begin
   VG.RegStatus:=$10; {OpNotFound}
   exit;
  end;

 Position:=DiskPosition(VG.RegSect-1);

 seek(Str,Position);
 blockread(Str,diskbuf,sizeof(diskbuf),numread);

 if Position=2048 then diskbuf[227]:=16; {BUG !!! at pos $8e3 must be $10 ??}

 if numread<>sizeof(diskbuf) then VG.RegStatus:=$08 {OpContSum}
  else
   begin
    DskDataSize:=$FF;
    VG.RegData:=DiskBuf[0];
    OpCom;
   end;
end;

procedure OpWriteSector;
begin
 if DskStatus and $40>0 then
  begin
   VG.RegStatus:=$40; {OpWrProt}
   exit;
  end;
 if (VG.RegSect>$10) or (VG.RegTrack<>VG.TrackReal[VG.System and $03]) or
    (DskStatus and $04=0) then VG.RegStatus:=$10 {OpNotFound}
   else
   begin
    DskDataSize:=$0100;
    OpCom;
   end;
end;

procedure DiskVG(OperIO:Byte;Var DataIO:Byte);

var numread,numwritten,
    i,attr:integer;
    IntrqDrq:Word;
    Intrq,Drq:Byte;
begin
        if VG.RegStatus and $01>0 then
         begin
          dec(DskCountDatLost);
          if dskcountdatlost=0 then VG.RegStatus:=$04;
         end;
        if CntReady>0 then
         begin dec(CntReady);if (CntReady=0) then VG.RegStatus:=$03; end;

        case OperIO of
         $0: begin
                DataIO:=VG.RegStatus;
                if VG.RegCom and $80>0 then exit;
                dec(DskIndexCounter);
                if DskIndexCounter and $E>0 then DataIO:=DataIO or $02;
              end;
         $1: begin
                if VG.RegStatus and $01=0 then
                begin
                        if (DataIO and $F0)=$D0 then exit;
                        VG.RegCom:=DataIO;
                        case VG.RegCom shr 4 of
                         $0: begin
                                VG.TrackReal[VG.System and $03]:=0;
                                VG.RegTrack:=0;
                                VG.StepDirect:=-1;
                                SetStateStep;
                              end;
                         $1: begin
                                VG.TrackReal[VG.System and $03]:=VG.RegData;
                                VG.RegTrack:=VG.RegData;
                                if VG.RegData-VG.RegTrack<0 then VG.StepDirect:=-1;
                                if VG.RegData-VG.RegTrack>0 then VG.StepDirect:=1;
                                SetStateStep;
                             end;
                          $2,
                          $3,
                          $4,
                          $5:begin
                              if ( (VG.RegCom shr 4) in [2,3]) and (VG.StepDirect=-1) then
                               begin StepRear;exit;end;
                                if VG.RegTrack>0 then
                                 begin
                                  inc(VG.RegTrack);
                                  VG.TrackReal[VG.System and $03]:=VG.RegTrack;
                                 end;
                                VG.StepDirect:=1;
                                SetStateStep;
                              end;
                         $6,
                         $7: StepRear;
                         $8,
                         $9: OpReadSector;
                         $A,
                         $B: OpWriteSector;
                         $C: begin
                                DskDataSize:=$0005;
                                VG.RegData:=1;
                                if ReadIndexTrack then VG.RegData:=VG.RegTrack;
                                OpCom;
                             end;
                         $E:;
                         $F: begin
                                if DskStatus and $40>0 then
                                  VG.RegStatus:=$40 {OpWrProt}
                                else
                                begin
                                 DskDataSize:=FormatDatLen;
                                 OpCom;
                                end;
                             end;
                        end;
                end;
               end;
         $2: DataIO:=VG.RegTrack;
         $3: if VG.RegStatus and $01=0 then VG.RegTrack:=DataIO;
         $4: DataIO:=VG.RegSect;
         $5: if VG.RegStatus and $01=0 then VG.RegSect:=DataIO;
         $6: begin
                if VG.RegStatus and $01>0 then
                 begin
                        case VG.RegCom shr 4 of
                         $8,
                         $9: begin
                                DataIO:=VG.RegData;
                                DskCountDatLost:=$10;
                                if CntData<DskDataSize then
                                 begin
                                  inc(cntData);
                                  VG.RegData:=DiskBuf[CntData];
                                 end
                                else begin
                                        if VG.RegCom and $10>0 then
                                         begin
                                                inc(VG.RegSect);
                                                OpReadSector;
                                         end else VG.RegStatus:=$00; {OpOk}
                                end
                              end;
                          $C: begin
                                DataIO:=VG.RegData;
                                DskCountDatLost:=$10;
                                if CntData<DskDataSize then
                                 begin
                                  VG.RegData:=DskIndex[CntData];
                                  inc(CntData);
                                 end
                                else VG.RegStatus:=$00; {OpOk}
                               end;
                        end
                end else DataIO:=VG.RegData;
                end;
         $7: begin
                if (VG.RegStatus and $01>0) then
                 begin
                        case VG.RegCom shr 4 of
                         $A,
                         $B: begin
                                DiskBuf[CntData]:=DataIO;
                                VG.RegData:=DataIO;inc(CntData);
                                DskCountDatLost:=$10;
                                if CntData>=DskDataSize then
                                 begin
                                        seek(Str,DiskPosition(VG.RegSect-1));
                                        blockwrite(Str,Diskbuf,sizeof(Diskbuf),numwritten);
                                        if numwritten<>sizeof(DiskBuf) then
                                         begin
                                          VG.RegStatus:=$08; {OpContSum}
                                          exit;
                                         end;
                                        if (VG.RegCom and $10>0) then
                                         begin
                                                inc(VG.RegSect);
                                                OpWriteSector;
                                        end else VG.RegStatus:=$00; {OpOk}
                                end
                              end;
                          $F: begin
                                VG.RegData:=DataIO;
                                DskCountDatLost:=$10;
                                inc(cntData);
                                if CntData>=DskDataSize then
                                begin
                                        fillchar(DiskBuf,sizeof (DiskBuf),0);
                                        if DskStatus and $04>0 then
                                        begin
                                                seek(Str,DiskPosition(0));
                                                for i:=0 to $10-1  do blockwrite(Str,DiskBuf,sizeof(Diskbuf));
                                        end else
                                        begin
                                         {$i+} assign(str,DskFileName);rewrite(str,1);{$i+}
                                         if ioresult<>0 then begin VG.RegStatus:=$00; {OpOk}exit;end;
                                         for i:=0 to $A00-1 do blockwrite(Str,DiskBuf,sizeof(Diskbuf));
                                         DskStatus:=DskStatus or $4;
                                        end;
                                        VG.RegStatus:=$00; {OpOk}
                                end;
                           end;
                       end
                end else
                        VG.RegData:=DataIO;
          end;
        $8: begin
                {if VG.RegStatus and 32>0 then DRQ:=$40 else DRQ:=0;
                if VG.Regstatus and 64>0 then Intrq:=$80 else Intrq:=0;
                Dataio:=DRQ or intrq;}
                IntrqDrq:=$BF;
                if VG.RegStatus and $01>0 then IntrqDrq:=$3F;
                if VG.RegStatus and $02>0 then IntrqDrq:=$7F;
                DataIO:=IntrqDrq;
             end;
         $9: begin
                if (VG.RegStatus and $01>0) and (VG.RegCom and $80>0) then
                 begin
                  VG.RegStatus:=$08; {OpContSum}
                  exit;
                 end;
                VG.System:=DataIO;
                if (VG.System xor DskStatus) and $03>0 then
                 begin
                        DiskVG($B,DataIO);
                        DiskVG($A,DataIO);
                 end;
               end;
          $A: begin
                if DskStatus and $80>0 then exit;
                DskStatus:=VG.System and $03;
                DskFileName:=Disks[DskStatus];
                Attr:=GetFA(DskFileName);
                if Attr<>-1 then
                begin
                        Attr:=Attr and $01;
                        DskStatus:=DskStatus or (Attr shl 6);
                        {$i+}assign(str,DskFilename);reset(str,1);{$i+}
                        if ioresult=0 then DskStatus:=DskStatus or $04;
                end;
                DskStatus:=DskStatus or $80;
               end;
         $B: begin
                if DskStatus and $80=0 then exit;
                if DskStatus and $04>0 then close(Str);
                DskStatus:=$00;
              end;
         $C: begin
                VG.RegStatus:=$24;
                VG.RegCom:=$00;
                VG.RegTrack:=$00;
                VG.RegSect:=$01;
                VG.RegData:=$00;
                VG.System:=$3C;
                VG.StepDirect:=shortint($FF);
                if (DskStatus and $80>0) and (DskStatus and $03>0) then
                 begin
                        DiskVG($B,DataIO);
                        DiskVG($A,DataIO);
                 end;
            end;
        end;
end;

begin
 initnew('TRDOS');
end.
