var z80,Z80_IX,Z80_IY:Array[0..255] of procedure; {Jump-Table}

procedure nop;
Begin
inc(t_state,4);
end;

procedure ld_bc_XXXX;
Begin
bc.W:=wordpeek(pc.W);
inc(pc.W,2);
inc(t_state,10);
end;

procedure ld_mbc_a;
Begin
spokeb(bc.W,af.h);
inc(t_state,7);
end;

procedure inc_bc;
Begin
inc(bc.w);
inc(t_state,6);
end;

procedure inc_b;
Begin
af.l:=inc_f[bc.h] or (af.l and 1); 
inc(bc.h);
inc(t_state,4);
end;

procedure dec_b;
Begin
af.l:=dec_f[bc.h] or (af.l and 1); 
dec(bc.h);
inc(t_state,4);
end;

procedure ld_b_XX;
Begin
bc.h:=speekb(pc.W);
inc(pc.W);
inc(t_state,7);
end;

procedure rlca;
var btemp: Byte;
Begin
btemp:=af.l and 1;
af.l:=rlca_f[btemp][af.h] or (af.l and 196); 
af.h:=rlca_a[btemp][af.h];
inc(t_state,4);
end;

procedure ex_af_af;
var temp: word;
Begin
temp:=af.W;
af.W:=af2.W;
af2.W:=temp;
inc(t_state,4);
end;

procedure add_ix_bc;
Begin
add16(ix.W,bc.W);
inc(t_state,11);
end;

procedure add_iy_bc;
Begin
add16(iy.W,bc.W);
inc(t_state,11);
end;

procedure add_hl_bc;
Begin
add16(hl.W,bc.W);
inc(t_state,11);
end;

procedure ld_a_mbc;
Begin
af.h:=speekb(bc.W);
inc(t_state,7);
end;

procedure dec_bc;
Begin
dec(bc.W);
inc(t_state,6);
end;

procedure inc_c;
Begin
af.l:=inc_f[bc.l] or (af.l and 1); 
inc(bc.l);
inc(t_state,4);
end;

procedure dec_c;
Begin
af.l:=dec_f[bc.l] or (af.l and 1); 
dec(bc.l);
inc(t_state,4);
end;

procedure ld_c_XX;
Begin
bc.l:=speekb(pc.W);
inc(pc.W);
inc(t_state,7);
end;

procedure rrca;
var btemp: Byte;
Begin
btemp:=af.l and 1;
af.l:=rrca_f[btemp][af.h] or (af.l and 196); 
af.h:=rrca_a[btemp][af.h];
inc(t_state,4);
end;

procedure djnz_DIS;
Begin
dec(bc.h);
if bc.h>0 then
Begin
pc.W:=pc.w + shortint(speekb(pc.W))+1;
inc(t_state,13);
end
else
Begin
inc(pc.W);
inc(t_state,8);
end
end;

procedure ld_de_XXXX;
Begin
de.W:=wordpeek(pc.W);
inc(pc.W,2);
inc(t_state,10);
end;

procedure ld_mde_a;
Begin
spokeb(de.W,af.h);
inc(t_state,7);
end;

procedure inc_de;
Begin
inc(de.W);
inc(t_state,6);
end;

procedure inc_d;
Begin
af.l:=inc_f[de.h] or (af.l and 1); 
inc(de.h);
inc(t_state,4);
end;

procedure dec_d;
Begin
af.l:=dec_f[de.h] or (af.l and 1); 
dec(de.h);
inc(t_state,4);
end;

procedure ld_d_XX;
Begin
de.h:=speekb(pc.W);
inc(pc.W);
inc(t_state,7);
end;

procedure rla;
var btemp: Byte;
Begin
btemp:=af.l and 1;
af.l:=rla_f[btemp][af.h] or (af.l and 196); 
af.h:=rla_a[btemp][af.h];
inc(t_state,4);
end;

procedure jr_DIS;
Begin
pc.W:=pc.w + shortint(speekb(pc.W))+1;
inc(t_state,12);
end;

procedure add_ix_de;
Begin
add16(ix.W,de.W);
inc(t_state,11);
end;

procedure add_iy_de;
Begin
add16(iy.W,de.W);
inc(t_state,11);
end;

procedure add_hl_de;
Begin
add16(hl.W,de.W);
inc(t_state,11);
end;

procedure ld_a_mde;
Begin
af.h:=speekb(de.W);
inc(t_state,7);
end;

procedure dec_de;
Begin
dec(de.W);
inc(t_state,6);
end;

procedure inc_e;
Begin
af.l:=inc_f[de.l] or (af.l and 1); 
inc(de.l);
inc(t_state,4);
end;

procedure dec_e;
Begin
af.l:=dec_f[de.l] or (af.l and 1); 
dec(de.l);
inc(t_state,4);
end;

procedure ld_e_XX;
Begin
de.l:=speekb(pc.W);
inc(pc.W);
inc(t_state,7);
end;

procedure rra;
Begin
 if af.l and 1=0 then
 begin
 af.l:=rra_f[af.h] or (af.l and 196); 
 af.h:=rra_a[0][af.h];
 end
 else
 begin
  af.l:=rra_f[af.h] or (af.l and 196);
  af.h:=rra_a[1][af.h];
 end;
 inc(t_state,4);
end;

procedure jr_nz_DIS;
Begin
if af.l and 64=0 then
Begin
 pc.W:=pc.w + shortint(speekb(pc.W))+1;
 inc(t_state,12);
end
else
Begin
 inc(pc.W);
 inc(t_state,7);
end
end;

procedure ld_ix_XXXX;
Begin
ix.W:=wordpeek(pc.W);
inc(pc.W,2);
inc(t_state,10);
end;

procedure ld_iy_XXXX;
Begin
iy.W:=wordpeek(pc.W);
inc(pc.W,2);
inc(t_state,10);
end;

procedure ld_hl_XXXX;
Begin
hl.W:=wordpeek(pc.W);
inc(pc.W,2);
inc(t_state,10);
end;

procedure Z80ld_aXXXX_ix;
Begin
wordpoke(wordpeek(pc.W),ix.W);
inc(pc.W,2);
inc(t_state,16);
end;

procedure Z80ld_aXXXX_iy;
Begin
wordpoke(wordpeek(pc.W),iy.W);
inc(pc.W,2);
inc(t_state,16);
end;

procedure Z80ld_aXXXX_hl;
Begin
wordpoke(wordpeek(pc.W),hl.W);
inc(pc.W,2);
inc(t_state,16);
end;

procedure inc_ix;
Begin
inc(ix.W);
inc(t_state,6);
end;

procedure inc_iy;
Begin
        inc(iy.W);
inc(t_state,6);
end;

procedure inc_hl;
Begin
inc(hl.W);
inc(t_state,6);
end;

procedure inc_ixh;
Begin
af.l:=inc_f[ix.h] or (af.l and 1); 
inc(ix.h);
inc(t_state,4);
end;

procedure inc_iyh;
Begin
af.l:=inc_f[iy.h] or (af.l and 1); 
inc(iy.h);
inc(t_state,4);
end;

procedure inc_h;
Begin
af.l:=inc_f[hl.h] or (af.l and 1); 
inc(hl.h);
inc(t_state,4);
end;

procedure dec_ixh;
Begin
af.l:=dec_f[ix.h] or (af.l and 1); 
dec(ix.h);
inc(t_state,4);
end;

procedure dec_iyh;
Begin
af.l:=dec_f[iy.h] or (af.l and 1); 
dec(iy.h);
inc(t_state,4);
end;

procedure dec_h;
Begin
af.l:=dec_f[hl.h] or (af.l and 1); 
dec(hl.h);
inc(t_state,4);
end;

procedure ld_ixh_XX;
Begin
ix.h:=speekb(pc.W);
inc(pc.W);
inc(t_state,7);
end;

procedure ld_iyh_XX;
Begin
iy.h:=speekb(pc.W);
inc(pc.W);
inc(t_state,7);
end;

procedure ld_h_XX;
Begin
hl.h:=speekb(pc.W);
inc(pc.W);
inc(t_state,7);
end;

procedure daa;
var daa_select: Byte;
Begin
daa_select:=af.l and 19; 
if daa_select and 16>0 then 
Begin
af.l:=daa_f[daa_select-12][af.h];
af.h:=daa_a[daa_select-12][af.h];
end
else 
Begin
af.l:=daa_f[daa_select][af.h];
af.h:=daa_a[daa_select][af.h];
end;
inc(t_state,4);
end;

procedure jr_z_DIS;
Begin
if af.l and 64>0 then
Begin
pc.W:=pc.w + shortint(speekb(pc.W))+1;
inc(t_state,12);
end
else
Begin
inc(pc.W);
inc(t_state,7);
end
end;

procedure add_ix_ix;
Begin
add16(ix.W,ix.W);
inc(t_state,11);
end;

procedure add_iy_iy;
Begin
add16(iy.W,iy.W);
inc(t_state,11);
end;

procedure add_hl_hl;
Begin
add16(hl.W,hl.W);
inc(t_state,11);
end;

procedure Z80ld_ix_aXXXX;
Begin
ix.W:=wordpeek(wordpeek(pc.W));
inc(pc.W,2);
inc(t_state,16);
end;

procedure Z80ld_iy_aXXXX;
Begin
iy.W:=wordpeek(wordpeek(pc.W));
inc(pc.W,2);
inc(t_state,16);
end;

procedure Z80ld_hl_aXXXX;
Begin
hl.W:=wordpeek(wordpeek(pc.W));
inc(pc.W,2);
inc(t_state,16);
end;

procedure dec_ix;
Begin
dec(ix.W);
inc(t_state,6);
end;

procedure dec_iy;
Begin
dec(iy.W);
inc(t_state,6);
end;

procedure dec_hl;
Begin
dec(hl.W);
inc(t_state,6);
end;

procedure inc_ixl;
Begin
af.l:=inc_f[ix.l] or (af.l and 1); 
inc(ix.l);
inc(t_state,4);
end;

procedure inc_iyl;
Begin
af.l:=inc_f[iy.l] or (af.l and 1); 
inc(iy.l);
inc(t_state,4);
end;

procedure inc_l;
Begin
af.l:=inc_f[hl.l] or (af.l and 1); 
inc(hl.l);
inc(t_state,4);
end;

procedure dec_ixl;
Begin
af.l:=dec_f[ix.l] or (af.l and 1); 
dec(ix.l);
inc(t_state,4);
end;

procedure dec_iyl;
Begin
af.l:=dec_f[iy.l] or (af.l and 1); 
dec(iy.l);
inc(t_state,4);
end;

procedure dec_l;
Begin
af.l:=dec_f[hl.l] or (af.l and 1); 
dec(hl.l);
inc(t_state,4);
end;

procedure ld_ixl_XX;
Begin
ix.l:=speekb(pc.W);
inc(pc.W);
inc(t_state,7);
end;

procedure ld_iyl_XX;
Begin
iy.l:=speekb(pc.W);
inc(pc.W);
inc(t_state,7);
end;

procedure ld_l_XX;
Begin
hl.l:=speekb(pc.W);
inc(pc.W);
inc(t_state,7);
end;

procedure cpl;
Begin
af.h:=af.h xor 255;
af.l:=af.l or 18; 
copy_b53(af.h);
inc(t_state,4);
end;

procedure jr_nc_DIS;
Begin
if af.l and 1=0 then
Begin
 pc.W:=pc.w + shortint(speekb(pc.W))+1;
 inc(t_state,12);
end
else
Begin
 inc(pc.W);
 inc(t_state,7);
end
end;

procedure ld_sp_XXXX;
Begin
sp.W:=wordpeek(pc.W);
inc(pc.W,2);
inc(t_state,10);
end;

procedure ld_aXXXX_a;
Begin
spokeb(wordpeek(pc.W),af.h);
inc(pc.W,2);
inc(t_state,13);
end;

procedure inc_sp;
Begin
inc(sp.W);
inc(t_state,6);
end;

procedure inc_mix;
var btemp: Byte;
    dis:Shortint;
Begin
dis:=speekb(pc.W);
inc(pc.W);
btemp:=speekb(ix.W+dis);
af.l:=inc_f[btemp] or (af.l and 1); 
spokeb(ix.W+dis,btemp+1);
inc(t_state,19);
end;

procedure inc_miy;
var btemp: Byte;
    dis:shortint;
Begin

dis:=speekb(pc.W);
inc(pc.W);
btemp:=speekb(iy.W+dis);
af.l:=inc_f[btemp] or (af.l and 1); 
spokeb(iy.W+dis,btemp+1);
inc(t_state,19);
end;

procedure inc_mhl;
var btemp: Byte;
Begin
btemp:=speekb(hl.W);
af.l:=inc_f[btemp] or (af.l and 1); 
spokeb(hl.W,btemp+1);
inc(t_state,11);
end;

procedure dec_mix;
var btemp: Byte;
    dis: shortint;
Begin
dis:=speekb(pc.W);
inc(pc.W);
btemp:=speekb(ix.W+dis);
af.l:=dec_f[btemp] or (af.l and 1); 
spokeb(ix.W+dis,btemp-1);
inc(t_state,19);
end;

procedure dec_miy;
var btemp: Byte;
    dis: shortint;
Begin
dis:=speekb(pc.W);
inc(pc.W);
btemp:=speekb(iy.W+dis);
af.l:=dec_f[btemp] or (af.l and 1); 
spokeb(iy.W+dis,btemp-1);
inc(t_state,19);
end;

procedure dec_mhl;
var btemp: Byte;
Begin
btemp:=speekb(hl.W);
af.l:=dec_f[btemp] or (af.l and 1); 
spokeb(hl.W,btemp-1);
inc(t_state,11);
end;

procedure ld_mix_XX;
var dis: shortint;
Begin
dis:=speekb(pc.W);
inc(pc.W);
spokeb(ix.W+dis,speekb(pc.W));
inc(pc.W);
inc(t_state,15);
end;

procedure ld_miy_XX;
var dis: shortint;
Begin
dis:=speekb(pc.W);
inc(pc.W);
spokeb(iy.W+dis,speekb(pc.W));
inc(pc.W);
inc(t_state,15);
end;

procedure ld_mhl_XX;
Begin
spokeb(hl.W,speekb(pc.W));
inc(pc.W);
inc(t_state,10);
end;

procedure scf;
Begin
af.l:=af.l and 237; 
copy_b53(af.h);
af.l:=af.l Or 1;
inc(t_state,4);
end;

procedure jr_c_DIS;
Begin
if af.l and 1>0 then
Begin
pc.W:=pc.w + shortint(speekb(pc.W))+1;
inc(t_state,12);
end
else
Begin
inc(pc.W);
inc(t_state,7);
end
end;

procedure add_ix_sp;
Begin
add16(ix.W,sp.W);
inc(t_state,11);
end;

procedure add_iy_sp;
Begin
add16(iy.W,sp.W);
inc(t_state,11);
end;

procedure add_hl_sp;
Begin
add16(hl.W,sp.W);
inc(t_state,11);
end;

procedure ld_a_aXXXX;
Begin
af.h:=speekb(wordpeek(pc.W));
inc(pc.W,2);
inc(t_state,13);
end;

procedure dec_sp;
Begin
dec(sp.W);
inc(t_state,6);
end;

procedure Z80inc_a;
Begin
af.l:=inc_f[af.h] or (af.l and 1); 
inc(af.h);
inc(t_state,4);
end;

procedure Z80dec_a;
Begin
af.l:=dec_f[af.h] or (af.l and 1); 
dec(af.h);
inc(t_state,4);
end;

procedure ld_a_XX;
Begin
af.h:=speekb(pc.W);
inc(pc.W);
inc(t_state,7);
end;

procedure ccf;
Begin
af.l:=af.l xor 1;
af.l:=af.l And 253;
copy_b53(af.h);
inc(t_state,4);
end;

procedure ld_b_b;
Begin
bc.h:=bc.h;
inc(t_state,4);
end;

procedure ld_b_c;
Begin
bc.h:=bc.l;
inc(t_state,4);
end;

procedure ld_b_d;
Begin
bc.h:=de.h;
inc(t_state,4);
end;

procedure ld_b_e;
Begin
bc.h:=de.l;
inc(t_state,4);
end;

procedure ld_b_ixh;
Begin
bc.h:=ix.h;
inc(t_state,4);
end;

procedure ld_b_iyh;
Begin
bc.h:=iy.h;
inc(t_state,4);
end;

procedure ld_b_h;
Begin
bc.h:=hl.h;
inc(t_state,4);
end;

procedure ld_b_ixl;
Begin
bc.h:=ix.l;
inc(t_state,4);
end;

procedure ld_b_iyl;
Begin
bc.h:=iy.l;
inc(t_state,4);
end;

procedure ld_b_l;
Begin
bc.h:=hl.l;
inc(t_state,4);
end;

procedure ld_b_ix;
Begin
bc.h:=speekb(ix.W+ shortint(speekb(pc.W)));
inc(pc.W);
inc(t_state,15);
end;

procedure ld_b_iy;
Begin
bc.h:=speekb(iy.W+shortint(speekb(pc.W)));
inc(pc.W);
inc(t_state,15);
end;

procedure ld_b_hl;
Begin
bc.h:=speekb(hl.W);
inc(t_state,7);
end;

procedure ld_b_a;
Begin
bc.h:=af.h;
inc(t_state,4);
end;

procedure ld_c_b;
Begin
bc.l:=bc.h;
inc(t_state,4);
end;

procedure ld_c_c;
Begin
bc.l:=bc.l;
inc(t_state,4);
end;

procedure ld_c_d;
Begin
bc.l:=de.h;
inc(t_state,4);
end;

procedure ld_c_e;
Begin
bc.l:=de.l;
inc(t_state,4);
end;

procedure ld_c_ixh;
Begin
bc.l:=ix.h;
inc(t_state,4);
end;

procedure ld_c_iyh;
Begin
bc.l:=iy.h;
inc(t_state,4);
end;

procedure ld_c_h;
Begin
bc.l:=hl.h;
inc(t_state,4);
end;

procedure ld_c_ixl;
Begin
bc.l:=ix.l;
inc(t_state,4);
end;

procedure ld_c_iyl;
Begin
bc.l:=iy.l;
inc(t_state,4);
end;

procedure ld_c_l;
Begin
bc.l:=hl.l;
inc(t_state,4);
end;

procedure ld_c_ix;
Begin
bc.l:=speekb(ix.W+shortint(speekb(pc.W)));
inc(pc.W);
inc(t_state,15);
end;

procedure ld_c_iy;
Begin
bc.l:=speekb(iy.W+shortint(speekb(pc.W)));
inc(pc.W);
inc(t_state,15);
end;

procedure ld_c_hl;
Begin
bc.l:=speekb(hl.W);
inc(t_state,7);
end;

procedure ld_c_a;
Begin
bc.l:=af.h;
inc(t_state,4);
end;

procedure ld_d_b;
Begin
de.h:=bc.h;
inc(t_state,4);
end;

procedure ld_d_c;
Begin
de.h:=bc.l;
inc(t_state,4);
end;

procedure ld_d_d;
Begin
de.h:=de.h;
inc(t_state,4);
end;

procedure ld_d_e;
Begin
de.h:=de.l;
inc(t_state,4);
end;

procedure ld_d_ixh;
Begin
de.h:=ix.h;
inc(t_state,4);
end;

procedure ld_d_iyh;
Begin
de.h:=iy.h;
inc(t_state,4);
end;

procedure ld_d_h;
Begin
de.h:=hl.h;
inc(t_state,4);
end;

procedure ld_d_ixl;
Begin
de.h:=ix.l;
inc(t_state,4);
end;

procedure ld_d_iyl;
Begin
de.h:=iy.l;
inc(t_state,4);
end;

procedure ld_d_l;
Begin
de.h:=hl.l;
inc(t_state,4);
end;

procedure ld_d_ix;
Begin
de.h:=speekb(ix.W+shortint(speekb(pc.W)));
inc(pc.W);
inc(t_state,15);
end;

procedure ld_d_iy;
Begin
de.h:=speekb(iy.W+shortint(speekb(pc.W)));
inc(pc.W);
inc(t_state,15);
end;

procedure ld_d_hl;
Begin
de.h:=speekb(hl.W);
inc(t_state,7);
end;

procedure ld_d_a;
Begin
de.h:=af.h;
inc(t_state,4);
end;

procedure ld_e_b;
Begin
de.l:=bc.h;
inc(t_state,4);
end;

procedure ld_e_c;
Begin
de.l:=bc.l;
inc(t_state,4);
end;

procedure ld_e_d;
Begin
de.l:=de.h;
inc(t_state,4);
end;

procedure ld_e_e;
Begin
de.l:=de.l;
inc(t_state,4);
end;

procedure ld_e_ixh;
Begin
de.l:=ix.h;
inc(t_state,4);
end;

procedure ld_e_iyh;
Begin
de.l:=iy.h;
inc(t_state,4);
end;

procedure ld_e_h;
Begin
de.l:=hl.h;
inc(t_state,4);
end;

procedure ld_e_ixl;
Begin
de.l:=ix.l;
inc(t_state,4);
end;

procedure ld_e_iyl;
Begin
de.l:=iy.l;
inc(t_state,4);
end;

procedure ld_e_l;
Begin
de.l:=hl.l;
inc(t_state,4);
end;

procedure ld_e_ix;
Begin
de.l:=speekb(ix.W+shortint(speekb(pc.W)));
inc(pc.W);
inc(t_state,15);
end;

procedure ld_e_iy;
Begin
de.l:=speekb(iy.W+shortint(speekb(pc.W)));
inc(pc.W);
inc(t_state,15);
end;

procedure ld_e_hl;
Begin
de.l:=speekb(hl.W);
inc(t_state,7);
end;

procedure ld_e_a;
Begin
de.l:=af.h;
inc(t_state,4);
end;

procedure ld_ixh_b;
Begin
ix.h:=bc.h;
inc(t_state,4);
end;

procedure ld_iyh_b;
Begin
iy.h:=bc.h;
inc(t_state,4);
end;

procedure ld_h_b;
Begin
hl.h:=bc.h;
inc(t_state,4);
end;

procedure ld_ixh_c;
Begin
ix.h:=bc.l;
inc(t_state,4);
end;

procedure ld_iyh_c;
Begin
iy.h:=bc.l;
inc(t_state,4);
end;

procedure ld_h_c;
Begin
hl.h:=bc.l;
inc(t_state,4);
end;

procedure ld_ixh_d;
Begin
ix.h:=de.h;
inc(t_state,4);
end;

procedure ld_iyh_d;
Begin
iy.h:=de.h;
inc(t_state,4);
end;

procedure ld_h_d;
Begin
hl.h:=de.h;
inc(t_state,4);
end;

procedure ld_ixh_e;
Begin
ix.h:=de.l;
inc(t_state,4);
end;

procedure ld_iyh_e;
Begin
iy.h:=de.l;
inc(t_state,4);
end;

procedure ld_h_e;
Begin
hl.h:=de.l;
inc(t_state,4);
end;

procedure ld_ixh_ixh;
Begin
ix.h:=ix.h;
inc(t_state,4);
end;

procedure ld_iyh_iyh;
Begin
iy.h:=iy.h;
inc(t_state,4);
end;

procedure ld_h_h;
Begin
hl.h:=hl.h;
inc(t_state,4);
end;

procedure ld_ixh_ixl;
Begin
ix.h:=ix.l;
inc(t_state,4);
end;

procedure ld_iyh_iyl;
Begin
iy.h:=iy.l;
inc(t_state,4);
end;

procedure ld_h_l;
Begin
hl.h:=hl.l;
inc(t_state,4);
end;

procedure ld_h_ix;
Begin
hl.h:=speekb(ix.W+shortint(speekb(pc.W)));
inc(pc.W);
inc(t_state,15);
end;

procedure ld_h_iy;
Begin
hl.h:=speekb(iy.W+shortint(speekb(pc.W)));
inc(pc.W);
inc(t_state,15);
end;

procedure ld_h_hl;
Begin
hl.h:=speekb(hl.W);
inc(t_state,7);
end;

procedure ld_ixh_a;
Begin
ix.h:=af.h;
inc(t_state,4);
end;

procedure ld_iyh_a;
Begin
iy.h:=af.h;
inc(t_state,4);
end;

procedure ld_h_a;
Begin
hl.h:=af.h;
inc(t_state,4);
end;

procedure ld_ixl_b;
Begin
ix.l:=bc.h;
inc(t_state,4);
end;

procedure ld_iyl_b;
Begin
iy.l:=bc.h;
inc(t_state,4);
end;

procedure ld_l_b;
Begin
hl.l:=bc.h;
inc(t_state,4);
end;

procedure ld_ixl_c;
Begin
ix.l:=bc.l;
inc(t_state,4);
end;

procedure ld_iyl_c;
Begin
iy.l:=bc.l;
inc(t_state,4);
end;

procedure ld_l_c;
Begin
hl.l:=bc.l;
inc(t_state,4);
end;

procedure ld_ixl_d;
Begin
ix.l:=de.h;
inc(t_state,4);
end;

procedure ld_iyl_d;
Begin
iy.l:=de.h;
inc(t_state,4);
end;

procedure ld_l_d;
Begin
hl.l:=de.h;
inc(t_state,4);
end;

procedure ld_ixl_e;
Begin
ix.l:=de.l;
inc(t_state,4);
end;

procedure ld_iyl_e;
Begin
iy.l:=de.l;
inc(t_state,4);
end;

procedure ld_l_e;
Begin
hl.l:=de.l;
inc(t_state,4);
end;

procedure ld_ixl_ixh;
Begin
ix.l:=ix.h;
inc(t_state,4);
end;

procedure ld_iyl_iyh;
Begin
iy.l:=iy.h;
inc(t_state,4);
end;

procedure ld_l_h;
Begin
hl.l:=hl.h;
inc(t_state,4);
end;

procedure ld_ixl_ixl;
Begin
ix.l:=ix.l;
inc(t_state,4);
end;

procedure ld_iyl_iyl;
Begin
iy.l:=iy.l;
inc(t_state,4);
end;

procedure ld_l_l;
Begin
hl.l:=hl.l;
inc(t_state,4);
end;

procedure ld_l_ix;
Begin
hl.l:=speekb(ix.W+shortint(speekb(pc.W)));
inc(pc.W);
inc(t_state,15);
end;

procedure ld_l_iy;
Begin
hl.l:=speekb(iy.W+shortint(speekb(pc.W)));
inc(pc.W);
inc(t_state,15);
end;

procedure ld_l_hl;
Begin
hl.l:=speekb(hl.W);
inc(t_state,7);
end;

procedure ld_ixl_a;
Begin
ix.l:=af.h;
inc(t_state,4);
end;

procedure ld_iyl_a;
Begin
iy.l:=af.h;
inc(t_state,4);
end;

procedure ld_l_a;
Begin
hl.l:=af.h;
inc(t_state,4);
end;

procedure ld_ix_b;
Begin
spokeb(ix.W+shortint(speekb(pc.W)),bc.h);
inc(pc.W);
inc(t_state,15);
end;

procedure ld_iy_b;
Begin
spokeb(iy.W+shortint(speekb(pc.W)),bc.h);
inc(pc.W);
inc(t_state,15);
end;

procedure ld_hl_b;
Begin
spokeb(hl.W,bc.h);
inc(t_state,7);
end;

procedure ld_ix_c;
Begin
spokeb(ix.W+shortint(speekb(pc.W)),bc.l);
inc(pc.W);
inc(t_state,15);
end;

procedure ld_iy_c;
Begin
spokeb(iy.W+shortint(speekb(pc.W)),bc.l);
inc(pc.W);
inc(t_state,15);
end;

procedure ld_hl_c;
Begin
spokeb(hl.W,bc.l);
inc(t_state,7);
end;

procedure ld_ix_d;
Begin
spokeb(ix.W+shortint(speekb(pc.W)),de.h);
inc(pc.W);
inc(t_state,15);
end;

procedure ld_iy_d;
Begin
spokeb(iy.W+shortint(speekb(pc.W)),de.h);
inc(pc.W);
inc(t_state,15);
end;

procedure ld_hl_d;
Begin
spokeb(hl.W,de.h);
inc(t_state,7);
end;

procedure ld_ix_e;
Begin
spokeb(ix.W+shortint(speekb(pc.W)),de.l);
inc(pc.W);
inc(t_state,15);
end;

procedure ld_iy_e;
Begin
spokeb(iy.W+shortint(speekb(pc.W)),de.l);
inc(pc.W);
inc(t_state,15);
end;

procedure ld_hl_e;
Begin
spokeb(hl.W,de.l);
inc(t_state,7);
end;

procedure ld_ix_h;
Begin
spokeb(ix.W+shortint(speekb(pc.W)),hl.h);
inc(pc.W);
inc(t_state,15);
end;

procedure ld_iy_h;
Begin
spokeb(iy.W+shortint(speekb(pc.W)),hl.h);
inc(pc.W);
inc(t_state,15);
end;

procedure ld_hl_h;
Begin
spokeb(hl.W,hl.h);
inc(t_state,7);
end;

procedure ld_ix_l;
Begin
spokeb(ix.W+shortint(speekb(pc.W)),hl.l);
inc(pc.W);
inc(t_state,15);
end;

procedure ld_iy_l;
Begin
spokeb(iy.W+shortint(speekb(pc.W)),hl.l);
inc(pc.W);
inc(t_state,15);
end;

procedure ld_hl_l;
Begin
spokeb(hl.W,hl.l);
inc(t_state,7);
end;

procedure Z80halt;
Begin
halt:=1;
inc(t_state,4);
end;

procedure ld_ix_a;
Begin
spokeb(ix.W+shortint(speekb(pc.W)),af.h);
inc(pc.W);
inc(t_state,15);
end;

procedure ld_iy_a;
Begin
spokeb(iy.W+shortint(speekb(pc.W)),af.h);
inc(pc.W);
inc(t_state,15);
end;

procedure ld_hl_a;
Begin
spokeb(hl.W,af.h);
inc(t_state,7);
end;

procedure ld_a_b;
Begin
af.h:=bc.h;
inc(t_state,4);
end;

procedure ld_a_c;
Begin
af.h:=bc.l;
inc(t_state,4);
end;

procedure ld_a_d;
Begin
af.h:=de.h;
inc(t_state,4);
end;

procedure ld_a_e;
Begin
af.h:=de.l;
inc(t_state,4);
end;

procedure ld_a_ixh;
Begin
af.h:=ix.h;
inc(t_state,4);
end;

procedure ld_a_iyh;
Begin
af.h:=iy.h;
inc(t_state,4);
end;

procedure ld_a_h;
Begin
af.h:=hl.h;
inc(t_state,4);
end;

procedure ld_a_ixl;
Begin
af.h:=ix.l;
inc(t_state,4);
end;

procedure ld_a_iyl;
Begin
af.h:=iy.l;
inc(t_state,4);
end;

procedure ld_a_l;
Begin
af.h:=hl.l;
inc(t_state,4);
end;

procedure ld_a_ix;
Begin
af.h:=speekb(ix.W+shortint(speekb(pc.W)));
inc(pc.W);
inc(t_state,15);
end;

procedure ld_a_iy;
Begin
af.h:=speekb(iy.W+shortint(speekb(pc.W)));
inc(pc.W);
inc(t_state,15);
end;

procedure ld_a_hl;
Begin
af.h:=speekb(hl.W);
inc(t_state,7);
end;

procedure ld_a_a;
Begin
af.h:=af.h;
inc(t_state,4);
end;

procedure add_a_b;
Begin
add8(af.h,bc.h);
inc(t_state,4);
end;

procedure add_a_c;
Begin
add8(af.h,bc.l);
inc(t_state,4);
end;

procedure add_a_d;
Begin
add8(af.h,de.h);
inc(t_state,4);
end;

procedure add_a_e;
Begin
add8(af.h,de.l);
inc(t_state,4);
end;

procedure add_a_ixh;
Begin
add8(af.h,ix.h);
inc(t_state,4);
end;

procedure add_a_iyh;
Begin
add8(af.h,iy.h);
inc(t_state,4);
end;

procedure add_a_h;
Begin
add8(af.h,hl.h);
inc(t_state,4);
end;

procedure add_a_ixl;
Begin
add8(af.h,ix.l);
inc(t_state,4);
end;

procedure add_a_iyl;
Begin
add8(af.h,iy.l);
inc(t_state,4);
end;

procedure add_a_l;
Begin
add8(af.h,hl.l);
inc(t_state,4);
end;

procedure add_a_ix;
Begin
add8(af.h,speekb(ix.W+shortint(speekb(pc.W))));
inc(pc.W);
inc(t_state,15);
end;

procedure add_a_iy;
Begin
add8(af.h,speekb(iy.W+shortint(speekb(pc.W))));
inc(pc.W);
inc(t_state,15);
end;

procedure add_a_hl;
Begin
add8(af.h,speekb(hl.W));
inc(t_state,7);
end;

procedure add_a_a;
Begin
add8(af.h,af.h);
inc(t_state,4);
end;

procedure adc_a_b;
Begin
adc8(af.h,bc.h);
inc(t_state,4);
end;

procedure adc_a_c;
Begin
adc8(af.h,bc.l);
inc(t_state,4);
end;

procedure adc_a_d;
Begin
adc8(af.h,de.h);
inc(t_state,4);
end;

procedure adc_a_e;
Begin
adc8(af.h,de.l);
inc(t_state,4);
end;

procedure adc_a_ixh;
Begin
adc8(af.h,ix.h);
inc(t_state,4);
end;

procedure adc_a_iyh;
Begin
adc8(af.h,iy.h);
inc(t_state,4);
end;

procedure adc_a_h;
Begin
adc8(af.h,hl.h);
inc(t_state,4);
end;

procedure adc_a_ixl;
Begin
adc8(af.h,ix.l);
inc(t_state,4);
end;

procedure adc_a_iyl;
Begin
adc8(af.h,iy.l);
inc(t_state,4);
end;

procedure adc_a_l;
Begin
adc8(af.h,hl.l);
inc(t_state,4);
end;

procedure adc_a_ix;
Begin
adc8(af.h,speekb(ix.W+shortint(speekb(pc.W))));
inc(pc.W);
inc(t_state,15);
end;

procedure adc_a_iy;
Begin
adc8(af.h,speekb(iy.W+shortint(speekb(pc.W))));
inc(pc.W);
inc(t_state,15);
end;

procedure adc_a_hl;
Begin
adc8(af.h,speekb(hl.W));
inc(t_state,7);
end;

procedure adc_a_a;
Begin
adc8(af.h,af.h);
inc(t_state,4);
end;

procedure sub_b;
Begin
sub8(af.h,bc.h);
inc(t_state,4);
end;

procedure sub_c;
Begin
sub8(af.h,bc.l);
inc(t_state,4);
end;

procedure sub_d;
Begin
sub8(af.h,de.h);
inc(t_state,4);
end;

procedure sub_e;
Begin
sub8(af.h,de.l);
inc(t_state,4);
end;

procedure sub_ixh;
Begin
sub8(af.h,ix.h);
inc(t_state,4);
end;

procedure sub_iyh;
Begin
sub8(af.h,iy.h);
inc(t_state,4);
end;

procedure sub_h;
Begin
sub8(af.h,hl.h);
inc(t_state,4);
end;

procedure sub_ixl;
Begin
sub8(af.h,ix.l);
inc(t_state,4);
end;

procedure sub_iyl;
Begin
sub8(af.h,iy.l);
inc(t_state,4);
end;

procedure sub_l;
Begin
sub8(af.h,hl.l);
inc(t_state,4);
end;

procedure sub_ix;
Begin
sub8(af.h,speekb(ix.W+shortint(speekb(pc.W))));
inc(pc.W);
inc(t_state,15);
end;

procedure sub_iy;
Begin
sub8(af.h,speekb(iy.W+shortint(speekb(pc.W))));
inc(pc.W);
inc(t_state,15);
end;

procedure sub_hl;
Begin
sub8(af.h,speekb(hl.W));
inc(t_state,7);
end;

procedure sub_a;
Begin
sub8(af.h,af.h);
inc(t_state,4);
end;

procedure sbc_a_b;
Begin
sbc8(af.h,bc.h);
inc(t_state,4);
end;

procedure sbc_a_c;
Begin
sbc8(af.h,bc.l);
inc(t_state,4);
end;

procedure sbc_a_d;
Begin
sbc8(af.h,de.h);
inc(t_state,4);
end;

procedure sbc_a_e;
Begin
sbc8(af.h,de.l);
inc(t_state,4);
end;

procedure sbc_a_ixh;
Begin
sbc8(af.h,ix.h);
inc(t_state,4);
end;

procedure sbc_a_iyh;
Begin
sbc8(af.h,iy.h);
inc(t_state,4);
end;

procedure sbc_a_h;
Begin
sbc8(af.h,hl.h);
inc(t_state,4);
end;

procedure sbc_a_ixl;
Begin
sbc8(af.h,ix.l);
inc(t_state,4);
end;

procedure sbc_a_iyl;
Begin
sbc8(af.h,iy.l);
inc(t_state,4);
end;

procedure sbc_a_l;
Begin
sbc8(af.h,hl.l);
inc(t_state,4);
end;

procedure sbc_a_ix;
Begin
sbc8(af.h,speekb(ix.W+shortint(speekb(pc.W))));
inc(pc.W);
inc(t_state,15);
end;

procedure sbc_a_iy;
Begin
sbc8(af.h,speekb(iy.W+shortint(speekb(pc.W))));
inc(pc.W);
inc(t_state,15);
end;

procedure sbc_a_hl;
Begin
sbc8(af.h,speekb(hl.W));
inc(t_state,7);
end;

procedure sbc_a_a;
Begin
sbc8(af.h,af.h);
inc(t_state,4);
end;

procedure and_b;
Begin
anda(bc.h);
inc(t_state,4);
end;

procedure and_c;
Begin
anda(bc.l);
inc(t_state,4);
end;

procedure and_d;
Begin
anda(de.h);
inc(t_state,4);
end;

procedure and_e;
Begin
anda(de.l);
inc(t_state,4);
end;

procedure and_ixh;
Begin
anda(ix.h);
inc(t_state,4);
end;

procedure and_iyh;
Begin
anda(iy.h);
inc(t_state,4);
end;

procedure and_h;
Begin
anda(hl.h);
inc(t_state,4);
end;

procedure and_ixl;
Begin
anda(ix.l);
inc(t_state,4);
end;

procedure and_iyl;
Begin
anda(iy.l);
inc(t_state,4);
end;

procedure and_l;
Begin
anda(hl.l);
inc(t_state,4);
end;

procedure and_ix;
Begin
anda(speekb(ix.W+shortint(speekb(pc.W))));
inc(pc.W);
inc(t_state,15);
end;

procedure and_iy;
Begin
anda(speekb(iy.W+shortint(speekb(pc.W))));
inc(pc.W);
inc(t_state,15);
end;

procedure and_hl;
Begin
anda(speekb(hl.W));
inc(t_state,7);
end;

procedure and_a;
Begin
anda(af.h);
inc(t_state,4);
end;

procedure xor_b;
Begin
xora(bc.h);
inc(t_state,4);
end;

procedure xor_c;
Begin
xora(bc.l);
inc(t_state,4);
end;

procedure xor_d;
Begin
xora(de.h);
inc(t_state,4);
end;

procedure xor_e;
Begin
xora(de.l);
inc(t_state,4);
end;

procedure xor_ixh;
Begin
xora(ix.h);
inc(t_state,4);
end;

procedure xor_iyh;
Begin
xora(iy.h);
inc(t_state,4);
end;

procedure xor_h;
Begin
xora(hl.h);
inc(t_state,4);
end;

procedure xor_ixl;
Begin
xora(ix.l);
inc(t_state,4);
end;

procedure xor_iyl;
Begin
xora(iy.l);
inc(t_state,4);
end;

procedure xor_l;
Begin
xora(hl.l);
inc(t_state,4);
end;

procedure xor_ix;
Begin
xora(speekb(ix.W+shortint(speekb(pc.W))));
inc(pc.W);
inc(t_state,15);
end;

procedure xor_iy;
Begin
xora(speekb(iy.W+shortint(speekb(pc.W))));
inc(pc.W);
inc(t_state,15);
end;

procedure xor_hl;
Begin
xora(speekb(hl.W));
inc(t_state,7);
end;

procedure xor_a;
Begin
xora(af.h);
inc(t_state,4);
end;

procedure or_b;
Begin
ora(bc.h);
inc(t_state,4);
end;

procedure or_c;
Begin
ora(bc.l);
inc(t_state,4);
end;

procedure or_d;
Begin
ora(de.h);
inc(t_state,4);
end;

procedure or_e;
Begin
ora(de.l);
inc(t_state,4);
end;

procedure or_ixh;
Begin
ora(ix.h);
inc(t_state,4);
end;

procedure or_iyh;
Begin
ora(iy.h);
inc(t_state,4);
end;

procedure or_h;
Begin
ora(hl.h);
inc(t_state,4);
end;

procedure or_ixl;
Begin
ora(ix.l);
inc(t_state,4);
end;

procedure or_iyl;
Begin
ora(iy.l);
inc(t_state,4);
end;

procedure or_l;
Begin
ora(hl.l);
inc(t_state,4);
end;

procedure or_ix;
Begin
ora(speekb(ix.W+shortint(speekb(pc.W))));
inc(pc.W);
inc(t_state,15);
end;

procedure or_iy;
Begin
ora(speekb(iy.W+shortint(speekb(pc.W))));
inc(pc.W);
inc(t_state,15);
end;

procedure or_hl;
Begin
ora(speekb(hl.W));
inc(t_state,7);
end;

procedure or_a;
Begin
ora(af.h);
inc(t_state,4);
end;

procedure cp_b;
Begin
cp_sub8(af.h,bc.h);
inc(t_state,4);
end;

procedure cp_c;
Begin
cp_sub8(af.h,bc.l);
inc(t_state,4);
end;

procedure cp_d;
Begin
cp_sub8(af.h,de.h);
inc(t_state,4);
end;

procedure cp_e;
Begin
cp_sub8(af.h,de.l);
inc(t_state,4);
end;

procedure cp_ixh;
Begin
cp_sub8(af.h,ix.h);
inc(t_state,4);
end;

procedure cp_iyh;
Begin
cp_sub8(af.h,iy.h);
inc(t_state,4);
end;

procedure cp_h;
Begin
cp_sub8(af.h,hl.h);
inc(t_state,4);
end;

procedure cp_ixl;
Begin
cp_sub8(af.h,ix.l);
inc(t_state,4);
end;

procedure cp_iyl;
Begin
cp_sub8(af.h,iy.l);
inc(t_state,4);
end;

procedure cp_l;
Begin
cp_sub8(af.h,hl.l);
inc(t_state,4);
end;

procedure cp_ix;
Begin
cp_sub8(af.h,speekb(ix.W+shortint(speekb(pc.W))));
inc(pc.W);
inc(t_state,15);
end;

procedure cp_iy;
Begin
cp_sub8(af.h,speekb(iy.W+shortint(speekb(pc.W))));
inc(pc.W);
inc(t_state,15);
end;

procedure cp_hl;
Begin
cp_sub8(af.h,speekb(hl.W));
inc(t_state,7);
end;

procedure cp_a;
Begin
cp_sub8(af.h,af.h);
inc(t_state,4);
end;

procedure ret_nz;
Begin
if af.l and 64=0 then
 Begin
  pop(pc.W);
  inc(t_state,11);
 end else inc(t_state,5);
end;

procedure pop_bc;
Begin
pop(bc.W);
inc(t_state,10);
end;

procedure jp_nz_XXXX;
Begin
if af.l and 64=0 then
Begin
 pc.W:=wordpeek(pc.W);
 inc(t_state,10);
end
else
Begin
 inc(pc.W,2);
 inc(t_state,10);
end
end;

procedure jp_XXXX;
Begin
pc.W:=wordpeek(pc.W);
inc(t_state,10);
end;

procedure call_nz_XXXX;
Begin
if af.l and 64=0 then
Begin
 push(pc.W+2);
 pc.W:=wordpeek(pc.W);
 inc(t_state,17);
end
else
Begin
 inc(pc.W,2);
 inc(t_state,10);
end
end;

procedure push_bc;
Begin
 push(bc.W);
 inc(t_state,11);
end;

procedure add_a_XX;
Begin
add8(af.h,speekb(pc.W));
inc(pc.W);
inc(t_state,7);
end;

procedure rst_0;
Begin
push(pc.W);
pc.W:=0;
inc(t_state,11);
end;

procedure ret_z;
Begin
if af.l and 64>0 then
Begin
 pop(pc.W);
 inc(t_state,11);
end
else inc(t_state,5);
end;

procedure ret;
Begin
pop(pc.W);
inc(t_state,10);
end;

procedure jp_z_XXXX;
Begin
if af.l and 64>0 then
Begin
pc.W:=wordpeek(pc.W);
inc(t_state,10);
end
else
Begin
inc(pc.W,2);
inc(t_state,10); 
end
end;

procedure call_z_XXXX;
Begin
if af.l and 64>0 then
Begin
push(pc.W+2);
pc.W:=wordpeek(pc.W);
inc(t_state,17);
end
else
Begin
inc(pc.W,2);
inc(t_state,10);
end
end;

procedure call_XXXX;
Begin
push(pc.W+2);
pc.W:=wordpeek(pc.W);
inc(t_state,17);
end;

procedure adc_a_XX;
Begin
adc8(af.h,speekb(pc.W));
inc(pc.W);
inc(t_state,7);
end;

procedure rst_8;
Begin
push(pc.W);
pc.W:=8;
inc(t_state,11);
end;

procedure ret_nc;
Begin
if af.l and 1=0 then
Begin
pop(pc.W);
inc(t_state,11);
end
else inc(t_state,5);
end;

procedure pop_de;
Begin
pop(de.W);
inc(t_state,10);
end;

procedure jp_nc_XXXX;
Begin
if af.l and 1=0 then
Begin
pc.W:=wordpeek(pc.W);
inc(t_state,10);
end
else
Begin
inc(pc.W,2);
inc(t_state,10); 
end
end;

procedure out_XX_a;
Begin
outport(word(af.h shl 8) or speekb(pc.W),af.h);
inc(pc.W);
inc(t_state,11);
end;

procedure call_nc_XXXX;
Begin
if af.l and 1=0 then
Begin
push(pc.W+2);
pc.W:=wordpeek(pc.W);
inc(t_state,17);
end
else
Begin
inc(pc.W,2);
inc(t_state,10);
end
end;

procedure push_de;
Begin
push(de.W);
inc(t_state,11);
end;

procedure sub_XX;
Begin
sub8(af.h,speekb(pc.W));
inc(pc.W);
inc(t_state,7);
end;

procedure rst_16;
Begin
push(pc.W);
pc.W:=16;
inc(t_state,11);
end;

procedure ret_c;
Begin
if af.l and 1>0 then
Begin
pop(pc.W);
inc(t_state,11);
end
else inc(t_state,5);
end;

procedure exx;
var temp: word;
Begin
 {temp:=af.W;af.W:=af2.W;af2.W:=temp;}
 temp:=bc.W;bc.W:=bc2.W;bc2.W:=temp;
 temp:=de.W;de.W:=de2.W;de2.W:=temp;
 temp:=hl.W;hl.W:=hl2.W;hl2.W:=temp;
 inc(t_state,4);
end;

procedure jp_c_XXXX;
Begin
if af.l and 1>0 then
Begin
pc.W:=wordpeek(pc.W);
inc(t_state,10);
end
else
Begin
inc(pc.W,2);
inc(t_state,10); 
end
end;

procedure in_a_XX;
Begin
af.h:=inport(af.h,speekb(pc.W));
inc(pc.W);
inc(t_state,11);
end;

procedure call_c_XXXX;
Begin
if af.l and 1>0 then
Begin
push(pc.W+2);
pc.W:=wordpeek(pc.W);
inc(t_state,17);
end
else
Begin
inc(pc.W,2);
inc(t_state,10);
end
end;

procedure sbc_a_XX;
Begin
sbc8(af.h,speekb(pc.W));
inc(pc.W);
inc(t_state,7);
end;

procedure rst_24;
Begin
push(pc.W);
pc.W:=24;
inc(t_state,11);
end;

procedure ret_po;
Begin
if af.l and 4=0 then
Begin
pop(pc.W);
inc(t_state,11);
end
else inc(t_state,5);
end;

procedure pop_ix;
Begin
pop(ix.W);
inc(t_state,10);
end;

procedure pop_iy;
Begin
pop(iy.W);
inc(t_state,10);
end;

procedure pop_hl;
Begin
pop(hl.W);
inc(t_state,10);
end;

procedure jp_po_XXXX;
Begin
if af.l and 4=0 then
Begin
 pc.W:=wordpeek(pc.W);
 inc(t_state,10);
end
else
Begin
 inc(pc.W,2);
 inc(t_state,10);
end
end;

procedure ex_msp_ix;
var temp:Word;
Begin
temp:=wordpeek(sp.W);
wordpoke(sp.W,ix.W);
ix.W:=temp;
inc(t_state,19);
end;

procedure ex_msp_iy;
var temp:Word;
Begin
temp:=wordpeek(sp.W);
wordpoke(sp.W,iy.W);
iy.W:=temp;
inc(t_state,19);
end;

procedure ex_msp_hl;
var temp:Word;
Begin
temp:=wordpeek(sp.W);
wordpoke(sp.W,hl.W);
hl.W:=temp;
inc(t_state,4);
end;

procedure call_po_XXXX;
Begin
        if af.l and 4=0 then
Begin
push(pc.W+2);
pc.W:=wordpeek(pc.W);
inc(t_state,17);
end
else
Begin
inc(pc.W,2);
inc(t_state,10);
end
end;

procedure push_ix;
Begin
push(ix.W);
inc(t_state,11);
end;

procedure push_iy;
Begin
push(iy.W);
inc(t_state,11);
end;

procedure push_hl;
Begin
push(hl.W);
inc(t_state,11);
end;

procedure and_XX;
Begin
anda(speekb(pc.W));
inc(pc.W);
inc(t_state,7);
end;

procedure rst_32;
Begin
push(pc.W);
pc.W:=32;
inc(t_state,11);
end;

procedure ret_pe;
Begin
if af.l and 4>0 then
Begin
pop(pc.W);
inc(t_state,11);
end
else inc(t_state,5);
end;

procedure jp_ix;
Begin
pc.W:=ix.W;
inc(t_state,4);
end;

procedure jp_iy;
Begin
pc.W:=iy.W;
inc(t_state,4);
end;

procedure jp_hl;
Begin
pc.W:=hl.W;
inc(t_state,4);
end;

procedure jp_pe_XXXX;
Begin
if af.l and 4>0 then
Begin
pc.W:=wordpeek(pc.W);
inc(t_state,10);
end
else
Begin
inc(pc.W,2);
inc(t_state,10); 
end
end;

procedure ex_de_ix;
var temp: Word;
Begin
temp:=de.W;
de.W:=ix.W;
ix.W:=temp;
inc(t_state,4);
end;

procedure ex_de_iy;
var temp: word;
Begin
temp:=de.W;
de.W:=iy.W;
iy.W:=temp;
inc(t_state,4);
end;

procedure ex_de_hl;
var temp: word;
Begin
temp:=de.W;
de.W:=hl.W;
hl.W:=temp;
inc(t_state,4);
end;

procedure call_pe_XXXX;
Begin
if af.l and 4>0 then
Begin
push(pc.W+2);
pc.W:=wordpeek(pc.W);
inc(t_state,17);
end
else
Begin
inc(pc.W,2);
inc(t_state,10);
end
end;

procedure xor_XX;
Begin
xora(speekb(pc.W));
inc(pc.W);
inc(t_state,7);
end;

procedure rst_40;
Begin
push(pc.W);
pc.W:=40;
inc(t_state,11);
end;

procedure ret_p;
Begin
if af.l and 128=0 then
Begin
pop(pc.W);
inc(t_state,11);
end
else inc(t_state,5);
end;

procedure pop_af;
Begin
pop(af.W);
inc(t_state,10);
end;

procedure jp_p_XXXX;
Begin
if af.l and 128=0 then
Begin
pc.W:=wordpeek(pc.W);
inc(t_state,10);
end
else
Begin
inc(pc.W,2);
inc(t_state,10); 
end
end;

procedure di;
Begin
iff1:=0;
inc(t_state,4);
end;

procedure call_p_XXXX;
Begin
if af.l and 128=0 then
Begin
push(pc.W+2);
pc.W:=wordpeek(pc.W);
inc(t_state,17);
end
else
Begin
inc(pc.W,2);
inc(t_state,10);
end
end;

procedure push_af;
Begin
push(af.W);
inc(t_state,11);
end;

procedure or_XX;
Begin
ora(speekb(pc.W));
inc(pc.W);
inc(t_state,7);
end;

procedure rst_48;
Begin
push(pc.W);
pc.W:=48;
inc(t_state,11);
end;

procedure ret_m;
Begin
if af.l and 128>0 then
Begin
pop(pc.W);
inc(t_state,11);
end else inc(t_state,5);
end;

procedure ld_sp_ix;
Begin
sp.W:=ix.W;
inc(t_state,6);
end;

procedure ld_sp_iy;
Begin
sp.W:=iy.W;
inc(t_state,6);
end;

procedure ld_sp_hl;
Begin
sp.W:=hl.W;
inc(t_state,6);
end;

procedure jp_m_XXXX;
Begin
if af.l and 128>0 then
Begin
pc.W:=wordpeek(pc.W);
inc(t_state,10);
end
else
Begin
inc(pc.W,2);
inc(t_state,10); 
end
end;

procedure ei;
Begin
iff1:=1;
inc(t_state,4);
end;

procedure call_m_XXXX;
Begin
if af.l and 128>0 then
Begin
push(pc.W+2);
pc.W:=wordpeek(pc.W);
inc(t_state,17);
end
else
Begin
inc(pc.W,2);
inc(t_state,10);
end
end;

procedure cp_XX;
Begin
cp_sub8(af.h,speekb(pc.W));
inc(pc.W);
inc(t_state,7);
end;

procedure rst_56;
Begin
push(pc.W);
pc.W:=56;
inc(t_state,11);
end;

procedure IX_Pre;
var b:byte;
begin
inc(ir.l);
b:=speekb(pc.W);
inc(pc.W);
Z80_IX[b];
end;

procedure IY_Pre;
var b:byte;
begin
inc(ir.l);
b:=speekb(pc.W);
inc(pc.w);
Z80_IY[b];
end;

procedure ED_Pre;
var b:byte;
begin
        inc(ir.l);
b:=speekb(pc.W);
inc(pc.w);
ED[b];
end;

procedure  IX_CB_Pre;
var b:byte;
begin
CBdis:=speekb(pc.W);
inc(pc.w);
b:=speekb(pc.W);
inc(pc.w);
        addr:=ix.w+cbdis;
CB[b]; inc(t_state,8);
end;

procedure  IY_CB_Pre;
var b:byte;
begin
CBdis:=speekb(pc.W);
inc(pc.w);
b:=speekb(pc.W);
inc(pc.w);
        addr:=iy.w+cbdis;inc(t_state,8);
CB[b];
end;

procedure  CB_Pre;
var b:byte;
begin
        inc(ir.l);
b:=speekb(pc.W);
inc(pc.w);
        addr:=hl.w;
CB[b];
end;

procedure createZ80;
begin
Z80[0]:=nop;
Z80[1]:=ld_bc_XXXX;
Z80[2]:=ld_mbc_a;
Z80[3]:=inc_bc;
Z80[4]:=inc_b;
Z80[5]:=dec_b;
Z80[6]:=ld_b_XX;
Z80[7]:=rlca;
Z80[8]:=ex_af_af;
Z80[9]:=add_hl_bc;
Z80[10]:=ld_a_mbc;
Z80[11]:=dec_bc;
Z80[12]:=inc_c;
Z80[13]:=dec_c;
Z80[14]:=ld_c_XX;
Z80[15]:=rrca;
Z80[16]:=djnz_DIS;
Z80[17]:=ld_de_XXXX;
Z80[18]:=ld_mde_a;
Z80[19]:=inc_de;
Z80[20]:=inc_d;
Z80[21]:=dec_d;
Z80[22]:=ld_d_XX;
Z80[23]:=rla;
Z80[24]:=jr_DIS;
Z80[25]:=add_hl_de;
Z80[26]:=ld_a_mde;
Z80[27]:=dec_de;
Z80[28]:=inc_e;
Z80[29]:=dec_e;
Z80[30]:=ld_e_XX;
Z80[31]:=rra;
Z80[32]:=jr_nz_DIS;
Z80[33]:=ld_hl_XXXX;
Z80[34]:=Z80ld_aXXXX_hl;
Z80[35]:=inc_hl;
Z80[36]:=inc_h;
Z80[37]:=dec_h;
Z80[38]:=ld_h_XX;
Z80[39]:=daa;
Z80[40]:=jr_z_DIS;
Z80[41]:=add_hl_hl;
Z80[42]:=Z80ld_hl_aXXXX;
Z80[43]:=dec_hl;
Z80[44]:=inc_l;
Z80[45]:=dec_l;
Z80[46]:=ld_l_XX;
Z80[47]:=cpl;
Z80[48]:=jr_nc_DIS;
Z80[49]:=ld_sp_XXXX;
Z80[50]:=ld_aXXXX_a;
Z80[51]:=inc_sp;
Z80[52]:=inc_mhl;
Z80[53]:=dec_mhl;
Z80[54]:=ld_mhl_XX;
Z80[55]:=scf;
Z80[56]:=jr_c_DIS;
Z80[57]:=add_hl_sp;
Z80[58]:=ld_a_aXXXX;
Z80[59]:=dec_sp;
Z80[60]:=Z80inc_a;
Z80[61]:=Z80dec_a;
Z80[62]:=ld_a_XX;
Z80[63]:=ccf;
Z80[64]:=ld_b_b;
Z80[65]:=ld_b_c;
Z80[66]:=ld_b_d;
Z80[67]:=ld_b_e;
Z80[68]:=ld_b_h;
Z80[69]:=ld_b_l;
Z80[70]:=ld_b_hl;
Z80[71]:=ld_b_a;
Z80[72]:=ld_c_b;
Z80[73]:=ld_c_c;
Z80[74]:=ld_c_d;
Z80[75]:=ld_c_e;
Z80[76]:=ld_c_h;
Z80[77]:=ld_c_l;
Z80[78]:=ld_c_hl;
Z80[79]:=ld_c_a;
Z80[80]:=ld_d_b;
Z80[81]:=ld_d_c;
Z80[82]:=ld_d_d;
Z80[83]:=ld_d_e;
Z80[84]:=ld_d_h;
Z80[85]:=ld_d_l;
Z80[86]:=ld_d_hl;
Z80[87]:=ld_d_a;
Z80[88]:=ld_e_b;
Z80[89]:=ld_e_c;
Z80[90]:=ld_e_d;
Z80[91]:=ld_e_e;
Z80[92]:=ld_e_h;
Z80[93]:=ld_e_l;
Z80[94]:=ld_e_hl;
Z80[95]:=ld_e_a;
Z80[96]:=ld_h_b;
Z80[97]:=ld_h_c;
Z80[98]:=ld_h_d;
Z80[99]:=ld_h_e;
Z80[100]:=ld_h_h;
Z80[101]:=ld_h_l;
Z80[102]:=ld_h_hl;
Z80[103]:=ld_h_a;
Z80[104]:=ld_l_b;
Z80[105]:=ld_l_c;
Z80[106]:=ld_l_d;
Z80[107]:=ld_l_e;
Z80[108]:=ld_l_h;
Z80[109]:=ld_l_l;
Z80[110]:=ld_l_hl;
Z80[111]:=ld_l_a;
Z80[112]:=ld_hl_b;
Z80[113]:=ld_hl_c;
Z80[114]:=ld_hl_d;
Z80[115]:=ld_hl_e;
Z80[116]:=ld_hl_h;
Z80[117]:=ld_hl_l;
Z80[118]:=Z80halt;
Z80[119]:=ld_hl_a;
Z80[120]:=ld_a_b;
Z80[121]:=ld_a_c;
Z80[122]:=ld_a_d;
Z80[123]:=ld_a_e;
Z80[124]:=ld_a_h;
Z80[125]:=ld_a_l;
Z80[126]:=ld_a_hl;
Z80[127]:=ld_a_a;
Z80[128]:=add_a_b;
Z80[129]:=add_a_c;
Z80[130]:=add_a_d;
Z80[131]:=add_a_e;
Z80[132]:=add_a_h;
Z80[133]:=add_a_l;
Z80[134]:=add_a_hl;
Z80[135]:=add_a_a;
Z80[136]:=adc_a_b;
Z80[137]:=adc_a_c;
Z80[138]:=adc_a_d;
Z80[139]:=adc_a_e;
Z80[140]:=adc_a_h;
Z80[141]:=adc_a_l;
Z80[142]:=adc_a_hl;
Z80[143]:=adc_a_a;
Z80[144]:=sub_b;
Z80[145]:=sub_c;
Z80[146]:=sub_d;
Z80[147]:=sub_e;
Z80[148]:=sub_h;
Z80[149]:=sub_l;
Z80[150]:=sub_hl;
Z80[151]:=sub_a;
Z80[152]:=sbc_a_b;
Z80[153]:=sbc_a_c;
Z80[154]:=sbc_a_d;
Z80[155]:=sbc_a_e;
Z80[156]:=sbc_a_h;
Z80[157]:=sbc_a_l;
Z80[158]:=sbc_a_hl;
Z80[159]:=sbc_a_a;
Z80[160]:=and_b;
Z80[161]:=and_c;
Z80[162]:=and_d;
Z80[163]:=and_e;
Z80[164]:=and_h;
Z80[165]:=and_l;
Z80[166]:=and_hl;
Z80[167]:=and_a;
Z80[168]:=xor_b;
Z80[169]:=xor_c;
Z80[170]:=xor_d;
Z80[171]:=xor_e;
Z80[172]:=xor_h;
Z80[173]:=xor_l;
Z80[174]:=xor_hl;
Z80[175]:=xor_a;
Z80[176]:=or_b;
Z80[177]:=or_c;
Z80[178]:=or_d;
Z80[179]:=or_e;
Z80[180]:=or_h;
Z80[181]:=or_l;
Z80[182]:=or_hl;
Z80[183]:=or_a;
Z80[184]:=cp_b;
Z80[185]:=cp_c;
Z80[186]:=cp_d;
Z80[187]:=cp_e;
Z80[188]:=cp_h;
Z80[189]:=cp_l;
Z80[190]:=cp_hl;
Z80[191]:=cp_a;
Z80[192]:=ret_nz;
Z80[193]:=pop_bc;
Z80[194]:=jp_nz_XXXX;
Z80[195]:=jp_XXXX;
Z80[196]:=call_nz_XXXX;
Z80[197]:=push_bc;
Z80[198]:=add_a_XX;
Z80[199]:=rst_0;
Z80[200]:=ret_z;
Z80[201]:=ret;
Z80[202]:=jp_z_XXXX;
Z80[203]:=CB_Pre;
Z80[204]:=call_z_XXXX;
Z80[205]:=call_XXXX;
Z80[206]:=adc_a_XX;
Z80[207]:=rst_8;
Z80[208]:=ret_nc;
Z80[209]:=pop_de;
Z80[210]:=jp_nc_XXXX;
Z80[211]:=out_XX_a;
Z80[212]:=call_nc_XXXX;
Z80[213]:=push_de;
Z80[214]:=sub_XX;
Z80[215]:=rst_16;
Z80[216]:=ret_c;
Z80[217]:=exx;
Z80[218]:=jp_c_XXXX;
Z80[219]:=in_a_XX;
Z80[220]:=call_c_XXXX;
Z80[221]:=IX_Pre;
Z80[222]:=sbc_a_XX;
Z80[223]:=rst_24;
Z80[224]:=ret_po;
Z80[225]:=pop_hl;
Z80[226]:=jp_po_XXXX;
Z80[227]:=ex_msp_hl;
Z80[228]:=call_po_XXXX;
Z80[229]:=push_hl;
Z80[230]:=and_XX;
Z80[231]:=rst_32;
Z80[232]:=ret_pe;
Z80[233]:=jp_hl;
Z80[234]:=jp_pe_XXXX;
Z80[235]:=ex_de_hl;
Z80[236]:=call_pe_XXXX;
Z80[237]:=ED_Pre;
Z80[238]:=xor_XX;
Z80[239]:=rst_40;
Z80[240]:=ret_p;
Z80[241]:=pop_af;
Z80[242]:=jp_p_XXXX;
Z80[243]:=di;
Z80[244]:=call_p_XXXX;
Z80[245]:=push_af;
Z80[246]:=or_XX;
Z80[247]:=rst_48;
Z80[248]:=ret_m;
Z80[249]:=ld_sp_hl;
Z80[250]:=jp_m_XXXX;
Z80[251]:=ei;
Z80[252]:=call_m_XXXX;
Z80[253]:=IY_Pre;
Z80[254]:=cp_XX;
Z80[255]:=rst_56;

Z80_IX[0]:=nop;
Z80_IX[1]:=ld_bc_XXXX;
Z80_IX[2]:=ld_mbc_a;
Z80_IX[3]:=inc_bc;
Z80_IX[4]:=inc_b;
Z80_IX[5]:=dec_b;
Z80_IX[6]:=ld_b_XX;
Z80_IX[7]:=rlca;
Z80_IX[8]:=ex_af_af;
Z80_IX[9]:=add_ix_bc;
Z80_IX[10]:=ld_a_mbc;
Z80_IX[11]:=dec_bc;
Z80_IX[12]:=inc_c;
Z80_IX[13]:=dec_c;
Z80_IX[14]:=ld_c_XX;
Z80_IX[15]:=rrca;
Z80_IX[16]:=djnz_DIS;
Z80_IX[17]:=ld_de_XXXX;
Z80_IX[18]:=ld_mde_a;
Z80_IX[19]:=inc_de;
Z80_IX[20]:=inc_d;
Z80_IX[21]:=dec_d;
Z80_IX[22]:=ld_d_XX;
Z80_IX[23]:=rla;
Z80_IX[24]:=jr_DIS;
Z80_IX[25]:=add_ix_de;
Z80_IX[26]:=ld_a_mde;
Z80_IX[27]:=dec_de;
Z80_IX[28]:=inc_e;
Z80_IX[29]:=dec_e;
Z80_IX[30]:=ld_e_XX;
Z80_IX[31]:=rra;
Z80_IX[32]:=jr_nz_DIS;
Z80_IX[33]:=ld_ix_XXXX;
Z80_IX[34]:=Z80ld_aXXXX_ix;
Z80_IX[35]:=inc_ix;
Z80_IX[36]:=inc_ixh;
Z80_IX[37]:=dec_ixh;
Z80_IX[38]:=ld_ixh_XX;
Z80_IX[39]:=daa;
Z80_IX[40]:=jr_z_DIS;
Z80_IX[41]:=add_ix_ix;
Z80_IX[42]:=Z80ld_ix_aXXXX;
Z80_IX[43]:=dec_ix;
Z80_IX[44]:=inc_ixl;
Z80_IX[45]:=dec_ixl;
Z80_IX[46]:=ld_ixl_XX;
Z80_IX[47]:=cpl;
Z80_IX[48]:=jr_nc_DIS;
Z80_IX[49]:=ld_sp_XXXX;
Z80_IX[50]:=ld_aXXXX_a;
Z80_IX[51]:=inc_sp;
Z80_IX[52]:=inc_mix;
Z80_IX[53]:=dec_mix;
Z80_IX[54]:=ld_mix_XX;
Z80_IX[55]:=scf;
Z80_IX[56]:=jr_c_DIS;
Z80_IX[57]:=add_ix_sp;
Z80_IX[58]:=ld_a_aXXXX;
Z80_IX[59]:=dec_sp;
Z80_IX[60]:=Z80inc_a;
Z80_IX[61]:=Z80dec_a;
Z80_IX[62]:=ld_a_XX;
Z80_IX[63]:=ccf;
Z80_IX[64]:=ld_b_b;
Z80_IX[65]:=ld_b_c;
Z80_IX[66]:=ld_b_d;
Z80_IX[67]:=ld_b_e;
Z80_IX[68]:=ld_b_ixh;
Z80_IX[69]:=ld_b_ixl;
Z80_IX[70]:=ld_b_ix;
Z80_IX[71]:=ld_b_a;
Z80_IX[72]:=ld_c_b;
Z80_IX[73]:=ld_c_c;
Z80_IX[74]:=ld_c_d;
Z80_IX[75]:=ld_c_e;
Z80_IX[76]:=ld_c_ixh;
Z80_IX[77]:=ld_c_ixl;
Z80_IX[78]:=ld_c_ix;
Z80_IX[79]:=ld_c_a;
Z80_IX[80]:=ld_d_b;
Z80_IX[81]:=ld_d_c;
Z80_IX[82]:=ld_d_d;
Z80_IX[83]:=ld_d_e;
Z80_IX[84]:=ld_d_ixh;
Z80_IX[85]:=ld_d_ixl;
Z80_IX[86]:=ld_d_ix;
Z80_IX[87]:=ld_d_a;
Z80_IX[88]:=ld_e_b;
Z80_IX[89]:=ld_e_c;
Z80_IX[90]:=ld_e_d;
Z80_IX[91]:=ld_e_e;
Z80_IX[92]:=ld_e_ixh;
Z80_IX[93]:=ld_e_ixl;
Z80_IX[94]:=ld_e_ix;
Z80_IX[95]:=ld_e_a;
Z80_IX[96]:=ld_ixh_b;
Z80_IX[97]:=ld_ixh_c;
Z80_IX[98]:=ld_ixh_d;
Z80_IX[99]:=ld_ixh_e;
Z80_IX[100]:=ld_ixh_ixh;
Z80_IX[101]:=ld_ixh_ixl;
Z80_IX[102]:=ld_h_ix;
Z80_IX[103]:=ld_ixh_a;
Z80_IX[104]:=ld_ixl_b;
Z80_IX[105]:=ld_ixl_c;
Z80_IX[106]:=ld_ixl_d;
Z80_IX[107]:=ld_ixl_e;
Z80_IX[108]:=ld_ixl_ixh;
Z80_IX[109]:=ld_ixl_ixl;
Z80_IX[110]:=ld_l_ix;
Z80_IX[111]:=ld_ixl_a;
Z80_IX[112]:=ld_ix_b;
Z80_IX[113]:=ld_ix_c;
Z80_IX[114]:=ld_ix_d;
Z80_IX[115]:=ld_ix_e;
Z80_IX[116]:=ld_ix_h;
Z80_IX[117]:=ld_ix_l;
Z80_IX[118]:=Z80halt;
Z80_IX[119]:=ld_ix_a;
Z80_IX[120]:=ld_a_b;
Z80_IX[121]:=ld_a_c;
Z80_IX[122]:=ld_a_d;
Z80_IX[123]:=ld_a_e;
Z80_IX[124]:=ld_a_ixh;
Z80_IX[125]:=ld_a_ixl;
Z80_IX[126]:=ld_a_ix;
Z80_IX[127]:=ld_a_a;
Z80_IX[128]:=add_a_b;
Z80_IX[129]:=add_a_c;
Z80_IX[130]:=add_a_d;
Z80_IX[131]:=add_a_e;
Z80_IX[132]:=add_a_ixh;
Z80_IX[133]:=add_a_ixl;
Z80_IX[134]:=add_a_ix;
Z80_IX[135]:=add_a_a;
Z80_IX[136]:=adc_a_b;
Z80_IX[137]:=adc_a_c;
Z80_IX[138]:=adc_a_d;
Z80_IX[139]:=adc_a_e;
Z80_IX[140]:=adc_a_ixh;
Z80_IX[141]:=adc_a_ixl;
Z80_IX[142]:=adc_a_ix;
Z80_IX[143]:=adc_a_a;
Z80_IX[144]:=sub_b;
Z80_IX[145]:=sub_c;
Z80_IX[146]:=sub_d;
Z80_IX[147]:=sub_e;
Z80_IX[148]:=sub_ixh;
Z80_IX[149]:=sub_ixl;
Z80_IX[150]:=sub_ix;
Z80_IX[151]:=sub_a;
Z80_IX[152]:=sbc_a_b;
Z80_IX[153]:=sbc_a_c;
Z80_IX[154]:=sbc_a_d;
Z80_IX[155]:=sbc_a_e;
Z80_IX[156]:=sbc_a_ixh;
Z80_IX[157]:=sbc_a_ixl;
Z80_IX[158]:=sbc_a_ix;
Z80_IX[159]:=sbc_a_a;
Z80_IX[160]:=and_b;
Z80_IX[161]:=and_c;
Z80_IX[162]:=and_d;
Z80_IX[163]:=and_e;
Z80_IX[164]:=and_ixh;
Z80_IX[165]:=and_ixl;
Z80_IX[166]:=and_ix;
Z80_IX[167]:=and_a;
Z80_IX[168]:=xor_b;
Z80_IX[169]:=xor_c;
Z80_IX[170]:=xor_d;
Z80_IX[171]:=xor_e;
Z80_IX[172]:=xor_ixh;
Z80_IX[173]:=xor_ixl;
Z80_IX[174]:=xor_ix;
Z80_IX[175]:=xor_a;
Z80_IX[176]:=or_b;
Z80_IX[177]:=or_c;
Z80_IX[178]:=or_d;
Z80_IX[179]:=or_e;
Z80_IX[180]:=or_ixh;
Z80_IX[181]:=or_ixl;
Z80_IX[182]:=or_ix;
Z80_IX[183]:=or_a;
Z80_IX[184]:=cp_b;
Z80_IX[185]:=cp_c;
Z80_IX[186]:=cp_d;
Z80_IX[187]:=cp_e;
Z80_IX[188]:=cp_ixh;
Z80_IX[189]:=cp_ixl;
Z80_IX[190]:=cp_ix;
Z80_IX[191]:=cp_a;
Z80_IX[192]:=ret_nz;
Z80_IX[193]:=pop_bc;
Z80_IX[194]:=jp_nz_XXXX;
Z80_IX[195]:=jp_XXXX;
Z80_IX[196]:=call_nz_XXXX;
Z80_IX[197]:=push_bc;
Z80_IX[198]:=add_a_XX;
Z80_IX[199]:=rst_0;
Z80_IX[200]:=ret_z;
Z80_IX[201]:=ret;
Z80_IX[202]:=jp_z_XXXX;
Z80_IX[203]:=ix_CB_pre;
Z80_IX[204]:=call_z_XXXX;
Z80_IX[205]:=call_XXXX;
Z80_IX[206]:=adc_a_XX;
Z80_IX[207]:=rst_8;
Z80_IX[208]:=ret_nc;
Z80_IX[209]:=pop_de;
Z80_IX[210]:=jp_nc_XXXX;
Z80_IX[211]:=out_XX_a;
Z80_IX[212]:=call_nc_XXXX;
Z80_IX[213]:=push_de;
Z80_IX[214]:=sub_XX;
Z80_IX[215]:=rst_16;
Z80_IX[216]:=ret_c;
Z80_IX[217]:=exx;
Z80_IX[218]:=jp_c_XXXX;
Z80_IX[219]:=in_a_XX;
Z80_IX[220]:=call_c_XXXX;
Z80_IX[221]:=IX_Pre;
Z80_IX[222]:=sbc_a_XX;
Z80_IX[223]:=rst_24;
Z80_IX[224]:=ret_po;
Z80_IX[225]:=pop_ix;
Z80_IX[226]:=jp_po_XXXX;
Z80_IX[227]:=ex_msp_ix;
Z80_IX[228]:=call_po_XXXX;
Z80_IX[229]:=push_ix;
Z80_IX[230]:=and_XX;
Z80_IX[231]:=rst_32;
Z80_IX[232]:=ret_pe;
Z80_IX[233]:=jp_ix;
Z80_IX[234]:=jp_pe_XXXX;
Z80_IX[235]:=ex_de_ix;
Z80_IX[236]:=call_pe_XXXX;
Z80_IX[237]:=ED_Pre;
Z80_IX[238]:=xor_XX;
Z80_IX[239]:=rst_40;
Z80_IX[240]:=ret_p;
Z80_IX[241]:=pop_af;
Z80_IX[242]:=jp_p_XXXX;
Z80_IX[243]:=di;
Z80_IX[244]:=call_p_XXXX;
Z80_IX[245]:=push_af;
Z80_IX[246]:=or_XX;
Z80_IX[247]:=rst_48;
Z80_IX[248]:=ret_m;
Z80_IX[249]:=ld_sp_ix;
Z80_IX[250]:=jp_m_XXXX;
Z80_IX[251]:=ei;
Z80_IX[252]:=call_m_XXXX;
Z80_IX[253]:=IY_Pre;
Z80_IX[254]:=cp_XX;
Z80_IX[255]:=rst_56;

Z80_IY[0]:=nop;
Z80_IY[1]:=ld_bc_XXXX;
Z80_IY[2]:=ld_mbc_a;
Z80_IY[3]:=inc_bc;
Z80_IY[4]:=inc_b;
Z80_IY[5]:=dec_b;
Z80_IY[6]:=ld_b_XX;
Z80_IY[7]:=rlca;
Z80_IY[8]:=ex_af_af;
Z80_IY[9]:=add_iy_bc;
Z80_IY[10]:=ld_a_mbc;
Z80_IY[11]:=dec_bc;
Z80_IY[12]:=inc_c;
Z80_IY[13]:=dec_c;
Z80_IY[14]:=ld_c_XX;
Z80_IY[15]:=rrca;
Z80_IY[16]:=djnz_DIS;
Z80_IY[17]:=ld_de_XXXX;
Z80_IY[18]:=ld_mde_a;
Z80_IY[19]:=inc_de;
Z80_IY[20]:=inc_d;
Z80_IY[21]:=dec_d;
Z80_IY[22]:=ld_d_XX;
Z80_IY[23]:=rla;
Z80_IY[24]:=jr_DIS;
Z80_IY[25]:=add_iy_de;
Z80_IY[26]:=ld_a_mde;
Z80_IY[27]:=dec_de;
Z80_IY[28]:=inc_e;
Z80_IY[29]:=dec_e;
Z80_IY[30]:=ld_e_XX;
Z80_IY[31]:=rra;
Z80_IY[32]:=jr_nz_DIS;
Z80_IY[33]:=ld_iy_XXXX;
Z80_IY[34]:=Z80ld_aXXXX_iy;
Z80_IY[35]:=inc_iy;
Z80_IY[36]:=inc_iyh;
Z80_IY[37]:=dec_iyh;
Z80_IY[38]:=ld_iyh_XX;
Z80_IY[39]:=daa;
Z80_IY[40]:=jr_z_DIS;
Z80_IY[41]:=add_iy_iy;
Z80_IY[42]:=Z80ld_iy_aXXXX;
Z80_IY[43]:=dec_iy;
Z80_IY[44]:=inc_iyl;
Z80_IY[45]:=dec_iyl;
Z80_IY[46]:=ld_iyl_XX;
Z80_IY[47]:=cpl;
Z80_IY[48]:=jr_nc_DIS;
Z80_IY[49]:=ld_sp_XXXX;
Z80_IY[50]:=ld_aXXXX_a;
Z80_IY[51]:=inc_sp;
Z80_IY[52]:=inc_miy;
Z80_IY[53]:=dec_miy;
Z80_IY[54]:=ld_miy_XX;
Z80_IY[55]:=scf;
Z80_IY[56]:=jr_c_DIS;
Z80_IY[57]:=add_iy_sp;
Z80_IY[58]:=ld_a_aXXXX;
Z80_IY[59]:=dec_sp;
Z80_IY[60]:=Z80inc_a;
Z80_IY[61]:=Z80dec_a;
Z80_IY[62]:=ld_a_XX;
Z80_IY[63]:=ccf;
Z80_IY[64]:=ld_b_b;
Z80_IY[65]:=ld_b_c;
Z80_IY[66]:=ld_b_d;
Z80_IY[67]:=ld_b_e;
Z80_IY[68]:=ld_b_iyh;
Z80_IY[69]:=ld_b_iyl;
Z80_IY[70]:=ld_b_iy;
Z80_IY[71]:=ld_b_a;
Z80_IY[72]:=ld_c_b;
Z80_IY[73]:=ld_c_c;
Z80_IY[74]:=ld_c_d;
Z80_IY[75]:=ld_c_e;
Z80_IY[76]:=ld_c_iyh;
Z80_IY[77]:=ld_c_iyl;
Z80_IY[78]:=ld_c_iy;
Z80_IY[79]:=ld_c_a;
Z80_IY[80]:=ld_d_b;
Z80_IY[81]:=ld_d_c;
Z80_IY[82]:=ld_d_d;
Z80_IY[83]:=ld_d_e;
Z80_IY[84]:=ld_d_iyh;
Z80_IY[85]:=ld_d_iyl;
Z80_IY[86]:=ld_d_iy;
Z80_IY[87]:=ld_d_a;
Z80_IY[88]:=ld_e_b;
Z80_IY[89]:=ld_e_c;
Z80_IY[90]:=ld_e_d;
Z80_IY[91]:=ld_e_e;
Z80_IY[92]:=ld_e_iyh;
Z80_IY[93]:=ld_e_iyl;
Z80_IY[94]:=ld_e_iy;
Z80_IY[95]:=ld_e_a;
Z80_IY[96]:=ld_iyh_b;
Z80_IY[97]:=ld_iyh_c;
Z80_IY[98]:=ld_iyh_d;
Z80_IY[99]:=ld_iyh_e;
Z80_IY[100]:=ld_iyh_iyh;
Z80_IY[101]:=ld_iyh_iyl;
Z80_IY[102]:=ld_h_iy;
Z80_IY[103]:=ld_iyh_a;
Z80_IY[104]:=ld_iyl_b;
Z80_IY[105]:=ld_iyl_c;
Z80_IY[106]:=ld_iyl_d;
Z80_IY[107]:=ld_iyl_e;
Z80_IY[108]:=ld_iyl_iyh;
Z80_IY[109]:=ld_iyl_iyl;
Z80_IY[110]:=ld_l_iy;
Z80_IY[111]:=ld_iyl_a;
Z80_IY[112]:=ld_iy_b;
Z80_IY[113]:=ld_iy_c;
Z80_IY[114]:=ld_iy_d;
Z80_IY[115]:=ld_iy_e;
Z80_IY[116]:=ld_iy_h;
Z80_IY[117]:=ld_iy_l;
Z80_IY[118]:=Z80halt;
Z80_IY[119]:=ld_iy_a;
Z80_IY[120]:=ld_a_b;
Z80_IY[121]:=ld_a_c;
Z80_IY[122]:=ld_a_d;
Z80_IY[123]:=ld_a_e;
Z80_IY[124]:=ld_a_iyh;
Z80_IY[125]:=ld_a_iyl;
Z80_IY[126]:=ld_a_iy;
Z80_IY[127]:=ld_a_a;
Z80_IY[128]:=add_a_b;
Z80_IY[129]:=add_a_c;
Z80_IY[130]:=add_a_d;
Z80_IY[131]:=add_a_e;
Z80_IY[132]:=add_a_iyh;
Z80_IY[133]:=add_a_iyl;
Z80_IY[134]:=add_a_iy;
Z80_IY[135]:=add_a_a;
Z80_IY[136]:=adc_a_b;
Z80_IY[137]:=adc_a_c;
Z80_IY[138]:=adc_a_d;
Z80_IY[139]:=adc_a_e;
Z80_IY[140]:=adc_a_iyh;
Z80_IY[141]:=adc_a_iyl;
Z80_IY[142]:=adc_a_iy;
Z80_IY[143]:=adc_a_a;
Z80_IY[144]:=sub_b;
Z80_IY[145]:=sub_c;
Z80_IY[146]:=sub_d;
Z80_IY[147]:=sub_e;
Z80_IY[148]:=sub_iyh;
Z80_IY[149]:=sub_iyl;
Z80_IY[150]:=sub_iy;
Z80_IY[151]:=sub_a;
Z80_IY[152]:=sbc_a_b;
Z80_IY[153]:=sbc_a_c;
Z80_IY[154]:=sbc_a_d;
Z80_IY[155]:=sbc_a_e;
Z80_IY[156]:=sbc_a_iyh;
Z80_IY[157]:=sbc_a_iyl;
Z80_IY[158]:=sbc_a_iy;
Z80_IY[159]:=sbc_a_a;
Z80_IY[160]:=and_b;
Z80_IY[161]:=and_c;
Z80_IY[162]:=and_d;
Z80_IY[163]:=and_e;
Z80_IY[164]:=and_iyh;
Z80_IY[165]:=and_iyl;
Z80_IY[166]:=and_iy;
Z80_IY[167]:=and_a;
Z80_IY[168]:=xor_b;
Z80_IY[169]:=xor_c;
Z80_IY[170]:=xor_d;
Z80_IY[171]:=xor_e;
Z80_IY[172]:=xor_iyh;
Z80_IY[173]:=xor_iyl;
Z80_IY[174]:=xor_iy;
Z80_IY[175]:=xor_a;
Z80_IY[176]:=or_b;
Z80_IY[177]:=or_c;
Z80_IY[178]:=or_d;
Z80_IY[179]:=or_e;
Z80_IY[180]:=or_iyh;
Z80_IY[181]:=or_iyl;
Z80_IY[182]:=or_iy;
Z80_IY[183]:=or_a;
Z80_IY[184]:=cp_b;
Z80_IY[185]:=cp_c;
Z80_IY[186]:=cp_d;
Z80_IY[187]:=cp_e;
Z80_IY[188]:=cp_iyh;
Z80_IY[189]:=cp_iyl;
Z80_IY[190]:=cp_iy;
Z80_IY[191]:=cp_a;
Z80_IY[192]:=ret_nz;
Z80_IY[193]:=pop_bc;
Z80_IY[194]:=jp_nz_XXXX;
Z80_IY[195]:=jp_XXXX;
Z80_IY[196]:=call_nz_XXXX;
Z80_IY[197]:=push_bc;
Z80_IY[198]:=add_a_XX;
Z80_IY[199]:=rst_0;
Z80_IY[200]:=ret_z;
Z80_IY[201]:=ret;
Z80_IY[202]:=jp_z_XXXX;
Z80_IY[203]:=IY_CB_Pre;
Z80_IY[204]:=call_z_XXXX;
Z80_IY[205]:=call_XXXX;
Z80_IY[206]:=adc_a_XX;
Z80_IY[207]:=rst_8;
Z80_IY[208]:=ret_nc;
Z80_IY[209]:=pop_de;
Z80_IY[210]:=jp_nc_XXXX;
Z80_IY[211]:=out_XX_a;
Z80_IY[212]:=call_nc_XXXX;
Z80_IY[213]:=push_de;
Z80_IY[214]:=sub_XX;
Z80_IY[215]:=rst_16;
Z80_IY[216]:=ret_c;
Z80_IY[217]:=exx;
Z80_IY[218]:=jp_c_XXXX;
Z80_IY[219]:=in_a_XX;
Z80_IY[220]:=call_c_XXXX;
Z80_IY[221]:=IX_Pre;
Z80_IY[222]:=sbc_a_XX;
Z80_IY[223]:=rst_24;
Z80_IY[224]:=ret_po;
Z80_IY[225]:=pop_iy;
Z80_IY[226]:=jp_po_XXXX;
Z80_IY[227]:=ex_msp_iy;
Z80_IY[228]:=call_po_XXXX;
Z80_IY[229]:=push_iy;
Z80_IY[230]:=and_XX;
Z80_IY[231]:=rst_32;
Z80_IY[232]:=ret_pe;
Z80_IY[233]:=jp_iy;
Z80_IY[234]:=jp_pe_XXXX;
Z80_IY[235]:=ex_de_iy;
Z80_IY[236]:=call_pe_XXXX;
Z80_IY[237]:=ED_Pre;
Z80_IY[238]:=xor_XX;
Z80_IY[239]:=rst_40;
Z80_IY[240]:=ret_p;
Z80_IY[241]:=pop_af;
Z80_IY[242]:=jp_p_XXXX;
Z80_IY[243]:=di;
Z80_IY[244]:=call_p_XXXX;
Z80_IY[245]:=push_af;
Z80_IY[246]:=or_XX;
Z80_IY[247]:=rst_48;
Z80_IY[248]:=ret_m;
Z80_IY[249]:=ld_sp_iy;
Z80_IY[250]:=jp_m_XXXX;
Z80_IY[251]:=ei;
Z80_IY[252]:=call_m_XXXX;
Z80_IY[253]:=IY_Pre;
Z80_IY[254]:=cp_XX;
Z80_IY[255]:=rst_56;
end;
