{$i compile.inc}
unit core;

interface uses dos;

VAR   key             : array[1..127] of boolean;    {to store the keypresses}
      AnyPressed      : Boolean;
      KeyDelay        : Word;
      StartDir        : DirStr;
 JoyFound   :boolean;

 Joybuttons :byte;
 JoyAX,JoyAY:word;
 JoyBX,JoyBY:word;

 JoyMinX:word;
 JoyMaxX:word;
 JoyMinY:word;
 JoyMaxY:word;


CONST Halt_Error : String='';
      hooked     : Boolean=False;
      FramePerSecond : longint=0;                    {Actual Number of Frames}
      DosIntrCount   : Word=50;{Hz}
      OpSystem       : byte=1; {Win95=1}
      Cal_L:word=$FFFF;       {rect containing calibration extent of 'center'}
      Cal_T:word=$FFFF;
      Cal_R:word=0;
      Cal_B:word=0;

      KeyName : array[1..83] of string[10] = (
           'Esc','1','2','3','4','','6','7','8','9','0','_','=','BckSpace',
           'Tab','Q','W','E','R','T','Y','U','I','O','P','[',']','Return',
           'Ctrl','A','S','D','F','G','H','J','K','L',';','"','`','Left Shift',
           '\','Z','X','C','V','B','N','M',',','.','/','Right Shift','*',
           'AlT','Space','Caps Lock','F1','F2','F3','F4','F5','F6','F7','F8',
           'F9','F10','Num Lock','Scroll Lock','Home','Up','Pg Up','-','Left',
           '5','Right','+','End','Down','Pg Down','Ins','Del');

      EscKey = 1;
      Down   = 80;
      Up     = 72;
      Left   = 75;
      Right  = 77;
      CTRL   = 29;
      ALT    = 56;
      RETURN = 28;


PROCEDURE Settimer(frqdiv:longint);

procedure ReadJoystick;
Procedure InitJoyStick;
Function JoyUp:Boolean;
Function JoyDown:Boolean;
Function JoyLeft:Boolean;
Function JoyRight:Boolean;
Function JoyA:boolean;
Function JoyB:boolean;
Function JoyC:boolean;
Function JoyD:boolean;
PROCEDURE DEBUG(S:STRING);
PROCEDURE Delay(ms : Word);                                        {CPU-Delay}

PROCEDURE InitInt09(Spectrum:Boolean);          {Initializes Keyboard-Handler}
PROCEDURE RestoreInt09;                   {Restores Original Keyboard-Handler}
FUNCTION ReadKey: Char;
FUNCTION KeyPressed: Boolean;

PROCEDURE NextFrame;                           {counting the number of frames}
PROCEDURE ResetFPS;                               {Resetting the framecounter}

PROCEDURE InitNew(s:string);
PROCEDURE DisplayNew(s:String);
PROCEDURE WriteCentered(txt:String;yPos:word);
FUNCTION byte2hex (W : Byte) : String;
FUNCTION word2hex (W : Word) : String;

function downcase(s: String):String;
function i2s(i:Longint;j: Byte;C:Char):String;
function delback(s: String;welcher: ShortInt):String;

IMPLEMENTATION
USES Crt,Vars;

VAR FrameCount     : longint;
    time           : longint Absolute $46c; {Timer}

CONST StartTimer     : longint = 0;
      EndTimer       : longint = 0;
      TIMEOUT        : word = 5;               {number of interrupts pr frame}
      OldInt09       : pointer=NIL;                    {old keyboard interupt}
      OldExit        : pointer=NIL;
      rktemp         : Char=#0;
{------------------------------------------------}
 PROCEDURE DEBUG(S:STRING);
 var f:text;
 begin
  assign(f,startdir+'debug.txt');
  {$i-}
   reset(f);
   if ioresult<>0 then rewrite(f);
   close(f);
  {$i+}
  append(f);
  writeln(f,s);
  close(f);
 end;

 function downcase(s: String):String;
 var i: integeR;
 begin
  for i:=1 to length(s) do
   if s[i] in ['A'..'Z'] then s[i]:=chr(ord(s[i])+32);
  downcase:=s;
 end;

 function i2s(i:Longint;j: Byte;C:Char):String;
 var s: string;
  begin
   str(i,s); while length(s)<j do s:=c+s; i2s:=s;
  end;

 function delback(s: String;welcher: ShortInt):String;
 var i,j,anzback,pos: integer;
 begin
  anzback:=0; for i:=1 to length(s) do if s[i]='\' then inc(anzback);
  if (welcher>0) and (welcher<anzback) then anzback:=welcher;
  pos:=0;j:=0; for i:=1 to length(s) do if s[i]='\' then
   begin inc(j);if j=anzback then pos:=i;end;
  if pos>0 then delback:=copy(s,1,pos);
 end;
{------------------------------------------------}

procedure SetTimer(frqdiv : longint);
var izaehler : word;
    wintick,Divisor : real;
begin
  if FrqDiv=$FFFF then
  begin
   asm cli end;
   port[$43] := $36;
   port[$40] := $FF;
   port[$40] := $FF;
   asm sti end;
   exit;
  end else
  begin
   asm cli end;
   divisor:=frqdiv;
   if OpSystem=1 then {Window Mode}
    if FrqDiv > 1000 then begin
       WinTick := 1 + trunc (FrqDiv / 1000);
       Divisor := Divisor / WinTick;
     end;
   if FrqDiv>65535 then izaehler:=0 else izaehler := trunc($1234DD/divisor);
   port[$43] := $36;
   port[$40] := lo(izaehler);
   port[$40] := hi(izaehler);
   asm sti end;
  end;
end;

(* Joystick *****************************************************************)
(*procedure ReadJoystick; assembler; { code from PC64 }
 asm
 cli
  cmp JoyFound,False
  je  @TimeOut
  mov dx,201h
  in  al,dx          { read buttons and idle state }
 jmp @Flush
 @Flush:
  out dx,al         { start measurement }
  xor ah,ah
  mov JoyButtons,al
  and al,00001111b
  mov bl,al         { BL = idle state }
  mov cx,10

  @WaitInit:
   in AL,61h         { wait until counters are on }
  loop @WaitInit

  mov ah,00001111b  { all counters are initially on }
  @Next:
   inc cx            { increment loop counter }
   jz @TimeOut       { timeout at 65536 loops }
   in AL,DX          { read state }
   and AL,00001111b
   xor AL,AH         { AL = bits who have changed }
  jz @Next
   test AL,0001b     { check directions and store loop counter }
   je @NoAX
   mov JoyAX,CX
  @NoAX:
   test AL,0010b
   je @NoAY
   mov JoyAY,CX
  @NoAY:
   test AL,0100b
   je @NoBX
   mov JoyBX,CX
  @NoBX:
   test AL,1000b
   je @NoBY
   mov JoyBY,CX
  @NoBY:
   xor AH,AL         { set new state }
   cmp AH,BL         { idle state reached? }
  jne @Next

 jmp @Return
 @TimeOut:
   mov JoyAX,0
   mov JoyAY,0
   mov JoyBX,0
   mov JoyBY,0
  @Return:
  sti
 end;*)

procedure ReadJoystick;
var j,idle,value:Byte;
    i:Word;
label ende;
begin
 asm cli end;
 if not joyfound then
  begin joyax:=0;joybx:=0;joyay:=0;joyby:=0;goto ende;end;

  joybuttons:=PORT[$201];
  port[$201]:=joybuttons;
  idle:=joybuttons and 15;
  { for k:=1 to 10 do value:=port[$61];}

  j:=15;
  for i:=0 to $FFFF do
  begin
   value:=(port[$201] and 15) xor j;
   if value<>0 then
    begin
     if value and 1>0 then joyax:=i;
     if value and 2>0 then joyay:=i;
     if value and 4>0 then joybx:=i;
     if value and 1>0 then joyby:=i;
     j:=j xor value;
     if j=idle then goto ende;
    end;
  end;
 joyax:=0;joybx:=0;joyay:=0;joyby:=0;
 ende:
 asm sti end;
end;


Procedure InitJoyStick;
 Var
  Status:byte;
  dx,dy:word;
 begin
  JoyButtons:=$ff;
  JoyMinX:=0;
  JoyMaxX:=0;
  JoyMinY:=0;
  JoyMaxY:=0;

  Status:=Port[$201];
  {JoyFound:=(Status=$FC)or(Status=$F0);}
  JoyFound:=Status in [$F0..$FC];
  if JoyFound then begin
   ReadJoystick;
   JoyFound:=(JoyAX>0)and(JoyAY>0);
   if JoyFound then begin
    dx:=(5*JoyAX) div 16;
    dy:=(5*JoyAY) div 16;
    JoyMinX:=JoyAX-dx;
    JoyMaxX:=JoyAX+dx;
    JoyMinY:=JoyAY-dy;
    JoyMaxY:=JoyAY+dy;
   end;
  end;

 end;

Function JoyUp:Boolean;    begin JoyUp:=JoyAY<JoyMinY; end;
Function JoyDown:Boolean;  begin JoyDown:=JoyAY>JoyMaxY; end;
Function JoyLeft:Boolean;  begin JoyLeft:=JoyAX<JoyMinX; end;
Function JoyRight:Boolean; begin JoyRight:=JoyAX>JoyMaxX; end;
Function JoyA:boolean; begin JoyA:=(JoyButtons and $10)=0 end;
Function JoyB:boolean; begin JoyB:=(JoyButtons and $20)=0 end;
Function JoyC:boolean; begin JoyC:=(JoyButtons and $40)=0 end;
Function JoyD:boolean; begin JoyD:=(JoyButtons and $80)=0 end;

Procedure Delay(ms : Word); Assembler;
Asm
 mov ax, 1000;
 mul ms;
 mov cx, dx;
 mov dx, ax;
 mov ah, 86h;
 int 15h;
end;

(* Keyboard *****************************************************************)

function  ReadKey:char;
var     k:char;
begin
  if rktemp<>#0 then begin
    ReadKey:=rktemp;
    rktemp:=#0;
  end else begin
    asm
      sub ah,ah
      int 16h
      mov k,al
      cmp al,1
      sbb al,al
      and al,ah
      mov rktemp,al
    end;
    ReadKey:=k;
  end;
end;


function  Keypressed:boolean;
var k:boolean;
begin
  asm
    mov ah,1
    mov k,false
    int 16h
    jz @@1
    mov k,true
@@1:
  end;
  Keypressed:=k;
end;

PROCEDURE RestoreInt09;
BEGIN
  if hooked then SetIntVec($09, OldInt09);
  OldInt09:=Nil;hooked:=false;
END;

PROCEDURE SpectrumInt09;
var j:byte;
Begin
  j:=port[$60];
  if j <> $E0 then begin
    if j > 127 then
     begin
      Key[j and 127]:=false;
      anypressed:=false;
     end else
      begin
       Key[j]:=true;
       anypressed:=true;
      end;
  end;
  port[$61]:=port[$61] or $80;
  port[$61]:=port[$61] and $7F;
  port[$20]:=$20;
{------------------------------------ Spectrum part -------------------------}
  for j:=0 to 7 do skey[j]:=$FF;
  {if not anypressed then exit;}
    if key[14] then {Backslash}
     begin
     Skey[0]:=Skey[0] and $fe;
     Skey[4]:=Skey[4] and $fe;
     end;
    if key[29] then {Ctrl}
     begin
     Skey[0]:=Skey[0] and $fe;
     Skey[7]:=Skey[7] and $fd;
     end;
    if key[1] then {Escape = Edit}
     begin
      Skey[0]:=Skey[0] and $fe;
      Skey[3]:=Skey[3] and $fe;
     end;
    if key[72] then {Up}
     begin
      Skey[0]:=Skey[0] and $fe;
      Skey[4]:=Skey[4] and $f7;
     end;
    if key[80] then {Down}
     begin
      Skey[0]:=Skey[0] and $fe;
      Skey[4]:=Skey[4] and $ef;
     end;
    if key[75] then {Left}
     begin
      Skey[0]:=Skey[0] and $fe;
      Skey[3]:=Skey[3] and $ef;
     end;
    if key[77] then {Right}
     begin
      Skey[0]:=Skey[0] and $fe;
      Skey[4]:=Skey[4] and $fb;
     end;

    if (key[42]) or (key[54]) then skey[0] := skey[0] and $FE;{Lshift}
    if key[44] then skey[0] := skey[0] and $FD;{Y bzw. Z}
    if key[45] then skey[0] := skey[0] and $FB;{X}
    if key[46] then skey[0] := skey[0] and $F7;{C}
    if key[47] then skey[0] := skey[0] and $EF;{V}
    if key[30] then skey[1] := skey[1] and $FE;{A}
    if key[31] then skey[1] := skey[1] and $FD;{S}
    if key[32] then skey[1] := skey[1] and $FB;{D}
    if key[33] then skey[1] := skey[1] and $F7;{F}
    if key[34] then skey[1] := skey[1] and $EF;{G}
    if key[16] then skey[2] := skey[2] and $FE;{Q}
    if key[17] then skey[2] := skey[2] and $FD;{W}
    if key[18] then skey[2] := skey[2] and $FB;{E}
    if key[19] then skey[2] := skey[2] and $F7;{R}
    if key[20] then skey[2] := skey[2] and $EF;{T}
    if key[02] then skey[3] := skey[3] and $FE;{1}
    if key[03] then skey[3] := skey[3] and $FD;{2}
    if key[04] then skey[3] := skey[3] and $FB;{3}
    if key[05] then skey[3] := skey[3] and $F7;{4}
    if key[06] then skey[3] := skey[3] and $EF;{5}
    if key[11] then skey[4] := skey[4] and $FE;{0}
    if key[10] then skey[4] := skey[4] and $FD;{9}
    if key[09] then skey[4] := skey[4] and $FB;{8}
    if key[08] then skey[4] := skey[4] and $F7;{7}
    if key[07] then skey[4] := skey[4] and $EF;{6}
    if key[25] then skey[5] := skey[5] and $FE;{P}
    if key[24] then skey[5] := skey[5] and $FD;{O}
    if key[23] then skey[5] := skey[5] and $FB;{I}
    if key[22] then skey[5] := skey[5] and $F7;{U}
    if key[21] then skey[5] := skey[5] and $EF;{Y bzw. Z}
    if key[28] then skey[6] := skey[6] and $FE;{ENTER}
    if key[38] then skey[6] := skey[6] and $FD;{L}
    if key[37] then skey[6] := skey[6] and $FB;{K}
    if key[36] then skey[6] := skey[6] and $F7;{J}
    if key[35] then skey[6] := skey[6] and $EF;{H}
    if key[57] then skey[7] := skey[7] and $FE;{SPACE}
    if key[56] then skey[7] := skey[7] and $FD;{ALT}
    if key[50] then skey[7] := skey[7] and $FB;{M}
    if key[49] then skey[7] := skey[7] and $F7;{N}
    if key[48] then skey[7]  :=skey[7] and $EF;{B}
    if not usestick then
     with joykeys do
     begin
      stickvalue:=0;
      if key[up] then stickvalue:=stickvalue or $08;
      if key[down] then stickvalue:=stickvalue or $04;
      if key[left] then stickvalue:=stickvalue or $02;
      if key[right] then stickvalue:=stickvalue or $01;
      if key[fire] then stickvalue:=stickvalue or $10;
     end;
End;

PROCEDURE NewInt09;
{Same as above but without Spectrum-Part}
var j:byte;
Begin
 j:=port[$60];
  if j <> $E0 then begin
    if j > 127 then
     begin
      Key[j and 127]:=false;
      anypressed:=false;
     end else
      begin
       Key[j]:=true;
       anypressed:=true;
      end;
  end;
  port[$61]:=port[$61] or $80;
  port[$61]:=port[$61] and $7F;
  port[$20]:=$20;
end;

PROCEDURE InitInt09(Spectrum:Boolean);
VAR n : byte;
BEGIN
  AnyPressed:=False;
  for n:=1 to 127 do key[n]:=false;
  if not hooked then begin
    hooked:=true;
    GetIntVec($9,oldint09);
    if Spectrum then
     SetIntVec( $09, @SpectrumInt09) else
     SetIntVec( $09, @NewInt09);
  end;
END;

(* Framecounter *************************************************************)
PROCEDURE NextFrame;
BEGIN
  {=-=-=- See if FPS counter was initialised -=-=-=}
  if StartTimer=0 then begin
     FrameCount:=0;
     if OPsystem=1 then
         StartTimer:=time          { Windows Mode }
     else
         StartTimer:=time*timeout; { DOS Mode }
     EndTimer:=0;
  end;
  inc(FrameCount);
  if OPsystem=1 then
      EndTimer:=time              { Windows Mode }
  else
      EndTimer:=Time*timeout;     { DOS Mode }

  if EndTimer>StartTimer then
      FramePerSecond:=round(FrameCount*18.2/(EndTimer-StartTimer));

END;

PROCEDURE ResetFPS;
BEGIN
 FrameCount:=0;
 if OPsystem=1 then
    StartTimer:=time          { Windows Mode }
 else
    StartTimer:=time*timeout; { DOS Mode }
 EndTimer:=0;
END;

function win95:Boolean;assembler;
asm
  mov    ax,4680h
  int    2Fh
end;

(* Startup stuff ************************************************************)

PROCEDURE TWRITE(x,y:word;text:string;col1,col2:byte);
var attr,i:byte;
    offs:word;
begin
 Offs:=((y-1)*160+(x shl 1-2));
 attr:=col1+col2 shl 4;
 for i:=1 to length(text) do
  begin
   memw[$b8000+offs]:=ord(text[i])+attr shl 8;
   inc(offs,2);
  end;
end;

PROCEDURE NewExit;
var i         : byte;
    time      : integer;
    hh        : byte;
    mm        : byte;
    ss        : byte;
    eradr     : string;
    Halt_Proc : string;

    FUNCTION Ptr2hex(adr:pointer):string;
    VAR tmp : string;
        tw  : word;
        value  : word;
    BEGIN
      value:=(longint(adr) shr 16);
      tmp:=word2hex(value);
      value:=(longint(adr) mod 65536);
      tmp:=tmp+':'+word2hex(value);
      ptr2hex:=tmp;
    END;
var error_in:String;
BEGIN
  ExitProc:=OldExit;
  asm
    xor ax,ax
    mov ah,0fh;
    int 10h;
    cmp al,3
    jz @ende;
    mov ax,3
    int 10h;
   @ende:
  end;

  Error_In:=Halt_Error;
  Halt_Proc:='System Error';
  if ErrorAddr<>nil then begin
     Halt_Proc:='RunTime Error';
     Case ExitCode of
       2 : Halt_Error:='(2) File Not Found';
       3 : Halt_Error:='(3) Path Not Found';
     100 : Halt_Error:='(100) Disk Read Error';
     101 : Halt_Error:='(101) Disk Write Error';
     103 : Halt_Error:='(103) File Not Open (programmers fault)';
     200 : Halt_Error:='(200) Division by Zero';
     201 : Halt_Error:='(201) Range Check Error (programmers fault)';
     202 : Halt_Error:='(202) Stack overflow Error (programmers fault)';
     203 : Halt_Error:='(203) Heap Overflow error (programmers fault)';
     204 : Halt_Error:='(204) Invalid pointer operation (programmers fault)';
     216 : Halt_Error:='(216) General Protection fault';
     else Halt_Error:=i2s(ExitCode,0,' ');
    end;
     eradr:=ptr2hex(ErrorAddr);
     halt_error:=halt_error+'  (ADR='+eradr+')';
     ErrorAddr:=NIL;
  end else halt_error:='';


  if halt_error<>'' then begin

   twrite(1,2,'ͻ',7,0);
   twrite(1,3,'Error type  :                                                                 ',7,0);
   twrite(1,4,'Error in    :                                                                 ',7,0);
   twrite(1,5,'Error MSG   :                                                                 ',7,0);
   twrite(1,6,'ͼ',7,0);

   Twrite(16,3,Halt_proc,7,0);
   if error_in<>'' then TWrite(16,4,Error_in,7,0);
   Twrite(16,5,Halt_Error,7,0);

   window(1,7,80,25);
   clrscr;
  end;

 if oldint09<>NIL then RestoreInt09;
 if oldexit<>nil then asm call oldexit end;
END;

PROCEDURE InitNew(s:string);
BEGIN
  writeln('Initialising '+s+'...');
END;

PROCEDURE DisplayNew(s:String);
BEGIN
  writeln('    ',s);
END;

PROCEDURE WriteCentered(txt:String;yPos:word);
BEGIN
 Gotoxy(40-(length(txt) shr 1)-1,ypos);
 if ypos=25 then write(txt) else writeln(txt);
END;

Const h     : String = ('0123456789ABCDEF');

FUNCTION byte2hex (W : Byte) : String;
BEGIN
  byte2hex := h [W Div 16 + 1] + h [W Mod 16 + 1];
END;

FUNCTION word2hex (W : Word) : String;
BEGIN
  word2hex := byte2hex (Hi (W) ) + byte2hex (Lo (W) );
END;

(* Initialisation **********************************************************)
PROCEDURE INITCore;
var N: NameStr;
    E: ExtStr;

BEGIN
 InitNew('CORE ');
 if win95 then opsystem:=1 else opsystem:=0;
 Displaynew('Joystick ');
 InitJoyStick;

 FSplit(Paramstr(0), startdir, N, E);
 if startdir[length(startdir)]<>'\' then startdir:=startdir+'\';

  oldexit:=ExitProc;
  if oldExit<>exitProc then begin
     DisplayNew('* Error, unable to find old exit adress..');
     system.halt;
  end;
  ExitProc:=@NewExit;
END;

begin
 initcore;
end.
