unit DPMI;

interface uses DOS;

type DosMem=record
             Segment,Offset:Word;
             LinearAddress:Longint;
             DSize:Longint;
             Selector:Longint;
            end;

function GetDosMem(Var DM:Dosmem;MSize: longint):Boolean;
function FreeDosMem(Var DM:Dosmem):Boolean;
function ResizeDosMem(var DM:DosMem;sz: longint):Boolean;
procedure SimulateInterrupt(IntNum: byte; var regs: registers);

Function Get_Linear_Addr(MBase: longint; MSize: longint):Longint;
Procedure Free_Linear_Addr(DAddress:Longint);assembler;

implementation

Function Get_Linear_Addr(MBase: longint; MSize: longint):Longint;
Var Daddress:Longint;
begin
   asm
      push ebx
      push esi
      push edi
      mov  ecx, Mbase
      shld ebx, ecx, 16
      mov  edi, MSize
      shld esi, edi, 16
      mov  eax, 800h
      int  31h
      jnc  @@00
@@00:
      shl  ecx, 16
      shld ebx, ecx, 16
      mov  [DAddress], ebx
{     mov  [DSize], edi}
      pop  edi
      pop  esi
      pop  ebx
   end;
   Get_Linear_Addr:=DAddress;
end;

Procedure Free_Linear_Addr(DAddress:Longint);assembler;
asm
      push ebx
      mov  ecx, [DAddress]
      shld ebx, ecx, 16
      mov  eax, 801h
      int  31h
      jnc  @@00
@@00:
      pop  ebx
end;

procedure SimulateInterrupt(IntNum: byte; var regs: registers);
begin
   regs.ss:= 0;
   regs.sp:= 0;
   regs.flags:= 0;
   asm
      push ebx
      push edi
      mov  bl, IntNum
      mov  ax, 300h
      sub  ecx, ecx
      mov  edi, regs
      int  31h
      pop  edi
      pop  ebx
   end;
end;

function GetDosMem(Var DM:Dosmem;MSize: longint):Boolean;
var error:boolean;
begin
   asm
      push ebx
      push edx
      mov  ebx, MSize
      add  ebx, 15
      and  ebx, $FFFF0
      mov  ecx, DM
      mov  [ecx][DosMem.DSize], ebx
      shr  ebx, 4
      mov  eax, 100h
      int  31h
      jnc  @@00
      mov  error, true
@@00:
      shl  eax, 4
      mov  [ecx][DosMem.Selector], edx
      mov  [ecx][DosMem.LinearAddress], eax
      pop  edx
      pop  ebx
   end;
   GetDosMem:=Error;
   with DM do
    begin
     Segment:=LinearAddress shr 4;
     Offset:=LinearAddress-((LinearAddress shr 4) shl 4);
    end;
end;

function FreeDosMem(Var DM:Dosmem):Boolean;
var error: boolean;
begin
   error:=false;
   asm
      push edx
      mov  edx, DM
      mov  edx, [edx][DosMem.Selector]
      mov  eax, 101h
      int  31h
      jnc  @@00
      mov  error, true
@@00:
      pop  edx
   end;
   FreeDosmem:=error;
end;

function ResizeDosMem(var DM:DosMem;sz: longint):Boolean;
var error: boolean;
begin
   error:=false;
   asm
      push ebx
      mov  ebx, sz
      add  ebx, 15
      shr  ebx, 4
      mov  eax, 102h
      int  31h
      jnc  @@00
      mov  error, true
      jmp  @@01
@@00:
      shl  ebx, 4
      mov  ecx, DM
      mov  [ecx][DosMem.DSize], ebx
@@01:
      pop  ebx
   end;
   ResizeDosmem:=error;
end;

end.
