unit lfn;

interface

Type

 TLSearchRec=record
  Attr:longint;
  CreationTime,LastAccessTime,LastModTime:record lo,hi:longint;end; { See below for conversion }
  HiSize,LoSize:longint;
  Reserved:comp;
  Name:array[0..259] of char;
  ShortName:array[0..13] of char; { Only if longname exists }
  Handle:word;
 end;

function LFindFirst(FileSpec:string; Attr:word; var SRec:TLSearchRec):word;
function LFindNext(var SRec:TLSearchRec):word;
function LFindClose(var SRec:TLSearchRec):word;
Function DRVList:String;

implementation
uses DOS,dpmi;

function StrLen(Str:Pchar):Longint;
var i:Longint;
begin
 i:=0;while str[i]<>#0 do inc(i);
 result:=I;
end;

function LFindFirst(FileSpec:string; Attr:word; var SRec:TLSearchRec):word;
{ Search for files }
var regs:registers;
    dm,LF:DosMem;
    len:longint;
begin
 FileSpec:=FileSpec+#0;
 len:=length(FileSpec); {Strlen(FileSpec);}
 getdosmem(DM,sizeof(TLSearchRec));
 getdosmem(LF,Len);

 move(FileSpec[1],pointer(LF.LinearAddress)^,len);
 regs.ds:=LF.segment;
 regs.edx:=LF.offset;

 regs.es:=DM.segment;
 regs.edi:=DM.offset;
 regs.ecx:=Attr;
 regs.si:=0;
 regs.ax:=$714e;
 SimulateInterrupt($21,regs);
 Move(pointer(DM.LinearAddress)^,SRec,Sizeof(TLSearchRec));
 freedosmem(DM);freedosmem(LF);

 Srec.Handle:=Regs.AX;
 if (regs.flags and $001 {carryflag}) <> 0 then
  doserror:=integer(regs.ax) else doserror:=0;
end;

function LFindNext(var SRec:TLSearchRec):word;
var regs:registers;
    DM:DosMem;
begin
 GetDosMem(DM,sizeof(TLSearchRec));
 Move(Srec,pointer(DM.LinearAddress)^,sizeof(TLSearchRec));

 regs.ax:=$714f;
 regs.si:=0;
 regs.es:=DM.segment;
 regs.di:=DM.offset;
 regs.bx:=Srec.Handle;
 SimulateInterrupt($21,regs);

 Move(pointer(DM.LinearAddress)^,SRec,Sizeof(TLSearchRec));
 FreeDosMem(DM);
 if (regs.flags and $001 {carryflag}) <> 0 then
  doserror:=integer(regs.ax) else doserror:=0;
end;

function LFindClose(var SRec:TLSearchRec):word;
{ Free search handle }
var regs:registers;
begin
 regs.ax:=$714f;
 regs.bx:=srec.handle;
 SimulateInterrupt($21,regs);

 if (regs.flags and $001 {carryflag}) <> 0 then
  doserror:=integer(regs.ax) else doserror:=0;
end;

function DRVList:String;
var regs:registers;
    drv:string[2];
    drives:string;
    dm:dosmem;
begin
 drv:='A:'+#0;drives:='';
 getdosmem(dm,3);
 repeat
  move(drv[1],pointer(dm.linearaddress)^,length(drv));

  regs.ds:=dm.segment;
  regs.si:=dm.offset;
  regs.ax:=$2906;
  Simulateinterrupt($21,regs);

  if regs.al=0 then drives:=drives+drv[1];
  inc(byte(drv[1]));

 until drv[1]>'Z';
 freedosmem(dm);
 DrvList:=drives;
end;

end.