{$i compile.inc}
unit machine;

interface uses vars;

const
    inport:function(port_hi, port_lo:Byte):Byte=NIL;
    outport:procedure(portnum:word;val:Byte)=NIL;
    speekb:function (Addr:Word):Byte=NIL;
    spokeb:procedure (addr:Word;val:Byte)=NIL;

    Machine_reset: procedure = NIL;
    Machine_nmi: procedure = NIL;
    Machine_hooktrd: procedure = NIL;
    Machine_InitPages: procedure = NIL;

    SP_SCREEN    : pmem=NIL;

    RAM          : array[0..15] of pmem=(NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,
                                        NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL);
    SRAM         : array[0..3] of pmem=(NIL,NIL,NIL,NIL);
    ROM          : array[0..5] of pmem=(NIL,NIL,NIL,NIL,NIL,NIL); {4=MF128,5=MF3}

    {Display/ULA/Memory constants}

    Max_V_line         : Word = 311;
    t_states_per_line  : Word = 228;
    t_state            : Word = 0;
    ula_delay          : Word = 0;
    cpu_delay          : Word = 0;
    last_7ffd          : Byte = 0;
    last_1ffd          : Byte = 0;
    last_fffd          : Byte = 0;
    line_counter       : Longint = 0;

type ZXModels=(mZX48,mZX128,mZXPlus2,mZXPlus3,mDidaktik,mPentagon,mScorpion,mUser,mMF128,mMF3,mTRDOS);

const
    Model : ZXModels=mPentagon;
    UserROM: String='';
    UserRomTyp: ZXModels=mZX48;

var contended: array[0..7]of byte;

procedure closemem;
procedure initmem;
procedure set_spectrum_mode(mode:ZXModels);
function GetRomChecksum(ROM:Pointer;Length:Longint):Longint;
procedure debugmem;

implementation
uses core,dos,z80cpu,spec48,spec128,plus2,plus3,pentagon,
     scorpion,didaktik,mf3;

procedure debugmem;
var i,j:byte;
begin
 for j:=low(sram) to high(sram) do
  begin
   for i:=low(rom) to high(rom) do
    if sram[j]=rom[i] then debug('SRAM['+i2s(j,0,'0')+']:=ROM['+i2s(i,0,'0')+'];');
  for i:=low(rAm) to high(rAm) do
    if sram[j]=rAm[i] then debug('SRAM['+i2s(j,0,'0')+']:=RAM['+i2s(i,0,'0')+'];');
  end;
 debug('last_7ffd:='+word2hex(last_7ffd)+';');
 debug('last_1ffd:='+word2hex(last_1ffd)+';');
 debug('pc:='+word2hex(pc.w)+';');
end;

function not_a_rom(Segm:Byte):Boolean;
var i:byte;
    IsRom:Boolean;
begin
 for i:=low(ROM) to High(ROM) do begin isrom:=(rom[i]=SRAM[Segm]);if isrom then break; end;
 not_a_rom:=not IsRom;
end;

procedure AllocFree(var ROM:Pmem);
begin
 if ROM<>NIL then freemem(Rom,sizeof(tmem));
 rom:=NIL;
end;

procedure MemAlloc(var ROM:pmem;S:String;x:Byte);
var xs:string;
begin
 if x=0 then xs:='' else xs:='['+i2s(x,1,' ')+']';
 halt_error:='cannot allocate memory for Spectrum '+s+xs;
 Getmem(Rom,sizeof(tmem));
 if not assigned(rom) then system.halt;
end;

procedure initmem;
var x: byte;
    s:String;
begin
	for x:=low(ram) to high(ram) do MemAlloc(ram[x],'RAM ',x);
        for x:=low(rom) to high(rom) do memAlloc(rom[x],'ROM ',x);
	SRAM[1]:=RAM[5];
        SRAM[2]:=RAM[2];
        SRAM[3]:=RAM[0];
        SP_SCREEN:=RAM[5];
        mf128init('mf128.rom');
        mf3init('mfplus3.rom');
end;

procedure closemem;
var x: byte;
begin
 for x:=low(ram) to high(ram) do allocfree(ram[x]);
 for x:=low(rom) to high(rom) do allocfree(rom[x]);
end;

function GetFileSize(S:String):Longint;
var f:file;
begin
 {$i-}
 assign(f,s);reset(f,1);
 getFileSize:=FileSize(f);
 close(f);
 {$i+}
end;

procedure set_spectrum_mode(mode:ZXModels);
var dummy:byte;
    size:longint;
    old:ZXModels;
begin
 old:=model;
 model:=mode;

  inport:=NIL;
  outport:=NIL;
  speekb:=NIL;
  spokeb:=NIL;
  Machine_reset:= NIL;
  Machine_nmi:= NIL;
  Machine_hooktrd:= NIL;
  Machine_InitPages:= NIL;

//  for dummy:=0 to 3 do SRAM[dummy]:=NIL;
//  for dummy:=low(rOm) to high(rOm)-2 do fillchar(rom[dummy]^,sizeof(tmem),0);
//  for dummy:=low(ram) to high(ram) do if dummy<>5 then fillchar(ram[dummy]^,sizeof(tmem),0);
  z80_reset;

 case mode of
  mzx48: spec48init(startdir+'48.rom');
  mzx128: spec128init(startdir+'128.rom');
  mzxplus2: specplus2init(startdir+'plus2.rom');
  mzxplus3: specplus3init(startdir+'plus3.rom');
  mpentagon: pentagoninit(startdir+'pentagon.rom',startdir+'trdos.rom');
  mscorpion: scorpioninit(startdir+'scorpion.rom');
  mDidaktik: Didaktikinit(startdir+'didaktik.rom');
  mUser: begin
          case UserROMtyp of
           mZX48: spec48init(userrom);
           mZX128: spec128init(userrom);
           mZXplus2: specplus2init(userrom);
           mZXplus3: specplus3init(userrom);
           mPentagon: pentagoninit(userrom,startdir+'trdos.rom');
           mscorpion: scorpioninit(userrom);
           mDidaktik: DidaktikInit(userrom);
           (*mMF128: begin
                    mf128init(userrom);
                    if old<>mUser then set_spectrum_mode(old) else
                     set_spectrum_mode(mpentagon);
                   end;
           mMF3: begin
                    mf3init(userrom);
                    if old<>mUser then set_spectrum_mode(old) else
                     set_spectrum_mode(mpentagon);
                   end;*)
           mTRDOS: pentagoninit(startdir+'pentagon.rom',userrom);
         end;
        end;
 end;
 machine_reset;
end;

function GetRomChecksum(ROM:Pointer;Length:Longint):Longint;
var checksum:longint;
    tmp,i:Word;
begin
 checksum:=0;
  for i:= 0 to length-1 do
  begin
   tmp:= checksum and 1;
   checksum:=checksum shr 1;
   if tmp>0 then checksum:=checksum or $8000;
   checksum:=checksum xor (mem[longint(ROM^)+i]);
  end;
 GetRomChecksum:=checksum;
end;


begin
 InitNew('$Id: machine.pas (Virtual Machine Driver),v 1.1');
end.
