unit mf3;

interface

function inMF128(port_lo:Byte):Byte;
function inMF3(port_hi,port_lo:Byte):Byte;

procedure mf3init(romname:String);
procedure mf128init(romname:String);

implementation uses core,vars,machine;

function inMF128(port_lo:Byte):Byte;
begin
 case port_lo of
 63: (* Mf 128 Page Out *)
     begin
      {outport(32765,last_7ffd);}
      SRAM[0]:=ROM[(last_7ffd and 16) shr 4];
      inMF128:=$FF;
     end;
 191: (* Mf 128 Page In *)
      begin
       SRAM[0]:=ROM[4];
       if last_7ffd and 8>0 then inMF128:=255 else inMF128:=127;
      end;
 end;
end;

function InMF3(port_hi,port_lo:Byte):Byte;
begin
 case port_lo of
  191: 	if (Last_1FFD and 1=0) and (SRAM[0]=rom[5]) then
  	SRAM[0]:=ROM[(((Last_7FFD and 16) shr 4) or
	    	     ((Last_1FFD and 4) shr 1))];
  63: case port_hi of
        $7f: InMF3:=Last_7FFD;
        $1f: InMF3:=Last_1FFD;
       else if (SRAM[0]<>rom[5]) and (Last_1FFD and 1=0) then SRAM[0]:=rom[5];
      end;
 end;
end;

procedure mf128init(romname:String);
var f:file;
    numread:integer;
begin
 halt_error:='loading mf128 rom ('+romname+')';
 assign(f,romname);reset(f,1);
 fillchar(rom[4]^,sizeof(tmem),0);
 blockread(f,rom[4]^,sizeof(tmem),numread);
 close(f);
end;

procedure mf3init(romname:String);
var f:file;
    numread:integer;
begin
 halt_error:='loading mf3 rom ('+romname+')';
 assign(f,romname);reset(f,1);
 fillchar(rom[5]^,sizeof(tmem),0);
 blockread(f,rom[5]^,sizeof(tmem),numread);
 close(f);
end;

end.
