{
 ROM 0 = 128k    ROM
 ROM 1 = Basic   ROM
 ROM 2 = Service ROM
 ROM 3 = TRDOS   ROM
}

unit scorpion;

interface

procedure scorpioninit(romname:String);

implementation

uses core,vars,machine,z80CPU,sndDrv,trdos;

const version:string = 'scorpion.pas,v 1.0';

procedure open_rom_scorpion(romname:String);
var f: file;
    numread:longint;
begin
 assign(f,romname);reset(f,1);
 blockread(f,ROM[0]^,16384,numread);
 blockread(f,ROM[1]^,16384,numread);
 blockread(f,ROM[2]^,16384,numread);
 blockread(f,ROM[3]^,16384,numread);
 close(f);
end;
{$f+}

function scorpionReadMem(Addr:Word):Byte;
begin
 scorpionReadMem:=SRAM[(addr and $C000) shr 14]^[addr and $3FFF]
end;

procedure scorpionWriteMem(addr:word;val:Byte);
var segm:Word;
begin
 segm:=(addr and $C000) shr 14;
 if (segm>=0) or (SRAM[segm]=ROM[2]) then SRAM[segm]^[addr and $3FFF]:=val;
end;

procedure scorpionHookTRD;
begin
   if (pc.w>=$4000) and (sram[0]=ROM[3]) then
    SRAM[0]:=ROM[1]{(last_7ffd and 16) shr 4]}
   else
    if ((pc.w and $ff00)=$3d00) and (sram[0]=ROM[1]) then
     SRAM[0]:=ROM[3];
end;

procedure scorpionInitPages;
begin
        SRAM[0]:=ROM[0];
	SRAM[1]:=RAM[5];
	SRAM[2]:=RAM[2];
	SRAM[3]:=RAM[0];
        SP_SCREEN:=RAM[5];
end;

procedure scorpionReset;
begin
	Z80_Reset;
        scorpionInitPages;
end;

function scorpionInPort(port_hi, port_lo:Byte):Byte;
var i,data: byte;
begin
     if ((sram[0]=ROM[2]) or (sram[0]=ROM[3])) and (port_lo and 31>0) then
      begin
        i:=(port_lo shr 4) and $e;
        if i<8 then diskvg(i,data) else
        if i=$E then diskvg(8,data);
        scorpionInPort:=data;exit;
      end;

        case port_lo of
                  31: scorpionInPort:=StickValue; (* Kempston *)
                 253: (* Ay-3-8912 *) scorpionInPort:=PSG[last_fffd];
                 254: (* Keys *)
                    begin
                        data:=255;
                        if port_hi and 128=0 then
                                data:=data and SKey[7];
                        if port_hi and 64=0 then
                                data:=data and SKey[6];
                        if port_hi and 32=0 then
                                data:=data and SKey[5];
                        if port_hi and 16=0 then
                                data:=data and SKey[4];
                        if port_hi and 8=0 then
                                data:=data and SKey[3];
                        if port_hi and 4=0 then
                                data:=data and SKey[2];
                        if port_hi and 2=0 then
                                data:=data and SKey[1];
                        if port_hi and 1=0 then
                                data:=data and SKey[0];
                        {if (VOC_file_open) and (VOC_paused=false) then
                            data:=data xor return_next_bit;}
                        scorpionInPort:=data;
                       end;
                 255: (* Vertical Retrace (not on +3 or +2A) *)
                      scorpionInPort:=vline and 255; (* Temporary  *)
                else scorpionInPort:=255; (* Temporary *)
        end;
end;

procedure scorOutBankm128(val:Byte);
var s:string;
begin
(*     if Last_7FFD and 32>0 then s:='dis' else s:='en';
        DEBUG(
			'bankm: RAM select '+i2s(((Last_1FFD and 16) shr 1) or (val and 7),0,'0')+
                        ', ROM select '+i2s( (val and 16) shr 4,0,'0')+
                        ', screen '+i2s((val and 8) shr 3,0,'0')+
                        ', paging '+s+'abled');*)

	if (last_7FFD and $20>0) then exit;
        if (val and 8>0) then SP_SCREEN:=RAM[7] else SP_SCREEN:=RAM[5];
	Last_7FFD:= val;
	SRAM[3]:=RAM[((Last_1FFD and 16) shr 1) or (val and 7)];
	if (Last_1FFD and 3=0) then
		SRAM[0]:=ROM[((val and 16) shr 4)];
end;

procedure ScorOutBankmX(val:Byte);
begin
        (*DEBUG('bankx: RAM select '+i2s(((val and 16) shr 1) or (Last_7FFD and 7),0,'0')+
              ', RAM8 '+i2s(byte(val and 1),0,'0')+', ROM2 '+i2s((val and 2) shr 1,0,'0')+
              ', 7FFD '+word2hex(last_7ffd)+
              ', 1FFD '+word2hex(last_1ffd));*)

	case val and (1 or 2) of
	 1: SRAM[0]:=RAM[8];
	 2: SRAM[0]:=ROM[2];
         3:;
	 else SRAM[0]:=ROM[(Last_7FFD and 16) shr 4];
	end;
	SRAM[3]:=RAM[((val and 16) shr 1) or (Last_7FFD and 7)];
	Last_1FFD:= val;
end;

procedure scorpionOutPort(portnum:word;val:Byte);
var btemp,port_hi,port_lo:Byte;
begin
  port_hi:=(portnum shr 8) and $FF;
  port_lo:=(portnum and $FF);
 { DEBUG('writing '+byte2hex(val)+' to port '+word2hex(portnum));}

  if ((sram[0]=ROM[2]) or (sram[0]=ROM[3])) and (port_lo and 31>0) then
   begin
    btemp:=(port_lo shr 4);
    if btemp<8 then diskvg(btemp,val) else
    if btemp=$F then diskvg(9,val);
   end;

  if (port_lo and 1)=0 then
  begin
   border:=val and 7;(* ULA (border/48K sound) *)
   tune48k(val);exit;
  End;

    if port_lo=253 then
     begin
      btemp:=port_hi shr 6;
      case btemp of
       0: ScorOutBankmX(val);
       1: ScorOutBankm128(val);
       2: sound.PSGOut(last_fffd,val);
       3: last_fffd:=val and 15;
      end;
     end;

end;

procedure scorpionNmi;
begin
	Z80_NMI;
        SRAM[0]:=ROM[3];
end;


{$f-}

procedure scorpionInit(romname:String);
var i:byte;
begin
        max_v_Line:=312;
        t_states_per_line:=224;

	Machine_reset:= scorpionReset;
	Machine_nmi:= scorpionNmi;
	Machine_HookTRD:= scorpionHookTRD;
        Machine_InitPages:=scorpionInitPages;;

	speekb:= scorpionReadMem;
	spokeb:= scorpionWriteMem;
	inPort:= scorpionInPort;
	outPort:= scorpionOutPort;
        open_rom_scorpion(romname);

        {scorpionreset;}
        ROM[1]^[1386]:=237;
        ROM[1]^[1387]:=255;
end;

begin
 initnew(version);
end.
