{AY8910 through Speaker V2.0}
{$i compile.inc}
unit speaker;

interface
uses sndDRV;

var speakerDRV: Sound_Drv;

implementation
uses dos,vars,core;

 const
  channel_on:array[0..3] of boolean=(true,true,true,true);

const
  MIN_VOL  = 0;
  MAXFREQ  = 10000;

var invalidfreq:array[0..3] of boolean;
    channelTAB:array[0..3] of Longint;
    channelvolume:array[0..3] of integer;

const spk_channels:array[0..3] of byte=(4,3,2,1);
      actchannel:Byte=0;

procedure UpdateSound;
var totalfreq,new_freq:longint;
    c,i:byte;
begin
 new_freq:=0;
 totalfreq:=0;

    i:=0;
    repeat
     c:=spk_channels[actchannel];
     actchannel:=(actchannel+1) mod 4;
     inc(i);
    until ( (channel_on[c-1])  and (not invalidfreq[c-1]) ) or (i>=4);

    if (c>0) AND (not invalidfreq[c -1]) AND (channel_on[c-1]) AND
       (channelvolume[c-1]>MIN_VOL) then
    begin
     totalfreq:=channelTAB[c-1];
     if totalfreq>0 then new_freq:=1192380 div totalfreq;
    end;

  if new_freq>0 then
  begin
   port[$43]:=$b6;
   port[$42]:=new_freq and $FF;
   port[$42]:=new_freq shr 8;
   port[$61]:=port[$61] or 3;
  end
  else port[$61]:=port[$61] and $FC; {MUTE}
end;

procedure Set_Vol(r:byte);
begin
 channelvolume[r]:=psg[r+8];UpdateSound;
end;

procedure Set_Tone(r:byte);
var freq:longint;
    realfreq:longint;
begin
 freq:=(PSG[(R shl 1)+1] shl 8) or PSG[R shl 1];
 if freq=0 then freq:=1024;
 realfreq:=3579545 div (freq shl 5); {!!!!!}
 if (realfreq>MAXFREQ) then invalidfreq[r]:=true else invalidfreq[r]:=false;
 if (r=3) then realfreq:=realfreq shr 2;
 channelTAB[r]:=realfreq;
 UpdateSound;
 if (r=2) and (white_noise) then
 begin psg[3]:=freq;Set_Tone(3); end;
end;

procedure NoiseControl (r:Byte);
var v:Byte;
const NoiseFreqs:array[0..3] of byte= (16,32,64,0);
begin
 v:=psg[r];
 if ((v and 3)=3) then
 begin
  if (not white_noise) then
  begin
   white_noise:=true;
   psg[3]:=psg[2];Set_Tone(3);
  end;
 end
 else
  psg[3]:=NoiseFreqs[v and 3];Set_Tone(3);
end;

{$f+}
procedure PSGOut(r,v:Byte);
begin
  PSG[R]:=V;
    case R of
	 0,                                                          {A-Fine}
	 1:Set_Tone(0);                                            {A-Coarse}
	 2,                                                          {B-Fine}
	 3:Set_Tone(1);                                            {B-Coarse}
	 4,                                                          {C-Fine}
	 5:Set_Tone(2);                                            {C-Coarse}
         6:NoiseControl (r);                                          {Noise}
	 7:begin Set_Vol(0);Set_Vol(1);Set_Vol(2);end;         {Enable Sound}
	 8:Set_Vol(0);                                                {A-Vol}
	 9:Set_Vol(1);                                                {B-Vol}
        10:Set_Vol(2);                                                {C-Vol}
        11:;                                                         {E-Fine}
        12:;                                                       {E-Coarse}
        13:;                                                        {E-Shape}
        14:;                                                         {Port A}
        15:;                                                         {Port B}
      end;
end;

procedure MuteSound;
begin
 port[$61]:=port[$61] and $FC;
end;

function init:Boolean;
begin
 init:=true;
end;

procedure done;
begin
 mutesound;
end;
{$f-}


begin
 initnew('Speaker Driver');
 speakerDRV.mutesound:=Mutesound;
 speakerDRV.psgout:=psgout;
 speakerDRV.init:=init;
 speakerDRV.done:=done;

end.
{ alte Version }
procedure UpdateSound;
var totalvolume,totalfreq:longint;
    c,j,i:longint;new_freq:longint;
begin
 new_freq:=0;
 totalvolume:=0;
 totalfreq:=0;

  for i:=0 to 3 do
  begin
    c:=spk_channels[i];
   if (c>0) AND (not invalidfreq[c -1]) AND (channel_on[c-1]) AND
      (channelvolume[c-1]>MIN_VOL) then
   begin
    totalfreq:=channelTAB[c-1];
    totalvolume:=1;
    break;
   end;
  end;
  if totalvolume>0 then
  begin
   i:=totalfreq div totalvolume;
   if i>0 then new_freq:=1192380 div i;
  end;

  if new_freq>0 then
  begin
   port[$43]:=$b6;
   port[$42]:=new_freq and $FF;
   port[$42]:=new_freq shr 8;
   port[$61]:=port[$61] or 3;
  end
  else port[$61]:=port[$61] and $FC; {MUTE}
end;
