unit spec48;

interface

procedure spec48init(romname:String);

implementation

uses core,vars,machine,z80CPU,sndDrv,tape,mf3;

const version:string = '$Id: spec48.pas,v 1.0';

procedure open_rom48k(romname:String);
var f: file;
    numread:integer;
begin
 assign(f,romname);reset(f,1);
 blockread(f,ROM[0]^,16384,numread);
 close(f);
end;
{$f+}
function spec48ReadMem(Addr:Word):Byte;
var page:byte;
begin
 page:=(addr and $C000) shr 14;
 spec48ReadMem:=SRAM[Page]^[addr and $3FFF];
end;

procedure spec48WriteMem(addr:word;val:Byte);
var segm:Word;
begin
 segm:=(addr and $C000) shr 14;
 if (segm>0) or (SRAM[segm]=ROM[4]) then SRAM[segm]^[addr and $3FFF]:=val;
 if (CONTENDED[segm]>0) and
    (t_state shr 7=0) and (vline and 192>0) then inc(t_state,4);

end;

procedure spec48Nmi;
begin
	Z80_NMI;
	inport(0,191);
end;

procedure spec48HookTrd;
begin
end;

procedure spec48InitPages;
begin
	SRAM[0]:=ROM[0];
	SRAM[1]:=RAM[5];
	SRAM[2]:=RAM[2];
	SRAM[3]:=RAM[0];
        SP_SCREEN:=RAM[5];
end;

procedure spec48Reset;
begin
	Z80_Reset;
        Spec48InitPages;
end;

function spec48InPort(port_hi, port_lo:Byte):Byte;
var i,data: byte;
begin
        case port_lo of
                  31: spec48InPort:=StickValue; (* Kempston *)
               63,191: spec48InPort:=inMF128(port_lo);
                 253: (* Ay-3-8912 *) spec48InPort:=PSG[last_fffd];
                 254: (* Keys *)
                    begin
                        data:=255;
                        if port_hi and 128=0 then
                                data:=data and SKey[7];
                        if port_hi and 64=0 then
                                data:=data and SKey[6];
                        if port_hi and 32=0 then
                                data:=data and SKey[5];
                        if port_hi and 16=0 then
                                data:=data and SKey[4];
                        if port_hi and 8=0 then
                                data:=data and SKey[3];
                        if port_hi and 4=0 then
                                data:=data and SKey[2];
                        if port_hi and 2=0 then
                                data:=data and SKey[1];
                        if port_hi and 1=0 then
                                data:=data and SKey[0];
                        if (VOC_file_open) and (VOC_paused=false) then
                            data:=data xor return_next_bit;
                        spec48InPort:=data;
                       end;
                 255: (* Vertical Retrace (not on +3 or +2A) *)
                      spec48InPort:=vline and 255; (* Temporary  *)
                else spec48InPort:=255; (* Temporary *)
        end;
end;

procedure Spec48OutPort(portnum:word;val:Byte);
var btemp,port_hi,port_lo:Byte;
begin
  port_hi:=(portnum shr 8) and $FF;
  port_lo:=(portnum and $FF);

  if (port_lo and 1)=0 then border:=val and 7;(* ULA (border/48K sound) *)

  if (not(odd(portnum))) then
   Begin
    tune48k(val);exit;
   End;

    if port_lo=253 {0xfd} then
      case port_hi shr 6 of
      {0,1: begin last_7ffd:=val;if not mf128 then sram[0]:=ROM[0];end;}
        2:  sound.PSGOut(last_fffd,val);
        3: last_fffd:=val and 15;
     end;
end;

{$f-}

procedure Spec48Init(romname:String);
begin
        max_v_line:=312;
	t_states_Per_Line:= 224;

	Machine_reset:= spec48Reset;
	Machine_nmi:= spec48Nmi;
	Machine_hooktrd:= spec48HookTrd;
        Machine_InitPages:=spec48InitPages;;

	speekb:= spec48ReadMem;
	spokeb:= spec48WriteMem;
	inPort:= spec48InPort;
	outPort:= spec48OutPort;
        open_rom48k(romname);
        {spec48reset;}
        ROM[0]^[1386]:=237;
        ROM[0]^[1387]:=255;
end;

begin
 initnew(version);
end.
