unit VBE2;

Interface

type
   TRgb24 = packed record
      Blue, Green, Red: byte;
   end;

   TRgb32 = packed record
      Blue, Green, Red, Alpha: byte;
   end;

   TRealModePtr = packed record
      Offset, Segment:    word;
   end;
   TScreenBuffer8B  = array [0..0] of byte;
   TScreenBuffer16B = array [0..0] of word;
   TScreenBuffer24B = array [0..0] of TRgb24;
   TScreenBuffer32B = array [0..0] of TRgb32;

   TLfbPointer = record
   case integer of
      0: (TLfb8bitPtr:     ^TScreenBuffer8B;);
      1: (TLfb16bitPtr:    ^TScreenBuffer16B;);
      2: (Tlfb24bitPtr:    ^TScreenBuffer24B;);
      3: (Tlfb32bitPtr:    ^TScreenBuffer32B;);
   end;

   TModeList   = array [word] of word;
   PModeList   = ^TModeList;

   TVbeInfo = packed record

      VbeSignature:       longint;
      VbeMinorVersion:    byte;
      VbeMajorVersion:    byte;

      case integer of
         0: (
            OemStringRmPtr:  TRealModePtr;
            Capabilities:    longint;
            ModeListRmPtr:   TRealModePtr;
            TotalMemory:     word;
            OemSoftwareRev:  word;
            OemVendorNameRmPtr,
            OemProductNameRmPtr,
            OemProductRevRmPtr: TRealModePtr;
            Reserved:        array [0..221] of byte;
            OemData:         array [0..255] of byte;
            );

         1: (
            OemStringPtr:    Pchar;
            Capabilities_:   longint;
            ModeListPtr:     PModeList;
            TotalMemory_:    word;
            OemSoftwareRev_: word;
            OemVendorNamePtr,
            OemProductNamePtr,
            OemProductRevPtr:   Pchar;
            Reserved_:        array [0..221] of byte;
            OemData_:         array [0..255] of byte;
            );
   end;

   TVbeModeInfo = packed record

      ModeAttributes:     word;
      WinAAttributes:     byte;
      WinBAttributes:     byte;
      WinGranularity:     word;
      WinSize:            word;
      WinASegment:        word;
      WinBSegment:        word;
      WinFuncPtr:         TRealModePtr;
      BytesPerScanLine:   word;
      SizeX:              word;
      SizeY:              word;
      CharSizeX:          byte;
      CharSizeY:          byte;
      NumberOfPlanes:     byte;
      BitsPerPixel:       byte;
      NumberOfBanks:      byte;
      MemoryModel:        byte;
      BankSize:           byte;
      NumberOfImagePages: byte;
      Reserved1:          byte;
      RedMaskSize:        byte;
      RedFieldPosition:   byte;
      GreenMaskSize:      byte;
      GreenFieldPosition: byte;
      BlueMaskSize:       byte;
      BlueFieldPosition:  byte;
      RsvdMaskSize:       byte;
      RsvdFieldPosition:  byte;
      DirectColorInfo:    byte;
      LfbPtr:             TLfbPointer;
      OffScreenMemOffset: pointer;
      OffScreenMemSize:   word;
      Reserved2:          Array [0..205] of Byte;

   end;

   TVbePmi = packed record
      SetWindowOffset:    word; { fn 5 }
      SetDispStartOffset: word; { fn 7 }
      SetPrimaryPalette:  word; { fn 9 }
      PortMemArrayOffset: word;
      PmCode:             array [word] of byte;
   end;

   PVbeInfo = ^TVbeInfo;
   PVbeModeInfo = ^TVbeModeInfo;
   PVbePmi = ^TVbePmi;

Var CurrentBank:longint;CurrentMode:Word;
    CurrentX,CurrentY,CurrentBPP:Word;
    VbeInfo: PVbeInfo;
    ModeInfo: PVbeModeInfo;
    Screenbuffer:Pointer;
    LFBoffs,WindowSize:Longint;

function Initgraph(X, Y, bpp: longint;LFB:Boolean):Boolean;
procedure closegraph;
procedure SetContent(var src);
function FindMode(X, Y, bpp: longint): word;
procedure SetBank(bank: integer);register;

Implementation uses Dos,DPMI;

var BlockSize,NumBlocks:longint;
    BankIncrement:longint;
    WaitRetrace:Boolean;

    HaveLFB:Boolean;

    DosMemoryBlock: DosMem;

    PmiBankSwitcher: pointer;
    PmiSetDisplayStart: pointer;
    PmiSetPalette: pointer;

function LinearPointer(SegOfs: TRealModePtr):pointer;
begin
   LinearPointer:= pointer((longint(SegOfs.Segment) SHL 4) + SegOfs.Offset);
end;

function GetModeInfo(mode: word): PVbeModeInfo;
var regs: registers;
begin
   regs.es:= DosMemoryBlock.LinearAddress SHR 4;
   regs.di:= 512;
   regs.cx:= mode AND $FFF;
   regs.ax:= $4F01;
   SimulateInterrupt($10, regs);
   GetModeInfo:= ModeInfo;
end;

Function GetVbeInfo:Boolean;
const vbesigstr: array [0..3] of char = 'VESA';
var regs: registers;
    vbesig: longint absolute vbesigstr;

begin
   GetVBEinfo:=True;
   regs.es:= DosMemoryBlock.LinearAddress SHR 4;
   regs.di:= 0;
   regs.ax:= $4F00;
   SimulateInterrupt($10, regs);
   if (regs.ax <> $4F) or (VbeInfo^.VbeSignature <> vbesig) then
       GetVbeInfo:=False;
   with VbeInfo^ do begin
       OemVendorNamePtr:= LinearPointer(OemVendorNameRmPtr);
       OemProductNamePtr:= LinearPointer(OemProductNameRmPtr);
       OemProductRevPtr:= LinearPointer(OemProductRevRmPtr);
       OemStringPtr:= LinearPointer(OemStringRmPtr);
       ModeListPtr:= LinearPointer(ModeListRmPtr);
   end;
end;

procedure InitPmi;
var  Pmi:   PVbePmi;
     regs:  registers;
begin
   Pmi:= NIL;
   PmiBankSwitcher:= NIL;
   PmiSetDisplayStart:= NIL;
   PmiSetPalette:= NIL;
   if VbeInfo^.VbeMajorVersion > 1 then
    begin
      regs.ax:= $4F0A;
      regs.bl:= 0;
      SimulateInterrupt($10, regs);
      if regs.ax = $4F then
       begin
        Pmi:= pointer((longint(regs.es) SHL 4) + regs.di);
        PmiBankSwitcher:= @(Pmi^.PmCode[Pmi^.SetWindowOffset - 8]);
        PmiSetDisplayStart:= @(Pmi^.PmCode[Pmi^.SetDispStartOffset - 8]);
        PmiSetPalette:= @(Pmi^.PmCode[Pmi^.SetPrimaryPalette - 8]);
       end;
   end;
end;

function FindMode(X, Y, bpp: longint): word;
var i: integer;
    list: PModeList;
    haveLfb: boolean;
begin
   haveLfb:= false;
   result:= $FFFF;
   i:= 0;
   list:= VbeInfo^.ModeListPtr;
   with ModeInfo^ do begin
      while (list^[i] <> $FFFF) and (result = $FFFF) do begin
         GetModeInfo(list^[i] AND $FFF);
         if (SizeX = X) and (SizeY = Y) and (BitsPerPixel = bpp)
            and ((ModeAttributes AND 3) = 3) then begin
            result:= list^[i];
            if VbeInfo^.VbeMajorVersion > 1 then begin
               haveLfb := (ModeAttributes AND $83) = $83;
               while (list^[i+1] <> $FFFF) and (not(haveLfb)) do begin
                  GetModeInfo(list^[i+1] AND $FFF);
                  if (SizeX = X) and (SizeY = Y) and (BitsPerPixel = bpp)
                     then begin
                     haveLfb := (ModeAttributes AND $83) = $83;
                     if haveLfb then result:= list^[i+1];
                  end;
                  inc(i);
               end;
            end;
         end;
         inc(i);
      end;
   end;
   if (result = 0) and (X = 320) and (Y = 200) and (bpp = 8) then result:= $13;
end;

procedure WaitVRT; assembler;
asm
  mov  edx, 3DAh

@@1:
  in   al, dx
  test al, 8
  jnz  @@1

@@2:
  in   al, dx
  test al, 8
  jz   @@2
end;

function SetModeVbe(mode: word):boolean; register; assembler;
asm
   push  ebx
   mov   ebx, eax
   sub   edx, edx
   mov   ax, 4F02h
   int   10h
   xchg  eax, edx
   cmp   dx, 4Fh
   sete  al
   pop   ebx
end;

procedure SetModeVga(mode: word); register; assembler;
asm
   sub  ah, ah
   int  10h
end;

procedure SetBank(bank: integer); register; assembler;
asm
   cmp   CurrentBank, edx
   je    @@done

   mov   CurrentBank, edx
   mov   ecx, PmiBankSwitcher

{
   A well behaved implementation would not destroy esi and ebp as the VBE 2
   standard says that it must not.
}
   push  edi
   push  ebx
   mov   eax, 4F05h
   sub   ebx, ebx
   test  ecx, ecx
   je    @@UseInt

   push  OFFSET @@Return
   jmp   ecx

@@UseInt:
   int   10h

@@Return:
   pop   ebx
   pop   edi
@@done:
end;

function SetVMode(mode: word;DisAbleLFB:Boolean):Boolean;
var error: boolean;
begin
   error:= true;
   if mode AND $F7F < $14 then begin
      SetModeVga(mode);
      CurrentMode:= mode;
      CurrentBank:= 0;
      if (mode AND $1F) = $13 then begin
         CurrentX:= 320;
         CurrentY:= 200;
         CurrentBPP:= 8;
         ScreenBuffer:= pointer($A0000);
         WindowSize:= 64000;
         blockSize:= WindowSize;
         numBlocks:= 1;
         // Palette:= CurrentPalette;
      end;
   end else begin
      GetModeInfo(mode AND $FFF);
      with ModeInfo^ do begin         {and if we have LFB}

         if (not DisableLFB)and (VbeInfo^.VbeMajorVersion > 1) and ((ModeAttributes AND $83) = $83) then
         begin
               LFBoffs:=Get_Linear_Addr(
                                   longint(LfbPtr),
                                   longint(SizeX) *
                                   longint(SizeY) *
                                   longint((BitsPerPixel + 7) DIV 8)
                                );
               error:= not (SetModeVbe(mode OR $4000));
               if not error then begin
                  CurrentMode:= mode OR $4000;
                  ScreenBuffer:= pointer(LFBoffs);
                  WindowSize:= SizeX * SizeY * ((BitsPerPixel + 7) SHR 3);
                  blockSize:= WindowSize;
               end;
         end; { if }
         if error and ((ModeAttributes AND $43) = 3) then begin
            error:= not (SetModeVbe(mode AND $FFF));
            if not error then begin
               CurrentMode:= mode AND $FFF;
               ScreenBuffer:= pointer(longint(WinASegment) SHL 4);
               WindowSize:= longint(WinSize) SHL 10;
               blockSize:= WindowSize - (WindowSize MOD (longint(WinGranularity) SHL 10));
               BankIncrement:= blockSize DIV (longint(WinGranularity) SHL 10);
               CurrentBank:= -1; { This fixes some older BIOSes that would }
               SetBank(0);       { start with a non zero offset.           }
            end;
         end; { if }
      end; { with }
      if error then setvmode:=false
      else begin
         CurrentBank:= 0;
         CurrentX:= ModeInfo^.SizeX;
         CurrentY:= ModeInfo^.SizeY;
         CurrentBPP:= ModeInfo^.BitsPerPixel;
         // Palette:= CurrentPalette;
         numBlocks:= CurrentX * CurrentY * ((CurrentBPP + 7) SHR 3)
            DIV blockSize;
         if ((CurrentX * CurrentY * ((CurrentBPP + 7) SHR 3)) MOD blockSize)
            > 0 then numBlocks:= numBlocks + 1;
         setvmode:=True;
      end;
   end; { vbe }
end;

function Initgraph(X, Y, bpp: longint;LFB:Boolean):Boolean;
var m: word;
begin
   InitGraph:=false;
   GetDosMem(DosMemoryBlock,768);
   if (x=320) and (y=200) and (bpp=8) then
   begin
    asm mov ax,13h; int 10h; end;
    screenbuffer:=pointer($a0000);
    currentx:=320;currenty:=200;currentbpp:=200;
    InitGraph:=true;exit;
   end;

   VbeInfo:= pointer(DosMemoryBlock.LinearAddress);
   ModeInfo:= pointer(DosMemoryBlock.LinearAddress+512);
   FillChar(VbeInfo^, 768, #0);
   if GetVbeInfo then
   begin
    InitPmi;
    m:= FindMode(X, Y, bpp);
    if m = $FFFF then InitGraph(320,200,8,lfb); {Geht immer exit;}
    if not SetVMode(M,not LFB) then exit;
   end;
   InitGraph:=true;
end;

procedure closegraph;
begin
 FreeDosmem(DosMemoryBlock);
end;

procedure SetContent(var src);
var
    dPtr: pointer;
    tSize: longint;
    bi, i: integer;
    sz: longint;
begin
 bi:= 0;
 sz:= CurrentX * CurrentY * ((CurrentBPP + 7) SHR 3);
 if WaitRetrace then WaitVRT;
 for i:= 0 to numBlocks - 1 do
  begin
   dPtr:= ScreenBuffer;
   SetBank(bi);
   bi:= bi + BankIncrement;
   if sz > blockSize then tSize:= blockSize else tSize:= sz;
   sz:= sz - blockSize;
    asm
     cld
     mov  ecx, tSize
     push edi
     push esi
     mov  esi, src
     mov  edi, dPtr
     shr  ecx, 2
     rep  movsd
     mov  src, esi
     pop  esi
     pop  edi
    end;
   end;
end;

end.
