{$i compile.inc}
unit z80cpu;

interface uses machine;

procedure oneinstr;
procedure z80_decode;
procedure z80_reset;

procedure Z80_NMI;

implementation
uses core,crt,{$ifdef vesa} vesamon {$else} z80mon {$endif},tape,SNDDrv,vars,trdos,grafx;

{$i procs.inc}
{$i cbops.inc}
{$i edops.inc}
{$i z80ops.inc}

 procedure Z80_NMI;
 var temp:byte;
 begin
  iff2:=iff1;
  iff1:=0;
  halt:=0;
  inc(ir.l);
  push(pc.W);
  pc.W:=102;
{ temp:=inport(0,191);}
  inc(t_state,11);
 end;

 procedure oneinstr; (* Must be changed !!!! *)
 var b:byte;
 begin
	if halt=0 then
	Begin
         inc(ir.l);
	 b:=speekb(pc.W);
	 inc(pc.w);
         z80[b];
	end else inc(t_state,4);
 end;


procedure z80_decode;
var b,screen_up: Byte;
    line,fps:Word;
begin
screen_up:=0;
{$ifdef debug} resetfps;{$endif}
   repeat
      if (t_state>=t_states_per_line) then
	Begin
		t_state:=t_state-t_states_per_line;
		inc(vline);
		if(vline>=Max_V_line) then
		Begin
                        if usestick then ReadJoyStick;
			vline:=0;
                        inc(screen_up);
			if (screen_up>=frame_skip) then screen_up:=0;

			dec(flash_counter);
			if flash_counter=0 then
			Begin
				flash_counter:=16;
				flash_status:=not flash_status;
			end;
			if iff1>0 then
			Begin
				iff2:=iff1;
				iff1:=0;
                                halt:=0;
                                if speekb(pc.w)=$76 then inc(pc.w);
                                push(pc.w);
				if im=2 then
				Begin
					pc.W:=wordpeek((ir.h shl 8) or 255);
                                        inc(ir.l);
					inc(t_state,19);
				end
				else
				Begin
                                        inc(ir.l);
					pc.w:=$38; {Z80[255];}
					inc(t_state,13);
				end;
			end;
           end;

          if vline and 192>0 then
           begin
            line:=vline-64;
      (* Check Frame Skip *)
         { If 0, wait until changes
           If 1, decrement variable  and set that next frame will be drawn
           If >1, decrement variable and set that next frame won't be drawn.}

            if (realspeed) and (line=191) then
             begin
              if (timerVar<=1) and (frame_skip>0) then dec(frame_skip)
              else if timerVar>1 then
               begin
                inc(frame_skip);{debug(i2s(timervar,0,'0'));}
               end;
             end;

            if screen_up=0 then
            begin
             (* Slow down *****************************************)
             if (realspeed) and (line=191) then
             begin
              while timervar=0 do; timervar:=0;
              if showspeed then showstatus(false);
             end;

             updateline(line);
             inc(t_state,ula_delay);
            end;
           end;
	end;

        if halt=0 then
	while (t_state<t_states_per_line) and (halt=0) do
         begin

        (* Check for TRDOS *******************************************)
         machine_HookTRD;
        (* Normal Execution Process ***********************************)
         inc(ir.l);
	 {b:=SRAM[(pc.w and $C000) shr 14]^[pc.w and $3FFF];}
         b:=speekb(pc.W);
	 inc(pc.w);
         z80[b];
         asm
           cmp realspeed,0
           jz @2
           cmp cpu_delay,0
           jz @2
           mov cx,cpu_delay;
           @1: dec cx;
           jnz @1;
           @2:
          end;
	end else
         begin z80[0]; {inc(t_state,4);} end;

    (* Joystick *******************************************************)
    if usestick then {either use keyboard; look into core.pas}
    begin
     stickvalue:=0;
     if JoyAX>JoyMaxX then stickvalue:=stickvalue or $01; {Right}
     if JoyAX<JoyMinX then stickvalue:=stickvalue or $02; {Left}
     if JoyAY>JoyMaxY then stickvalue:=stickvalue or $04; {Down}
     if JoyAY<JoyMinY then stickvalue:=stickvalue or $08; {Up}
     if (joybuttons and $10)=0 then stickvalue:=stickvalue or $10; {Fire}
    end;
   until (key[59]) or (key[60]) or (key[61]) or (key[62]) or (key[63])
         or (key[64]) or (key[65]) or (key[66]) or (key[67]) or (key[68])
         {or (keypressed)};
 sound.mutesound;
end;

procedure z80_reset;
Begin
	fillchar(PSG,Sizeof(PSG),0);
        fillchar(skey,sizeof(skey),0);
	iff1:=0;iff2:=0;
        bit7_r:=0;

        af.W:=0;af2.W:=0;
	hl.W:=0;hl2.W:=0;
        de.W:=0;de2.W:=0;
        bc.W:=0;bc2.W:=0;
	ix.W:=$FFFF;iy.W:=$FFFF;

        im:=1;ir.W:=0;
        sp.W:=0;pc.W:=0;

        halt:=0;
        last_fffd:=0;
        last_7ffd:=0;
        last_1ffd:=0;
	vline:=0;
        t_state:=0;
	flash_counter:=16;
        border:=7;
end;

begin
 initNew('Z80-CPU ');
 displaynew('Create CB-Table');createCB;
 displaynew('Create ED-Table');CreateED;
 displaynew('Create Z80-Table');CreateZ80;
end.