{B0/B3 Ton an / aus A0/A3 - Freq}
{$i compile.inc}
unit Adlib;

interface

uses sndDRV;

 var AdlibDRV: Sound_Drv;

implementation uses dos,vars,core;

Const
      Volumes:array[0..15] of byte=
      ($FF,$3F,$3F,$3F,$2C,$26,$22,$1D,
       $16,$12,$0C,$0A,$07,$05,$02,$00);

      FMAdr :word= $220; { $388}
      OPL3: Boolean=True;

procedure WriteFM (index,value:Byte);
var i,tmp:byte;
begin
 port[FMAdr]:=index;
 if (OPL3) then tmp:=port[FMAdr]
 else for i:=0 to 5 do tmp:=port[FMAdr];
 port[FMAdr+1]:=value;
 if (OPL3) then begin tmp:=port[FMAdr];tmp:=port[FMAdr];end else
 for i:=0 to 34 do tmp:=port[FMAdr];
end;

procedure Set_Tone(R:Byte);
var j:byte;
    lath:word;
    tune:Longint;
begin
	Lath:=(PSG[(R shl 1)+1] shl 8) or PSG[R shl 1];
	Lath:=Lath and 4095; {111111111111b}
	if lath>0 then Tune:=2345678 div Lath else tune:=1;
        j:=0; while tune>=$400 do
         begin
          tune:=tune shr 1;
          inc(j);
         end;

  	case r of
	0:begin
		if PSG[7] and 1=0 then
		begin
			WriteFM($A0+R,Tune and $FF);
			WriteFM($B0+R,((Tune shr 8) and $03) or (J shl 2) or $20);
                        if (OPL3) then
                         begin
                          WriteFM($A3+R,Tune and $FF);
                          WriteFM($B3+R,((Tune shr 8) and $03) or (J shl 2) or $20);
                         end;
		end;
		if PSG[7] and 8=0 then
		begin
			WriteFM($A7,Tune and $FF);
			WriteFM($B7,((Tune shr 8) and $03) or (J shl 2) or $20);
		end;
           end;
	1: begin
	     if PSG[7] and 2=0 then
		begin
			WriteFM($A0+R,Tune and $FF);
			WriteFM($B0+R,((Tune shr 8) and $03) or (J shl 2) or $20);
                        if (OPL3) then
                        begin
                         WriteFM($A3+R,Tune and $FF);
                         WriteFM($B3+R,((Tune shr 8) and $03) or (J shl 2) or $20);
                        end;
		end;
		if PSG[7] and 16=0 then
		begin
			WriteFM($A7,Tune and $FF);
			WriteFM($B7,((Tune shr 8) and $03) or (J shl 2) or $20);
		end;
            end;
        2:  begin
		if PSG[7] and 4=0 then
		begin
			WriteFM($A0+R,Tune and $FF);
			WriteFM($B0+R,((Tune shr 8) and $03) or (J shl 2) or $20);
                        if opl3 then
                        begin
                	 WriteFM($B3+R,((Tune shr 8) and $03) or (J shl 2) or $20);
                         WriteFM($A3+R,Tune and $FF);
                        end;
		end;
		if PSG[7] and 32=0 then
                begin
			WriteFM($A7,Tune and $FF);
			WriteFM($B7,((Tune shr 8) and $03) or (J shl 2) or $20);
		end;
             end;
      end;
   case PSG[7] shr R and 9 of
    9:;
    8:Begin
        WriteFM($A0+R,Tune and $FF);
	WriteFM($B0+R,((Tune shr 8) and $03) or (J shl 2) or $20);
        if opl3 then
        begin
         WriteFM($B3+R,((Tune shr 8) and $03) or (J shl 2) or $20);
         WriteFM($A3+R,Tune and $FF);
        end;
      end;
    1:Begin
       WriteFM($A7,Tune and $FF);
       WriteFM($B7,((Tune shr 8) and $03) or (J shl 2) or $20);
      end;
    0: Begin
        WriteFM($A0+R,Tune and $FF);
	WriteFM($B0+R,((Tune shr 8) and $03) or (J shl 2) or $20);
         if opl3 then
         begin
          WriteFM($A3+R,Tune and $FF);
          WriteFM($B3+R,((Tune shr 8) and $03) or (J shl 2) or $20);
         end;
	WriteFM($A7,Tune and $FF);
	WriteFM($B7,((Tune shr 8) and $03) or (J shl 2) or $20);
       end;
    end;
end;

procedure Set_Vol( R:Byte);
var v: byte;
begin
	V:=PSG[R+8];
	if V and $10>0 then V:=12;

	if((PSG[7] and (1 shl R)))>0 then
		WriteFM($43+R,Volumes[0])
	else
		WriteFM($43+R,Volumes[V]);

	if((PSG[7] and $38)=$38) then
		WriteFM($54,Volumes[0])
	else
		if white_noise then WriteFM($54,Volumes[V]);
end;

{$f+}
procedure PSGOut(r,v:Byte);
begin
  PSG[R]:=V;
    case R of
	 0,                                                          {A-Fine}
	 1:Set_Tone(0);                                            {A-Coarse}
	 2,                                                          {B-Fine}
	 3:Set_Tone(1);                                            {B-Coarse}
	 4,                                                          {C-Fine}
	 5:Set_Tone(2);                                            {C-Coarse}
	 6,                                                           {Noise}
	 7:begin Set_Vol(0);Set_Vol(1);Set_Vol(2);end;         {Enable Sound}
	 8:Set_Vol(0);                                                {A-Vol}
	 9:Set_Vol(1);                                                {B-Vol}
        10:Set_Vol(2);                                                {C-Vol}
        11:;                                                         {E-Fine}
        12:;                                                       {E-Coarse}
        13:;                                                        {E-Shape}
        14:;                                                         {Port A}
        15:;                                                         {Port B}
      end;
end;

procedure MuteSound;
var oldpsg7:Byte;
begin
  OldPSG7:=255;
  OldPSG7:=PSG[7];
  PSG[7]:=255;
  PSGOut(7,255);
  PSG[7]:=OldPSG7;
end;

function  Init:Boolean;
var dummy,i,a1,a2: Byte;
begin
  init:=True;
  if soundblaster then fmadr:=sbadr else
  begin
   (*         Suche nach Adlib          *)
   fmadr:=$388;

   WriteFM($01,$00);                                    {lsche test register}
   WriteFM($04,$60);                                       {schalte timer aus}
   WriteFM($04,$80);                                            {lsche timer}
   A1:=port[$388] and $E0;                                       {lese status}
   WriteFM($02,$FF);                                               {Timer=$FF}
   WriteFM($04,$21);                                            {starte Timer}
   for I:=0 to $C8-1 do dummy:=port[$388];
   A2:=port[$388] and $E0;                                       {lese status}
   WriteFM($04,$60);                                       {schalte timer aus}
   WriteFM($04,$80);                                            {lsche timer}
   if (byte(A2<>$C0) or A1)>0 then begin init:=false;exit;end else
  { displaynew('Adlib found at '+word2hex(fmadr));}
  end;

  if (port[FMAdr] and 6)=0 then
  Begin
   WriteFM(1,5);
   WriteFM(0,4);
  end
  else OPL3:=false;
  {if opl3 then
   displaynew('OPL3 chip found') else displaynew('OPL3 chip NOT found');}

  for I:=0 to 254 do WriteFM(I,$00);
  WriteFM($01,$20);
  WriteFM($BD,$20 or 8);
  MuteSound;
  for I:=0 to 2 do
  begin
    WriteFM($20+I,$01);
    WriteFM($23+I,$01);
    WriteFM($40+I,$18);
    WriteFM($43+I,$3F);
    WriteFM($60+I,$F0);
    WriteFM($63+I,$F0);
    WriteFM($80+I,$14);
    WriteFM($83+I,$13);
    WriteFM($E0+I,$02);
    WriteFM($E3+I,$00);
    WriteFM($C0+I,$0A);
    WriteFM($B0+I,$00);
    if opl3 then WriteFM($B3+I,$00)
  end;
  WriteFM($34,$21);
  WriteFM($54,$3F);
  WriteFM($74,$99);
  WriteFM($94,$00);
  WriteFM($F4,$00);
  WriteFM($BD,$28);
end;

procedure Done;
begin
    MuteSound;         {sounds of silence :-)}
    WriteFM($04,$60);     {schalte timer aus}
    WriteFM($04,$80);    {setze timer zurck}
end;
{$f-}

{procedure ResumeSound;
begin
    PSGOut(7,PSG[7]);
end;}

begin
 initnew('Adlib Driver');
 AdlibDRV.mutesound:=Mutesound;
 AdlibDRV.psgout:=psgout;
 AdlibDRV.init:=init;
 AdlibDRV.done:=done;
end.