unit didaktik;

interface

procedure Didaktikinit(romname:String);

implementation

uses core,vars,machine,z80CPU,sndDrv,mf3,TRDOS;

const version:string = '$Id: didaktik.pas,v 1.0';
      last_0x81:byte=0;

procedure open_rom_didaktik(romname:String);
var f: file;
begin
 assign(f,romname);reset(f,1);
 blockread(f,ROM[0]^,16384); {Basicrom}
 blockread(f,ROM[1]^,16384);
 close(f);
end;
{$f+}
function DidaktikReadMem(Addr:Word):Byte;
begin
 DidaktikReadMem:=SRAM[(addr and $C000) shr 14]^[addr and $3FFF]
end;

procedure DidaktikWriteMem(addr:word;val:Byte);
var segm:Word;
begin
 segm:=(addr and $C000) shr 14;
 if (segm>0) or (SRAM[segm]=ROM[1]) then
 SRAM[segm]^[addr and $3FFF]:=val;
end;

procedure DidaktikNmi;
begin
	Z80_NMI;
end;

procedure DidaktikHookTrd;
begin
	if (pc.w=0) or (pc.w=8) then SRAM[0]:=ROM[1] else
        if pc.w = $1700 then SRAM[0]:=ROM[0];
end;

procedure DidaktikInitPages;
begin
        SRAM[0]:=ROM[0];
	SRAM[1]:=RAM[5];
	SRAM[2]:=RAM[2];
	SRAM[3]:=RAM[0];

        SP_SCREEN:=RAM[5];
end;

procedure DidaktikReset;
begin
	Z80_Reset;
        DidaktikInitPages;
end;
function DidaktikInPort(port_hi, port_lo:Byte):Byte;
var i,data: byte;
begin
        case port_lo of
                  31: DidaktikInPort:=StickValue; (* Kempston *)
                 253: (* Ay-3-8912 *)
                      DidaktikInPort:=PSG[last_fffd];
                 254: (* Keys *)
                    begin
                        data:=255;
                        if port_hi and 128=0 then
                                data:=data and SKey[7];
                        if port_hi and 64=0 then
                                data:=data and SKey[6];
                        if port_hi and 32=0 then
                                data:=data and SKey[5];
                        if port_hi and 16=0 then
                                data:=data and SKey[4];
                        if port_hi and 8=0 then
                                data:=data and SKey[3];
                        if port_hi and 4=0 then
                                data:=data and SKey[2];
                        if port_hi and 2=0 then
                                data:=data and SKey[1];
                        if port_hi and 1=0 then
                                data:=data and SKey[0];
                        {if (VOC_file_open) and (VOC_paused=false) then
                            data:=data xor return_next_bit;}
                        DidaktikInPort:=data;
                       end;
                 $81: DidaktikInport:=last_0x81; {! Fehler ??}
                 255: (* Vertical Retrace (not on +3 or +2A) *)
                      DidaktikInPort:=vline and 255; (* Temporary  *)
                else
                 begin
                  {debug('Inport:  '+byte2hex(port_lo)+', pc: 0x'+word2hex(pc.w));}
                  DidaktikInPort:=255; (* Temporary *)
                 end;
        end;
end;

procedure DidaktikOutPort(portnum:word;val:Byte);
var btemp,port_hi,port_lo:Byte;
begin
  (*asm
   mov ax,portnum
   mov port_hi,ah
   mov port_lo,al
  end;*)
  port_hi:=(portnum shr 8) and $FF;port_lo:=(portnum and $FF);

  if (port_lo=$81) then last_0x81:=val;
  if (port_lo and 1)=0 then
   begin
    border:=val and 7;(* ULA (border/48K sound) *)
    tune48k(val);
   end;
  if port_lo=253 (*0xfd*) then
   case port_hi shr 6 of
     2: sound.PSGOut(last_fffd,val);
     3: last_fffd:=val and 15;
   end;
{  if not (port_lo in [$81,253]) and (port_lo and 1>0) then debug('OutPort: '+byte2hex(port_lo)+', Val: '+byte2hex(val));}
end;



{$f-}

procedure DidaktikInit(romname:String);
var i:byte;
begin
        max_v_line:= 312;
	t_states_per_line:= 224;

	Machine_reset:= DidaktikReset;
	Machine_nmi:= DidaktikNmi;
	Machine_hooktrd:= DidaktikHookTrd;
        Machine_InitPages:=DidaktikInitPages;;

	speekb:= DidaktikReadMem;
	spokeb:= DidaktikWriteMem;
	inPort:= DidaktikInPort;
	outPort:= DidaktikOutPort;
        open_rom_didaktik(romname);

       {Didaktikreset;}
        ROM[0]^[1386]:=237;
        ROM[0]^[1387]:=255;
end;

begin
 initnew(version);
end.