{$i compile.inc}
unit tape;

interface
var f_handle:File;
    calc_checksum:Byte;
const tap_file_open: Boolean=False;
      Tap_FileName:String='';

      VOC_file_open: Boolean=false;
      VOC_paused: Boolean=False;

function TAP_load(id_a:byte;start_ix,length_de:word):Byte;
procedure loadtap(S:String);

procedure savescr(S:String);
procedure loadscr(S:String);

procedure loadsna(s:String);
procedure Savesna(s:String);

procedure loadz80(S:String);
procedure savez80(S:String);

procedure loadVOC(S:String);
function return_next_bit:Byte;

implementation
uses vars,z80mon,machine;

var wrongmachine:Boolean;

function fread(var f:File;var p;size:Word):integer;
var numread:integer;
begin
 blockread(f,p,size,numread);
 fread:=numread;
end;

procedure savescr(S:String);
var f:File;
begin
{$i-} assign(f,s);rewrite(f,1);{$i+}
if ioresult<>0 then exit;
blockwrite(f,sp_screen^,6912);close(f);
end;

procedure loadscr(S:String);
var f:File;
begin
assign(f,s);reset(f,1);fread(f,sp_screen^,6912);close(f);
end;

procedure skip_block(length_wanted:Word);
var i,anz_gelesen:integer;
begin
anz_gelesen:=fread(f_handle,buffer,length_wanted);
for i:=0 to anz_gelesen-1 do calc_checksum:=calc_checksum xor buffer[i];
end;

procedure read_block(start_ix, length_wanted:Word);
var anz_gelesen,i:integer;
begin
        anz_gelesen:=fread(f_handle,buffer,length_wanted);
	for i:=0 to anz_gelesen-1 do
	begin
	 spokeb(start_ix,buffer[i]);
	 calc_checksum:=calc_checksum xor buffer[i];
	 inc(start_ix);
	end;
	display;
end;

function TAP_load(id_a:Byte; start_ix, length_de:Word):Byte;
var length:pair;
    id_tape, checksum:Byte;
begin
	if (TAP_file_open=false) then
         begin tap_load:=0;exit;end;(* fail, no file *)

	if eof(f_handle) then seek(f_handle,0); (* Back to start *)
	fread(f_handle,length.l,1);
	fread(f_handle,length.h,1);

	dec(length.W,2); (* Now actual Spectrum length *)

        fread(f_handle,id_tape,1);
	calc_checksum:=id_tape;

	if id_tape=id_a then (* Yes, the correct ID, proceed. *)
	begin
		if(length_de<=length.W) then (* Length <= so OK *)
		begin
			read_block(start_ix,length_de);
			if length_de<>length.W then
				skip_block(length.W-length_de);
                        fread(f_handle,checksum,1);
			inc(ix.W,length_de);
			de.W:=0; (* checksum in this case? *)
			if checksum=calc_checksum then
				tap_load:=1  (* success *)
			   else tap_load:=0; (* fail *)
		end
		else (* Too many bytes requested *)
		begin
			read_block(start_ix,length.W);
                        fread(f_handle,checksum,1);
			inc(ix.W,length.W);
			de.W:=0;
			tap_load:=0; (* fail *)
		end;
	end
	else (* Wrong ID! *)
	begin
		skip_block(length.W);
                fread(f_handle,checksum,1);
		tap_load:=0; (* fail *)
	end;
end;

procedure loadtap(S:String);
begin
 {$i-}
  if tap_file_open then begin close(f_handle);tap_file_open:=false; end;
  assign(f_handle,s);
  reset(f_handle,1);
 {$i+}
 if ioresult=0 then
 begin tap_filename:=s;tap_file_open:=true end else
 begin tap_file_open:=false;tap_filename:='';end;
end;

procedure loadsna(s:String);
var f: file;
    x: Byte;
    snatyp:byte; {0-2}
begin
   t_state:=0;
   assign(f,s);{$i-} reset(f,1);{$i+}

   if filesize(f)=49179 then begin outport(32765,48);snatyp:=0; end else
   if (filesize(f)=131103) or (filesize(f)=147487) then
    begin
     if model=mZX48 then set_spectrum_mode(mzx128); {falls 48k dann 128k}
     snatyp:=1;
    end
   else
    begin
     if model<>mscorpion then set_spectrum_mode(mscorpion);
     snatyp:=2;
    end;

{ lade header }

   fread(f,ir.h,1);
   fread(f,hl2.l,1);
   fread(f,hl2.h,1);
   fread(f,de2.l,1);
   fread(f,de2.h,1);
   fread(f,bc2.l,1);
   fread(f,bc2.h,1);
   fread(f,af2.l,1);
   fread(f,af2.h,1);
   fread(f,hl.l,1);
   fread(f,hl.h,1);
   fread(f,de.l,1);
   fread(f,de.h,1);
   fread(f,bc.l,1);
   fread(f,bc.h,1);
   fread(f,iy.l,1);
   fread(f,iy.h,1);
   fread(f,ix.l,1);
   fread(f,ix.h,1);
   fread(f,iff2,1);
   if iff2>0 then iff2:=1;
   iff1:=iff2;
   fread(f,ir.l,1);
   bit7_r:=ir.l and 128;
   ir.l:=ir.l and 127;
   fread(f,af.l,1);
   fread(f,af.h,1);
   fread(f,sp.l,1);
   fread(f,sp.h,1);
   fread(f,im,1);
   fread(f,border,1); (* Border *)
   outport(254,border);

   fread(f,RAM[5]^,16384); (* 16384 *)
   fread(f,RAM[2]^,16384); (* 32768 *)

   case snatyp of
   0: {48k Spectrum}
      begin
       fread(f,RAM[0]^,16384); (* 49152 *)
       pc.w:=wordpeek(sp.W);inc(sp.W,2);inc(t_state,14); {RETI}
      end;
   1: {128k Spectrum}
      begin
       fread(f,buffer,16384);
       fread(f,pc.l,1);fread(f,pc.h,1);
       fread(f,last_7ffd,1);outport($7ffd,last_7ffd);
       fread(f,x,1); {is TRDOS in mem}
       if (x=1) then
        begin
         if (model<>mpentagon) then
          begin
           set_spectrum_mode(mpentagon);
           close(f);
           loadsna(s);  {nochmal}
          end;
         SRAM[0]:=ROM[2]; {Rom2 == TRDOS ROM !!!!}
        end;
       move(buffer,RAM[last_7ffd and 7]^,16384);
       for x:=0 to 7 do
        if ((x in [2,5,last_7ffd and 7])=false) then
         fread(f,RAM[x]^,16384);
      end;
   2: {Scorpion}
     begin
       fread(f,buffer,16384);
       fread(f,pc.l,1);fread(f,pc.h,1);
       fread(f,last_7ffd,1);outport($7ffd,last_7ffd);
       fread(f,last_1ffd,1);outport($1ffd,last_1ffd);
       fread(f,x,1); {is TRDOS in mem}
       if (x=1) then SRAM[0]:=ROM[3]; {Rom3 == TRDOS SCORPION ROM !!!!}
       move(buffer,RAM[last_7ffd and 7]^,16384);
       for x:=0 to 15 do
        if ((x in [2,5,((Last_1FFD and 16) shr 1) or (last_7ffd and 7)])=false) then
         fread(f,RAM[x]^,16384);
      end;
   end;
   close(f);
end;

procedure Savesna(s:String);
var f: file;
    x: Byte;
begin
   {$i-} assign(f,s);rewrite(f,1);{$i+}
   if ioresult<>0 then exit;
   blockwrite(f,ir.h,1);
   blockwrite(f,hl2.l,1);
   blockwrite(f,hl2.h,1);
   blockwrite(f,de2.l,1);
   blockwrite(f,de2.h,1);
   blockwrite(f,bc2.l,1);
   blockwrite(f,bc2.h,1);
   blockwrite(f,af2.l,1);
   blockwrite(f,af2.h,1);
   blockwrite(f,hl.l,1);
   blockwrite(f,hl.h,1);
   blockwrite(f,de.l,1);
   blockwrite(f,de.h,1);
   blockwrite(f,bc.l,1);
   blockwrite(f,bc.h,1);
   blockwrite(f,iy.l,1);
   blockwrite(f,iy.h,1);
   blockwrite(f,ix.l,1);
   blockwrite(f,ix.h,1);
   blockwrite(f,iff2,1);
   blockwrite(f,ir.l,1);
   {bit7_r:=ir.l and 128; ir.l:=ir.l and 127;}
   blockwrite(f,af.l,1);
   blockwrite(f,af.h,1);
   blockwrite(f,sp.l,1);
   blockwrite(f,sp.h,1);
   blockwrite(f,im,1);
   blockwrite(f,border,1); (* Border *)
   blockwrite(f,RAM[5]^,16384); (* 16384 *)
   blockwrite(f,RAM[2]^,16384); (* 32768 *)
   case model of
    mzx48: blockwrite(f,RAM[0]^,16384); (* 48k *)
    mScorpion: begin
                blockwrite(f,RAM[last_7ffd and 7]^,16384);
                blockwrite(f,pc.l,1);blockwrite(f,pc.h,1);
                blockwrite(f,last_7ffd,1);blockwrite(f,last_1ffd,1);
                if  (sram[0]=ROM[3]) then x:=1 else x:=0; {TRDOS}
                blockwrite(f,x,1); {TRDOS}
                for x:=0 to 15 do if (x in [2,5,((Last_1FFD and 16) shr 1) or (last_7ffd and 7)])=false then
                blockwrite(f,RAM[X]^,16384);
               end;
    else begin {alles andere}
          blockwrite(f,RAM[last_7ffd and 7]^,16384);
          blockwrite(f,pc.l,1);blockwrite(f,pc.h,1);
          blockwrite(f,last_7ffd,1);
          if (model=mpentagon) and (sram[0]=ROM[2]) then x:=1 else x:=0; {TRDOS}
          blockwrite(f,x,1); {TRDOS}
          for x:=0 to 7 do if (x in [2,5,last_7ffd and 7])=false then
           blockwrite(f,RAM[X]^,16384);
         end;
   end;
   close(f);
end;

{-------------------------------- Z80 --------------------------------------}
const mode_128:Boolean=true;
var hmode:Byte;
function read_48k(Var F:file):Boolean;
var block_len, base, addr, count:Word; buffcount:integer; {Word;}
    b, byte2, poker, loopr, x:Byte;
begin
	block_len:=49152;
	fillchar(buffer,$4000,0);
	buffcount:=fread(f,buffer,block_len);
	outport(32765,48);
	addr:=16384;

	count:=0;
	base:=addr;
	repeat
		b:=buffer[count];
		inc(count);
		if(b=237) then
		begin
			byte2:=buffer[count];
			inc(count);
			if (byte2=237) then
			begin
				loopr:=buffer[count];
				inc(count);
				poker:=buffer[count];
				inc(count);
				for x:=0 to loopr-1 do
				begin
					spokeb(base,poker);
					inc(base);
				end;
			end
			else
			begin
				spokeb(base,b);
				inc(base);
				spokeb(base,byte2);
				inc(base);
			end;
		end
		else
		begin
			spokeb(base,b);
			inc(base);
		end;
		if (buffer[count]=0) and (buffer[count+1]=237) and
		   (buffer[count+2]=237) and (buffer[count+3]=0) then
		begin read_48k:=true;exit; end;
		if (base>0) and (base<16384) then
		begin read_48k:=false; exit; end;
	until count>=block_len;
	read_48k:=true;
end;

function read_16k(Var F:file):Boolean;
var base, addr, count:Word;
    page_num, b, byte2, poker, loopr, x:Byte;
    block_len:pair;
begin
	fread(f,block_len.l,1);
	fread(f,block_len.h,1);
	fread(f,page_num,1);
        fillchar(buffer,$4000,0);
	fread(f,buffer,block_len.w);
	if mode_128 then
	begin
		if model=mZX48 then begin wrongmachine:=true; exit; end;
		outport(32765,page_num-3);addr:=49152;
	end
	else
	begin
		outport(32765,48);
		case page_num of
		4  : addr:=32768;
		5  : addr:=49152;
		8  : addr:=16384;
		else addr:=49152;
		end;
	end;
	count:=0;
	base:=addr;
	repeat
		b:=buffer[count];
		inc(count);
		if b=237 then
                begin
			byte2:=buffer[count];
			inc(count);
			if byte2=237 then
			begin
				loopr:=buffer[count];
				inc(count);
				poker:=buffer[count];
				inc(count);
				for x:=0 to loopr-1 do
				begin
					spokeb(base,poker);
					inc(base);
				end;
			end
			else
			begin
				spokeb(base,b);
				inc(base);
				spokeb(base,byte2);
				inc(base);
			end;
		end
		else
		begin
			spokeb(base,b);
			inc(base);
		end;
		if (base-addr)>16384 then begin read_16k:=false; exit;end;
	until count>=block_len.W;
	read_16k:=true;
end;

procedure compress_16k(Var f:File;ram_page,z80_page:Byte);
var b_index:Pair;
    index,XX:Word;
    yy, special:Byte;
    single_ED:Boolean;
begin
 b_index.W:=0;
 single_ED:=false;
 index:=0;
  while index<16384 do
  begin
		yy:=RAM[ram_page]^[index];
		special:=0;
		xx:=1;
		while (xx<256) and (special=0) do
		begin
			if index+xx<16384 then
			begin
				if(RAM[ram_page]^[index+xx]=yy) then inc(xx)
				else special:=1;
				if xx=255 then special:=1;
			end
			else special:=1;

		end;
		if (xx>=2) and ((yy=$ED) or (xx>=5)) then
		begin
			if single_ED=true then
			begin
				buffer[b_index.W]:=yy;inc(b_index.W);
				buffer[b_index.W]:=$ED;inc(b_index.W);
				buffer[b_index.W]:=$ED;inc(b_index.W);
				buffer[b_index.W]:=xx-1;inc(b_index.W);
				buffer[b_index.W]:=yy;inc(b_index.W);
			end
			else
			begin
				buffer[b_index.W]:=$ED;inc(b_index.W);
				buffer[b_index.W]:=$ED;inc(b_index.W);
				buffer[b_index.W]:=xx;inc(b_index.W);
				buffer[b_index.W]:=yy;inc(b_index.W);
			end;
			index:=index+xx;
			single_ED:=false;
		end
		else
		begin
			buffer[b_index.W]:=yy;inc(b_index.W);
			inc(index);
			if(yy=$ED) then single_ED:=true else single_ED:=false;

		end;
	end;
	blockwrite(f,b_index.l,1);
	blockwrite(f,b_index.h,1);
	blockwrite(f,z80_page,1);
	blockwrite(f,buffer,b_index.W);
end;
procedure skip_16k(Var F:File);
var page_num:byte;
    block_len:pair;
begin
	fread(f,block_len.l,1);
	fread(f,block_len.h,1);
	fread(f,page_num,1);
	fread(f,buffer,block_len.W);
end;

function z80_v3(head_block:Word;Var F:file):Boolean;
var btemp, flag, x:Byte;
begin
   if head_block=54 then
   begin
	fread(f,pc.l,1);
	fread(f,pc.h,1);
	fread(f,hmode,1);
	fread(f,last_7ffd,1);
	fread(f,btemp,1);
        fread(f,flag,1);
	fread(f,last_fffd,1);
	fread(f,PSG,sizeof(psg));
	for x:=0 to 30 do fread(f,btemp,1);
	mode_128:=false;
	case hmode of
	0,1,2: (* 48K *)
	    for x:=0 to 2 do
	    begin
	     outport(32765,48);
	     if read_16k(F)=false then begin z80_v3:=false; exit; end;
	    end;
	3: (* Sam Ram *)
	   begin
            for x:=0 to 2 do
	    begin
	     outport(32765,48);
	     if read_16k(F)=false then begin z80_v3:=false; exit; end;
             end;
	     skip_16k(f);
	     skip_16k(f);
	     outport(32765,48);
	     if read_16k(F)=false then begin z80_v3:=false; exit; end;
	    end;
	4,5,6: (* 128K *)
	   begin
	    mode_128:=true;
             if model=mZX48 then begin wrongmachine:=true; exit; end;
	    btemp:=last_7ffd;
	    for x:=0 to 7 do if read_16k(F)=false then begin z80_v3:=false; exit; end;
	    outport(32765,btemp);
	   end;
	else begin z80_v3:=false; exit; end;
   end;
   end;
   z80_v3:=true;
end;

function z80_v2(Var f:File):Boolean;
var ptemp:pair;
    btemp, flag, x:byte;
begin
   fread(f,ptemp.l,1);
   fread(f,ptemp.h,1);
   if ptemp.W=23 then
   begin
	fread(f,pc.l,1);
	fread(f,pc.h,1);
	fread(f,hmode,1);
	fread(f,last_7ffd,1);
	fread(f,btemp,1);
	fread(f,flag,1);
	fread(f,last_fffd,1);
	fread(f,PSG,sizeof(psg));
	mode_128:=false;
	case hmode of
	0,1: (* 48K *)
	  begin
	   for x:=0 to 2 do
	    begin
	     outport(32765,48);
	     if not read_16k(f) then begin z80_v2:=false; exit; end;
	     end;
            end;
	  2:begin (* Sam Ram *)
             for x:=0 to 1 do
	      begin
	       outport(32765,48);
               if not read_16k(f) then begin z80_v2:=false; exit; end;
	      end;
	      skip_16k(f);
	      skip_16k(f);
	      outport(32765,48);
              if not read_16k(f) then begin z80_v2:=false; exit; end;
	      outport(32764,48);
             end;
	  3,4: (* 128K *)
	     begin
	      mode_128:=true;
              if model=mZX48 then begin wrongmachine:=true; exit; end;
	      btemp:=last_7ffd;
	      for x:=0 to 7 do
	       if not read_16k(f) then begin z80_v2:=false; exit; end;
	       outport(32765,btemp);
	      end;
	else begin z80_v2:=false; exit; end;
       end;
	z80_v2:=true;
   end
   else z80_v3(ptemp.w,f);
end;

procedure loadz80(S:String);
var flag, compr:Byte;
    f:File;
begin
   wrongmachine:=false;

   assign(f,s);reset(f,1);
   fread(f,af.h,1);
   fread(f,af.l,1);
   fread(f,bc.l,1);
   fread(f,bc.h,1);
   fread(f,hl.l,1);
   fread(f,hl.h,1);
   fread(f,pc.l,1);
   fread(f,pc.h,1);
   fread(f,sp.l,1);
   fread(f,sp.h,1);
   fread(f,ir.h,1);
   fread(f,ir.l,1);
   ir.l:=ir.l and 127;
   fread(f,flag,1);
   if flag=255 then flag:=1;
   if flag and 1>0 then bit7_r:=128 else bit7_r:=0;
   border:=(flag and 14) shr 1;
   compr:=(flag and 32) shr 5;
   fread(f,de.l,1);
   fread(f,de.h,1);
   fread(f,bc2.l,1);
   fread(f,bc2.h,1);
   fread(f,de2.l,1);
   fread(f,de2.h,1);
   fread(f,hl2.l,1);
   fread(f,hl2.h,1);
   fread(f,af2.h,1);
   fread(f,af2.l,1);
   fread(f,iy.l,1);
   fread(f,iy.h,1);
   fread(f,ix.l,1);
   fread(f,ix.h,1);
   fread(f,iff1,1);
   fread(f,iff2,1);
   fread(f,flag,1);
   im:=flag and 3;
   if pc.W=0 then z80_v2(F) else
   begin
	if compr=0 then
	begin
		outport(32765,48);
		fread(f,RAM[5],16384);
		fread(f,RAM[2],16384);
		fread(f,RAM[0],16384);
	end
	else read_48k(f); (* decompress 48K *)
   end;
   close(f);
   if wrongmachine then
    begin
     set_spectrum_mode(mzx128);
     loadz80(s); {starten wir nochmal}
    end;
   outport(254,border);
end;

procedure savez80(S:String);
var zero, flag, x:Byte;
    f:File;
begin
        zero:=0;
        {$i-} assign(f,s);rewrite(f,1);{$i+}
        if ioresult<>0 then exit;
		blockwrite(f,af.h,1);
		blockwrite(f,af.l,1);
		blockwrite(f,bc.l,1);
		blockwrite(f,bc.h,1);
		blockwrite(f,hl.l,1);
		blockwrite(f,hl.h,1);
		blockwrite(f,zero,1); (* PC = 0 *)
		blockwrite(f,zero,1); (* V2 Rule *)
		blockwrite(f,sp.l,1);
		blockwrite(f,sp.h,1);
		blockwrite(f,ir.h,1);
		blockwrite(f,ir.l,1);

		flag:=32 or (border shr 1); (* 32 = compressed *)
		if bit7_r>0 then flag:=flag or 1; (* bit 7 of r *)
		(* bit 4 Samrom switched in is ignored (0) *)
		blockwrite(f,flag,1);

		blockwrite(f,de.l,1);
		blockwrite(f,de.h,1);
		blockwrite(f,bc2.l,1);
		blockwrite(f,bc2.h,1);
		blockwrite(f,de2.l,1);
		blockwrite(f,de2.h,1);
		blockwrite(f,hl2.l,1);
		blockwrite(f,hl2.h,1);
		blockwrite(f,af2.h,1);
		blockwrite(f,af2.l,1);
		blockwrite(f,iy.l,1);
		blockwrite(f,iy.h,1);
		blockwrite(f,ix.l,1);
		blockwrite(f,ix.h,1);
		blockwrite(f,iff1,1);
		blockwrite(f,iff2,1);

		flag:=im;
                {flag:=im or (joy_type shr 6);
		if(keyboard_issue=255) then flag:=flag or 4;}
		blockwrite(f,flag,1);

		x:=23;
		blockwrite(f,x,1);
		blockwrite(f,zero,1);
		blockwrite(f,pc.l,1);
		blockwrite(f,pc.h,1);
		if model<>mZX48 then x:=3 else x:=0;
		blockwrite(f,x,1);
		blockwrite(f,last_7ffd,1);
		blockwrite(f,zero,1); (* IF 1 not paged in *)
		x:=3;
		blockwrite(f,x,1); (* R and LDIR on *)
		blockwrite(f,last_fffd,1);
		blockwrite(f,psg,sizeof(psg));
		if model<>mZX48 then
			for x:=0 to 7 do compress_16k(f,x,x+3) else
                begin
			compress_16k(f,2,4);
			compress_16k(f,0,5);
			compress_16k(f,5,8);
		end;
		close(f);
end;
{------------------------- Voc --------------------------------------------}
var line_counter, VOC_block_len:longint;
    no_of_t_before_next:longint;
    last_t_VOC_in:longint;

const threshold:byte=30;
      no_of_t_vary:Byte=0;

var   sample_rate_in:Word;
      Voc_f:file;

procedure process_block;
var block_type, temp:Byte;
begin
	fread(Voc_f,block_type,1);
	case block_type of
	 0 : (* Window, end of file message *) close(Voc_f);
	 1 : begin
	      fread(Voc_f,buffer,3);
	      VOC_block_len:=buffer[2] shl 8;
	      VOC_block_len:=(voc_block_len or buffer[1]) shl 8;
	      VOC_block_len:=VOC_block_len or buffer[0];
	      fread(Voc_f,buffer,2);
	      sample_rate_in:=1000000 div (256-buffer[0]);
	      temp:=0-buffer[0];
	      no_of_t_before_next:=(temp*7) div 2;
	      no_of_t_before_next:=no_of_t_before_next+shortint(no_of_t_vary);
	      dec(VOC_block_len,2);
	      if buffer[1]<>0 then
			begin
			 (* Error, packed data *)
			 close(Voc_f);
			 end;
             end;
	 else
			(* Error, cannot handle other blocks *)
			close(Voc_f);
    end;
end;

procedure LoadVOC(S:String);
var start_of_data:longint;
begin
        assign(Voc_f,s);reset(Voc_f,1);
	fread(Voc_f,buffer,$19); {Header}
	start_of_data:=(buffer[$15] shl 8) or buffer[$14];
	seek(Voc_f,start_of_data);
	process_block; (* Work out sample rate *)

	last_t_VOC_in:=0;
        line_counter:=0;

end;

function return_next_bit:Byte;
var last_bit,DSP_byte:Byte;
    bytes_passed, time_passed, current_t:longint;
begin
 last_bit:=0;
 current_t:=(line_counter*t_states_per_line)+t_state;
 time_passed:=current_t-last_t_VOC_in;
 bytes_passed:=time_passed div no_of_t_before_next;
 if bytes_passed>0 then
	begin
		while bytes_passed>0 do
		begin
			if VOC_block_len=0 then process_block;
			if VOC_file_open then
                         fread(Voc_f,DSP_byte,1);
			dec(VOC_block_len);
			dec(bytes_passed);
		end;
		if (DSP_byte>(128+threshold)) then last_bit:=64;
		if(DSP_byte<(128-threshold)) then last_bit:=0;
		last_t_VOC_in:=current_t;
	end;
 return_next_bit:=last_bit;
end;

end.