(* In this unit are all global variables, since Version 0.9 Ive splitted   *)
(* the variables and memory parts into two pieces ! Have a look at          *)
(* Machine.pas                                                              *)

{$i compile.inc}
Unit vars {& Misc};

interface uses dos;

const
           {Display}
           vline:Word=0;
           flash_counter:Byte=0;
           flash_status:Boolean=False;
           realborder:Boolean=True;

           {Others}
           usestick: Boolean=False;

           {Timing}
           timerVar:word=0;
           timerproc: pointer=NIL;
           RealSpeed: Boolean=True;
           ShowSpeed: Boolean=False;
           frame_skip: Byte = 1;
           interlace : Boolean=False;
{Registers...................................................................}

type
     pair=record
        case boolean of
           false: (l,h:Byte);
           true: (W:Word);
        end;
        quadruple=record
           case byte of
              0: (b1,b2,b3,b4:Byte);
              1: (w1,w2:Word);
              2: (q:longint);
           end;

var af, bc, de, hl:pair;
    ix, iy:pair;
    sp, pc:pair;
    ir: Pair;
    im   : Byte;
    AF2,BC2,DE2,HL2: Pair; { == AF' BC' DE' HL'}
    iff1, iff2, bit7_r: Byte;
    border:Byte;

    halt, quit:Byte;
    qtemp: quadruple;
    ptemp:pair;

{Sound.......................................................................}

    PSG:array[0..15] of byte; {AY 8910}

{Keyboard....................................................................}

    skey:Array[0..7] of byte; {Each Spectrum Key is saved inside this Array}
    stickvalue:Byte; {Joystick}
    joykeys: record up,down,left,right,fire:byte; end;

{Memory......................................................................}

type tmem=array[0..$4000-1] of byte;
     pmem=^tmem;
     tmemory=array[0..$FFFF {C000-1}] of byte;

var
     BUFFER:tmemory{=NIL};

function wordpeek(Addr:Word):Word;
procedure wordpoke(addr,val:Word);

{$i tables.inc}

implementation

uses CRT,Core,Machine;

function wordpeek(Addr:Word):Word;
begin
 wordpeek:=((speekb((addr)+1) shl 8) or speekb(addr))
end;

procedure wordpoke(addr,val:Word);
begin
 spokeb(addr, LO(val));spokeb(addr + 1, HI(val));
end;

procedure calc_intable;
var i,j:Byte;
begin
  for i:=0 to 255 do
  begin
        { $ifndef assembler}
        if i=0 then j:=64 else j:=0;
	add8_table[i]:=(i and 168) or (j); (* Just HVC to do! *)
	sub8_table[i]:=(i and 168) or (j) or 2;
	cpsub8_table[i]:=(i and 128) or (j) or 2; (* 5 bits left.. *)
        { $endif}
        in_table[i]:=(i and 168) or (parity[i]);
	in_table[0]:=in_table[0] or 64; (* Don't forget to keep old C flag *)
  end;
end;
var s:String;

BEGIN
 textattr:=7;ClrScr;
 textcolor(15); TextBackground(4);
 s:='';while length(s)<80 do s:=s+' ';
 gotoxy(1,1);writeln(s);
 WriteCentered('Initialising System',1);
 Textcolor(8); Textbackground(0);
 gotoxy(1,2);
 Window(2,3,78,21);
 gotoxy(1,1);
 Textcolor(7); TextBackground(0);

 calc_intable;
end.
