{ YASE V0.8a                                   (C) 1997,00 Christian Hackbart}
{$i compile.inc}
uses core,dpmi,lfn, dos,tape,SndDrv,Speaker,Adlib,TRDOS,
     grafx,z80mon,machine,
     Vars,z80cpu,files,{$ifdef debugger} disasm {$endif};

const ver:string='V0.8a';

{ $i disasm.inc}

procedure saveConfig;
var f:File;
begin
 assign(f,startdir+'Yase.CFG');rewrite(f,1);
 blockwrite(f,vidmode,sizeof(vidmode));
 blockwrite(f,realborder,1);
 blockwrite(f,interlace,1);
 blockwrite(f,white_noise,1);
 blockwrite(f,smode,1);
 blockwrite(f,smode48k,1);
 blockwrite(f,realspeed,1);
 blockwrite(f,showspeed,1);
 blockwrite(f,position,sizeof(position));
 blockwrite(f,ula_delay,sizeof(ula_delay));
 blockwrite(f,cpu_delay,sizeof(cpu_delay));
 blockwrite(f,frame_skip,sizeof(frame_skip));
 blockwrite(f,UseStick,1);
 blockwrite(f,joykeys,sizeof(joykeys));
 blockwrite(f,realborder,1);
 if model=muser then model:=mPentagon;
 blockwrite(f,model,sizeof(model));
 close(F);
end;

procedure LoadConfig;
var f:File;
    nr:longint;
begin
 {$i-}
 assign(f,startdir+'Yase.CFG');reset(f,1);
 if ioresult<>0 then exit;
 blockread(f,vidmode,sizeof(vidmode),nr);
 blockread(f,realborder,1,nr);
 blockread(f,interlace,1,nr);
 blockread(f,white_noise,1,nr);
 blockread(f,smode,1,nr);
 blockread(f,smode48k,1,nr);
 blockread(f,realspeed,1,nr);
 blockread(f,showspeed,1,nr);
 blockread(f,position,sizeof(position),nr);
 blockread(f,ula_delay,sizeof(ula_delay),nr);
 blockread(f,cpu_delay,sizeof(cpu_delay),nr);
 blockread(f,frame_skip,sizeof(frame_skip),nr);
 blockread(f,UseStick,1,nr);
 blockread(f,joykeys,sizeof(joykeys),nr);
 blockread(f,realborder,1,nr);
 blockread(f,model,sizeof(model),nr);
 close(F);
 {$i+}
end;

procedure tapeoptions;
var
  P: PathStr;
  D: DirStr;
  N: NameStr;
  E: ExtStr;
  c:word;
begin
 if not tap_file_open then exit;
 FSplit(Tap_Filename, D, N, E);
 box(20,15,210,25,117);souttextxy(25,18,'Browse Tapefile : '+N+E,118,119);
 box(20,40,210,150,117);
 c:=showtap(24,45,TAPElist,anzentry,16);
 if c<=anzentry then seek(f_handle, tapelist[c].real.start);
end;

function insert(s,t:string;len,posi:byte):String;
var i:byte;
begin
 while length(t)<len do t:=t+' ';
 if s[1]='#' then inc(posi);
 for i:=1 to len do s[posi+i-1]:=t[i]; insert:=s;
end;

procedure joystickoptions;

 function getkey:Byte;
 var i: Byte;
 begin
  initint09(false);
  repeat until anypressed;
  for i:=1 to 127 do if key[i] then begin getkey:=i; end;
  restoreint09;
 end;

const joyMenuTxt:array[0..6] of string =(
     'Up                    [      ]',
     'Down                  [      ]',
     'Left                  [      ]',
     'Right                 [      ]',
     'Fire                  [      ]',
     '',
     'Analogue joystick     [ ]');
var c,lr:Byte;
    xp,yp:Byte;
begin
 xp:=25;yp:=35;
 box(10,10,220,100,117);
 souttextxy(71,15,'JOYSTICK OPTIONS:',118,119);
 h_line2(14,24,202,119,118);
 if usestick then c:=6 else c:=0;
 repeat
  for lr:=0 to 4 do if joymenutxt[lr][1]='#' then delete(joymenutxt[lr],1,1);
  joymenutxt[0]:=insert(joymenutxt[0],keyname[joykeys.up],   6,24);
  joymenutxt[1]:=insert(joymenutxt[1],keyname[joykeys.down], 6,24);
  joymenutxt[2]:=insert(joymenutxt[2],keyname[joykeys.left], 6,24);
  joymenutxt[3]:=insert(joymenutxt[3],keyname[joykeys.right],6,24);
  joymenutxt[4]:=insert(joymenutxt[4],keyname[joykeys.fire], 6,24);
  if usestick then
   begin
    for lr:=0 to 4 do joymenutxt[lr]:='#'+joymenutxt[lr];
    joymenutxt[6][24]:='X'
   end else
   begin
    joymenutxt[6][24]:=' ';
   end;
  c:=choose(xp,yp, 119,117,joymenutxt,c,lr);
  if lr=0 then
  with joykeys do
  case c of
  0: begin outtextxy(xp+124,yp-1,'      ',119,120);up:=getkey;lr:=2; end;
  1: begin outtextxy(xp+124,yp+7,'      ',119,120);down:=getkey;lr:=2; end;
  2: begin outtextxy(xp+124,yp+15,'      ',119,120);left:=getkey;lr:=2; end;
  3: begin outtextxy(xp+124,yp+23,'      ',119,120);right:=getkey;lr:=2; end;
  4: begin outtextxy(xp+124,yp+31,'      ',119,120);fire:=getkey;lr:=2; end;
  6: begin usestick:=not usestick;lr:=2; end;
  end;
 until lr in [0,3];
end;

procedure setSoundMode(Mode:Byte);
begin
{ if mode=smode then exit;}
 case mode of
  0: snddrv.sound:=noSoundDRV;
  1: snddrv.Sound:=SpeakerDRV;
  2: snddrv.Sound:=AdlibDRV;
 end;
 if snddrv.sound.init=true then smode:=mode else
 begin snddrv.sound:=noSoundDRV;smode:=0; end;
end;

procedure setSound48k(Mode:Byte);
begin
 case mode of
  0: snddrv.tune48k:=SilenceTune;
  1: snddrv.tune48k:=SpeakerTune;
  2: if soundblaster then snddrv.tune48k:=BlasterTune;
 end;
 smode48k:=mode;
end;

procedure gfx_soundoptions;
const soundMenuTxt:array[0..6] of string =(
     'Sound Device          [       ]',
     'AY 8912               [       ]',
     '#Stereo                [    ]',
     '',
     'Video Resolution      [       ]',
     'Realborder            [ ]',
     'Interlace             [ ]');
     Device:array[0..2] of string=('NONE','SPEAKER','BLASTER');
     MusicDev:array[0..2] of string=('NONE','SPEAKER','OPL');
     Stereo:array[0..2] of string=('MONO','ACB','ABC');
var oldvidmode,c,lr:Byte;
    xp,yp:Word;
    s:String;
begin
 xp:=25;yp:=35;
 box(10,10,220,93,117);
 souttextxy(71,15,'SOUND OPTIONS:',118,119);
 h_line2(14,24,202,119,118);
 h_line2(14,60,202,119,118);
 c:=0;
 oldvidmode:=vidmode;
 repeat
  soundmenutxt[0]:=insert(soundmenutxt[0],device[smode48k],7,24);
  soundmenutxt[1]:=insert(soundmenutxt[1],MusicDev[smode],7,24);
  soundmenutxt[4]:=insert(soundmenutxt[4],GFXMode[vidmode].name,7,24);
  if realborder then soundmenutxt[5][24]:='X' else soundmenutxt[5][24]:=' ';
  if interlace then soundmenutxt[6][24]:='X' else soundmenutxt[6][24]:=' ';
  if (position[0]=0) and (position[1]=0) and (position[2]=0) then lr:=0 else
  if (position[0]=0) and (position[1]=0) and (position[2]=1) then lr:=1 else
  if (position[0]=0) and (position[1]=1) and (position[2]=0) then lr:=2;

  soundmenutxt[2]:=insert(soundmenutxt[2],Stereo[lr],4,24);
  c:=choose(xp,yp, 119,117,soundmenutxt,c,lr);
  if lr<>3 then
  case c of
   0: begin
       if lr=1 then
        begin
         if smode48k>0 then setSound48k(smode48k-1);
        end else
       if lr=2 then
        begin
          if smode48k<2 then setSound48k(smode48k+1);
        end;
        lr:=1;
       end;
   1: begin
       if lr=1 then
        begin if smode>0 then setSoundmode(smode-1) end
        else begin if smode<2 then setSoundmode(smode+1) end;
        lr:=1;
       end;
   2: begin (* Stereo *)
       if (position[0]=0) and (position[1]=0) and (position[2]=0) then
       begin position[0]:=0; position[1]:=0; position[2]:=1; end else
       if (position[0]=0) and (position[1]=0) and (position[2]=1) then
       begin position[0]:=0; position[1]:=1; position[2]:=0; end else
       if (position[0]=0) and (position[1]=1) and (position[2]=0) then
       begin position[0]:=0; position[1]:=0; position[2]:=0; end;
       lr:=1;
      end;
   4: begin
       if lr=1 then
        begin if vidmode>low(gfxmode) then dec(vidmode);end else
        begin
          if vidmode<high(gfxmode) then inc(vidmode);
        end;
       lr:=1;
      end;
   5: begin
       if lr=0 then realborder:=not realborder;lr:=1;
      end;
   6: begin
       if lr=0 then interlace:=not interlace;
       lr:=1;
      end;
  end;
 until lr in [0,3];
 if vidmode<>oldvidmode then
  begin
   move(sp_screen^,buffer,6912);
   closegraph;
   oldvidmode:=border;border:=0;
   initgraph(vidmode);
   setpal;
   repaintall;
   move(buffer,sp_screen^,6912);
   border:=oldvidmode;
  end;
end;

procedure genericoptions;
const genericMenuTxt:array[0..4] of string =(
   'ALTER ULA DELAY',
   'ALTER SCREEN SKIP',
   'ALTER DELAY',
   'REAL SPEED [ ]',
   'SHOW SPEED [ ]');
var c,lr:Byte;
begin
 box(10,10,160,74,117);
 souttextxy(45,15,'GENERIC OPTIONS:',118,119);
 h_line2(14,24,142,119,118);
 c:=0;
 repeat
  genericMenuTXT[0]:='ALTER ULA DELAY '+i2s(ula_delay,3,' ');
  genericMenuTXT[1]:='ALTER SCREEN SKIP 1/'+i2s(frame_skip+1,1,' ')+'  ';
  genericMenuTXT[2]:='ALTER DELAY '+i2s(cpu_delay,4,' ');
  if realspeed then
   begin
    genericMenuTXT[1]:='#'+genericMenuTXT[1];
    genericMenuTXT[2]:='#'+genericMenuTXT[2];
    genericMenuTXT[3][13]:='X';
   end else genericMenuTXT[3][13]:=' ';

  if showspeed then genericMenuTXT[4][13]:='X' else  genericMenuTXT[4][13]:=' ';
  c:=choose(25,35,119,117,genericMenuTXT,c,lr);
  if lr<3 then
  case c of
  0:begin
     if lr=1 then if ula_delay>0 then dec(ula_delay) else ula_delay:=500;
     if lr=2 then if ula_delay<500 then inc(ula_delay) else ula_delay:=0;
    end;
  1:begin
     if lr=1 then if frame_skip>0 then dec(frame_skip) else frame_skip:=255;
     if lr=2 then if frame_skip<255 then inc(frame_skip) else frame_skip:=0;
    end;
  2:begin
     if lr=1 then if cpu_delay>0 then dec(cpu_delay) else cpu_delay:=5000;
     if lr=2 then if cpu_delay<5000 then inc(cpu_delay) else cpu_delay:=0;
    end;
  3:if lr=0 then begin realspeed:=not realspeed;lr:=1; end;
  4:if lr=0 then begin showspeed:=not showspeed;lr:=1; end;
  end;
 until lr in [0,3];
end;

procedure interface3options;begin end;

procedure changemodel;
const modell:array[0..7] of string=
      ('SPECTRUM 48k','SPECTRUM 128k','SPECTRUM +2',
       'SPECTRUM +3','DIDAKTIK 128k','PENTAGON 128k','SCORPION 256k','#none');
var c,lr:byte;
begin
 box(10,10,120,98,117);
 souttextxy(31,15,'RESET IN MODE:',118,119);
 h_line2(14,24,102,119,118);
 c:=byte(model);
 if (c=7) and (userrom='') then c:=0;
 if userrom<>'' then
  begin
   modell[7]:=userrom;
   while pos('\',modell[7])>0 do delete(modell[7],1,pos('\',modell[7]));
  end;
 repeat
  c:=choose(25,35,119,117,modell,c,lr);
 until lr in [0,3];
 if lr=0 then set_spectrum_mode(ZXModels(c));
end;

procedure showlayout;
var old:Byte;
begin
 move(sp_screen^,buffer,6912);
 loadscr(startdir+'layout.scr');
 old:=border;border:=0;
 display;
 readkey; while keypressed do readkey;
 move(buffer,sp_screen^,6912);
 border:=old;
end;

{$ifndef debugger}
procedure showdebuggeR;
begin
end;
{$endif}

const menu: array[0..16] of
     string=('LOAD A TAP OR SNAPSHOT FILE (F2)',
             'SAVE SNAPSHOT FILE (F3)',
             'SAVE SCREENSHOT (F4)',
             'TAPE OPTIONS (ALT+F2)','',
             'RESET (F5) CURRENT MACHINE',
             'NMI (F6)',
             'DEBUGGER (F7)','',
             'GENERIC OPTIONS',
             'GRAPHIC AND SOUND OPTIONS',
             'JOYSTICK OPTIONS',
             'INTERFACE I/+3 OPTIONS','',
             'CHANGE MEMORY MODEL (F8)',
             'SHOW KEYBOARD LAYOUT (F9)',
             'EXIT YASE (F10)');

procedure mainmenu;
var lr,c:Byte;
label anfang;
begin
 c:=0;
 anfang:
 box(20,10,300,168,117);
 souttextxy(45,14,'YASE '+Ver+' (C) 1997-2000 BY CHRISTIAN HACKBART',118,119);
 h_line2(25,24,270,119,118);h_line2(25,63,270,119,118);h_line2(25,95,270,16,118);
 h_line2(25,135,270,119,118);
 box(20,180,300,190,117); souttextxy(100,183,'PRESS ESCAPE TO RETURN.',118,119);
 repeat
  c:=choose(28,30,119,117,menu,c,lr);
  if lr=0 then
  case c of
  00: begin repaintall; selectfile;repaintall; goto anfang; end;
  01: begin repaintall; savefile; repaintall;goto anfang;end;
  02: begin repaintall; savescreen; repaintall;goto anfang;end;
  03: if tap_file_open then begin repaintall; tapeoptions; repaintall;goto anfang;end;
  05: begin {set_spectrum_mode(model);} machine_reset;c:=high(menu);lr:=3; end;{Reset}
  06: begin machine_nmi;c:=high(menu);lr:=3; end;{NMI}
  07: begin repaintall; showdebugger;repaintall; goto anfang; end;
  09: begin repaintall; genericoptions; repaintall;goto anfang;end;
  10: begin repaintall; gfx_soundoptions; repaintall;goto anfang;end;
  11: begin repaintall; joystickoptions;repaintall;goto anfang;end;
  {12: begin repaintall; interface3options; repaintall;goto anfang;end;}
  14: begin repaintall;changemodel;C:=high(menu);lr:=3;end;
  15: begin repaintall; showlayout;repaintall; goto anfang; end;
 end;
 until (c=high(menu)) and (lr in [0,3]);
 if (c=high(menu)) and (lr=0) then key[68]:=true;
 repaintall;
end;

{---------------------------------------------------------------------------}
{$ifdef debug}
procedure showfps;
var i:Word;
begin
  i:=frame_skip;if i<1 then i:=1;
  souttextxy(1,1,i2s(framepersecond*i,3,' ')+' fps',118,119);
end;
{$endif}


 procedure newint08;
 begin
   inc(timervar);
   asm
    mov ax,$20
    out $20,ax
   end;
  end;

procedure initint08;
begin
 settimer(DosintrCount-2);
 timervar:=0;
 getintvec($8,timerproc);
 setintvec($8,addr(newint08));
end;

procedure restoreint08;
begin
 setintvec($8,timerproc);
 timerproc:=nil;
 settimer($FFFF);
end;

var  dummy:Byte;
begin
  with joykeys do
  begin
   up:=16;down:=30;left:=24;right:=25;fire:=57;
  end;

 initnew('mainprogram');

 LoadConfig;

 initmem;
 setSoundMode(smode);
 setsound48k(smode48k);
 sound.init;

 DisplayNew('==============================================================');
 DisplayNew(' YaSE SOURCE CODE RELEASE version.');
 DisplayNew('  copyright 1997-2000, Christian Hackbart.');
 DisplayNew('  This program can be freely distributed as long as no money');
 DisplayNew('  is asked for it.');
 DisplayNew('==============================================================');
 DisplayNew('press and key');
 repeat until keypressed; while keypressed do readkey;
 initgraph(vidmode);
 setpal;
 loadscr('yase.scr');repaintall;
 repeat until keypressed; while keypressed do readkey;
 set_spectrum_mode(model);machine_reset;
 repeat
  halt:=0;
  initint08;
  initint09(true);
   if model in [mPentagon,mScorpion] then diskvg($A,dummy);
   z80_decode;
   if model in [mPentagon,mScorpion] then diskvg($B,dummy);
  restoreint09;
  restoreint08;

  if key[59] then begin {$ifdef debug} showfps; {$endif} mainmenu end else

  if (key[60]) and (key[56]) and (tap_file_open) then  {Alt+F2}
     begin tapeoptions;repaintall; end else

  if key[60] then begin selectfile;repaintall; end else
  if key[61] then begin savefile;repaintall; end else
  if key[62] then begin savescreen;repaintall; end else
  if key[63] then {set_spectrum_mode(model)} machine_reset else
  if key[64] then machine_nmi else
  if key[65] then begin showdebugger;repaintall; end else
  if key[66] then begin changemodel;repaintall; end else
  if key[67] then begin showlayout;repaintall;end; {else}

  {if realspeed then frame_skip:=0; {reset the frameskip}
 until key[68];
 sound.done;
 closegraph;
 saveConfig;
 closemem;
 {$i-}
  chdir(copy(startdir,1,length(startdir)-1));
  if tap_file_open then close(f_handle);
 {$i+}
 writeln('TNX for using the emu');
 {Dirty but useful, if you won't get an error message each time you exit}
 {halt_error:='';}
end.
