{$i compile.inc}
Unit z80Mon;

Interface uses dpmi;

var speccyline: array[0..191] of word;
    reverse_attr:array[0..127] of byte;
    vga_h_nib:array[0..15,0..127] of longint;
    vga_h_nib_double:array[0..15,0..127,0..1] of longint;
    CenterX_2x,CenterY_2x,
    CenterX,CenterY:WORD; {Position for the Display}

procedure updateline(Y:word); {draw each line 0-191}
Procedure Display;            {Paint only the screen}
Procedure RepaintAll;         {Repaint the screen and the Border}
procedure Setpal;             {Set the Speccy-Pal}
procedure showstatus(reinit:Boolean);
procedure CalcCenter;

const rgb:array[0..16*3-1] of byte=(
 0,0,0,0,0,40,55,0,0,57,0,45,0,53,0,0,53,53,52,52,0,50,50,50,
 0,0,0,0,0,43,60,0,0,63,0,55,0,60,0,0,63,63,63,63,0,63,63,63);
 { PURPUR,      WEISS,   SCHWARZ,    CYAN}
 menucol:array[0..17] of byte=
 (115,115,115,165,165,240,255,255,255,10,10,20,67,255,255, 255,255,000);

const oldborder:Byte=255;

Implementation
uses dos,core,vars,vbe2,grafx,machine;

procedure setpal;
var i: longint;
begin
 port[$3c8]:=0;for i:=0 to 16*3-1 do port[$3c9]:=rgb[i];
 port[$3c8]:=116;for i:=0 to 17 do port[$3c9]:=menucol[i];
 Fill($FF);
end;

(* Status **************************************************************)
const oldpos:integer=0;
procedure showstatus(reinit:Boolean);
var percentage:integer;
    cx,cy:Word;
begin
 cx:=currentx-24;
 cy:=currenty shr 1-30;
 if reinit then
  begin
   number_outtextxy(cx,cy,'100%',118,119);
   number_outtextxy(cx,currenty shr 1+76,'  0%',118,119);
  end;
 if frame_skip>25 then percentage:=110 else percentage:=frame_skip shl 2;
 if percentage<>oldpos then
  number_outtextxy(cx-6,cy+oldpos,'-',255,255);
 oldpos:=percentage;
  number_outtextxy(cx-6,cy+percentage,'-',118,119);
end;
(***********************************************************************)

procedure make_table;
var  v,x,y,z:integer;
     fore_attrib,back_attrib:array[0..255] of byte;
     l1,qtemp:Quadruple;
begin
 v:=0;
 for x:=0 to 2 do
   for y:=0 to 7 do
     for z:=0 to 7 do
      begin
       speccyline[v]:=x shl 11+y shl 5+z shl 8;
       inc(v);
      end;
 for x:=0 to 255 do
  begin
   y:=x and 7; (* fore *)
   z:=(x and 56) shr 3; (* back *)
   if y=0 then y:=y or 8;
   if z=0 then z:=z or 8;
		if x and 64>0 then
		begin
			y:=y or 8;
			z:=z or 8;
		end;
		fore_attrib[x]:=y;
		back_attrib[x]:=z;
	end;

	for x:=0 to 15 do
	begin
		for y:=0 to 127 do
		begin
			if x and 1>0 then

				qtemp.b4:=fore_attrib[y]
			else
				qtemp.b4:=back_attrib[y];
			if x and 2>0 then
				qtemp.b3:=fore_attrib[y]
			else
				qtemp.b3:=back_attrib[y];

			if x and 4>0 then
				qtemp.b2:=fore_attrib[y]
			else
				qtemp.b2:=back_attrib[y];
			if x and 8>0 then
				qtemp.b1:=fore_attrib[y]
			else
				qtemp.b1:=back_attrib[y];
			vga_h_nib[x][y]:=qtemp.Q;
		end;
	end;
	for x:=0 to 127 do
	begin
		y:=(x and 7) shr 3;
		z:=(x and 56) shr 3;
		reverse_attr[x]:=(x and 64) or y or z;
	end;
for x:=0 to 15 do
 for y:=0 to 127 do
  begin
   qtemp.q:=vga_h_nib[x][y];
   l1.b1:=qtemp.b1;l1.b2:=qtemp.b1; l1.b3:=qtemp.b2;l1.b4:=qtemp.b2;
   vga_h_nib_double[x][y][0]:=l1.q;
   l1.b1:=qtemp.b3;l1.b2:=qtemp.b3; l1.b3:=qtemp.b4;l1.b4:=qtemp.b4;
   vga_h_nib_double[x][y][1]:=l1.q;
  end;
end;

{procedure fillborder(Y,centerx,centery:WORD);
var yp,x:Word;
begin
 x:=currentx-centerx;
 yp:=y+centery;

 H_LINE(0,yp,centerx,border); H_LINE(x,yp,centerx,border);

 yp:=centery*currentx;
 if y=0 then h_line(0,0,yp,border);
 if y>=191 then h_line(0,currenty-centery,yp(*-centery*),border);
end;}

procedure updateline_Stretched(Y:word);
var bitmap, farbepos:word;
    offs,offs2:longint;
     x, color, attr, data:Byte;
begin
        offs:=longint(screenbuffer)+(y shl 1+centery_2x)*currentx+centerx_2x;
       {$ifdef realborder} fillborder(y shl 1,centerx_2x,centery_2x);{$endif}
         if oldborder<>border then
         begin
          oldborder:=border;
          {$ifndef realborder}
           port[$3c8]:=255;x:=border*3;
           port[$3c9]:=rgb[x];
           port[$3c9]:=rgb[x+1];
           port[$3c9]:=rgb[x+2];
          {$endif}
        end;

	bitmap:=speccyline[y];
	farbepos:=6144 or ((y and 248) shl 2);
        for x:=0 to 31 do
         begin
          color:=sp_SCREEN^[farbepos];inc(farbepos);
          asm
           mov al,color
           and al,127
           mov attr,al
          end;
  	  if (color and 128>0) and (flash_status) then
           attr:=reverse_attr[attr];

 	  data:=SP_SCREEN^[bitmap];inc(bitmap);

          meml[offs]:=vga_h_nib_double[(data and $F0) shr 4][attr][0];inc(offs,4);
          meml[offs]:=vga_h_nib_double[(data and $F0) shr 4][attr][1];inc(offs,4);
          meml[offs]:=vga_h_nib_double[data and $0F][attr][0];inc(offs,4);
          meml[offs]:=vga_h_nib_double[data and $0F][attr][1];inc(offs,4);

          if not interlace then
           begin
            offs2:=offs-16+currentx;
            meml[offs2]:=vga_h_nib_double[(data and $F0) shr 4][attr][0];inc(offs2,4);
            meml[offs2]:=vga_h_nib_double[(data and $F0) shr 4][attr][1];inc(offs2,4);
            meml[offs2]:=vga_h_nib_double[data and $0F][attr][0];inc(offs2,4);
            meml[offs2]:=vga_h_nib_double[data and $0F][attr][1];inc(offs2,4);
           end;
         end;
 end;

procedure updateline(Y:word);
var bitmap, farbepos:word;
    offs:longint;
     x, color, attr, data:Byte;
begin
         if currentx>=640 then begin updateline_stretched(Y);exit;end;
         if (interlace) (*or (currenty>=400)*) then
         begin
          {$ifdef realborder} fillborder(y shl 1,centerx,centery_2x);{$endif}
          offs:=longint(screenbuffer)+(y shl 1+centery_2x)*currentx+centerx;
         end else
         begin
          {$ifdef realborder} fillborder(y,centerx,centery);{$endif}
          offs:=longint(screenbuffer)+(y+centery)*currentx+centerx;
         end;
         if oldborder<>border then
         begin
          oldborder:=border;
          {$ifndef realborder}
           port[$3c8]:=255;x:=border*3;
           port[$3c9]:=rgb[x];
           port[$3c9]:=rgb[x+1];
           port[$3c9]:=rgb[x+2];
          {$endif}
        end;

	bitmap:=speccyline[y];
	farbepos:=6144 or ((y and 248) shl 2);
        for x:=0 to 31 do
         begin
          color:=sp_SCREEN^[farbepos];inc(farbepos);
          asm
           mov al,color
           and al,127
           mov attr,al
          end;
  	  if (color and 128>0) and (flash_status) then
           attr:=reverse_attr[attr];

 	  data:=SP_SCREEN^[bitmap];inc(bitmap);

          meml[offs]:=vga_h_nib[(data and $F0) shr 4][attr];inc(offs,4);
          meml[offs]:=vga_h_nib[data and $0F][attr];inc(offs,4);
          (*if (currenty>=400) and (not interlace) then {lets double the whole line}
          begin
           meml[offs+currentx-8]:=vga_h_nib[(data and $F0) shr 4][attr];
           meml[offs+currentx-4]:=vga_h_nib[data and $0F][attr];
          end;*)
         end;
 end;



Procedure Display;
Var Y: Byte;
begin
 for y:=0 to 191 do updateline(y);
end;

procedure CalcCenter;
begin
 centerx:=(currentx-256 {maxx}) shr 1;
 centery:=(currenty-191 {maxy}) shr 1;
 centerx_2x:=(currentx-512 {maxx}) shr 1;
 centery_2x:=(currenty-(191*2) {maxx}) shr 1;
end;

Procedure RepaintAll;
var i:word;
begin
 Fill($FF);
 if realborder then drawellipse(0,0);
 if currenty<400 then interlace:=false;

 if interlace then
  for i:=1 to currenty do h_line(0,i shl 1,currentx,0);
 CalcCenter;
 Display;
 if showspeed then showstatus(true);
end;

begin
 initnew('Spectrum Display Unit');
 displaynew('Creating Tables');
 make_table;
end.

(* Old Stuff *)
procedure updateline_stretched(Y:word);
var bitmap, farbepos:word;
    x, color, attr, data:Byte;
    line:array[0..31] of record l1,l2,r1,r2:longint;end;
begin
	{$ifdef debug} if y=191 then nextframe;{$endif}
         if oldborder<>border then
         begin
          oldborder:=border;

           port[$3c8]:=255;x:=border*3;
           port[$3c9]:=rgb[x];
           port[$3c9]:=rgb[x+1];
           port[$3c9]:=rgb[x+2];

        end;

	bitmap:=speccyline[y];
	farbepos:=6144 or ((y and 248) shl 2);
        for x:=0 to 31 do
         begin
          color:=sp_SCREEN^[farbepos];inc(farbepos);
          asm
           mov al,color
           and al,127
           mov attr,al
          end;
  	  if (color and 128>0) and (flash_status) then
           attr:=reverse_attr[attr];

 	  data:=SP_SCREEN^[bitmap];inc(bitmap);

          with line[x] do
          begin
           l1:=vga_h_nib_double[(data and $F0) shr 4][attr][0];
           l2:=vga_h_nib_double[(data and $F0) shr 4][attr][1];
           r1:=vga_h_nib_double[data and $0F][attr][0];
           r2:=vga_h_nib_double[data and $0F][attr][1];
          end;

         end;

    if interlace then
     put_line(centerx_2x,y shl 1+centery_2x,sizeof(line),line)
    else
    begin
     put_line(centerx_2x,y shl 1+centery_2x,sizeof(line),line);
     put_line(centerx_2x,y shl 1-1+centery_2x,sizeof(line),line)
    end;
end;

procedure updateline(Y:word);
var bitmap, farbepos:word;
    x, color, attr, data:Byte;
    line:array[0..31] of record l,r:longint;end;
begin
	{$ifdef debug} if y=191 then nextframe;{$endif}

         if currentx>=640 then begin updateline_stretched(Y);exit;end;

         if oldborder<>border then
         begin
          oldborder:=border;

           port[$3c8]:=255;x:=border*3;
           port[$3c9]:=rgb[x];
           port[$3c9]:=rgb[x+1];
           port[$3c9]:=rgb[x+2];

        end;

	bitmap:=speccyline[y];
	farbepos:=6144 or ((y and 248) shl 2);
        for x:=0 to 31 do
         begin
          color:=sp_SCREEN^[farbepos];inc(farbepos);
          asm
           mov al,color
           and al,127
           mov attr,al
          end;
  	  if (color and 128>0) and (flash_status) then
           attr:=reverse_attr[attr];

 	  data:=SP_SCREEN^[bitmap];inc(bitmap);

          with line[x] do
          begin
           l:=vga_h_nib[(data and $F0) shr 4][attr];
           r:=vga_h_nib[data and $0F][attr];
          end;
         end;
    if interlace then
     put_line(centerx,y shl 1+centery_2x,sizeof(line),line)
    else
     put_line(centerx,y+centery,sizeof(line),line)
end;
