; DYNALIB.ASM
; Titan x86 DynaRec (PATRICk)

bits 32

%ifdef WIN32
section .data
%endif

struc tagSH2
	GenReg:  resd 16 
	CtrlReg:  resd 4
	SysReg:  resd 3 
endstruc

%ifdef WIN32
section .code
%endif

;Memory Functions
extern _memGetByte, _memGetWord, _memGetLong
extern _memSetByte, _memSetWord, _memSetLong

%macro opfunc 1
	global _x86_%1
	_x86_%1:
%endmacro

%macro opdesc 7
	global _%1_size
	_%1_size db %2
	global _%1_src
	_%1_src db %3
	global _%1_dest
	_%1_dest db %4
	global _%1_off1
	_%1_off1 db %5
	global _%1_imm
	_%1_imm db %6
	global _%1_off3
	_%1_off3 db %7
%endmacro

%macro ctrlreg_load 1	;5
	mov ebp,edi
	add ebp,byte 64+(%1*4)
%endmacro

%macro getflag 1	;7
	lahf
	shl ax,8+%1
	and eax,byte 1
%endmacro

; SR => [ebx]
; PC => [edx]
; GenReg => edi
; SysReg => esi

global _prologue
_prologue:
pushad          ;1
push dword 00   ;4
mov ebp,[esp+36+4];4
mov edi,ebp     ;2 (GenReg)
add ebp,byte 64 ;3
mov ebx,ebp     ;2 (SR)
add ebp,byte 12 ;3
mov esi,ebp     ;2 (SysReg)
mov edx,esi     ;2
add edx,byte 12 ;3 (PC)
and dword [esp+36+8], byte 0xff ;5
jz .continue ;2
jmp near [esp+36+8] ;4
.continue
; Size = 38 Bytes

global _seperator
_seperator:
add dword [edx],byte 2
;Size = 3 Bytes

global _epilogue
_epilogue:
pop eax         ;1
popad           ;1
ret             ;1
; Size = 3 Bytes

global _PageFlip
_PageFlip:
and dword [esp], byte 0xff
jz .continue
mov eax,[esp]
mov [edx],eax
pop eax
popad
ret
nop
nop
;these make up for the delay clear code
nop
nop
nop
nop
.continue

global _PageJump
_PageJump:
and dword [esp], byte 0xff
jz .continue
mov eax,[esp]
and dword [esp],byte 0
mov [edx],eax;
jmp near dword .continue
.continue

;global _JumpHLE
;_JumpHLE:
;test dword [esp],0xffffffff
;jz .continue
;mov eax,[esp]
;mov [edx],eax;
;jmp word .continue
;.continue

;=================
;Begin x86 Opcodes
;=================

opdesc CLRT,	3,0,0,0,0,0
opfunc CLRT
and dword [ebx],byte 0xfe

opdesc CLRMAC,	8,0,0,0,0,0
opfunc CLRMAC
and dword [esi],byte 0
and dword [esi+4],byte 0

opdesc NOP,		1,0,0,0,0,0
opfunc NOP
nop

opdesc DIV0U,	5,0,0,0,0,0
opfunc DIV0U
and dword [ebx],0xfffffcfe

;opfunc RTE
;opfunc RTS

opdesc SETT,	3,0,0,0,0,0
opfunc SETT
or [ebx],byte 1

opdesc SLEEP,	1,0,0,0,0,0
opfunc SLEEP
nop

opdesc SWAP_W,	16,4,14,0,0,0
opfunc SWAP_W
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
bswap eax           ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov [ebp],eax       ;2

opdesc SWAP_B,	15,4,13,0,0,0
opfunc SWAP_B
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov ax,[ebp]        ;2
xchg ah,al          ;1
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov [ebp],ax        ;2

opdesc TST,	26,4,12,0,0,0
opfunc TST
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
test [ebp],eax      ;2
getflag 4           ;7
and dword [ebx],byte 0xfe ;3
or [ebx],eax        ;2

opdesc ANDI,	11,0,0,0,8,0
opfunc ANDI
mov ebp,edi         ;2
and eax,byte 0      ;3
mov al,byte $00     ;3
and dword [ebp],eax ;3

opdesc XORI,	11,0,0,0,8,0
opfunc XORI
mov ebp,edi         ;2
and eax,byte 0      ;3
mov al,byte $00     ;3
xor dword [ebp],eax ;3

opdesc ORI,	11,0,0,0,8,0
opfunc ORI
mov ebp,edi         ;2
and eax,byte 0      ;3
mov al,byte $00     ;3
or dword [ebp],eax  ;3

opdesc CMP_EQ_IMM,	19,0,0,0,7,0
opfunc CMP_EQ_IMM
mov ebp,edi         ;2
mov eax,[ebp]       ;2
cmp dword [ebp],byte $00 ;3
getflag 4           ;7
and dword [ebx],byte 0xfe ;3
or [ebx],eax        ;2 

opdesc XTRCT,	20,4,12,0,0,0
opfunc XTRCT
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
shl eax,16          ;3
shr dword [ebp],16  ;3
or [ebp],eax        ;2

opdesc ADD,		16,4,12,0,0,0
opfunc ADD
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
add [ebp],eax       ;2

opdesc ADDC,	33,4,19,0,0,0
opfunc ADDC
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebx]       ;2
and dword eax,1     ;5
add eax,[ebp]       ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
adc [ebp],eax       ;2
getflag 2           ;7
and dword [ebx],byte 0xfe ;3
or [ebx],eax        ;2

opdesc SUB,		16,4,12,0,0,0
opfunc SUB
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
sub [ebp],eax       ;2

opdesc SUBC,	33,4,19,0,0,0
opfunc SUBC
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebx]       ;2
and dword eax,1     ;5
add eax,[ebp]       ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
sbb [ebp],eax       ;2
getflag 2           ;7
and dword [ebx],byte 0xfe ;3
or [ebx],eax        ;2

opdesc NOT,		16,4,14,0,0,0
opfunc NOT
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
not eax             ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov [ebp],eax       ;2

opdesc NEG,		16,4,14,0,0,0
opfunc NEG
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
neg eax             ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov [ebp],eax       ;2

opdesc NEGC,	47,4,0,0,0,0
opfunc NEGC
mov ebp,edi         ;2
add ebp,byte $00    ;3
neg dword [ebp]     ;2
mov eax,[ebx]       ;2
and dword eax,1     ;5
sub [ebp],eax       ;2
and dword [ebx],byte 0xfe ;3
mov eax,[ebp]       ;2
cmp eax,0           ;5
getflag 15          ;7
or [ebx],eax        ;2
cmp eax,[ebp]       ;3
getflag 12          ;7
or [ebx],eax        ;2

opdesc EXTU_B,	19,4,17,0,0,0
opfunc EXTU_B
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
and dword eax,0xff  ;5
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov [ebp],eax       ;2

opdesc EXTU_W,	19,4,17,0,0,0
opfunc EXTU_W
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
and dword eax,0xffff;5
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov [ebp],eax       ;2

opdesc EXTS_B,	16,4,14,0,0,0
opfunc EXTS_B
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
cbw                 ;1
cwde                ;1
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov [ebp],eax       ;2

opdesc EXTS_W,	15,4,13,0,0,0
opfunc EXTS_W
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
cwde                ;1
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov [ebp],eax       ;2

;Store Register Opcodes
;----------------------

opdesc STC_SR_MEM,	19,0,4,0,0,0
opfunc STC_SR_MEM
mov ebp,edi         ;2
add ebp,byte $00    ;3
sub dword [ebp],byte 4 ;3
push dword [ebp]    ;1
mov eax,[ebx]       ;2
push eax            ;1
mov eax,_memSetLong ;5
call eax            ;2

opdesc STC_GBR_MEM,	19,0,4,0,0,0
opfunc STC_GBR_MEM
mov ebp,edi         ;2
add ebp,byte $00    ;3
sub dword [ebp],byte 4 ;3
push dword [ebp]    ;1
ctrlreg_load 1      ;5
mov eax,[ebp]       ;2
push eax            ;1
mov eax,_memSetLong ;5
call eax            ;2

opdesc STC_VBR_MEM,	19,0,4,0,0,0
opfunc STC_VBR_MEM
mov ebp,edi         ;2
add ebp,byte $00    ;3
sub dword [ebp],byte 4 ;3
push dword [ebp]    ;1
ctrlreg_load 2      ;5
mov eax,[ebp]       ;2
push eax            ;1
mov eax,_memSetLong ;5
call eax            ;2

;------------------------------

opdesc MOVB_MEM_REG,	27,4,19,0,0,0
opfunc MOVB_MEM_REG
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;3
push edx            ;1
push eax            ;1
mov eax,_memGetByte ;5
call eax            ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
cbw                 ;1
cwde                ;1
mov [ebp],eax       ;3
pop eax             ;1
pop edx             ;1

opdesc MOVW_MEM_REG,		28,4,20,0,0,0
opfunc MOVW_MEM_REG
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;3
push eax            ;1
mov eax,_memGetWord ;5
call eax            ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
cwde                ;1
mov [ebp],eax       ;3
pop eax             ;1
pop ecx             ;1
pop edx             ;1

opdesc MOVL_MEM_REG,		27,4,20,0,0,0
opfunc MOVL_MEM_REG
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;3
push eax            ;1
mov eax,_memGetLong ;5
call eax            ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov [ebp],eax       ;3
pop eax             ;1
pop ecx             ;1
pop edx             ;1

opdesc MOV_B_INC,	27,4,21,0,0,0
opfunc MOV_B_INC
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
inc dword [ebp]     ;2
push edx            ;1
push eax            ;1
mov eax,_memGetByte ;3
call eax            ;3
pop edx             ;1
mov ebp,edi         ;2
add ebp,byte $00    ;3
cbw                 ;1
cwde                ;1
mov [ebp],eax       ;2

opdesc MOV_W_INC,	27,4,22,0,0,0
opfunc MOV_W_INC
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
add dword [ebp],byte 2 ;3
push edx            ;1
push eax            ;1
mov eax,_memGetWord ;3
call eax            ;3
pop edx             ;1
mov ebp,edi         ;2
add ebp,byte $00    ;3
cwde                ;1
mov [ebp],eax       ;2

opdesc MOV_L_INC,	26,4,22,0,0,0
opfunc MOV_L_INC
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
add dword [ebp],byte 4 ;3
push edx            ;1
push eax            ;1
mov eax,_memGetLong ;3
call eax            ;3
pop edx             ;1
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov [ebp],eax       ;2

opdesc MOVW_A,	38,0,4,0,17,0
opfunc MOVW_A
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[edx]       ;2
and eax,byte 0xfc   ;3
push eax            ;1
and eax,byte 0      ;3
mov al,byte $00     ;3
shl eax,byte 2      ;3
add eax,dword [esp] ;2
add eax,byte 4      ;3
push edx            ;1
push eax            ;1
mov eax,_memGetWord ;3
call eax            ;3
pop edx             ;1
cwde                ;1
mov [ebp],eax       ;2
pop eax             ;1

opdesc MOVL_A,	37,0,4,0,17,0
opfunc MOVL_A
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[edx]       ;2
and eax,byte 0xfc   ;3
push eax            ;1
and eax,byte 0      ;3
mov al,byte $00     ;3
shl eax,byte 2      ;3
add eax,dword [esp] ;2
add eax,byte 4      ;3
push edx            ;1
push eax            ;1
mov eax,_memGetLong ;3
call eax            ;3
pop edx             ;1
mov [ebp],eax       ;2
pop eax             ;1

opdesc MOVI,	14,0,4,0,10,0
opfunc MOVI
mov ebp,edi         ;2
add ebp,byte $00    ;3
and eax,byte 0      ;3
or eax,byte 00      ;3
mov [ebp],eax       ;3

;----------------------

opdesc MOVB_M_R0,	27,15,4,0,0,0
opfunc MOVB_M_R0
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
add eax,[edi]       ;2
push eax            ;1
mov ebp,edi         ;2
add ebp,byte $00    ;3
; -- Hack for Pushing bytes --
mov word ax,[ebp]   ;2
push ax             ;1
add esp,1          ;3
call [_memSetByte]  ;6

opdesc MOVW_M_R0,	24,15,4,0,0,0
opfunc MOVW_M_R0
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
add eax,[edi]       ;2
push eax            ;1
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov word ax,[ebp]   ;2
push ax             ;1
call [_memSetWord]  ;6

opdesc MOVL_M_R0,	24,15,4,0,0,0
opfunc MOVL_M_R0
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
add eax,[edi]       ;2
push eax            ;1
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
push eax            ;1
call [_memSetLong]  ;6

opdesc MOVT,		14,0,4,0,0,0
opfunc MOVT
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebx]       ;2
and dword eax,1     ;5
mov [ebp],eax       ;2

opdesc MOVB_R0_N,	25,4,23,0,0,0
opfunc MOVB_R0_N
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
add eax,[edi]       ;2
push eax            ;1
mov eax,_memGetByte ;3
call eax            ;3
cbw                 ;1
cwde                ;1
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov [ebp],eax       ;2

opdesc MOVW_R0_N,	24,4,22,0,0,0
opfunc MOVW_R0_N
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
add eax,[edi]       ;2
push eax            ;1
mov eax,_memGetWord ;3
call eax            ;3
cwde                ;1
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov [ebp],eax       ;2

opdesc MOVL_R0_N,	23,4,21,0,0,0
opfunc MOVL_R0_N
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
add eax,[edi]       ;2
push eax            ;1
mov eax,_memGetLong ;3
call eax            ;3
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov [ebp],eax       ;2

;===========================================================================
;Verified Opcodes
;===========================================================================

opdesc DT,		20,0,4,0,0,0
opfunc DT
mov ebp,edi         ;2
add ebp,byte $00    ;3
and dword [ebx],byte 0xfe ;3
dec dword [ebp]     ;3
cmp dword [ebp],byte 0 ;4
jne .continue       ;2
or dword [ebx],byte 1 ;3
.continue

opdesc CMP_PZ,	15,0,4,0,0,0
opfunc CMP_PZ
mov ebp,edi         ;2
add ebp,byte $00    ;3
and dword [ebx],byte 0xfe ;3
cmp dword [ebp],byte 0 ;3
jl .continue       ;2
or [ebx],eax        ;2
.continue

opdesc CMP_PL,	15,0,4,0,0,0
opfunc CMP_PL
mov ebp,edi         ;2
add ebp,byte $00    ;3
and dword [ebx],byte 0xfe ;3
cmp dword [ebp],byte 0 ;3
jle .continue
or [ebx],eax        ;2
.continue

opdesc CMP_EQ,	23,4,12,0,0,0
opfunc CMP_EQ
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
and dword [ebx],byte 0xfe ;3
cmp [ebp],eax       ;3
jne .continue       ;2
or [ebx],byte 1     ;3 
.continue

opdesc CMP_GE,	23,4,12,0,0,0
opfunc CMP_GE
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
and dword [ebx],byte 0xfe ;3
cmp [ebp],eax       ;3
jl .continue        ;2
or [ebx],byte 1     ;3 
.continue

opdesc CMP_HS,	23,4,12,0,0,0
opfunc CMP_HS
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
and dword [ebx],byte 0xfe ;3
cmp [ebp],eax       ;3
jo .continue        ;2
or [ebx],byte 1     ;3 
.continue

opdesc CMP_HI,	25,4,12,0,0,0
opfunc CMP_HI
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
and dword [ebx],byte 0xfe ;3
cmp [ebp],eax       ;3
jo .continue        ;2
jz .continue        ;2
or [ebx],byte 1     ;3 
.continue

opdesc CMP_GT,	23,4,12,0,0,0
opfunc CMP_GT
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
and dword [ebx],byte 0xfe ;3
cmp [ebp],eax       ;3
jle .continue       ;2
or [ebx],byte 1     ;3 
.continue

opdesc ROTL,	21,0,4,0,0,0
opfunc ROTL
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
shr eax,byte 31     ;3
and dword [ebx],byte 0xfe ;3
or [ebx],eax        ;2
shl dword [ebp],byte 1 ;4
or [ebp],eax        ;2

opdesc ROTR,	22,0,4,0,0,0
opfunc ROTR
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
and eax,byte 1      ;3
and dword [ebx],byte 0xfe ;3
or [ebx],eax        ;2
shr dword [ebp],1   ;2
shl eax,byte 31     ;3
or [ebp],eax        ;2

opdesc ROTCL,	30,0,4,0,0,0
opfunc ROTCL
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebx]       ;2
and dword eax,1     ;5
push eax            ;1
mov eax,[ebp]       ;2
shr eax,byte 31     ;3
and dword [ebx],byte 0xfe ;3
or [ebx],eax        ;2
shl dword [ebp],byte 1 ;4
pop eax	            ;1
or [ebp],eax        ;2

opdesc ROTCR,	35,0,4,0,0,0
opfunc ROTCR
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebx]       ;2
and dword eax,1     ;5
shl eax,byte 31     ;3
push eax            ;1
mov eax,[ebp]       ;2
and dword eax,1     ;5
and dword [ebx],byte 0xfe ;3
or [ebx],eax        ;2
shr dword [ebp],byte 1 ;4
pop eax	            ;1
or [ebp],eax        ;2

opdesc SHL,		20,0,4,0,0,0
opfunc SHL
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;3
shr eax,byte 31     ;3
and dword [ebx],byte 0xfe ;3
or [ebx],eax        ;2
shl dword [ebp],byte 1 ;4

opdesc SHLR,	21,0,4,0,0,0
opfunc SHLR
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
and dword eax,1     ;5
and dword [ebx],byte 0xfe ;3
or [ebx],eax          ;3
shr dword [ebp],byte 1 ;4

opdesc SHAR,	30,0,4,0,0,0
opfunc SHAR
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
and dword eax,1     ;5
and dword [ebx],byte 0xfe ;3
or [ebx],eax        ;2
mov eax,[ebp]       ;2
and eax,0x80000000  ;5
shr dword [ebp],byte 1 ;4
or [ebp],eax        ;2

opdesc SHLL2,	9,0,4,0,0,0
opfunc SHLL2
mov ebp,edi         ;2
add ebp,byte $00    ;3
shl dword [ebp],byte 2 ;4

opdesc SHLR2,	9,0,4,0,0,0
opfunc SHLR2
mov ebp,edi         ;2
add ebp,byte $00    ;3
shr dword [ebp],byte 2 ;4

opdesc SHLL8,	9,0,4,0,0,0
opfunc SHLL8
mov ebp,edi         ;2
add ebp,byte $00    ;3
shl dword[ebp],byte 8  ;4

opdesc SHLR8,	9,0,4,0,0,0
opfunc SHLR8
mov ebp,edi         ;2
add ebp,byte $00    ;3
shr dword [ebp],byte 8 ;4

opdesc SHLL16,	9,0,4,0,0,0
opfunc SHLL16
mov ebp,edi         ;2
add ebp,byte $00    ;3
shl dword [ebp],byte 16 ;4

opdesc SHLR16,	9,0,4,0,0,0
opfunc SHLR16
mov ebp,edi         ;2
add ebp,byte $00    ;3
shr dword [ebp],byte 16 ;4

opdesc AND,		16,4,12,0,0,0
opfunc AND
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
and [ebp],eax       ;2

opdesc OR,		16,4,12,0,0,0
opfunc OR
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
or [ebp],eax        ;2

opdesc XOR,		16,4,12,0,0,0
opfunc XOR
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
xor [ebp],eax       ;3

opdesc ADDI,	9,0,4,0,8,0
opfunc ADDI
mov ebp,edi         ;2
add ebp,byte $00    ;3
add dword [ebp],byte $00 ;4


opdesc AND_B,	35,0,0,0,18,0
opfunc AND_B
push edx            ;1
ctrlreg_load 1      ;5
add eax, dword [edi];3
push eax            ;1
mov eax, _memGetByte;5
call eax            ;2
pop ebp             ;1
and al,byte $00     ;2
push eax            ;1
push ebp            ;1
mov eax, _memSetByte;5
call eax            ;2
add esp, byte 8     ;3
pop edx             ;1

opdesc OR_B,	35,0,0,0,18,0
opfunc OR_B
push edx            ;1
ctrlreg_load 1      ;5
add eax, dword [edi];3
push eax            ;1
mov eax, _memGetByte;5
call eax            ;2
pop ebp             ;1
or al,byte $00      ;2
push eax            ;1
push ebp            ;1
mov eax, _memSetByte;5
call eax            ;2
add esp, byte 8     ;3
pop edx             ;1

opdesc TST_B,	31,0,0,0,18,0
opfunc TST_B
push edx            ;1
ctrlreg_load 1      ;5
add eax, dword [edi];3
push eax            ;1
mov eax, _memGetByte;5
call eax            ;2
pop ebp             ;1
and al,byte $00     ;2
cmp al,0            ;2
and dword [ebx],byte 0xfe ;3
jne .continue       ;2
or dword [ebx],byte 1 ;3
.continue
pop edx

opdesc XOR_B,	35,0,0,0,18,0
opfunc XOR_B
push edx            ;1
ctrlreg_load 1      ;5
add eax, dword [edi];3
push eax            ;1
mov eax, _memGetByte;5
call eax            ;2
pop ebp             ;1
xor al,byte $00      ;2
push eax            ;1
push ebp            ;1
mov eax, _memSetByte;5
call eax            ;2
add esp, byte 8     ;3
pop edx             ;1

;Jump Opcodes
;------------

opdesc JMP,		10,0,4,0,0,0
opfunc JMP
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
mov [esp],eax       ;3

opdesc JSR,		19,0,4,0,0,0
opfunc JSR
mov [edx],eax       ;3
add eax,byte 4      ;3
mov eax,[esi+8]     ;3
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
mov [esp],eax       ;3

opdesc BRA,		29,0,0,0,0,5
opfunc BRA
and eax,byte 00     ;3
mov ax,0            ;4
shl eax,byte 1      ;3
cmp ax,0xfff        ;4
jle .continue       ;2
or eax,0xfffff000   ;5
.continue
add eax,byte 4      ;3
add eax,dword [edx] ;2
mov [esp],eax       ;3

opdesc BSR,		37,0,0,0,0,13
opfunc BSR
mov eax,[edx]       ;2
add eax,byte 4      ;3
mov [esi+8],eax     ;3
and eax,byte 00     ;3
mov ax,0            ;4
shl eax,byte 1      ;3
cmp ax,0xfff        ;4
jle .continue       ;2
or eax,0xfffff000   ;5
.continue
add eax,byte 4      ;3
add eax,dword [edx] ;2
mov [esp],eax       ;3

opdesc BSRF,		22,4,0,0,0,0
opfunc BSRF
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[edx]       ;2
add eax,byte 4      ;3
mov [esi+8],eax     ;3
mov eax,[edx]       ;3
add eax,dword [ebp] ;3
mov [esp],eax       ;3

opdesc BRAF,		13,4,0,0,0,0
opfunc BRAF
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[edx]       ;2
add eax,dword [ebp] ;3
mov [esp],eax       ;3

opdesc RTS,			6,0,0,0,0,0
opfunc RTS
mov eax,[esi+8]     ;3
mov [esp],eax       ;3

opdesc RTE,			44,0,0,0,0,0
opfunc RTE
mov ebp,edi         ;2
add ebp,byte 15     ;3
push edx            ;1
push dword [ebp]    ;1
mov eax,_memGetLong ;5
call eax            ;2
add eax,byte 4      ;3
mov [esp],eax       ;4
add dword [ebp],byte 4 ;5
mov eax,_memGetLong ;5
call eax            ;2
pop edx             ;1
and ax,0x3f3        ;3
mov [ebx],eax       ;3
add dword [ebp],byte 4 ;4

opdesc BT,		23,0,0,0,11,0
opfunc BT
bt dword [ebx],0    ;4
jc .continue        ;2
and eax,byte 00     ;3
or eax,byte 00      ;3
shl eax,byte 1      ;3
add eax,byte 4      ;3
add eax,dword [edx] ;2
mov [esp],eax       ;3
.continue

opdesc BF,		23,0,0,0,11,0
opfunc BF
bt dword [ebx],0    ;4
jnc .continue       ;2
and eax,byte 00     ;3
or eax,byte 00      ;3
shl eax,byte 1      ;3
add eax,byte 4      ;3
add eax,dword [edx] ;2
mov [esp],eax       ;3
.continue

;Store/Load Opcodes
;------------------

opdesc STC_SR,	9,0,4,0,0,0
opfunc STC_SR
mov ebp,edi
add ebp,byte $00
mov eax,[ebx]
mov [ebp],eax

opdesc STC_GBR,	16,0,4,0,0,0
opfunc STC_GBR
mov ebp,edi         ;2
add ebp,byte $00    ;3
push ebp            ;1
ctrlreg_load 1      ;5
mov eax,[ebp]       ;2
pop ebp             ;1
mov [ebp],eax       ;2

opdesc STC_VBR,	16,0,4,0,0,0
opfunc STC_VBR
mov ebp,edi
add ebp,byte $00
push ebp
ctrlreg_load 2
mov eax,[ebp]
pop ebp
mov [ebp],eax

opdesc STS_MACH, 9,0,4,0,0,0
opfunc STS_MACH
mov ebp,edi       ;2
add ebp,byte $00  ;3
mov eax,[esi]     ;2
mov [ebp],eax     ;2

opdesc STS_MACH_DEC,	21,0,4,0,0,0
opfunc STS_MACH_DEC
mov ebp,edi       ;2
add ebp,byte $00  ;3
sub dword [ebp],byte 4 ;3
mov eax,[esi]     ;2
push eax          ;1
mov eax,[ebp]     ;2
push eax          ;1
mov eax,_memSetLong ;5
call eax          ;2

opdesc STS_MACL, 10,0,4,0,0,0
opfunc STS_MACL
mov ebp,edi       ;2
add ebp,byte $00  ;3
mov eax,[esi+4]   ;3
mov [ebp],eax     ;2

opdesc STS_MACL_DEC,	22,0,4,0,0,0
opfunc STS_MACL_DEC
mov ebp,edi       ;2
add ebp,byte $00  ;3
sub dword [ebp],byte 4 ;3
mov eax,[esi+4]   ;3
push eax          ;1
mov eax,[ebp]     ;2
push eax          ;1
mov eax,_memSetLong ;5
call eax          ;2

opdesc LDC_SR,	9,0,4,0,0,0
opfunc LDC_SR
mov ebp,edi
add ebp,byte $00
mov eax,[ebp]
mov [ebx],eax

opdesc LDC_SR_INC,	24,0,4,0,0,0
opfunc LDC_SR_INC
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
push eax            ;1
mov eax,_memGetLong ;5
call eax            ;2
and ax,0x3f3        ;3
mov word [ebx],ax   ;3
add dword [ebp],byte 4 ;3

opdesc LDC_GBR,	14,0,4,0,0,0
opfunc LDC_GBR
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
ctrlreg_load 1      ;5
mov [ebp],eax       ;2

opdesc LDC_GBR_INC,	25,0,4,0,0,0
opfunc LDC_GBR_INC
mov ebp,edi         ;2
add ebp,byte $00    ;3
add dword [ebp],byte 4 ;3
mov eax,[ebp]       ;2
push eax            ;1
mov eax,_memGetLong ;5
call eax            ;2
ctrlreg_load 1      ;5
mov [ebp],eax       ;2

opdesc LDC_VBR,	14,0,4,0,0,0
opfunc LDC_VBR
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
ctrlreg_load 2      ;5
mov [ebp],eax       ;2

opdesc LDC_VBR_INC,	25,0,4,0,0,0
opfunc LDC_VBR_INC
mov ebp,edi         ;2
add ebp,byte $00    ;3
add dword [ebp],byte 4 ;3
mov eax,[ebp]       ;2
push eax            ;1
mov eax,_memGetLong ;5
call eax            ;2
ctrlreg_load 2      ;5
mov [ebp],eax       ;2

opdesc STS_PR,		11,0,4,0,0,0
opfunc STS_PR
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[esi+8]     ;3
mov [ebp],eax       ;3

opdesc STS_PR_DEC,	22,0,4,0,0,0
opfunc STS_PR_DEC
mov ebp,edi       ;2
add ebp,byte $00  ;3
sub dword [ebp],byte 4 ;3
mov eax,[esi+8]   ;3
push eax          ;1
mov eax,[ebp]     ;2
push eax          ;1
mov eax,_memSetLong ;5
call eax          ;2

opdesc LDS_PR,		11,0,4,0,0,0
opfunc LDS_PR
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
mov [esi+8],eax     ;4

opdesc LDS_PR_INC,	21,0,4,0,0,0
opfunc LDS_PR_INC
mov ebp,edi         ;2
add ebp,byte $00    ;3
add dword [ebp],byte 4 ;3
mov eax,[ebp]       ;2
push eax            ;1
mov eax,_memGetLong ;5
call eax            ;2
mov [esi+8],eax     ;2

opdesc LDS_MACH,		17,0,4,0,0,0
opdesc LDS_MACH_INC,	20,0,4,0,0,0
opfunc LDS_MACH
opfunc LDS_MACH_INC
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
push eax            ;1
mov eax,_memGetLong ;5
call eax            ;2
mov [esi],eax       ;2
add dword [ebp],byte 4 ;3

opdesc LDS_MACL,		18,0,4,0,0,0
opdesc LDS_MACL_INC,	21,0,4,0,0,0
opfunc LDS_MACL
opfunc LDS_MACL_INC
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
push eax            ;1
mov eax,_memGetLong ;5
call eax            ;2
mov [esi+4],eax     ;3
add dword [ebp],byte 4 ;3

;Mov Opcodes
;-----------

opdesc MOVA,	25,0,0,0,14,0
opfunc MOVA
mov ebp,edi         ;2
mov eax,[edx]       ;2
and eax,byte 0xfc   ;3
push eax            ;1
and eax,byte 0      ;3
mov al,byte $00     ;3
shl eax,byte 2      ;3
add eax,dword [esp] ;2
add eax,byte 4      ;3
mov [ebp],eax       ;2
pop eax             ;1

opdesc MOVW_DISP,	41,4,0,0,9,0
opfunc MOVW_DISP
mov ebp,edi
add ebp,byte $00
and eax,byte 00
mov al,00
shl ax,byte 2
push edx
push eax
mov eax,[edx]
and eax,byte 0xfc
add [esp],eax
add dword [esp],byte 4
mov eax,_memGetWord
call eax
cwde
mov [ebp],eax
pop eax
pop edx
pop ax

opdesc MOVL_DISP,	40,4,0,0,9,0
opfunc MOVL_DISP
mov ebp,edi
add ebp,byte $00
and eax,byte 00
mov al,00
shl ax,byte 2
push edx
push eax
mov eax,[edx]
and eax,byte 0xfc
add [esp],eax
add dword [esp],byte 4
mov eax,_memGetLong
call eax
mov [ebp],eax
pop eax
pop edx

opdesc MOVL_REG_DISP,	37,13,4,22,0,0
opfunc MOVL_REG_DISP
mov ebp,edi         ;2
add ebp,byte $00    ;3
push edx            ;1
push dword [ebp]    ;3
mov ebp,edi         ;2
add ebp,byte $00    ;3
push dword [ebp]    ;3
and eax,byte 0      ;3
or eax,byte 0       ;3
shl eax,byte 2      ;3
add dword [esp],eax ;2
mov eax,_memSetLong ;5
call eax            ;2
pop eax             ;1
pop edx             ;1

opdesc MOV_B_MEM,	33,4,17,0,0,0
opfunc MOV_B_MEM
mov ebp,edi         ;2
add ebp,byte $00    ;3
push edx            ;1
push word [ebp]     ;4
add esp,byte 1      ;3
mov ebp,edi         ;2
add ebp,byte $00    ;3
push dword [ebp]    ;3
mov eax,_memSetByte ;5
call eax            ;2
pop eax             ;1
add esp,byte 1      ;3
pop edx             ;1

opdesc MOV_W_MEM,	28,4,14,0,0,0
opfunc MOV_W_MEM
mov ebp,edi         ;2
add ebp,byte $00    ;3
push edx            ;1
push word [ebp]     ;4
mov ebp,edi         ;2
add ebp,byte $00    ;3
push dword [ebp]    ;3
mov eax,_memSetWord ;5
call eax            ;2
pop eax             ;1
pop ax              ;1
pop edx             ;1

opdesc MOV_L_MEM,	27,4,13,0,0,0
opfunc MOV_L_MEM
mov ebp,edi         ;2
add ebp,byte $00    ;3
push edx            ;1
push dword [ebp]    ;3
mov ebp,edi         ;2
add ebp,byte $00    ;3
push dword [ebp]    ;3
mov eax,_memSetLong ;5
call eax            ;2
pop eax             ;1
pop eax             ;1
pop edx             ;1

opdesc MOV_REG,		15,4,12,0,0,0
opfunc MOV_REG
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov eax,[ebp]       ;2
mov ebp,edi         ;2
add ebp,byte $00    ;3
mov [ebp],eax       ;3

end