;
; Genital68K Version 0.22: Motorola 68000 emulator
; Copyright 2000, 2001 Bart Trzynadlowski, see "README.TXT" for terms of use
; Assemble with NASM (http://www.web-sites.co.uk/nasm) only
;
; Configuration:
; - 24-bit addresses
; - Illegal instruction, Line 1010, and Line 1111 exceptions
; - Idle loop skipping disabled
; - Fetch pointer updated for Bcc, BRA, BSR, and DBcc
; - Data regions used for PC-relative reading
; - Single address space for supervisor and user
; - Definable memory map arrays
; - Stack calling conventions
;
bits 32
section .data
times ($$-$) & 31 nop
global genital68kcontext, _genital68kcontext, genital68kcontext_
genital68kcontext:
_genital68kcontext:
genital68kcontext_:
context_start:
fetch      dd 0
pcfetch    dd 0
read_byte  dd 0
read_word  dd 0
read_long  dd 0
write_byte dd 0
write_word dd 0
write_long dd 0
super_fetch      dd 0
super_pcfetch    dd 0
super_read_byte  dd 0
super_read_word  dd 0
super_read_long  dd 0
super_write_byte dd 0
super_write_word dd 0
super_write_long dd 0
user_fetch       dd 0
user_pcfetch     dd 0
user_read_byte   dd 0
user_read_word   dd 0
user_read_long   dd 0
user_write_byte  dd 0
user_write_word  dd 0
user_write_long  dd 0
intr       times 8 dd 0
cycles     dd 0
remaining  dd 0
d          times 8 dd 0
a          times 8 dd 0
__sp       dd 0
sr         dd 0
pc         dd 0
status     dd 0
Reset      dd 0
context_end:
x          dd 0
memhandler_eax    dd 0
memhandler_ebx    dd 0
memhandler_ecx    dd 0
memhandler_edx    dd 0
memhandler_esi    dd 0
memhandler_edi    dd 0
memhandler_ebp    dd 0
run_eax    dd 0
run_ebx    dd 0
run_ecx    dd 0
run_edx    dd 0
run_esi    dd 0
run_edi    dd 0
run_ebp    dd 0
safety_eax    dd 0
safety_ebx    dd 0
safety_ecx    dd 0
safety_edx    dd 0
safety_esi    dd 0
safety_edi    dd 0
safety_ebp    dd 0
fetch_esi dd 0
section .text
times ($$-$) & 3 nop
global Genital68KInit, _Genital68KInit, Genital68KInit_
Genital68KInit:
_Genital68KInit:
Genital68KInit_:
mov  [safety_ecx], ecx
mov  [safety_edx], edx
mov  [safety_esi], esi
mov  [safety_edi], edi
mov  esi, compressed_jmptab
mov  edi, jmptab
xor  ecx, ecx
.l:
mov  cx, [esi]
add  esi, byte 2
mov  edx, ecx
and  edx, 0xc000
cmp  dx, 0xc000
je   .r1
cmp  dx, 0x8000
je   .r8
mov  eax, [esi]
add  esi, byte 4
cld
rep  stosd
.c:
cmp  dword [esi], byte -1
jne  .l
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
xor  eax, eax
ret
times ($$-$) & 3 nop
.r1:
and  ecx, 0x3ff
cld
rep  movsd
jmp  .c
times ($$-$) & 3 nop
.r8:
and  ecx, 0x7ff
.r8_l:
mov  edx, ecx
mov  ecx, 8
mov  eax, [esi]
add  esi, byte 4
cld
rep  stosd
mov  ecx, edx
dec  ecx
jnz  .r8_l
jmp  .c
times ($$-$) & 3 nop
global Genital68KReset, _Genital68KReset, Genital68KReset_
Genital68KReset:
_Genital68KReset:
Genital68KReset_:
mov  [safety_ebx], ebx
mov  [safety_ecx], ecx
mov  [safety_edx], edx
mov  [safety_esi], esi
mov  [safety_edi], edi
push ebp
or   byte [status], 1
and  byte [status], 0xfd
mov  ebx, 4
call ReadLong
mov  dword [sr], 0x2700
mov  dword [cycles], 0
mov  dword [remaining], 0
mov  esi, edx
xor  eax, eax
mov  edi, d
mov  ecx, 16
cld
rep  stosd
mov  edi, intr
mov  ecx, 8
rep  stosd
mov  [fetch_esi], esi
and  esi, 0x00FFFFFF
mov     edx, [fetch]
.find_fetch_loop0:
add     edx, byte 12
cmp     dword [edx], byte -1
je      near fetch_error
cmp     esi, [edx]
jb      .find_fetch_loop0
cmp     esi, [edx+4]
ja      .find_fetch_loop0
mov     ebp, [edx+8]
mov  edx, [fetch_esi]
mov  esi, edx
and  edx, 0xFF000000
sub  ebp, edx
add     esi, ebp
mov  dword [pc], esi
sub  dword [pc], ebp
xor  ebx, ebx
xor  ecx, ecx
call ReadLong
mov  [a+7*4], edx
mov  [__sp], edx
and  byte [status], 0xfe
pop  ebp
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
xor  eax, eax
ret
invalid_error:
and      eax, 0xc101
mov      dh, ah
shr      dh, byte 4
shl      al, byte 1
or       dh, al
shr      ah, byte 1
adc      dh, 0
mov      ah, [x]
shl      ah, byte 4
or       dh, ah
mov      [sr], dh
and  byte [status], 0xfe
mov [remaining], ecx
mov  dword [pc], esi
sub  dword [pc], ebp
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
pop  ebp
mov  eax, 2
ret
fetch_error:
mov  [remaining], ecx
and  byte [status], 0xfe
mov  [pc], esi
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
pop  ebp
mov  eax, 1
ret
times ($$-$) & 3 nop
global Genital68KReadPC, _Genital68KReadPC, Genital68KReadPC_
Genital68KReadPC:
_Genital68KReadPC:
Genital68KReadPC_:
mov  eax, [pc]
ret
times ($$-$) & 3 nop
global Genital68KSetFetch, _Genital68KSetFetch, Genital68KSetFetch_
Genital68KSetFetch:
_Genital68KSetFetch:
Genital68KSetFetch_:
mov  [safety_eax], eax
mov  [safety_edx], edx
mov  eax, [esp+4+(0*4)]
sub  eax, 12
mov  [fetch], eax
mov  edx, [safety_edx]
mov  eax, [safety_eax]
ret
times ($$-$) & 3 nop
global Genital68KGetFetch, _Genital68KGetFetch, Genital68KGetFetch_
Genital68KGetFetch:
_Genital68KGetFetch:
Genital68KGetFetch_:
mov  [safety_edx], edx
mov  eax, [fetch]
mov  edx, [safety_edx]
add  eax, 12
ret
times ($$-$) & 3 nop
global Genital68KSetReadByte, _Genital68KSetReadByte, Genital68KSetReadByte_
Genital68KSetReadByte:
_Genital68KSetReadByte:
Genital68KSetReadByte_:
mov  [safety_eax], eax
mov  [safety_edx], edx
mov  eax, [esp+4+(0*4)]
sub  eax, 16
mov  [read_byte], eax
mov  edx, [safety_edx]
mov  eax, [safety_eax]
ret
times ($$-$) & 3 nop
global Genital68KGetReadByte, _Genital68KGetReadByte, Genital68KGetReadByte_
Genital68KGetReadByte:
_Genital68KGetReadByte:
Genital68KGetReadByte_:
mov  [safety_edx], edx
mov  eax, [read_byte]
add  eax, 16
mov  edx, [safety_edx]
ret
times ($$-$) & 3 nop
global Genital68KSetReadWord, _Genital68KSetReadWord, Genital68KSetReadWord_
Genital68KSetReadWord:
_Genital68KSetReadWord:
Genital68KSetReadWord_:
mov  [safety_eax], eax
mov  [safety_edx], edx
mov  eax, [esp+4+(0*4)]
sub  eax, 16
mov  [read_word], eax
mov  edx, [safety_edx]
mov  eax, [safety_eax]
ret
times ($$-$) & 3 nop
global Genital68KGetReadWord, _Genital68KGetReadWord, Genital68KGetReadWord_
Genital68KGetReadWord:
_Genital68KGetReadWord:
Genital68KGetReadWord_:
mov  [safety_edx], edx
mov  eax, [read_word]
add  eax, 16
mov  edx, [safety_edx]
ret
times ($$-$) & 3 nop
global Genital68KSetReadLong, _Genital68KSetReadLong, Genital68KSetReadLong_
Genital68KSetReadLong:
_Genital68KSetReadLong:
Genital68KSetReadLong_:
mov  [safety_eax], eax
mov  [safety_edx], edx
mov  eax, [esp+4+(0*4)]
sub  eax, 16
mov  [read_long], eax
mov  edx, [safety_edx]
mov  eax, [safety_eax]
ret
times ($$-$) & 3 nop
global Genital68KGetReadLong, _Genital68KGetReadLong, Genital68KGetReadLong_
Genital68KGetReadLong:
_Genital68KGetReadLong:
Genital68KGetReadLong_:
mov  [safety_edx], edx
mov  eax, [read_long]
add  eax, 16
mov  edx, [safety_edx]
ret
times ($$-$) & 3 nop
global Genital68KSetWriteByte, _Genital68KSetWriteByte, Genital68KSetWriteByte_
Genital68KSetWriteByte:
_Genital68KSetWriteByte:
Genital68KSetWriteByte_:
mov  [safety_eax], eax
mov  [safety_edx], edx
mov  eax, [esp+4+(0*4)]
sub  eax, 16
mov  [write_byte], eax
mov  edx, [safety_edx]
mov  eax, [safety_eax]
ret
times ($$-$) & 3 nop
global Genital68KGetWriteByte, _Genital68KGetWriteByte, Genital68KGetWriteByte_
Genital68KGetWriteByte:
_Genital68KGetWriteByte:
Genital68KGetWriteByte_:
mov  [safety_edx], edx
mov  eax, [write_byte]
add  eax, 16
mov  edx, [safety_edx]
ret
times ($$-$) & 3 nop
global Genital68KSetWriteWord, _Genital68KSetWriteWord, Genital68KSetWriteWord_
Genital68KSetWriteWord:
_Genital68KSetWriteWord:
Genital68KSetWriteWord_:
mov  [safety_eax], eax
mov  [safety_edx], edx
mov  eax, [esp+4+(0*4)]
sub  eax, 16
mov  [write_word], eax
mov  edx, [safety_edx]
mov  eax, [safety_eax]
ret
times ($$-$) & 3 nop
global Genital68KGetWriteWord, _Genital68KGetWriteWord, Genital68KGetWriteWord_
Genital68KGetWriteWord:
_Genital68KGetWriteWord:
Genital68KGetWriteWord_:
mov  [safety_edx], edx
mov  eax, [write_word]
add  eax, 16
mov  edx, [safety_edx]
ret
times ($$-$) & 3 nop
global Genital68KSetWriteLong, _Genital68KSetWriteLong, Genital68KSetWriteLong_
Genital68KSetWriteLong:
_Genital68KSetWriteLong:
Genital68KSetWriteLong_:
mov  [safety_eax], eax
mov  [safety_edx], edx
mov  eax, [esp+4+(0*4)]
sub  eax, 16
mov  [write_long], eax
mov  edx, [safety_edx]
mov  eax, [safety_eax]
ret
times ($$-$) & 3 nop
global Genital68KGetWriteLong, _Genital68KGetWriteLong, Genital68KGetWriteLong_
Genital68KGetWriteLong:
_Genital68KGetWriteLong:
Genital68KGetWriteLong_:
mov  [safety_edx], edx
mov  eax, [write_long]
add  eax, 16
mov  edx, [safety_edx]
ret
times ($$-$) & 3 nop
global Genital68KFetchPtr, _Genital68KFetchPtr, Genital68KFetchPtr_
Genital68KFetchPtr:
_Genital68KFetchPtr:
Genital68KFetchPtr_:
mov  [safety_ebx], ebx
mov  [safety_ecx], ecx
mov  [safety_edx], edx
mov  [safety_esi], esi
mov  [safety_edi], edi
push ebp
mov  esi, [esp+8+(0*4)]
and  esi, 0x00FFFFFF
mov     edx, [fetch]
.find_fetch_loop:
add     edx, byte 12
cmp     dword [edx], byte -1
je      short .not_found
cmp     esi, [edx]
jb      short .find_fetch_loop
cmp     esi, [edx+4]
ja      short .find_fetch_loop
mov     ebp, [edx+8]
add     esi, ebp
mov     eax, esi
pop  ebp
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
ret
.not_found:
xor  eax, eax
pop  ebp
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
ret
times ($$-$) & 3 nop
global Genital68KReadByte, _Genital68KReadByte, Genital68KReadByte_
Genital68KReadByte:
_Genital68KReadByte:
Genital68KReadByte_:
mov  [safety_ebx], ebx
mov  [safety_ecx], ecx
mov  [safety_edx], edx
mov  [safety_esi], esi
mov  [safety_edi], edi
push ebp
xor  ebp, ebp
mov  esi, [pc]
mov  ebx, [esp+8+(0*4)]
call ReadByte
mov  eax, edx
pop  ebp
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
ret
times ($$-$) & 3 nop
global Genital68KReadWord, _Genital68KReadWord, Genital68KReadWord_
Genital68KReadWord:
_Genital68KReadWord:
Genital68KReadWord_:
mov  [safety_ebx], ebx
mov  [safety_ecx], ecx
mov  [safety_edx], edx
mov  [safety_esi], esi
mov  [safety_edi], edi
push ebp
xor  ebp, ebp
mov  esi, [pc]
mov  ebx, [esp+8+(0*4)]
call ReadWord
mov  eax, edx
pop  ebp
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
ret
times ($$-$) & 3 nop
global Genital68KReadLong, _Genital68KReadLong, Genital68KReadLong_
Genital68KReadLong:
_Genital68KReadLong:
Genital68KReadLong_:
mov  [safety_ebx], ebx
mov  [safety_ecx], ecx
mov  [safety_edx], edx
mov  [safety_esi], esi
mov  [safety_edi], edi
push ebp
xor  ebp, ebp
mov  esi, [pc]
mov  ebx, [esp+8+(0*4)]
call ReadLong
mov  eax, edx
pop  ebp
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
ret
times ($$-$) & 3 nop
global Genital68KWriteByte, _Genital68KWriteByte, Genital68KWriteByte_
Genital68KWriteByte:
_Genital68KWriteByte:
Genital68KWriteByte_:
mov  [safety_eax], eax
mov  [safety_ebx], ebx
mov  [safety_ecx], ecx
mov  [safety_edx], edx
mov  [safety_esi], esi
mov  [safety_edi], edi
push ebp
xor  ebp, ebp
mov  esi, [pc]
mov  ebx, [esp+8+(0*4)]
mov  edx, [esp+8+(1*4)]
call WriteByte
pop  ebp
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
mov  eax, [safety_eax]
ret
times ($$-$) & 3 nop
global Genital68KWriteWord, _Genital68KWriteWord, Genital68KWriteWord_
Genital68KWriteWord:
_Genital68KWriteWord:
Genital68KWriteWord_:
mov  [safety_eax], eax
mov  [safety_ebx], ebx
mov  [safety_ecx], ecx
mov  [safety_edx], edx
mov  [safety_esi], esi
mov  [safety_edi], edi
push ebp
xor  ebp, ebp
mov  esi, [pc]
mov  ebx, [esp+8+(0*4)]
mov  edx, [esp+8+(1*4)]
call WriteWord
pop  ebp
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
mov  eax, [safety_eax]
ret
times ($$-$) & 3 nop
global Genital68KWriteLong, _Genital68KWriteLong, Genital68KWriteLong_
Genital68KWriteLong:
_Genital68KWriteLong:
Genital68KWriteLong_:
mov  [safety_eax], eax
mov  [safety_ebx], ebx
mov  [safety_ecx], ecx
mov  [safety_edx], edx
mov  [safety_esi], esi
mov  [safety_edi], edi
push ebp
xor  ebp, ebp
mov  esi, [pc]
mov  ebx, [esp+8+(0*4)]
mov  edx, [esp+8+(1*4)]
call WriteLong
pop  ebp
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
mov  eax, [safety_eax]
ret
times ($$-$) & 3 nop
global Genital68KSetContext, _Genital68KSetContext, Genital68KSetContext_
Genital68KSetContext:
_Genital68KSetContext:
Genital68KSetContext_:
mov  [safety_ecx], ecx
mov  [safety_esi], esi
mov  [safety_edi], edi
mov  esi, [esp+4+(0*4)]
mov  edi, genital68kcontext
mov  ecx, (context_end - context_start) / 4
cld
rep  movsd
sub  dword [read_byte], 16
sub  dword [read_word], 16
sub  dword [read_long], 16
sub  dword [write_byte], 16
sub  dword [write_word], 16
sub  dword [write_long], 16
sub  dword [fetch], 12
sub  dword [pcfetch], 12
sub  dword [super_read_byte], 16
sub  dword [super_read_word], 16
sub  dword [super_read_long], 16
sub  dword [super_write_byte], 16
sub  dword [super_write_word], 16
sub  dword [super_write_long], 16
sub  dword [super_fetch], 12
sub  dword [super_pcfetch], 12
sub  dword [user_read_byte], 16
sub  dword [user_read_word], 16
sub  dword [user_read_long], 16
sub  dword [user_write_byte], 16
sub  dword [user_write_word], 16
sub  dword [user_write_long], 16
sub  dword [user_fetch], 12
sub  dword [user_pcfetch], 12
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  ecx, [safety_ecx]
ret
times ($$-$) & 3 nop
global Genital68KGetContext, _Genital68KGetContext, Genital68KGetContext_
Genital68KGetContext:
_Genital68KGetContext:
Genital68KGetContext_:
mov  [safety_ecx], ecx
mov  [safety_esi], esi
mov  [safety_edi], edi
add  dword [read_byte], 16
add  dword [read_word], 16
add  dword [read_long], 16
add  dword [write_byte], 16
add  dword [write_word], 16
add  dword [write_long], 16
add  dword [fetch], 12
add  dword [pcfetch], 12
add  dword [super_read_byte], 16
add  dword [super_read_word], 16
add  dword [super_read_long], 16
add  dword [super_write_byte], 16
add  dword [super_write_word], 16
add  dword [super_write_long], 16
add  dword [super_fetch], 12
add  dword [super_pcfetch], 12
add  dword [user_read_byte], 16
add  dword [user_read_word], 16
add  dword [user_read_long], 16
add  dword [user_write_byte], 16
add  dword [user_write_word], 16
add  dword [user_write_long], 16
add  dword [user_fetch], 12
add  dword [user_pcfetch], 12
mov  edi, [esp+4+(0*4)]
mov  esi, genital68kcontext
mov  ecx, (context_end - context_start) / 4
cld
rep  movsd
sub  dword [read_byte], 16
sub  dword [read_word], 16
sub  dword [read_long], 16
sub  dword [write_byte], 16
sub  dword [write_word], 16
sub  dword [write_long], 16
sub  dword [fetch], 12
sub  dword [pcfetch], 12
sub  dword [super_read_byte], 16
sub  dword [super_read_word], 16
sub  dword [super_read_long], 16
sub  dword [super_write_byte], 16
sub  dword [super_write_word], 16
sub  dword [super_write_long], 16
sub  dword [super_fetch], 12
sub  dword [super_pcfetch], 12
sub  dword [user_read_byte], 16
sub  dword [user_read_word], 16
sub  dword [user_read_long], 16
sub  dword [user_write_byte], 16
sub  dword [user_write_word], 16
sub  dword [user_write_long], 16
sub  dword [user_fetch], 12
sub  dword [user_pcfetch], 12
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  ecx, [safety_ecx]
ret
times ($$-$) & 3 nop
global Genital68KGetContextSize, _Genital68KGetContextSize, Genital68KGetContextSize_
Genital68KGetContextSize:
_Genital68KGetContextSize:
Genital68KGetContextSize_:
mov  eax, (context_end - context_start)
ret
global Genital68KClearCycles, _Genital68KClearCycles, Genital68KClearCycles_
Genital68KClearCycles:
_Genital68KClearCycles:
Genital68KClearCycles_:
mov  dword [cycles], 0
mov  dword [remaining], 0
ret
global Genital68KFreeTimeSlice, _Genital68KFreeTimeSlice, Genital68KFreeTimeSlice_
Genital68KFreeTimeSlice:
_Genital68KFreeTimeSlice:
Genital68KFreeTimeSlice_:
mov  [safety_eax], eax
mov  eax, [cycles]
sub  eax, [remaining]
mov  [cycles], eax
mov  dword [remaining], 0
mov  eax, [safety_eax]
ret
global Genital68KGetElapsedCycles, _Genital68KGetElapsedCycles, Genital68KGetElapsedCycles_
Genital68KGetElapsedCycles:
_Genital68KGetElapsedCycles:
Genital68KGetElapsedCycles_:
mov  eax, [cycles]
sub  eax, [remaining]
ret
times ($$-$) & 3 nop
global Genital68KProcessInterrupts, _Genital68KProcessInterrupts, Genital68KProcessInterrupts_
Genital68KProcessInterrupts:
_Genital68KProcessInterrupts:
Genital68KProcessInterrupts_:
mov  [safety_ebx], ebx
mov  [safety_ecx], ecx
mov  [safety_edx], edx
mov  [safety_esi], esi
mov  [safety_edi], edi
test byte [status], 1
jnz  near .end
push ebp
mov  ecx, [remaining]
or   byte [status], 1
mov  esi, [pc]
mov  [fetch_esi], esi
and  esi, 0x00FFFFFF
mov     edx, [fetch]
.find_fetch_loop0:
add     edx, byte 12
cmp     dword [edx], byte -1
je      near fetch_error
cmp     esi, [edx]
jb      .find_fetch_loop0
cmp     esi, [edx+4]
ja      .find_fetch_loop0
mov     ebp, [edx+8]
mov  edx, [fetch_esi]
mov  esi, edx
and  edx, 0xFF000000
sub  ebp, edx
add     esi, ebp
call ProcessInterrupts
mov [remaining], ecx
mov  dword [pc], esi
sub  dword [pc], ebp
and  byte [status], 0xfe
pop  ebp
.end:
xor  eax, eax
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
ret
times ($$-$) & 3 nop
global Genital68KInterrupt, _Genital68KInterrupt, Genital68KInterrupt_
Genital68KInterrupt:
_Genital68KInterrupt:
Genital68KInterrupt_:
mov  [safety_ebx], ebx
mov  [safety_ecx], ecx
mov  [safety_edx], edx
mov  [safety_esi], esi
mov  [safety_edi], edi
mov  eax, [esp+4+(0*4)]
test eax, -1
jz   short .inv_level
cmp  eax, byte 7
ja   short .inv_level
mov  ebx, [esp+4+(1*4)]
cmp  ebx, byte 2
jb   short .inv_vector
cmp  ebx, 256
ja   short .inv_vector
jne  short .not_auto
mov  ebx, eax
add  ebx, byte 24
.not_auto:
dec  eax
shl  eax, byte 2
cmp  [intr+eax], byte 0
jne  short .pending
mov  [intr+eax], ebx
inc  dword [intr+7*4]
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
xor  eax, eax
ret
.inv_level:
mov  eax, 3
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
ret
.inv_vector:
mov  eax, 4
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
ret
.pending:
mov  eax, 5
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
ret
times ($$-$) & 3 nop
global Genital68KCancelInterrupt, _Genital68KCancelInterrupt, Genital68KCancelInterrupt_
Genital68KCancelInterrupt:
_Genital68KCancelInterrupt:
Genital68KCancelInterrupt_:
mov  [safety_ebx], ebx
mov  [safety_ecx], ecx
mov  [safety_edx], edx
mov  [safety_esi], esi
mov  [safety_edi], edi
mov  eax, [esp+4+(0*4)]
test eax, 0xffffffff
jz   short .inv_level
cmp  eax, byte 7
ja   short .inv_level
test byte [status], 0x04
jnz  short .busy
dec  eax
cmp  dword [intr+eax], byte 0
je   .nothing_to_cancel
mov  dword [intr+eax], 0
dec  dword [intr+7*4]
.busy:
.nothing_to_cancel:
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
xor  eax, eax
ret
.inv_level:
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
mov  eax, 3
ret
times ($$-$) & 3 nop
ProcessInterrupts:
or   byte [status], 4
cmp  dword [intr+7*4], byte 0
je   near .no_int_end
mov  [run_eax], eax
mov  al, [sr+1]
and  eax, byte 7
cmp  al, 7
jne  short .no_int7
mov  edi, intr+6*4
jmp  short .l
.no_int7:
mov  edi, eax
shl  edi, byte 2
add  edi, intr
inc  al
.l:
cmp  dword [edi], byte 0
je   near .skip
test byte [sr+1], 0x20
jnz  short .no_sp_magic
mov  edx, [__sp]
xchg [a+7*4], edx
mov  [__sp], edx
.no_sp_magic:
mov  ebx, [a+7*4]
mov  edx, [pc]
sub  ebx, byte 4
mov  [run_ebx], ebx
mov  [run_edi], edi
call WriteLong
mov  edi, [run_edi]
mov  ebx, [run_ebx]
mov  edx, [sr]
sub  ebx, byte 2
mov  [run_edi], edi
mov  [run_ebx], ebx
call WriteWord
mov  ebx, [run_ebx]
mov  edi, [run_edi]
mov  dh, al
or   dh, 0x20
and  edx, 0xa71f
mov  [sr], edx
mov  [a+7*4], ebx
mov  ebx, [edi]
shl  ebx, byte 2
mov  [run_edi], edi
call ReadLong
mov  edi, [run_edi]
mov  [pc], edx
mov  dword [edi], 0
dec  dword [intr+7*4]
sub  ecx, byte 44
and  byte [status], 0xfd
.skip:
add  edi, byte 4
inc  al
cmp  edi, intr+7*4
jne  near .l
mov  esi, [pc]
mov  eax, [run_eax]
mov  [fetch_esi], esi
and  esi, 0x00FFFFFF
mov     edx, [fetch]
.find_fetch_loop0:
add     edx, byte 12
cmp     dword [edx], byte -1
je      near fetch_error
cmp     esi, [edx]
jb      .find_fetch_loop0
cmp     esi, [edx+4]
ja      .find_fetch_loop0
mov     ebp, [edx+8]
mov  edx, [fetch_esi]
mov  esi, edx
and  edx, 0xFF000000
sub  ebp, edx
add     esi, ebp
.no_int_end:
and  byte [status], 0xfb
ret
times ($$-$) & 3 nop
global Genital68KRun, _Genital68KRun, Genital68KRun_
Genital68KRun:
_Genital68KRun:
Genital68KRun_:
mov  [safety_ebx], ebx
mov  [safety_ecx], ecx
mov  [safety_edx], edx
mov  [safety_esi], esi
mov  [safety_edi], edi
push ebp
mov  ecx, [esp+8+(0*4)]
mov  [cycles], ecx
mov  [remaining], ecx
test byte [sr+1], 0x20
jz   near .set_user_space
jmp  near .continue
.set_user_space:
.continue:
or   byte [status], 1
mov  esi, [pc]
mov  [fetch_esi], esi
and  esi, 0x00FFFFFF
mov     edx, [fetch]
.find_fetch_loop0:
add     edx, byte 12
cmp     dword [edx], byte -1
je      near fetch_error
cmp     esi, [edx]
jb      .find_fetch_loop0
cmp     esi, [edx+4]
ja      .find_fetch_loop0
mov     ebp, [edx+8]
mov  edx, [fetch_esi]
mov  esi, edx
and  edx, 0xFF000000
sub  ebp, edx
add     esi, ebp
mov      dh, [sr]
mov      ah, dh
shl      ah, byte 4
test     dh, byte 2
setnz    al
test     dh, 0x10
setnz    byte [x]
and      dh, byte 1
or       ah, dh
call ProcessInterrupts
test byte [status], 2
jnz  short .stopped
xor  edi, edi
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
.stopped:
xor  ecx, ecx
jmp  Genital68KRun_done
times ($$-$) & 3 nop
Genital68KRun_done:
and      eax, 0xc101
mov      dh, ah
shr      dh, byte 4
shl      al, byte 1
or       dh, al
shr      ah, byte 1
adc      dh, 0
mov      ah, [x]
shl      ah, byte 4
or       dh, ah
mov      [sr], dh
mov [remaining], ecx
mov  dword [pc], esi
sub  dword [pc], ebp
and  byte [status], 0xfe
pop  ebp
xor  eax, eax
mov  edi, [safety_edi]
mov  esi, [safety_esi]
mov  edx, [safety_edx]
mov  ecx, [safety_ecx]
mov  ebx, [safety_ebx]
ret
times ($$-$) & 31 nop
ReadByte:
mov  edi, [read_byte]
mov  [memhandler_ebx], ebx
and  ebx, 0x00FFFFFF
.loop:
add     edi, byte 16
cmp     dword [edi], byte -1
je      short .not_found
cmp     ebx, [edi]
jb      short .loop
cmp     ebx, [edi+4]
ja      short .loop
cmp     dword [edi+8], byte 0
je      short .read_from_handler
mov     edx, ebx
xor     dl, 1
add     edx, [edi+8]
mov     dl, [edx]
xor  edi, edi
mov  ebx, [memhandler_ebx]
ret
times ($$-$) & 3 nop
.not_found:
xor  edi, edi
xor  edx, edx
dec  edx
mov  ebx, [memhandler_ebx]
ret
times ($$-$) & 3 nop
.read_from_handler:
mov  [memhandler_eax], eax
mov  [memhandler_ebp], ebp
mov  dword [pc], esi
sub  dword [pc], ebp
mov     [remaining], ecx
push ebx
call    dword [edi+12]
add     esp, byte 4
mov     edx, eax
mov     esi, [pc]
mov     ecx, [remaining]
mov  eax, [memhandler_eax]
mov  ebp, [memhandler_ebp]
add     esi, ebp
xor     edi, edi
mov  ebx, [memhandler_ebx]
ret
times ($$-$) & 31 nop
ReadWord:
mov  edi, [read_word]
mov  [memhandler_ebx], ebx
and  ebx, 0x00FFFFFF
.loop:
add     edi, byte 16
cmp     dword [edi], byte -1
je      short .not_found
cmp     ebx, [edi]
jb      short .loop
cmp     ebx, [edi+4]
ja      short .loop
cmp     dword [edi+8], byte 0
je      short .read_from_handler
mov     edx, ebx
add     edx, [edi+8]
mov     edx, [edx]
xor  edi, edi
mov  ebx, [memhandler_ebx]
ret
times ($$-$) & 3 nop
.not_found:
xor  edi, edi
xor  edx, edx
dec  edx
mov  ebx, [memhandler_ebx]
ret
times ($$-$) & 3 nop
.read_from_handler:
mov  [memhandler_eax], eax
mov  [memhandler_ebp], ebp
mov  dword [pc], esi
sub  dword [pc], ebp
mov     [remaining], ecx
push ebx
call    dword [edi+12]
add     esp, byte 4
mov     edx, eax
mov     esi, [pc]
mov     ecx, [remaining]
mov  eax, [memhandler_eax]
mov  ebp, [memhandler_ebp]
add     esi, ebp
xor     edi, edi
mov  ebx, [memhandler_ebx]
ret
times ($$-$) & 31 nop
ReadLong:
mov  edi, [read_long]
mov  [memhandler_ebx], ebx
and  ebx, 0x00FFFFFF
.loop:
add     edi, byte 16
cmp     dword [edi], byte -1
je      short .not_found
cmp     ebx, [edi]
jb      short .loop
cmp     ebx, [edi+4]
ja      short .loop
cmp     dword [edi+8], byte 0
je      short .read_from_handler
mov     edx, ebx
add     edx, [edi+8]
mov     edx, [edx]
rol     edx, byte 16
xor  edi, edi
mov  ebx, [memhandler_ebx]
ret
times ($$-$) & 3 nop
.not_found:
xor  edi, edi
xor  edx, edx
dec  edx
mov  ebx, [memhandler_ebx]
ret
times ($$-$) & 3 nop
.read_from_handler:
mov  [memhandler_eax], eax
mov  [memhandler_ebp], ebp
mov  dword [pc], esi
sub  dword [pc], ebp
mov     [remaining], ecx
push ebx
call    dword [edi+12]
add     esp, byte 4
mov     edx, eax
mov     esi, [pc]
mov     ecx, [remaining]
mov  eax, [memhandler_eax]
mov  ebp, [memhandler_ebp]
add     esi, ebp
xor     edi, edi
mov  ebx, [memhandler_ebx]
ret
times ($$-$) & 31 nop
ReadWordSX:
mov  edi, [read_word]
mov  [memhandler_ebx], ebx
and  ebx, 0x00FFFFFF
.loop:
add     edi, byte 16
cmp     dword [edi], byte -1
je      short .not_found
cmp     ebx, [edi]
jb      short .loop
cmp     ebx, [edi+4]
ja      short .loop
cmp     dword [edi+8], byte 0
je      short .read_from_handler
mov     edx, ebx
add     edx, [edi+8]
movsx   edx, word [edx]
xor  edi, edi
mov  ebx, [memhandler_ebx]
ret
times ($$-$) & 3 nop
.not_found:
xor  edi, edi
xor  edx, edx
dec  edx
mov  ebx, [memhandler_ebx]
ret
times ($$-$) & 3 nop
.read_from_handler:
mov  [memhandler_eax], eax
mov  [memhandler_ebp], ebp
mov  dword [pc], esi
sub  dword [pc], ebp
mov     [remaining], ecx
push ebx
call    dword [edi+12]
add     esp, byte 4
movsx   edx, ax
mov     esi, [pc]
mov     ecx, [remaining]
mov  eax, [memhandler_eax]
mov  ebp, [memhandler_ebp]
add     esi, ebp
xor     edi, edi
mov  ebx, [memhandler_ebx]
ret
times ($$-$) & 31 nop
WriteByte:
mov  edi, [write_byte]
and  ebx, 0x00FFFFFF
.loop:
add     edi, byte 16
cmp     dword [edi], byte -1
je      short .not_found
cmp     ebx, [edi]
jb      short .loop
cmp     ebx, [edi+4]
ja      short .loop
cmp     dword [edi+8], byte 0
je      short .write_with_handler
xor     bl, 1
add     ebx, [edi+8]
mov     [ebx], dl
.not_found:
xor  edi, edi
mov  ebx, [memhandler_ebx]
ret
times ($$-$) & 3 nop
.write_with_handler:
mov  [memhandler_eax], eax
mov  [memhandler_ebp], ebp
mov  dword [pc], esi
sub  dword [pc], ebp
mov     [remaining], ecx
mov  [memhandler_edx], edx
push edx
push ebx
call    dword [edi+12]
add     esp, byte 8
mov  edx, [memhandler_edx]
mov     esi, [pc]
mov     ecx, [remaining]
mov  eax, [memhandler_eax]
mov  ebp, [memhandler_ebp]
add     esi, ebp
xor     edi, edi
ret
times ($$-$) & 31 nop
WriteWord:
mov  edi, [write_word]
and  ebx, 0x00FFFFFF
.loop:
add     edi, byte 16
cmp     dword [edi], byte -1
je      short .not_found
cmp     ebx, [edi]
jb      short .loop
cmp     ebx, [edi+4]
ja      short .loop
cmp     dword [edi+8], byte 0
je      short .write_with_handler
add     ebx, [edi+8]
mov     [ebx], dx
.not_found:
xor  edi, edi
mov  ebx, [memhandler_ebx]
ret
times ($$-$) & 3 nop
.write_with_handler:
mov  [memhandler_eax], eax
mov  [memhandler_ebp], ebp
mov  dword [pc], esi
sub  dword [pc], ebp
mov     [remaining], ecx
mov  [memhandler_edx], edx
push edx
push ebx
call    dword [edi+12]
add     esp, byte 8
mov  edx, [memhandler_edx]
mov     esi, [pc]
mov     ecx, [remaining]
mov  eax, [memhandler_eax]
mov  ebp, [memhandler_ebp]
add     esi, ebp
xor     edi, edi
ret
times ($$-$) & 31 nop
WriteLong:
mov  edi, [write_long]
and  ebx, 0x00FFFFFF
.loop:
add     edi, byte 16
cmp     dword [edi], byte -1
je      short .not_found
cmp     ebx, [edi]
jb      short .loop
cmp     ebx, [edi+4]
ja      short .loop
cmp     dword [edi+8], byte 0
je      short .write_with_handler
add     ebx, [edi+8]
ror     edx, byte 16
mov     [ebx], edx
ror     edx, byte 16
.not_found:
xor  edi, edi
mov  ebx, [memhandler_ebx]
ret
times ($$-$) & 3 nop
.write_with_handler:
mov  [memhandler_eax], eax
mov  [memhandler_ebp], ebp
mov  dword [pc], esi
sub  dword [pc], ebp
mov     [remaining], ecx
mov  [memhandler_edx], edx
push edx
push ebx
call    dword [edi+12]
add     esp, byte 8
mov  edx, [memhandler_edx]
mov     esi, [pc]
mov     ecx, [remaining]
mov  eax, [memhandler_eax]
mov  ebp, [memhandler_ebp]
add     esi, ebp
xor     edi, edi
ret
times ($$-$) & 3 nop
IC100: ; ABCD		0xC100-0xC107
and  edi, byte 7
mov  al, [d+0*4]
mov  bl, [d+edi*4]
shr  byte [x], 1
adc  al, bl
daa
setc dl
setc byte [x]
jz   short .unchanged_z
and  ah, 0xbf
.unchanged_z:
and  ah, 0xfe
or   ah, dl
mov  [d+0*4], al
sub  ecx, byte 6
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC108: ; ABCD		0xC108-0xC10F
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
dec  dword [a+0*4]
mov  ebx, [a+edi*4]
call ReadByte
mov  [run_edx], dl
mov  ebx, [a+0*4]
call ReadByte
mov  al, dl
mov  dl, [run_edx]
shr  byte [x], 1
adc  al, dl
daa
setc byte [x]
jz   short .unchanged_z
and  ah, 0xbf
.unchanged_z:
and  ah, 0xfe
or   ah, [x]
mov  dl, al
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC300: ; ABCD		0xC300-0xC307
and  edi, byte 7
mov  al, [d+1*4]
mov  bl, [d+edi*4]
shr  byte [x], 1
adc  al, bl
daa
setc dl
setc byte [x]
jz   short .unchanged_z
and  ah, 0xbf
.unchanged_z:
and  ah, 0xfe
or   ah, dl
mov  [d+1*4], al
sub  ecx, byte 6
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC308: ; ABCD		0xC308-0xC30F
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
dec  dword [a+1*4]
mov  ebx, [a+edi*4]
call ReadByte
mov  [run_edx], dl
mov  ebx, [a+1*4]
call ReadByte
mov  al, dl
mov  dl, [run_edx]
shr  byte [x], 1
adc  al, dl
daa
setc byte [x]
jz   short .unchanged_z
and  ah, 0xbf
.unchanged_z:
and  ah, 0xfe
or   ah, [x]
mov  dl, al
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC500: ; ABCD		0xC500-0xC507
and  edi, byte 7
mov  al, [d+2*4]
mov  bl, [d+edi*4]
shr  byte [x], 1
adc  al, bl
daa
setc dl
setc byte [x]
jz   short .unchanged_z
and  ah, 0xbf
.unchanged_z:
and  ah, 0xfe
or   ah, dl
mov  [d+2*4], al
sub  ecx, byte 6
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC508: ; ABCD		0xC508-0xC50F
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
dec  dword [a+2*4]
mov  ebx, [a+edi*4]
call ReadByte
mov  [run_edx], dl
mov  ebx, [a+2*4]
call ReadByte
mov  al, dl
mov  dl, [run_edx]
shr  byte [x], 1
adc  al, dl
daa
setc byte [x]
jz   short .unchanged_z
and  ah, 0xbf
.unchanged_z:
and  ah, 0xfe
or   ah, [x]
mov  dl, al
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC700: ; ABCD		0xC700-0xC707
and  edi, byte 7
mov  al, [d+3*4]
mov  bl, [d+edi*4]
shr  byte [x], 1
adc  al, bl
daa
setc dl
setc byte [x]
jz   short .unchanged_z
and  ah, 0xbf
.unchanged_z:
and  ah, 0xfe
or   ah, dl
mov  [d+3*4], al
sub  ecx, byte 6
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC708: ; ABCD		0xC708-0xC70F
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
dec  dword [a+3*4]
mov  ebx, [a+edi*4]
call ReadByte
mov  [run_edx], dl
mov  ebx, [a+3*4]
call ReadByte
mov  al, dl
mov  dl, [run_edx]
shr  byte [x], 1
adc  al, dl
daa
setc byte [x]
jz   short .unchanged_z
and  ah, 0xbf
.unchanged_z:
and  ah, 0xfe
or   ah, [x]
mov  dl, al
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC900: ; ABCD		0xC900-0xC907
and  edi, byte 7
mov  al, [d+4*4]
mov  bl, [d+edi*4]
shr  byte [x], 1
adc  al, bl
daa
setc dl
setc byte [x]
jz   short .unchanged_z
and  ah, 0xbf
.unchanged_z:
and  ah, 0xfe
or   ah, dl
mov  [d+4*4], al
sub  ecx, byte 6
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC908: ; ABCD		0xC908-0xC90F
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
dec  dword [a+4*4]
mov  ebx, [a+edi*4]
call ReadByte
mov  [run_edx], dl
mov  ebx, [a+4*4]
call ReadByte
mov  al, dl
mov  dl, [run_edx]
shr  byte [x], 1
adc  al, dl
daa
setc byte [x]
jz   short .unchanged_z
and  ah, 0xbf
.unchanged_z:
and  ah, 0xfe
or   ah, [x]
mov  dl, al
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICB00: ; ABCD		0xCB00-0xCB07
and  edi, byte 7
mov  al, [d+5*4]
mov  bl, [d+edi*4]
shr  byte [x], 1
adc  al, bl
daa
setc dl
setc byte [x]
jz   short .unchanged_z
and  ah, 0xbf
.unchanged_z:
and  ah, 0xfe
or   ah, dl
mov  [d+5*4], al
sub  ecx, byte 6
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICB08: ; ABCD		0xCB08-0xCB0F
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
dec  dword [a+5*4]
mov  ebx, [a+edi*4]
call ReadByte
mov  [run_edx], dl
mov  ebx, [a+5*4]
call ReadByte
mov  al, dl
mov  dl, [run_edx]
shr  byte [x], 1
adc  al, dl
daa
setc byte [x]
jz   short .unchanged_z
and  ah, 0xbf
.unchanged_z:
and  ah, 0xfe
or   ah, [x]
mov  dl, al
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICD00: ; ABCD		0xCD00-0xCD07
and  edi, byte 7
mov  al, [d+6*4]
mov  bl, [d+edi*4]
shr  byte [x], 1
adc  al, bl
daa
setc dl
setc byte [x]
jz   short .unchanged_z
and  ah, 0xbf
.unchanged_z:
and  ah, 0xfe
or   ah, dl
mov  [d+6*4], al
sub  ecx, byte 6
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICD08: ; ABCD		0xCD08-0xCD0F
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
dec  dword [a+6*4]
mov  ebx, [a+edi*4]
call ReadByte
mov  [run_edx], dl
mov  ebx, [a+6*4]
call ReadByte
mov  al, dl
mov  dl, [run_edx]
shr  byte [x], 1
adc  al, dl
daa
setc byte [x]
jz   short .unchanged_z
and  ah, 0xbf
.unchanged_z:
and  ah, 0xfe
or   ah, [x]
mov  dl, al
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICF00: ; ABCD		0xCF00-0xCF07
and  edi, byte 7
mov  al, [d+7*4]
mov  bl, [d+edi*4]
shr  byte [x], 1
adc  al, bl
daa
setc dl
setc byte [x]
jz   short .unchanged_z
and  ah, 0xbf
.unchanged_z:
and  ah, 0xfe
or   ah, dl
mov  [d+7*4], al
sub  ecx, byte 6
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICF08: ; ABCD		0xCF08-0xCF0F
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
sub  dword [a+7*4], byte 2
mov  ebx, [a+edi*4]
call ReadByte
mov  [run_edx], dl
mov  ebx, [a+7*4]
call ReadByte
mov  al, dl
mov  dl, [run_edx]
shr  byte [x], 1
adc  al, dl
daa
setc byte [x]
jz   short .unchanged_z
and  ah, 0xbf
.unchanged_z:
and  ah, 0xfe
or   ah, [x]
mov  dl, al
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8000: ; OR		0x8000-0x8007
and  edi, byte 7
mov  dl, [d+edi*4]
or   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8010: ; OR		0x8010-0x8017
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
or   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8018: ; OR		0x8018-0x801F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
or   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8020: ; OR		0x8020-0x8027
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
or   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8028: ; OR		0x8028-0x802F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
or   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8030: ; OR		0x8030-0x8037
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
or   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8038: ; OR		0x8038
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
or   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8039: ; OR		0x8039
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
or   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I803A: ; OR		0x803A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
or   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I803B: ; OR		0x803B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
or   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I803C: ; OR		0x803C
mov  dl, [esi]
add  esi, byte 2
or   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8040: ; OR		0x8040-0x8047
and  edi, byte 7
mov  edx, [d+edi*4]
or   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8050: ; OR		0x8050-0x8057
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
or   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8058: ; OR		0x8058-0x805F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
or   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8060: ; OR		0x8060-0x8067
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
or   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8068: ; OR		0x8068-0x806F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
or   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8070: ; OR		0x8070-0x8077
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
or   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8078: ; OR		0x8078
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
or   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8079: ; OR		0x8079
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
or   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I807A: ; OR		0x807A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
or   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I807B: ; OR		0x807B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
or   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I807C: ; OR		0x807C
mov  edx, [esi]
add  esi, byte 2
or   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8080: ; OR		0x8080-0x8087
and  edi, byte 7
mov  edx, [d+edi*4]
or   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8090: ; OR		0x8090-0x8097
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
or   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8098: ; OR		0x8098-0x809F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
or   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I80A0: ; OR		0x80A0-0x80A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
or   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I80A8: ; OR		0x80A8-0x80AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
or   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I80B0: ; OR		0x80B0-0x80B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
or   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I80B8: ; OR		0x80B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
or   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I80B9: ; OR		0x80B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
or   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I80BA: ; OR		0x80BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
or   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I80BB: ; OR		0x80BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
or   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I80BC: ; OR		0x80BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
or   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8110: ; OR		0x8110-0x8117
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
or   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8118: ; OR		0x8118-0x811F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
or   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8120: ; OR		0x8120-0x8127
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
or   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8128: ; OR		0x8128-0x812F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
or   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8130: ; OR		0x8130-0x8137
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
or   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8138: ; OR		0x8138
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
or   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8139: ; OR		0x8139
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
or   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8150: ; OR		0x8150-0x8157
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
or   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8158: ; OR		0x8158-0x815F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
or   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8160: ; OR		0x8160-0x8167
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
or   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8168: ; OR		0x8168-0x816F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
or   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8170: ; OR		0x8170-0x8177
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
or   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8178: ; OR		0x8178
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
or   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8179: ; OR		0x8179
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
or   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8190: ; OR		0x8190-0x8197
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
or   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8198: ; OR		0x8198-0x819F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
or   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I81A0: ; OR		0x81A0-0x81A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
or   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I81A8: ; OR		0x81A8-0x81AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
or   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I81B0: ; OR		0x81B0-0x81B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
or   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I81B8: ; OR		0x81B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
or   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I81B9: ; OR		0x81B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
or   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8200: ; OR		0x8200-0x8207
and  edi, byte 7
mov  dl, [d+edi*4]
or   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8210: ; OR		0x8210-0x8217
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
or   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8218: ; OR		0x8218-0x821F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
or   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8220: ; OR		0x8220-0x8227
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
or   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8228: ; OR		0x8228-0x822F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
or   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8230: ; OR		0x8230-0x8237
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
or   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8238: ; OR		0x8238
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
or   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8239: ; OR		0x8239
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
or   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I823A: ; OR		0x823A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
or   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I823B: ; OR		0x823B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
or   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I823C: ; OR		0x823C
mov  dl, [esi]
add  esi, byte 2
or   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8240: ; OR		0x8240-0x8247
and  edi, byte 7
mov  edx, [d+edi*4]
or   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8250: ; OR		0x8250-0x8257
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
or   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8258: ; OR		0x8258-0x825F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
or   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8260: ; OR		0x8260-0x8267
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
or   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8268: ; OR		0x8268-0x826F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
or   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8270: ; OR		0x8270-0x8277
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
or   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8278: ; OR		0x8278
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
or   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8279: ; OR		0x8279
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
or   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I827A: ; OR		0x827A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
or   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I827B: ; OR		0x827B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
or   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I827C: ; OR		0x827C
mov  edx, [esi]
add  esi, byte 2
or   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8280: ; OR		0x8280-0x8287
and  edi, byte 7
mov  edx, [d+edi*4]
or   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8290: ; OR		0x8290-0x8297
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
or   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8298: ; OR		0x8298-0x829F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
or   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I82A0: ; OR		0x82A0-0x82A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
or   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I82A8: ; OR		0x82A8-0x82AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
or   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I82B0: ; OR		0x82B0-0x82B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
or   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I82B8: ; OR		0x82B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
or   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I82B9: ; OR		0x82B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
or   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I82BA: ; OR		0x82BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
or   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I82BB: ; OR		0x82BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
or   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I82BC: ; OR		0x82BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
or   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8310: ; OR		0x8310-0x8317
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
or   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8318: ; OR		0x8318-0x831F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
or   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8320: ; OR		0x8320-0x8327
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
or   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8328: ; OR		0x8328-0x832F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
or   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8330: ; OR		0x8330-0x8337
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
or   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8338: ; OR		0x8338
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
or   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8339: ; OR		0x8339
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
or   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8350: ; OR		0x8350-0x8357
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
or   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8358: ; OR		0x8358-0x835F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
or   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8360: ; OR		0x8360-0x8367
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
or   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8368: ; OR		0x8368-0x836F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
or   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8370: ; OR		0x8370-0x8377
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
or   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8378: ; OR		0x8378
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
or   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8379: ; OR		0x8379
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
or   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8390: ; OR		0x8390-0x8397
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
or   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8398: ; OR		0x8398-0x839F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
or   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I83A0: ; OR		0x83A0-0x83A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
or   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I83A8: ; OR		0x83A8-0x83AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
or   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I83B0: ; OR		0x83B0-0x83B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
or   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I83B8: ; OR		0x83B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
or   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I83B9: ; OR		0x83B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
or   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8400: ; OR		0x8400-0x8407
and  edi, byte 7
mov  dl, [d+edi*4]
or   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8410: ; OR		0x8410-0x8417
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
or   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8418: ; OR		0x8418-0x841F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
or   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8420: ; OR		0x8420-0x8427
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
or   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8428: ; OR		0x8428-0x842F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
or   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8430: ; OR		0x8430-0x8437
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
or   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8438: ; OR		0x8438
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
or   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8439: ; OR		0x8439
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
or   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I843A: ; OR		0x843A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
or   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I843B: ; OR		0x843B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
or   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I843C: ; OR		0x843C
mov  dl, [esi]
add  esi, byte 2
or   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8440: ; OR		0x8440-0x8447
and  edi, byte 7
mov  edx, [d+edi*4]
or   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8450: ; OR		0x8450-0x8457
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
or   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8458: ; OR		0x8458-0x845F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
or   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8460: ; OR		0x8460-0x8467
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
or   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8468: ; OR		0x8468-0x846F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
or   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8470: ; OR		0x8470-0x8477
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
or   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8478: ; OR		0x8478
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
or   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8479: ; OR		0x8479
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
or   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I847A: ; OR		0x847A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
or   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I847B: ; OR		0x847B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
or   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I847C: ; OR		0x847C
mov  edx, [esi]
add  esi, byte 2
or   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8480: ; OR		0x8480-0x8487
and  edi, byte 7
mov  edx, [d+edi*4]
or   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8490: ; OR		0x8490-0x8497
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
or   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8498: ; OR		0x8498-0x849F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
or   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I84A0: ; OR		0x84A0-0x84A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
or   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I84A8: ; OR		0x84A8-0x84AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
or   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I84B0: ; OR		0x84B0-0x84B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
or   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I84B8: ; OR		0x84B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
or   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I84B9: ; OR		0x84B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
or   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I84BA: ; OR		0x84BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
or   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I84BB: ; OR		0x84BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
or   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I84BC: ; OR		0x84BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
or   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8510: ; OR		0x8510-0x8517
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
or   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8518: ; OR		0x8518-0x851F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
or   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8520: ; OR		0x8520-0x8527
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
or   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8528: ; OR		0x8528-0x852F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
or   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8530: ; OR		0x8530-0x8537
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
or   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8538: ; OR		0x8538
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
or   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8539: ; OR		0x8539
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
or   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8550: ; OR		0x8550-0x8557
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
or   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8558: ; OR		0x8558-0x855F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
or   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8560: ; OR		0x8560-0x8567
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
or   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8568: ; OR		0x8568-0x856F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
or   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8570: ; OR		0x8570-0x8577
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
or   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8578: ; OR		0x8578
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
or   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8579: ; OR		0x8579
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
or   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8590: ; OR		0x8590-0x8597
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
or   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8598: ; OR		0x8598-0x859F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
or   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I85A0: ; OR		0x85A0-0x85A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
or   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I85A8: ; OR		0x85A8-0x85AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
or   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I85B0: ; OR		0x85B0-0x85B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
or   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I85B8: ; OR		0x85B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
or   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I85B9: ; OR		0x85B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
or   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8600: ; OR		0x8600-0x8607
and  edi, byte 7
mov  dl, [d+edi*4]
or   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8610: ; OR		0x8610-0x8617
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
or   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8618: ; OR		0x8618-0x861F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
or   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8620: ; OR		0x8620-0x8627
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
or   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8628: ; OR		0x8628-0x862F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
or   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8630: ; OR		0x8630-0x8637
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
or   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8638: ; OR		0x8638
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
or   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8639: ; OR		0x8639
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
or   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I863A: ; OR		0x863A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
or   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I863B: ; OR		0x863B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
or   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I863C: ; OR		0x863C
mov  dl, [esi]
add  esi, byte 2
or   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8640: ; OR		0x8640-0x8647
and  edi, byte 7
mov  edx, [d+edi*4]
or   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8650: ; OR		0x8650-0x8657
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
or   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8658: ; OR		0x8658-0x865F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
or   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8660: ; OR		0x8660-0x8667
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
or   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8668: ; OR		0x8668-0x866F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
or   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8670: ; OR		0x8670-0x8677
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
or   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8678: ; OR		0x8678
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
or   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8679: ; OR		0x8679
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
or   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I867A: ; OR		0x867A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
or   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I867B: ; OR		0x867B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
or   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I867C: ; OR		0x867C
mov  edx, [esi]
add  esi, byte 2
or   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8680: ; OR		0x8680-0x8687
and  edi, byte 7
mov  edx, [d+edi*4]
or   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8690: ; OR		0x8690-0x8697
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
or   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8698: ; OR		0x8698-0x869F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
or   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I86A0: ; OR		0x86A0-0x86A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
or   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I86A8: ; OR		0x86A8-0x86AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
or   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I86B0: ; OR		0x86B0-0x86B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
or   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I86B8: ; OR		0x86B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
or   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I86B9: ; OR		0x86B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
or   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I86BA: ; OR		0x86BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
or   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I86BB: ; OR		0x86BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
or   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I86BC: ; OR		0x86BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
or   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8710: ; OR		0x8710-0x8717
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
or   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8718: ; OR		0x8718-0x871F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
or   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8720: ; OR		0x8720-0x8727
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
or   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8728: ; OR		0x8728-0x872F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
or   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8730: ; OR		0x8730-0x8737
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
or   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8738: ; OR		0x8738
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
or   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8739: ; OR		0x8739
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
or   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8750: ; OR		0x8750-0x8757
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
or   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8758: ; OR		0x8758-0x875F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
or   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8760: ; OR		0x8760-0x8767
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
or   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8768: ; OR		0x8768-0x876F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
or   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8770: ; OR		0x8770-0x8777
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
or   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8778: ; OR		0x8778
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
or   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8779: ; OR		0x8779
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
or   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8790: ; OR		0x8790-0x8797
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
or   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8798: ; OR		0x8798-0x879F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
or   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I87A0: ; OR		0x87A0-0x87A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
or   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I87A8: ; OR		0x87A8-0x87AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
or   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I87B0: ; OR		0x87B0-0x87B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
or   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I87B8: ; OR		0x87B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
or   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I87B9: ; OR		0x87B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
or   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8800: ; OR		0x8800-0x8807
and  edi, byte 7
mov  dl, [d+edi*4]
or   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8810: ; OR		0x8810-0x8817
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
or   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8818: ; OR		0x8818-0x881F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
or   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8820: ; OR		0x8820-0x8827
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
or   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8828: ; OR		0x8828-0x882F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
or   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8830: ; OR		0x8830-0x8837
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
or   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8838: ; OR		0x8838
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
or   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8839: ; OR		0x8839
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
or   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I883A: ; OR		0x883A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
or   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I883B: ; OR		0x883B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
or   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I883C: ; OR		0x883C
mov  dl, [esi]
add  esi, byte 2
or   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8840: ; OR		0x8840-0x8847
and  edi, byte 7
mov  edx, [d+edi*4]
or   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8850: ; OR		0x8850-0x8857
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
or   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8858: ; OR		0x8858-0x885F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
or   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8860: ; OR		0x8860-0x8867
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
or   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8868: ; OR		0x8868-0x886F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
or   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8870: ; OR		0x8870-0x8877
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
or   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8878: ; OR		0x8878
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
or   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8879: ; OR		0x8879
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
or   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I887A: ; OR		0x887A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
or   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I887B: ; OR		0x887B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
or   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I887C: ; OR		0x887C
mov  edx, [esi]
add  esi, byte 2
or   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8880: ; OR		0x8880-0x8887
and  edi, byte 7
mov  edx, [d+edi*4]
or   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8890: ; OR		0x8890-0x8897
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
or   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8898: ; OR		0x8898-0x889F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
or   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I88A0: ; OR		0x88A0-0x88A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
or   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I88A8: ; OR		0x88A8-0x88AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
or   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I88B0: ; OR		0x88B0-0x88B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
or   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I88B8: ; OR		0x88B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
or   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I88B9: ; OR		0x88B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
or   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I88BA: ; OR		0x88BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
or   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I88BB: ; OR		0x88BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
or   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I88BC: ; OR		0x88BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
or   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8910: ; OR		0x8910-0x8917
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
or   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8918: ; OR		0x8918-0x891F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
or   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8920: ; OR		0x8920-0x8927
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
or   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8928: ; OR		0x8928-0x892F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
or   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8930: ; OR		0x8930-0x8937
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
or   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8938: ; OR		0x8938
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
or   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8939: ; OR		0x8939
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
or   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8950: ; OR		0x8950-0x8957
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
or   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8958: ; OR		0x8958-0x895F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
or   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8960: ; OR		0x8960-0x8967
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
or   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8968: ; OR		0x8968-0x896F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
or   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8970: ; OR		0x8970-0x8977
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
or   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8978: ; OR		0x8978
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
or   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8979: ; OR		0x8979
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
or   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8990: ; OR		0x8990-0x8997
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
or   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8998: ; OR		0x8998-0x899F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
or   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I89A0: ; OR		0x89A0-0x89A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
or   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I89A8: ; OR		0x89A8-0x89AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
or   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I89B0: ; OR		0x89B0-0x89B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
or   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I89B8: ; OR		0x89B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
or   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I89B9: ; OR		0x89B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
or   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A00: ; OR		0x8A00-0x8A07
and  edi, byte 7
mov  dl, [d+edi*4]
or   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A10: ; OR		0x8A10-0x8A17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
or   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A18: ; OR		0x8A18-0x8A1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
or   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A20: ; OR		0x8A20-0x8A27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
or   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A28: ; OR		0x8A28-0x8A2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
or   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A30: ; OR		0x8A30-0x8A37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
or   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A38: ; OR		0x8A38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
or   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A39: ; OR		0x8A39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
or   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A3A: ; OR		0x8A3A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
or   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A3B: ; OR		0x8A3B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
or   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A3C: ; OR		0x8A3C
mov  dl, [esi]
add  esi, byte 2
or   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A40: ; OR		0x8A40-0x8A47
and  edi, byte 7
mov  edx, [d+edi*4]
or   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A50: ; OR		0x8A50-0x8A57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
or   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A58: ; OR		0x8A58-0x8A5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
or   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A60: ; OR		0x8A60-0x8A67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
or   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A68: ; OR		0x8A68-0x8A6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
or   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A70: ; OR		0x8A70-0x8A77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
or   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A78: ; OR		0x8A78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
or   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A79: ; OR		0x8A79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
or   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A7A: ; OR		0x8A7A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
or   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A7B: ; OR		0x8A7B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
or   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A7C: ; OR		0x8A7C
mov  edx, [esi]
add  esi, byte 2
or   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A80: ; OR		0x8A80-0x8A87
and  edi, byte 7
mov  edx, [d+edi*4]
or   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A90: ; OR		0x8A90-0x8A97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
or   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8A98: ; OR		0x8A98-0x8A9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
or   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8AA0: ; OR		0x8AA0-0x8AA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
or   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8AA8: ; OR		0x8AA8-0x8AAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
or   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8AB0: ; OR		0x8AB0-0x8AB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
or   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8AB8: ; OR		0x8AB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
or   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8AB9: ; OR		0x8AB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
or   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8ABA: ; OR		0x8ABA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
or   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8ABB: ; OR		0x8ABB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
or   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8ABC: ; OR		0x8ABC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
or   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8B10: ; OR		0x8B10-0x8B17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
or   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8B18: ; OR		0x8B18-0x8B1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
or   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8B20: ; OR		0x8B20-0x8B27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
or   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8B28: ; OR		0x8B28-0x8B2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
or   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8B30: ; OR		0x8B30-0x8B37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
or   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8B38: ; OR		0x8B38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
or   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8B39: ; OR		0x8B39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
or   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8B50: ; OR		0x8B50-0x8B57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
or   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8B58: ; OR		0x8B58-0x8B5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
or   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8B60: ; OR		0x8B60-0x8B67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
or   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8B68: ; OR		0x8B68-0x8B6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
or   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8B70: ; OR		0x8B70-0x8B77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
or   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8B78: ; OR		0x8B78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
or   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8B79: ; OR		0x8B79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
or   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8B90: ; OR		0x8B90-0x8B97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
or   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8B98: ; OR		0x8B98-0x8B9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
or   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8BA0: ; OR		0x8BA0-0x8BA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
or   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8BA8: ; OR		0x8BA8-0x8BAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
or   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8BB0: ; OR		0x8BB0-0x8BB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
or   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8BB8: ; OR		0x8BB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
or   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8BB9: ; OR		0x8BB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
or   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C00: ; OR		0x8C00-0x8C07
and  edi, byte 7
mov  dl, [d+edi*4]
or   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C10: ; OR		0x8C10-0x8C17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
or   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C18: ; OR		0x8C18-0x8C1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
or   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C20: ; OR		0x8C20-0x8C27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
or   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C28: ; OR		0x8C28-0x8C2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
or   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C30: ; OR		0x8C30-0x8C37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
or   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C38: ; OR		0x8C38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
or   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C39: ; OR		0x8C39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
or   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C3A: ; OR		0x8C3A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
or   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C3B: ; OR		0x8C3B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
or   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C3C: ; OR		0x8C3C
mov  dl, [esi]
add  esi, byte 2
or   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C40: ; OR		0x8C40-0x8C47
and  edi, byte 7
mov  edx, [d+edi*4]
or   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C50: ; OR		0x8C50-0x8C57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
or   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C58: ; OR		0x8C58-0x8C5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
or   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C60: ; OR		0x8C60-0x8C67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
or   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C68: ; OR		0x8C68-0x8C6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
or   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C70: ; OR		0x8C70-0x8C77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
or   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C78: ; OR		0x8C78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
or   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C79: ; OR		0x8C79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
or   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C7A: ; OR		0x8C7A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
or   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C7B: ; OR		0x8C7B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
or   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C7C: ; OR		0x8C7C
mov  edx, [esi]
add  esi, byte 2
or   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C80: ; OR		0x8C80-0x8C87
and  edi, byte 7
mov  edx, [d+edi*4]
or   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C90: ; OR		0x8C90-0x8C97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
or   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8C98: ; OR		0x8C98-0x8C9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
or   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8CA0: ; OR		0x8CA0-0x8CA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
or   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8CA8: ; OR		0x8CA8-0x8CAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
or   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8CB0: ; OR		0x8CB0-0x8CB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
or   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8CB8: ; OR		0x8CB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
or   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8CB9: ; OR		0x8CB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
or   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8CBA: ; OR		0x8CBA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
or   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8CBB: ; OR		0x8CBB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
or   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8CBC: ; OR		0x8CBC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
or   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8D10: ; OR		0x8D10-0x8D17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
or   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8D18: ; OR		0x8D18-0x8D1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
or   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8D20: ; OR		0x8D20-0x8D27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
or   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8D28: ; OR		0x8D28-0x8D2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
or   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8D30: ; OR		0x8D30-0x8D37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
or   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8D38: ; OR		0x8D38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
or   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8D39: ; OR		0x8D39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
or   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8D50: ; OR		0x8D50-0x8D57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
or   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8D58: ; OR		0x8D58-0x8D5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
or   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8D60: ; OR		0x8D60-0x8D67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
or   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8D68: ; OR		0x8D68-0x8D6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
or   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8D70: ; OR		0x8D70-0x8D77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
or   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8D78: ; OR		0x8D78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
or   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8D79: ; OR		0x8D79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
or   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8D90: ; OR		0x8D90-0x8D97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
or   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8D98: ; OR		0x8D98-0x8D9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
or   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8DA0: ; OR		0x8DA0-0x8DA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
or   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8DA8: ; OR		0x8DA8-0x8DAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
or   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8DB0: ; OR		0x8DB0-0x8DB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
or   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8DB8: ; OR		0x8DB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
or   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8DB9: ; OR		0x8DB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
or   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E00: ; OR		0x8E00-0x8E07
and  edi, byte 7
mov  dl, [d+edi*4]
or   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E10: ; OR		0x8E10-0x8E17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
or   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E18: ; OR		0x8E18-0x8E1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
or   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E20: ; OR		0x8E20-0x8E27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
or   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E28: ; OR		0x8E28-0x8E2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
or   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E30: ; OR		0x8E30-0x8E37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
or   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E38: ; OR		0x8E38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
or   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E39: ; OR		0x8E39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
or   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E3A: ; OR		0x8E3A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
or   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E3B: ; OR		0x8E3B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
or   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E3C: ; OR		0x8E3C
mov  dl, [esi]
add  esi, byte 2
or   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E40: ; OR		0x8E40-0x8E47
and  edi, byte 7
mov  edx, [d+edi*4]
or   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E50: ; OR		0x8E50-0x8E57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
or   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E58: ; OR		0x8E58-0x8E5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
or   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E60: ; OR		0x8E60-0x8E67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
or   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E68: ; OR		0x8E68-0x8E6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
or   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E70: ; OR		0x8E70-0x8E77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
or   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E78: ; OR		0x8E78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
or   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E79: ; OR		0x8E79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
or   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E7A: ; OR		0x8E7A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
or   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E7B: ; OR		0x8E7B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
or   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E7C: ; OR		0x8E7C
mov  edx, [esi]
add  esi, byte 2
or   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E80: ; OR		0x8E80-0x8E87
and  edi, byte 7
mov  edx, [d+edi*4]
or   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E90: ; OR		0x8E90-0x8E97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
or   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8E98: ; OR		0x8E98-0x8E9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
or   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8EA0: ; OR		0x8EA0-0x8EA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
or   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8EA8: ; OR		0x8EA8-0x8EAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
or   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8EB0: ; OR		0x8EB0-0x8EB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
or   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8EB8: ; OR		0x8EB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
or   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8EB9: ; OR		0x8EB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
or   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8EBA: ; OR		0x8EBA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
or   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8EBB: ; OR		0x8EBB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
or   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8EBC: ; OR		0x8EBC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
or   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8F10: ; OR		0x8F10-0x8F17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
or   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8F18: ; OR		0x8F18-0x8F1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
or   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8F20: ; OR		0x8F20-0x8F27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
or   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8F28: ; OR		0x8F28-0x8F2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
or   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8F30: ; OR		0x8F30-0x8F37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
or   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8F38: ; OR		0x8F38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
or   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8F39: ; OR		0x8F39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
or   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8F50: ; OR		0x8F50-0x8F57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
or   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8F58: ; OR		0x8F58-0x8F5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
or   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8F60: ; OR		0x8F60-0x8F67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
or   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8F68: ; OR		0x8F68-0x8F6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
or   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8F70: ; OR		0x8F70-0x8F77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
or   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8F78: ; OR		0x8F78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
or   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8F79: ; OR		0x8F79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
or   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8F90: ; OR		0x8F90-0x8F97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
or   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8F98: ; OR		0x8F98-0x8F9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
or   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8FA0: ; OR		0x8FA0-0x8FA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
or   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8FA8: ; OR		0x8FA8-0x8FAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
or   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8FB0: ; OR		0x8FB0-0x8FB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
or   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8FB8: ; OR		0x8FB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
or   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I8FB9: ; OR		0x8FB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
or   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9000: ; SUB		0x9000-0x9007
and  edi, byte 7
mov  dl, [d+edi*4]
sub   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9010: ; SUB		0x9010-0x9017
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9018: ; SUB		0x9018-0x901F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9020: ; SUB		0x9020-0x9027
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9028: ; SUB		0x9028-0x902F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9030: ; SUB		0x9030-0x9037
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9038: ; SUB		0x9038
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9039: ; SUB		0x9039
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I903A: ; SUB		0x903A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
sub   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I903B: ; SUB		0x903B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
sub   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I903C: ; SUB		0x903C
mov  dl, [esi]
add  esi, byte 2
sub   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9040: ; SUB		0x9040-0x9047
and  edi, byte 7
mov  edx, [d+edi*4]
sub   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9048: ; SUB		0x9048-0x904F
and  edi, byte 7
mov  edx, [a+edi*4]
sub   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9050: ; SUB		0x9050-0x9057
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9058: ; SUB		0x9058-0x905F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9060: ; SUB		0x9060-0x9067
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9068: ; SUB		0x9068-0x906F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9070: ; SUB		0x9070-0x9077
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9078: ; SUB		0x9078
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9079: ; SUB		0x9079
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I907A: ; SUB		0x907A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
sub   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I907B: ; SUB		0x907B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
sub   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I907C: ; SUB		0x907C
mov  edx, [esi]
add  esi, byte 2
sub   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9080: ; SUB		0x9080-0x9087
and  edi, byte 7
mov  edx, [d+edi*4]
sub   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9088: ; SUB		0x9088-0x908F
and  edi, byte 7
mov  edx, [a+edi*4]
sub   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9090: ; SUB		0x9090-0x9097
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9098: ; SUB		0x9098-0x909F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90A0: ; SUB		0x90A0-0x90A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90A8: ; SUB		0x90A8-0x90AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90B0: ; SUB		0x90B0-0x90B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90B8: ; SUB		0x90B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90B9: ; SUB		0x90B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90BA: ; SUB		0x90BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90BB: ; SUB		0x90BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90BC: ; SUB		0x90BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
sub   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9110: ; SUB		0x9110-0x9117
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9118: ; SUB		0x9118-0x911F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   dl, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9120: ; SUB		0x9120-0x9127
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9128: ; SUB		0x9128-0x912F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   dl, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9130: ; SUB		0x9130-0x9137
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9138: ; SUB		0x9138
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   dl, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9139: ; SUB		0x9139
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   dl, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9150: ; SUB		0x9150-0x9157
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9158: ; SUB		0x9158-0x915F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   dx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9160: ; SUB		0x9160-0x9167
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9168: ; SUB		0x9168-0x916F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   dx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9170: ; SUB		0x9170-0x9177
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9178: ; SUB		0x9178
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   dx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9179: ; SUB		0x9179
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   dx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9190: ; SUB		0x9190-0x9197
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9198: ; SUB		0x9198-0x919F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   edx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I91A0: ; SUB		0x91A0-0x91A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I91A8: ; SUB		0x91A8-0x91AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   edx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I91B0: ; SUB		0x91B0-0x91B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I91B8: ; SUB		0x91B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   edx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I91B9: ; SUB		0x91B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   edx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9200: ; SUB		0x9200-0x9207
and  edi, byte 7
mov  dl, [d+edi*4]
sub   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9210: ; SUB		0x9210-0x9217
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9218: ; SUB		0x9218-0x921F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9220: ; SUB		0x9220-0x9227
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9228: ; SUB		0x9228-0x922F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9230: ; SUB		0x9230-0x9237
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9238: ; SUB		0x9238
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9239: ; SUB		0x9239
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I923A: ; SUB		0x923A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
sub   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I923B: ; SUB		0x923B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
sub   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I923C: ; SUB		0x923C
mov  dl, [esi]
add  esi, byte 2
sub   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9240: ; SUB		0x9240-0x9247
and  edi, byte 7
mov  edx, [d+edi*4]
sub   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9248: ; SUB		0x9248-0x924F
and  edi, byte 7
mov  edx, [a+edi*4]
sub   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9250: ; SUB		0x9250-0x9257
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9258: ; SUB		0x9258-0x925F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9260: ; SUB		0x9260-0x9267
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9268: ; SUB		0x9268-0x926F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9270: ; SUB		0x9270-0x9277
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9278: ; SUB		0x9278
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9279: ; SUB		0x9279
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I927A: ; SUB		0x927A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
sub   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I927B: ; SUB		0x927B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
sub   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I927C: ; SUB		0x927C
mov  edx, [esi]
add  esi, byte 2
sub   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9280: ; SUB		0x9280-0x9287
and  edi, byte 7
mov  edx, [d+edi*4]
sub   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9288: ; SUB		0x9288-0x928F
and  edi, byte 7
mov  edx, [a+edi*4]
sub   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9290: ; SUB		0x9290-0x9297
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9298: ; SUB		0x9298-0x929F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92A0: ; SUB		0x92A0-0x92A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92A8: ; SUB		0x92A8-0x92AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92B0: ; SUB		0x92B0-0x92B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92B8: ; SUB		0x92B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92B9: ; SUB		0x92B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92BA: ; SUB		0x92BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92BB: ; SUB		0x92BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92BC: ; SUB		0x92BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
sub   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9310: ; SUB		0x9310-0x9317
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9318: ; SUB		0x9318-0x931F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   dl, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9320: ; SUB		0x9320-0x9327
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9328: ; SUB		0x9328-0x932F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   dl, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9330: ; SUB		0x9330-0x9337
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9338: ; SUB		0x9338
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   dl, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9339: ; SUB		0x9339
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   dl, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9350: ; SUB		0x9350-0x9357
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9358: ; SUB		0x9358-0x935F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   dx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9360: ; SUB		0x9360-0x9367
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9368: ; SUB		0x9368-0x936F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   dx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9370: ; SUB		0x9370-0x9377
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9378: ; SUB		0x9378
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   dx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9379: ; SUB		0x9379
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   dx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9390: ; SUB		0x9390-0x9397
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9398: ; SUB		0x9398-0x939F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   edx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I93A0: ; SUB		0x93A0-0x93A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I93A8: ; SUB		0x93A8-0x93AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   edx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I93B0: ; SUB		0x93B0-0x93B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I93B8: ; SUB		0x93B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   edx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I93B9: ; SUB		0x93B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   edx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9400: ; SUB		0x9400-0x9407
and  edi, byte 7
mov  dl, [d+edi*4]
sub   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9410: ; SUB		0x9410-0x9417
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9418: ; SUB		0x9418-0x941F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9420: ; SUB		0x9420-0x9427
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9428: ; SUB		0x9428-0x942F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9430: ; SUB		0x9430-0x9437
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9438: ; SUB		0x9438
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9439: ; SUB		0x9439
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I943A: ; SUB		0x943A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
sub   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I943B: ; SUB		0x943B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
sub   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I943C: ; SUB		0x943C
mov  dl, [esi]
add  esi, byte 2
sub   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9440: ; SUB		0x9440-0x9447
and  edi, byte 7
mov  edx, [d+edi*4]
sub   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9448: ; SUB		0x9448-0x944F
and  edi, byte 7
mov  edx, [a+edi*4]
sub   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9450: ; SUB		0x9450-0x9457
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9458: ; SUB		0x9458-0x945F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9460: ; SUB		0x9460-0x9467
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9468: ; SUB		0x9468-0x946F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9470: ; SUB		0x9470-0x9477
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9478: ; SUB		0x9478
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9479: ; SUB		0x9479
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I947A: ; SUB		0x947A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
sub   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I947B: ; SUB		0x947B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
sub   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I947C: ; SUB		0x947C
mov  edx, [esi]
add  esi, byte 2
sub   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9480: ; SUB		0x9480-0x9487
and  edi, byte 7
mov  edx, [d+edi*4]
sub   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9488: ; SUB		0x9488-0x948F
and  edi, byte 7
mov  edx, [a+edi*4]
sub   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9490: ; SUB		0x9490-0x9497
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9498: ; SUB		0x9498-0x949F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94A0: ; SUB		0x94A0-0x94A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94A8: ; SUB		0x94A8-0x94AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94B0: ; SUB		0x94B0-0x94B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94B8: ; SUB		0x94B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94B9: ; SUB		0x94B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94BA: ; SUB		0x94BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94BB: ; SUB		0x94BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94BC: ; SUB		0x94BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
sub   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9510: ; SUB		0x9510-0x9517
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9518: ; SUB		0x9518-0x951F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   dl, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9520: ; SUB		0x9520-0x9527
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9528: ; SUB		0x9528-0x952F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   dl, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9530: ; SUB		0x9530-0x9537
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9538: ; SUB		0x9538
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   dl, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9539: ; SUB		0x9539
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   dl, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9550: ; SUB		0x9550-0x9557
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9558: ; SUB		0x9558-0x955F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   dx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9560: ; SUB		0x9560-0x9567
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9568: ; SUB		0x9568-0x956F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   dx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9570: ; SUB		0x9570-0x9577
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9578: ; SUB		0x9578
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   dx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9579: ; SUB		0x9579
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   dx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9590: ; SUB		0x9590-0x9597
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9598: ; SUB		0x9598-0x959F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   edx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I95A0: ; SUB		0x95A0-0x95A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I95A8: ; SUB		0x95A8-0x95AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   edx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I95B0: ; SUB		0x95B0-0x95B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I95B8: ; SUB		0x95B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   edx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I95B9: ; SUB		0x95B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   edx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9600: ; SUB		0x9600-0x9607
and  edi, byte 7
mov  dl, [d+edi*4]
sub   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9610: ; SUB		0x9610-0x9617
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9618: ; SUB		0x9618-0x961F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9620: ; SUB		0x9620-0x9627
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9628: ; SUB		0x9628-0x962F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9630: ; SUB		0x9630-0x9637
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9638: ; SUB		0x9638
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9639: ; SUB		0x9639
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I963A: ; SUB		0x963A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
sub   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I963B: ; SUB		0x963B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
sub   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I963C: ; SUB		0x963C
mov  dl, [esi]
add  esi, byte 2
sub   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9640: ; SUB		0x9640-0x9647
and  edi, byte 7
mov  edx, [d+edi*4]
sub   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9648: ; SUB		0x9648-0x964F
and  edi, byte 7
mov  edx, [a+edi*4]
sub   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9650: ; SUB		0x9650-0x9657
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9658: ; SUB		0x9658-0x965F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9660: ; SUB		0x9660-0x9667
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9668: ; SUB		0x9668-0x966F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9670: ; SUB		0x9670-0x9677
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9678: ; SUB		0x9678
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9679: ; SUB		0x9679
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I967A: ; SUB		0x967A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
sub   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I967B: ; SUB		0x967B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
sub   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I967C: ; SUB		0x967C
mov  edx, [esi]
add  esi, byte 2
sub   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9680: ; SUB		0x9680-0x9687
and  edi, byte 7
mov  edx, [d+edi*4]
sub   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9688: ; SUB		0x9688-0x968F
and  edi, byte 7
mov  edx, [a+edi*4]
sub   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9690: ; SUB		0x9690-0x9697
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9698: ; SUB		0x9698-0x969F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96A0: ; SUB		0x96A0-0x96A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96A8: ; SUB		0x96A8-0x96AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96B0: ; SUB		0x96B0-0x96B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96B8: ; SUB		0x96B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96B9: ; SUB		0x96B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96BA: ; SUB		0x96BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96BB: ; SUB		0x96BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96BC: ; SUB		0x96BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
sub   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9710: ; SUB		0x9710-0x9717
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9718: ; SUB		0x9718-0x971F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   dl, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9720: ; SUB		0x9720-0x9727
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9728: ; SUB		0x9728-0x972F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   dl, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9730: ; SUB		0x9730-0x9737
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9738: ; SUB		0x9738
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   dl, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9739: ; SUB		0x9739
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   dl, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9750: ; SUB		0x9750-0x9757
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9758: ; SUB		0x9758-0x975F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   dx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9760: ; SUB		0x9760-0x9767
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9768: ; SUB		0x9768-0x976F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   dx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9770: ; SUB		0x9770-0x9777
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9778: ; SUB		0x9778
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   dx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9779: ; SUB		0x9779
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   dx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9790: ; SUB		0x9790-0x9797
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9798: ; SUB		0x9798-0x979F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   edx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I97A0: ; SUB		0x97A0-0x97A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I97A8: ; SUB		0x97A8-0x97AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   edx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I97B0: ; SUB		0x97B0-0x97B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I97B8: ; SUB		0x97B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   edx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I97B9: ; SUB		0x97B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   edx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9800: ; SUB		0x9800-0x9807
and  edi, byte 7
mov  dl, [d+edi*4]
sub   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9810: ; SUB		0x9810-0x9817
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9818: ; SUB		0x9818-0x981F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9820: ; SUB		0x9820-0x9827
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9828: ; SUB		0x9828-0x982F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9830: ; SUB		0x9830-0x9837
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9838: ; SUB		0x9838
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9839: ; SUB		0x9839
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I983A: ; SUB		0x983A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
sub   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I983B: ; SUB		0x983B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
sub   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I983C: ; SUB		0x983C
mov  dl, [esi]
add  esi, byte 2
sub   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9840: ; SUB		0x9840-0x9847
and  edi, byte 7
mov  edx, [d+edi*4]
sub   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9848: ; SUB		0x9848-0x984F
and  edi, byte 7
mov  edx, [a+edi*4]
sub   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9850: ; SUB		0x9850-0x9857
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9858: ; SUB		0x9858-0x985F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9860: ; SUB		0x9860-0x9867
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9868: ; SUB		0x9868-0x986F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9870: ; SUB		0x9870-0x9877
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9878: ; SUB		0x9878
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9879: ; SUB		0x9879
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I987A: ; SUB		0x987A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
sub   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I987B: ; SUB		0x987B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
sub   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I987C: ; SUB		0x987C
mov  edx, [esi]
add  esi, byte 2
sub   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9880: ; SUB		0x9880-0x9887
and  edi, byte 7
mov  edx, [d+edi*4]
sub   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9888: ; SUB		0x9888-0x988F
and  edi, byte 7
mov  edx, [a+edi*4]
sub   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9890: ; SUB		0x9890-0x9897
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9898: ; SUB		0x9898-0x989F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98A0: ; SUB		0x98A0-0x98A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98A8: ; SUB		0x98A8-0x98AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98B0: ; SUB		0x98B0-0x98B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98B8: ; SUB		0x98B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98B9: ; SUB		0x98B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98BA: ; SUB		0x98BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98BB: ; SUB		0x98BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98BC: ; SUB		0x98BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
sub   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9910: ; SUB		0x9910-0x9917
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9918: ; SUB		0x9918-0x991F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   dl, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9920: ; SUB		0x9920-0x9927
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9928: ; SUB		0x9928-0x992F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   dl, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9930: ; SUB		0x9930-0x9937
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9938: ; SUB		0x9938
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   dl, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9939: ; SUB		0x9939
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   dl, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9950: ; SUB		0x9950-0x9957
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9958: ; SUB		0x9958-0x995F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   dx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9960: ; SUB		0x9960-0x9967
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9968: ; SUB		0x9968-0x996F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   dx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9970: ; SUB		0x9970-0x9977
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9978: ; SUB		0x9978
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   dx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9979: ; SUB		0x9979
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   dx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9990: ; SUB		0x9990-0x9997
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9998: ; SUB		0x9998-0x999F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   edx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I99A0: ; SUB		0x99A0-0x99A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I99A8: ; SUB		0x99A8-0x99AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   edx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I99B0: ; SUB		0x99B0-0x99B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I99B8: ; SUB		0x99B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   edx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I99B9: ; SUB		0x99B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   edx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A00: ; SUB		0x9A00-0x9A07
and  edi, byte 7
mov  dl, [d+edi*4]
sub   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A10: ; SUB		0x9A10-0x9A17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A18: ; SUB		0x9A18-0x9A1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A20: ; SUB		0x9A20-0x9A27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A28: ; SUB		0x9A28-0x9A2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A30: ; SUB		0x9A30-0x9A37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A38: ; SUB		0x9A38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A39: ; SUB		0x9A39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A3A: ; SUB		0x9A3A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
sub   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A3B: ; SUB		0x9A3B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
sub   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A3C: ; SUB		0x9A3C
mov  dl, [esi]
add  esi, byte 2
sub   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A40: ; SUB		0x9A40-0x9A47
and  edi, byte 7
mov  edx, [d+edi*4]
sub   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A48: ; SUB		0x9A48-0x9A4F
and  edi, byte 7
mov  edx, [a+edi*4]
sub   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A50: ; SUB		0x9A50-0x9A57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A58: ; SUB		0x9A58-0x9A5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A60: ; SUB		0x9A60-0x9A67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A68: ; SUB		0x9A68-0x9A6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A70: ; SUB		0x9A70-0x9A77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A78: ; SUB		0x9A78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A79: ; SUB		0x9A79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A7A: ; SUB		0x9A7A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
sub   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A7B: ; SUB		0x9A7B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
sub   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A7C: ; SUB		0x9A7C
mov  edx, [esi]
add  esi, byte 2
sub   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A80: ; SUB		0x9A80-0x9A87
and  edi, byte 7
mov  edx, [d+edi*4]
sub   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A88: ; SUB		0x9A88-0x9A8F
and  edi, byte 7
mov  edx, [a+edi*4]
sub   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A90: ; SUB		0x9A90-0x9A97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9A98: ; SUB		0x9A98-0x9A9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9AA0: ; SUB		0x9AA0-0x9AA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9AA8: ; SUB		0x9AA8-0x9AAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9AB0: ; SUB		0x9AB0-0x9AB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9AB8: ; SUB		0x9AB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9AB9: ; SUB		0x9AB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9ABA: ; SUB		0x9ABA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9ABB: ; SUB		0x9ABB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9ABC: ; SUB		0x9ABC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
sub   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9B10: ; SUB		0x9B10-0x9B17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9B18: ; SUB		0x9B18-0x9B1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   dl, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9B20: ; SUB		0x9B20-0x9B27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9B28: ; SUB		0x9B28-0x9B2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   dl, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9B30: ; SUB		0x9B30-0x9B37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9B38: ; SUB		0x9B38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   dl, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9B39: ; SUB		0x9B39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   dl, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9B50: ; SUB		0x9B50-0x9B57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9B58: ; SUB		0x9B58-0x9B5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   dx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9B60: ; SUB		0x9B60-0x9B67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9B68: ; SUB		0x9B68-0x9B6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   dx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9B70: ; SUB		0x9B70-0x9B77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9B78: ; SUB		0x9B78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   dx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9B79: ; SUB		0x9B79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   dx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9B90: ; SUB		0x9B90-0x9B97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9B98: ; SUB		0x9B98-0x9B9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   edx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9BA0: ; SUB		0x9BA0-0x9BA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9BA8: ; SUB		0x9BA8-0x9BAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   edx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9BB0: ; SUB		0x9BB0-0x9BB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9BB8: ; SUB		0x9BB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   edx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9BB9: ; SUB		0x9BB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   edx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C00: ; SUB		0x9C00-0x9C07
and  edi, byte 7
mov  dl, [d+edi*4]
sub   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C10: ; SUB		0x9C10-0x9C17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C18: ; SUB		0x9C18-0x9C1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C20: ; SUB		0x9C20-0x9C27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C28: ; SUB		0x9C28-0x9C2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C30: ; SUB		0x9C30-0x9C37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C38: ; SUB		0x9C38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C39: ; SUB		0x9C39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C3A: ; SUB		0x9C3A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
sub   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C3B: ; SUB		0x9C3B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
sub   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C3C: ; SUB		0x9C3C
mov  dl, [esi]
add  esi, byte 2
sub   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C40: ; SUB		0x9C40-0x9C47
and  edi, byte 7
mov  edx, [d+edi*4]
sub   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C48: ; SUB		0x9C48-0x9C4F
and  edi, byte 7
mov  edx, [a+edi*4]
sub   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C50: ; SUB		0x9C50-0x9C57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C58: ; SUB		0x9C58-0x9C5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C60: ; SUB		0x9C60-0x9C67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C68: ; SUB		0x9C68-0x9C6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C70: ; SUB		0x9C70-0x9C77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C78: ; SUB		0x9C78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C79: ; SUB		0x9C79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C7A: ; SUB		0x9C7A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
sub   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C7B: ; SUB		0x9C7B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
sub   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C7C: ; SUB		0x9C7C
mov  edx, [esi]
add  esi, byte 2
sub   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C80: ; SUB		0x9C80-0x9C87
and  edi, byte 7
mov  edx, [d+edi*4]
sub   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C88: ; SUB		0x9C88-0x9C8F
and  edi, byte 7
mov  edx, [a+edi*4]
sub   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C90: ; SUB		0x9C90-0x9C97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9C98: ; SUB		0x9C98-0x9C9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CA0: ; SUB		0x9CA0-0x9CA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CA8: ; SUB		0x9CA8-0x9CAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CB0: ; SUB		0x9CB0-0x9CB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CB8: ; SUB		0x9CB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CB9: ; SUB		0x9CB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CBA: ; SUB		0x9CBA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CBB: ; SUB		0x9CBB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CBC: ; SUB		0x9CBC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
sub   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9D10: ; SUB		0x9D10-0x9D17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9D18: ; SUB		0x9D18-0x9D1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   dl, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9D20: ; SUB		0x9D20-0x9D27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9D28: ; SUB		0x9D28-0x9D2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   dl, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9D30: ; SUB		0x9D30-0x9D37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9D38: ; SUB		0x9D38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   dl, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9D39: ; SUB		0x9D39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   dl, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9D50: ; SUB		0x9D50-0x9D57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9D58: ; SUB		0x9D58-0x9D5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   dx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9D60: ; SUB		0x9D60-0x9D67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9D68: ; SUB		0x9D68-0x9D6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   dx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9D70: ; SUB		0x9D70-0x9D77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9D78: ; SUB		0x9D78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   dx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9D79: ; SUB		0x9D79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   dx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9D90: ; SUB		0x9D90-0x9D97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9D98: ; SUB		0x9D98-0x9D9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   edx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9DA0: ; SUB		0x9DA0-0x9DA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9DA8: ; SUB		0x9DA8-0x9DAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   edx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9DB0: ; SUB		0x9DB0-0x9DB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9DB8: ; SUB		0x9DB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   edx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9DB9: ; SUB		0x9DB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   edx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E00: ; SUB		0x9E00-0x9E07
and  edi, byte 7
mov  dl, [d+edi*4]
sub   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E10: ; SUB		0x9E10-0x9E17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E18: ; SUB		0x9E18-0x9E1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E20: ; SUB		0x9E20-0x9E27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E28: ; SUB		0x9E28-0x9E2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E30: ; SUB		0x9E30-0x9E37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E38: ; SUB		0x9E38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E39: ; SUB		0x9E39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E3A: ; SUB		0x9E3A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
sub   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E3B: ; SUB		0x9E3B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
sub   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E3C: ; SUB		0x9E3C
mov  dl, [esi]
add  esi, byte 2
sub   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E40: ; SUB		0x9E40-0x9E47
and  edi, byte 7
mov  edx, [d+edi*4]
sub   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E48: ; SUB		0x9E48-0x9E4F
and  edi, byte 7
mov  edx, [a+edi*4]
sub   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E50: ; SUB		0x9E50-0x9E57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E58: ; SUB		0x9E58-0x9E5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E60: ; SUB		0x9E60-0x9E67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E68: ; SUB		0x9E68-0x9E6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E70: ; SUB		0x9E70-0x9E77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E78: ; SUB		0x9E78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E79: ; SUB		0x9E79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E7A: ; SUB		0x9E7A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
sub   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E7B: ; SUB		0x9E7B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
sub   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E7C: ; SUB		0x9E7C
mov  edx, [esi]
add  esi, byte 2
sub   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E80: ; SUB		0x9E80-0x9E87
and  edi, byte 7
mov  edx, [d+edi*4]
sub   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E88: ; SUB		0x9E88-0x9E8F
and  edi, byte 7
mov  edx, [a+edi*4]
sub   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E90: ; SUB		0x9E90-0x9E97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9E98: ; SUB		0x9E98-0x9E9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9EA0: ; SUB		0x9EA0-0x9EA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9EA8: ; SUB		0x9EA8-0x9EAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9EB0: ; SUB		0x9EB0-0x9EB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9EB8: ; SUB		0x9EB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9EB9: ; SUB		0x9EB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9EBA: ; SUB		0x9EBA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9EBB: ; SUB		0x9EBB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9EBC: ; SUB		0x9EBC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
sub   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9F10: ; SUB		0x9F10-0x9F17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9F18: ; SUB		0x9F18-0x9F1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   dl, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9F20: ; SUB		0x9F20-0x9F27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9F28: ; SUB		0x9F28-0x9F2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   dl, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9F30: ; SUB		0x9F30-0x9F37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   dl, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9F38: ; SUB		0x9F38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   dl, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9F39: ; SUB		0x9F39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   dl, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9F50: ; SUB		0x9F50-0x9F57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9F58: ; SUB		0x9F58-0x9F5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   dx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9F60: ; SUB		0x9F60-0x9F67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9F68: ; SUB		0x9F68-0x9F6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   dx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9F70: ; SUB		0x9F70-0x9F77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   dx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9F78: ; SUB		0x9F78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   dx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9F79: ; SUB		0x9F79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   dx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9F90: ; SUB		0x9F90-0x9F97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9F98: ; SUB		0x9F98-0x9F9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   edx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9FA0: ; SUB		0x9FA0-0x9FA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9FA8: ; SUB		0x9FA8-0x9FAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   edx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9FB0: ; SUB		0x9FB0-0x9FB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   edx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9FB8: ; SUB		0x9FB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   edx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9FB9: ; SUB		0x9FB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   edx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB000: ; CMP		0xB000-0xB007
and  edi, byte 7
mov  dl, [d+edi*4]
cmp   [d+(0*4)], dl
lahf
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB010: ; CMP		0xB010-0xB017
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
cmp   [d+(0*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB018: ; CMP		0xB018-0xB01F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
cmp   [d+(0*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB020: ; CMP		0xB020-0xB027
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
cmp   [d+(0*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB028: ; CMP		0xB028-0xB02F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
cmp   [d+(0*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB030: ; CMP		0xB030-0xB037
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
cmp   [d+(0*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB038: ; CMP		0xB038
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
cmp   [d+(0*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB039: ; CMP		0xB039
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
cmp   [d+(0*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB03A: ; CMP		0xB03A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
cmp   [d+(0*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB03B: ; CMP		0xB03B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
cmp   [d+(0*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB03C: ; CMP		0xB03C
mov  dl, [esi]
add  esi, byte 2
cmp   [d+(0*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB040: ; CMP		0xB040-0xB047
and  edi, byte 7
mov  edx, [d+edi*4]
cmp   [d+(0*4)], dx
lahf
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB048: ; CMP		0xB048-0xB04F
and  edi, byte 7
mov  edx, [a+edi*4]
cmp   [d+(0*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB050: ; CMP		0xB050-0xB057
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
cmp   [d+(0*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB058: ; CMP		0xB058-0xB05F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
cmp   [d+(0*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB060: ; CMP		0xB060-0xB067
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
cmp   [d+(0*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB068: ; CMP		0xB068-0xB06F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
cmp   [d+(0*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB070: ; CMP		0xB070-0xB077
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
cmp   [d+(0*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB078: ; CMP		0xB078
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
cmp   [d+(0*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB079: ; CMP		0xB079
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
cmp   [d+(0*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB07A: ; CMP		0xB07A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
cmp   [d+(0*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB07B: ; CMP		0xB07B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
cmp   [d+(0*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB07C: ; CMP		0xB07C
mov  edx, [esi]
add  esi, byte 2
cmp   [d+(0*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB080: ; CMP		0xB080-0xB087
and  edi, byte 7
mov  edx, [d+edi*4]
cmp   [d+(0*4)], edx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB088: ; CMP		0xB088-0xB08F
and  edi, byte 7
mov  edx, [a+edi*4]
cmp   [d+(0*4)], edx
lahf
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB090: ; CMP		0xB090-0xB097
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
cmp   [d+(0*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB098: ; CMP		0xB098-0xB09F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
cmp   [d+(0*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB0A0: ; CMP		0xB0A0-0xB0A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
cmp   [d+(0*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB0A8: ; CMP		0xB0A8-0xB0AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
cmp   [d+(0*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB0B0: ; CMP		0xB0B0-0xB0B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
cmp   [d+(0*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB0B8: ; CMP		0xB0B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
cmp   [d+(0*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB0B9: ; CMP		0xB0B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
cmp   [d+(0*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB0BA: ; CMP		0xB0BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
cmp   [d+(0*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB0BB: ; CMP		0xB0BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
cmp   [d+(0*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB0BC: ; CMP		0xB0BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
cmp   [d+(0*4)], edx
lahf
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB100: ; EOR		0xB100-0xB107
and  edi, byte 7
mov  edx, [d+(0*4)]
xor   byte [d+(edi*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB110: ; EOR		0xB110-0xB117
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB118: ; EOR		0xB118-0xB11F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
xor   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB120: ; EOR		0xB120-0xB127
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB128: ; EOR		0xB128-0xB12F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
xor   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB130: ; EOR		0xB130-0xB137
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB138: ; EOR		0xB138
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
xor   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB139: ; EOR		0xB139
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
xor   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB140: ; EOR		0xB140-0xB147
and  edi, byte 7
mov  edx, [d+(0*4)]
xor   word [d+(edi*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB150: ; EOR		0xB150-0xB157
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB158: ; EOR		0xB158-0xB15F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
xor   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB160: ; EOR		0xB160-0xB167
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB168: ; EOR		0xB168-0xB16F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
xor   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB170: ; EOR		0xB170-0xB177
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB178: ; EOR		0xB178
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
xor   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB179: ; EOR		0xB179
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
xor   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB180: ; EOR		0xB180-0xB187
and  edi, byte 7
mov  edx, [d+(0*4)]
xor   dword [d+(edi*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB190: ; EOR		0xB190-0xB197
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB198: ; EOR		0xB198-0xB19F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
xor   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB1A0: ; EOR		0xB1A0-0xB1A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB1A8: ; EOR		0xB1A8-0xB1AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
xor   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB1B0: ; EOR		0xB1B0-0xB1B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB1B8: ; EOR		0xB1B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
xor   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB1B9: ; EOR		0xB1B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
xor   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB200: ; CMP		0xB200-0xB207
and  edi, byte 7
mov  dl, [d+edi*4]
cmp   [d+(1*4)], dl
lahf
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB210: ; CMP		0xB210-0xB217
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
cmp   [d+(1*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB218: ; CMP		0xB218-0xB21F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
cmp   [d+(1*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB220: ; CMP		0xB220-0xB227
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
cmp   [d+(1*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB228: ; CMP		0xB228-0xB22F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
cmp   [d+(1*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB230: ; CMP		0xB230-0xB237
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
cmp   [d+(1*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB238: ; CMP		0xB238
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
cmp   [d+(1*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB239: ; CMP		0xB239
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
cmp   [d+(1*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB23A: ; CMP		0xB23A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
cmp   [d+(1*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB23B: ; CMP		0xB23B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
cmp   [d+(1*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB23C: ; CMP		0xB23C
mov  dl, [esi]
add  esi, byte 2
cmp   [d+(1*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB240: ; CMP		0xB240-0xB247
and  edi, byte 7
mov  edx, [d+edi*4]
cmp   [d+(1*4)], dx
lahf
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB248: ; CMP		0xB248-0xB24F
and  edi, byte 7
mov  edx, [a+edi*4]
cmp   [d+(1*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB250: ; CMP		0xB250-0xB257
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
cmp   [d+(1*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB258: ; CMP		0xB258-0xB25F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
cmp   [d+(1*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB260: ; CMP		0xB260-0xB267
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
cmp   [d+(1*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB268: ; CMP		0xB268-0xB26F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
cmp   [d+(1*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB270: ; CMP		0xB270-0xB277
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
cmp   [d+(1*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB278: ; CMP		0xB278
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
cmp   [d+(1*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB279: ; CMP		0xB279
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
cmp   [d+(1*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB27A: ; CMP		0xB27A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
cmp   [d+(1*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB27B: ; CMP		0xB27B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
cmp   [d+(1*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB27C: ; CMP		0xB27C
mov  edx, [esi]
add  esi, byte 2
cmp   [d+(1*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB280: ; CMP		0xB280-0xB287
and  edi, byte 7
mov  edx, [d+edi*4]
cmp   [d+(1*4)], edx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB288: ; CMP		0xB288-0xB28F
and  edi, byte 7
mov  edx, [a+edi*4]
cmp   [d+(1*4)], edx
lahf
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB290: ; CMP		0xB290-0xB297
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
cmp   [d+(1*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB298: ; CMP		0xB298-0xB29F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
cmp   [d+(1*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB2A0: ; CMP		0xB2A0-0xB2A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
cmp   [d+(1*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB2A8: ; CMP		0xB2A8-0xB2AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
cmp   [d+(1*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB2B0: ; CMP		0xB2B0-0xB2B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
cmp   [d+(1*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB2B8: ; CMP		0xB2B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
cmp   [d+(1*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB2B9: ; CMP		0xB2B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
cmp   [d+(1*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB2BA: ; CMP		0xB2BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
cmp   [d+(1*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB2BB: ; CMP		0xB2BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
cmp   [d+(1*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB2BC: ; CMP		0xB2BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
cmp   [d+(1*4)], edx
lahf
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB300: ; EOR		0xB300-0xB307
and  edi, byte 7
mov  edx, [d+(1*4)]
xor   byte [d+(edi*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB310: ; EOR		0xB310-0xB317
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB318: ; EOR		0xB318-0xB31F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
xor   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB320: ; EOR		0xB320-0xB327
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB328: ; EOR		0xB328-0xB32F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
xor   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB330: ; EOR		0xB330-0xB337
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB338: ; EOR		0xB338
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
xor   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB339: ; EOR		0xB339
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
xor   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB340: ; EOR		0xB340-0xB347
and  edi, byte 7
mov  edx, [d+(1*4)]
xor   word [d+(edi*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB350: ; EOR		0xB350-0xB357
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB358: ; EOR		0xB358-0xB35F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
xor   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB360: ; EOR		0xB360-0xB367
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB368: ; EOR		0xB368-0xB36F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
xor   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB370: ; EOR		0xB370-0xB377
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB378: ; EOR		0xB378
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
xor   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB379: ; EOR		0xB379
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
xor   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB380: ; EOR		0xB380-0xB387
and  edi, byte 7
mov  edx, [d+(1*4)]
xor   dword [d+(edi*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB390: ; EOR		0xB390-0xB397
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB398: ; EOR		0xB398-0xB39F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
xor   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB3A0: ; EOR		0xB3A0-0xB3A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB3A8: ; EOR		0xB3A8-0xB3AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
xor   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB3B0: ; EOR		0xB3B0-0xB3B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB3B8: ; EOR		0xB3B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
xor   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB3B9: ; EOR		0xB3B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
xor   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB400: ; CMP		0xB400-0xB407
and  edi, byte 7
mov  dl, [d+edi*4]
cmp   [d+(2*4)], dl
lahf
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB410: ; CMP		0xB410-0xB417
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
cmp   [d+(2*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB418: ; CMP		0xB418-0xB41F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
cmp   [d+(2*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB420: ; CMP		0xB420-0xB427
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
cmp   [d+(2*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB428: ; CMP		0xB428-0xB42F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
cmp   [d+(2*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB430: ; CMP		0xB430-0xB437
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
cmp   [d+(2*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB438: ; CMP		0xB438
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
cmp   [d+(2*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB439: ; CMP		0xB439
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
cmp   [d+(2*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB43A: ; CMP		0xB43A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
cmp   [d+(2*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB43B: ; CMP		0xB43B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
cmp   [d+(2*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB43C: ; CMP		0xB43C
mov  dl, [esi]
add  esi, byte 2
cmp   [d+(2*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB440: ; CMP		0xB440-0xB447
and  edi, byte 7
mov  edx, [d+edi*4]
cmp   [d+(2*4)], dx
lahf
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB448: ; CMP		0xB448-0xB44F
and  edi, byte 7
mov  edx, [a+edi*4]
cmp   [d+(2*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB450: ; CMP		0xB450-0xB457
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
cmp   [d+(2*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB458: ; CMP		0xB458-0xB45F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
cmp   [d+(2*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB460: ; CMP		0xB460-0xB467
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
cmp   [d+(2*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB468: ; CMP		0xB468-0xB46F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
cmp   [d+(2*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB470: ; CMP		0xB470-0xB477
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
cmp   [d+(2*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB478: ; CMP		0xB478
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
cmp   [d+(2*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB479: ; CMP		0xB479
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
cmp   [d+(2*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB47A: ; CMP		0xB47A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
cmp   [d+(2*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB47B: ; CMP		0xB47B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
cmp   [d+(2*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB47C: ; CMP		0xB47C
mov  edx, [esi]
add  esi, byte 2
cmp   [d+(2*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB480: ; CMP		0xB480-0xB487
and  edi, byte 7
mov  edx, [d+edi*4]
cmp   [d+(2*4)], edx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB488: ; CMP		0xB488-0xB48F
and  edi, byte 7
mov  edx, [a+edi*4]
cmp   [d+(2*4)], edx
lahf
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB490: ; CMP		0xB490-0xB497
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
cmp   [d+(2*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB498: ; CMP		0xB498-0xB49F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
cmp   [d+(2*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB4A0: ; CMP		0xB4A0-0xB4A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
cmp   [d+(2*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB4A8: ; CMP		0xB4A8-0xB4AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
cmp   [d+(2*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB4B0: ; CMP		0xB4B0-0xB4B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
cmp   [d+(2*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB4B8: ; CMP		0xB4B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
cmp   [d+(2*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB4B9: ; CMP		0xB4B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
cmp   [d+(2*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB4BA: ; CMP		0xB4BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
cmp   [d+(2*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB4BB: ; CMP		0xB4BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
cmp   [d+(2*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB4BC: ; CMP		0xB4BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
cmp   [d+(2*4)], edx
lahf
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB500: ; EOR		0xB500-0xB507
and  edi, byte 7
mov  edx, [d+(2*4)]
xor   byte [d+(edi*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB510: ; EOR		0xB510-0xB517
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB518: ; EOR		0xB518-0xB51F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
xor   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB520: ; EOR		0xB520-0xB527
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB528: ; EOR		0xB528-0xB52F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
xor   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB530: ; EOR		0xB530-0xB537
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB538: ; EOR		0xB538
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
xor   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB539: ; EOR		0xB539
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
xor   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB540: ; EOR		0xB540-0xB547
and  edi, byte 7
mov  edx, [d+(2*4)]
xor   word [d+(edi*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB550: ; EOR		0xB550-0xB557
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB558: ; EOR		0xB558-0xB55F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
xor   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB560: ; EOR		0xB560-0xB567
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB568: ; EOR		0xB568-0xB56F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
xor   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB570: ; EOR		0xB570-0xB577
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB578: ; EOR		0xB578
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
xor   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB579: ; EOR		0xB579
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
xor   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB580: ; EOR		0xB580-0xB587
and  edi, byte 7
mov  edx, [d+(2*4)]
xor   dword [d+(edi*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB590: ; EOR		0xB590-0xB597
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB598: ; EOR		0xB598-0xB59F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
xor   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB5A0: ; EOR		0xB5A0-0xB5A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB5A8: ; EOR		0xB5A8-0xB5AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
xor   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB5B0: ; EOR		0xB5B0-0xB5B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB5B8: ; EOR		0xB5B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
xor   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB5B9: ; EOR		0xB5B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
xor   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB600: ; CMP		0xB600-0xB607
and  edi, byte 7
mov  dl, [d+edi*4]
cmp   [d+(3*4)], dl
lahf
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB610: ; CMP		0xB610-0xB617
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
cmp   [d+(3*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB618: ; CMP		0xB618-0xB61F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
cmp   [d+(3*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB620: ; CMP		0xB620-0xB627
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
cmp   [d+(3*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB628: ; CMP		0xB628-0xB62F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
cmp   [d+(3*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB630: ; CMP		0xB630-0xB637
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
cmp   [d+(3*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB638: ; CMP		0xB638
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
cmp   [d+(3*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB639: ; CMP		0xB639
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
cmp   [d+(3*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB63A: ; CMP		0xB63A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
cmp   [d+(3*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB63B: ; CMP		0xB63B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
cmp   [d+(3*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB63C: ; CMP		0xB63C
mov  dl, [esi]
add  esi, byte 2
cmp   [d+(3*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB640: ; CMP		0xB640-0xB647
and  edi, byte 7
mov  edx, [d+edi*4]
cmp   [d+(3*4)], dx
lahf
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB648: ; CMP		0xB648-0xB64F
and  edi, byte 7
mov  edx, [a+edi*4]
cmp   [d+(3*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB650: ; CMP		0xB650-0xB657
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
cmp   [d+(3*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB658: ; CMP		0xB658-0xB65F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
cmp   [d+(3*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB660: ; CMP		0xB660-0xB667
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
cmp   [d+(3*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB668: ; CMP		0xB668-0xB66F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
cmp   [d+(3*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB670: ; CMP		0xB670-0xB677
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
cmp   [d+(3*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB678: ; CMP		0xB678
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
cmp   [d+(3*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB679: ; CMP		0xB679
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
cmp   [d+(3*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB67A: ; CMP		0xB67A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
cmp   [d+(3*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB67B: ; CMP		0xB67B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
cmp   [d+(3*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB67C: ; CMP		0xB67C
mov  edx, [esi]
add  esi, byte 2
cmp   [d+(3*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB680: ; CMP		0xB680-0xB687
and  edi, byte 7
mov  edx, [d+edi*4]
cmp   [d+(3*4)], edx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB688: ; CMP		0xB688-0xB68F
and  edi, byte 7
mov  edx, [a+edi*4]
cmp   [d+(3*4)], edx
lahf
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB690: ; CMP		0xB690-0xB697
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
cmp   [d+(3*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB698: ; CMP		0xB698-0xB69F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
cmp   [d+(3*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB6A0: ; CMP		0xB6A0-0xB6A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
cmp   [d+(3*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB6A8: ; CMP		0xB6A8-0xB6AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
cmp   [d+(3*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB6B0: ; CMP		0xB6B0-0xB6B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
cmp   [d+(3*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB6B8: ; CMP		0xB6B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
cmp   [d+(3*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB6B9: ; CMP		0xB6B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
cmp   [d+(3*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB6BA: ; CMP		0xB6BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
cmp   [d+(3*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB6BB: ; CMP		0xB6BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
cmp   [d+(3*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB6BC: ; CMP		0xB6BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
cmp   [d+(3*4)], edx
lahf
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB700: ; EOR		0xB700-0xB707
and  edi, byte 7
mov  edx, [d+(3*4)]
xor   byte [d+(edi*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB710: ; EOR		0xB710-0xB717
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB718: ; EOR		0xB718-0xB71F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
xor   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB720: ; EOR		0xB720-0xB727
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB728: ; EOR		0xB728-0xB72F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
xor   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB730: ; EOR		0xB730-0xB737
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB738: ; EOR		0xB738
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
xor   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB739: ; EOR		0xB739
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
xor   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB740: ; EOR		0xB740-0xB747
and  edi, byte 7
mov  edx, [d+(3*4)]
xor   word [d+(edi*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB750: ; EOR		0xB750-0xB757
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB758: ; EOR		0xB758-0xB75F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
xor   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB760: ; EOR		0xB760-0xB767
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB768: ; EOR		0xB768-0xB76F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
xor   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB770: ; EOR		0xB770-0xB777
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB778: ; EOR		0xB778
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
xor   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB779: ; EOR		0xB779
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
xor   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB780: ; EOR		0xB780-0xB787
and  edi, byte 7
mov  edx, [d+(3*4)]
xor   dword [d+(edi*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB790: ; EOR		0xB790-0xB797
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB798: ; EOR		0xB798-0xB79F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
xor   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB7A0: ; EOR		0xB7A0-0xB7A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB7A8: ; EOR		0xB7A8-0xB7AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
xor   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB7B0: ; EOR		0xB7B0-0xB7B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB7B8: ; EOR		0xB7B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
xor   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB7B9: ; EOR		0xB7B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
xor   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB800: ; CMP		0xB800-0xB807
and  edi, byte 7
mov  dl, [d+edi*4]
cmp   [d+(4*4)], dl
lahf
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB810: ; CMP		0xB810-0xB817
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
cmp   [d+(4*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB818: ; CMP		0xB818-0xB81F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
cmp   [d+(4*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB820: ; CMP		0xB820-0xB827
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
cmp   [d+(4*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB828: ; CMP		0xB828-0xB82F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
cmp   [d+(4*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB830: ; CMP		0xB830-0xB837
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
cmp   [d+(4*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB838: ; CMP		0xB838
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
cmp   [d+(4*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB839: ; CMP		0xB839
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
cmp   [d+(4*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB83A: ; CMP		0xB83A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
cmp   [d+(4*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB83B: ; CMP		0xB83B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
cmp   [d+(4*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB83C: ; CMP		0xB83C
mov  dl, [esi]
add  esi, byte 2
cmp   [d+(4*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB840: ; CMP		0xB840-0xB847
and  edi, byte 7
mov  edx, [d+edi*4]
cmp   [d+(4*4)], dx
lahf
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB848: ; CMP		0xB848-0xB84F
and  edi, byte 7
mov  edx, [a+edi*4]
cmp   [d+(4*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB850: ; CMP		0xB850-0xB857
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
cmp   [d+(4*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB858: ; CMP		0xB858-0xB85F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
cmp   [d+(4*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB860: ; CMP		0xB860-0xB867
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
cmp   [d+(4*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB868: ; CMP		0xB868-0xB86F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
cmp   [d+(4*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB870: ; CMP		0xB870-0xB877
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
cmp   [d+(4*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB878: ; CMP		0xB878
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
cmp   [d+(4*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB879: ; CMP		0xB879
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
cmp   [d+(4*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB87A: ; CMP		0xB87A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
cmp   [d+(4*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB87B: ; CMP		0xB87B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
cmp   [d+(4*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB87C: ; CMP		0xB87C
mov  edx, [esi]
add  esi, byte 2
cmp   [d+(4*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB880: ; CMP		0xB880-0xB887
and  edi, byte 7
mov  edx, [d+edi*4]
cmp   [d+(4*4)], edx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB888: ; CMP		0xB888-0xB88F
and  edi, byte 7
mov  edx, [a+edi*4]
cmp   [d+(4*4)], edx
lahf
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB890: ; CMP		0xB890-0xB897
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
cmp   [d+(4*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB898: ; CMP		0xB898-0xB89F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
cmp   [d+(4*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB8A0: ; CMP		0xB8A0-0xB8A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
cmp   [d+(4*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB8A8: ; CMP		0xB8A8-0xB8AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
cmp   [d+(4*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB8B0: ; CMP		0xB8B0-0xB8B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
cmp   [d+(4*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB8B8: ; CMP		0xB8B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
cmp   [d+(4*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB8B9: ; CMP		0xB8B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
cmp   [d+(4*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB8BA: ; CMP		0xB8BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
cmp   [d+(4*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB8BB: ; CMP		0xB8BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
cmp   [d+(4*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB8BC: ; CMP		0xB8BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
cmp   [d+(4*4)], edx
lahf
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB900: ; EOR		0xB900-0xB907
and  edi, byte 7
mov  edx, [d+(4*4)]
xor   byte [d+(edi*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB910: ; EOR		0xB910-0xB917
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB918: ; EOR		0xB918-0xB91F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
xor   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB920: ; EOR		0xB920-0xB927
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB928: ; EOR		0xB928-0xB92F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
xor   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB930: ; EOR		0xB930-0xB937
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB938: ; EOR		0xB938
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
xor   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB939: ; EOR		0xB939
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
xor   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB940: ; EOR		0xB940-0xB947
and  edi, byte 7
mov  edx, [d+(4*4)]
xor   word [d+(edi*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB950: ; EOR		0xB950-0xB957
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB958: ; EOR		0xB958-0xB95F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
xor   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB960: ; EOR		0xB960-0xB967
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB968: ; EOR		0xB968-0xB96F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
xor   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB970: ; EOR		0xB970-0xB977
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB978: ; EOR		0xB978
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
xor   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB979: ; EOR		0xB979
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
xor   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB980: ; EOR		0xB980-0xB987
and  edi, byte 7
mov  edx, [d+(4*4)]
xor   dword [d+(edi*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB990: ; EOR		0xB990-0xB997
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB998: ; EOR		0xB998-0xB99F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
xor   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB9A0: ; EOR		0xB9A0-0xB9A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB9A8: ; EOR		0xB9A8-0xB9AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
xor   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB9B0: ; EOR		0xB9B0-0xB9B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB9B8: ; EOR		0xB9B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
xor   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IB9B9: ; EOR		0xB9B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
xor   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA00: ; CMP		0xBA00-0xBA07
and  edi, byte 7
mov  dl, [d+edi*4]
cmp   [d+(5*4)], dl
lahf
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA10: ; CMP		0xBA10-0xBA17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
cmp   [d+(5*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA18: ; CMP		0xBA18-0xBA1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
cmp   [d+(5*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA20: ; CMP		0xBA20-0xBA27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
cmp   [d+(5*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA28: ; CMP		0xBA28-0xBA2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
cmp   [d+(5*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA30: ; CMP		0xBA30-0xBA37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
cmp   [d+(5*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA38: ; CMP		0xBA38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
cmp   [d+(5*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA39: ; CMP		0xBA39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
cmp   [d+(5*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA3A: ; CMP		0xBA3A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
cmp   [d+(5*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA3B: ; CMP		0xBA3B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
cmp   [d+(5*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA3C: ; CMP		0xBA3C
mov  dl, [esi]
add  esi, byte 2
cmp   [d+(5*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA40: ; CMP		0xBA40-0xBA47
and  edi, byte 7
mov  edx, [d+edi*4]
cmp   [d+(5*4)], dx
lahf
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA48: ; CMP		0xBA48-0xBA4F
and  edi, byte 7
mov  edx, [a+edi*4]
cmp   [d+(5*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA50: ; CMP		0xBA50-0xBA57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
cmp   [d+(5*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA58: ; CMP		0xBA58-0xBA5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
cmp   [d+(5*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA60: ; CMP		0xBA60-0xBA67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
cmp   [d+(5*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA68: ; CMP		0xBA68-0xBA6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
cmp   [d+(5*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA70: ; CMP		0xBA70-0xBA77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
cmp   [d+(5*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA78: ; CMP		0xBA78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
cmp   [d+(5*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA79: ; CMP		0xBA79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
cmp   [d+(5*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA7A: ; CMP		0xBA7A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
cmp   [d+(5*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA7B: ; CMP		0xBA7B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
cmp   [d+(5*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA7C: ; CMP		0xBA7C
mov  edx, [esi]
add  esi, byte 2
cmp   [d+(5*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA80: ; CMP		0xBA80-0xBA87
and  edi, byte 7
mov  edx, [d+edi*4]
cmp   [d+(5*4)], edx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA88: ; CMP		0xBA88-0xBA8F
and  edi, byte 7
mov  edx, [a+edi*4]
cmp   [d+(5*4)], edx
lahf
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA90: ; CMP		0xBA90-0xBA97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
cmp   [d+(5*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBA98: ; CMP		0xBA98-0xBA9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
cmp   [d+(5*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBAA0: ; CMP		0xBAA0-0xBAA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
cmp   [d+(5*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBAA8: ; CMP		0xBAA8-0xBAAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
cmp   [d+(5*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBAB0: ; CMP		0xBAB0-0xBAB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
cmp   [d+(5*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBAB8: ; CMP		0xBAB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
cmp   [d+(5*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBAB9: ; CMP		0xBAB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
cmp   [d+(5*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBABA: ; CMP		0xBABA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
cmp   [d+(5*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBABB: ; CMP		0xBABB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
cmp   [d+(5*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBABC: ; CMP		0xBABC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
cmp   [d+(5*4)], edx
lahf
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB00: ; EOR		0xBB00-0xBB07
and  edi, byte 7
mov  edx, [d+(5*4)]
xor   byte [d+(edi*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB10: ; EOR		0xBB10-0xBB17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB18: ; EOR		0xBB18-0xBB1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
xor   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB20: ; EOR		0xBB20-0xBB27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB28: ; EOR		0xBB28-0xBB2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
xor   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB30: ; EOR		0xBB30-0xBB37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB38: ; EOR		0xBB38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
xor   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB39: ; EOR		0xBB39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
xor   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB40: ; EOR		0xBB40-0xBB47
and  edi, byte 7
mov  edx, [d+(5*4)]
xor   word [d+(edi*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB50: ; EOR		0xBB50-0xBB57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB58: ; EOR		0xBB58-0xBB5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
xor   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB60: ; EOR		0xBB60-0xBB67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB68: ; EOR		0xBB68-0xBB6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
xor   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB70: ; EOR		0xBB70-0xBB77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB78: ; EOR		0xBB78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
xor   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB79: ; EOR		0xBB79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
xor   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB80: ; EOR		0xBB80-0xBB87
and  edi, byte 7
mov  edx, [d+(5*4)]
xor   dword [d+(edi*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB90: ; EOR		0xBB90-0xBB97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBB98: ; EOR		0xBB98-0xBB9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
xor   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBBA0: ; EOR		0xBBA0-0xBBA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBBA8: ; EOR		0xBBA8-0xBBAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
xor   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBBB0: ; EOR		0xBBB0-0xBBB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBBB8: ; EOR		0xBBB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
xor   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBBB9: ; EOR		0xBBB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
xor   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC00: ; CMP		0xBC00-0xBC07
and  edi, byte 7
mov  dl, [d+edi*4]
cmp   [d+(6*4)], dl
lahf
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC10: ; CMP		0xBC10-0xBC17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
cmp   [d+(6*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC18: ; CMP		0xBC18-0xBC1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
cmp   [d+(6*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC20: ; CMP		0xBC20-0xBC27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
cmp   [d+(6*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC28: ; CMP		0xBC28-0xBC2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
cmp   [d+(6*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC30: ; CMP		0xBC30-0xBC37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
cmp   [d+(6*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC38: ; CMP		0xBC38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
cmp   [d+(6*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC39: ; CMP		0xBC39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
cmp   [d+(6*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC3A: ; CMP		0xBC3A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
cmp   [d+(6*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC3B: ; CMP		0xBC3B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
cmp   [d+(6*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC3C: ; CMP		0xBC3C
mov  dl, [esi]
add  esi, byte 2
cmp   [d+(6*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC40: ; CMP		0xBC40-0xBC47
and  edi, byte 7
mov  edx, [d+edi*4]
cmp   [d+(6*4)], dx
lahf
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC48: ; CMP		0xBC48-0xBC4F
and  edi, byte 7
mov  edx, [a+edi*4]
cmp   [d+(6*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC50: ; CMP		0xBC50-0xBC57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
cmp   [d+(6*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC58: ; CMP		0xBC58-0xBC5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
cmp   [d+(6*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC60: ; CMP		0xBC60-0xBC67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
cmp   [d+(6*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC68: ; CMP		0xBC68-0xBC6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
cmp   [d+(6*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC70: ; CMP		0xBC70-0xBC77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
cmp   [d+(6*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC78: ; CMP		0xBC78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
cmp   [d+(6*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC79: ; CMP		0xBC79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
cmp   [d+(6*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC7A: ; CMP		0xBC7A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
cmp   [d+(6*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC7B: ; CMP		0xBC7B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
cmp   [d+(6*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC7C: ; CMP		0xBC7C
mov  edx, [esi]
add  esi, byte 2
cmp   [d+(6*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC80: ; CMP		0xBC80-0xBC87
and  edi, byte 7
mov  edx, [d+edi*4]
cmp   [d+(6*4)], edx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC88: ; CMP		0xBC88-0xBC8F
and  edi, byte 7
mov  edx, [a+edi*4]
cmp   [d+(6*4)], edx
lahf
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC90: ; CMP		0xBC90-0xBC97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
cmp   [d+(6*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBC98: ; CMP		0xBC98-0xBC9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
cmp   [d+(6*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBCA0: ; CMP		0xBCA0-0xBCA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
cmp   [d+(6*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBCA8: ; CMP		0xBCA8-0xBCAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
cmp   [d+(6*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBCB0: ; CMP		0xBCB0-0xBCB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
cmp   [d+(6*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBCB8: ; CMP		0xBCB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
cmp   [d+(6*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBCB9: ; CMP		0xBCB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
cmp   [d+(6*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBCBA: ; CMP		0xBCBA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
cmp   [d+(6*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBCBB: ; CMP		0xBCBB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
cmp   [d+(6*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBCBC: ; CMP		0xBCBC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
cmp   [d+(6*4)], edx
lahf
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD00: ; EOR		0xBD00-0xBD07
and  edi, byte 7
mov  edx, [d+(6*4)]
xor   byte [d+(edi*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD10: ; EOR		0xBD10-0xBD17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD18: ; EOR		0xBD18-0xBD1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
xor   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD20: ; EOR		0xBD20-0xBD27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD28: ; EOR		0xBD28-0xBD2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
xor   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD30: ; EOR		0xBD30-0xBD37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD38: ; EOR		0xBD38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
xor   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD39: ; EOR		0xBD39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
xor   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD40: ; EOR		0xBD40-0xBD47
and  edi, byte 7
mov  edx, [d+(6*4)]
xor   word [d+(edi*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD50: ; EOR		0xBD50-0xBD57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD58: ; EOR		0xBD58-0xBD5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
xor   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD60: ; EOR		0xBD60-0xBD67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD68: ; EOR		0xBD68-0xBD6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
xor   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD70: ; EOR		0xBD70-0xBD77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD78: ; EOR		0xBD78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
xor   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD79: ; EOR		0xBD79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
xor   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD80: ; EOR		0xBD80-0xBD87
and  edi, byte 7
mov  edx, [d+(6*4)]
xor   dword [d+(edi*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD90: ; EOR		0xBD90-0xBD97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBD98: ; EOR		0xBD98-0xBD9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
xor   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBDA0: ; EOR		0xBDA0-0xBDA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBDA8: ; EOR		0xBDA8-0xBDAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
xor   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBDB0: ; EOR		0xBDB0-0xBDB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBDB8: ; EOR		0xBDB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
xor   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBDB9: ; EOR		0xBDB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
xor   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE00: ; CMP		0xBE00-0xBE07
and  edi, byte 7
mov  dl, [d+edi*4]
cmp   [d+(7*4)], dl
lahf
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE10: ; CMP		0xBE10-0xBE17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
cmp   [d+(7*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE18: ; CMP		0xBE18-0xBE1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
cmp   [d+(7*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE20: ; CMP		0xBE20-0xBE27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
cmp   [d+(7*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE28: ; CMP		0xBE28-0xBE2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
cmp   [d+(7*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE30: ; CMP		0xBE30-0xBE37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
cmp   [d+(7*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE38: ; CMP		0xBE38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
cmp   [d+(7*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE39: ; CMP		0xBE39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
cmp   [d+(7*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE3A: ; CMP		0xBE3A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
cmp   [d+(7*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE3B: ; CMP		0xBE3B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
cmp   [d+(7*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE3C: ; CMP		0xBE3C
mov  dl, [esi]
add  esi, byte 2
cmp   [d+(7*4)], dl
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE40: ; CMP		0xBE40-0xBE47
and  edi, byte 7
mov  edx, [d+edi*4]
cmp   [d+(7*4)], dx
lahf
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE48: ; CMP		0xBE48-0xBE4F
and  edi, byte 7
mov  edx, [a+edi*4]
cmp   [d+(7*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE50: ; CMP		0xBE50-0xBE57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
cmp   [d+(7*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE58: ; CMP		0xBE58-0xBE5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
cmp   [d+(7*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE60: ; CMP		0xBE60-0xBE67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
cmp   [d+(7*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE68: ; CMP		0xBE68-0xBE6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
cmp   [d+(7*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE70: ; CMP		0xBE70-0xBE77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
cmp   [d+(7*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE78: ; CMP		0xBE78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
cmp   [d+(7*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE79: ; CMP		0xBE79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
cmp   [d+(7*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE7A: ; CMP		0xBE7A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
cmp   [d+(7*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE7B: ; CMP		0xBE7B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
cmp   [d+(7*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE7C: ; CMP		0xBE7C
mov  edx, [esi]
add  esi, byte 2
cmp   [d+(7*4)], dx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE80: ; CMP		0xBE80-0xBE87
and  edi, byte 7
mov  edx, [d+edi*4]
cmp   [d+(7*4)], edx
lahf
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE88: ; CMP		0xBE88-0xBE8F
and  edi, byte 7
mov  edx, [a+edi*4]
cmp   [d+(7*4)], edx
lahf
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE90: ; CMP		0xBE90-0xBE97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
cmp   [d+(7*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBE98: ; CMP		0xBE98-0xBE9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
cmp   [d+(7*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBEA0: ; CMP		0xBEA0-0xBEA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
cmp   [d+(7*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBEA8: ; CMP		0xBEA8-0xBEAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
cmp   [d+(7*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBEB0: ; CMP		0xBEB0-0xBEB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
cmp   [d+(7*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBEB8: ; CMP		0xBEB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
cmp   [d+(7*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBEB9: ; CMP		0xBEB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
cmp   [d+(7*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBEBA: ; CMP		0xBEBA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
cmp   [d+(7*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBEBB: ; CMP		0xBEBB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
cmp   [d+(7*4)], edx
lahf
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBEBC: ; CMP		0xBEBC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
cmp   [d+(7*4)], edx
lahf
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF00: ; EOR		0xBF00-0xBF07
and  edi, byte 7
mov  edx, [d+(7*4)]
xor   byte [d+(edi*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF10: ; EOR		0xBF10-0xBF17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF18: ; EOR		0xBF18-0xBF1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
xor   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF20: ; EOR		0xBF20-0xBF27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF28: ; EOR		0xBF28-0xBF2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
xor   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF30: ; EOR		0xBF30-0xBF37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
xor   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF38: ; EOR		0xBF38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
xor   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF39: ; EOR		0xBF39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
xor   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF40: ; EOR		0xBF40-0xBF47
and  edi, byte 7
mov  edx, [d+(7*4)]
xor   word [d+(edi*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF50: ; EOR		0xBF50-0xBF57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF58: ; EOR		0xBF58-0xBF5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
xor   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF60: ; EOR		0xBF60-0xBF67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF68: ; EOR		0xBF68-0xBF6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
xor   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF70: ; EOR		0xBF70-0xBF77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
xor   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF78: ; EOR		0xBF78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
xor   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF79: ; EOR		0xBF79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
xor   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF80: ; EOR		0xBF80-0xBF87
and  edi, byte 7
mov  edx, [d+(7*4)]
xor   dword [d+(edi*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF90: ; EOR		0xBF90-0xBF97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBF98: ; EOR		0xBF98-0xBF9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
xor   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBFA0: ; EOR		0xBFA0-0xBFA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBFA8: ; EOR		0xBFA8-0xBFAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
xor   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBFB0: ; EOR		0xBFB0-0xBFB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
xor   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBFB8: ; EOR		0xBFB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
xor   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IBFB9: ; EOR		0xBFB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
xor   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC000: ; AND		0xC000-0xC007
and  edi, byte 7
mov  dl, [d+edi*4]
and   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC010: ; AND		0xC010-0xC017
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
and   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC018: ; AND		0xC018-0xC01F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
and   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC020: ; AND		0xC020-0xC027
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
and   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC028: ; AND		0xC028-0xC02F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
and   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC030: ; AND		0xC030-0xC037
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
and   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC038: ; AND		0xC038
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
and   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC039: ; AND		0xC039
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
and   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC03A: ; AND		0xC03A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
and   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC03B: ; AND		0xC03B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
and   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC03C: ; AND		0xC03C
mov  dl, [esi]
add  esi, byte 2
and   [d+(0*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC040: ; AND		0xC040-0xC047
and  edi, byte 7
mov  edx, [d+edi*4]
and   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC050: ; AND		0xC050-0xC057
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
and   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC058: ; AND		0xC058-0xC05F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
and   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC060: ; AND		0xC060-0xC067
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
and   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC068: ; AND		0xC068-0xC06F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
and   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC070: ; AND		0xC070-0xC077
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
and   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC078: ; AND		0xC078
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
and   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC079: ; AND		0xC079
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
and   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC07A: ; AND		0xC07A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
and   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC07B: ; AND		0xC07B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
and   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC07C: ; AND		0xC07C
mov  edx, [esi]
add  esi, byte 2
and   [d+(0*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC080: ; AND		0xC080-0xC087
and  edi, byte 7
mov  edx, [d+edi*4]
and   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC090: ; AND		0xC090-0xC097
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
and   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC098: ; AND		0xC098-0xC09F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
and   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC0A0: ; AND		0xC0A0-0xC0A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
and   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC0A8: ; AND		0xC0A8-0xC0AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
and   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC0B0: ; AND		0xC0B0-0xC0B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
and   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC0B8: ; AND		0xC0B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
and   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC0B9: ; AND		0xC0B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
and   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC0BA: ; AND		0xC0BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
and   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC0BB: ; AND		0xC0BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
and   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC0BC: ; AND		0xC0BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
and   [d+(0*4)], edx
lahf
xor  al, al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC110: ; AND		0xC110-0xC117
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
and   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC118: ; AND		0xC118-0xC11F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
and   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC120: ; AND		0xC120-0xC127
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
and   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC128: ; AND		0xC128-0xC12F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
and   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC130: ; AND		0xC130-0xC137
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
and   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC138: ; AND		0xC138
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
and   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC139: ; AND		0xC139
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
and   dl, [d+(0*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC150: ; AND		0xC150-0xC157
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
and   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC158: ; AND		0xC158-0xC15F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
and   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC160: ; AND		0xC160-0xC167
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
and   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC168: ; AND		0xC168-0xC16F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
and   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC170: ; AND		0xC170-0xC177
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
and   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC178: ; AND		0xC178
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
and   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC179: ; AND		0xC179
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
and   dx, [d+(0*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC190: ; AND		0xC190-0xC197
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
and   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC198: ; AND		0xC198-0xC19F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
and   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC1A0: ; AND		0xC1A0-0xC1A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
and   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC1A8: ; AND		0xC1A8-0xC1AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
and   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC1B0: ; AND		0xC1B0-0xC1B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
and   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC1B8: ; AND		0xC1B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
and   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC1B9: ; AND		0xC1B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
and   edx, [d+(0*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC200: ; AND		0xC200-0xC207
and  edi, byte 7
mov  dl, [d+edi*4]
and   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC210: ; AND		0xC210-0xC217
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
and   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC218: ; AND		0xC218-0xC21F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
and   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC220: ; AND		0xC220-0xC227
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
and   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC228: ; AND		0xC228-0xC22F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
and   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC230: ; AND		0xC230-0xC237
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
and   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC238: ; AND		0xC238
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
and   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC239: ; AND		0xC239
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
and   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC23A: ; AND		0xC23A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
and   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC23B: ; AND		0xC23B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
and   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC23C: ; AND		0xC23C
mov  dl, [esi]
add  esi, byte 2
and   [d+(1*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC240: ; AND		0xC240-0xC247
and  edi, byte 7
mov  edx, [d+edi*4]
and   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC250: ; AND		0xC250-0xC257
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
and   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC258: ; AND		0xC258-0xC25F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
and   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC260: ; AND		0xC260-0xC267
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
and   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC268: ; AND		0xC268-0xC26F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
and   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC270: ; AND		0xC270-0xC277
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
and   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC278: ; AND		0xC278
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
and   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC279: ; AND		0xC279
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
and   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC27A: ; AND		0xC27A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
and   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC27B: ; AND		0xC27B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
and   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC27C: ; AND		0xC27C
mov  edx, [esi]
add  esi, byte 2
and   [d+(1*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC280: ; AND		0xC280-0xC287
and  edi, byte 7
mov  edx, [d+edi*4]
and   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC290: ; AND		0xC290-0xC297
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
and   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC298: ; AND		0xC298-0xC29F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
and   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC2A0: ; AND		0xC2A0-0xC2A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
and   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC2A8: ; AND		0xC2A8-0xC2AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
and   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC2B0: ; AND		0xC2B0-0xC2B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
and   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC2B8: ; AND		0xC2B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
and   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC2B9: ; AND		0xC2B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
and   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC2BA: ; AND		0xC2BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
and   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC2BB: ; AND		0xC2BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
and   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC2BC: ; AND		0xC2BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
and   [d+(1*4)], edx
lahf
xor  al, al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC310: ; AND		0xC310-0xC317
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
and   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC318: ; AND		0xC318-0xC31F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
and   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC320: ; AND		0xC320-0xC327
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
and   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC328: ; AND		0xC328-0xC32F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
and   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC330: ; AND		0xC330-0xC337
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
and   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC338: ; AND		0xC338
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
and   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC339: ; AND		0xC339
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
and   dl, [d+(1*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC350: ; AND		0xC350-0xC357
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
and   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC358: ; AND		0xC358-0xC35F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
and   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC360: ; AND		0xC360-0xC367
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
and   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC368: ; AND		0xC368-0xC36F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
and   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC370: ; AND		0xC370-0xC377
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
and   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC378: ; AND		0xC378
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
and   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC379: ; AND		0xC379
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
and   dx, [d+(1*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC390: ; AND		0xC390-0xC397
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
and   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC398: ; AND		0xC398-0xC39F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
and   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC3A0: ; AND		0xC3A0-0xC3A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
and   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC3A8: ; AND		0xC3A8-0xC3AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
and   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC3B0: ; AND		0xC3B0-0xC3B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
and   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC3B8: ; AND		0xC3B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
and   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC3B9: ; AND		0xC3B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
and   edx, [d+(1*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC400: ; AND		0xC400-0xC407
and  edi, byte 7
mov  dl, [d+edi*4]
and   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC410: ; AND		0xC410-0xC417
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
and   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC418: ; AND		0xC418-0xC41F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
and   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC420: ; AND		0xC420-0xC427
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
and   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC428: ; AND		0xC428-0xC42F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
and   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC430: ; AND		0xC430-0xC437
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
and   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC438: ; AND		0xC438
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
and   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC439: ; AND		0xC439
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
and   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC43A: ; AND		0xC43A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
and   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC43B: ; AND		0xC43B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
and   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC43C: ; AND		0xC43C
mov  dl, [esi]
add  esi, byte 2
and   [d+(2*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC440: ; AND		0xC440-0xC447
and  edi, byte 7
mov  edx, [d+edi*4]
and   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC450: ; AND		0xC450-0xC457
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
and   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC458: ; AND		0xC458-0xC45F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
and   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC460: ; AND		0xC460-0xC467
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
and   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC468: ; AND		0xC468-0xC46F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
and   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC470: ; AND		0xC470-0xC477
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
and   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC478: ; AND		0xC478
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
and   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC479: ; AND		0xC479
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
and   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC47A: ; AND		0xC47A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
and   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC47B: ; AND		0xC47B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
and   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC47C: ; AND		0xC47C
mov  edx, [esi]
add  esi, byte 2
and   [d+(2*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC480: ; AND		0xC480-0xC487
and  edi, byte 7
mov  edx, [d+edi*4]
and   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC490: ; AND		0xC490-0xC497
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
and   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC498: ; AND		0xC498-0xC49F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
and   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC4A0: ; AND		0xC4A0-0xC4A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
and   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC4A8: ; AND		0xC4A8-0xC4AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
and   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC4B0: ; AND		0xC4B0-0xC4B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
and   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC4B8: ; AND		0xC4B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
and   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC4B9: ; AND		0xC4B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
and   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC4BA: ; AND		0xC4BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
and   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC4BB: ; AND		0xC4BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
and   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC4BC: ; AND		0xC4BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
and   [d+(2*4)], edx
lahf
xor  al, al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC510: ; AND		0xC510-0xC517
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
and   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC518: ; AND		0xC518-0xC51F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
and   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC520: ; AND		0xC520-0xC527
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
and   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC528: ; AND		0xC528-0xC52F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
and   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC530: ; AND		0xC530-0xC537
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
and   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC538: ; AND		0xC538
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
and   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC539: ; AND		0xC539
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
and   dl, [d+(2*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC550: ; AND		0xC550-0xC557
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
and   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC558: ; AND		0xC558-0xC55F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
and   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC560: ; AND		0xC560-0xC567
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
and   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC568: ; AND		0xC568-0xC56F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
and   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC570: ; AND		0xC570-0xC577
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
and   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC578: ; AND		0xC578
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
and   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC579: ; AND		0xC579
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
and   dx, [d+(2*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC590: ; AND		0xC590-0xC597
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
and   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC598: ; AND		0xC598-0xC59F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
and   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC5A0: ; AND		0xC5A0-0xC5A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
and   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC5A8: ; AND		0xC5A8-0xC5AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
and   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC5B0: ; AND		0xC5B0-0xC5B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
and   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC5B8: ; AND		0xC5B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
and   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC5B9: ; AND		0xC5B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
and   edx, [d+(2*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC600: ; AND		0xC600-0xC607
and  edi, byte 7
mov  dl, [d+edi*4]
and   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC610: ; AND		0xC610-0xC617
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
and   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC618: ; AND		0xC618-0xC61F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
and   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC620: ; AND		0xC620-0xC627
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
and   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC628: ; AND		0xC628-0xC62F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
and   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC630: ; AND		0xC630-0xC637
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
and   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC638: ; AND		0xC638
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
and   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC639: ; AND		0xC639
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
and   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC63A: ; AND		0xC63A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
and   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC63B: ; AND		0xC63B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
and   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC63C: ; AND		0xC63C
mov  dl, [esi]
add  esi, byte 2
and   [d+(3*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC640: ; AND		0xC640-0xC647
and  edi, byte 7
mov  edx, [d+edi*4]
and   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC650: ; AND		0xC650-0xC657
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
and   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC658: ; AND		0xC658-0xC65F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
and   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC660: ; AND		0xC660-0xC667
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
and   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC668: ; AND		0xC668-0xC66F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
and   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC670: ; AND		0xC670-0xC677
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
and   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC678: ; AND		0xC678
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
and   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC679: ; AND		0xC679
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
and   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC67A: ; AND		0xC67A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
and   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC67B: ; AND		0xC67B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
and   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC67C: ; AND		0xC67C
mov  edx, [esi]
add  esi, byte 2
and   [d+(3*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC680: ; AND		0xC680-0xC687
and  edi, byte 7
mov  edx, [d+edi*4]
and   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC690: ; AND		0xC690-0xC697
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
and   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC698: ; AND		0xC698-0xC69F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
and   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC6A0: ; AND		0xC6A0-0xC6A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
and   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC6A8: ; AND		0xC6A8-0xC6AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
and   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC6B0: ; AND		0xC6B0-0xC6B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
and   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC6B8: ; AND		0xC6B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
and   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC6B9: ; AND		0xC6B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
and   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC6BA: ; AND		0xC6BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
and   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC6BB: ; AND		0xC6BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
and   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC6BC: ; AND		0xC6BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
and   [d+(3*4)], edx
lahf
xor  al, al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC710: ; AND		0xC710-0xC717
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
and   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC718: ; AND		0xC718-0xC71F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
and   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC720: ; AND		0xC720-0xC727
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
and   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC728: ; AND		0xC728-0xC72F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
and   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC730: ; AND		0xC730-0xC737
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
and   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC738: ; AND		0xC738
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
and   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC739: ; AND		0xC739
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
and   dl, [d+(3*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC750: ; AND		0xC750-0xC757
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
and   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC758: ; AND		0xC758-0xC75F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
and   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC760: ; AND		0xC760-0xC767
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
and   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC768: ; AND		0xC768-0xC76F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
and   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC770: ; AND		0xC770-0xC777
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
and   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC778: ; AND		0xC778
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
and   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC779: ; AND		0xC779
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
and   dx, [d+(3*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC790: ; AND		0xC790-0xC797
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
and   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC798: ; AND		0xC798-0xC79F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
and   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC7A0: ; AND		0xC7A0-0xC7A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
and   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC7A8: ; AND		0xC7A8-0xC7AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
and   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC7B0: ; AND		0xC7B0-0xC7B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
and   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC7B8: ; AND		0xC7B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
and   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC7B9: ; AND		0xC7B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
and   edx, [d+(3*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC800: ; AND		0xC800-0xC807
and  edi, byte 7
mov  dl, [d+edi*4]
and   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC810: ; AND		0xC810-0xC817
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
and   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC818: ; AND		0xC818-0xC81F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
and   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC820: ; AND		0xC820-0xC827
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
and   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC828: ; AND		0xC828-0xC82F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
and   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC830: ; AND		0xC830-0xC837
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
and   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC838: ; AND		0xC838
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
and   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC839: ; AND		0xC839
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
and   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC83A: ; AND		0xC83A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
and   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC83B: ; AND		0xC83B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
and   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC83C: ; AND		0xC83C
mov  dl, [esi]
add  esi, byte 2
and   [d+(4*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC840: ; AND		0xC840-0xC847
and  edi, byte 7
mov  edx, [d+edi*4]
and   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC850: ; AND		0xC850-0xC857
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
and   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC858: ; AND		0xC858-0xC85F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
and   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC860: ; AND		0xC860-0xC867
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
and   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC868: ; AND		0xC868-0xC86F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
and   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC870: ; AND		0xC870-0xC877
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
and   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC878: ; AND		0xC878
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
and   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC879: ; AND		0xC879
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
and   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC87A: ; AND		0xC87A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
and   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC87B: ; AND		0xC87B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
and   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC87C: ; AND		0xC87C
mov  edx, [esi]
add  esi, byte 2
and   [d+(4*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC880: ; AND		0xC880-0xC887
and  edi, byte 7
mov  edx, [d+edi*4]
and   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC890: ; AND		0xC890-0xC897
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
and   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC898: ; AND		0xC898-0xC89F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
and   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC8A0: ; AND		0xC8A0-0xC8A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
and   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC8A8: ; AND		0xC8A8-0xC8AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
and   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC8B0: ; AND		0xC8B0-0xC8B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
and   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC8B8: ; AND		0xC8B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
and   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC8B9: ; AND		0xC8B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
and   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC8BA: ; AND		0xC8BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
and   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC8BB: ; AND		0xC8BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
and   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC8BC: ; AND		0xC8BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
and   [d+(4*4)], edx
lahf
xor  al, al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC910: ; AND		0xC910-0xC917
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
and   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC918: ; AND		0xC918-0xC91F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
and   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC920: ; AND		0xC920-0xC927
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
and   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC928: ; AND		0xC928-0xC92F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
and   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC930: ; AND		0xC930-0xC937
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
and   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC938: ; AND		0xC938
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
and   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC939: ; AND		0xC939
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
and   dl, [d+(4*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC950: ; AND		0xC950-0xC957
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
and   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC958: ; AND		0xC958-0xC95F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
and   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC960: ; AND		0xC960-0xC967
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
and   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC968: ; AND		0xC968-0xC96F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
and   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC970: ; AND		0xC970-0xC977
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
and   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC978: ; AND		0xC978
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
and   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC979: ; AND		0xC979
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
and   dx, [d+(4*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC990: ; AND		0xC990-0xC997
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
and   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC998: ; AND		0xC998-0xC99F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
and   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC9A0: ; AND		0xC9A0-0xC9A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
and   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC9A8: ; AND		0xC9A8-0xC9AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
and   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC9B0: ; AND		0xC9B0-0xC9B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
and   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC9B8: ; AND		0xC9B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
and   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IC9B9: ; AND		0xC9B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
and   edx, [d+(4*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA00: ; AND		0xCA00-0xCA07
and  edi, byte 7
mov  dl, [d+edi*4]
and   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA10: ; AND		0xCA10-0xCA17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
and   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA18: ; AND		0xCA18-0xCA1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
and   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA20: ; AND		0xCA20-0xCA27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
and   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA28: ; AND		0xCA28-0xCA2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
and   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA30: ; AND		0xCA30-0xCA37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
and   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA38: ; AND		0xCA38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
and   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA39: ; AND		0xCA39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
and   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA3A: ; AND		0xCA3A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
and   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA3B: ; AND		0xCA3B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
and   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA3C: ; AND		0xCA3C
mov  dl, [esi]
add  esi, byte 2
and   [d+(5*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA40: ; AND		0xCA40-0xCA47
and  edi, byte 7
mov  edx, [d+edi*4]
and   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA50: ; AND		0xCA50-0xCA57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
and   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA58: ; AND		0xCA58-0xCA5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
and   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA60: ; AND		0xCA60-0xCA67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
and   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA68: ; AND		0xCA68-0xCA6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
and   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA70: ; AND		0xCA70-0xCA77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
and   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA78: ; AND		0xCA78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
and   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA79: ; AND		0xCA79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
and   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA7A: ; AND		0xCA7A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
and   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA7B: ; AND		0xCA7B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
and   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA7C: ; AND		0xCA7C
mov  edx, [esi]
add  esi, byte 2
and   [d+(5*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA80: ; AND		0xCA80-0xCA87
and  edi, byte 7
mov  edx, [d+edi*4]
and   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA90: ; AND		0xCA90-0xCA97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
and   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICA98: ; AND		0xCA98-0xCA9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
and   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICAA0: ; AND		0xCAA0-0xCAA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
and   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICAA8: ; AND		0xCAA8-0xCAAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
and   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICAB0: ; AND		0xCAB0-0xCAB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
and   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICAB8: ; AND		0xCAB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
and   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICAB9: ; AND		0xCAB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
and   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICABA: ; AND		0xCABA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
and   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICABB: ; AND		0xCABB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
and   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICABC: ; AND		0xCABC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
and   [d+(5*4)], edx
lahf
xor  al, al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICB10: ; AND		0xCB10-0xCB17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
and   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICB18: ; AND		0xCB18-0xCB1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
and   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICB20: ; AND		0xCB20-0xCB27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
and   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICB28: ; AND		0xCB28-0xCB2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
and   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICB30: ; AND		0xCB30-0xCB37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
and   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICB38: ; AND		0xCB38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
and   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICB39: ; AND		0xCB39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
and   dl, [d+(5*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICB50: ; AND		0xCB50-0xCB57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
and   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICB58: ; AND		0xCB58-0xCB5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
and   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICB60: ; AND		0xCB60-0xCB67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
and   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICB68: ; AND		0xCB68-0xCB6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
and   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICB70: ; AND		0xCB70-0xCB77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
and   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICB78: ; AND		0xCB78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
and   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICB79: ; AND		0xCB79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
and   dx, [d+(5*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICB90: ; AND		0xCB90-0xCB97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
and   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICB98: ; AND		0xCB98-0xCB9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
and   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICBA0: ; AND		0xCBA0-0xCBA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
and   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICBA8: ; AND		0xCBA8-0xCBAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
and   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICBB0: ; AND		0xCBB0-0xCBB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
and   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICBB8: ; AND		0xCBB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
and   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICBB9: ; AND		0xCBB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
and   edx, [d+(5*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC00: ; AND		0xCC00-0xCC07
and  edi, byte 7
mov  dl, [d+edi*4]
and   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC10: ; AND		0xCC10-0xCC17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
and   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC18: ; AND		0xCC18-0xCC1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
and   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC20: ; AND		0xCC20-0xCC27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
and   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC28: ; AND		0xCC28-0xCC2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
and   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC30: ; AND		0xCC30-0xCC37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
and   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC38: ; AND		0xCC38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
and   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC39: ; AND		0xCC39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
and   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC3A: ; AND		0xCC3A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
and   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC3B: ; AND		0xCC3B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
and   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC3C: ; AND		0xCC3C
mov  dl, [esi]
add  esi, byte 2
and   [d+(6*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC40: ; AND		0xCC40-0xCC47
and  edi, byte 7
mov  edx, [d+edi*4]
and   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC50: ; AND		0xCC50-0xCC57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
and   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC58: ; AND		0xCC58-0xCC5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
and   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC60: ; AND		0xCC60-0xCC67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
and   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC68: ; AND		0xCC68-0xCC6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
and   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC70: ; AND		0xCC70-0xCC77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
and   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC78: ; AND		0xCC78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
and   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC79: ; AND		0xCC79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
and   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC7A: ; AND		0xCC7A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
and   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC7B: ; AND		0xCC7B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
and   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC7C: ; AND		0xCC7C
mov  edx, [esi]
add  esi, byte 2
and   [d+(6*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC80: ; AND		0xCC80-0xCC87
and  edi, byte 7
mov  edx, [d+edi*4]
and   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC90: ; AND		0xCC90-0xCC97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
and   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICC98: ; AND		0xCC98-0xCC9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
and   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICCA0: ; AND		0xCCA0-0xCCA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
and   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICCA8: ; AND		0xCCA8-0xCCAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
and   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICCB0: ; AND		0xCCB0-0xCCB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
and   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICCB8: ; AND		0xCCB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
and   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICCB9: ; AND		0xCCB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
and   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICCBA: ; AND		0xCCBA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
and   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICCBB: ; AND		0xCCBB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
and   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICCBC: ; AND		0xCCBC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
and   [d+(6*4)], edx
lahf
xor  al, al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICD10: ; AND		0xCD10-0xCD17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
and   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICD18: ; AND		0xCD18-0xCD1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
and   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICD20: ; AND		0xCD20-0xCD27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
and   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICD28: ; AND		0xCD28-0xCD2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
and   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICD30: ; AND		0xCD30-0xCD37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
and   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICD38: ; AND		0xCD38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
and   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICD39: ; AND		0xCD39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
and   dl, [d+(6*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICD50: ; AND		0xCD50-0xCD57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
and   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICD58: ; AND		0xCD58-0xCD5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
and   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICD60: ; AND		0xCD60-0xCD67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
and   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICD68: ; AND		0xCD68-0xCD6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
and   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICD70: ; AND		0xCD70-0xCD77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
and   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICD78: ; AND		0xCD78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
and   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICD79: ; AND		0xCD79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
and   dx, [d+(6*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICD90: ; AND		0xCD90-0xCD97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
and   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICD98: ; AND		0xCD98-0xCD9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
and   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICDA0: ; AND		0xCDA0-0xCDA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
and   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICDA8: ; AND		0xCDA8-0xCDAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
and   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICDB0: ; AND		0xCDB0-0xCDB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
and   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICDB8: ; AND		0xCDB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
and   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICDB9: ; AND		0xCDB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
and   edx, [d+(6*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE00: ; AND		0xCE00-0xCE07
and  edi, byte 7
mov  dl, [d+edi*4]
and   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE10: ; AND		0xCE10-0xCE17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
and   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE18: ; AND		0xCE18-0xCE1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
and   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE20: ; AND		0xCE20-0xCE27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
and   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE28: ; AND		0xCE28-0xCE2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
and   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE30: ; AND		0xCE30-0xCE37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
and   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE38: ; AND		0xCE38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
and   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE39: ; AND		0xCE39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
and   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE3A: ; AND		0xCE3A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
and   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE3B: ; AND		0xCE3B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
and   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE3C: ; AND		0xCE3C
mov  dl, [esi]
add  esi, byte 2
and   [d+(7*4)], dl
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE40: ; AND		0xCE40-0xCE47
and  edi, byte 7
mov  edx, [d+edi*4]
and   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE50: ; AND		0xCE50-0xCE57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
and   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE58: ; AND		0xCE58-0xCE5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
and   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE60: ; AND		0xCE60-0xCE67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
and   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE68: ; AND		0xCE68-0xCE6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
and   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE70: ; AND		0xCE70-0xCE77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
and   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE78: ; AND		0xCE78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
and   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE79: ; AND		0xCE79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
and   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE7A: ; AND		0xCE7A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
and   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE7B: ; AND		0xCE7B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
and   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE7C: ; AND		0xCE7C
mov  edx, [esi]
add  esi, byte 2
and   [d+(7*4)], dx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE80: ; AND		0xCE80-0xCE87
and  edi, byte 7
mov  edx, [d+edi*4]
and   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE90: ; AND		0xCE90-0xCE97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
and   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICE98: ; AND		0xCE98-0xCE9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
and   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICEA0: ; AND		0xCEA0-0xCEA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
and   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICEA8: ; AND		0xCEA8-0xCEAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
and   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICEB0: ; AND		0xCEB0-0xCEB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
and   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICEB8: ; AND		0xCEB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
and   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICEB9: ; AND		0xCEB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
and   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICEBA: ; AND		0xCEBA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
and   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICEBB: ; AND		0xCEBB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
and   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICEBC: ; AND		0xCEBC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
and   [d+(7*4)], edx
lahf
xor  al, al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICF10: ; AND		0xCF10-0xCF17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
and   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICF18: ; AND		0xCF18-0xCF1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
and   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICF20: ; AND		0xCF20-0xCF27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
and   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICF28: ; AND		0xCF28-0xCF2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
and   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICF30: ; AND		0xCF30-0xCF37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
and   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICF38: ; AND		0xCF38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
and   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICF39: ; AND		0xCF39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
and   dl, [d+(7*4)]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICF50: ; AND		0xCF50-0xCF57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
and   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICF58: ; AND		0xCF58-0xCF5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
and   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICF60: ; AND		0xCF60-0xCF67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
and   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICF68: ; AND		0xCF68-0xCF6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
and   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICF70: ; AND		0xCF70-0xCF77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
and   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICF78: ; AND		0xCF78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
and   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICF79: ; AND		0xCF79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
and   dx, [d+(7*4)]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICF90: ; AND		0xCF90-0xCF97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
and   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICF98: ; AND		0xCF98-0xCF9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
and   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICFA0: ; AND		0xCFA0-0xCFA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
and   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICFA8: ; AND		0xCFA8-0xCFAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
and   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICFB0: ; AND		0xCFB0-0xCFB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
and   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICFB8: ; AND		0xCFB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
and   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ICFB9: ; AND		0xCFB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
and   edx, [d+(7*4)]
lahf
xor  al, al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID000: ; ADD		0xD000-0xD007
and  edi, byte 7
mov  dl, [d+edi*4]
add   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID010: ; ADD		0xD010-0xD017
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID018: ; ADD		0xD018-0xD01F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID020: ; ADD		0xD020-0xD027
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID028: ; ADD		0xD028-0xD02F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID030: ; ADD		0xD030-0xD037
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID038: ; ADD		0xD038
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID039: ; ADD		0xD039
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID03A: ; ADD		0xD03A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
add   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID03B: ; ADD		0xD03B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
add   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID03C: ; ADD		0xD03C
mov  dl, [esi]
add  esi, byte 2
add   [d+(0*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID040: ; ADD		0xD040-0xD047
and  edi, byte 7
mov  edx, [d+edi*4]
add   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID048: ; ADD		0xD048-0xD04F
and  edi, byte 7
mov  edx, [a+edi*4]
add   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID050: ; ADD		0xD050-0xD057
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID058: ; ADD		0xD058-0xD05F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID060: ; ADD		0xD060-0xD067
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID068: ; ADD		0xD068-0xD06F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID070: ; ADD		0xD070-0xD077
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID078: ; ADD		0xD078
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID079: ; ADD		0xD079
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID07A: ; ADD		0xD07A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
add   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID07B: ; ADD		0xD07B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
add   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID07C: ; ADD		0xD07C
mov  edx, [esi]
add  esi, byte 2
add   [d+(0*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID080: ; ADD		0xD080-0xD087
and  edi, byte 7
mov  edx, [d+edi*4]
add   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID088: ; ADD		0xD088-0xD08F
and  edi, byte 7
mov  edx, [a+edi*4]
add   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID090: ; ADD		0xD090-0xD097
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID098: ; ADD		0xD098-0xD09F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0A0: ; ADD		0xD0A0-0xD0A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0A8: ; ADD		0xD0A8-0xD0AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0B0: ; ADD		0xD0B0-0xD0B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0B8: ; ADD		0xD0B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0B9: ; ADD		0xD0B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0BA: ; ADD		0xD0BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0BB: ; ADD		0xD0BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0BC: ; ADD		0xD0BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
add   [d+(0*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID110: ; ADD		0xD110-0xD117
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   dl, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID118: ; ADD		0xD118-0xD11F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   dl, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID120: ; ADD		0xD120-0xD127
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   dl, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID128: ; ADD		0xD128-0xD12F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   dl, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID130: ; ADD		0xD130-0xD137
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   dl, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID138: ; ADD		0xD138
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   dl, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID139: ; ADD		0xD139
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   dl, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID150: ; ADD		0xD150-0xD157
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   dx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID158: ; ADD		0xD158-0xD15F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   dx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID160: ; ADD		0xD160-0xD167
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   dx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID168: ; ADD		0xD168-0xD16F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   dx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID170: ; ADD		0xD170-0xD177
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   dx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID178: ; ADD		0xD178
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   dx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID179: ; ADD		0xD179
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   dx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID190: ; ADD		0xD190-0xD197
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   edx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID198: ; ADD		0xD198-0xD19F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   edx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID1A0: ; ADD		0xD1A0-0xD1A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   edx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID1A8: ; ADD		0xD1A8-0xD1AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   edx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID1B0: ; ADD		0xD1B0-0xD1B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   edx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID1B8: ; ADD		0xD1B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   edx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID1B9: ; ADD		0xD1B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   edx, [d+(0*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID200: ; ADD		0xD200-0xD207
and  edi, byte 7
mov  dl, [d+edi*4]
add   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID210: ; ADD		0xD210-0xD217
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID218: ; ADD		0xD218-0xD21F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID220: ; ADD		0xD220-0xD227
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID228: ; ADD		0xD228-0xD22F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID230: ; ADD		0xD230-0xD237
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID238: ; ADD		0xD238
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID239: ; ADD		0xD239
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID23A: ; ADD		0xD23A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
add   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID23B: ; ADD		0xD23B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
add   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID23C: ; ADD		0xD23C
mov  dl, [esi]
add  esi, byte 2
add   [d+(1*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID240: ; ADD		0xD240-0xD247
and  edi, byte 7
mov  edx, [d+edi*4]
add   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID248: ; ADD		0xD248-0xD24F
and  edi, byte 7
mov  edx, [a+edi*4]
add   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID250: ; ADD		0xD250-0xD257
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID258: ; ADD		0xD258-0xD25F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID260: ; ADD		0xD260-0xD267
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID268: ; ADD		0xD268-0xD26F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID270: ; ADD		0xD270-0xD277
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID278: ; ADD		0xD278
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID279: ; ADD		0xD279
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID27A: ; ADD		0xD27A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
add   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID27B: ; ADD		0xD27B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
add   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID27C: ; ADD		0xD27C
mov  edx, [esi]
add  esi, byte 2
add   [d+(1*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID280: ; ADD		0xD280-0xD287
and  edi, byte 7
mov  edx, [d+edi*4]
add   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID288: ; ADD		0xD288-0xD28F
and  edi, byte 7
mov  edx, [a+edi*4]
add   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID290: ; ADD		0xD290-0xD297
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID298: ; ADD		0xD298-0xD29F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2A0: ; ADD		0xD2A0-0xD2A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2A8: ; ADD		0xD2A8-0xD2AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2B0: ; ADD		0xD2B0-0xD2B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2B8: ; ADD		0xD2B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2B9: ; ADD		0xD2B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2BA: ; ADD		0xD2BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2BB: ; ADD		0xD2BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2BC: ; ADD		0xD2BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
add   [d+(1*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID310: ; ADD		0xD310-0xD317
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   dl, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID318: ; ADD		0xD318-0xD31F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   dl, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID320: ; ADD		0xD320-0xD327
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   dl, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID328: ; ADD		0xD328-0xD32F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   dl, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID330: ; ADD		0xD330-0xD337
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   dl, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID338: ; ADD		0xD338
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   dl, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID339: ; ADD		0xD339
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   dl, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID350: ; ADD		0xD350-0xD357
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   dx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID358: ; ADD		0xD358-0xD35F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   dx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID360: ; ADD		0xD360-0xD367
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   dx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID368: ; ADD		0xD368-0xD36F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   dx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID370: ; ADD		0xD370-0xD377
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   dx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID378: ; ADD		0xD378
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   dx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID379: ; ADD		0xD379
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   dx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID390: ; ADD		0xD390-0xD397
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   edx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID398: ; ADD		0xD398-0xD39F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   edx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID3A0: ; ADD		0xD3A0-0xD3A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   edx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID3A8: ; ADD		0xD3A8-0xD3AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   edx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID3B0: ; ADD		0xD3B0-0xD3B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   edx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID3B8: ; ADD		0xD3B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   edx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID3B9: ; ADD		0xD3B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   edx, [d+(1*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID400: ; ADD		0xD400-0xD407
and  edi, byte 7
mov  dl, [d+edi*4]
add   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID410: ; ADD		0xD410-0xD417
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID418: ; ADD		0xD418-0xD41F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID420: ; ADD		0xD420-0xD427
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID428: ; ADD		0xD428-0xD42F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID430: ; ADD		0xD430-0xD437
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID438: ; ADD		0xD438
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID439: ; ADD		0xD439
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID43A: ; ADD		0xD43A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
add   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID43B: ; ADD		0xD43B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
add   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID43C: ; ADD		0xD43C
mov  dl, [esi]
add  esi, byte 2
add   [d+(2*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID440: ; ADD		0xD440-0xD447
and  edi, byte 7
mov  edx, [d+edi*4]
add   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID448: ; ADD		0xD448-0xD44F
and  edi, byte 7
mov  edx, [a+edi*4]
add   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID450: ; ADD		0xD450-0xD457
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID458: ; ADD		0xD458-0xD45F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID460: ; ADD		0xD460-0xD467
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID468: ; ADD		0xD468-0xD46F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID470: ; ADD		0xD470-0xD477
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID478: ; ADD		0xD478
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID479: ; ADD		0xD479
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID47A: ; ADD		0xD47A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
add   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID47B: ; ADD		0xD47B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
add   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID47C: ; ADD		0xD47C
mov  edx, [esi]
add  esi, byte 2
add   [d+(2*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID480: ; ADD		0xD480-0xD487
and  edi, byte 7
mov  edx, [d+edi*4]
add   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID488: ; ADD		0xD488-0xD48F
and  edi, byte 7
mov  edx, [a+edi*4]
add   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID490: ; ADD		0xD490-0xD497
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID498: ; ADD		0xD498-0xD49F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4A0: ; ADD		0xD4A0-0xD4A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4A8: ; ADD		0xD4A8-0xD4AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4B0: ; ADD		0xD4B0-0xD4B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4B8: ; ADD		0xD4B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4B9: ; ADD		0xD4B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4BA: ; ADD		0xD4BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4BB: ; ADD		0xD4BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4BC: ; ADD		0xD4BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
add   [d+(2*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID510: ; ADD		0xD510-0xD517
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   dl, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID518: ; ADD		0xD518-0xD51F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   dl, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID520: ; ADD		0xD520-0xD527
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   dl, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID528: ; ADD		0xD528-0xD52F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   dl, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID530: ; ADD		0xD530-0xD537
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   dl, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID538: ; ADD		0xD538
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   dl, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID539: ; ADD		0xD539
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   dl, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID550: ; ADD		0xD550-0xD557
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   dx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID558: ; ADD		0xD558-0xD55F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   dx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID560: ; ADD		0xD560-0xD567
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   dx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID568: ; ADD		0xD568-0xD56F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   dx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID570: ; ADD		0xD570-0xD577
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   dx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID578: ; ADD		0xD578
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   dx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID579: ; ADD		0xD579
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   dx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID590: ; ADD		0xD590-0xD597
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   edx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID598: ; ADD		0xD598-0xD59F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   edx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID5A0: ; ADD		0xD5A0-0xD5A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   edx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID5A8: ; ADD		0xD5A8-0xD5AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   edx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID5B0: ; ADD		0xD5B0-0xD5B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   edx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID5B8: ; ADD		0xD5B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   edx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID5B9: ; ADD		0xD5B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   edx, [d+(2*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID600: ; ADD		0xD600-0xD607
and  edi, byte 7
mov  dl, [d+edi*4]
add   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID610: ; ADD		0xD610-0xD617
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID618: ; ADD		0xD618-0xD61F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID620: ; ADD		0xD620-0xD627
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID628: ; ADD		0xD628-0xD62F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID630: ; ADD		0xD630-0xD637
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID638: ; ADD		0xD638
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID639: ; ADD		0xD639
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID63A: ; ADD		0xD63A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
add   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID63B: ; ADD		0xD63B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
add   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID63C: ; ADD		0xD63C
mov  dl, [esi]
add  esi, byte 2
add   [d+(3*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID640: ; ADD		0xD640-0xD647
and  edi, byte 7
mov  edx, [d+edi*4]
add   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID648: ; ADD		0xD648-0xD64F
and  edi, byte 7
mov  edx, [a+edi*4]
add   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID650: ; ADD		0xD650-0xD657
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID658: ; ADD		0xD658-0xD65F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID660: ; ADD		0xD660-0xD667
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID668: ; ADD		0xD668-0xD66F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID670: ; ADD		0xD670-0xD677
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID678: ; ADD		0xD678
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID679: ; ADD		0xD679
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID67A: ; ADD		0xD67A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
add   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID67B: ; ADD		0xD67B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
add   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID67C: ; ADD		0xD67C
mov  edx, [esi]
add  esi, byte 2
add   [d+(3*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID680: ; ADD		0xD680-0xD687
and  edi, byte 7
mov  edx, [d+edi*4]
add   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID688: ; ADD		0xD688-0xD68F
and  edi, byte 7
mov  edx, [a+edi*4]
add   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID690: ; ADD		0xD690-0xD697
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID698: ; ADD		0xD698-0xD69F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6A0: ; ADD		0xD6A0-0xD6A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6A8: ; ADD		0xD6A8-0xD6AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6B0: ; ADD		0xD6B0-0xD6B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6B8: ; ADD		0xD6B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6B9: ; ADD		0xD6B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6BA: ; ADD		0xD6BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6BB: ; ADD		0xD6BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6BC: ; ADD		0xD6BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
add   [d+(3*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID710: ; ADD		0xD710-0xD717
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   dl, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID718: ; ADD		0xD718-0xD71F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   dl, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID720: ; ADD		0xD720-0xD727
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   dl, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID728: ; ADD		0xD728-0xD72F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   dl, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID730: ; ADD		0xD730-0xD737
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   dl, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID738: ; ADD		0xD738
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   dl, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID739: ; ADD		0xD739
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   dl, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID750: ; ADD		0xD750-0xD757
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   dx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID758: ; ADD		0xD758-0xD75F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   dx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID760: ; ADD		0xD760-0xD767
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   dx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID768: ; ADD		0xD768-0xD76F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   dx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID770: ; ADD		0xD770-0xD777
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   dx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID778: ; ADD		0xD778
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   dx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID779: ; ADD		0xD779
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   dx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID790: ; ADD		0xD790-0xD797
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   edx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID798: ; ADD		0xD798-0xD79F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   edx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID7A0: ; ADD		0xD7A0-0xD7A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   edx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID7A8: ; ADD		0xD7A8-0xD7AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   edx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID7B0: ; ADD		0xD7B0-0xD7B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   edx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID7B8: ; ADD		0xD7B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   edx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID7B9: ; ADD		0xD7B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   edx, [d+(3*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID800: ; ADD		0xD800-0xD807
and  edi, byte 7
mov  dl, [d+edi*4]
add   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID810: ; ADD		0xD810-0xD817
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID818: ; ADD		0xD818-0xD81F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID820: ; ADD		0xD820-0xD827
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID828: ; ADD		0xD828-0xD82F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID830: ; ADD		0xD830-0xD837
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID838: ; ADD		0xD838
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID839: ; ADD		0xD839
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID83A: ; ADD		0xD83A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
add   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID83B: ; ADD		0xD83B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
add   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID83C: ; ADD		0xD83C
mov  dl, [esi]
add  esi, byte 2
add   [d+(4*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID840: ; ADD		0xD840-0xD847
and  edi, byte 7
mov  edx, [d+edi*4]
add   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID848: ; ADD		0xD848-0xD84F
and  edi, byte 7
mov  edx, [a+edi*4]
add   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID850: ; ADD		0xD850-0xD857
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID858: ; ADD		0xD858-0xD85F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID860: ; ADD		0xD860-0xD867
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID868: ; ADD		0xD868-0xD86F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID870: ; ADD		0xD870-0xD877
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID878: ; ADD		0xD878
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID879: ; ADD		0xD879
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID87A: ; ADD		0xD87A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
add   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID87B: ; ADD		0xD87B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
add   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID87C: ; ADD		0xD87C
mov  edx, [esi]
add  esi, byte 2
add   [d+(4*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID880: ; ADD		0xD880-0xD887
and  edi, byte 7
mov  edx, [d+edi*4]
add   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID888: ; ADD		0xD888-0xD88F
and  edi, byte 7
mov  edx, [a+edi*4]
add   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID890: ; ADD		0xD890-0xD897
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID898: ; ADD		0xD898-0xD89F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8A0: ; ADD		0xD8A0-0xD8A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8A8: ; ADD		0xD8A8-0xD8AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8B0: ; ADD		0xD8B0-0xD8B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8B8: ; ADD		0xD8B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8B9: ; ADD		0xD8B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8BA: ; ADD		0xD8BA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8BB: ; ADD		0xD8BB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8BC: ; ADD		0xD8BC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
add   [d+(4*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID910: ; ADD		0xD910-0xD917
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   dl, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID918: ; ADD		0xD918-0xD91F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   dl, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID920: ; ADD		0xD920-0xD927
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   dl, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID928: ; ADD		0xD928-0xD92F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   dl, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID930: ; ADD		0xD930-0xD937
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   dl, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID938: ; ADD		0xD938
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   dl, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID939: ; ADD		0xD939
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   dl, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID950: ; ADD		0xD950-0xD957
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   dx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID958: ; ADD		0xD958-0xD95F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   dx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID960: ; ADD		0xD960-0xD967
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   dx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID968: ; ADD		0xD968-0xD96F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   dx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID970: ; ADD		0xD970-0xD977
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   dx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID978: ; ADD		0xD978
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   dx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID979: ; ADD		0xD979
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   dx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID990: ; ADD		0xD990-0xD997
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   edx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID998: ; ADD		0xD998-0xD99F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   edx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID9A0: ; ADD		0xD9A0-0xD9A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   edx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID9A8: ; ADD		0xD9A8-0xD9AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   edx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID9B0: ; ADD		0xD9B0-0xD9B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   edx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID9B8: ; ADD		0xD9B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   edx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID9B9: ; ADD		0xD9B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   edx, [d+(4*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA00: ; ADD		0xDA00-0xDA07
and  edi, byte 7
mov  dl, [d+edi*4]
add   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA10: ; ADD		0xDA10-0xDA17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA18: ; ADD		0xDA18-0xDA1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA20: ; ADD		0xDA20-0xDA27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA28: ; ADD		0xDA28-0xDA2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA30: ; ADD		0xDA30-0xDA37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA38: ; ADD		0xDA38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA39: ; ADD		0xDA39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA3A: ; ADD		0xDA3A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
add   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA3B: ; ADD		0xDA3B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
add   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA3C: ; ADD		0xDA3C
mov  dl, [esi]
add  esi, byte 2
add   [d+(5*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA40: ; ADD		0xDA40-0xDA47
and  edi, byte 7
mov  edx, [d+edi*4]
add   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA48: ; ADD		0xDA48-0xDA4F
and  edi, byte 7
mov  edx, [a+edi*4]
add   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA50: ; ADD		0xDA50-0xDA57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA58: ; ADD		0xDA58-0xDA5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA60: ; ADD		0xDA60-0xDA67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA68: ; ADD		0xDA68-0xDA6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA70: ; ADD		0xDA70-0xDA77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA78: ; ADD		0xDA78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA79: ; ADD		0xDA79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA7A: ; ADD		0xDA7A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
add   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA7B: ; ADD		0xDA7B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
add   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA7C: ; ADD		0xDA7C
mov  edx, [esi]
add  esi, byte 2
add   [d+(5*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA80: ; ADD		0xDA80-0xDA87
and  edi, byte 7
mov  edx, [d+edi*4]
add   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA88: ; ADD		0xDA88-0xDA8F
and  edi, byte 7
mov  edx, [a+edi*4]
add   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA90: ; ADD		0xDA90-0xDA97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDA98: ; ADD		0xDA98-0xDA9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDAA0: ; ADD		0xDAA0-0xDAA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDAA8: ; ADD		0xDAA8-0xDAAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDAB0: ; ADD		0xDAB0-0xDAB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDAB8: ; ADD		0xDAB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDAB9: ; ADD		0xDAB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDABA: ; ADD		0xDABA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDABB: ; ADD		0xDABB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDABC: ; ADD		0xDABC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
add   [d+(5*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB10: ; ADD		0xDB10-0xDB17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   dl, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB18: ; ADD		0xDB18-0xDB1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   dl, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB20: ; ADD		0xDB20-0xDB27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   dl, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB28: ; ADD		0xDB28-0xDB2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   dl, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB30: ; ADD		0xDB30-0xDB37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   dl, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB38: ; ADD		0xDB38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   dl, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB39: ; ADD		0xDB39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   dl, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB50: ; ADD		0xDB50-0xDB57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   dx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB58: ; ADD		0xDB58-0xDB5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   dx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB60: ; ADD		0xDB60-0xDB67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   dx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB68: ; ADD		0xDB68-0xDB6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   dx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB70: ; ADD		0xDB70-0xDB77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   dx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB78: ; ADD		0xDB78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   dx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB79: ; ADD		0xDB79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   dx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB90: ; ADD		0xDB90-0xDB97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   edx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB98: ; ADD		0xDB98-0xDB9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   edx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDBA0: ; ADD		0xDBA0-0xDBA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   edx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDBA8: ; ADD		0xDBA8-0xDBAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   edx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDBB0: ; ADD		0xDBB0-0xDBB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   edx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDBB8: ; ADD		0xDBB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   edx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDBB9: ; ADD		0xDBB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   edx, [d+(5*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC00: ; ADD		0xDC00-0xDC07
and  edi, byte 7
mov  dl, [d+edi*4]
add   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC10: ; ADD		0xDC10-0xDC17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC18: ; ADD		0xDC18-0xDC1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC20: ; ADD		0xDC20-0xDC27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC28: ; ADD		0xDC28-0xDC2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC30: ; ADD		0xDC30-0xDC37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC38: ; ADD		0xDC38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC39: ; ADD		0xDC39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC3A: ; ADD		0xDC3A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
add   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC3B: ; ADD		0xDC3B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
add   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC3C: ; ADD		0xDC3C
mov  dl, [esi]
add  esi, byte 2
add   [d+(6*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC40: ; ADD		0xDC40-0xDC47
and  edi, byte 7
mov  edx, [d+edi*4]
add   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC48: ; ADD		0xDC48-0xDC4F
and  edi, byte 7
mov  edx, [a+edi*4]
add   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC50: ; ADD		0xDC50-0xDC57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC58: ; ADD		0xDC58-0xDC5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC60: ; ADD		0xDC60-0xDC67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC68: ; ADD		0xDC68-0xDC6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC70: ; ADD		0xDC70-0xDC77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC78: ; ADD		0xDC78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC79: ; ADD		0xDC79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC7A: ; ADD		0xDC7A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
add   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC7B: ; ADD		0xDC7B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
add   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC7C: ; ADD		0xDC7C
mov  edx, [esi]
add  esi, byte 2
add   [d+(6*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC80: ; ADD		0xDC80-0xDC87
and  edi, byte 7
mov  edx, [d+edi*4]
add   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC88: ; ADD		0xDC88-0xDC8F
and  edi, byte 7
mov  edx, [a+edi*4]
add   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC90: ; ADD		0xDC90-0xDC97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDC98: ; ADD		0xDC98-0xDC9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCA0: ; ADD		0xDCA0-0xDCA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCA8: ; ADD		0xDCA8-0xDCAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCB0: ; ADD		0xDCB0-0xDCB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCB8: ; ADD		0xDCB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCB9: ; ADD		0xDCB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCBA: ; ADD		0xDCBA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCBB: ; ADD		0xDCBB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCBC: ; ADD		0xDCBC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
add   [d+(6*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD10: ; ADD		0xDD10-0xDD17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   dl, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD18: ; ADD		0xDD18-0xDD1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   dl, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD20: ; ADD		0xDD20-0xDD27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   dl, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD28: ; ADD		0xDD28-0xDD2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   dl, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD30: ; ADD		0xDD30-0xDD37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   dl, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD38: ; ADD		0xDD38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   dl, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD39: ; ADD		0xDD39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   dl, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD50: ; ADD		0xDD50-0xDD57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   dx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD58: ; ADD		0xDD58-0xDD5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   dx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD60: ; ADD		0xDD60-0xDD67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   dx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD68: ; ADD		0xDD68-0xDD6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   dx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD70: ; ADD		0xDD70-0xDD77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   dx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD78: ; ADD		0xDD78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   dx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD79: ; ADD		0xDD79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   dx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD90: ; ADD		0xDD90-0xDD97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   edx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD98: ; ADD		0xDD98-0xDD9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   edx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDDA0: ; ADD		0xDDA0-0xDDA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   edx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDDA8: ; ADD		0xDDA8-0xDDAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   edx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDDB0: ; ADD		0xDDB0-0xDDB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   edx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDDB8: ; ADD		0xDDB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   edx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDDB9: ; ADD		0xDDB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   edx, [d+(6*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE00: ; ADD		0xDE00-0xDE07
and  edi, byte 7
mov  dl, [d+edi*4]
add   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE10: ; ADD		0xDE10-0xDE17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE18: ; ADD		0xDE18-0xDE1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE20: ; ADD		0xDE20-0xDE27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE28: ; ADD		0xDE28-0xDE2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE30: ; ADD		0xDE30-0xDE37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE38: ; ADD		0xDE38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE39: ; ADD		0xDE39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE3A: ; ADD		0xDE3A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
add   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE3B: ; ADD		0xDE3B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadByte
add   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE3C: ; ADD		0xDE3C
mov  dl, [esi]
add  esi, byte 2
add   [d+(7*4)], dl
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE40: ; ADD		0xDE40-0xDE47
and  edi, byte 7
mov  edx, [d+edi*4]
add   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE48: ; ADD		0xDE48-0xDE4F
and  edi, byte 7
mov  edx, [a+edi*4]
add   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE50: ; ADD		0xDE50-0xDE57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE58: ; ADD		0xDE58-0xDE5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE60: ; ADD		0xDE60-0xDE67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE68: ; ADD		0xDE68-0xDE6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE70: ; ADD		0xDE70-0xDE77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE78: ; ADD		0xDE78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE79: ; ADD		0xDE79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE7A: ; ADD		0xDE7A
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
add   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE7B: ; ADD		0xDE7B
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWord
add   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE7C: ; ADD		0xDE7C
mov  edx, [esi]
add  esi, byte 2
add   [d+(7*4)], dx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE80: ; ADD		0xDE80-0xDE87
and  edi, byte 7
mov  edx, [d+edi*4]
add   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE88: ; ADD		0xDE88-0xDE8F
and  edi, byte 7
mov  edx, [a+edi*4]
add   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE90: ; ADD		0xDE90-0xDE97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDE98: ; ADD		0xDE98-0xDE9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDEA0: ; ADD		0xDEA0-0xDEA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDEA8: ; ADD		0xDEA8-0xDEAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDEB0: ; ADD		0xDEB0-0xDEB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDEB8: ; ADD		0xDEB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDEB9: ; ADD		0xDEB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDEBA: ; ADD		0xDEBA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDEBB: ; ADD		0xDEBB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDEBC: ; ADD		0xDEBC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
add   [d+(7*4)], edx
lahf
setc byte [x]
seto al
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF10: ; ADD		0xDF10-0xDF17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   dl, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF18: ; ADD		0xDF18-0xDF1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   dl, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF20: ; ADD		0xDF20-0xDF27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   dl, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF28: ; ADD		0xDF28-0xDF2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   dl, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF30: ; ADD		0xDF30-0xDF37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   dl, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF38: ; ADD		0xDF38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   dl, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF39: ; ADD		0xDF39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   dl, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF50: ; ADD		0xDF50-0xDF57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   dx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF58: ; ADD		0xDF58-0xDF5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   dx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF60: ; ADD		0xDF60-0xDF67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   dx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF68: ; ADD		0xDF68-0xDF6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   dx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF70: ; ADD		0xDF70-0xDF77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   dx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF78: ; ADD		0xDF78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   dx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF79: ; ADD		0xDF79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   dx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF90: ; ADD		0xDF90-0xDF97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   edx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF98: ; ADD		0xDF98-0xDF9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   edx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDFA0: ; ADD		0xDFA0-0xDFA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   edx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDFA8: ; ADD		0xDFA8-0xDFAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   edx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDFB0: ; ADD		0xDFB0-0xDFB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   edx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDFB8: ; ADD		0xDFB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   edx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDFB9: ; ADD		0xDFB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   edx, [d+(7*4)]
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0000: ; ORI		0x0000-0x0007
and  edi, byte 7
mov  edx, [esi]
or   byte [d+edi*4], dl
lahf
xor  al, al
add  esi, byte 2
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0010: ; ORI		0x0010-0x0017
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
mov  edi, [run_esi]
or   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0018: ; ORI		0x0018-0x001F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
mov  edi, [run_esi]
or   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0020: ; ORI		0x0020-0x0027
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
mov  edi, [run_esi]
or   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0028: ; ORI		0x0028-0x002F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
mov  edi, [run_esi]
or   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0030: ; ORI		0x0030-0x0037
mov  [run_esi], esi
add  esi, byte 2
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
mov  edi, [run_esi]
or   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0038: ; ORI		0x0038
mov  [run_esi], esi
add  esi, byte 2
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
mov  edi, [run_esi]
or   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0039: ; ORI		0x0039
mov  [run_esi], esi
add  esi, byte 2
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
mov  edi, [run_esi]
or   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0040: ; ORI		0x0040-0x0047
and  edi, byte 7
mov  edx, [esi]
or   word [d+edi*4], dx
lahf
xor  al, al
add  esi, byte 2
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0050: ; ORI		0x0050-0x0057
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
mov  edi, [run_esi]
or   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0058: ; ORI		0x0058-0x005F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
mov  edi, [run_esi]
or   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0060: ; ORI		0x0060-0x0067
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
mov  edi, [run_esi]
or   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0068: ; ORI		0x0068-0x006F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
mov  edi, [run_esi]
or   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0070: ; ORI		0x0070-0x0077
mov  [run_esi], esi
add  esi, byte 2
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
mov  edi, [run_esi]
or   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0078: ; ORI		0x0078
mov  [run_esi], esi
add  esi, byte 2
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
mov  edi, [run_esi]
or   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0079: ; ORI		0x0079
mov  [run_esi], esi
add  esi, byte 2
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
mov  edi, [run_esi]
or   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0080: ; ORI		0x0080-0x0087
and  edi, byte 7
mov  edx, [esi]
ror  edx, byte 16
or   dword [d+edi*4], edx
lahf
xor  al, al
add  esi, byte 4
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0090: ; ORI		0x0090-0x0097
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
or   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0098: ; ORI		0x0098-0x009F
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
or   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I00A0: ; ORI		0x00A0-0x00A7
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
or   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I00A8: ; ORI		0x00A8-0x00AF
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
or   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I00B0: ; ORI		0x00B0-0x00B7
mov  [run_esi], esi
add  esi, byte 4
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
or   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 30
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I00B8: ; ORI		0x00B8
mov  [run_esi], esi
add  esi, byte 4
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
or   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I00B9: ; ORI		0x00B9
mov  [run_esi], esi
add  esi, byte 4
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
or   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 32
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0200: ; ANDI		0x0200-0x0207
and  edi, byte 7
mov  edx, [esi]
and   byte [d+edi*4], dl
lahf
xor  al, al
add  esi, byte 2
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0210: ; ANDI		0x0210-0x0217
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
mov  edi, [run_esi]
and   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0218: ; ANDI		0x0218-0x021F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
mov  edi, [run_esi]
and   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0220: ; ANDI		0x0220-0x0227
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
mov  edi, [run_esi]
and   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0228: ; ANDI		0x0228-0x022F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
mov  edi, [run_esi]
and   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0230: ; ANDI		0x0230-0x0237
mov  [run_esi], esi
add  esi, byte 2
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
mov  edi, [run_esi]
and   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0238: ; ANDI		0x0238
mov  [run_esi], esi
add  esi, byte 2
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
mov  edi, [run_esi]
and   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0239: ; ANDI		0x0239
mov  [run_esi], esi
add  esi, byte 2
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
mov  edi, [run_esi]
and   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0240: ; ANDI		0x0240-0x0247
and  edi, byte 7
mov  edx, [esi]
and   word [d+edi*4], dx
lahf
xor  al, al
add  esi, byte 2
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0250: ; ANDI		0x0250-0x0257
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
mov  edi, [run_esi]
and   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0258: ; ANDI		0x0258-0x025F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
mov  edi, [run_esi]
and   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0260: ; ANDI		0x0260-0x0267
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
mov  edi, [run_esi]
and   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0268: ; ANDI		0x0268-0x026F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
mov  edi, [run_esi]
and   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0270: ; ANDI		0x0270-0x0277
mov  [run_esi], esi
add  esi, byte 2
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
mov  edi, [run_esi]
and   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0278: ; ANDI		0x0278
mov  [run_esi], esi
add  esi, byte 2
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
mov  edi, [run_esi]
and   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0279: ; ANDI		0x0279
mov  [run_esi], esi
add  esi, byte 2
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
mov  edi, [run_esi]
and   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0280: ; ANDI		0x0280-0x0287
and  edi, byte 7
mov  edx, [esi]
ror  edx, byte 16
and   dword [d+edi*4], edx
lahf
xor  al, al
add  esi, byte 4
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0290: ; ANDI		0x0290-0x0297
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
and   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0298: ; ANDI		0x0298-0x029F
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
and   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I02A0: ; ANDI		0x02A0-0x02A7
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
and   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I02A8: ; ANDI		0x02A8-0x02AF
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
and   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I02B0: ; ANDI		0x02B0-0x02B7
mov  [run_esi], esi
add  esi, byte 4
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
and   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I02B8: ; ANDI		0x02B8
mov  [run_esi], esi
add  esi, byte 4
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
and   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I02B9: ; ANDI		0x02B9
mov  [run_esi], esi
add  esi, byte 4
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
and   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0400: ; SUBI		0x0400-0x0407
and  edi, byte 7
mov  edx, [esi]
sub   byte [d+edi*4], dl
lahf
setc byte [x]
seto al
add  esi, byte 2
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0410: ; SUBI		0x0410-0x0417
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
mov  edi, [run_esi]
sub   dl, [edi]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0418: ; SUBI		0x0418-0x041F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
mov  edi, [run_esi]
sub   dl, [edi]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0420: ; SUBI		0x0420-0x0427
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
mov  edi, [run_esi]
sub   dl, [edi]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0428: ; SUBI		0x0428-0x042F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
mov  edi, [run_esi]
sub   dl, [edi]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0430: ; SUBI		0x0430-0x0437
mov  [run_esi], esi
add  esi, byte 2
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
mov  edi, [run_esi]
sub   dl, [edi]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0438: ; SUBI		0x0438
mov  [run_esi], esi
add  esi, byte 2
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
mov  edi, [run_esi]
sub   dl, [edi]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0439: ; SUBI		0x0439
mov  [run_esi], esi
add  esi, byte 2
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
mov  edi, [run_esi]
sub   dl, [edi]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0440: ; SUBI		0x0440-0x0447
and  edi, byte 7
mov  edx, [esi]
sub   word [d+edi*4], dx
lahf
setc byte [x]
seto al
add  esi, byte 2
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0450: ; SUBI		0x0450-0x0457
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
mov  edi, [run_esi]
sub   dx, [edi]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0458: ; SUBI		0x0458-0x045F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
mov  edi, [run_esi]
sub   dx, [edi]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0460: ; SUBI		0x0460-0x0467
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
mov  edi, [run_esi]
sub   dx, [edi]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0468: ; SUBI		0x0468-0x046F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
mov  edi, [run_esi]
sub   dx, [edi]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0470: ; SUBI		0x0470-0x0477
mov  [run_esi], esi
add  esi, byte 2
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
mov  edi, [run_esi]
sub   dx, [edi]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0478: ; SUBI		0x0478
mov  [run_esi], esi
add  esi, byte 2
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
mov  edi, [run_esi]
sub   dx, [edi]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0479: ; SUBI		0x0479
mov  [run_esi], esi
add  esi, byte 2
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
mov  edi, [run_esi]
sub   dx, [edi]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0480: ; SUBI		0x0480-0x0487
and  edi, byte 7
mov  edx, [esi]
ror  edx, byte 16
sub   dword [d+edi*4], edx
lahf
setc byte [x]
seto al
add  esi, byte 4
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0490: ; SUBI		0x0490-0x0497
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
sub   edx, edi
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0498: ; SUBI		0x0498-0x049F
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
sub   edx, edi
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I04A0: ; SUBI		0x04A0-0x04A7
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
sub   edx, edi
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I04A8: ; SUBI		0x04A8-0x04AF
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
sub   edx, edi
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I04B0: ; SUBI		0x04B0-0x04B7
mov  [run_esi], esi
add  esi, byte 4
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
sub   edx, edi
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 30
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I04B8: ; SUBI		0x04B8
mov  [run_esi], esi
add  esi, byte 4
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
sub   edx, edi
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I04B9: ; SUBI		0x04B9
mov  [run_esi], esi
add  esi, byte 4
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
sub   edx, edi
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 32
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0600: ; ADDI		0x0600-0x0607
and  edi, byte 7
mov  edx, [esi]
add   byte [d+edi*4], dl
lahf
setc byte [x]
seto al
add  esi, byte 2
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0610: ; ADDI		0x0610-0x0617
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
mov  edi, [run_esi]
add   dl, [edi]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0618: ; ADDI		0x0618-0x061F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
mov  edi, [run_esi]
add   dl, [edi]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0620: ; ADDI		0x0620-0x0627
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
mov  edi, [run_esi]
add   dl, [edi]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0628: ; ADDI		0x0628-0x062F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
mov  edi, [run_esi]
add   dl, [edi]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0630: ; ADDI		0x0630-0x0637
mov  [run_esi], esi
add  esi, byte 2
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
mov  edi, [run_esi]
add   dl, [edi]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0638: ; ADDI		0x0638
mov  [run_esi], esi
add  esi, byte 2
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
mov  edi, [run_esi]
add   dl, [edi]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0639: ; ADDI		0x0639
mov  [run_esi], esi
add  esi, byte 2
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
mov  edi, [run_esi]
add   dl, [edi]
lahf
setc byte [x]
seto al
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0640: ; ADDI		0x0640-0x0647
and  edi, byte 7
mov  edx, [esi]
add   word [d+edi*4], dx
lahf
setc byte [x]
seto al
add  esi, byte 2
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0650: ; ADDI		0x0650-0x0657
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
mov  edi, [run_esi]
add   dx, [edi]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0658: ; ADDI		0x0658-0x065F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
mov  edi, [run_esi]
add   dx, [edi]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0660: ; ADDI		0x0660-0x0667
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
mov  edi, [run_esi]
add   dx, [edi]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0668: ; ADDI		0x0668-0x066F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
mov  edi, [run_esi]
add   dx, [edi]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0670: ; ADDI		0x0670-0x0677
mov  [run_esi], esi
add  esi, byte 2
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
mov  edi, [run_esi]
add   dx, [edi]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0678: ; ADDI		0x0678
mov  [run_esi], esi
add  esi, byte 2
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
mov  edi, [run_esi]
add   dx, [edi]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0679: ; ADDI		0x0679
mov  [run_esi], esi
add  esi, byte 2
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
mov  edi, [run_esi]
add   dx, [edi]
lahf
setc byte [x]
seto al
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0680: ; ADDI		0x0680-0x0687
and  edi, byte 7
mov  edx, [esi]
ror  edx, byte 16
add   dword [d+edi*4], edx
lahf
setc byte [x]
seto al
add  esi, byte 4
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0690: ; ADDI		0x0690-0x0697
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
add   edx, edi
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0698: ; ADDI		0x0698-0x069F
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
add   edx, edi
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I06A0: ; ADDI		0x06A0-0x06A7
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
add   edx, edi
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I06A8: ; ADDI		0x06A8-0x06AF
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
add   edx, edi
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I06B0: ; ADDI		0x06B0-0x06B7
mov  [run_esi], esi
add  esi, byte 4
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
add   edx, edi
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 30
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I06B8: ; ADDI		0x06B8
mov  [run_esi], esi
add  esi, byte 4
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
add   edx, edi
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I06B9: ; ADDI		0x06B9
mov  [run_esi], esi
add  esi, byte 4
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
add   edx, edi
lahf
setc byte [x]
seto al
call WriteLong
sub  ecx, byte 32
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A00: ; EORI		0x0A00-0x0A07
and  edi, byte 7
mov  edx, [esi]
xor   byte [d+edi*4], dl
lahf
xor  al, al
add  esi, byte 2
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A10: ; EORI		0x0A10-0x0A17
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
mov  edi, [run_esi]
xor   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A18: ; EORI		0x0A18-0x0A1F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
mov  edi, [run_esi]
xor   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A20: ; EORI		0x0A20-0x0A27
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
mov  edi, [run_esi]
xor   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A28: ; EORI		0x0A28-0x0A2F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
mov  edi, [run_esi]
xor   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A30: ; EORI		0x0A30-0x0A37
mov  [run_esi], esi
add  esi, byte 2
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
mov  edi, [run_esi]
xor   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A38: ; EORI		0x0A38
mov  [run_esi], esi
add  esi, byte 2
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
mov  edi, [run_esi]
xor   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A39: ; EORI		0x0A39
mov  [run_esi], esi
add  esi, byte 2
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
mov  edi, [run_esi]
xor   dl, [edi]
lahf
xor  al, al
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A40: ; EORI		0x0A40-0x0A47
and  edi, byte 7
mov  edx, [esi]
xor   word [d+edi*4], dx
lahf
xor  al, al
add  esi, byte 2
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A50: ; EORI		0x0A50-0x0A57
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
mov  edi, [run_esi]
xor   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A58: ; EORI		0x0A58-0x0A5F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
mov  edi, [run_esi]
xor   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A60: ; EORI		0x0A60-0x0A67
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
mov  edi, [run_esi]
xor   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A68: ; EORI		0x0A68-0x0A6F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
mov  edi, [run_esi]
xor   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A70: ; EORI		0x0A70-0x0A77
mov  [run_esi], esi
add  esi, byte 2
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
mov  edi, [run_esi]
xor   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A78: ; EORI		0x0A78
mov  [run_esi], esi
add  esi, byte 2
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
mov  edi, [run_esi]
xor   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A79: ; EORI		0x0A79
mov  [run_esi], esi
add  esi, byte 2
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
mov  edi, [run_esi]
xor   dx, [edi]
lahf
xor  al, al
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A80: ; EORI		0x0A80-0x0A87
and  edi, byte 7
mov  edx, [esi]
ror  edx, byte 16
xor   dword [d+edi*4], edx
lahf
xor  al, al
add  esi, byte 4
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A90: ; EORI		0x0A90-0x0A97
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
xor   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0A98: ; EORI		0x0A98-0x0A9F
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
xor   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0AA0: ; EORI		0x0AA0-0x0AA7
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
xor   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0AA8: ; EORI		0x0AA8-0x0AAF
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
xor   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0AB0: ; EORI		0x0AB0-0x0AB7
mov  [run_esi], esi
add  esi, byte 4
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
xor   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 30
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0AB8: ; EORI		0x0AB8
mov  [run_esi], esi
add  esi, byte 4
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
xor   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0AB9: ; EORI		0x0AB9
mov  [run_esi], esi
add  esi, byte 4
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
xor   edx, edi
lahf
xor  al, al
call WriteLong
sub  ecx, byte 32
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C00: ; CMPI		0x0C00-0x0C07
and  edi, byte 7
mov  edx, [esi]
cmp   byte [d+edi*4], dl
lahf
seto al
add  esi, byte 2
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C10: ; CMPI		0x0C10-0x0C17
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
mov  edi, [run_esi]
cmp   dl, [edi]
lahf
seto al
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C18: ; CMPI		0x0C18-0x0C1F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
mov  edi, [run_esi]
cmp   dl, [edi]
lahf
seto al
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C20: ; CMPI		0x0C20-0x0C27
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
mov  edi, [run_esi]
cmp   dl, [edi]
lahf
seto al
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C28: ; CMPI		0x0C28-0x0C2F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
mov  edi, [run_esi]
cmp   dl, [edi]
lahf
seto al
call WriteByte
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C30: ; CMPI		0x0C30-0x0C37
mov  [run_esi], esi
add  esi, byte 2
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
mov  edi, [run_esi]
cmp   dl, [edi]
lahf
seto al
call WriteByte
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C38: ; CMPI		0x0C38
mov  [run_esi], esi
add  esi, byte 2
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
mov  edi, [run_esi]
cmp   dl, [edi]
lahf
seto al
call WriteByte
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C39: ; CMPI		0x0C39
mov  [run_esi], esi
add  esi, byte 2
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
mov  edi, [run_esi]
cmp   dl, [edi]
lahf
seto al
call WriteByte
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C40: ; CMPI		0x0C40-0x0C47
and  edi, byte 7
mov  edx, [esi]
cmp   word [d+edi*4], dx
lahf
seto al
add  esi, byte 2
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C50: ; CMPI		0x0C50-0x0C57
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
mov  edi, [run_esi]
cmp   dx, [edi]
lahf
seto al
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C58: ; CMPI		0x0C58-0x0C5F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
mov  edi, [run_esi]
cmp   dx, [edi]
lahf
seto al
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C60: ; CMPI		0x0C60-0x0C67
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
mov  edi, [run_esi]
cmp   dx, [edi]
lahf
seto al
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C68: ; CMPI		0x0C68-0x0C6F
mov  [run_esi], esi
add  esi, byte 2
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
mov  edi, [run_esi]
cmp   dx, [edi]
lahf
seto al
call WriteWord
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C70: ; CMPI		0x0C70-0x0C77
mov  [run_esi], esi
add  esi, byte 2
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
mov  edi, [run_esi]
cmp   dx, [edi]
lahf
seto al
call WriteWord
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C78: ; CMPI		0x0C78
mov  [run_esi], esi
add  esi, byte 2
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
mov  edi, [run_esi]
cmp   dx, [edi]
lahf
seto al
call WriteWord
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C79: ; CMPI		0x0C79
mov  [run_esi], esi
add  esi, byte 2
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
mov  edi, [run_esi]
cmp   dx, [edi]
lahf
seto al
call WriteWord
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C80: ; CMPI		0x0C80-0x0C87
and  edi, byte 7
mov  edx, [esi]
ror  edx, byte 16
cmp   dword [d+edi*4], edx
lahf
seto al
add  esi, byte 4
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C90: ; CMPI		0x0C90-0x0C97
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
cmp   edx, edi
lahf
seto al
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0C98: ; CMPI		0x0C98-0x0C9F
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
cmp   edx, edi
lahf
seto al
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0CA0: ; CMPI		0x0CA0-0x0CA7
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
cmp   edx, edi
lahf
seto al
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0CA8: ; CMPI		0x0CA8-0x0CAF
mov  [run_esi], esi
add  esi, byte 4
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
cmp   edx, edi
lahf
seto al
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0CB0: ; CMPI		0x0CB0-0x0CB7
mov  [run_esi], esi
add  esi, byte 4
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
cmp   edx, edi
lahf
seto al
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0CB8: ; CMPI		0x0CB8
mov  [run_esi], esi
add  esi, byte 4
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
cmp   edx, edi
lahf
seto al
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I0CB9: ; CMPI		0x0CB9
mov  [run_esi], esi
add  esi, byte 4
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
mov  edi, [run_esi]
mov  edi, [edi]
ror  edi, byte 16
cmp   edx, edi
lahf
seto al
call WriteLong
sub  ecx, byte 30
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0C0: ; ADDA		0xD0C0-0xD0C7
and  edi, byte 7
movsx    edx, word [d+edi*4]
add  [a+0*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0C8: ; ADDA		0xD0C8-0xD0CF
and  edi, byte 7
movsx    edx, word [a+edi*4]
add  [a+0*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0D0: ; ADDA		0xD0D0-0xD0D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWordSX
add  [a+0*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0D8: ; ADDA		0xD0D8-0xD0DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWordSX
add  [a+0*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0E0: ; ADDA		0xD0E0-0xD0E7
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWordSX
add  [a+0*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0E8: ; ADDA		0xD0E8-0xD0EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWordSX
add  [a+0*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0F0: ; ADDA		0xD0F0-0xD0F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWordSX
add  [a+0*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0F8: ; ADDA		0xD0F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWordSX
add  [a+0*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0F9: ; ADDA		0xD0F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWordSX
add  [a+0*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0FA: ; ADDA		0xD0FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
add  [a+0*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0FB: ; ADDA		0xD0FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
add  [a+0*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID0FC: ; ADDA		0xD0FC
movsx    edx, word [esi]
add  esi, byte 2
add  [a+0*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2C0: ; ADDA		0xD2C0-0xD2C7
and  edi, byte 7
movsx    edx, word [d+edi*4]
add  [a+1*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2C8: ; ADDA		0xD2C8-0xD2CF
and  edi, byte 7
movsx    edx, word [a+edi*4]
add  [a+1*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2D0: ; ADDA		0xD2D0-0xD2D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWordSX
add  [a+1*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2D8: ; ADDA		0xD2D8-0xD2DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWordSX
add  [a+1*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2E0: ; ADDA		0xD2E0-0xD2E7
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWordSX
add  [a+1*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2E8: ; ADDA		0xD2E8-0xD2EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWordSX
add  [a+1*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2F0: ; ADDA		0xD2F0-0xD2F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWordSX
add  [a+1*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2F8: ; ADDA		0xD2F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWordSX
add  [a+1*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2F9: ; ADDA		0xD2F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWordSX
add  [a+1*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2FA: ; ADDA		0xD2FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
add  [a+1*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2FB: ; ADDA		0xD2FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
add  [a+1*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID2FC: ; ADDA		0xD2FC
movsx    edx, word [esi]
add  esi, byte 2
add  [a+1*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4C0: ; ADDA		0xD4C0-0xD4C7
and  edi, byte 7
movsx    edx, word [d+edi*4]
add  [a+2*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4C8: ; ADDA		0xD4C8-0xD4CF
and  edi, byte 7
movsx    edx, word [a+edi*4]
add  [a+2*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4D0: ; ADDA		0xD4D0-0xD4D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWordSX
add  [a+2*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4D8: ; ADDA		0xD4D8-0xD4DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWordSX
add  [a+2*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4E0: ; ADDA		0xD4E0-0xD4E7
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWordSX
add  [a+2*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4E8: ; ADDA		0xD4E8-0xD4EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWordSX
add  [a+2*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4F0: ; ADDA		0xD4F0-0xD4F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWordSX
add  [a+2*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4F8: ; ADDA		0xD4F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWordSX
add  [a+2*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4F9: ; ADDA		0xD4F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWordSX
add  [a+2*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4FA: ; ADDA		0xD4FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
add  [a+2*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4FB: ; ADDA		0xD4FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
add  [a+2*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID4FC: ; ADDA		0xD4FC
movsx    edx, word [esi]
add  esi, byte 2
add  [a+2*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6C0: ; ADDA		0xD6C0-0xD6C7
and  edi, byte 7
movsx    edx, word [d+edi*4]
add  [a+3*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6C8: ; ADDA		0xD6C8-0xD6CF
and  edi, byte 7
movsx    edx, word [a+edi*4]
add  [a+3*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6D0: ; ADDA		0xD6D0-0xD6D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWordSX
add  [a+3*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6D8: ; ADDA		0xD6D8-0xD6DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWordSX
add  [a+3*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6E0: ; ADDA		0xD6E0-0xD6E7
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWordSX
add  [a+3*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6E8: ; ADDA		0xD6E8-0xD6EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWordSX
add  [a+3*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6F0: ; ADDA		0xD6F0-0xD6F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWordSX
add  [a+3*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6F8: ; ADDA		0xD6F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWordSX
add  [a+3*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6F9: ; ADDA		0xD6F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWordSX
add  [a+3*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6FA: ; ADDA		0xD6FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
add  [a+3*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6FB: ; ADDA		0xD6FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
add  [a+3*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID6FC: ; ADDA		0xD6FC
movsx    edx, word [esi]
add  esi, byte 2
add  [a+3*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8C0: ; ADDA		0xD8C0-0xD8C7
and  edi, byte 7
movsx    edx, word [d+edi*4]
add  [a+4*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8C8: ; ADDA		0xD8C8-0xD8CF
and  edi, byte 7
movsx    edx, word [a+edi*4]
add  [a+4*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8D0: ; ADDA		0xD8D0-0xD8D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWordSX
add  [a+4*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8D8: ; ADDA		0xD8D8-0xD8DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWordSX
add  [a+4*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8E0: ; ADDA		0xD8E0-0xD8E7
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWordSX
add  [a+4*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8E8: ; ADDA		0xD8E8-0xD8EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWordSX
add  [a+4*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8F0: ; ADDA		0xD8F0-0xD8F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWordSX
add  [a+4*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8F8: ; ADDA		0xD8F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWordSX
add  [a+4*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8F9: ; ADDA		0xD8F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWordSX
add  [a+4*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8FA: ; ADDA		0xD8FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
add  [a+4*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8FB: ; ADDA		0xD8FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
add  [a+4*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID8FC: ; ADDA		0xD8FC
movsx    edx, word [esi]
add  esi, byte 2
add  [a+4*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDAC0: ; ADDA		0xDAC0-0xDAC7
and  edi, byte 7
movsx    edx, word [d+edi*4]
add  [a+5*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDAC8: ; ADDA		0xDAC8-0xDACF
and  edi, byte 7
movsx    edx, word [a+edi*4]
add  [a+5*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDAD0: ; ADDA		0xDAD0-0xDAD7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWordSX
add  [a+5*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDAD8: ; ADDA		0xDAD8-0xDADF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWordSX
add  [a+5*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDAE0: ; ADDA		0xDAE0-0xDAE7
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWordSX
add  [a+5*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDAE8: ; ADDA		0xDAE8-0xDAEF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWordSX
add  [a+5*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDAF0: ; ADDA		0xDAF0-0xDAF7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWordSX
add  [a+5*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDAF8: ; ADDA		0xDAF8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWordSX
add  [a+5*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDAF9: ; ADDA		0xDAF9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWordSX
add  [a+5*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDAFA: ; ADDA		0xDAFA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
add  [a+5*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDAFB: ; ADDA		0xDAFB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
add  [a+5*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDAFC: ; ADDA		0xDAFC
movsx    edx, word [esi]
add  esi, byte 2
add  [a+5*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCC0: ; ADDA		0xDCC0-0xDCC7
and  edi, byte 7
movsx    edx, word [d+edi*4]
add  [a+6*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCC8: ; ADDA		0xDCC8-0xDCCF
and  edi, byte 7
movsx    edx, word [a+edi*4]
add  [a+6*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCD0: ; ADDA		0xDCD0-0xDCD7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWordSX
add  [a+6*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCD8: ; ADDA		0xDCD8-0xDCDF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWordSX
add  [a+6*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCE0: ; ADDA		0xDCE0-0xDCE7
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWordSX
add  [a+6*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCE8: ; ADDA		0xDCE8-0xDCEF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWordSX
add  [a+6*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCF0: ; ADDA		0xDCF0-0xDCF7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWordSX
add  [a+6*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCF8: ; ADDA		0xDCF8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWordSX
add  [a+6*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCF9: ; ADDA		0xDCF9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWordSX
add  [a+6*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCFA: ; ADDA		0xDCFA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
add  [a+6*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCFB: ; ADDA		0xDCFB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
add  [a+6*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDCFC: ; ADDA		0xDCFC
movsx    edx, word [esi]
add  esi, byte 2
add  [a+6*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDEC0: ; ADDA		0xDEC0-0xDEC7
and  edi, byte 7
movsx    edx, word [d+edi*4]
add  [a+7*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDEC8: ; ADDA		0xDEC8-0xDECF
and  edi, byte 7
movsx    edx, word [a+edi*4]
add  [a+7*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDED0: ; ADDA		0xDED0-0xDED7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWordSX
add  [a+7*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDED8: ; ADDA		0xDED8-0xDEDF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWordSX
add  [a+7*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDEE0: ; ADDA		0xDEE0-0xDEE7
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWordSX
add  [a+7*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDEE8: ; ADDA		0xDEE8-0xDEEF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWordSX
add  [a+7*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDEF0: ; ADDA		0xDEF0-0xDEF7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWordSX
add  [a+7*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDEF8: ; ADDA		0xDEF8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWordSX
add  [a+7*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDEF9: ; ADDA		0xDEF9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWordSX
add  [a+7*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDEFA: ; ADDA		0xDEFA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
add  [a+7*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDEFB: ; ADDA		0xDEFB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
add  [a+7*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDEFC: ; ADDA		0xDEFC
movsx    edx, word [esi]
add  esi, byte 2
add  [a+7*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID1C0: ; ADDA		0xD1C0-0xD1C7
and  edi, byte 7
mov  edx, [d+edi*4]
add  [a+0*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID1C8: ; ADDA		0xD1C8-0xD1CF
and  edi, byte 7
mov  edx, [a+edi*4]
add  [a+0*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID1D0: ; ADDA		0xD1D0-0xD1D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add  [a+0*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID1D8: ; ADDA		0xD1D8-0xD1DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add  [a+0*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID1E0: ; ADDA		0xD1E0-0xD1E7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add  [a+0*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID1E8: ; ADDA		0xD1E8-0xD1EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add  [a+0*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID1F0: ; ADDA		0xD1F0-0xD1F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add  [a+0*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID1F8: ; ADDA		0xD1F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add  [a+0*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID1F9: ; ADDA		0xD1F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add  [a+0*4], edx
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID1FA: ; ADDA		0xD1FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add  [a+0*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID1FB: ; ADDA		0xD1FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add  [a+0*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID1FC: ; ADDA		0xD1FC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
add  [a+0*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID3C0: ; ADDA		0xD3C0-0xD3C7
and  edi, byte 7
mov  edx, [d+edi*4]
add  [a+1*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID3C8: ; ADDA		0xD3C8-0xD3CF
and  edi, byte 7
mov  edx, [a+edi*4]
add  [a+1*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID3D0: ; ADDA		0xD3D0-0xD3D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add  [a+1*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID3D8: ; ADDA		0xD3D8-0xD3DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add  [a+1*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID3E0: ; ADDA		0xD3E0-0xD3E7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add  [a+1*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID3E8: ; ADDA		0xD3E8-0xD3EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add  [a+1*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID3F0: ; ADDA		0xD3F0-0xD3F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add  [a+1*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID3F8: ; ADDA		0xD3F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add  [a+1*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID3F9: ; ADDA		0xD3F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add  [a+1*4], edx
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID3FA: ; ADDA		0xD3FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add  [a+1*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID3FB: ; ADDA		0xD3FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add  [a+1*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID3FC: ; ADDA		0xD3FC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
add  [a+1*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID5C0: ; ADDA		0xD5C0-0xD5C7
and  edi, byte 7
mov  edx, [d+edi*4]
add  [a+2*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID5C8: ; ADDA		0xD5C8-0xD5CF
and  edi, byte 7
mov  edx, [a+edi*4]
add  [a+2*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID5D0: ; ADDA		0xD5D0-0xD5D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add  [a+2*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID5D8: ; ADDA		0xD5D8-0xD5DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add  [a+2*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID5E0: ; ADDA		0xD5E0-0xD5E7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add  [a+2*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID5E8: ; ADDA		0xD5E8-0xD5EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add  [a+2*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID5F0: ; ADDA		0xD5F0-0xD5F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add  [a+2*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID5F8: ; ADDA		0xD5F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add  [a+2*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID5F9: ; ADDA		0xD5F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add  [a+2*4], edx
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID5FA: ; ADDA		0xD5FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add  [a+2*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID5FB: ; ADDA		0xD5FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add  [a+2*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID5FC: ; ADDA		0xD5FC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
add  [a+2*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID7C0: ; ADDA		0xD7C0-0xD7C7
and  edi, byte 7
mov  edx, [d+edi*4]
add  [a+3*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID7C8: ; ADDA		0xD7C8-0xD7CF
and  edi, byte 7
mov  edx, [a+edi*4]
add  [a+3*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID7D0: ; ADDA		0xD7D0-0xD7D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add  [a+3*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID7D8: ; ADDA		0xD7D8-0xD7DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add  [a+3*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID7E0: ; ADDA		0xD7E0-0xD7E7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add  [a+3*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID7E8: ; ADDA		0xD7E8-0xD7EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add  [a+3*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID7F0: ; ADDA		0xD7F0-0xD7F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add  [a+3*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID7F8: ; ADDA		0xD7F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add  [a+3*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID7F9: ; ADDA		0xD7F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add  [a+3*4], edx
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID7FA: ; ADDA		0xD7FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add  [a+3*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID7FB: ; ADDA		0xD7FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add  [a+3*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID7FC: ; ADDA		0xD7FC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
add  [a+3*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID9C0: ; ADDA		0xD9C0-0xD9C7
and  edi, byte 7
mov  edx, [d+edi*4]
add  [a+4*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID9C8: ; ADDA		0xD9C8-0xD9CF
and  edi, byte 7
mov  edx, [a+edi*4]
add  [a+4*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID9D0: ; ADDA		0xD9D0-0xD9D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add  [a+4*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID9D8: ; ADDA		0xD9D8-0xD9DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add  [a+4*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID9E0: ; ADDA		0xD9E0-0xD9E7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add  [a+4*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID9E8: ; ADDA		0xD9E8-0xD9EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add  [a+4*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID9F0: ; ADDA		0xD9F0-0xD9F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add  [a+4*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID9F8: ; ADDA		0xD9F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add  [a+4*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID9F9: ; ADDA		0xD9F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add  [a+4*4], edx
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID9FA: ; ADDA		0xD9FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add  [a+4*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID9FB: ; ADDA		0xD9FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add  [a+4*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID9FC: ; ADDA		0xD9FC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
add  [a+4*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDBC0: ; ADDA		0xDBC0-0xDBC7
and  edi, byte 7
mov  edx, [d+edi*4]
add  [a+5*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDBC8: ; ADDA		0xDBC8-0xDBCF
and  edi, byte 7
mov  edx, [a+edi*4]
add  [a+5*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDBD0: ; ADDA		0xDBD0-0xDBD7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add  [a+5*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDBD8: ; ADDA		0xDBD8-0xDBDF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add  [a+5*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDBE0: ; ADDA		0xDBE0-0xDBE7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add  [a+5*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDBE8: ; ADDA		0xDBE8-0xDBEF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add  [a+5*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDBF0: ; ADDA		0xDBF0-0xDBF7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add  [a+5*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDBF8: ; ADDA		0xDBF8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add  [a+5*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDBF9: ; ADDA		0xDBF9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add  [a+5*4], edx
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDBFA: ; ADDA		0xDBFA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add  [a+5*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDBFB: ; ADDA		0xDBFB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add  [a+5*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDBFC: ; ADDA		0xDBFC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
add  [a+5*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDDC0: ; ADDA		0xDDC0-0xDDC7
and  edi, byte 7
mov  edx, [d+edi*4]
add  [a+6*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDDC8: ; ADDA		0xDDC8-0xDDCF
and  edi, byte 7
mov  edx, [a+edi*4]
add  [a+6*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDDD0: ; ADDA		0xDDD0-0xDDD7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add  [a+6*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDDD8: ; ADDA		0xDDD8-0xDDDF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add  [a+6*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDDE0: ; ADDA		0xDDE0-0xDDE7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add  [a+6*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDDE8: ; ADDA		0xDDE8-0xDDEF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add  [a+6*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDDF0: ; ADDA		0xDDF0-0xDDF7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add  [a+6*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDDF8: ; ADDA		0xDDF8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add  [a+6*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDDF9: ; ADDA		0xDDF9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add  [a+6*4], edx
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDDFA: ; ADDA		0xDDFA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add  [a+6*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDDFB: ; ADDA		0xDDFB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add  [a+6*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDDFC: ; ADDA		0xDDFC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
add  [a+6*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDFC0: ; ADDA		0xDFC0-0xDFC7
and  edi, byte 7
mov  edx, [d+edi*4]
add  [a+7*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDFC8: ; ADDA		0xDFC8-0xDFCF
and  edi, byte 7
mov  edx, [a+edi*4]
add  [a+7*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDFD0: ; ADDA		0xDFD0-0xDFD7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add  [a+7*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDFD8: ; ADDA		0xDFD8-0xDFDF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add  [a+7*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDFE0: ; ADDA		0xDFE0-0xDFE7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add  [a+7*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDFE8: ; ADDA		0xDFE8-0xDFEF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add  [a+7*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDFF0: ; ADDA		0xDFF0-0xDFF7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add  [a+7*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDFF8: ; ADDA		0xDFF8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add  [a+7*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDFF9: ; ADDA		0xDFF9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add  [a+7*4], edx
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDFFA: ; ADDA		0xDFFA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add  [a+7*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDFFB: ; ADDA		0xDFFB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
add  [a+7*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDFFC: ; ADDA		0xDFFC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
add  [a+7*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90C0: ; SUBA		0x90C0-0x90C7
and  edi, byte 7
movsx    edx, word [d+edi*4]
sub  [a+0*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90C8: ; SUBA		0x90C8-0x90CF
and  edi, byte 7
movsx    edx, word [a+edi*4]
sub  [a+0*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90D0: ; SUBA		0x90D0-0x90D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWordSX
sub  [a+0*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90D8: ; SUBA		0x90D8-0x90DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWordSX
sub  [a+0*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90E0: ; SUBA		0x90E0-0x90E7
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWordSX
sub  [a+0*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90E8: ; SUBA		0x90E8-0x90EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWordSX
sub  [a+0*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90F0: ; SUBA		0x90F0-0x90F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWordSX
sub  [a+0*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90F8: ; SUBA		0x90F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWordSX
sub  [a+0*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90F9: ; SUBA		0x90F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWordSX
sub  [a+0*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90FA: ; SUBA		0x90FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
sub  [a+0*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90FB: ; SUBA		0x90FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
sub  [a+0*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I90FC: ; SUBA		0x90FC
movsx    edx, word [esi]
add  esi, byte 2
sub  [a+0*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92C0: ; SUBA		0x92C0-0x92C7
and  edi, byte 7
movsx    edx, word [d+edi*4]
sub  [a+1*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92C8: ; SUBA		0x92C8-0x92CF
and  edi, byte 7
movsx    edx, word [a+edi*4]
sub  [a+1*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92D0: ; SUBA		0x92D0-0x92D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWordSX
sub  [a+1*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92D8: ; SUBA		0x92D8-0x92DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWordSX
sub  [a+1*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92E0: ; SUBA		0x92E0-0x92E7
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWordSX
sub  [a+1*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92E8: ; SUBA		0x92E8-0x92EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWordSX
sub  [a+1*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92F0: ; SUBA		0x92F0-0x92F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWordSX
sub  [a+1*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92F8: ; SUBA		0x92F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWordSX
sub  [a+1*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92F9: ; SUBA		0x92F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWordSX
sub  [a+1*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92FA: ; SUBA		0x92FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
sub  [a+1*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92FB: ; SUBA		0x92FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
sub  [a+1*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I92FC: ; SUBA		0x92FC
movsx    edx, word [esi]
add  esi, byte 2
sub  [a+1*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94C0: ; SUBA		0x94C0-0x94C7
and  edi, byte 7
movsx    edx, word [d+edi*4]
sub  [a+2*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94C8: ; SUBA		0x94C8-0x94CF
and  edi, byte 7
movsx    edx, word [a+edi*4]
sub  [a+2*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94D0: ; SUBA		0x94D0-0x94D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWordSX
sub  [a+2*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94D8: ; SUBA		0x94D8-0x94DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWordSX
sub  [a+2*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94E0: ; SUBA		0x94E0-0x94E7
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWordSX
sub  [a+2*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94E8: ; SUBA		0x94E8-0x94EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWordSX
sub  [a+2*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94F0: ; SUBA		0x94F0-0x94F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWordSX
sub  [a+2*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94F8: ; SUBA		0x94F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWordSX
sub  [a+2*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94F9: ; SUBA		0x94F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWordSX
sub  [a+2*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94FA: ; SUBA		0x94FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
sub  [a+2*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94FB: ; SUBA		0x94FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
sub  [a+2*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I94FC: ; SUBA		0x94FC
movsx    edx, word [esi]
add  esi, byte 2
sub  [a+2*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96C0: ; SUBA		0x96C0-0x96C7
and  edi, byte 7
movsx    edx, word [d+edi*4]
sub  [a+3*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96C8: ; SUBA		0x96C8-0x96CF
and  edi, byte 7
movsx    edx, word [a+edi*4]
sub  [a+3*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96D0: ; SUBA		0x96D0-0x96D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWordSX
sub  [a+3*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96D8: ; SUBA		0x96D8-0x96DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWordSX
sub  [a+3*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96E0: ; SUBA		0x96E0-0x96E7
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWordSX
sub  [a+3*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96E8: ; SUBA		0x96E8-0x96EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWordSX
sub  [a+3*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96F0: ; SUBA		0x96F0-0x96F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWordSX
sub  [a+3*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96F8: ; SUBA		0x96F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWordSX
sub  [a+3*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96F9: ; SUBA		0x96F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWordSX
sub  [a+3*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96FA: ; SUBA		0x96FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
sub  [a+3*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96FB: ; SUBA		0x96FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
sub  [a+3*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I96FC: ; SUBA		0x96FC
movsx    edx, word [esi]
add  esi, byte 2
sub  [a+3*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98C0: ; SUBA		0x98C0-0x98C7
and  edi, byte 7
movsx    edx, word [d+edi*4]
sub  [a+4*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98C8: ; SUBA		0x98C8-0x98CF
and  edi, byte 7
movsx    edx, word [a+edi*4]
sub  [a+4*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98D0: ; SUBA		0x98D0-0x98D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWordSX
sub  [a+4*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98D8: ; SUBA		0x98D8-0x98DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWordSX
sub  [a+4*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98E0: ; SUBA		0x98E0-0x98E7
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWordSX
sub  [a+4*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98E8: ; SUBA		0x98E8-0x98EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWordSX
sub  [a+4*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98F0: ; SUBA		0x98F0-0x98F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWordSX
sub  [a+4*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98F8: ; SUBA		0x98F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWordSX
sub  [a+4*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98F9: ; SUBA		0x98F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWordSX
sub  [a+4*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98FA: ; SUBA		0x98FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
sub  [a+4*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98FB: ; SUBA		0x98FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
sub  [a+4*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I98FC: ; SUBA		0x98FC
movsx    edx, word [esi]
add  esi, byte 2
sub  [a+4*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9AC0: ; SUBA		0x9AC0-0x9AC7
and  edi, byte 7
movsx    edx, word [d+edi*4]
sub  [a+5*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9AC8: ; SUBA		0x9AC8-0x9ACF
and  edi, byte 7
movsx    edx, word [a+edi*4]
sub  [a+5*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9AD0: ; SUBA		0x9AD0-0x9AD7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWordSX
sub  [a+5*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9AD8: ; SUBA		0x9AD8-0x9ADF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWordSX
sub  [a+5*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9AE0: ; SUBA		0x9AE0-0x9AE7
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWordSX
sub  [a+5*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9AE8: ; SUBA		0x9AE8-0x9AEF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWordSX
sub  [a+5*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9AF0: ; SUBA		0x9AF0-0x9AF7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWordSX
sub  [a+5*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9AF8: ; SUBA		0x9AF8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWordSX
sub  [a+5*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9AF9: ; SUBA		0x9AF9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWordSX
sub  [a+5*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9AFA: ; SUBA		0x9AFA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
sub  [a+5*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9AFB: ; SUBA		0x9AFB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
sub  [a+5*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9AFC: ; SUBA		0x9AFC
movsx    edx, word [esi]
add  esi, byte 2
sub  [a+5*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CC0: ; SUBA		0x9CC0-0x9CC7
and  edi, byte 7
movsx    edx, word [d+edi*4]
sub  [a+6*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CC8: ; SUBA		0x9CC8-0x9CCF
and  edi, byte 7
movsx    edx, word [a+edi*4]
sub  [a+6*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CD0: ; SUBA		0x9CD0-0x9CD7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWordSX
sub  [a+6*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CD8: ; SUBA		0x9CD8-0x9CDF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWordSX
sub  [a+6*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CE0: ; SUBA		0x9CE0-0x9CE7
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWordSX
sub  [a+6*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CE8: ; SUBA		0x9CE8-0x9CEF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWordSX
sub  [a+6*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CF0: ; SUBA		0x9CF0-0x9CF7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWordSX
sub  [a+6*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CF8: ; SUBA		0x9CF8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWordSX
sub  [a+6*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CF9: ; SUBA		0x9CF9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWordSX
sub  [a+6*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CFA: ; SUBA		0x9CFA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
sub  [a+6*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CFB: ; SUBA		0x9CFB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
sub  [a+6*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9CFC: ; SUBA		0x9CFC
movsx    edx, word [esi]
add  esi, byte 2
sub  [a+6*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9EC0: ; SUBA		0x9EC0-0x9EC7
and  edi, byte 7
movsx    edx, word [d+edi*4]
sub  [a+7*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9EC8: ; SUBA		0x9EC8-0x9ECF
and  edi, byte 7
movsx    edx, word [a+edi*4]
sub  [a+7*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9ED0: ; SUBA		0x9ED0-0x9ED7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWordSX
sub  [a+7*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9ED8: ; SUBA		0x9ED8-0x9EDF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWordSX
sub  [a+7*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9EE0: ; SUBA		0x9EE0-0x9EE7
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWordSX
sub  [a+7*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9EE8: ; SUBA		0x9EE8-0x9EEF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWordSX
sub  [a+7*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9EF0: ; SUBA		0x9EF0-0x9EF7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWordSX
sub  [a+7*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9EF8: ; SUBA		0x9EF8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWordSX
sub  [a+7*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9EF9: ; SUBA		0x9EF9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWordSX
sub  [a+7*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9EFA: ; SUBA		0x9EFA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
sub  [a+7*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9EFB: ; SUBA		0x9EFB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadWordSX
sub  [a+7*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9EFC: ; SUBA		0x9EFC
movsx    edx, word [esi]
add  esi, byte 2
sub  [a+7*4], edx
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I91C0: ; SUBA		0x91C0-0x91C7
and  edi, byte 7
mov  edx, [d+edi*4]
sub  [a+0*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I91C8: ; SUBA		0x91C8-0x91CF
and  edi, byte 7
mov  edx, [a+edi*4]
sub  [a+0*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I91D0: ; SUBA		0x91D0-0x91D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub  [a+0*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I91D8: ; SUBA		0x91D8-0x91DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub  [a+0*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I91E0: ; SUBA		0x91E0-0x91E7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub  [a+0*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I91E8: ; SUBA		0x91E8-0x91EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub  [a+0*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I91F0: ; SUBA		0x91F0-0x91F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub  [a+0*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I91F8: ; SUBA		0x91F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub  [a+0*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I91F9: ; SUBA		0x91F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub  [a+0*4], edx
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I91FA: ; SUBA		0x91FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub  [a+0*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I91FB: ; SUBA		0x91FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub  [a+0*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I91FC: ; SUBA		0x91FC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
sub  [a+0*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I93C0: ; SUBA		0x93C0-0x93C7
and  edi, byte 7
mov  edx, [d+edi*4]
sub  [a+1*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I93C8: ; SUBA		0x93C8-0x93CF
and  edi, byte 7
mov  edx, [a+edi*4]
sub  [a+1*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I93D0: ; SUBA		0x93D0-0x93D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub  [a+1*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I93D8: ; SUBA		0x93D8-0x93DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub  [a+1*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I93E0: ; SUBA		0x93E0-0x93E7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub  [a+1*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I93E8: ; SUBA		0x93E8-0x93EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub  [a+1*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I93F0: ; SUBA		0x93F0-0x93F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub  [a+1*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I93F8: ; SUBA		0x93F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub  [a+1*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I93F9: ; SUBA		0x93F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub  [a+1*4], edx
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I93FA: ; SUBA		0x93FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub  [a+1*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I93FB: ; SUBA		0x93FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub  [a+1*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I93FC: ; SUBA		0x93FC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
sub  [a+1*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I95C0: ; SUBA		0x95C0-0x95C7
and  edi, byte 7
mov  edx, [d+edi*4]
sub  [a+2*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I95C8: ; SUBA		0x95C8-0x95CF
and  edi, byte 7
mov  edx, [a+edi*4]
sub  [a+2*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I95D0: ; SUBA		0x95D0-0x95D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub  [a+2*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I95D8: ; SUBA		0x95D8-0x95DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub  [a+2*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I95E0: ; SUBA		0x95E0-0x95E7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub  [a+2*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I95E8: ; SUBA		0x95E8-0x95EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub  [a+2*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I95F0: ; SUBA		0x95F0-0x95F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub  [a+2*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I95F8: ; SUBA		0x95F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub  [a+2*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I95F9: ; SUBA		0x95F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub  [a+2*4], edx
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I95FA: ; SUBA		0x95FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub  [a+2*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I95FB: ; SUBA		0x95FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub  [a+2*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I95FC: ; SUBA		0x95FC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
sub  [a+2*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I97C0: ; SUBA		0x97C0-0x97C7
and  edi, byte 7
mov  edx, [d+edi*4]
sub  [a+3*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I97C8: ; SUBA		0x97C8-0x97CF
and  edi, byte 7
mov  edx, [a+edi*4]
sub  [a+3*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I97D0: ; SUBA		0x97D0-0x97D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub  [a+3*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I97D8: ; SUBA		0x97D8-0x97DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub  [a+3*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I97E0: ; SUBA		0x97E0-0x97E7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub  [a+3*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I97E8: ; SUBA		0x97E8-0x97EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub  [a+3*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I97F0: ; SUBA		0x97F0-0x97F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub  [a+3*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I97F8: ; SUBA		0x97F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub  [a+3*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I97F9: ; SUBA		0x97F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub  [a+3*4], edx
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I97FA: ; SUBA		0x97FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub  [a+3*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I97FB: ; SUBA		0x97FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub  [a+3*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I97FC: ; SUBA		0x97FC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
sub  [a+3*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I99C0: ; SUBA		0x99C0-0x99C7
and  edi, byte 7
mov  edx, [d+edi*4]
sub  [a+4*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I99C8: ; SUBA		0x99C8-0x99CF
and  edi, byte 7
mov  edx, [a+edi*4]
sub  [a+4*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I99D0: ; SUBA		0x99D0-0x99D7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub  [a+4*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I99D8: ; SUBA		0x99D8-0x99DF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub  [a+4*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I99E0: ; SUBA		0x99E0-0x99E7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub  [a+4*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I99E8: ; SUBA		0x99E8-0x99EF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub  [a+4*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I99F0: ; SUBA		0x99F0-0x99F7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub  [a+4*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I99F8: ; SUBA		0x99F8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub  [a+4*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I99F9: ; SUBA		0x99F9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub  [a+4*4], edx
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I99FA: ; SUBA		0x99FA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub  [a+4*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I99FB: ; SUBA		0x99FB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub  [a+4*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I99FC: ; SUBA		0x99FC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
sub  [a+4*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9BC0: ; SUBA		0x9BC0-0x9BC7
and  edi, byte 7
mov  edx, [d+edi*4]
sub  [a+5*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9BC8: ; SUBA		0x9BC8-0x9BCF
and  edi, byte 7
mov  edx, [a+edi*4]
sub  [a+5*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9BD0: ; SUBA		0x9BD0-0x9BD7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub  [a+5*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9BD8: ; SUBA		0x9BD8-0x9BDF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub  [a+5*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9BE0: ; SUBA		0x9BE0-0x9BE7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub  [a+5*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9BE8: ; SUBA		0x9BE8-0x9BEF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub  [a+5*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9BF0: ; SUBA		0x9BF0-0x9BF7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub  [a+5*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9BF8: ; SUBA		0x9BF8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub  [a+5*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9BF9: ; SUBA		0x9BF9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub  [a+5*4], edx
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9BFA: ; SUBA		0x9BFA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub  [a+5*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9BFB: ; SUBA		0x9BFB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub  [a+5*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9BFC: ; SUBA		0x9BFC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
sub  [a+5*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9DC0: ; SUBA		0x9DC0-0x9DC7
and  edi, byte 7
mov  edx, [d+edi*4]
sub  [a+6*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9DC8: ; SUBA		0x9DC8-0x9DCF
and  edi, byte 7
mov  edx, [a+edi*4]
sub  [a+6*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9DD0: ; SUBA		0x9DD0-0x9DD7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub  [a+6*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9DD8: ; SUBA		0x9DD8-0x9DDF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub  [a+6*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9DE0: ; SUBA		0x9DE0-0x9DE7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub  [a+6*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9DE8: ; SUBA		0x9DE8-0x9DEF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub  [a+6*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9DF0: ; SUBA		0x9DF0-0x9DF7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub  [a+6*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9DF8: ; SUBA		0x9DF8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub  [a+6*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9DF9: ; SUBA		0x9DF9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub  [a+6*4], edx
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9DFA: ; SUBA		0x9DFA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub  [a+6*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9DFB: ; SUBA		0x9DFB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub  [a+6*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9DFC: ; SUBA		0x9DFC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
sub  [a+6*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9FC0: ; SUBA		0x9FC0-0x9FC7
and  edi, byte 7
mov  edx, [d+edi*4]
sub  [a+7*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9FC8: ; SUBA		0x9FC8-0x9FCF
and  edi, byte 7
mov  edx, [a+edi*4]
sub  [a+7*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9FD0: ; SUBA		0x9FD0-0x9FD7
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub  [a+7*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9FD8: ; SUBA		0x9FD8-0x9FDF
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub  [a+7*4], edx
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9FE0: ; SUBA		0x9FE0-0x9FE7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub  [a+7*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9FE8: ; SUBA		0x9FE8-0x9FEF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub  [a+7*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9FF0: ; SUBA		0x9FF0-0x9FF7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub  [a+7*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9FF8: ; SUBA		0x9FF8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub  [a+7*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9FF9: ; SUBA		0x9FF9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub  [a+7*4], edx
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9FFA: ; SUBA		0x9FFA
movsx    ebx, word [esi]
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub  [a+7*4], edx
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9FFB: ; SUBA		0x9FFB
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, esi
sub      ebx, ebp
add      esi, byte 2
call ReadLong
sub  [a+7*4], edx
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I9FFC: ; SUBA		0x9FFC
mov  edx, [esi]
add  esi, byte 4
ror  edx, byte 16
sub  [a+7*4], edx
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5000: ; ADDQ		0x5000-0x5007
and  edi, byte 7
add   byte [d+edi*4], 8
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5010: ; ADDQ		0x5010-0x5017
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   dl, byte 8
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5018: ; ADDQ		0x5018-0x501F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   dl, byte 8
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5020: ; ADDQ		0x5020-0x5027
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   dl, byte 8
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5028: ; ADDQ		0x5028-0x502F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   dl, byte 8
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5030: ; ADDQ		0x5030-0x5037
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   dl, byte 8
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5038: ; ADDQ		0x5038
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   dl, byte 8
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5039: ; ADDQ		0x5039
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   dl, byte 8
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5040: ; ADDQ		0x5040-0x5047
and  edi, byte 7
add   word [d+edi*4], 8
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5048: ; ADDQ		0x5048-0x504F
and  edi, byte 7
add   dword [a+edi*4], byte 8
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5050: ; ADDQ		0x5050-0x5057
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   dx, 8
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5058: ; ADDQ		0x5058-0x505F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   dx, 8
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5060: ; ADDQ		0x5060-0x5067
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   dx, 8
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5068: ; ADDQ		0x5068-0x506F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   dx, 8
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5070: ; ADDQ		0x5070-0x5077
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   dx, 8
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5078: ; ADDQ		0x5078
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   dx, 8
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5079: ; ADDQ		0x5079
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   dx, 8
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5080: ; ADDQ		0x5080-0x5087
and  edi, byte 7
add   dword [d+edi*4], byte 8
lahf
seto al
setc byte [x]
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5088: ; ADDQ		0x5088-0x508F
and  edi, byte 7
add   dword [a+edi*4], byte 8
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5090: ; ADDQ		0x5090-0x5097
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   edx, byte 8
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5098: ; ADDQ		0x5098-0x509F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   edx, byte 8
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I50A0: ; ADDQ		0x50A0-0x50A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   edx, byte 8
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I50A8: ; ADDQ		0x50A8-0x50AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   edx, byte 8
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I50B0: ; ADDQ		0x50B0-0x50B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   edx, byte 8
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I50B8: ; ADDQ		0x50B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   edx, byte 8
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I50B9: ; ADDQ		0x50B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   edx, byte 8
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5100: ; SUBQ		0x5100-0x5107
and  edi, byte 7
sub   byte [d+edi*4], 8
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5110: ; SUBQ		0x5110-0x5117
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, byte 8
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5118: ; SUBQ		0x5118-0x511F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   dl, byte 8
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5120: ; SUBQ		0x5120-0x5127
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, byte 8
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5128: ; SUBQ		0x5128-0x512F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   dl, byte 8
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5130: ; SUBQ		0x5130-0x5137
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   dl, byte 8
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5138: ; SUBQ		0x5138
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   dl, byte 8
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5139: ; SUBQ		0x5139
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   dl, byte 8
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5140: ; SUBQ		0x5140-0x5147
and  edi, byte 7
sub   word [d+edi*4], 8
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5148: ; SUBQ		0x5148-0x514F
and  edi, byte 7
sub   dword [a+edi*4], byte 8
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5150: ; SUBQ		0x5150-0x5157
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, 8
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5158: ; SUBQ		0x5158-0x515F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   dx, 8
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5160: ; SUBQ		0x5160-0x5167
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, 8
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5168: ; SUBQ		0x5168-0x516F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   dx, 8
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5170: ; SUBQ		0x5170-0x5177
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   dx, 8
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5178: ; SUBQ		0x5178
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   dx, 8
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5179: ; SUBQ		0x5179
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   dx, 8
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5180: ; SUBQ		0x5180-0x5187
and  edi, byte 7
sub   dword [d+edi*4], byte 8
lahf
seto al
setc byte [x]
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5188: ; SUBQ		0x5188-0x518F
and  edi, byte 7
sub   dword [a+edi*4], byte 8
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5190: ; SUBQ		0x5190-0x5197
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, byte 8
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5198: ; SUBQ		0x5198-0x519F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   edx, byte 8
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I51A0: ; SUBQ		0x51A0-0x51A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, byte 8
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I51A8: ; SUBQ		0x51A8-0x51AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   edx, byte 8
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I51B0: ; SUBQ		0x51B0-0x51B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   edx, byte 8
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I51B8: ; SUBQ		0x51B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   edx, byte 8
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I51B9: ; SUBQ		0x51B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   edx, byte 8
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5200: ; ADDQ		0x5200-0x5207
and  edi, byte 7
add   byte [d+edi*4], 1
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5210: ; ADDQ		0x5210-0x5217
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   dl, byte 1
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5218: ; ADDQ		0x5218-0x521F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   dl, byte 1
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5220: ; ADDQ		0x5220-0x5227
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   dl, byte 1
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5228: ; ADDQ		0x5228-0x522F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   dl, byte 1
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5230: ; ADDQ		0x5230-0x5237
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   dl, byte 1
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5238: ; ADDQ		0x5238
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   dl, byte 1
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5239: ; ADDQ		0x5239
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   dl, byte 1
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5240: ; ADDQ		0x5240-0x5247
and  edi, byte 7
add   word [d+edi*4], 1
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5248: ; ADDQ		0x5248-0x524F
and  edi, byte 7
add   dword [a+edi*4], byte 1
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5250: ; ADDQ		0x5250-0x5257
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   dx, 1
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5258: ; ADDQ		0x5258-0x525F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   dx, 1
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5260: ; ADDQ		0x5260-0x5267
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   dx, 1
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5268: ; ADDQ		0x5268-0x526F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   dx, 1
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5270: ; ADDQ		0x5270-0x5277
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   dx, 1
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5278: ; ADDQ		0x5278
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   dx, 1
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5279: ; ADDQ		0x5279
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   dx, 1
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5280: ; ADDQ		0x5280-0x5287
and  edi, byte 7
add   dword [d+edi*4], byte 1
lahf
seto al
setc byte [x]
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5288: ; ADDQ		0x5288-0x528F
and  edi, byte 7
add   dword [a+edi*4], byte 1
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5290: ; ADDQ		0x5290-0x5297
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   edx, byte 1
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5298: ; ADDQ		0x5298-0x529F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   edx, byte 1
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I52A0: ; ADDQ		0x52A0-0x52A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   edx, byte 1
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I52A8: ; ADDQ		0x52A8-0x52AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   edx, byte 1
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I52B0: ; ADDQ		0x52B0-0x52B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   edx, byte 1
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I52B8: ; ADDQ		0x52B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   edx, byte 1
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I52B9: ; ADDQ		0x52B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   edx, byte 1
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5300: ; SUBQ		0x5300-0x5307
and  edi, byte 7
sub   byte [d+edi*4], 1
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5310: ; SUBQ		0x5310-0x5317
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, byte 1
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5318: ; SUBQ		0x5318-0x531F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   dl, byte 1
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5320: ; SUBQ		0x5320-0x5327
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, byte 1
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5328: ; SUBQ		0x5328-0x532F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   dl, byte 1
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5330: ; SUBQ		0x5330-0x5337
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   dl, byte 1
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5338: ; SUBQ		0x5338
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   dl, byte 1
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5339: ; SUBQ		0x5339
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   dl, byte 1
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5340: ; SUBQ		0x5340-0x5347
and  edi, byte 7
sub   word [d+edi*4], 1
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5348: ; SUBQ		0x5348-0x534F
and  edi, byte 7
sub   dword [a+edi*4], byte 1
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5350: ; SUBQ		0x5350-0x5357
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, 1
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5358: ; SUBQ		0x5358-0x535F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   dx, 1
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5360: ; SUBQ		0x5360-0x5367
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, 1
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5368: ; SUBQ		0x5368-0x536F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   dx, 1
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5370: ; SUBQ		0x5370-0x5377
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   dx, 1
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5378: ; SUBQ		0x5378
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   dx, 1
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5379: ; SUBQ		0x5379
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   dx, 1
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5380: ; SUBQ		0x5380-0x5387
and  edi, byte 7
sub   dword [d+edi*4], byte 1
lahf
seto al
setc byte [x]
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5388: ; SUBQ		0x5388-0x538F
and  edi, byte 7
sub   dword [a+edi*4], byte 1
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5390: ; SUBQ		0x5390-0x5397
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, byte 1
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5398: ; SUBQ		0x5398-0x539F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   edx, byte 1
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I53A0: ; SUBQ		0x53A0-0x53A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, byte 1
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I53A8: ; SUBQ		0x53A8-0x53AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   edx, byte 1
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I53B0: ; SUBQ		0x53B0-0x53B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   edx, byte 1
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I53B8: ; SUBQ		0x53B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   edx, byte 1
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I53B9: ; SUBQ		0x53B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   edx, byte 1
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5400: ; ADDQ		0x5400-0x5407
and  edi, byte 7
add   byte [d+edi*4], 2
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5410: ; ADDQ		0x5410-0x5417
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   dl, byte 2
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5418: ; ADDQ		0x5418-0x541F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   dl, byte 2
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5420: ; ADDQ		0x5420-0x5427
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   dl, byte 2
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5428: ; ADDQ		0x5428-0x542F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   dl, byte 2
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5430: ; ADDQ		0x5430-0x5437
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   dl, byte 2
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5438: ; ADDQ		0x5438
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   dl, byte 2
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5439: ; ADDQ		0x5439
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   dl, byte 2
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5440: ; ADDQ		0x5440-0x5447
and  edi, byte 7
add   word [d+edi*4], 2
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5448: ; ADDQ		0x5448-0x544F
and  edi, byte 7
add   dword [a+edi*4], byte 2
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5450: ; ADDQ		0x5450-0x5457
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   dx, 2
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5458: ; ADDQ		0x5458-0x545F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   dx, 2
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5460: ; ADDQ		0x5460-0x5467
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   dx, 2
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5468: ; ADDQ		0x5468-0x546F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   dx, 2
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5470: ; ADDQ		0x5470-0x5477
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   dx, 2
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5478: ; ADDQ		0x5478
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   dx, 2
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5479: ; ADDQ		0x5479
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   dx, 2
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5480: ; ADDQ		0x5480-0x5487
and  edi, byte 7
add   dword [d+edi*4], byte 2
lahf
seto al
setc byte [x]
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5488: ; ADDQ		0x5488-0x548F
and  edi, byte 7
add   dword [a+edi*4], byte 2
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5490: ; ADDQ		0x5490-0x5497
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   edx, byte 2
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5498: ; ADDQ		0x5498-0x549F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   edx, byte 2
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I54A0: ; ADDQ		0x54A0-0x54A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   edx, byte 2
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I54A8: ; ADDQ		0x54A8-0x54AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   edx, byte 2
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I54B0: ; ADDQ		0x54B0-0x54B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   edx, byte 2
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I54B8: ; ADDQ		0x54B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   edx, byte 2
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I54B9: ; ADDQ		0x54B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   edx, byte 2
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5500: ; SUBQ		0x5500-0x5507
and  edi, byte 7
sub   byte [d+edi*4], 2
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5510: ; SUBQ		0x5510-0x5517
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, byte 2
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5518: ; SUBQ		0x5518-0x551F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   dl, byte 2
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5520: ; SUBQ		0x5520-0x5527
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, byte 2
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5528: ; SUBQ		0x5528-0x552F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   dl, byte 2
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5530: ; SUBQ		0x5530-0x5537
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   dl, byte 2
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5538: ; SUBQ		0x5538
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   dl, byte 2
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5539: ; SUBQ		0x5539
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   dl, byte 2
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5540: ; SUBQ		0x5540-0x5547
and  edi, byte 7
sub   word [d+edi*4], 2
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5548: ; SUBQ		0x5548-0x554F
and  edi, byte 7
sub   dword [a+edi*4], byte 2
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5550: ; SUBQ		0x5550-0x5557
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, 2
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5558: ; SUBQ		0x5558-0x555F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   dx, 2
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5560: ; SUBQ		0x5560-0x5567
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, 2
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5568: ; SUBQ		0x5568-0x556F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   dx, 2
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5570: ; SUBQ		0x5570-0x5577
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   dx, 2
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5578: ; SUBQ		0x5578
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   dx, 2
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5579: ; SUBQ		0x5579
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   dx, 2
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5580: ; SUBQ		0x5580-0x5587
and  edi, byte 7
sub   dword [d+edi*4], byte 2
lahf
seto al
setc byte [x]
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5588: ; SUBQ		0x5588-0x558F
and  edi, byte 7
sub   dword [a+edi*4], byte 2
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5590: ; SUBQ		0x5590-0x5597
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, byte 2
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5598: ; SUBQ		0x5598-0x559F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   edx, byte 2
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I55A0: ; SUBQ		0x55A0-0x55A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, byte 2
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I55A8: ; SUBQ		0x55A8-0x55AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   edx, byte 2
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I55B0: ; SUBQ		0x55B0-0x55B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   edx, byte 2
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I55B8: ; SUBQ		0x55B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   edx, byte 2
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I55B9: ; SUBQ		0x55B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   edx, byte 2
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5600: ; ADDQ		0x5600-0x5607
and  edi, byte 7
add   byte [d+edi*4], 3
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5610: ; ADDQ		0x5610-0x5617
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   dl, byte 3
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5618: ; ADDQ		0x5618-0x561F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   dl, byte 3
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5620: ; ADDQ		0x5620-0x5627
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   dl, byte 3
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5628: ; ADDQ		0x5628-0x562F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   dl, byte 3
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5630: ; ADDQ		0x5630-0x5637
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   dl, byte 3
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5638: ; ADDQ		0x5638
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   dl, byte 3
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5639: ; ADDQ		0x5639
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   dl, byte 3
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5640: ; ADDQ		0x5640-0x5647
and  edi, byte 7
add   word [d+edi*4], 3
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5648: ; ADDQ		0x5648-0x564F
and  edi, byte 7
add   dword [a+edi*4], byte 3
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5650: ; ADDQ		0x5650-0x5657
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   dx, 3
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5658: ; ADDQ		0x5658-0x565F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   dx, 3
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5660: ; ADDQ		0x5660-0x5667
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   dx, 3
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5668: ; ADDQ		0x5668-0x566F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   dx, 3
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5670: ; ADDQ		0x5670-0x5677
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   dx, 3
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5678: ; ADDQ		0x5678
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   dx, 3
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5679: ; ADDQ		0x5679
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   dx, 3
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5680: ; ADDQ		0x5680-0x5687
and  edi, byte 7
add   dword [d+edi*4], byte 3
lahf
seto al
setc byte [x]
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5688: ; ADDQ		0x5688-0x568F
and  edi, byte 7
add   dword [a+edi*4], byte 3
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5690: ; ADDQ		0x5690-0x5697
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   edx, byte 3
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5698: ; ADDQ		0x5698-0x569F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   edx, byte 3
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I56A0: ; ADDQ		0x56A0-0x56A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   edx, byte 3
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I56A8: ; ADDQ		0x56A8-0x56AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   edx, byte 3
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I56B0: ; ADDQ		0x56B0-0x56B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   edx, byte 3
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I56B8: ; ADDQ		0x56B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   edx, byte 3
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I56B9: ; ADDQ		0x56B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   edx, byte 3
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5700: ; SUBQ		0x5700-0x5707
and  edi, byte 7
sub   byte [d+edi*4], 3
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5710: ; SUBQ		0x5710-0x5717
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, byte 3
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5718: ; SUBQ		0x5718-0x571F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   dl, byte 3
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5720: ; SUBQ		0x5720-0x5727
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, byte 3
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5728: ; SUBQ		0x5728-0x572F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   dl, byte 3
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5730: ; SUBQ		0x5730-0x5737
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   dl, byte 3
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5738: ; SUBQ		0x5738
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   dl, byte 3
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5739: ; SUBQ		0x5739
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   dl, byte 3
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5740: ; SUBQ		0x5740-0x5747
and  edi, byte 7
sub   word [d+edi*4], 3
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5748: ; SUBQ		0x5748-0x574F
and  edi, byte 7
sub   dword [a+edi*4], byte 3
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5750: ; SUBQ		0x5750-0x5757
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, 3
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5758: ; SUBQ		0x5758-0x575F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   dx, 3
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5760: ; SUBQ		0x5760-0x5767
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, 3
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5768: ; SUBQ		0x5768-0x576F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   dx, 3
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5770: ; SUBQ		0x5770-0x5777
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   dx, 3
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5778: ; SUBQ		0x5778
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   dx, 3
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5779: ; SUBQ		0x5779
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   dx, 3
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5780: ; SUBQ		0x5780-0x5787
and  edi, byte 7
sub   dword [d+edi*4], byte 3
lahf
seto al
setc byte [x]
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5788: ; SUBQ		0x5788-0x578F
and  edi, byte 7
sub   dword [a+edi*4], byte 3
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5790: ; SUBQ		0x5790-0x5797
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, byte 3
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5798: ; SUBQ		0x5798-0x579F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   edx, byte 3
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I57A0: ; SUBQ		0x57A0-0x57A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, byte 3
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I57A8: ; SUBQ		0x57A8-0x57AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   edx, byte 3
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I57B0: ; SUBQ		0x57B0-0x57B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   edx, byte 3
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I57B8: ; SUBQ		0x57B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   edx, byte 3
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I57B9: ; SUBQ		0x57B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   edx, byte 3
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5800: ; ADDQ		0x5800-0x5807
and  edi, byte 7
add   byte [d+edi*4], 4
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5810: ; ADDQ		0x5810-0x5817
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   dl, byte 4
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5818: ; ADDQ		0x5818-0x581F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   dl, byte 4
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5820: ; ADDQ		0x5820-0x5827
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   dl, byte 4
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5828: ; ADDQ		0x5828-0x582F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   dl, byte 4
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5830: ; ADDQ		0x5830-0x5837
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   dl, byte 4
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5838: ; ADDQ		0x5838
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   dl, byte 4
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5839: ; ADDQ		0x5839
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   dl, byte 4
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5840: ; ADDQ		0x5840-0x5847
and  edi, byte 7
add   word [d+edi*4], 4
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5848: ; ADDQ		0x5848-0x584F
and  edi, byte 7
add   dword [a+edi*4], byte 4
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5850: ; ADDQ		0x5850-0x5857
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   dx, 4
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5858: ; ADDQ		0x5858-0x585F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   dx, 4
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5860: ; ADDQ		0x5860-0x5867
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   dx, 4
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5868: ; ADDQ		0x5868-0x586F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   dx, 4
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5870: ; ADDQ		0x5870-0x5877
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   dx, 4
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5878: ; ADDQ		0x5878
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   dx, 4
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5879: ; ADDQ		0x5879
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   dx, 4
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5880: ; ADDQ		0x5880-0x5887
and  edi, byte 7
add   dword [d+edi*4], byte 4
lahf
seto al
setc byte [x]
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5888: ; ADDQ		0x5888-0x588F
and  edi, byte 7
add   dword [a+edi*4], byte 4
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5890: ; ADDQ		0x5890-0x5897
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   edx, byte 4
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5898: ; ADDQ		0x5898-0x589F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   edx, byte 4
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I58A0: ; ADDQ		0x58A0-0x58A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   edx, byte 4
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I58A8: ; ADDQ		0x58A8-0x58AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   edx, byte 4
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I58B0: ; ADDQ		0x58B0-0x58B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   edx, byte 4
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I58B8: ; ADDQ		0x58B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   edx, byte 4
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I58B9: ; ADDQ		0x58B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   edx, byte 4
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5900: ; SUBQ		0x5900-0x5907
and  edi, byte 7
sub   byte [d+edi*4], 4
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5910: ; SUBQ		0x5910-0x5917
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, byte 4
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5918: ; SUBQ		0x5918-0x591F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   dl, byte 4
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5920: ; SUBQ		0x5920-0x5927
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, byte 4
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5928: ; SUBQ		0x5928-0x592F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   dl, byte 4
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5930: ; SUBQ		0x5930-0x5937
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   dl, byte 4
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5938: ; SUBQ		0x5938
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   dl, byte 4
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5939: ; SUBQ		0x5939
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   dl, byte 4
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5940: ; SUBQ		0x5940-0x5947
and  edi, byte 7
sub   word [d+edi*4], 4
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5948: ; SUBQ		0x5948-0x594F
and  edi, byte 7
sub   dword [a+edi*4], byte 4
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5950: ; SUBQ		0x5950-0x5957
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, 4
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5958: ; SUBQ		0x5958-0x595F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   dx, 4
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5960: ; SUBQ		0x5960-0x5967
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, 4
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5968: ; SUBQ		0x5968-0x596F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   dx, 4
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5970: ; SUBQ		0x5970-0x5977
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   dx, 4
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5978: ; SUBQ		0x5978
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   dx, 4
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5979: ; SUBQ		0x5979
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   dx, 4
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5980: ; SUBQ		0x5980-0x5987
and  edi, byte 7
sub   dword [d+edi*4], byte 4
lahf
seto al
setc byte [x]
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5988: ; SUBQ		0x5988-0x598F
and  edi, byte 7
sub   dword [a+edi*4], byte 4
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5990: ; SUBQ		0x5990-0x5997
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, byte 4
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5998: ; SUBQ		0x5998-0x599F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   edx, byte 4
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I59A0: ; SUBQ		0x59A0-0x59A7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, byte 4
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I59A8: ; SUBQ		0x59A8-0x59AF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   edx, byte 4
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I59B0: ; SUBQ		0x59B0-0x59B7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   edx, byte 4
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I59B8: ; SUBQ		0x59B8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   edx, byte 4
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I59B9: ; SUBQ		0x59B9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   edx, byte 4
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A00: ; ADDQ		0x5A00-0x5A07
and  edi, byte 7
add   byte [d+edi*4], 5
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A10: ; ADDQ		0x5A10-0x5A17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   dl, byte 5
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A18: ; ADDQ		0x5A18-0x5A1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   dl, byte 5
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A20: ; ADDQ		0x5A20-0x5A27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   dl, byte 5
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A28: ; ADDQ		0x5A28-0x5A2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   dl, byte 5
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A30: ; ADDQ		0x5A30-0x5A37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   dl, byte 5
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A38: ; ADDQ		0x5A38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   dl, byte 5
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A39: ; ADDQ		0x5A39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   dl, byte 5
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A40: ; ADDQ		0x5A40-0x5A47
and  edi, byte 7
add   word [d+edi*4], 5
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A48: ; ADDQ		0x5A48-0x5A4F
and  edi, byte 7
add   dword [a+edi*4], byte 5
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A50: ; ADDQ		0x5A50-0x5A57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   dx, 5
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A58: ; ADDQ		0x5A58-0x5A5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   dx, 5
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A60: ; ADDQ		0x5A60-0x5A67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   dx, 5
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A68: ; ADDQ		0x5A68-0x5A6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   dx, 5
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A70: ; ADDQ		0x5A70-0x5A77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   dx, 5
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A78: ; ADDQ		0x5A78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   dx, 5
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A79: ; ADDQ		0x5A79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   dx, 5
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A80: ; ADDQ		0x5A80-0x5A87
and  edi, byte 7
add   dword [d+edi*4], byte 5
lahf
seto al
setc byte [x]
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A88: ; ADDQ		0x5A88-0x5A8F
and  edi, byte 7
add   dword [a+edi*4], byte 5
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A90: ; ADDQ		0x5A90-0x5A97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   edx, byte 5
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5A98: ; ADDQ		0x5A98-0x5A9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   edx, byte 5
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5AA0: ; ADDQ		0x5AA0-0x5AA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   edx, byte 5
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5AA8: ; ADDQ		0x5AA8-0x5AAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   edx, byte 5
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5AB0: ; ADDQ		0x5AB0-0x5AB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   edx, byte 5
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5AB8: ; ADDQ		0x5AB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   edx, byte 5
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5AB9: ; ADDQ		0x5AB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   edx, byte 5
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B00: ; SUBQ		0x5B00-0x5B07
and  edi, byte 7
sub   byte [d+edi*4], 5
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B10: ; SUBQ		0x5B10-0x5B17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, byte 5
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B18: ; SUBQ		0x5B18-0x5B1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   dl, byte 5
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B20: ; SUBQ		0x5B20-0x5B27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, byte 5
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B28: ; SUBQ		0x5B28-0x5B2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   dl, byte 5
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B30: ; SUBQ		0x5B30-0x5B37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   dl, byte 5
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B38: ; SUBQ		0x5B38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   dl, byte 5
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B39: ; SUBQ		0x5B39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   dl, byte 5
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B40: ; SUBQ		0x5B40-0x5B47
and  edi, byte 7
sub   word [d+edi*4], 5
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B48: ; SUBQ		0x5B48-0x5B4F
and  edi, byte 7
sub   dword [a+edi*4], byte 5
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B50: ; SUBQ		0x5B50-0x5B57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, 5
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B58: ; SUBQ		0x5B58-0x5B5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   dx, 5
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B60: ; SUBQ		0x5B60-0x5B67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, 5
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B68: ; SUBQ		0x5B68-0x5B6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   dx, 5
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B70: ; SUBQ		0x5B70-0x5B77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   dx, 5
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B78: ; SUBQ		0x5B78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   dx, 5
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B79: ; SUBQ		0x5B79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   dx, 5
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B80: ; SUBQ		0x5B80-0x5B87
and  edi, byte 7
sub   dword [d+edi*4], byte 5
lahf
seto al
setc byte [x]
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B88: ; SUBQ		0x5B88-0x5B8F
and  edi, byte 7
sub   dword [a+edi*4], byte 5
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B90: ; SUBQ		0x5B90-0x5B97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, byte 5
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5B98: ; SUBQ		0x5B98-0x5B9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   edx, byte 5
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5BA0: ; SUBQ		0x5BA0-0x5BA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, byte 5
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5BA8: ; SUBQ		0x5BA8-0x5BAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   edx, byte 5
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5BB0: ; SUBQ		0x5BB0-0x5BB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   edx, byte 5
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5BB8: ; SUBQ		0x5BB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   edx, byte 5
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5BB9: ; SUBQ		0x5BB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   edx, byte 5
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C00: ; ADDQ		0x5C00-0x5C07
and  edi, byte 7
add   byte [d+edi*4], 6
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C10: ; ADDQ		0x5C10-0x5C17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   dl, byte 6
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C18: ; ADDQ		0x5C18-0x5C1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   dl, byte 6
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C20: ; ADDQ		0x5C20-0x5C27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   dl, byte 6
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C28: ; ADDQ		0x5C28-0x5C2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   dl, byte 6
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C30: ; ADDQ		0x5C30-0x5C37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   dl, byte 6
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C38: ; ADDQ		0x5C38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   dl, byte 6
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C39: ; ADDQ		0x5C39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   dl, byte 6
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C40: ; ADDQ		0x5C40-0x5C47
and  edi, byte 7
add   word [d+edi*4], 6
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C48: ; ADDQ		0x5C48-0x5C4F
and  edi, byte 7
add   dword [a+edi*4], byte 6
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C50: ; ADDQ		0x5C50-0x5C57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   dx, 6
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C58: ; ADDQ		0x5C58-0x5C5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   dx, 6
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C60: ; ADDQ		0x5C60-0x5C67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   dx, 6
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C68: ; ADDQ		0x5C68-0x5C6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   dx, 6
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C70: ; ADDQ		0x5C70-0x5C77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   dx, 6
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C78: ; ADDQ		0x5C78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   dx, 6
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C79: ; ADDQ		0x5C79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   dx, 6
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C80: ; ADDQ		0x5C80-0x5C87
and  edi, byte 7
add   dword [d+edi*4], byte 6
lahf
seto al
setc byte [x]
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C88: ; ADDQ		0x5C88-0x5C8F
and  edi, byte 7
add   dword [a+edi*4], byte 6
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C90: ; ADDQ		0x5C90-0x5C97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   edx, byte 6
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5C98: ; ADDQ		0x5C98-0x5C9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   edx, byte 6
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5CA0: ; ADDQ		0x5CA0-0x5CA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   edx, byte 6
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5CA8: ; ADDQ		0x5CA8-0x5CAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   edx, byte 6
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5CB0: ; ADDQ		0x5CB0-0x5CB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   edx, byte 6
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5CB8: ; ADDQ		0x5CB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   edx, byte 6
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5CB9: ; ADDQ		0x5CB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   edx, byte 6
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D00: ; SUBQ		0x5D00-0x5D07
and  edi, byte 7
sub   byte [d+edi*4], 6
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D10: ; SUBQ		0x5D10-0x5D17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, byte 6
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D18: ; SUBQ		0x5D18-0x5D1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   dl, byte 6
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D20: ; SUBQ		0x5D20-0x5D27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, byte 6
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D28: ; SUBQ		0x5D28-0x5D2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   dl, byte 6
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D30: ; SUBQ		0x5D30-0x5D37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   dl, byte 6
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D38: ; SUBQ		0x5D38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   dl, byte 6
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D39: ; SUBQ		0x5D39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   dl, byte 6
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D40: ; SUBQ		0x5D40-0x5D47
and  edi, byte 7
sub   word [d+edi*4], 6
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D48: ; SUBQ		0x5D48-0x5D4F
and  edi, byte 7
sub   dword [a+edi*4], byte 6
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D50: ; SUBQ		0x5D50-0x5D57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, 6
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D58: ; SUBQ		0x5D58-0x5D5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   dx, 6
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D60: ; SUBQ		0x5D60-0x5D67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, 6
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D68: ; SUBQ		0x5D68-0x5D6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   dx, 6
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D70: ; SUBQ		0x5D70-0x5D77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   dx, 6
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D78: ; SUBQ		0x5D78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   dx, 6
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D79: ; SUBQ		0x5D79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   dx, 6
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D80: ; SUBQ		0x5D80-0x5D87
and  edi, byte 7
sub   dword [d+edi*4], byte 6
lahf
seto al
setc byte [x]
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D88: ; SUBQ		0x5D88-0x5D8F
and  edi, byte 7
sub   dword [a+edi*4], byte 6
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D90: ; SUBQ		0x5D90-0x5D97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, byte 6
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5D98: ; SUBQ		0x5D98-0x5D9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   edx, byte 6
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5DA0: ; SUBQ		0x5DA0-0x5DA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, byte 6
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5DA8: ; SUBQ		0x5DA8-0x5DAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   edx, byte 6
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5DB0: ; SUBQ		0x5DB0-0x5DB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   edx, byte 6
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5DB8: ; SUBQ		0x5DB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   edx, byte 6
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5DB9: ; SUBQ		0x5DB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   edx, byte 6
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E00: ; ADDQ		0x5E00-0x5E07
and  edi, byte 7
add   byte [d+edi*4], 7
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E10: ; ADDQ		0x5E10-0x5E17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
add   dl, byte 7
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E18: ; ADDQ		0x5E18-0x5E1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
add   dl, byte 7
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E20: ; ADDQ		0x5E20-0x5E27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
add   dl, byte 7
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E28: ; ADDQ		0x5E28-0x5E2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
add   dl, byte 7
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E30: ; ADDQ		0x5E30-0x5E37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
add   dl, byte 7
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E38: ; ADDQ		0x5E38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
add   dl, byte 7
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E39: ; ADDQ		0x5E39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
add   dl, byte 7
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E40: ; ADDQ		0x5E40-0x5E47
and  edi, byte 7
add   word [d+edi*4], 7
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E48: ; ADDQ		0x5E48-0x5E4F
and  edi, byte 7
add   dword [a+edi*4], byte 7
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E50: ; ADDQ		0x5E50-0x5E57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
add   dx, 7
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E58: ; ADDQ		0x5E58-0x5E5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
add   dx, 7
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E60: ; ADDQ		0x5E60-0x5E67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
add   dx, 7
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E68: ; ADDQ		0x5E68-0x5E6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
add   dx, 7
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E70: ; ADDQ		0x5E70-0x5E77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
add   dx, 7
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E78: ; ADDQ		0x5E78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
add   dx, 7
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E79: ; ADDQ		0x5E79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
add   dx, 7
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E80: ; ADDQ		0x5E80-0x5E87
and  edi, byte 7
add   dword [d+edi*4], byte 7
lahf
seto al
setc byte [x]
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E88: ; ADDQ		0x5E88-0x5E8F
and  edi, byte 7
add   dword [a+edi*4], byte 7
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E90: ; ADDQ		0x5E90-0x5E97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
add   edx, byte 7
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5E98: ; ADDQ		0x5E98-0x5E9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
add   edx, byte 7
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5EA0: ; ADDQ		0x5EA0-0x5EA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
add   edx, byte 7
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5EA8: ; ADDQ		0x5EA8-0x5EAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
add   edx, byte 7
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5EB0: ; ADDQ		0x5EB0-0x5EB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
add   edx, byte 7
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5EB8: ; ADDQ		0x5EB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
add   edx, byte 7
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5EB9: ; ADDQ		0x5EB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
add   edx, byte 7
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F00: ; SUBQ		0x5F00-0x5F07
and  edi, byte 7
sub   byte [d+edi*4], 7
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F10: ; SUBQ		0x5F10-0x5F17
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, byte 7
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F18: ; SUBQ		0x5F18-0x5F1F
and  edi, byte 7
mov  ebx, [a+edi*4]
cmp  edi, byte 7
cmc
adc  dword [a+edi*4], byte 1
call ReadByte
sub   dl, byte 7
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F20: ; SUBQ		0x5F20-0x5F27
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
mov  ebx, [a+edi*4]
call ReadByte
sub   dl, byte 7
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F28: ; SUBQ		0x5F28-0x5F2F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadByte
sub   dl, byte 7
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F30: ; SUBQ		0x5F30-0x5F37
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadByte
sub   dl, byte 7
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F38: ; SUBQ		0x5F38
movsx    ebx, word [esi]
add      esi, byte 2
call ReadByte
sub   dl, byte 7
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F39: ; SUBQ		0x5F39
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadByte
sub   dl, byte 7
lahf
seto al
setc byte [x]
call WriteByte
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F40: ; SUBQ		0x5F40-0x5F47
and  edi, byte 7
sub   word [d+edi*4], 7
lahf
seto al
setc byte [x]
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F48: ; SUBQ		0x5F48-0x5F4F
and  edi, byte 7
sub   dword [a+edi*4], byte 7
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F50: ; SUBQ		0x5F50-0x5F57
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, 7
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F58: ; SUBQ		0x5F58-0x5F5F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 2
call ReadWord
sub   dx, 7
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 12
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F60: ; SUBQ		0x5F60-0x5F67
and  edi, byte 7
sub  dword [a+edi*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
sub   dx, 7
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 14
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F68: ; SUBQ		0x5F68-0x5F6F
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadWord
sub   dx, 7
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F70: ; SUBQ		0x5F70-0x5F77
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadWord
sub   dx, 7
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F78: ; SUBQ		0x5F78
movsx    ebx, word [esi]
add      esi, byte 2
call ReadWord
sub   dx, 7
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 16
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F79: ; SUBQ		0x5F79
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadWord
sub   dx, 7
lahf
seto al
setc byte [x]
call WriteWord
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F80: ; SUBQ		0x5F80-0x5F87
and  edi, byte 7
sub   dword [d+edi*4], byte 7
lahf
seto al
setc byte [x]
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F88: ; SUBQ		0x5F88-0x5F8F
and  edi, byte 7
sub   dword [a+edi*4], byte 7
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F90: ; SUBQ		0x5F90-0x5F97
and  edi, byte 7
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, byte 7
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5F98: ; SUBQ		0x5F98-0x5F9F
and  edi, byte 7
mov  ebx, [a+edi*4]
add  dword [a+edi*4], byte 4
call ReadLong
sub   edx, byte 7
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5FA0: ; SUBQ		0x5FA0-0x5FA7
and  edi, byte 7
sub  dword [a+edi*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
sub   edx, byte 7
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5FA8: ; SUBQ		0x5FA8-0x5FAF
and  edi, byte 7
movsx    ebx, word [esi]
add      ebx, [a+edi*4]
add      esi, byte 2
call ReadLong
sub   edx, byte 7
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5FB0: ; SUBQ		0x5FB0-0x5FB7
and      edi, byte 7
xor      ebx, ebx
mov      bx, [esi]
movsx    edx, bl
add      esi, byte 2
shr      ebx, byte 12
mov      ebx, [d+ebx*4]
jc       short .ll
movsx    ebx, bx
.ll:
add      ebx, edx
add      ebx, [a+edi*4]
call ReadLong
sub   edx, byte 7
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 26
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5FB8: ; SUBQ		0x5FB8
movsx    ebx, word [esi]
add      esi, byte 2
call ReadLong
sub   edx, byte 7
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I5FB9: ; SUBQ		0x5FB9
mov      ebx, [esi]
ror      ebx, byte 16
add      esi, byte 4
call ReadLong
sub   edx, byte 7
lahf
seto al
setc byte [x]
call WriteLong
sub  ecx, byte 28
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID100: ; ADDX		0xD100-0xD107
and  edi, byte 7
mov  bl, [d+0*4]
mov  dl, [d+edi*4]
shr  byte [x], 1
adc  bl, dl
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+0*4], bl
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID108: ; ADDX		0xD108-0xD10F
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
dec  dword [a+0*4]
mov  ebx, [a+edi*4]
call ReadByte
mov  [run_edx], edx
mov  ebx, [a+0*4]
call ReadByte
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  bl, dl
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID140: ; ADDX		0xD140-0xD147
and  edi, byte 7
mov  ebx, [d+0*4]
mov  edx, [d+edi*4]
shr  byte [x], 1
adc  bx, dx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+0*4], bx
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID148: ; ADDX		0xD148-0xD14F
and  edi, byte 7
sub  dword [a+edi*4], byte 2
sub  dword [a+0*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
mov  [run_edx], edx
mov  ebx, [a+0*4]
call ReadWord
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  bx, dx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID180: ; ADDX		0xD180-0xD187
and  edi, byte 7
mov  ebx, [d+0*4]
mov  edx, [d+edi*4]
shr  byte [x], 1
adc  ebx, edx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+0*4], ebx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID188: ; ADDX		0xD188-0xD18F
and  edi, byte 7
sub  dword [a+edi*4], byte 4
sub  dword [a+0*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
mov  [run_edx], edx
mov  ebx, [a+0*4]
call ReadLong
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  ebx, edx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteLong
sub  ecx, byte 30
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID300: ; ADDX		0xD300-0xD307
and  edi, byte 7
mov  bl, [d+1*4]
mov  dl, [d+edi*4]
shr  byte [x], 1
adc  bl, dl
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+1*4], bl
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID308: ; ADDX		0xD308-0xD30F
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
dec  dword [a+1*4]
mov  ebx, [a+edi*4]
call ReadByte
mov  [run_edx], edx
mov  ebx, [a+1*4]
call ReadByte
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  bl, dl
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID340: ; ADDX		0xD340-0xD347
and  edi, byte 7
mov  ebx, [d+1*4]
mov  edx, [d+edi*4]
shr  byte [x], 1
adc  bx, dx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+1*4], bx
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID348: ; ADDX		0xD348-0xD34F
and  edi, byte 7
sub  dword [a+edi*4], byte 2
sub  dword [a+1*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
mov  [run_edx], edx
mov  ebx, [a+1*4]
call ReadWord
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  bx, dx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID380: ; ADDX		0xD380-0xD387
and  edi, byte 7
mov  ebx, [d+1*4]
mov  edx, [d+edi*4]
shr  byte [x], 1
adc  ebx, edx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+1*4], ebx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID388: ; ADDX		0xD388-0xD38F
and  edi, byte 7
sub  dword [a+edi*4], byte 4
sub  dword [a+1*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
mov  [run_edx], edx
mov  ebx, [a+1*4]
call ReadLong
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  ebx, edx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteLong
sub  ecx, byte 30
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID500: ; ADDX		0xD500-0xD507
and  edi, byte 7
mov  bl, [d+2*4]
mov  dl, [d+edi*4]
shr  byte [x], 1
adc  bl, dl
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+2*4], bl
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID508: ; ADDX		0xD508-0xD50F
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
dec  dword [a+2*4]
mov  ebx, [a+edi*4]
call ReadByte
mov  [run_edx], edx
mov  ebx, [a+2*4]
call ReadByte
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  bl, dl
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID540: ; ADDX		0xD540-0xD547
and  edi, byte 7
mov  ebx, [d+2*4]
mov  edx, [d+edi*4]
shr  byte [x], 1
adc  bx, dx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+2*4], bx
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID548: ; ADDX		0xD548-0xD54F
and  edi, byte 7
sub  dword [a+edi*4], byte 2
sub  dword [a+2*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
mov  [run_edx], edx
mov  ebx, [a+2*4]
call ReadWord
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  bx, dx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID580: ; ADDX		0xD580-0xD587
and  edi, byte 7
mov  ebx, [d+2*4]
mov  edx, [d+edi*4]
shr  byte [x], 1
adc  ebx, edx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+2*4], ebx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID588: ; ADDX		0xD588-0xD58F
and  edi, byte 7
sub  dword [a+edi*4], byte 4
sub  dword [a+2*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
mov  [run_edx], edx
mov  ebx, [a+2*4]
call ReadLong
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  ebx, edx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteLong
sub  ecx, byte 30
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID700: ; ADDX		0xD700-0xD707
and  edi, byte 7
mov  bl, [d+3*4]
mov  dl, [d+edi*4]
shr  byte [x], 1
adc  bl, dl
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+3*4], bl
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID708: ; ADDX		0xD708-0xD70F
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
dec  dword [a+3*4]
mov  ebx, [a+edi*4]
call ReadByte
mov  [run_edx], edx
mov  ebx, [a+3*4]
call ReadByte
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  bl, dl
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID740: ; ADDX		0xD740-0xD747
and  edi, byte 7
mov  ebx, [d+3*4]
mov  edx, [d+edi*4]
shr  byte [x], 1
adc  bx, dx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+3*4], bx
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID748: ; ADDX		0xD748-0xD74F
and  edi, byte 7
sub  dword [a+edi*4], byte 2
sub  dword [a+3*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
mov  [run_edx], edx
mov  ebx, [a+3*4]
call ReadWord
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  bx, dx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID780: ; ADDX		0xD780-0xD787
and  edi, byte 7
mov  ebx, [d+3*4]
mov  edx, [d+edi*4]
shr  byte [x], 1
adc  ebx, edx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+3*4], ebx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID788: ; ADDX		0xD788-0xD78F
and  edi, byte 7
sub  dword [a+edi*4], byte 4
sub  dword [a+3*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
mov  [run_edx], edx
mov  ebx, [a+3*4]
call ReadLong
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  ebx, edx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteLong
sub  ecx, byte 30
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID900: ; ADDX		0xD900-0xD907
and  edi, byte 7
mov  bl, [d+4*4]
mov  dl, [d+edi*4]
shr  byte [x], 1
adc  bl, dl
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+4*4], bl
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID908: ; ADDX		0xD908-0xD90F
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
dec  dword [a+4*4]
mov  ebx, [a+edi*4]
call ReadByte
mov  [run_edx], edx
mov  ebx, [a+4*4]
call ReadByte
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  bl, dl
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID940: ; ADDX		0xD940-0xD947
and  edi, byte 7
mov  ebx, [d+4*4]
mov  edx, [d+edi*4]
shr  byte [x], 1
adc  bx, dx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+4*4], bx
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID948: ; ADDX		0xD948-0xD94F
and  edi, byte 7
sub  dword [a+edi*4], byte 2
sub  dword [a+4*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
mov  [run_edx], edx
mov  ebx, [a+4*4]
call ReadWord
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  bx, dx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID980: ; ADDX		0xD980-0xD987
and  edi, byte 7
mov  ebx, [d+4*4]
mov  edx, [d+edi*4]
shr  byte [x], 1
adc  ebx, edx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+4*4], ebx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
ID988: ; ADDX		0xD988-0xD98F
and  edi, byte 7
sub  dword [a+edi*4], byte 4
sub  dword [a+4*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
mov  [run_edx], edx
mov  ebx, [a+4*4]
call ReadLong
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  ebx, edx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteLong
sub  ecx, byte 30
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB00: ; ADDX		0xDB00-0xDB07
and  edi, byte 7
mov  bl, [d+5*4]
mov  dl, [d+edi*4]
shr  byte [x], 1
adc  bl, dl
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+5*4], bl
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB08: ; ADDX		0xDB08-0xDB0F
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
dec  dword [a+5*4]
mov  ebx, [a+edi*4]
call ReadByte
mov  [run_edx], edx
mov  ebx, [a+5*4]
call ReadByte
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  bl, dl
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB40: ; ADDX		0xDB40-0xDB47
and  edi, byte 7
mov  ebx, [d+5*4]
mov  edx, [d+edi*4]
shr  byte [x], 1
adc  bx, dx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+5*4], bx
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB48: ; ADDX		0xDB48-0xDB4F
and  edi, byte 7
sub  dword [a+edi*4], byte 2
sub  dword [a+5*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
mov  [run_edx], edx
mov  ebx, [a+5*4]
call ReadWord
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  bx, dx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB80: ; ADDX		0xDB80-0xDB87
and  edi, byte 7
mov  ebx, [d+5*4]
mov  edx, [d+edi*4]
shr  byte [x], 1
adc  ebx, edx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+5*4], ebx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDB88: ; ADDX		0xDB88-0xDB8F
and  edi, byte 7
sub  dword [a+edi*4], byte 4
sub  dword [a+5*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
mov  [run_edx], edx
mov  ebx, [a+5*4]
call ReadLong
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  ebx, edx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteLong
sub  ecx, byte 30
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD00: ; ADDX		0xDD00-0xDD07
and  edi, byte 7
mov  bl, [d+6*4]
mov  dl, [d+edi*4]
shr  byte [x], 1
adc  bl, dl
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+6*4], bl
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD08: ; ADDX		0xDD08-0xDD0F
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
dec  dword [a+6*4]
mov  ebx, [a+edi*4]
call ReadByte
mov  [run_edx], edx
mov  ebx, [a+6*4]
call ReadByte
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  bl, dl
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD40: ; ADDX		0xDD40-0xDD47
and  edi, byte 7
mov  ebx, [d+6*4]
mov  edx, [d+edi*4]
shr  byte [x], 1
adc  bx, dx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+6*4], bx
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD48: ; ADDX		0xDD48-0xDD4F
and  edi, byte 7
sub  dword [a+edi*4], byte 2
sub  dword [a+6*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
mov  [run_edx], edx
mov  ebx, [a+6*4]
call ReadWord
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  bx, dx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD80: ; ADDX		0xDD80-0xDD87
and  edi, byte 7
mov  ebx, [d+6*4]
mov  edx, [d+edi*4]
shr  byte [x], 1
adc  ebx, edx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+6*4], ebx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDD88: ; ADDX		0xDD88-0xDD8F
and  edi, byte 7
sub  dword [a+edi*4], byte 4
sub  dword [a+6*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
mov  [run_edx], edx
mov  ebx, [a+6*4]
call ReadLong
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  ebx, edx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteLong
sub  ecx, byte 30
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF00: ; ADDX		0xDF00-0xDF07
and  edi, byte 7
mov  bl, [d+7*4]
mov  dl, [d+edi*4]
shr  byte [x], 1
adc  bl, dl
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+7*4], bl
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF08: ; ADDX		0xDF08-0xDF0F
and  edi, byte 7
cmp  edi, byte 7
cmc
sbb  dword [a+edi*4], byte 1
sub  dword [a+7*4], byte 2
mov  ebx, [a+edi*4]
call ReadByte
mov  [run_edx], edx
mov  ebx, [a+7*4]
call ReadByte
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  bl, dl
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteByte
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF40: ; ADDX		0xDF40-0xDF47
and  edi, byte 7
mov  ebx, [d+7*4]
mov  edx, [d+edi*4]
shr  byte [x], 1
adc  bx, dx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+7*4], bx
sub  ecx, byte 4
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF48: ; ADDX		0xDF48-0xDF4F
and  edi, byte 7
sub  dword [a+edi*4], byte 2
sub  dword [a+7*4], byte 2
mov  ebx, [a+edi*4]
call ReadWord
mov  [run_edx], edx
mov  ebx, [a+7*4]
call ReadWord
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  bx, dx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteWord
sub  ecx, byte 18
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF80: ; ADDX		0xDF80-0xDF87
and  edi, byte 7
mov  ebx, [d+7*4]
mov  edx, [d+edi*4]
shr  byte [x], 1
adc  ebx, edx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  [d+7*4], ebx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IDF88: ; ADDX		0xDF88-0xDF8F
and  edi, byte 7
sub  dword [a+edi*4], byte 4
sub  dword [a+7*4], byte 4
mov  ebx, [a+edi*4]
call ReadLong
mov  [run_edx], edx
mov  ebx, [a+7*4]
call ReadLong
mov  [run_ebx], ebx
mov  ebx, edx
mov  edx, [run_edx]
shr  byte [x], 1
adc  ebx, edx
mov  dl, ah
lahf
setc byte [x]
seto al
jnz  short .z
and  dl, 0x40
and  ah, 0xbf
or   ah, dl
.z:
mov  edx, ebx
mov  ebx, [run_ebx]
call WriteLong
sub  ecx, byte 30
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I023C: ; ANDI to CCR		0x023C
and      eax, 0xc101
mov      dh, ah
shr      dh, byte 4
shl      al, byte 1
or       dh, al
shr      ah, byte 1
adc      dh, 0
mov      ah, [x]
shl      ah, byte 4
or       dh, ah
mov      [sr], dh
mov  dl, [esi]
and  dl, 0x1f
and  [sr], dl
add  esi, byte 2
mov      dh, [sr]
mov      ah, dh
shl      ah, byte 4
test     dh, byte 2
setnz    al
test     dh, 0x10
setnz    byte [x]
and      dh, byte 1
or       ah, dh
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
I027C: ; ANDI to SR		0x027C
test byte [sr+1], 0x20
jz   near exception_privilege_violation
and      eax, 0xc101
mov      dh, ah
shr      dh, byte 4
shl      al, byte 1
or       dh, al
shr      ah, byte 1
adc      dh, 0
mov      ah, [x]
shl      ah, byte 4
or       dh, ah
mov      [sr], dh
mov  edx, [esi]
and  edx, 0xa71f
and  [sr], dx
add  esi, byte 2
mov      dh, [sr]
mov      ah, dh
shl      ah, byte 4
test     dh, byte 2
setnz    al
test     dh, 0x10
setnz    byte [x]
and      dh, byte 1
or       ah, dh
test byte [sr+1], 0x20
jnz  short .in_s
mov  ebx, [a+7*4]
mov  edx, [__sp]
mov  [a+7*4], edx
mov  [__sp], ebx
.in_s:
sub  ecx, byte 20
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IE000: ; ASR		0xE000-0xE007
and  edi, byte 7
sar  byte [d+edi*4], 8
lahf
setc byte [x]
xor  al, al
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IE020: ; ASR		0xE020-0xE027
and  edi, byte 7
mov  ebx, ecx
mov  ecx, [d+0*4]
and  ecx, byte 0x3f
mov  dl, [d+edi*4]
sar  dl, cl
setc bl
test dl, dl
lahf
test cl, cl
jz   short .no_x
or   ah, bl
test     ah, 1
setnz    byte [x]
.no_x:
mov  [d+edi*4], dl
xor  al, al
shl  cl, byte 1
add  cl, byte 6
neg  ecx
add  ecx, ebx
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IE040: ; ASR		0xE040-0xE047
and  edi, byte 7
sar  word [d+edi*4], 8
lahf
setc byte [x]
xor  al, al
sub  ecx, byte 22
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IE060: ; ASR		0xE060-0xE067
and  edi, byte 7
mov  ebx, ecx
mov  ecx, [d+0*4]
and  ecx, byte 0x3f
mov  edx, [d+edi*4]
sar  dx, cl
setc bl
test dx, dx
lahf
test cl, cl
jz   short .no_x
or   ah, bl
test     ah, 1
setnz    byte [x]
.no_x:
mov  [d+edi*4], dx
xor  al, al
shl  cl, byte 1
add  cl, byte 6
neg  ecx
add  ecx, ebx
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IE080: ; ASR		0xE080-0xE087
and  edi, byte 7
sar  dword [d+edi*4], 8
lahf
setc byte [x]
xor  al, al
sub  ecx, byte 24
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IE0A0: ; ASR		0xE0A0-0xE0A7
and  edi, byte 7
mov  ebx, ecx
mov  ecx, [d+0*4]
and  ecx, byte 0x3f
mov  edx, [d+edi*4]
sar  edx, cl
setc bl
test edx, edx
lahf
test cl, cl
jz   short .no_x
or   ah, bl
test     ah, 1
setnz    byte [x]
.no_x:
mov  [d+edi*4], edx
xor  al, al
shl  cl, byte 1
add  cl, byte 8
neg  ecx
add  ecx, ebx
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IE100: ; ASL		0xE100-0xE107
and  edi, byte 7
xor  al, al
mov  dl, [d+edi*4]
shl  dl, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  dl, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  dl, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  dl, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  dl, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  dl, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  dl, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  dl, 1
lahf
setc byte [x]
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
mov  [d+edi*4], dl
sub  ecx, byte 6
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IE120: ; ASL		0xE120-0xE127
and  edi, byte 7
xor  al, al
mov  [run_edi], edi
mov  edx, [d+edi*4]
mov  edi, [d+0*4]
and  edi, byte 0x3f
jz   short .zero_shift
.loop:
shl  dl, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
dec  edi
jnz  short .loop
mov  edi, [run_edi]
mov  [d+edi*4], dl
test dl, dl
lahf
or   ah, bl
test bl, bl
setnz byte [x]
jmp  short .end
.zero_shift:
test dl, dl
lahf
xor  al, al
.end:
sub  ecx, byte 6
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IE140: ; ASL		0xE140-0xE147
and  edi, byte 7
xor  al, al
mov  dx, [d+edi*4]
shl  dx, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  dx, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  dx, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  dx, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  dx, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  dx, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  dx, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  dx, 1
lahf
setc byte [x]
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
mov  [d+edi*4], dx
sub  ecx, byte 6
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IE160: ; ASL		0xE160-0xE167
and  edi, byte 7
xor  al, al
mov  [run_edi], edi
mov  edx, [d+edi*4]
mov  edi, [d+0*4]
and  edi, byte 0x3f
jz   short .zero_shift
.loop:
shl  dx, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
dec  edi
jnz  short .loop
mov  edi, [run_edi]
mov  [d+edi*4], dx
test dx, dx
lahf
or   ah, bl
test bl, bl
setnz byte [x]
jmp  short .end
.zero_shift:
test dx, dx
lahf
xor  al, al
.end:
sub  ecx, byte 6
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IE180: ; ASL		0xE180-0xE187
and  edi, byte 7
xor  al, al
mov  edx, [d+edi*4]
shl  edx, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  edx, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  edx, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  edx, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  edx, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  edx, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  edx, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
shl  edx, 1
lahf
setc byte [x]
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
mov  [d+edi*4], edx
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IE1A0: ; ASL		0xE1A0-0xE1A7
and  edi, byte 7
xor  al, al
mov  [run_edi], edi
mov  edx, [d+edi*4]
mov  edi, [d+0*4]
and  edi, byte 0x3f
jz   short .zero_shift
.loop:
shl  edx, 1
setc bl
sets bh
xor  bh, bl
or   al, bh
sub  ecx, byte 2
dec  edi
jnz  short .loop
mov  edi, [run_edi]
mov  [d+edi*4], edx
test edx, edx
lahf
or   ah, bl
test bl, bl
setnz byte [x]
jmp  short .end
.zero_shift:
test edx, edx
lahf
xor  al, al
.end:
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IE200: ; ASR		0xE200-0xE207
and  edi, byte 7
sar  byte [d+edi*4], 1
lahf
setc byte [x]
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IE220: ; ASR		0xE220-0xE227
and  edi, byte 7
mov  ebx, ecx
mov  ecx, [d+1*4]
and  ecx, byte 0x3f
mov  dl, [d+edi*4]
sar  dl, cl
setc bl
test dl, dl
lahf
test cl, cl
jz   short .no_x
or   ah, bl
test     ah, 1
setnz    byte [x]
.no_x:
mov  [d+edi*4], dl
xor  al, al
shl  cl, byte 1
add  cl, byte 6
neg  ecx
add  ecx, ebx
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IE240: ; ASR		0xE240-0xE247
and  edi, byte 7
sar  word [d+edi*4], 1
lahf
setc byte [x]
xor  al, al
sub  ecx, byte 8
js   near Genital68KRun_done
mov  di, [esi]
add  esi, byte 2
jmp  dword [jmptab+edi*4]
times ($$-$) & 3 nop
IE260: ; ASR		0xE260-0xE267
and  edi, byte 7
mov  ebx, ecx
mov  ecx, [d+1*4]
and  ecx, byte 0x3f
mov  edx, [d+edi*4]
sar  dx, cl
setc bl
test dx, dx
lahf
test cl, cl
jz   short .no_x
or   ah, bl
test     ah, 1
setnz    byte [x]
.no_x:
mov  [d+edi*4], dx
xor  al, al
shl  cl, byte 1
add 