// CDROM.H
// Titan Win32 CD Routine Header File

#ifndef _CDROM_H
#define _CDROM_H

#include "plugin.h"

#define DLLEXPORT	__declspec(dllexport)

#define CD_CMOK	0x0001
#define CD_DRDY	0x0002
#define CD_CSCT	0x0004
#define CD_BFUL	0x0008
#define CD_PEND	0x0010
#define CD_DCHG	0x0020
#define CD_ESEL	0x0040
#define CD_EHST	0x0080
#define CD_ECPY	0x0100
#define CD_EFLS	0x0200
#define CD_SCDQ	0x0400

/*#define CD_MPED	0x0800
#define CD_MPCM	0x1000
#define CD_MPST	0x2000*/

#define CDC_ERR_CMDBUSY	-1
#define CDC_ERR_CMDNG	-2
#define CDC_ERR_TMOUT	-3
#define CDC_ERR_PUT		-4
#define CDC_ERR_REJECT	-5
#define CDC_ERR_WAIT	-6
#define CDC_ERR_TRNS	-7
#define CDC_ERR_PERI	-8  

#define CD_ST_BUSY     0x00
#define CD_ST_PAUSE    0x01
#define CD_ST_STANDBY  0x02
#define CD_ST_PLAY     0x03
#define CD_ST_SEEK     0x04
#define CD_ST_SCAN     0x05
#define CD_ST_OPEN     0x06
#define CD_ST_NODISC   0x27
#define CD_ST_RETRY    0x08
#define CD_ST_ERROR    0x09
#define CD_ST_FATAL    0x0A

void DLLEXPORT PLUGINCALL SAT_PlugInfo(tagPlugInfo*);
int DLLEXPORT PLUGINCALL SCD_InitPlugin(unsigned long);
int DLLEXPORT PLUGINCALL SCD_StartPlugin(void);
void DLLEXPORT PLUGINCALL SCD_StopPlugin(void);
void DLLEXPORT PLUGINCALL SCD_FreePlugin(void);

void DLLEXPORT PLUGINCALL SCD_WriteRegs(unsigned long, unsigned long);
unsigned short DLLEXPORT PLUGINCALL SCD_ReadRegs(unsigned long);


#endif
