// PLUGIN.H
// Titan Plugin Structures

#ifndef _PLUGIN_H
#define _PLUGIN_H

#define SAT_VDP_PLUGIN	0
#define SAT_SND_PLUGIN	1
#define SAT_SCD_PLUGIN	2
#define SAT_PAD_PLUGIN	3

#ifdef __GNUC__
#define PLUGINCALL
#else
#define	PLUGINCALL __stdcall
#endif

typedef struct {
	char *name;
	unsigned char plugType;
	unsigned long plugVersion;
} tagPlugInfo;

typedef void (PLUGINCALL *PlugInfo)(tagPlugInfo*);

typedef void (PLUGINCALL *voidPlugCall)(void);
typedef int (PLUGINCALL *retPlugCall)(void);

// VDP Function Prototypes
typedef int (PLUGINCALL *VDPInit)(unsigned char*, unsigned char*, unsigned long);
typedef void (PLUGINCALL *VDPRegs)(unsigned long);

// SCU Function Prototypes
typedef int (PLUGINCALL *SCDInit)(unsigned long);
typedef void (PLUGINCALL *SCDWrite)(unsigned long, unsigned long);
typedef unsigned short (PLUGINCALL *SCDRead)(unsigned long);

#endif