// DYNAMAP.C
// Titan SH2 Dynamic Recompilation Routines

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "dynamap.h"
#include "sh2.h"
#include "mem.h"

int blockCount;

Block *dynaInit(Block *dynaCode)
{
	dynaCode = (Block*)ALLOCATE(sizeof(Block)*NUMOFBLOCKS);
	memset((void*)dynaCode, 0, sizeof(Block)*NUMOFBLOCKS); 
	blockCount = 0;
	return dynaCode;
}

int dynaCheckPC(tagSH2 *sh2, Block *dynaCode)
{
	unsigned int register i;

	// check to see if current PC is already generated
	for (i=0;i<NUMOFBLOCKS;i++)
	{
		if (dynaCode[i].reserved == (unsigned long)sh2) 
		{
			if (PC >= dynaCode[i].b_addr && PC <= dynaCode[i].e_addr) {
				blockCount = i;
				return 1;
			}
		}
	}
	return 0;
}

void dynaMakeBlock(tagSH2 *sh2, Block *dynaCode)
{
	dynaCode[blockCount].b_addr = PC;
	dynaCode[blockCount].reserved = (unsigned long)sh2;

	xlatPage(&dynaCode[blockCount]);
}
