// DYNAMAP.H
// Titan SH2 Dynamic Recompilation Routines

#ifndef _DYNAMAP_H
#define _DYNAMAP_H

#include "sh2.h"

#if defined(__i386__) || defined(_M_IX86)
#include "./Cpu/i386/dynalib.h"
#endif

typedef void (*dynaFunc)(tagSH2*, uint32);

typedef struct {
	unsigned char code[MAXBLOCKSIZE];
	//unsigned char numofinstr;
	unsigned long b_addr; //beginning PC
	unsigned long e_addr; //ending PC
	unsigned long reserved;
} Block;

extern int blockCount;

// Universal CPU Specific
Block *dynaInit(Block*);
int dynaCheckPC(tagSH2*, Block*);
void dynaMakeBlock(tagSH2*, Block*);
void dynaExecute(tagSH2*, Block*);

void xlatPage(Block *page);
#endif