// GLOBAL.H
// Titan Global Settings

#ifndef _GLOBAL_H
#define _GLOBAL_H

#include <stdarg.h>
#include "plugin.h"

#define uint8	unsigned char
#define uint16	unsigned short
#define uint32	unsigned long

#ifdef __GNUC__
#define uint64	unsigned long long
#define sint64	signed long long

#define FALSE	0
#define TRUE	1

#ifndef NULL
#define NULL	0
#endif

#define ASM(x)	__asm__ __volatile__ (#x)

#define FASTCALL //__attribute__ ((regparm(1)))
#define NAKED	__attribute__ ( naked )
#else
#define uint64	unsigned __int64
#define sint64	__int64

#define ASM(x)	__asm ##x

#define	FASTCALL __fastcall
#define NAKED	 __declspec( naked ) 
#endif

#define MSG_NORM	0
#define MSG_WARN	1
#define MSG_FATAL	2

#define EMU_STOP	0
#define EMU_RUN		1
#define EMU_PAUSE	2

// Global Options
//#define CPU_PROFILING
//#define TITAN_DEBUG

unsigned short swapWord(unsigned short);
unsigned long swapLong(unsigned long);

#ifdef WIN32
#include <windows.h>

extern HWND g_hWnd;
extern HINSTANCE g_hInst;

#define VDP_INIT		((VDPInit)GetProcAddress(DLL_VDP, "_VDP_InitPlugin@12"))
#define VDP_UPD_REGS(x)	((VDPRegs)GetProcAddress(DLL_VDP, "_VDP_UpdateRegs@4"))(x)
#define	VDP_FUNC(x, y)	((x)GetProcAddress(DLL_VDP, "_##y##@0"))

#define SCD_INIT		((SCDInit)GetProcAddress(DLL_SCD, "_SCD_InitPlugin@4"))
#define SCD_READ(x)		((SCDRead)GetProcAddress(DLL_SCD, "_SCD_ReadRegs@4"))(x)
#define SCD_WRITE(x, y)	((SCDWrite)GetProcAddress(DLL_SCD, "_SCD_WriteRegs@8"))(x, y)
#define	SCD_FUNC(x, y)	((x)GetProcAddress(DLL_SCD, "_##y##@0"))

extern HINSTANCE DLL_VDP, DLL_SND, DLL_SCD;
#else

#define VDP_UPD_REGS(x)		VDP_UpdateRegs(x)
#define VDP_INIT(x, y, z)	VDP_InitPlugin(x, y, z)

#define SCD_INIT(x)			SCD_InitPlugin(x)
#define SCD_READ(x)			SCD_ReadRegs(x)
#define SCD_WRITE(x, y)		SCD_WriteRegs(x, y)

#define GENERIC_MEM_FUNC

#endif

#ifdef TITAN_DEBUG
#include "debug.h"

#define MSG_DEBUG	3
#endif

// Platform Dependance
#if defined(__i386__) || defined(_M_IX86)
#define LSB_FIRST

#else
#define GENERIC_MEM_FUNC

#endif

extern uint8 EmuStatus;

typedef struct {
	uint8	CountryCode;
	uint8	ConsoleLog;
	uint8	Engine;
	uint8	AreaCode;
	char BIOSFile[255], VDPModule[255], SPUModule[255], SCDModule[255];
} tagPrefs;

extern tagPrefs Settings;

typedef struct {
	uint8	EmuStatus;
	uint8	SlaveEnabled;
	uint8	SoundEnabled;
	uint8	ResetEnabled;
} tagInternal;

extern tagInternal Flags;

// Console & Settings Functions
int emuStartUp(void);
void emuCleanUp(void);
int loadINISettings(void);
void ConsoleMsg(int flag, char *message, ...);

// Emulation Functions
void emulate(void);
void dynaEmulate(void);

//Plugin Functions
extern int initModules(void);
extern int startModules(void);
extern void stopModules(void);
extern void freeModules(void);

#endif