// MEM.H
// Titan Memory Header

#ifndef _MEM_H
#define _MEM_H

#ifdef WIN32
#define ALLOCATE(x)	GlobalAlloc(GMEM_FIXED,x)
#define FREEMEM(x)	GlobalFree(x)
#else
#define ALLOCATE(x)	malloc(x)
#define FREEMEM(x)	free(x)
#endif

extern unsigned char *IPL, *SMPC, *Backup, *RAM, *ABus, *Sound, *VDP1, *VDP2, *SCU, *Special;
extern unsigned long casLatency;

int loadROM(void);
int loadCart(char*);

int memInit(void);
void memFree(void);

void memSetByte(unsigned long, unsigned char);
void memSetWord(unsigned long, unsigned short);
void memSetLong(unsigned long, unsigned long);

unsigned char memGetByte(unsigned long);
unsigned short memGetWord(unsigned long);
unsigned long memGetLong(unsigned long);

//void *memAddrConv(unsigned long);
#endif
