// PAD.H
// Titan Peripheral Control

#ifndef _PAD_H
#define _PAD_H

#include "global.h"

typedef struct {
#ifdef LSB_FIRST
   unsigned size : 4;
   unsigned B : 1;
   unsigned C : 1;
   unsigned A : 1;
   unsigned Start : 1;
   unsigned Up : 1;
   unsigned Down : 1;
   unsigned Left : 1;
   unsigned Right : 1;
   unsigned extension : 3;
   unsigned L : 1;
   unsigned Z : 1;
   unsigned Y : 1;
   unsigned X : 1;
   unsigned R : 1;
#else
   unsigned R : 1;
   unsigned X : 1;
   unsigned Y : 1;
   unsigned Z : 1;
   unsigned L : 1;
   unsigned extension : 3;
   unsigned Right : 1;
   unsigned Left : 1;
   unsigned Down : 1;
   unsigned Up : 1;
   unsigned Start : 1;
   unsigned A : 1;
   unsigned C : 1;
   unsigned B : 1;
   unsigned size : 4;
#endif
} Peri_DigitalPad;

void *getPeriData(uint8, int*);

#endif