// HW.H
// Header for Titan Hardware Aliases and Related Stuff

#ifndef _SCU_H
#define _SCU_H

#include "mem.h"

#define SCU_DMA_FORCE_END	*(unsigned long*)&SCU[0x60]
#define SCU_DMA_STATUS		*(unsigned long*)&SCU[0x7c]

// Timers
#define SCU_TIMER0		*(unsigned long*)&SCU[0x90]
#define SCU_TIMER1_DATA *(unsigned long*)&SCU[0x94]
#define SCU_TIMER1_MODE *(unsigned long*)&SCU[0x98]

#define INT_VBLANK_IN	0x1
#define INT_VBLANK_OUT	0x2
#define INT_HBLANK_IN	0x4
#define INT_TIMER0		0x8
#define INT_TIMER1		0x10
#define INT_DSP_END		0x20
#define INT_SOUND		0x40
#define INT_SYSMANAGER	0x80
#define INT_PAD			0x100
#define INT_DMA_L2		0x200
#define INT_DMA_L1		0x400
#define INT_DMA_L0		0x800
#define INT_DMA_ILLEGAL 0x1000
#define INT_SPRITE_DRAW 0x2000

#define SCU_INT_MASK	*(unsigned long*)&SCU[0xa0]
#define SCU_INT_STATUS	*(unsigned long*)&SCU[0xa4]

// My attempt to complete the register instructions (Ricepad1)
#define CS0_CS1_SPACES  *(unsigned long*)&SCU[0xb0]
#define CS2_SPACE       *(unsigned long*)&SCU[0xb4]
#define ABUS_REFRESH    *(unsigned long*)&SCU[0xb8]
#define ABUS_INT_ACK    *(unsigned long*)&SCU[0xbc]

#define SDRAM_SELECT    *(unsigned long*)&SCU[0xc4]
#define VER_NUM         *(unsigned long*)&SCU[0xc8]

#define INTERRUPT(x) (SCU_INT_STATUS | x)
#define DMACHECK(x) (((dma[x].mode & 7) == 7) && ((dma[x].enable & 0x101) == 0x101))

// Specially mapped SCU registers
#define SCU_DIVU_DVSR		*(unsigned long*)&Special[0x1ff+0x00]
#define SCU_DIVU_DVDNT		*(unsigned long*)&Special[0x1ff+0x04]
#define SCU_DIVU_DVCR		*(unsigned long*)&Special[0x1ff+0x08]
#define SCU_DIVU_VCRDIV		*(unsigned long*)&Special[0x1ff+0x0C]
#define SCU_DIVU_DVDNTH		*(unsigned long*)&Special[0x1ff+0x10]
#define SCU_DIVU_DVDNTL		*(unsigned long*)&Special[0x1ff+0x14]

typedef struct {
	unsigned long raddr;
	unsigned long waddr;
	unsigned long count;
	unsigned long add;
	unsigned long enable;
	unsigned long mode;
	unsigned long dummy[2];
} dmaStruct;

extern int Timer0, Timer1;

void initHW(void);
void checkHW(uint32);
void updateHW(void);

void updateMiscRegs(unsigned long addr);

#endif