// DYNALIB.H
// x86 DynaRec (PATRICk) Engine Header

#ifndef _DYNALIB_H
#define _DYNALIB_H

#ifdef __GNUC__
#define dynaLock()	__asm__ __volatile__ ("push %edx"); \
					__asm__ __volatile__ ("push %ebx");
#define dynaFree()	__asm__ __volatile__ ("pop %ebx"); \
					__asm__ __volatile__ ("pop %edx");
#else
#define dynaLock()	__asm \
{                         \
   __asm push edx         \
   __asm push ebx         \
}
#define dynaFree()	__asm \
{                         \
   __asm pop ebx          \
   __asm pop edx          \
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

#define NUMOFBLOCKS		16
#define MAXBLOCKSIZE	1024

#define PROLOGSIZE		38
#define EPILOGSIZE		3
#define SEPERATORSIZE	3
#define DELAYJUMPSIZE	20

#define MININSTRSIZE    3
#define MAXINSTRSIZE	40
#define MAXJUMPSIZE		46

#define SAFEPAGESIZE	MAXBLOCKSIZE - MAXJUMPSIZE - MAXINSTRSIZE - DELAYJUMPSIZE - SEPERATORSIZE - EPILOGSIZE
#define MAXINSTRCNT		MAXBLOCKSIZE/(MININSTRSIZE+SEPERATORSIZE)

typedef struct {
	void (*func)();
	unsigned const char *size, *src, *dest, *off1, *imm, *off3, delay;
} x86op_desc;

#define opinit(x)	extern const unsigned char x##_size, x##_src, x##_dest, x##_off1, x##_imm, x##_off3; \
					void x86_##x();

typedef struct {
	unsigned char *ptr;
	unsigned long src, dest;
} jmpTag;

opinit(CLRT);
opinit(CLRMAC);
opinit(NOP);
opinit(DIV0U);
opinit(SETT);
opinit(SLEEP);

opinit(STS_MACH);
opinit(STS_MACL);
opinit(STS_MACH_DEC);
opinit(STS_MACL_DEC);
opinit(STS_PR);
opinit(STC_SR);
opinit(STC_VBR);
opinit(STC_GBR);
opinit(LDS_PR);
opinit(LDS_MACH);
opinit(LDS_MACL);
opinit(LDS_PR_INC);
opinit(LDS_MACH_INC);
opinit(LDS_MACL_INC);
opinit(LDC_SR);
opinit(LDC_VBR);
opinit(LDC_GBR);
opinit(LDC_SR_INC);
opinit(LDC_VBR_INC);
opinit(LDC_GBR_INC);
opinit(STC_SR_MEM);
opinit(STC_VBR_MEM);
opinit(STC_GBR_MEM);
opinit(STS_PR_DEC);

opinit(CMP_EQ);
opinit(CMP_HI);
opinit(CMP_GE);
opinit(CMP_HS);
opinit(CMP_GT);

opinit(DT);
opinit(CMP_PL);
opinit(CMP_PZ);
opinit(ROTL);
opinit(ROTR);
opinit(ROTCL);
opinit(ROTCR);
opinit(SHL);
opinit(SHLR);
opinit(SHAR);
opinit(SHLL2);
opinit(SHLR2);
opinit(SHLL8);
opinit(SHLR8);
opinit(SHLL16);
opinit(SHLR16);

opinit(AND);
opinit(OR);
opinit(XOR);
opinit(NOT);
opinit(XTRCT);
opinit(ADD);
opinit(ADDC);
opinit(SUB);
opinit(SUBC);
opinit(NEG);
opinit(NEGC);
opinit(TST);

opinit(AND_B);
opinit(OR_B);
opinit(TST_B);
opinit(XOR_B);

opinit(ADDI);
opinit(ANDI);
opinit(ORI);
opinit(XORI);
opinit(MOVI);
opinit(CMP_EQ_IMM);

opinit(SWAP_B);
opinit(SWAP_W);
opinit(EXTU_B);
opinit(EXTU_W);
opinit(EXTS_B);
opinit(EXTS_W);

opinit(BT)
opinit(BF);
opinit(JMP);
opinit(JSR);
opinit(BRA);
opinit(BSR);
opinit(BSRF);
opinit(BRAF);
opinit(RTE);
opinit(RTS);

opinit(MOVA);
opinit(MOVT);
opinit(MOVB_MEM_REG);
opinit(MOVW_MEM_REG);
opinit(MOVL_MEM_REG);
opinit(MOV_B_MEM);
opinit(MOV_W_MEM);
opinit(MOV_L_MEM);
/*opinit(MOVW_A);
opinit(MOVL_A);*/
opinit(MOVW_DISP);
opinit(MOVL_DISP);
opinit(MOVL_REG_DISP);
opinit(MOV_REG);
opinit(MOV_B_INC);
opinit(MOV_W_INC);
opinit(MOV_L_INC);
opinit(MOVB_M_R0);
opinit(MOVW_M_R0);
opinit(MOVL_M_R0);
opinit(MOVB_R0_N);
opinit(MOVW_R0_N);
opinit(MOVL_R0_N);

void prologue(void);
void epilogue(void);
void seperator(void);

void PageJump(void); // jumps to a different page
void PageFlip(void); // "flips" the page

extern x86op_desc asm_list[];

#ifdef __cplusplus
}
#endif

#endif