// CDROM.CPP
// Titan Win32 CD Routines

#include <windows.h>
#include "cdrom.h"

HWND scdWnd;

unsigned short CR[4];
unsigned short CD_REG;
unsigned short CD_MSKREG;

unsigned char CD_STATUS;

void UpdateRegs(void);

BOOL APIENTRY DllMain(HANDLE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}

void DLLEXPORT PLUGINCALL SAT_PlugInfo(tagPlugInfo *info)
{
	strcpy(info->name, "SCD Win32 Plugin");
	info->plugType = SAT_SCD_PLUGIN;
	info->plugVersion = 1;
}

int DLLEXPORT PLUGINCALL SCD_InitPlugin(unsigned long param)
{
	scdWnd = (HWND)param;

    CD_REG = CD_MSKREG = 0xffff;
    CD_STATUS = CD_ST_NODISC;
    CR[1] = 'C';
    CR[2] = 'DB'; //('D' << 8) | 'B';
    CR[3] = 'LO'; //('L' << 8) | 'O';
    CR[4] = 'CK'; //('C' << 8) | 'K';
	return 0;
}

int DLLEXPORT PLUGINCALL SCD_StartPlugin(void)
{
	return 0;
}

void DLLEXPORT PLUGINCALL SCD_StopPlugin(void)
{}

void DLLEXPORT PLUGINCALL SCD_FreePlugin(void)
{}

void DLLEXPORT PLUGINCALL SCD_WriteRegs(unsigned long addr, unsigned long data)
{
	switch (addr & 0xfffff)
	{
	    case (0x90008):
	    case (0x9000A):
			CD_REG = (unsigned short)data;
			UpdateRegs();
			break;
		case (0x9000C):
		case (0x9000E):
			CD_MSKREG = (unsigned short)data;
			break;
		case (0x90018):
		case (0x9001A):
			CR[1] = (unsigned short)data;
			break;
		case (0x9001C):
		case (0x9001E):
			CR[2] = (unsigned short)data;
			break;
		case (0x90020):
		case (0x90022):
			CR[3] = (unsigned short)data;
			break;
		case (0x90024):
		case (0x90026):
			CR[4] = (unsigned short)data;
			break;
		default:
			break;
	}
}

unsigned short DLLEXPORT PLUGINCALL SCD_ReadRegs(unsigned long addr)
{
	switch (addr & 0xfffff)
	{
	    case (0x90008):
	    case (0x9000A):
			return CD_REG;
			break;
		case (0x9000C):
		case (0x9000E):
			return CD_MSKREG;
			break;
		case (0x90018):
		case (0x9001A):
			return CR[1];
			break;
		case (0x9001C):
		case (0x9001E):
			return CR[2];
			break;
		case (0x90020):
		case (0x90022):
			return CR[3];
			break;
		case (0x90024):
		case (0x90026):
			return CR[4];
			break;
		default:
			return 0;
			break;
	}
}

void UpdateRegs(void)
{
    switch(CR[1]>>8)
	{
        case (0x00): // Get Status (SR)
            CR[1] = CD_STATUS<<8;   //CR1: Status(8)    | Flag(4) | Rep Cnt(4)
            CR[2] = 0x0000;         //CR2: Ctrl Addr(8) | Track No(8)
            CR[3] = 0x0000;         //CR3: Index No (8) | Upper Byte of current FAD (8)
            CR[4] = 0x0000;         //CR4: Lower word of current FAD(16)
            CD_REG |= (CD_EFLS | CD_CMOK);
            break;

        case (0x01): // Get Hardware Info (S) (Command 0x01)
            CR[1] = CD_STATUS<<8;   //CR1: Status(8)     | 0
            CR[2] = 0x0000;         //CR2: hw flag(8)    | version(8)
            CR[3] = 0x0000;         //CR3: 0             | Mpeg Version(8)
            CR[4] = 0x0000;         //CR4: Driver ver(8) | Revision(8)
            CD_REG |= CD_CMOK; //0x0FE1
            break;

        case (0x04): // Initialize CD system (SR) (Command 0x04)
            CR[1] = CD_STATUS<<8;   //CR1: Status(8)    | Flag(4) | Rep Cnt(4)
            CR[2] = 0x0000;         //CR2: Ctrl Addr(8) | Track No(8)
            CR[3] = 0x0000;         //CR3: Index No (8) | Upper Byte of current FAD (8)
            CR[4] = 0x0000;         //CR4: Lower word of current FAD(16)
            CD_REG |= (CD_EFLS | CD_CMOK);        //End Flag : CMOK ,ESEL
            break;

		case (0x6): // End Data Transfer
			CR[1] = CD_STATUS<<8;
			CR[2] = 0x0000;
			CR[3] = 0x0000;
			CR[4] = 0x0000;
			CD_REG |= CD_CMOK;
			CD_MSKREG &= 0xfffd;
			break;

		case (0x48): // Reset Selector 
			CR[1] = (CD_STATUS<<8) | 0xFF;
			CR[2] = 0xFFFF;
			CR[3] = 0xFFFF;
			CR[4] = 0xFFFF;
			CD_REG |= (CD_CMOK | CD_ESEL);
			break;

		case (0x60): // Set Sector Length
			CR[1] = (CD_STATUS<<8) | 0xFF;
			CR[2] = 0xFFFF;
			CR[3] = 0xFFFF;
			CR[4] = 0xFFFF;
			CD_REG |= 0x0041;
			break;
        case (0x75): // Abort file (SR) (command 0x75)
            CR[1] = CD_ST_STANDBY<<8; //CR1 : Status(8)    | Flag(4) | Rep Cnt(4)
            CR[2] = 0x0000;        //CR2 : Ctrl Addr(8) | Track No(8)
            CR[3] = 0x0000;        //CR3 : Index No (8) | Upper Byte of FAD (8)
            CR[4] = 0x0000;        //CR4 : Lower word of FAD(16)
            CD_REG |= (CD_EFLS | CD_CMOK);      //CMOK
            break;

        default:
			break;
    }
}
