// VDP.CPP
// Win32 VDP1/VDP2 Drawing Routines
// (should eventually port to plugin for Win32 version)

#include <windows.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <ddraw.h>
#include <d3d.h>
#include "vdp.h"

HWND vdpWnd;
vdp_pal palette[0x1000];
unsigned char *fb, *vram;
unsigned short  *vdp1reg, *vdp2col, *vdp2reg;

int screenMode, sizex=320, sizey=240, scrnx, scrny, depth;
unsigned char cram;

unsigned long	pa_start_addr;
unsigned long	pb_start_addr;
unsigned long	pc_start_addr;
unsigned long	pd_start_addr;

int VRes[] = {224, 240, 256};
int HRes[] = {320, 352, 640, 704, 320, 352, 640, 704};

void ConsoleMsg(char *message, ...);

int initScreenWindowed(void);
int initFulScreen(void);
HRESULT WINAPI EnumBackBufferCallback(LPDIRECTDRAWSURFACE7, LPDDSURFACEDESC2, LPVOID);

void DLLEXPORT PLUGINCALL SAT_PlugInfo(tagPlugInfo *info)
{
	strcpy(info->name, "VDP DirectX Plugin");
	info->plugType = SAT_VDP_PLUGIN;
	info->plugVersion = 1;
}

BOOL APIENTRY DllMain(HANDLE hModule, DWORD ul_reason_for_call, LPVOID lpReserved)
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}

int DLLEXPORT PLUGINCALL VDP_InitPlugin(unsigned char *VDP1, unsigned char *VDP2, unsigned long param)
{
	//HKEY myKey;
	fb      = VDP1;
	vdp1reg = (unsigned short*)(VDP1 + 0x30000);
	vram    = VDP2;
	vdp2col = (unsigned short*)(VDP2 + 0x80000);
	vdp2reg = (unsigned short*)(VDP2 + 0x81000);
	
	// param contains hWnd
	vdpWnd = (HWND)param;

	if (DirectDrawCreate(NULL, &lpDD, NULL) != DD_OK) 
		return -1;

	lpDD->Release();
	lpDD = NULL;

	return 0;
}

int DLLEXPORT PLUGINCALL VDP_StartPlugin(void)
{
	if (DirectDrawCreate(NULL, &lpDD, NULL) != DD_OK ) { 
		ConsoleMsg("Could not Create DirectDraw Object");
		return -1;
	}

	memset(&ddsd, 0, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_COMPLEX | DDSCAPS_3DDEVICE;
	ddsd.dwBackBufferCount = 1;

	initScreenWindowed();

	/*DDPIXELFORMAT ddpfZBuffer;
	if (getzbuffer(ddpfZBuffer)) return -1;
	
	memset(&ddsd, 0, sizeof(DDSURFACEDESC2));
	ddsd.dwSize = sizeof(DDSURFACEDESC2);
	ddsd.dwFlags        = DDSD_CAPS|DDSD_WIDTH|DDSD_HEIGHT|DDSD_PIXELFORMAT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_ZBUFFER | DDSCAPS_VIDEOMEMORY;
	ddsd.dwWidth        = Voodoo.width;
	ddsd.dwHeight       = Voodoo.height;
	memcpy( &ddsd.ddpfPixelFormat, &ddpfZBuffer, sizeof(DDPIXELFORMAT) ); 

	if(lpDD->CreateSurface(&ddsd, &lpDDSZBuffer, NULL) != DD_OK) {
		log(" Error in CreateSurface ");
		return -1;
	}

	if(DX.DDSRender->AddAttachedSurface(DX.DDSZBuffer) != DD_OK) {
		log("  Error in AddAttachedSurface");
		return XGLFALSE;
	}

	if (lpD3D->CreateDevice(IID_IDirect3DHALDevice, lpDDSBack, &lpD3DD)) {
		//log("  Error in CreateDevice");
		return -1;
	}*/

	return 0;
}

void DLLEXPORT PLUGINCALL VDP_StopPlugin(void)
{
	if(lpDD != NULL)
    {
		if (screenMode | VDP_FULLSCREEN)
			lpDD->RestoreDisplayMode();
		else 
			pcClipper->Release();

        if(lpDDSBack != NULL)
        {
            lpDDSBack->Release();
            lpDDSBack = NULL;
        }
        if(lpDDSPrimary != NULL)
        {
            lpDDSPrimary->Release();
            lpDDSPrimary = NULL;
        }

		/*lpD3DD->Release;
		lpD3D->Release;*/
		lpDD->Release();
		lpDD = NULL;
    }
}

void DLLEXPORT PLUGINCALL VDP_FreePlugin(void)
{}

void DLLEXPORT PLUGINCALL VDP_UpdateScreen(void)
{
}

void DLLEXPORT PLUGINCALL VDP_UpdateRegs(unsigned long addr)
{
	int i, tmp;
	//char tmpchar;

	switch (addr & 0xffffff)
	{
		case (0xf80000):
			tmp = vdp2reg[0x0];
			scrny = VRes[(tmp >> 4) & 0x3];
			scrnx = HRes[tmp & 0x7];
			break;
		case (0xf8000e):
			cram = (VDP2_RAMCTL>>12)&0x3;
			switch(cram) {
				case 0: //CRAM mode 0: RGB each 5 bits, 1024 color setting
					for(i=0; i<0x10; i++)
					{
						tmp = *(vdp2col+i) & 0x7fff;
						palette[i].red   = (tmp & 0x1f) << 3;
						palette[i].green = ((tmp >> 5) & 0x1f) << 3;
						palette[i].blue  = (tmp >> 10) << 3;
					} break;

				//case 1: //CRAM mode 1: RGB each 5 bits, 2048 color setting
				//case 2: //CRAM mode 2: RGB each 8 bits, 1024 color setting

				default: ConsoleMsg(0, "Unhandled CRAM mode %d", cram); break;
			}
			break;

		default: break; //ConsoleMsg("Unhandled VDP Register: 0x%8x", addr); break;
	}
}

void DLLEXPORT PLUGINCALL VDP_VBlank(void)
{}

void DLLEXPORT PLUGINCALL VDP_HBlank(void)
{}

int initFullScreen(void)
{
    if (lpDD->SetCooperativeLevel(vdpWnd, DDSCL_EXCLUSIVE|DDSCL_FULLSCREEN) != DD_OK)
		return -1;

	// should really enumerate x, y, and depth before this
	if (lpDD->SetDisplayMode(sizex, sizey, depth) != DD_OK)
		return -1;

    // Create the primary surface
	memset(&ddsd, 0, sizeof(ddsd));
    ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_COMPLEX | DDSCAPS_3DDEVICE; //DDSCAPS_FLIP
	ddsd.dwBackBufferCount = 1;

    if (lpDD->CreateSurface(&ddsd, &lpDDSPrimary, NULL) != DD_OK) {
		ConsoleMsg("Error Creating Primary Surface");
		return -1;
	}

	ddscaps.dwCaps = DDSCAPS_BACKBUFFER;

	if (lpDDSPrimary->GetAttachedSurface(&ddscaps,&lpDDSBack) != DD_OK) {
		ConsoleMsg("Error Creating Back Surface");
		return -1;
	}

	/*ddbltfx.dwSize = sizeof(ddbltfx);
	ddbltfx.dwFillColor = 0;
   
    lpDDSPrimary->Blt(NULL,NULL,NULL,DDBLT_COLORFILL,&ddbltfx);
    lpDDSBack->Blt(NULL,NULL,NULL,DDBLT_COLORFILL,&ddbltfx);*/
	//screenMode |= VDP_FULLSCREEN;

	return 0;
}

int initScreenWindowed(void)
{
	RECT rcSize;


    if(lpDD->SetCooperativeLevel(vdpWnd, DDSCL_NORMAL) != DD_OK)
		return -1;

	// Resize window
	GetClientRect(vdpWnd, &rcSize); 
	rcSize.right = rcSize.left + sizex;
	rcSize.bottom = rcSize.top + sizey;
	AdjustWindowRect(&rcSize, WS_OVERLAPPED | WS_SYSMENU | WS_BORDER, TRUE);

    // Create the primary surface
	memset(&ddsd, 0, sizeof(ddsd));
    ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_3DDEVICE;

    if (lpDD->CreateSurface(&ddsd, &lpDDSPrimary, NULL) != DD_OK) {
		ConsoleMsg("Error Creating Primary Surface");
		return -1;
	}

	// Create off-screen surface
    ddsd.dwFlags        = DDSD_WIDTH | DDSD_HEIGHT | DDSD_CAPS;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_3DDEVICE;
    ddsd.dwWidth  = rcSize.right - rcSize.left;
    ddsd.dwHeight = rcSize.bottom - rcSize.top;
 
	if (lpDD->CreateSurface(&ddsd, &lpDDSBack, NULL) != DD_OK) {
		ConsoleMsg("Error Creating Back Surface");
		return -1;
	}

	if (lpDD->CreateClipper(NULL, &pcClipper, NULL) != DD_OK) {
		ConsoleMsg("Error Creating Clipper");
		return -1;
	}

    pcClipper->SetHWnd(NULL, vdpWnd);
    lpDDSPrimary->SetClipper(pcClipper);
    //pcClipper->Release();
	//screenMode |= VDP_WINDOWED;

	return 0;
}

HRESULT WINAPI EnumBackBufferCallback(LPDIRECTDRAWSURFACE7 lpDDSurface, LPDDSURFACEDESC2 lpDDSurfaceDesc, LPVOID lpContext) {

	if (lpDDSurfaceDesc->ddsCaps.dwCaps & DDSCAPS_BACKBUFFER) {
		*(LPDIRECTDRAWSURFACE7*)lpContext = lpDDSurface;
		return DDENUMRET_CANCEL;
	}

	return D3DENUMRET_OK;
}

void ConsoleMsg(char *message, ...)
{
	va_list data;
	char tempstr[128];

	va_start(data, message);
	vsprintf(tempstr, message, data);
	va_end(data);

	strcat(tempstr, "\n");
	MessageBox(vdpWnd, tempstr, "VDP Plugin", MB_OK|MB_ICONWARNING);
}