// VDP.H
// Win32 VDP1/VDP2 Drawing Routines Header File
// (should eventually port to plugin for Win32 version)

#ifndef _VDP_H
#define _VDP_H

#include "vdpstruct.h"
#include "plugin.h"

#ifdef __cplusplus
extern "C" {
#endif

#define DLLEXPORT	__declspec(dllexport)

#define VDP2_EXTEN   vdp2reg[0x02]
#define VDP2_TVSTAT  vdp2reg[0x04]
#define VDP2_VRSIZE  vdp2reg[0x06]
#define VDP2_HCNT    vdp2reg[0x08]
#define VDP2_VCNT    vdp2reg[0x0a]
#define VDP2_RAMCTL  vdp2reg[0x0e]

#define VDP2_SPCTL   vdp2reg[0xe0]

#define VDP_FULLSCREEN	0x1
#define VDP_WINDOWED	0x2

void DLLEXPORT PLUGINCALL SAT_PlugInfo(tagPlugInfo*);
int DLLEXPORT PLUGINCALL VDP_InitPlugin(unsigned char*, unsigned char*, unsigned long);
int DLLEXPORT PLUGINCALL VDP_StartPlugin(void);
void DLLEXPORT PLUGINCALL VDP_StopPlugin(void);
void DLLEXPORT PLUGINCALL VDP_FreePlugin(void);
void DLLEXPORT PLUGINCALL VDP_UpdateRegs(unsigned long);
void DLLEXPORT PLUGINCALL VDP_UpdateScreen(void);

#ifdef __cplusplus
}
#endif

#endif