// WIN.C
// Titan Windows GUI

#define APPNAME "Titan"
#define szAppName	APPNAME

#include <windows.h>
#include <wingdi.h>
#include <winnt.h>
#include <commdlg.h>
#include <stdio.h>
#include "gui.h"
#include "../mem.h"
#include "../global.h"
#include "../plugin.h"

#ifdef TITAN_DEBUG
#include "../debug.h"
#endif

HWND      g_hWnd;
HINSTANCE g_hInst, DLL_VDP, DLL_SND, DLL_SCD;

HKEY	pluginKey;
HANDLE	EmuThread;
DWORD	dwScrap;

OPENFILENAME OpenFileName;
char szProgramPath[MAX_PATH];
char szFileName[MAX_PATH];
char szDirectory[255];

DWORD EmuCycle(LPDWORD);
LRESULT CALLBACK About(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PluginDialog(HWND, UINT, WPARAM, LPARAM);

int FindRegKeyValue(char*, char*);

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
 	MSG 	  msg;
	WNDCLASS  wc;
	HWND      hWnd;
	HACCEL	  hAccelTable;

	hWnd = FindWindow (szAppName, NULL);

	if (hWnd)
	{
       	if (IsIconic(hWnd))
       		ShowWindow(hWnd, SW_RESTORE);
		SetForegroundWindow (hWnd);
		return FALSE;
	}

	wc.style         = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc   = (WNDPROC)WndProc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = hInstance;
	wc.hIcon         = LoadIcon (hInstance, szAppName);
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);

	wc.lpszMenuName  = szAppName;
	wc.lpszClassName = szAppName;

	if (!hPrevInstance) 
	{
		if (!RegisterClass(&wc))
			return (FALSE);
	}

	hWnd = CreateWindow(szAppName, APPNAME, WS_OVERLAPPED | WS_SYSMENU | WS_BORDER,
		CW_USEDEFAULT, CW_USEDEFAULT, 320, 240,	NULL, NULL, hInstance, NULL);

	if (hWnd == NULL)
		return (FALSE);

	g_hWnd  = hWnd;
	g_hInst = hInstance;
	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	hAccelTable = LoadAccelerators (hInstance, szAppName);
	GetCurrentDirectory((DWORD)MAX_PATH, szProgramPath);
#ifdef TITAN_DEBUG
	AllocConsole();
	hConInput = GetStdHandle(STD_INPUT_HANDLE);
	hConOutput = GetStdHandle(STD_OUTPUT_HANDLE);
	SetConsoleTitle("Titan Debugger");
	DebugMsg("Project Titan Debugger\n");
#endif
	if (emuStartUp() || loadINISettings() || initModules())
		return (FALSE);

	memset(&OpenFileName, 0, sizeof(OpenFileName));
	
	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (!TranslateAccelerator (msg.hwnd, hAccelTable, &msg)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
			}
		}
	return (msg.wParam);

	//lpCmdLine; // This will prevent 'unused formal parameter' warnings
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	//HMENU hMenu;
	
    switch (message)
    {
		case WM_CREATE:
            break;

    	case WM_COMMAND:
			switch (LOWORD(wParam))
			{

				case IDM_ABOUT:
					DialogBox(g_hInst, MAKEINTRESOURCE(AboutBox), hWnd, (DLGPROC)About);
					break;

				case IDM_PLUGIN:
					DialogBox(g_hInst, MAKEINTRESOURCE(PLUGIN_SETUP), hWnd, (DLGPROC)PluginDialog);
					break;

				case IDM_LOAD:
#ifdef GUI_SAVE_DIRECTORY
					RegCreateKeyEx(HKEY_CURRENT_USER, "Software\\Emulators\\Titan",0,
							NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS,NULL,&pluginKey,&dwScrap);
					FindRegKeyValue("LastDirectory", szDirectory);
#endif
					memset (szFileName,0,sizeof(szFileName));
					OpenFileName.lStructSize  = sizeof(OpenFileName);
					OpenFileName.hwndOwner    = hWnd;
					OpenFileName.lpstrFilter  = "Saturn Executable (*.*)\0*.*\0All files (*.*)\0*.*\0";
					OpenFileName.lpstrFile    = szFileName;
					OpenFileName.lpstrTitle   = "Open Saturn Executable";
					OpenFileName.lpstrInitialDir    = szDirectory;
					OpenFileName.nMaxFile     = MAX_PATH;
					OpenFileName.Flags        = OFN_FILEMUSTEXIST|OFN_HIDEREADONLY;

					if (GetOpenFileName (&OpenFileName))
					{
						InvalidateRect(hWnd,NULL,TRUE);
#ifdef GUI_SAVE_DIRECTORY
						RegCloseKey(pluginKey);				
#endif
					}
					else
            			break;

#ifdef GUI_SAVE_DIRECTORY
					RegSetValueEx(pluginKey,"LastDirectory",0,REG_SZ,(const BYTE*)szDirectory,strlen(szDirectory));
					RegCloseKey(pluginKey);
#endif

					if (!loadCart(szFileName) && !startModules())
					{
						Flags.EmuStatus = EMU_RUN;
						EmuThread=CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)EmuCycle,
                        						hWnd, 0, &dwScrap);
					}
           			break;

				case IDM_ROM:
					if (!loadROM() && !startModules())
					{
						Flags.EmuStatus = EMU_RUN;
						EmuThread=CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)EmuCycle,
												hWnd, 0, &dwScrap);
					}
					else
						ConsoleMsg(MSG_WARN, "Cannot start emulation");
					break;

				case IDM_HALT:
					Flags.EmuStatus = EMU_STOP;
					stopModules();
					CloseHandle(EmuThread);
					break;

				case IDM_EXIT:
					if (Flags.EmuStatus) {
						Flags.EmuStatus = EMU_STOP;
						stopModules();
						CloseHandle(EmuThread);
					}
					DestroyWindow(hWnd);
					break;

				default:
					return (DefWindowProc(hWnd, message, wParam, lParam));
			}
			break;

        case WM_DESTROY:
			memFree();
			freeModules();
			emuCleanUp();
#ifdef TITAN_DEBUG
			FreeConsole();
#endif
			PostQuitMessage(0);
			break;

		default:
			return (DefWindowProc(hWnd, message, wParam, lParam));
	}
	return (0);
}

LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{

	switch (message) {

        case WM_INITDIALOG:
	   		return (TRUE);

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				EndDialog(hDlg, TRUE);
				return (TRUE);
			}
			break;
		}

    return FALSE;
}

DWORD EmuCycle(LPDWORD lpData)
{
	if (Settings.Engine == 0)
		emulate();
	else
		dynaEmulate();
	return 0;
}

LRESULT CALLBACK PluginDialog(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	//HINSTANCE hCurrent;
	//HANDLE hSearch; 
	//DWORD dwNew; 
	//HKEY pluginKey = NULL;
	//WIN32_FIND_DATA FileData;

	switch (message)
	{
        case WM_INITDIALOG:
  			return (TRUE);

        case WM_COMMAND:
        	switch (LOWORD(wParam))
            {
            	case SAT_OK:
					//NOTE: May decide to use INI file instead of registry

					/* add filenames to the registry
                    RegCreateKeyEx(HKEY_CURRENT_USER, "Software\\PSeudoX\\Plugins",0,
						NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS,NULL,&pluginKey,&dwNew);
					RegSetValueEx(pluginKey,"VDP",0,REG_SZ,(const BYTE*)DLL_FileNames[0],strlen(DLL_FileNames[0]));
					RegSetValueEx(pluginKey,"SND",0,REG_SZ,(const BYTE*)DLL_FileNames[1],strlen(DLL_FileNames[1]));
					RegSetValueEx(pluginKey,"SCD",0,REG_SZ,(const BYTE*)DLL_FileNames[2],strlen(DLL_FileNames[2]));
					RegCloseKey(pluginKey);*/

					EndDialog(hDlg, TRUE);
                    return (TRUE);

                default:
                	return (TRUE);
            }

        case WM_CLOSE:
       		EndDialog(hDlg, TRUE);
			return (TRUE);
    }
	return (FALSE);
}

int FindRegKeyValue(char *kname, char *value)
{
	DWORD dummy;
	int a = 0, flag = -1;
	char tmp0[64], tmp1[64];

	while (RegEnumValue(pluginKey, (DWORD)(a++), (LPTSTR)tmp0, &dummy, NULL, NULL,	(LPBYTE)tmp1, &dummy) == ERROR_SUCCESS)
	{
		if (strcmp(kname, tmp0) == 0)
		{
			strcpy(value, tmp1);
			flag = 0;
			break;
		}
	}

	return flag;
}

// Win32 Plugin Functions
int initModules(void)
{
	int i, result = 0;
	HINSTANCE hCurrent;


	for (i=0; i<3; i++) {
	    switch(i) {
			case 0:
				hCurrent = DLL_VDP = LoadLibrary(Settings.VDPModule);
				break;
			case 1:
				//hCurrent = DLL_SPU = LoadLibrary(Settings.SPUModule);
				break;
			case 2:
				hCurrent = DLL_SCD = LoadLibrary(Settings.SCDModule);
				break;
		}

		if (hCurrent == NULL) {
			ConsoleMsg(MSG_WARN, "Could not find all specified plugins");
			/*DialogBox(g_hInst, MAKEINTRESOURCE(PLUGIN_SETUP),
				NULL, (DLGPROC)PluginDialog);*/
			return -1;
		}
	}
	
	if (result = VDP_INIT(VDP1, VDP2, (unsigned long)g_hWnd))
		return result;

	if (result = SCD_INIT((unsigned long)g_hWnd))
		return result;

	return 0;
}

int startModules(void)
{
	int result = 0;

	if (result = ((retPlugCall)GetProcAddress(DLL_VDP, "_VDP_StartPlugin@0"))())
		return result;

	if (result = ((retPlugCall)GetProcAddress(DLL_SCD, "_SCD_StartPlugin@0"))())
		return result;

	return 0;
}

void stopModules(void)
{
	((voidPlugCall)GetProcAddress(DLL_VDP, "_VDP_StopPlugin@0"))();
	((voidPlugCall)GetProcAddress(DLL_SCD, "_SCD_StopPlugin@0"))();
}

void freeModules(void)
{
	((voidPlugCall)GetProcAddress(DLL_VDP, "_VDP_FreePlugin@0"))();
	((voidPlugCall)GetProcAddress(DLL_SCD, "_SCD_FreePlugin@0"))();

	FreeLibrary(DLL_VDP);
	//FreeLibrary(DLL_SPU);
	FreeLibrary(DLL_SCD);
}