// SOUND.C
// M68k Emulation (and SCSP Abstraction)

#include "global.h"
#include "m68k.h"

#define SCSPMEMSIZE		0x200000
#define FETCHREGIONS	2

#if defined(__i386__) || defined(_M_IX86)

struct GENITAL68K_DATAREGION m68k_fetch_byte[] =
{
	{ 0x00000,	0x80000,  GENITAL68K_NULL,	NULL },
	{ -1,       -1,       GENITAL68K_NULL,	NULL }
};

struct GENITAL68K_DATAREGION m68k_fetch_word[] =
{
	{ 0x00000,	0x80000,  GENITAL68K_NULL,	(void*)swapWord },
	{ -1,       -1,       GENITAL68K_NULL,	NULL }
};

struct GENITAL68K_DATAREGION m68k_fetch_long[] =
{
	{ 0x00000,	0x80000,  GENITAL68K_NULL,	(void*)swapLong },
	{ -1,       -1,       GENITAL68K_NULL,	NULL }
};

void init68k(void)
{
	m68k_fetch_byte[0].ptr = m68k_fetch_word[0].ptr = \
		m68k_fetch_long[0].ptr = (GENITAL68K_UINT32)Sound;

	genital68kcontext.read_byte = m68k_fetch_byte;
	genital68kcontext.write_byte = m68k_fetch_byte;

	genital68kcontext.fetch = m68k_fetch_word;
	genital68kcontext.read_word = m68k_fetch_word;
	genital68kcontext.write_word = m68k_fetch_word;

	genital68kcontext.read_long = m68k_fetch_long;
	genital68kcontext.write_long = m68k_fetch_long;

	Genital68KInit();
}

void step68k(int cycles)
{
	Genital68KRun(cycles);
}

void reset68k(void)
{
	Genital68KReset();
}

void stop68k(void)
{
	Genital68KClearCycles();
}

#else

void init68k(void)
{}

void reset68k(void)
{}

void step68k(int cycles)
{}

void stop68k(void)
{}

#endif

