// SETTINGS.C
// INI File Parsing/Preferences Handling

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "global.h"

#define INI_GETVAL(x, y, z)		getINIEntry(y, z, scrap); \
								x = (uint8)atoi(scrap);
#define INI_GETSTR(x, y, z)		getINIEntry(y, z, x); \

#define INI_WRITE(x)			strcpy(scrap, x); \
								fwrite((void*)x, sizeof(char), strlen(x), INIFile);

FILE *INIFile;
//int INI_Change;
tagPrefs Settings;

int getINIEntry(char*, char*, char*);
extern int initConsole(void);

void setDefaults(void)
{
	Settings.CountryCode = 1;
	Settings.ConsoleLog = 0;
	Settings.AreaCode = 4;

	strcpy(Settings.BIOSFile, "sega_101.bin");
}

int loadINISettings(void)
{
	char scrap[128];

	setDefaults();
	if((INIFile = fopen("titan.ini", "r")) == NULL)
	{
		ConsoleMsg(MSG_WARN, "Cannot Find TITAN.INI. Using Default Settings.");
		return 0;
	}

	INI_GETVAL(Settings.CountryCode, "[Emulation]", "CountryCode");
	INI_GETVAL(Settings.ConsoleLog, "[Emulation]", "ConsoleLog");
	INI_GETVAL(Settings.AreaCode, "[Emulation]", "AreaCode");
	//INI_GETVAL(scrap, "[Emulation]", "Engine");
	Settings.Engine = 0;

	INI_GETSTR(Settings.BIOSFile, "[Emulation]", "BIOS");

	if (Settings.ConsoleLog)
		initConsole();

	INI_GETSTR(Settings.VDPModule, "[Plugins]", "VDP");
	//INI_GETSTR(Settings.SPUModule, "[Plugins]", "SND");
	INI_GETSTR(Settings.SCDModule, "[Plugins]", "SCD");

	fclose(INIFile);
	return 0;
}

int writeINISettings(void)
{
	char scrap[128];
	char *numString[] = {"0","1","2","3","4","5","6","7","8","9","10","11","12","13" };

	if ((INIFile = fopen("titan.ini", "w")) == NULL)
	{
		ConsoleMsg(MSG_WARN, "Cannot write new settings to TITAN.INI");
		return 1;
	}

	INI_WRITE(";Titan Configuration File\n\n");
	INI_WRITE("[Emulators]\n");

	INI_WRITE("BIOS=");
	INI_WRITE(Settings.BIOSFile);

	INI_WRITE("ConsoleLog=");
	INI_WRITE(numString[Settings.ConsoleLog]);
	
	INI_WRITE("\nCountryCode=");
	INI_WRITE(numString[Settings.CountryCode]);

	INI_WRITE("\nEngine=");
	INI_WRITE(numString[Settings.Engine]);

	INI_WRITE("[Plugins]\n");
	INI_WRITE("VDP=");
	INI_WRITE(Settings.VDPModule);
	INI_WRITE("\nSND=");
	INI_WRITE(Settings.SPUModule);
	INI_WRITE("\nSCD=");
	INI_WRITE(Settings.SCDModule);

	return 0;
}

int getINIEntry(char *section, char *key, char *final)
{
	char temp[64] = "";

	if (INIFile == NULL)
		return 0;
	
    fseek(INIFile, 0L, SEEK_SET );

	// find section for key
	while (strcmp(temp, section) && !feof(INIFile))
		fscanf(INIFile, "%s", temp);

	// find key in section
	final[0] = '\0';
	do
	{
		fscanf(INIFile, "%s", temp);

		if ( (temp[0] != ';') && (strstr(temp, key) != NULL) )
		{
			if (strstr(temp, "=") != NULL && temp[strlen(temp)-1] != '=')
			{
				//strcpy(final, &temp[strlen(strstr(temp, "="))]);
				strcpy(final, strstr(temp, "=")+1);

				// remove additional whitespace
				scanf(final, "%s", final);
			}
			else
			{
				fscanf(INIFile, "%s", temp);
				if (strcmp(temp, "=") != 0)
					strcpy(final, temp);
				else
					fscanf(INIFile, "%s", final);
			}
		}
	} while (temp[0] != '[' && final[0] == '\0' && !feof(INIFile));

	if (final[0] == '\0')
		return 1;
	else
		return 0;
}

