// SH2.H
// Interpretive Engine Header

#ifndef _SH2_H
#define _SH2_H

#include "global.h"

#define ZERO_F  0
#define N_F     1
#define M_F     2
#define NM_F    3
#define MD_F    4
#define ND4_F   5
#define NMD_F   6
#define D_F     7
#define D12_F   8
#define ND8_F   9
#define I_F     10
#define NI_F    11

#define MACH	sh2->SysReg[0]
#define MACL	sh2->SysReg[1]
#define PR		sh2->SysReg[2]
#define PC		sh2->SysReg[3]

#define SR		sh2->CtrlReg[0]
#define GBR		sh2->CtrlReg[1]
#define VBR		sh2->CtrlReg[2]

typedef struct {
	uint32 GenReg[16];
	uint32 CtrlReg[3];
	uint32 SysReg[4];
	uint16 instr;
} tagSH2;

extern tagSH2 master, slave;

typedef struct
{
        int format;
        char *mnem;
        uint16 mask;
        uint16 bits;
		uint8 dat;
		void (FASTCALL *func)(tagSH2*);
} i_desc;

extern i_desc opcode_list[];

void sh2_ReturnFromFunction(tagSH2*);
void ResetCPU(tagSH2*);
void doInst(tagSH2*);
int opcodeIndex(unsigned short);

#endif