void doInst(tagSH2 *sh2)
{
	uint16 opcode;
	uint32 temp;
	uint64 mult;

	opcode = sh2->instr = memGetWord(sh2->SysReg[3]);
	sh2->SysReg[3] += 2;

	switch((opcode >> 12) & 0xf)
	{
		case (0x0):
			switch (opcode & 0xf) {
				case (0x2):
					if (source == 0) //STC SR,Rn
						sh2->GenReg[dest] = SR;
					else if (source == 1) //STC GBR,Rn
						sh2->GenReg[dest] = GBR;
					else if (source == 2) //STC VBR,Rn
						sh2->GenReg[dest] = VBR;
					break;
				case (0x3):
					if ((opcode >> 4) & 0xf == 0) //BSRF
					{
						PR = PC + 4;
						temp = PC + sh2->GenReg[dest];
						DelayBranch(temp);
					}
					if ((opcode >> 4) & 0xf == 2) //BRAF
					{
						temp = PC += sh2->GenReg[dest];
						DelayBranch(temp)
					}
					break;
				case (0x4): //MOV.B  Rm,@(R0,Rn)
					memSetByte(sh2->GenReg[0]+sh2->GenReg[dest], (uint8)sh2->GenReg[source]);
					break;
				case (0x5): //MOV.W  Rm,@(R0,Rn)
					memSetWord(sh2->GenReg[0]+sh2->GenReg[dest], (uint16)sh2->GenReg[source]);
					break;
				case (0x6): //MOV.L  Rm,@(R0,Rn)
					memSetLong(sh2->GenReg[0]+sh2->GenReg[dest], sh2->GenReg[source]);
					break;
				case (0x7): //MUL.L Rm,Rn
					MACL = (uint32)(sh2->GenReg[source] * sh2->GenReg[dest]);
					break;
				case (0x8):
					if (opcode == 0x8) //CLRT
						SR &= 0xfffffffe;
					else if (opcode == 0x18) //SETT
						setTBit(1);
					else if (opcode == 0x28) //CLRMAC
						MACH = MACL = 0;
					break;
				case (0x9):
					if (opcode == 0x9) //NOP
					{}
					else if (opcode == 0x19) //DIV0U
						SR &= 0xfcfe;
					else if (opcode & 0xff == 0x29) //MOVT
						sh2->GenReg[dest] = SR & 1;
					break;
				case (0xa):
					if (((opcode >> 4) & 0xf) == 0) //STS MACH,Rn
						sh2->GenReg[dest] = MACH;
					else if (((opcode >> 4) & 0xf) == 1) //STS MACL,Rn
						sh2->GenReg[dest] = MACL;
					else if (((opcode >> 4) & 0xf) == 2) //STS PR,Rn
						sh2->GenReg[dest] = PR;
					break;
				case (0xb):
					if (opcode == 0xb) //RTS
					{
						temp = PR;
						DelayBranch(temp);
					}
					else if (opcode == 0x1b) //SLEEP
					{
						ConsoleMsg(MSG_WARN, "SLEEP Opcode Interception");
					}
					else if (opcode == 0x2b) //RTE
					{
						temp = memGetLong(sh2->GenReg[15]) + 4;
						sh2->GenReg[15] += 4;
						SR = memGetLong(sh2->GenReg[15]) & 0x3f3;
						sh2->GenReg[15] += 4;
						DelayBranch(temp);
					}
					break;
				case (0xc): //MOV.B @(R0,Rm),Rn
					sh2->GenReg[dest] = (signed long)memGetByte(sh2->GenReg[0]+sh2->GenReg[source]);
					break;
				case (0xd): //MOV.W @(R0,Rm),Rn
					sh2->GenReg[dest] = (signed long)memGetWord(sh2->GenReg[0]+sh2->GenReg[source]);
					break;
				case (0xe): //MOV.L @(R0,Rm),Rn
					sh2->GenReg[dest] = memGetLong(sh2->GenReg[0]+sh2->GenReg[source]);
					break;
				case (0xf): //MAC.L @Rm+,@Rn+  **test
					mult = (uint64)((signed long)memGetLong(sh2->GenReg[source])*(signed long)memGetLong(sh2->GenReg[dest]));
					sh2->GenReg[source] += 4;
					sh2->GenReg[dest] += 4;
					mult += ((uint64)(MACH << 32) | (uint64)(MACL));
					MACL = (uint32)(mult & 0xffffffff);
					MACH = (uint32)((mult >> 32) & 0xffffffff);
					if (SR&1)
						MACH &= 0xffff;
					break;
				default:
					ConsoleMsg(MSG_WARN, "Unhandled Opcode at 0x%8x: 0x%4x", PC, opcode);
			}
			break;
		case (0x1):
			memSetLong(sh2->GenReg[dest]+(offset1<<2), sh2->GenReg[source]);
			break;
		case (0x2):
			switch (opcode & 0xf) {
				case (0x0): //MOV.B
					memSetByte(sh2->GenReg[dest], (uint8)sh2->GenReg[source]);
					break;
				case (0x1): //MOV.W
					memSetWord(sh2->GenReg[dest], (uint16)sh2->GenReg[source]);
					break;
				case (0x2): //MOV.L
					memSetLong(sh2->GenReg[dest], sh2->GenReg[source]);
					break;
				case (0x4): //MOV.B
					memSetByte(--sh2->GenReg[dest], (uint8)sh2->GenReg[source]);
					break;
				case (0x5): //MOV.W
					sh2->GenReg[dest] -= 2;
					memSetWord(sh2->GenReg[dest], (uint16)sh2->GenReg[source]);
					break;
				case (0x6): //MOV.L
					sh2->GenReg[dest] -= 4;
					memSetLong(sh2->GenReg[dest], sh2->GenReg[source]);
					break;
				case (0x7): //DIV0S Rm,Rn
					if ((sh2->GenReg[source]&0x80000000)^(sh2->GenReg[dest]&0x80000000))
						setTBit(0);
					else
						setTBit(1);
					break;
				case (0x8): //TST Rm,Rn
					if ((sh2->GenReg[dest] & sh2->GenReg[source]) == 0)
						setTBit(1);
					else
						setTBit(0);
					break;
				case (0x9): //AND Rm,Rn
					sh2->GenReg[dest] &= sh2->GenReg[source];
					break;
				case (0xa): //XOR Rm,Rn
					sh2->GenReg[dest] ^= sh2->GenReg[source];
					break;
				case (0xb): //OR Rm,Rn
					sh2->GenReg[dest] |= sh2->GenReg[source];
					break;
				case (0xc): //CMP/STR Rm,Rn
					temp = sh2->GenReg[dest]^sh2->GenReg[source];
					if ((temp>>12)&0xff || (temp>>8)&0xff || (temp>>4)&0xff || temp&0xff)
						setTBit(1);
					else
						SR &= 0xfffffffe;
					break;
				case (0xd): //XTRCT Rm,Rn
					sh2->GenReg[dest] = ((sh2->GenReg[source]<<16)&0xffff0000) | ((sh2->GenReg[dest]>>16)&0xffff);
					break;
				case (0xe): //MULU Rm,Rn
					MACL=((uint32)(uint16)sh2->GenReg[dest]*(uint32)(uint16)sh2->GenReg[source]);
					break;
				case (0xf): //MULS Rm,Rn
					MACL=((signed long)(short)sh2->GenReg[dest]*(signed long)(short)sh2->GenReg[source]);
					break;
				default:
					ConsoleMsg(MSG_WARN, "Unhandled Opcode at 0x%8x: 0x%4x", PC, opcode);
			}
			break;
		case (0x3):
			switch (opcode & 0xf) {
				case (0x0): //CMP/EQ Rm,Rn
					if (sh2->GenReg[source] == sh2->GenReg[dest])
						setTBit(1);
					else
						SR &= 0xfffffffe;
					break;
				case (0x2): //CMP/HS Rm,Rn
					if (sh2->GenReg[dest] >= sh2->GenReg[source])
						setTBit(1);
					else
						SR &= 0xfffffffe;
					break;
				case (0x3): //CMP/GE Rm,Rn
					if ((signed)sh2->GenReg[dest] >= (signed)sh2->GenReg[source])
						setTBit(1);
					else
						SR &= 0xfffffffe;
					break;
				case (0x4): //DIV1 Rm, Rn
					temp = (0x80000000 & sh2->GenReg[dest]) != 0;
					sh2->GenReg[dest] = ((sh2->GenReg[dest]<<1) | (SR&1));

					switch((SR&0x100 != 0)) {
						case 0:
							switch((SR&0x200 != 0)) {
								case 0:
									*(unsigned long*)&mult = sh2->GenReg[dest];
									sh2->GenReg[dest] -= sh2->GenReg[source];
									setQBit((sh2->GenReg[dest] > (uint32)mult) ^ temp);
									break;
								case 1:
									*(unsigned long*)&mult = sh2->GenReg[dest];
									sh2->GenReg[dest] += sh2->GenReg[source];
									setQBit((sh2->GenReg[dest] >= (uint32)mult) ^ temp);
									break;
							}
							break;
						case 1:
							switch((SR&0x200 != 0)) {
								case 0:
									*(unsigned long*)&mult = sh2->GenReg[dest];
									sh2->GenReg[dest] += sh2->GenReg[source];
									setQBit((sh2->GenReg[dest] < (uint32)mult) ^ temp);
									break;
								case 1:
									*(unsigned long*)&mult = sh2->GenReg[dest];
									sh2->GenReg[dest] -= sh2->GenReg[source];
									setQBit((sh2->GenReg[dest] <= (uint32)mult) ^ temp);
									break;
							}
							break;
					}
					setTBit((SR&0x100)^(SR&0x200));

					break;
				case (0x5): //DMULU.L Rm, Rn
					mult = ((uint64)sh2->GenReg[source] * (uint64)sh2->GenReg[dest]);
					MACL = (uint32)mult;
					MACH = (uint32)(mult >> 32);
					break;
				case (0x6): //CMP/HI Rm,Rn
					if (sh2->GenReg[dest] > sh2->GenReg[source])
						setTBit(1);
					else
						SR &= 0xfffffffe;
					break;
				case (0x7): //CMP/GT Rm,Rn
					if ((signed)sh2->GenReg[dest] > (signed)sh2->GenReg[source])
						setTBit(1);
					else
						SR &= 0xfffffffe;
					break;
				case (0x8): //SUB Rm,Rn
					sh2->GenReg[dest] -= sh2->GenReg[source];
					break;
				case (0xa): //SUBC Rm,Rn
					temp = sh2->GenReg[dest] - sh2->GenReg[source];
					if ((sh2->GenReg[dest] < temp) || (temp < temp - (SR&1)))
					{
						sh2->GenReg[dest] = temp - SR&1;
						setTBit(1);
					} else 
					{
						sh2->GenReg[dest] = temp - SR&1;
						setTBit(0);
					}
					break;
				case (0xb): //SUBV Rm,Rn **test
					temp = sh2->GenReg[dest] - sh2->GenReg[source];
					if (((signed long)(sh2->GenReg[dest] < 0) ^ (signed long)(sh2->GenReg[source] < 0)) && (temp < 0))
						setTBit(1);
					else
						setTBit(0);
					sh2->GenReg[dest] = temp;
					break;
				case (0xc): //ADD Rm,Rn
					sh2->GenReg[dest] += sh2->GenReg[source];
					break;
				case (0xd): //DMULS.L Rm, Rn
					mult = ((sint64)sh2->GenReg[source] * (sint64)sh2->GenReg[dest]);
					MACL = (uint32)mult;
					MACH = (uint32)(mult >> 32);
					break;
				case (0xe): //ADDC Rm,Rn **test
					temp = (uint32)(sh2->GenReg[dest] + sh2->GenReg[source]);
					if ((temp+(SR&1) < temp) || (temp < sh2->GenReg[dest]))
					{
						sh2->GenReg[dest] = temp + (SR&1);
						setTBit(1);
					} else {
						sh2->GenReg[dest] = temp + (SR&1);
						SR &= 0xfffffffe;
					}
					break;
				case (0xf): //ADDV Rm,Rn
					temp = sh2->GenReg[source] + sh2->GenReg[dest];
					if (!(((signed long)(sh2->GenReg[source] < 0) ^ (signed long)(sh2->GenReg[dest] < 0))) && (temp < 0))
						setTBit(1);
					else
						setTBit(0);
					sh2->GenReg[dest] = temp;
					break;
				default:
					ConsoleMsg(MSG_WARN, "Unhandled Opcode at 0x%8x: 0x%4x", PC, opcode);
			}
			break;
		case (0x4):
			switch (opcode & 0xff) {
				case (0x0):
				case (0x20): //SHLL Rn (0x0) <=> SHAL Rn (0x20)
					setTBit((sh2->GenReg[dest] >> 31) & 1);
					sh2->GenReg[dest] <<= 1;
					break;
				case (0x1): //SHLR Rn
					setTBit(sh2->GenReg[dest] & 1);
					sh2->GenReg[dest] >>= 1;
					break;
				case (0x2): //STS.L MACH,@-Rn
					sh2->GenReg[dest] -= 4;
					memSetLong(sh2->GenReg[dest], MACH);
					break;
				case (0x3): 
					sh2->GenReg[dest] -= 4;
					temp = (opcode >> 4) & 0xff;
					if (temp == 0) // STC.L SR,@-Rn
						memSetLong(sh2->GenReg[dest], SR);
					else if (temp == 1) //STC GBR,@-Rn
						memSetLong(sh2->GenReg[dest], GBR);
					else if (temp == 2) //STC VBR,@-Rn
						memSetLong(sh2->GenReg[dest], VBR);
					break;
				case (0x4): //ROTL Rn
					temp = ((sh2->GenReg[dest] >> 31) & 1);
					sh2->GenReg[dest] = (sh2->GenReg[dest] << 1) | (SR&1);
					setTBit(temp);
					break;
				case (0x5): //ROTR Rn
					temp = sh2->GenReg[dest] & 1;
					sh2->GenReg[dest] = (sh2->GenReg[dest] >> 1) | (uint32)((SR&1)<<31);
					setTBit(temp);
					break;
				case (0x6): //LDS.L @Rm+,MACH
					MACH = memGetLong(sh2->GenReg[dest]);
					sh2->GenReg[dest] += 4;
					break;
				case (0x7): //LDC.L @Rm+,SR
					SR = memGetLong(sh2->GenReg[dest]) & 0x3f3;
					sh2->GenReg[dest] += 4;
					break;
				case (0x8): //SHLL2 Rn
					sh2->GenReg[dest] <<= 2;
					break;
				case (0x9): //SHLR2 Rn
					sh2->GenReg[dest] >>= 2;
					break;
				case (0xa): //LDS Rm,MACH
					MACH = sh2->GenReg[dest];
					break;
				case (0xb): //JSR @Rm
					PR = PC + 4;
					temp = sh2->GenReg[dest];
					DelayBranch(temp);
					break;
				case (0xe): //LDC Rm,SR
					SR = sh2->GenReg[dest] & 0x3f3;
					break;
				case (0xf): //MAC.W @Rm+,@Rn+
					temp = ((signed long)memGetWord(sh2->GenReg[dest])*(signed long)memGetWord(sh2->GenReg[source]));
					sh2->GenReg[dest] += 4;
					sh2->GenReg[source] += 4;

					if (SR&2)
					{
						MACL = (uint32)((signed)MACL + (signed)temp);
						if (MACL > 0x80000000)
						{
							MACH = 1;
							MACL &= 0x8fffffff;
						}
					}
					else
					{
						mult = ((uint64)(MACH<<32))+MACL+temp;
						MACL = (uint32)mult;
						MACH = (uint32)(mult>>32);
					}
					break;
				case (0x10): //DT Rn
					if (--sh2->GenReg[dest] == 0)
						setTBit(1);
					else
						SR &= 0xfffffffe;
					break;
				case (0x11): //CMP/PZ Rn
					if ((signed)sh2->GenReg[dest] >= 0)
						setTBit(1);
					else
						SR &= 0xfffffffe;
					break;
				case (0x12): //STS.L MACL,@-Rn
					sh2->GenReg[dest] -= 4;
					memSetLong(sh2->GenReg[dest], MACL);
					break;
				case (0x15): //CMP/PL Rn
					if ((signed)sh2->GenReg[dest] > 0)
						setTBit(1);
					else
						SR &= 0xfffffffe;
					break;
				case (0x16): //LDS.L @Rm+,MACL
					MACL = memGetLong(sh2->GenReg[dest]);
					sh2->GenReg[dest] += 4;
					break;
				case (0x17): //LDC.L @Rm+,GBR
					GBR = memGetLong(sh2->GenReg[dest]);
					sh2->GenReg[dest] += 4;
					break;
				case (0x18): //SHLL8 Rn
					sh2->GenReg[dest] <<= 8;
					break;
				case (0x19): //SHLR8 Rn
					sh2->GenReg[dest] >>= 8;
					break;
				case (0x1a): //LDS Rm,MACL
					MACL = sh2->GenReg[dest];
					break;
				case (0x1b): //TAS.B @Rn
					temp = (uint32)memGetByte(sh2->GenReg[dest]);
					if (temp == 0) setTBit(1);
					else setTBit(0);
					temp |= 0x80;
					memSetByte(sh2->GenReg[dest], (uint8)temp);
					break;
				case (0x1e): //LDC Rm,GBR
					GBR = sh2->GenReg[dest];
					break;
				case (0x21): //SHAR Rn
					temp = sh2->GenReg[dest] & 0x80000000;
					setTBit(sh2->GenReg[dest] & 1);
					sh2->GenReg[dest] = ((sh2->GenReg[dest] >> 1) & 0x7fffffff) | temp;
					break;
				case (0x22): //STS.L PR,@-Rn
					sh2->GenReg[dest] -= 4;
					memSetLong(sh2->GenReg[dest], PR);
					break;
				case (0x24): //ROTCL Rn
					temp = (sh2->GenReg[dest] >> 31) & 1;
					sh2->GenReg[dest] = (sh2->GenReg[dest] << 1) | (SR&1);
					setTBit(temp);
					break;
				case (0x25): //ROTCR Rn
					temp = sh2->GenReg[dest] & 1;
					sh2->GenReg[dest] = (sh2->GenReg[dest] >> 1) | (uint32)((SR&1) << 31);
					setTBit(temp);
					break;
				case (0x26): //LDS.L @Rm+,PR
					PR = memGetLong(sh2->GenReg[dest]);
					sh2->GenReg[dest] += 4;
					break;
				case (0x27): //LDC.L @Rm+,VBR
					VBR = memGetLong(sh2->GenReg[dest]);
					sh2->GenReg[dest] += 4;
					break;
				case (0x28): //SHLL16 Rn
					sh2->GenReg[dest] <<= 16;
					break;
				case (0x29): //SHLR16 Rn
					sh2->GenReg[dest] >>= 16;
					break;
				case (0x2a): //LDS Rm,PR
					PR = sh2->GenReg[dest];
					break;
				case (0x2b): //JMP @Rm
					temp = sh2->GenReg[dest];
					DelayBranch(temp);
					break;
				case (0x2e): //LDC Rm,VBR
					VBR = sh2->GenReg[dest];
					break;
				default:
					ConsoleMsg(MSG_WARN, "Unhandled Opcode at 0x%8x: 0x%4x", PC, opcode);
			}
			break;
		case (0x5): //MOV.L @(disp,Rm),Rn
			sh2->GenReg[dest] = memGetLong(sh2->GenReg[source] + (offset1<<2));
			break;
		case (0x6): //MOV
			switch (opcode & 0xf) {
				case (0x0): //MOV.B @Rm,Rn
					sh2->GenReg[dest] = (signed char)memGetByte(sh2->GenReg[source]);
					break;
				case (0x1): //MOV.W @Rm,Rn
					sh2->GenReg[dest] = (signed short)memGetWord(sh2->GenReg[source]);
					break;
				case (0x2): //MOV.L
					sh2->GenReg[dest] = memGetLong(sh2->GenReg[source]);
					break;
				case (0x3): //MOV
					sh2->GenReg[dest] = sh2->GenReg[source];
					break;
				case (0x4): //MOV.B
					sh2->GenReg[dest] = (signed char)memGetByte(sh2->GenReg[source]++);
					break;
				case (0x5): //MOV.W
					sh2->GenReg[dest] = (signed short)memGetWord(sh2->GenReg[source]);
					sh2->GenReg[source] += 2;
					break;
				case (0x6): //MOV.L @Rm+,Rn
					sh2->GenReg[dest] = (signed long)memGetLong(sh2->GenReg[source]);
					sh2->GenReg[source] += 4;
					break;
				case (0x7): //NOT Rm,Rn
					sh2->GenReg[dest] = ~sh2->GenReg[source];
					break;
				case (0x8): //SWAP.B
					sh2->GenReg[dest] = (sh2->GenReg[dest] & 0xffff0000)|(uint16)(((uint16)sh2->GenReg[source]>>8)|((uint16)sh2->GenReg[source]<<8));
					break;
				case (0x9): //SWAP.W
					sh2->GenReg[dest] = swapLong(sh2->GenReg[source]); //(sh2->GenReg[source] >> 16) | (sh2->GenReg[source] << 16);
					break;
				case (0xa): //NEGC Rm,Rn
					temp = (signed long)(0-sh2->GenReg[source]);
					sh2->GenReg[dest] = (signed long)(temp) - (SR&1);
					if (0 < (signed)temp)
						setTBit(1);
					else
						SR &= 0xfffffffe;
					if (temp < sh2->GenReg[dest]) setTBit(1);
					break;
				case (0xb): //NEG Rm,Rn
					sh2->GenReg[dest] = (signed long)(0-sh2->GenReg[source]);
					break;
				case (0xc): //EXTU.B Rm,Rn
					sh2->GenReg[dest] = sh2->GenReg[source] & 0xff;
					break;
				case (0xd): //EXTU.W Rm,Rn
					sh2->GenReg[dest] = sh2->GenReg[source] & 0xffff;
					break;
				case (0xe): //EXTS.B Rm,Rn
					sh2->GenReg[dest] = (signed long)((char)sh2->GenReg[source]);
					break;
				case (0xf): //EXTS.W Rm,Rn
					sh2->GenReg[dest] = (signed long)((short)sh2->GenReg[source]);
					break;
				default:
					ConsoleMsg(MSG_WARN, "Unhandled Opcode at 0x%8x: 0x%4x", PC, opcode);
			}
			break;
		case (0x7):	//ADDI #imm,Rn
			sh2->GenReg[dest] += (signed long)immediate;
			break;
		case (0x8): //MOV
			switch ((opcode >> 8) & 0xf) {
				case (0x0): //MOV.B
					memSetByte(sh2->GenReg[source]+offset1, (uint8)sh2->GenReg[0]);
					break;
				case (0x1): //MOV.W
					memSetWord(sh2->GenReg[source]+(offset1<<1), (uint16)sh2->GenReg[0]);
					break;
				case (0x4): //MOV.B
					sh2->GenReg[0] = (signed long)memGetByte(sh2->GenReg[source]+offset1);
					break;
				case (0x5): //MOV.W
					sh2->GenReg[0] = (signed long)memGetWord(sh2->GenReg[source]+(offset1<<1));
					break;
				case (0x8): //CMP_EQ #imm,R0
					if ((signed)sh2->GenReg[0] == (signed long)immediate)
						setTBit(1);
					else
						SR &= 0xfffffffe;
					break;
				case (0x9): //BT
					if (SR&1)
						PC += (signed char)((immediate << 1) + 4) - 2;
					break;
				case (0xb): //BF
					if (!(SR&1))
						PC += (signed char)((immediate << 1) + 4) - 2;
					break;
				case (0xd): //BT/S
					if (SR&1)
					{
						temp = PC + (signed char)((immediate << 1) + 4);
						DelayBranch(temp);
					}
					break;
				case (0xf): //BF/S
					if (!(SR&1))
					{
						temp = PC + (signed char)((immediate << 1) + 4);
						DelayBranch(temp);
					}
					break;
				default:
					ConsoleMsg(MSG_WARN, "Unhandled Opcode at 0x%8x: 0x%8x", PC, opcode);
			}
			break;
		case (0x9): //MOV.W
			sh2->GenReg[dest] = (signed long)memGetWord(PC+(offset2<<1)+4);
			break;
		case (0xa): //BRA
			temp = (offset3 << 1);
			if (temp & 0x1000)
				temp |= 0xfffff000;
			temp = PC + (signed long)temp + 4;
			DelayBranch(temp);
			break;
		case (0xb): //BSR
			PR = PC + 4;
			temp = (signed short)(offset3 << 1);
			if (temp & 0x1000)
				temp |= 0xfffff000;
			temp = PC + (signed long)temp + 4;
			DelayBranch(temp);
			break;
		case (0xc):
			switch ((opcode >> 8) & 0xf) {
				case (0x0): //MOV.B  R0,@(disp,GBR)
					memSetByte(offset2+GBR, (uint8)sh2->GenReg[0]);
					break;
				case (0x1): //MOV.W  R0,@(disp,GBR)
					memSetWord((offset2<<1)+GBR, (uint16)sh2->GenReg[0]);
					break;
				case (0x2): //MOV.L  R0,@(disp,GBR)
					memSetLong((offset2<<2)+GBR, sh2->GenReg[0]);
					break;
				case (0x3): //TRAPA #imm
					sh2->GenReg[15] -= 4;
					memSetLong(sh2->GenReg[15], SR);
					sh2->GenReg[15] -= 4;
					memSetLong(sh2->GenReg[15], PC-2);
					PC = memGetLong(VBR + ((uint32)immediate << 2)) + 4 - 2;
					break;
				case (0x4): //MOV.B  @(disp,GBR),R0
					sh2->GenReg[0] = (signed long)memGetByte(offset2+GBR);
					break;
				case (0x5): //MOV.W  @(disp,GBR),R0
					sh2->GenReg[0] = (signed long)memGetWord((offset2<<1)+GBR);
					break;
				case (0x6): //MOV.L  @(disp,GBR),R0
					sh2->GenReg[0] = memGetLong((offset2<<2)+GBR);
					break;
				case (0x7): //MOVA
					sh2->GenReg[0] = (PC&0xfffffffc)+(offset2<<2)+4;
					break;
				case (0x8): //TST #imm,R0
					if (((uint8)sh2->GenReg[0] & offset2) == 0)
						setTBit(1);
					else
						setTBit(0);
					break;
				case (0x9): //AND #imm,R0
					sh2->GenReg[0] &= (uint32)immediate;
					break;
				case (0xa): //XOR #imm,R0
					sh2->GenReg[0] ^= (uint32)immediate;
					break;
				case (0xb): //ORI #imm,R0
					sh2->GenReg[0] |= (uint32)immediate;
					break;
				case (0xc): //TST.B #imm,@(R0,GBR)
					if (((uint32)memGetByte(GBR + sh2->GenReg[0]) & (uint32)immediate) == 0)
						setTBit(1);
					else
						setTBit(0);
					break;
				case (0xd): //AND.B #imm,@(R0,GBR)
					memSetByte(GBR + sh2->GenReg[0], (uint8)((uint32)memGetByte(GBR + sh2->GenReg[0]) & (uint32)immediate));
					break;
				case (0xe): //XOR.B #imm,@(R0,GBR)
					memSetByte(GBR + sh2->GenReg[0], (uint8)((uint32)memGetByte(GBR + sh2->GenReg[0]) ^ (uint32)immediate));
					break;
				case (0xf): //OR.B #imm,@(R0,GBR)
					memSetByte(GBR + sh2->GenReg[0], (uint8)((uint32)memGetByte(GBR + sh2->GenReg[0]) | (0x000000FF & (uint32)immediate)));
					break;
				default:
					ConsoleMsg(MSG_WARN, "Unhandled Opcode at 0x%8x: 0x%8x", PC, opcode);
			}
			break;
		case (0xd): //MOV.L
			sh2->GenReg[dest] = memGetLong((PC&0xfffffffc)+(offset2<<2)+4);
			break;
		case (0xe): // MOV
			sh2->GenReg[dest] = (long)immediate;
			break;
		default:
			ConsoleMsg(MSG_WARN, "Unhandled Opcode at 0x%8x: (0x%4x)", PC, opcode);
			break;
	}
}