// SMPC.H
// System Manager and Peripheral Control Header File

#ifndef _SMPC_H
#define _SMPC_H

#define COMREG	*(unsigned short*)&SMPC[0x1f]
#define SMPC_SR *(unsigned short*)&SMPC[0x61]
#define SMPC_SF *(unsigned short*)&SMPC[0x63]
//#define INTBACK *(unsigned short*)&SMPC[0x10]

#define IREG ((unsigned short*)&SMPC[0x1])
#define OREG ((unsigned short*)&SMPC[0x21])

// SH2 Peripheral Control
#define PDR1	SMPC[0x75]
#define DDR1	SMPC[0x79]
#define PDR2	SMPC[0x77]
#define DDR2	SMPC[0x7b]
#define IOSEL	SMPC[0x7d]
#define EXILE	SMPC[0x7f]

#define SMPC_NOP     0x01
#define SMPC_STATUS  0x02
#define SMPC_INPUT   0x03

void updateSMPC(void);
void InterruptBack(void);

#endif