        .MODEL  LARGE
        .STACK  400h
        .DATA
i8080AF LABEL   WORD
i8080F  DB      44h
i8080A  DB      00h
i8080BC LABEL   WORD
i8080C  DB      00h
i8080B  DB      00h
i8080DE LABEL   WORD
i8080E  DB      00h
i8080D  DB      00h
i8080HL LABEL   WORD
i8080L  DB      00h
i8080H  DB      00h
i8080PC DW      0000h
i8080SP DW      0000h
i8080IM DB      00h
OP      DB      00h
FHANDLE DW      0000h
HHANDLE DW      0000h
HDRNAME DB      13 dup(00h)
RNAME   DB      13 dup(00h)
        DB      13 dup(00h)
        DB      13 dup(00h)
        DB      13 dup(00h)
        DB      13 dup(00h)
        DB      13 dup(00h)
RLOC    DW      0000h
        DW      0000h
        DW      0000h
        DW      0000h
        DW      0000h
        DW      0000h
ROMNUM  DW      0000h
RSIZE   DW      0000h
IOARRAY DB      256 dup(00h)
BTMPIN  DB      00h
OUTARRY DB      256 dup(00h)
SHORTER DB      'is too short to work!',24h
NOEXIST DB      'doesn',27h,'t exist!',24h
NOFILEN DB      'You must include a filename!',24h
F2LONG  DB      'Filename is too long! 12 Characters maximum:',0Dh,0Ah
        DB      '       8 Characters maximum for main name',0Dh,0Ah
        DB      '       1 Character for period',0Dh,0Ah
        DB      '       3 Characters maximum for extention.',24h
ERRORO  DB      'Unknown error, program terminated.',24h
INSTRUC DB      'Emul80 Midway Arcade Emulator v1.0 (c) 2001 Ryan Holtz',0Dh,0Ah
        DB      'E-mail the creator at: mega64man1@hotmail.com',0Dh,0Ah
        DB      '       USAGE:          Emul80 <filename>',0Dh,0Ah
        DB      'Please note, there must be an existing header file for the filename.',0Dh,0Ah,24h
NOHEADR DB      'There is no header file for that game! Please create or download one.',24h
HDRSHRT DB      'The header file must be at least 256 bytes in length!',24h
TEMPBYT DB      00h
ROMPTR  DW      0000h
ASCNUM  DB      4 dup(00h),24h
TEMPWRD DW      0000h
INCLUDE REVERSE.INC
IEN     DB      00h
IRQ     DB      10h
ISK     DB      00h
HALTED  DB      00h
EIINT   DB      00h
COUNTER DD      0000411Ah
REGS    DB      'PC-       AF-       BC-       DE-    ',0Dh,0Ah
        DB      'HL-       SP-       OP-       CY-    ',0Dh,0Ah
        DB      'IE-       IQ-       IS-       HT-    ',24h
INCOUNT DW      0400h
KEYPRES DB      00h
OUTOFF  DW      OFFSET  OUTARRY
INOFF   DW      OFFSET  IOARRAY
SHFTOUT DW      0000h
BTMPOUT DW      0000h
BTMPTMP DB      00h

MEMARRY SEGMENT
MAINMEM DB      16384 dup(00h)
        DB      16384 dup(00h)
        DB      16384 dup(00h)
        DB      16384 dup(00h)
MEMARRY ENDS

.386
.CODE
MAIN    PROC    NEAR
        ASSUME  ES:MEMARRY
        INCLUDE GENERIC.MAC
        INCLUDE 8080.MAC
        INCLUDE TEXT.MAC
        INCLUDE GRAPH.MAC
        INCLUDE REVERSE.MAC
        INCLUDE PORT.MAC
        MOV     AX,@data
        MOV     DS,AX
        CALL    GETHEDR
        CALL    READHDR
        MOV     AX,MEMARRY
        MOV     ES,AX
        SETMODE 0Fh
        CALL    RST8080
        CALL    RR
        CALL    GO8080
        ENDPROG
MAIN    ENDP

RST8080 PROC    NEAR
        LOCALS
        MOV     CX,0FFFFh
        MOV     BX,0000h
        MOV     AX,0000h
@@EraseMem:
        MOV     BYTE PTR ES:[BX],AL
        INC     BX
        LOOP    @@EraseMem
        MOV     i8080A,00h
        MOV     i8080B,00h
        MOV     i8080C,00h
        MOV     i8080D,00h
        MOV     i8080E,00h
        MOV     i8080F,00h
        MOV     i8080H,00h
        MOV     i8080L,00h
        MOV     i8080PC,0000h
        MOV     i8080SP,0000h     
        RET
RST8080 ENDP

GO8080  PROC    NEAR
        LOCALS
@@Do8080:
        MOV     BX,i8080PC
        MOV     AL,BYTE PTR ES:[BX]
        MOV     OP,AL
        ;CALL    DREGS
        ;MOV     AH,08h
        ;INT     21h
        ;CMP     AL,71h
        ;JE      @@Done8080
        CALL    DECODE
        INC     i8080PC
        CMP     COUNTER,00000000h
        JLE     @@UpdateIt
        JMP     @@Do8080
@@UpdateIt:
        CALL    UPDATE
        XOR     IRQ,18h
        CALL    DOINT
        MOV     COUNTER,0000411Ah
        JMP     @@Do8080
@@Done8080:
        RET
GO8080  ENDP

DECODE  PROC    NEAR
        LOCALS
@@00h:                                  ; NOP
        CMP     OP,10h
        JNB     @@10h
        CMP     OP,00h
        JNE     @@01h
        SUB     COUNTER,0004h        
        RET
@@01h:                                  ; LXI B,nn
        CMP     OP,01h
        JNE     @@02h
        INC     i8080PC        
        MOV     BX,i8080PC
        INC     i8080PC
        MOV     AX,WORD PTR ES:[BX]
        MOV     i8080BC,AX
        SUB     COUNTER,000Ah
        RET
@@02h:                                  ; STAX B
        CMP     OP,02h
        JNE     @@03h
        MOV     AL,i8080A
        MOV     BX,i8080BC
        WRITMEM AL
        SUB     COUNTER,0007h
        RET
@@03h:                                  ; INX B
        CMP     OP,03h
        JNE     @@04h
        INC     i8080BC
        SUB     COUNTER,0005h
        RET
@@04h:                                  ; INR B                                 
        CMP     OP,04h
        JNE     @@05h
        INC     i8080B
        SZHP    i8080F
        SUB     COUNTER,0005h
        RET
@@05h:                                  ; DCR B
        CMP     OP,05h
        JNE     @@06h
        DEC     i8080B
        SZHP    i8080F
        SUB     COUNTER,0005h
        RET
@@06h:                                  ; MVI B,n
        CMP     OP,06h
        JNE     @@07h
        INC     i8080PC
        MOV     BX,i8080PC
        MOV     AL,BYTE PTR ES:[BX]
        MOV     i8080B,AL
        SUB     COUNTER,0007h
        RET
@@07h:                                  ; RLC
        CMP     OP,07h
        JNE     @@08h
        ROL     i8080A,01h
        CHECKC  i8080F
        SUB     COUNTER,0004h
        RET
@@08h:                                  ; Invalid                                
        CMP     OP,08h
        JNE     @@09h
        SUB     COUNTER,0004h
        RET
@@09h:                                  ; DAD B
        CMP     OP,09h
        JNE     @@0Ah
        MOV     CX,i8080BC
        ADD     i8080HL,CX
        HC      i8080F
        SUB     COUNTER,000Ah
        RET
@@0Ah:                                  ; LDAX B 
        CMP     OP,0Ah
        JNE     @@0Bh
        MOV     BX,i8080BC
        MOV     AL,BYTE PTR ES:[BX]
        MOV     i8080A,AL
        SUB     COUNTER,0007h
        RET
@@0Bh:                                  ; DCX B   
        CMP     OP,0Bh
        JNE     @@0Ch
        DEC     i8080BC
        SUB     COUNTER,0005h
        RET
@@0Ch:                                  ; INR C
        CMP     OP,0Ch
        JNE     @@0Dh
        INC     i8080C
        SZHP    i8080F
        SUB     COUNTER,0005h
        RET                                     
@@0Dh:                                  ; DCR C
        CMP     OP,0Dh
        JNE     @@0Eh
        DEC     i8080C
        SZHP    i8080F
        SUB     COUNTER,0005h
        RET
@@0Eh:                                  ; MVI C,n
        CMP     OP,0Eh
        JNE     @@0Fh
        INC     i8080PC
        MOV     BX,i8080PC
        MOV     AL,BYTE PTR ES:[BX]
        MOV     i8080C,AL
        SUB     COUNTER,0007h
        RET
@@0Fh:                                  ; RRC
        CMP     OP,0Fh
        JNE     @@10h
        ROR     i8080A,01h
        CHECKC  i8080F
        SUB     COUNTER,0004h
        RET             
@@10h:                                  ; Invalid
        CMP     OP,20h
        JNB     @@20h
        CMP     OP,10h
        JNE     @@11h
        SUB     COUNTER,0008h
        RET
@@11h:                                  ; LXI D,nn
        CMP     OP,11h
        JNE     @@12h
        INC     i8080PC
        MOV     BX,i8080PC
        INC     i8080PC
        MOV     AX,WORD PTR ES:[BX]
        MOV     i8080DE,AX
        SUB     COUNTER,000Ah
        RET
@@12h:                                  ; STAX D
        CMP     OP,12h
        JNE     @@13h
        MOV     AL,i8080A
        MOV     BX,i8080DE
        WRITMEM AL
        SUB     COUNTER,0007h
        RET
@@13h:                                  ; INX D
        CMP     OP,13h
        JNE     @@14h
        INC     i8080DE
        SUB     COUNTER,0005h
        RET
@@14h:                                  ; INR D
        CMP     OP,14h
        JNE     @@15h
        INC     i8080D
        SZHP    i8080F
        SUB     COUNTER,0005h
        RET
@@15h:                                  ; DCR D
        CMP     OP,15h
        JNE     @@16h
        DEC     i8080D
        SZHP    i8080F
        SUB     COUNTER,0005h
        RET
@@16h:                                  ; MVI D,n
        CMP     OP,16h
        JNE     @@17h
        INC     i8080PC
        MOV     BX,i8080PC
        MOV     AL,BYTE PTR ES:[BX]
        MOV     i8080D,AL
        SUB     COUNTER,0007h
        RET
@@17h:                                  ; RAL
        CMP     OP,17h
        JNE     @@18h
        CY80_86 i8080F
        RCL     i8080A,01h
        CHECKC  i8080F
        SUB     COUNTER,0004h
        RET
@@18h:                                  ; Invalid
        CMP     OP,18h
        JNE     @@19h
        SUB     COUNTER,0007h
        RET
@@19h:                                  ; DAD D
        CMP     OP,19h
        JNE     @@1Ah
        MOV     AX,i8080DE
        ADD     i8080HL,AX
        HC      i8080F
        SUB     COUNTER,000Ah
        RET
@@1Ah:                                  ; LDAX D 
        CMP     OP,1Ah
        JNE     @@1Bh
        MOV     BX,i8080DE
        MOV     AL,BYTE PTR ES:[BX]
        MOV     i8080A,AL
        SUB     COUNTER,0007h
        RET
@@1Bh:                                  ; DCX D
        CMP     OP,1Bh
        JNE     @@1Ch
        DEC     i8080DE
        SUB     COUNTER,0005h
        RET
@@1Ch:                                  ; INR E
        CMP     OP,1Ch
        JNE     @@1Dh
        INC     i8080E
        SZHP    i8080F
        SUB     COUNTER,0005h
        RET
@@1Dh:                                  ; DCR E
        CMP     OP,1Dh
        JNE     @@1Eh
        DEC     i8080E
        SZHP    i8080F
        SUB     COUNTER,0005h
        RET
@@1Eh:                                  ; MVI E,n
        CMP     OP,1Eh
        JNE     @@1Fh
        INC     i8080PC
        MOV     BX,i8080PC
        MOV     AL,BYTE PTR ES:[BX]
        MOV     i8080E,AL
        SUB     COUNTER,0007h
        RET
@@1Fh:                                  ; RAR
        CMP     OP,1Fh
        JNE     @@20h
        CY80_86 i8080F
        RCR     i8080A,01h
        CHECKC  i8080F
        SUB     COUNTER,0004h
        RET
@@20h:                                  ; Invalid
        CMP     OP,30h
        JNB     @@30h
        CMP     OP,20h
        JNE     @@21h
        SUB     COUNTER,0007h
        RET
@@21h:                                  ; LXI H,nn
        CMP     OP,21h
        JNE     @@22h
        INC     i8080PC
        MOV     BX,i8080PC
        INC     i8080PC
        MOV     AX,WORD PTR ES:[BX]
        MOV     i8080HL,AX
        SUB     COUNTER,000Ah
        RET
@@22h:                                  ; SHLD aa
        CMP     OP,22h
        JNE     @@23h
        INC     i8080PC
        MOV     BX,i8080PC
        INC     i8080PC
        MOV     BX,WORD PTR ES:[BX]
        MOV     AX,i8080HL
        WRITMEM AL
        INC     BX
        WRITMEM AH
        SUB     COUNTER,0010h
        RET
@@23h:                                  ; INX H
        CMP     OP,23h
        JNE     @@24h
        INC     i8080HL
        SUB     COUNTER,0005h
        RET
@@24h:                                  ; INR H
        CMP     OP,24h
        JNE     @@25h
        INC     i8080H
        SZHP    i8080F
        SUB     COUNTER,0005h
        RET
@@25h:                                  ; DCR H
        CMP     OP,25h
        JNE     @@26h
        DEC     i8080H
        SZHP    i8080F
        SUB     COUNTER,0005h
        RET
@@26h:                                  ; MVI H,n
        CMP     OP,26h
        JNE     @@27h
        INC     i8080PC
        MOV     BX,i8080PC
        MOV     AL,BYTE PTR ES:[BX]
        MOV     i8080H,AL
        SUB     COUNTER,0007h
        RET
@@27h:                                  ; DAA
        CMP     OP,27h
        JNE     @@28h
        MOV     AH,i8080F
        SAHF
        DAA
        LAHF
        AND     AH,11010101B
        AND     i8080F,00101010B
        OR      i8080F,CH
        SUB     COUNTER,0004h
        RET
@@28h:                                  ; Invalid
        CMP     OP,28h
        JNE     @@29h
        SUB     COUNTER,0007h
        RET
@@29h:                                  ; DAD H
        CMP     OP,29h
        JNE     @@2Ah
        MOV     BX,i8080HL
        ADD     i8080HL,BX
        HC      i8080F
        SUB     COUNTER,000Ah
        RET
@@2Ah:                                  ; LHLD aa
        CMP     OP,2Ah
        JNE     @@2Bh
        INC     i8080PC
        MOV     BX,i8080PC
        INC     i8080PC
        MOV     BX,WORD PTR ES:[BX]
        MOV     AX,WORD PTR ES:[BX]
        MOV     i8080HL,AX
        SUB     COUNTER,0010h
        RET
@@2Bh:                                  ; DCX H
        CMP     OP,2Bh
        JNE     @@2Ch
        DEC     i8080HL
        SUB     COUNTER,0005h
        RET
@@2Ch:                                  ; INR L
        CMP     OP,2Ch
        JNE     @@2Dh
        INC     i8080L
        SZHP    i8080F
        SUB     COUNTER,0005h
        RET
@@2Dh:                                  ; DCR L
        CMP     OP,2Dh
        JNE     @@2Eh
        DEC     i8080L
        SZHP    i8080F
        SUB     COUNTER,0005h
        RET
@@2Eh:                                  ; MVI L,n
        CMP     OP,2Eh
        JNE     @@2Fh
        INC     i8080PC
        MOV     BX,i8080PC
        MOV     AL,BYTE PTR ES:[BX]
        MOV     i8080L,AL
        SUB     COUNTER,0007h
        RET
@@2Fh:                                  ; CMA
        CMP     OP,2Fh
        JNE     @@30h
        NOT     i8080A
        SUB     COUNTER,0004h
        RET
@@30h:                                  ; Invalid
        CMP     OP,40h
        JNB     @@40h
        CMP     OP,30h
        JNE     @@31h
        SUB     COUNTER,0004h
        RET
@@31h:                                  ; LXI SP,nn
        CMP     OP,31h
        JNE     @@32h
        INC     i8080PC
        MOV     BX,i8080PC
        INC     i8080PC
        MOV     AX,WORD PTR ES:[BX]
        MOV     i8080SP,AX
        SUB     COUNTER,000Ah
        RET
@@32h:                                  ; STA aa
        CMP     OP,32h
        JNE     @@33h
        INC     i8080PC
        MOV     BX,i8080PC
        INC     i8080PC
        MOV     BX,WORD PTR ES:[BX]
        MOV     AL,i8080A
        WRITMEM AL
        SUB     COUNTER,000Dh
        RET
@@33h:                                  ; INX SP
        CMP     OP,33h
        JNE     @@34h
        INC     i8080SP
        SUB     COUNTER,0005h
        RET
@@34h:                                  ; INR M
        CMP     OP,34h
        JNE     @@35h
        MOV     BX,i8080HL
        MOV     CL,BYTE PTR ES:[BX]
        INC     CL
        SZHP    i8080F
        WRITMEM CL
        SUB     COUNTER,000Ah
        RET
@@35h:                                  ; DCR M
        CMP     OP,35h
        JNE     @@36h
        MOV     BX,i8080HL
        MOV     CL,BYTE PTR ES:[BX]
        DEC     CL
        SZHP    i8080F
        WRITMEM CL
        SUB     COUNTER,000Ah
        RET
@@36h:                                  ; MVI M,n
        CMP     OP,36h
        JNE     @@37h
        INC     i8080PC
        MOV     BX,i8080PC
        MOV     AL,BYTE PTR ES:[BX]
        MOV     BX,i8080HL
        WRITMEM AL
        SUB     COUNTER,000Ah
        RET
@@37h:                                  ; STC
        CMP     OP,37h
        JNE     @@38h
        OR      i8080F,00000001B
        SUB     COUNTER,0004h
        RET
@@38h:                                  ; Invalid
        CMP     OP,38h
        JNE     @@39h
        SUB     COUNTER,0007h
        RET
@@39h:                                  ; DAD SP
        CMP     OP,39h
        JNE     @@3Ah
        MOV     BX,i8080SP
        ADD     i8080HL,BX
        HC      i8080F
        SUB     COUNTER,000Ah
        RET
@@3Ah:                                  ; LDA aa 
        CMP     OP,3Ah
        JNE     @@3Bh
        INC     i8080PC
        MOV     BX,i8080PC
        INC     i8080PC
        MOV     BX,WORD PTR ES:[BX]
        MOV     AL,BYTE PTR ES:[BX]
        MOV     i8080A,AL
        SUB     COUNTER,000Dh
        RET
@@3Bh:                                  ; DCX SP
        CMP     OP,3Bh
        JNE     @@3Ch
        DEC     i8080SP
        SUB     COUNTER,0005h
        RET
@@3Ch:                                  ; INR A
        CMP     OP,3Ch
        JNE     @@3Dh
        INC     i8080A
        SZHP    i8080F
        SUB     COUNTER,0005h
        RET
@@3Dh:                                  ; DCR A
        CMP     OP,3Dh
        JNE     @@3Eh
        DEC     i8080A
        SZHP    i8080F
        SUB     COUNTER,0005h
        RET
@@3Eh:                                  ; MVI A,n
        CMP     OP,3Eh
        JNE     @@3Fh
        INC     i8080PC
        MOV     BX,i8080PC
        MOV     AL,BYTE PTR ES:[BX]
        MOV     i8080A,AL
        SUB     COUNTER,0007h
        RET
@@3Fh:                                  ; CMC
        CMP     OP,3Fh
        JNE     @@40h
        MOV     AL,i8080F
        AND     AL,00000001B
        NOT     AL
        AND     AL,00000001B
        AND     i8080F,11111110B
        OR      i8080F,AL
        SUB     COUNTER,0004h
        RET
@@40h:                                  ; MOV B,B
        CMP     OP,50h
        JNB     @@50h
        CMP     OP,40h
        JNE     @@41h
        MOVE    i8080B,i8080B
        SUB     COUNTER,0005h
        RET
@@41h:                                  ; MOV B,C
        CMP     OP,41h
        JNE     @@42h
        MOVE    i8080B,i8080C
        SUB     COUNTER,0005h
        RET
@@42h:                                  ; MOV B,D
        CMP     OP,42h
        JNE     @@43h
        MOVE    i8080B,i8080D
        SUB     COUNTER,0005h
        RET
@@43h:                                  ; MOV B,E
        CMP     OP,43h
        JNE     @@44h
        MOVE    i8080B,i8080E
        SUB     COUNTER,0005h
        RET
@@44h:                                  ; MOV B,H
        CMP     OP,44h
        JNE     @@45h
        MOVE    i8080B,i8080H
        SUB     COUNTER,0005h
        RET
@@45h:                                  ; MOV B,L
        CMP     OP,45h
        JNE     @@46h
        MOVE    i8080B,i8080L
        SUB     COUNTER,0005h
        RET
@@46h:                                  ; MOV B,M
        CMP     OP,46h
        JNE     @@47h
        MOV     BX,i8080HL
        MOV     AL,BYTE PTR ES:[BX]
        MOV     i8080B,AL
        SUB     COUNTER,0007h
        RET
@@47h:                                  ; MOV B,A
        CMP     OP,47h
        JNE     @@48h
        MOVE    i8080B,i8080A
        SUB     COUNTER,0005h
        RET
@@48h:                                  ; MOV C,B
        CMP     OP,48h
        JNE     @@49h
        MOVE    i8080C,i8080B
        SUB     COUNTER,0005h
        RET
@@49h:                                  ; MOV C,C
        CMP     OP,49h
        JNE     @@4Ah
        MOVE    i8080C,i8080C
        SUB     COUNTER,0005h
        RET
@@4Ah:                                  ; MOV C,D
        CMP     OP,4Ah
        JNE     @@4Bh
        MOVE    i8080C,i8080D
        SUB     COUNTER,0005h
        RET
@@4Bh:                                  ; MOV C,E
        CMP     OP,4Bh
        JNE     @@4Ch
        MOVE    i8080C,i8080E
        SUB     COUNTER,0005h
        RET
@@4Ch:                                  ; MOV C,H
        CMP     OP,4Ch
        JNE     @@4Dh
        MOVE    i8080C,i8080H
        SUB     COUNTER,0005h
        RET
@@4Dh:                                  ; MOV C,L
        CMP     OP,4Dh
        JNE     @@4Eh
        MOVE    i8080C,i8080L
        SUB     COUNTER,0005h
        RET
@@4Eh:                                  ; MOV C,M
        CMP     OP,4Eh
        JNE     @@4Fh
        MOV     BX,i8080HL
        MOV     AL,BYTE PTR ES:[BX]
        MOV     i8080C,AL
        SUB     COUNTER,0007h
        RET
@@4Fh:                                  ; MOV C,A
        CMP     OP,4Fh
        JNE     @@50h
        MOVE    i8080C,i8080A
        SUB     COUNTER,0005h
        RET
@@50h:                                  ; MOV D,B
        CMP     OP,60h
        JNB     @@60h
        CMP     OP,50h
        JNE     @@51h
        MOVE    i8080D,i8080B
        SUB     COUNTER,0005h
        RET
@@51h:                                  ; MOV D,C
        CMP     OP,51h
        JNE     @@52h
        MOVE    i8080D,i8080C
        SUB     COUNTER,0005h
        RET
@@52h:                                  ; MOV D,D
        CMP     OP,52h
        JNE     @@53h
        MOVE    i8080D,i8080D
        SUB     COUNTER,0005h
        RET
@@53h:                                  ; MOV D,E
        CMP     OP,53h
        JNE     @@54h
        MOVE    i8080D,i8080E
        SUB     COUNTER,0005h
        RET
@@54h:                                  ; MOV D,H
        CMP     OP,54h
        JNE     @@55h
        MOVE    i8080D,i8080H
        SUB     COUNTER,0005h
        RET
@@55h:                                  ; MOV D,L 
        CMP     OP,55h
        JNE     @@56h
        MOVE    i8080D,i8080L
        SUB     COUNTER,0005h
        RET
@@56h:                                  ; MOV D,M
        CMP     OP,56h
        JNE     @@57h
        MOV     BX,i8080HL
        MOV     AL,BYTE PTR ES:[BX]
        MOV     i8080D,AL
        SUB     COUNTER,0007h
        RET
@@57h:                                  ; MOV D,A
        CMP     OP,57h
        JNE     @@58h
        MOVE    i8080D,i8080A
        SUB     COUNTER,0005h
        RET
@@58h:                                  ; MOV E,B
        CMP     OP,58h
        JNE     @@59h
        MOVE    i8080E,i8080B
        SUB     COUNTER,0005h
        RET
@@59h:                                  ; MOV E,C
        CMP     OP,59h
        JNE     @@5Ah
        MOVE    i8080E,i8080C
        SUB     COUNTER,0005h
        RET
@@5Ah:                                  ; MOV E,D
        CMP     OP,5Ah
        JNE     @@5Bh
        MOVE    i8080E,i8080D
        SUB     COUNTER,0005h
        RET
@@5Bh:                                  ; MOV E,E
        CMP     OP,5Bh
        JNE     @@5Ch
        MOVE    i8080E,i8080E
        SUB     COUNTER,0005h
        RET
@@5Ch:                                  ; MOV E,H
        CMP     OP,5Ch
        JNE     @@5Dh
        MOVE    i8080E,i8080H
        SUB     COUNTER,0005h
        RET
@@5Dh:                                  ; MOV E,L
        CMP     OP,5Dh
        JNE     @@5Eh
        MOVE    i8080E,i8080L
        SUB     COUNTER,0005h
        RET
@@5Eh:                                  ; MOV E,M
        CMP     OP,5Eh
        JNE     @@5Fh
        MOV     BX,i8080HL
        MOV     AL,BYTE PTR ES:[BX]
        MOV     i8080E,AL
        SUB     COUNTER,0007h
        RET
@@5Fh:                                  ; MOV E,A
        CMP     OP,5Fh
        JNE     @@60h
        MOVE    i8080E,i8080A
        SUB     COUNTER,0005h
        RET
@@60h:                                  ; MOV H,B
        CMP     OP,70h
        JNB     @@70h
        CMP     OP,60h
        JNE     @@61h
        MOVE    i8080H,i8080B
        SUB     COUNTER,0005h
        RET
@@61h:                                  ; MOV H,C
        CMP     OP,61h
        JNE     @@62h
        MOVE    i8080H,i8080C
        SUB     COUNTER,0005h
        RET
@@62h:                                  ; MOV H,D
        CMP     OP,62h
        JNE     @@63h
        MOVE    i8080H,i8080D
        SUB     COUNTER,0005h
        RET
@@63h:                                  ; MOV H,E
        CMP     OP,63h
        JNE     @@64h
        MOVE    i8080H,i8080E
        SUB     COUNTER,0005h
        RET
@@64h:                                  ; MOV H,H
        CMP     OP,64h
        JNE     @@65h
        MOVE    i8080H,i8080H
        SUB     COUNTER,0005h
        RET
@@65h:                                  ; MOV H,L
        CMP     OP,65h
        JNE     @@66h
        MOVE    i8080H,i8080L
        SUB     COUNTER,0005h
        RET
@@66h:                                  ; MOV H,M
        CMP     OP,66h
        JNE     @@67h
        MOV     BX,i8080HL
        MOV     AL,BYTE PTR ES:[BX]
        MOV     i8080H,AL
        SUB     COUNTER,0007h
        RET
@@67h:                                  ; MOV H,A
        CMP     OP,67h
        JNE     @@68h
        MOVE    i8080H,i8080A
        SUB     COUNTER,0005h
        RET
@@68h:                                  ; MOV L,B
        CMP     OP,68h
        JNE     @@69h
        MOVE    i8080L,i8080B
        SUB     COUNTER,0005h
        RET
@@69h:                                  ; MOV L,C
        CMP     OP,69h
        JNE     @@6Ah
        MOVE    i8080L,i8080C
        SUB     COUNTER,0005h
        RET
@@6Ah:                                  ; MOV L,D
        CMP     OP,6Ah
        JNE     @@6Bh
        MOVE    i8080L,i8080D
        SUB     COUNTER,0005h
        RET
@@6Bh:                                  ; MOV L,E
        CMP     OP,6Bh
        JNE     @@6Ch
        MOVE    i8080L,i8080E
        SUB     COUNTER,0005h
        RET
@@6Ch:                                  ; MOV L,H
        CMP     OP,6Ch
        JNE     @@6Dh
        MOVE    i8080L,i8080H
        SUB     COUNTER,0005h
        RET
@@6Dh:                                  ; MOV L,L
        CMP     OP,6Dh
        JNE     @@6Eh
        MOVE    i8080L,i8080L
        SUB     COUNTER,0005h
        RET
@@6Eh:                                  ; MOV L,M
        CMP     OP,6Eh
        JNE     @@6Fh
        MOV     BX,i8080HL
        MOV     AL,BYTE PTR ES:[BX]
        MOV     i8080L,AL
        SUB     COUNTER,0007h
        RET
@@6Fh:                                  ; MOV L,A
        CMP     OP,6Fh
        JNE     @@70h
        MOVE    i8080L,i8080A
        SUB     COUNTER,0005h
        RET
@@70h:                                  ; MOV M,B
        CMP     OP,80h
        JNB     @@80h
        CMP     OP,70h
        JNE     @@71h
        MOV     BX,i8080HL
        MOV     AL,i8080B
        WRITMEM AL
        SUB     COUNTER,0007h
        RET
@@71h:                                  ; MOV M,C
        CMP     OP,71h
        JNE     @@72h
        MOV     BX,i8080HL
        MOV     AL,i8080C
        WRITMEM AL
        SUB     COUNTER,0007h
        RET
@@72h:                                  ; MOV M,D
        CMP     OP,72h
        JNE     @@73h
        MOV     BX,i8080HL
        MOV     AL,i8080D
        WRITMEM AL
        SUB     COUNTER,0007h
        RET
@@73h:                                  ; MOV M,E
        CMP     OP,73h
        JNE     @@74h
        MOV     BX,i8080HL
        MOV     AL,i8080E
        WRITMEM AL
        SUB     COUNTER,0007h
        RET
@@74h:                                  ; MOV M,H
        CMP     OP,74h
        JNE     @@75h
        MOV     BX,i8080HL
        MOV     AL,i8080H
        WRITMEM AL
        SUB     COUNTER,0007h
        RET
@@75h:                                  ; MOV M,L
        CMP     OP,75h
        JNE     @@76h
        MOV     BX,i8080HL
        MOV     AL,i8080L
        WRITMEM AL
        SUB     COUNTER,0007h
        RET
@@76h:                                  ; HLT
        CMP     OP,76h
        JNE     @@77h
        MOV     HALTED,0FFh
        DEC     i8080PC
        SUB     COUNTER,0004h
        RET
@@77h:                                  ; MOV M,A
        CMP     OP,77h
        JNE     @@78h
        MOV     BX,i8080HL
        MOV     AL,i8080A
        WRITMEM AL
        SUB     COUNTER,0007h
        RET
@@78h:                                  ; MOV A,B
        CMP     OP,78h
        JNE     @@79h
        MOVE    i8080A,i8080B
        SUB     COUNTER,0005h
        RET
@@79h:                                  ; MOV A,C
        CMP     OP,79h
        JNE     @@7Ah
        MOVE    i8080A,i8080C
        SUB     COUNTER,0005h
        RET
@@7Ah:                                  ; MOV A,D
        CMP     OP,7Ah
        JNE     @@7Bh
        MOVE    i8080A,i8080D
        SUB     COUNTER,0005h
        RET
@@7Bh:                                  ; MOV A,E
        CMP     OP,7Bh
        JNE     @@7Ch
        MOVE    i8080A,i8080E
        SUB     COUNTER,0005h
        RET
@@7Ch:                                  ; MOV A,H
        CMP     OP,7Ch
        JNE     @@7Dh
        MOVE    i8080A,i8080H
        SUB     COUNTER,0005h
        RET
@@7Dh:                                  ; MOV A,L
        CMP     OP,7Dh
        JNE     @@7Eh
        MOVE    i8080A,i8080L
        SUB     COUNTER,0005h
        RET
@@7Eh:                                  ; MOV A,M
        CMP     OP,7Eh
        JNE     @@7Fh
        MOV     BX,i8080HL
        MOV     AL,BYTE PTR ES:[BX]
        MOV     i8080A,AL
        SUB     COUNTER,0007h
        RET
@@7Fh:                                  ; MOV A,A
        CMP     OP,7Fh
        JNE     @@80h
        MOVE    i8080A,i8080A
        SUB     COUNTER,0005h
        RET
@@80h:                                  ; ADD B
        CMP     OP,90h
        JNB     @@90h
        CMP     OP,80h
        JNE     @@81h
        ADDREG  i8080A,i8080B
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@81h:                                  ; ADD C
        CMP     OP,81h
        JNE     @@82h
        ADDREG  i8080A,i8080C
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@82h:                                  ; ADD D
        CMP     OP,82h                         
        JNE     @@83h
        ADDREG  i8080A,i8080D
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@83h:                                  ; ADD E
        CMP     OP,83h
        JNE     @@84h
        ADDREG  i8080A,i8080E
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@84h:                                  ; ADD H
        CMP     OP,84h
        JNE     @@85h
        ADDREG  i8080A,i8080H
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@85h:                                  ; ADD L
        CMP     OP,85h
        JNE     @@86h
        ADDREG  i8080A,i8080L
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@86h:                                  ; ADD M
        CMP     OP,86h
        JNE     @@87h
        MOV     BX,i8080HL
        MOV     AL,BYTE PTR ES:[BX]
        ADD     i8080A,AL
        SZHPC   i8080F
        SUB     COUNTER,0007h
        RET
@@87h:                                  ; ADD A
        CMP     OP,87h
        JNE     @@88h
        ADDREG  i8080A,i8080A
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@88h:                                  ; ADC B
        CMP     OP,88h
        JNE     @@89h
        ADCREG  i8080A,i8080B,i8080F
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@89h:                                  ; ADC C
        CMP     OP,89h
        JNE     @@8Ah
        ADCREG  i8080A,i8080C,i8080F
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@8Ah:                                  ; ADC D
        CMP     OP,8Ah
        JNE     @@8Bh
        ADCREG  i8080A,i8080D,i8080F
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@8Bh:                                  ; ADC E
        CMP     OP,8Bh
        JNE     @@8Ch
        ADCREG  i8080A,i8080E,i8080F
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@8Ch:                                  ; ADC H
        CMP     OP,8Ch
        JNE     @@8Dh
        ADCREG  i8080A,i8080H,i8080F
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@8Dh:                                  ; ADC L 
        CMP     OP,8Dh
        JNE     @@8Eh
        ADCREG  i8080A,i8080L,i8080F
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@8Eh:                                  ; ADC M
        CMP     OP,8Eh
        JNE     @@8Fh
        MOV     BX,i8080HL
        MOV     DL,BYTE PTR ES:[BX]
        MOV     CL,i8080F
        AND     CL,00000001B
        ADD     DL,CL
        ADD     i8080A,DL
        SZHPC   i8080F
        SUB     COUNTER,0007h
        RET
@@8Fh:                                  ; ADC A
        CMP     OP,8Fh
        JNE     @@90h
        ADCREG  i8080A,i8080A,i8080F
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@90h:                                  ; SUB B
        CMP     OP,0A0h
        JNB     @@A0h
        CMP     OP,90h
        JNE     @@91h
        SUBREG  i8080A,i8080B
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@91h:                                  ; SUB C
        CMP     OP,91h
        JNE     @@92h
        SUBREG  i8080A,i8080C
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@92h:                                  ; SUB D
        CMP     OP,92h
        JNE     @@93h
        SUBREG  i8080A,i8080D
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@93h:                                  ; SUB E
        CMP     OP,93h
        JNE     @@94h
        SUBREG  i8080A,i8080E
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@94h:                                  ; SUB H
        CMP     OP,94h
        JNE     @@95h
        SUBREG  i8080A,i8080H
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@95h:                                  ; SUB L
        CMP     OP,95h
        JNE     @@96h
        SUBREG  i8080A,i8080L
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@96h:                                  ; SUB M
        CMP     OP,96h
        JNE     @@97h
        MOV     BX,i8080HL
        MOV     AL,BYTE PTR ES:[BX]
        SUB     i8080A,AL
        SZHPC   i8080F
        SUB     COUNTER,0007h
        RET
@@97h:                                  ; SUB A
        CMP     OP,97h
        JNE     @@98h
        SUBREG  i8080A,i8080A
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@98h:                                  ; SBB B
        CMP     OP,98h
        JNE     @@99h
        SBBREG  i8080A,i8080B,i8080F
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@99h:                                  ; SBB C
        CMP     OP,99h
        JNE     @@9Ah
        SBBREG  i8080A,i8080C,i8080F
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@9Ah:                                  ; SBB D
        CMP     OP,9Ah
        JNE     @@9Bh
        SBBREG  i8080A,i8080D,i8080F
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@9Bh:                                  ; SBB E
        CMP     OP,9Bh
        JNE     @@9Ch
        SBBREG  i8080A,i8080E,i8080F
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@9Ch:                                  ; SBB H
        CMP     OP,9Ch
        JNE     @@9Dh
        SBBREG  i8080A,i8080H,i8080F
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@9Dh:                                  ; SBB L
        CMP     OP,9Dh
        JNE     @@9Eh
        SBBREG  i8080A,i8080L,i8080F
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@9Eh:                                  ; SBB M
        CMP     OP,9Eh
        JNE     @@9Fh
        MOV     BX,i8080HL
        MOV     DL,BYTE PTR ES:[BX]
        MOV     CL,i8080F
        AND     CL,00000001B
        ADD     DL,CL
        CHECKC  i8080F
        SUB     i8080A,DL
        SZHPC   i8080F
        SUB     COUNTER,0007h
        RET
@@9Fh:                                  ; SBB A
        CMP     OP,9Fh
        JNE     @@A0h
        SBBREG  i8080A,i8080A,i8080F
        SZHPC   i8080F
        SUB     COUNTER,0004h
        RET
@@A0h:                                  ; ANA B
        CMP     OP,0B0h
        JNB     @@B0h
        CMP     OP,0A0h
        JNE     @@A1h
        ANAREG  i8080A,i8080B,i8080F        
        SZP     i8080F
        CLEARH  i8080F
        CLEARC  i8080F
        SUB     COUNTER,0004h
        RET                                    
@@A1h:                                  ; ANA C
        CMP     OP,0A1h
        JNE     @@A2h
        ANAREG  i8080A,i8080C,i8080F        
        SZP     i8080F
        CLEARH  i8080F
        CLEARC  i8080F
        SUB     COUNTER,0004h
        RET
@@A2h:                                  ; ANA D
        CMP     OP,0A2h
        JNE     @@A3h
        ANAREG  i8080A,i8080D,i8080F        
        SZP     i8080F
        CLEARH  i8080F
        CLEARC  i8080F
        SUB     COUNTER,0004h
        RET
@@A3h:                                  ; ANA E
        CMP     OP,0A3h
        JNE     @@A4h
        ANAREG  i8080A,i8080E,i8080F        
        SZP     i8080F
        CLEARH  i8080F
        CLEARC  i8080F
        SUB     COUNTER,0004h
        RET
@@A4h:                                  ; ANA H
        CMP     OP,0A4h
        JNE     @@A5h
        ANAREG  i8080A,i8080H,i8080F        
        SZP     i8080F
        CLEARH  i8080F
        CLEARC  i8080F
        SUB     COUNTER,0004h
        RET
@@A5h:                                  ; ANA L
        CMP     OP,0A5h
        JNE     @@A6h
        ANAREG  i8080A,i8080L,i8080F        
        SZP     i8080F
        CLEARH  i8080F
        CLEARC  i8080F
        SUB     COUNTER,0004h
        RET
@@A6h:                                  ; ANA M
        CMP     OP,0A6h
        JNE     @@A7h
        MOV     BX,i8080HL
        MOV     AL,BYTE PTR ES:[BX]
        AND     i8080A,AL
        SZP     i8080F
        CLEARH  i8080F
        CLEARC  i8080F
        SUB     COUNTER,0007h
        RET
@@A7h:                                  ; ANA A
        CMP     OP,0A7h
        JNE     @@A8h
        ANAREG  i8080A,i8080A,i8080F        
        SZP     i8080F
        CLEARH  i8080F
        CLEARC  i8080F
        SUB     COUNTER,0004h
        RET
@@A8h:                                  ; XRA B
        CMP     OP,0A8h
        JNE     @@A9h
        XRAREG  i8080A,i8080B,i8080F
        SZP     i8080F
        CLEARC  i8080F
        CLEARH  i8080F
        SUB     COUNTER,0004h
        RET
@@A9h:                                  ; XRA C
        CMP     OP,0A9h
        JNE     @@AAh
        XRAREG  i8080A,i8080C,i8080F
        SZP     i8080F
        CLEARC  i8080F
        CLEARH  i8080F
        SUB     COUNTER,0004h
        RET
@@AAh:                                  ; XRA D
        CMP     OP,0AAh
        JNE     @@ABh
        XRAREG  i8080A,i8080D,i8080F
        SZP     i8080F
        CLEARC  i8080F
        CLEARH  i8080F
        SUB     COUNTER,0004h
        RET
@@ABh:                                  ; XRA E
        CMP     OP,0ABh
        JNE     @@ACh
        XRAREG  i8080A,i8080E,i8080F
        SZP     i8080F
        CLEARC  i8080F
        CLEARH  i8080F
        SUB     COUNTER,0004h
        RET
@@ACh:                                  ; XRA H
        CMP     OP,0ACh
        JNE     @@ADh
        XRAREG  i8080A,i8080H,i8080F
        SZP     i8080F
        CLEARC  i8080F
        CLEARH  i8080F
        SUB     COUNTER,0004h
        RET
@@ADh:                                  ; XRA L
        CMP     OP,0ADh
        JNE     @@AEh
        XRAREG  i8080A,i8080L,i8080F
        SZP     i8080F
        CLEARC  i8080F
        CLEARH  i8080F
        SUB     COUNTER,0004h
        RET
@@AEh:                                  ; XRA M
        CMP     OP,0AEh
        JNE     @@AFh
        MOV     BX,i8080HL
        MOV     AL,BYTE PTR ES:[BX]
        XOR     i8080A,AL
        SZP     i8080F
        CLEARC  i8080F
        CLEARH  i8080F
        SUB     COUNTER,0004h
        RET
@@AFh:                                  ; XRA A
        CMP     OP,0AFh
        JNE     @@B0h
        XRAREG  i8080A,i8080A,i8080F
        SZP     i8080F
        CLEARC  i8080F
        CLEARH  i8080F
        SUB     COUNTER,0004h
        RET
@@B0h:                                  ; ORA B
        CMP     OP,0D0h
        JNB     @@D0h
        CMP     OP,0B0h
        JNE     @@B1h
        ORAREG  i8080A,i8080B,i8080F
        SZP     i8080F
        CLEARH  i8080F
        CLEARC  i8080F
        SUB     COUNTER,0004h
        RET
@@B1h:                                  ; ORA C
        CMP     OP,0B1h
        JNE     @@B2h
        ORAREG  i8080A,i8080C,i8080F
        SZP     i8080F
        CLEARH  i8080F
        CLEARC  i8080F
        SUB     COUNTER,0004h
        RET
@@B2h:                                  ; ORA D
        CMP     OP,0B2h
        JNE     @@B3h
        ORAREG  i8080A,i8080D,i8080F
        SZP     i8080F
        CLEARH  i8080F
        CLEARC  i8080F
        SUB     COUNTER,0004h
        RET
@@B3h:                                  ; ORA E
        CMP     OP,0B3h
        JNE     @@B4h
        ORAREG  i8080A,i8080E,i8080F
        SZP     i8080F
        CLEARH  i8080F
        CLEARC  i8080F
        SUB     COUNTER,0004h
        RET
@@B4h:                                  ; ORA H
        CMP     OP,0B4h
        JNE     @@B5h
        ORAREG  i8080A,i8080H,i8080F
        SZP     i8080F
        CLEARH  i8080F
        CLEARC  i8080F
        SUB     COUNTER,0004h
        RET
@@B5h:                                  ; ORA L 
        CMP     OP,0B5h
        JNE     @@B6h
        ORAREG  i8080A,i8080L,i8080F
        SZP     i8080F
        CLEARH  i8080F
        CLEARC  i8080F
        SUB     COUNTER,0004h
        RET
@@B6h:                                  ; ORA M
        CMP     OP,0B6h
        JNE     @@B7h
        MOV     BX,i8080HL
        MOV     AL,BYTE PTR ES:[BX]
        OR      i8080A,AL
        SZP     i8080F
        CLEARC  i8080F
        CLEARH  i8080F
        SUB     COUNTER,0007h
        RET
@@B7h:                                  ; ORA A
        CMP     OP,0B7h
        JNE     @@B8h
        ORAREG  i8080A,i8080A,i8080F
        SZP     i8080F
        CLEARH  i8080F
        CLEARC  i8080F
        SUB     COUNTER,0004h
        RET
@@B8h:                                  ; CMP B
        CMP     OP,0B8h
        JNE     @@B9h
        CMPREG  i8080A,i8080B,i8080F
        SUB     COUNTER,0004h
        RET
@@B9h:                                  ; CMP C
        CMP     OP,0B9h
        JNE     @@BAh
        CMPREG  i8080A,i8080C,i8080F
        SUB     COUNTER,0004h
        RET
@@BAh:                                  ; CMP D
        CMP     OP,0BAh
        JNE     @@BBh
        CMPREG  i8080A,i8080D,i8080F
        SUB     COUNTER,0004h
        RET
@@BBh:                                  ; CMP E
        CMP     OP,0BBh
        JNE     @@BCh
        CMPREG  i8080A,i8080E,i8080F
        SUB     COUNTER,0004h
        RET
@@BCh:                                  ; CMP H
        CMP     OP,0BCh
        JNE     @@BDh
        CMPREG  i8080A,i8080H,i8080F
        SUB     COUNTER,0004h
        RET
@@BDh:                                  ; CMP L
        CMP     OP,0BDh
        JNE     @@BEh
        CMPREG  i8080A,i8080L,i8080F
        SUB     COUNTER,0004h
        RET
@@BEh:                                  ; CMP M
        CMP     OP,0BEh
        JNE     @@BFh
        MOV     BX,i8080HL
        MOV     AL,BYTE PTR ES:[BX]
        CMP     i8080A,AL
        SZHPC   i8080F
        SUB     COUNTER,0007h
        RET
@@BFh:                                  ; CMP A
        CMP     OP,0BFh
        JNE     @@C0h
        CMPREG  i8080A,i8080A,i8080F
        SUB     COUNTER,0004h
        RET
@@C0h:                                  ; RNZ     
        CMP     OP,0C0h
        JNE     @@C1h
        MOV     AL,i8080F
        AND     AL,01000000B
        JNZ     @@C0Zero
        RET8080 i8080SP,i8080PC
        SUB     COUNTER,000Bh
        RET
@@C0Zero:
        SUB     COUNTER,0005h
        RET
@@C1h:                                  ; POP B
        CMP     OP,0C1h
        JNE     @@C2h
        MOV     BX,i8080SP
        MOV     AX,WORD PTR ES:[BX]
        MOV     i8080BC,AX
        INC     i8080SP
        INC     i8080SP
        SUB     COUNTER,000Ah
        RET

@@C2h:                                  ; JNZ aa
        CMP     OP,0C2h
        JNE     @@C3h
        MOV     AL,i8080F
        AND     AL,01000000B
        JNZ     @@C2Zero
        JMP8080 i8080PC
        SUB     COUNTER,000Ah
        RET
@@C2Zero:
        INC     i8080PC
        INC     i8080PC
        SUB     COUNTER,000Ah
        RET
@@C3h:                                  ; JMP aa
        CMP     OP,0C3h
        JNE     @@C4h
        JMP8080 i8080PC
        SUB     COUNTER,000Ah
        RET
@@C4h:                                  ; CNZ aa
        CMP     OP,0C4h
        JNE     @@C5h
        MOV     AL,i8080F
        AND     AL,01000000B
        JNZ     @@C4Zero
        CLL8080 i8080SP,i8080PC
        SUB     COUNTER,0011h
        RET
@@C4Zero:
        INC     i8080PC
        INC     i8080PC
        SUB     COUNTER,000Bh
        RET
@@C5h:                                  ; PUSH B
        CMP     OP,0C5h
        JNE     @@C6h
        MOV     BX,i8080SP
        MOV     AX,i8080BC
        DEC     BX
        WRITMEM AH
        DEC     BX
        WRITMEM AL
        DEC     i8080SP
        DEC     i8080SP
        SUB     COUNTER,000Bh
        RET
@@C6h:                                  ; ADI n
        CMP     OP,0C6h
        JNE     @@C7h
        INC     i8080PC
        MOV     BX,i8080PC
        MOV     AL,BYTE PTR ES:[BX]
        ADD     i8080A,AL
        SZHPC   i8080F
        SUB     COUNTER,0007h
        RET
@@C7h:                                  ; RST 0
        CMP     OP,0C7h
        JNE     @@C8h
        MOV     BX,i8080SP
        MOV     AX,i8080PC
        INC     AX
        DEC     BX
        WRITMEM AH
        DEC     BX
        WRITMEM AL
        DEC     i8080SP
        DEC     i8080SP
        MOV     AX,0000h
        MOV     i8080PC,AX
        DEC     i8080PC
        SUB     COUNTER,000Bh
        RET
@@C8h:                                  ; RZ
        CMP     OP,0C8h
        JNE     @@C9h
        MOV     AL,i8080F
        AND     AL,01000000B
        JZ      @@C8NZero
        RET8080 i8080SP,i8080PC
        SUB     COUNTER,000Bh
        RET
@@C8NZero:
        SUB     COUNTER,0005h
        RET
@@C9h:                                  ; RET
        CMP     OP,0C9h
        JNE     @@CAh
        RET8080 i8080SP,i8080PC
        SUB     COUNTER,000Ah
        RET
@@CAh:                                  ; JZ aa
        CMP     OP,0CAh
        JNE     @@CBh
        MOV     AL,i8080F
        AND     AL,01000000B
        JZ      @@CANZero
        JMP8080 i8080PC
        SUB     COUNTER,000Ah
        RET
@@CANZero:
        INC     i8080PC
        INC     i8080PC
        SUB     COUNTER,000Ah
        RET

@@CBh:                                  ; Invalid
        CMP     OP,0CBh
        JNE     @@CCh
        SUB     COUNTER,0004h
        RET
@@CCh:                                  ; CZ aa
        CMP     OP,0CCh
        JNE     @@CDh
        MOV     AL,i8080F
        AND     AL,01000000B
        JZ      @@CCNZero
        CLL8080 i8080SP,i8080PC
        SUB     COUNTER,0011h
        RET
@@CCNZero:
        INC     i8080PC
        INC     i8080PC
        SUB     COUNTER,000Bh
        RET
@@CDh:                                  ; CALL aa
        CMP     OP,0CDh
        JNE     @@CEh
        CLL8080 i8080SP,i8080PC
        SUB     COUNTER,0011h
        RET
@@CEh:                                  ; ACI n
        CMP     OP,0CEh
        JNE     @@CFh
        INC     i8080PC
        MOV     BX,i8080PC
        MOV     DL,BYTE PTR ES:[BX]
        ADCREG  i8080A,DL,i8080F
        SZHPC   i8080F
        SUB     COUNTER,0007h
        RET
@@CFh:                                  ; RST 1
        CMP     OP,0CFh
        JNE     @@D0h
        MOV     BX,i8080SP
        MOV     AX,i8080PC
        INC     AX
        DEC     BX
        WRITMEM AH
        DEC     BX
        WRITMEM AL
        DEC     i8080SP
        DEC     i8080SP
        MOV     AX,0008h
        MOV     i8080PC,AX
        DEC     i8080PC
        SUB     COUNTER,000Bh
        RET
@@D0h:                                  ; RNC
        CMP     OP,0E0h
        JNB     @@E0h
        CMP     OP,0D0h
        JNE     @@D1h
        MOV     AL,i8080F
        AND     AL,00000001B
        JNZ     @@D0Carry
        RET8080 i8080SP,i8080PC
        SUB     COUNTER,000Bh
        RET
@@D0Carry:
        SUB     COUNTER,0005h
        RET
@@D1h:                                  ; POP D
        CMP     OP,0D1h
        JNE     @@D2h
        MOV     BX,i8080SP
        MOV     AX,WORD PTR ES:[BX]
        MOV     i8080DE,AX
        INC     i8080SP
        INC     i8080SP
        SUB     COUNTER,000Ah
        RET
@@D2h:                                  ; JNC aa
        CMP     OP,0D2h
        JNE     @@D3h
        MOV     AL,i8080F
        AND     AL,00000001B
        JNZ     @@D2Carry
        JMP8080 i8080PC
        SUB     COUNTER,000Ah
        RET
@@D2Carry:
        INC     i8080PC
        INC     i8080PC
        SUB     COUNTER,000Ah
        RET
@@D3h:                                  ; OUT n
        CMP     OP,0D3h
        JNE     @@D4h
        INC     i8080PC
        MOV     BX,i8080PC
        MOV     DI,OUTOFF
        MOVZX   BX,BYTE PTR ES:[BX]
        CMP     BX,BTMPOUT
        JNE     @@D3NoBitmap
        MOV     AL,BYTE PTR DS:[BX+DI]
        MOV     BTMPTMP,AL
        MOV     AL,i8080A
        MOV     BYTE PTR DS:[BX+DI],AL
@@D3NoBitmap:
        MOV     AL,i8080A
        MOV     BYTE PTR DS:[BX+DI],AL
        SUB     COUNTER,000Ah
        RET
@@D4h:                                  ; CNC aa
        CMP     OP,0D4h
        JNE     @@D5h
        MOV     AL,i8080F
        AND     AL,00000001B
        JNZ     @@D4Carry
        CLL8080 i8080SP,i8080PC
        SUB     COUNTER,0011h
        RET
@@D4Carry:
        INC     i8080PC
        INC     i8080PC
        SUB     COUNTER,000Bh
        RET
@@D5h:                                  ; PUSH D
        CMP     OP,0D5h
        JNE     @@D6h
        MOV     BX,i8080SP
        MOV     AX,i8080DE
        DEC     BX
        WRITMEM AH
        DEC     BX
        WRITMEM AL
        DEC     i8080SP
        DEC     i8080SP
        SUB     COUNTER,000Bh
        RET
@@D6h:                                  ; SUI n
        CMP     OP,0D6h
        JNE     @@D7h
        INC     i8080PC
        MOV     BX,i8080PC
        MOV     AL,BYTE PTR ES:[BX]
        SUB     i8080A,AL
        SZHPC   i8080F
        SUB     COUNTER,0007h
        RET
@@D7h:                                  ; RST 2
        CMP     OP,0D7h
        JNE     @@D8h
        MOV     BX,i8080SP
        MOV     AX,i8080PC
        INC     AX
        DEC     BX
        WRITMEM AH
        DEC     BX
        WRITMEM AL
        DEC     i8080SP
        DEC     i8080SP
        MOV     AX,0010h
        MOV     i8080PC,AX
        DEC     i8080PC
        SUB     COUNTER,000Bh
        RET
@@D8h:                                  ; RC
        CMP     OP,0D8h
        JNE     @@D9h
        MOV     AL,i8080F
        AND     AL,00000001B
        JZ      @@D8NCarry
        RET8080 i8080SP,i8080PC
        SUB     COUNTER,000Bh
        RET
@@D8NCarry:
        SUB     COUNTER,0005h
        RET
@@D9h:                                  ; Invalid
        CMP     OP,0D9h
        JNE     @@DAh
        SUB     COUNTER,0004h
        RET
@@DAh:                                  ; JC aa
        CMP     OP,0DAh
        JNE     @@DBh
        MOV     AL,i8080F
        AND     AL,00000001B
        JZ      @@DANCarry
        JMP8080 i8080PC
        SUB     COUNTER,000Ah
        RET
@@DANCarry:
        INC     i8080PC
        INC     i8080PC
        SUB     COUNTER,000Ah
        RET
@@DBh:                                  ; IN n
        CMP     OP,0DBh
        JNE     @@DCh
        INC     i8080PC
        MOV     BX,i8080PC
        MOV     AL,BYTE PTR ES:[BX]
        CMP     AL,BTMPIN
        JNE     @@DBNoBitmap
        MOV     AX,OFFSET OUTARRY
        INBTMP  AX, SHFTOUT, BTMPOUT, BTMPTMP
        MOV     i8080A,AL
        SUB     COUNTER,000Ah
        RET
@@DBNoBitmap:
        MOVZX   BX,BYTE PTR ES:[BX]
        LEA     DI,IOARRAY
        MOV     AL,BYTE PTR DS:[BX+DI]
        MOV     i8080A,AL
        SUB     COUNTER,000Ah
        RET
@@DCh:                                  ; CC aa
        CMP     OP,0DCh
        JNE     @@DDh
        MOV     AL,i8080F
        AND     AL,00000001B
        JZ      @@DCNCarry
        CLL8080 i8080SP,i8080PC
        SUB     COUNTER,0011h
        RET
@@DCNCarry:
        INC     i8080PC
        INC     i8080PC
        SUB     COUNTER,000Bh
        RET

@@DDh:                                  ; Invalid
        CMP     OP,0DDh
        JNE     @@DEh
        SUB     COUNTER,0004h
        RET
@@DEh:                                  ; SBI n
        CMP     OP,0DEh
        JNE     @@DFh
        INC     i8080PC
        MOV     BX,i8080PC
        MOV     DL,BYTE PTR ES:[BX]
        SBBREG  i8080A,DL,i8080F
        SZHPC   i8080F
        SUB     COUNTER,0007h
        RET
@@DFh:                                  ; RST 3
        CMP     OP,0DFh
        JNE     @@E0h
        MOV     BX,i8080SP
        MOV     AX,i8080PC
        INC     AX
        DEC     BX
        WRITMEM AH
        DEC     BX
        WRITMEM AL
        DEC     i8080SP
        DEC     i8080SP
        MOV     AX,0018h
        MOV     i8080PC,AX
        DEC     i8080PC
        SUB     COUNTER,000Bh
        RET
@@E0h:                                  ; RPO
        CMP     OP,0F0h
        JNB     @@F0h
        CMP     OP,0E0h
        JNE     @@E1h
        MOV     AL,i8080F
        AND     AL,00000100B
        JNZ     @@E0Even
        RET8080 i8080SP,i8080PC
        SUB     COUNTER,000Bh
        RET
@@E0Even:
        SUB     COUNTER,0005h
        RET
@@E1h:                                  ; POP H
        CMP     OP,0E1h
        JNE     @@E2h
        MOV     BX,i8080SP
        MOV     AX,WORD PTR ES:[BX]
        MOV     i8080HL,AX
        INC     i8080SP
        INC     i8080SP
        SUB     COUNTER,000Ah
        RET
@@E2h:                                  ; JPO aa
        CMP     OP,0E2h
        JNE     @@E3h
        MOV     AL,i8080F
        AND     AL,00000100B
        JNZ     @@E2Even  
        JMP8080 i8080PC
        SUB     COUNTER,000Ah
        RET
@@E2Even:
        INC     i8080PC
        INC     i8080PC
        SUB     COUNTER,000Ah
        RET
@@E3h:                                  ; XTHL
        CMP     OP,0E3h
        JNE     @@E4h
        MOV     BX,i8080SP
        MOV     AX,WORD PTR ES:[BX]
        MOV     CX,i8080HL
        MOV     i8080HL,AX
        WRITMEM CL
        INC     BX
        WRITMEM CH
        SUB     COUNTER,0012h
        RET
@@E4h:                                  ; CPO aa
        CMP     OP,0E4h
        JNE     @@E5h
        MOV     AL,i8080F
        AND     AL,00000100B
        JNZ     @@E4Even  
        CLL8080 i8080SP,i8080PC
        SUB     COUNTER,0011h
        RET
@@E4Even:  
        INC     i8080PC
        INC     i8080PC
        SUB     COUNTER,000Bh
        RET
@@E5h:                                  ; PUSH H
        CMP     OP,0E5h
        JNE     @@E6h
        MOV     BX,i8080SP
        MOV     AX,i8080HL
        DEC     BX
        WRITMEM AH
        DEC     BX
        WRITMEM AL
        DEC     i8080SP
        DEC     i8080SP
        SUB     COUNTER,000Bh
        RET
@@E6h:                                  ; ANI n 
        CMP     OP,0E6h
        JNE     @@E7h
        INC     i8080PC
        MOV     BX,i8080PC
        MOV     AL,BYTE PTR ES:[BX]
        AND     i8080A,AL
        SZP     i8080F
        CLEARH  i8080F
        CLEARC  i8080F
        SUB     COUNTER,0007h
        RET
@@E7h:                                  ; RST 4
        CMP     OP,0E7h
        JNE     @@E8h
        MOV     BX,i8080SP
        MOV     AX,i8080PC
        INC     AX
        DEC     BX
        WRITMEM AH
        DEC     BX
        WRITMEM AL
        DEC     i8080SP
        DEC     i8080SP
        MOV     AX,0020h
        MOV     i8080PC,AX
        DEC     i8080PC
        SUB     COUNTER,000Bh
        RET
@@E8h:                                  ; RPE
        CMP     OP,0E8h
        JNE     @@E9h
        MOV     AL,i8080F
        AND     AL,00000100B
        JZ      @@E8Odd
        RET8080 i8080SP,i8080PC
        SUB     COUNTER,000Bh
        RET
@@E8Odd:
        SUB     COUNTER,0005h
        RET
@@E9h:                                  ; PCHL
        CMP     OP,0E9h
        JNE     @@EAh
        MOV     AX,i8080HL
        MOV     i8080PC,AX
        DEC     i8080PC
        SUB     COUNTER,0005h
        RET
@@EAh:                                  ; JPE aa
        CMP     OP,0EAh
        JNE     @@EBh
        MOV     AL,i8080F
        AND     AL,00000100B
        JZ      @@EAOdd   
        JMP8080 i8080PC
        SUB     COUNTER,000Ah
        RET
@@EAOdd:
        INC     i8080PC
        INC     i8080PC
        SUB     COUNTER,000Ah
        RET
@@EBh:                                  ; XCHG
        CMP     OP,0EBh
        JNE     @@ECh
        MOV     AX,i8080HL
        MOV     BX,i8080DE
        MOV     i8080HL,BX
        MOV     i8080DE,AX
        SUB     COUNTER,0004h
        RET
@@ECh:                                  ; CPE aa
        CMP     OP,0ECh
        JNE     @@EDh
        MOV     AL,i8080F
        AND     AL,00000100B
        JZ      @@ECOdd   
        CLL8080 i8080SP,i8080PC
        SUB     COUNTER,0011h
        RET
@@ECOdd:  
        INC     i8080PC
        INC     i8080PC
        SUB     COUNTER,000Bh
        RET
@@EDh:                                  ; Invalid
        CMP     OP,0EDh
        JNE     @@EEh
        SUB     COUNTER,0004h
        RET
@@EEh:                                  ; XRI n
        CMP     OP,0EEh
        JNE     @@EFh
        INC     i8080PC
        MOV     BX,i8080PC
        MOV     AL,BYTE PTR ES:[BX]
        XOR     i8080A,AL
        SZP     i8080F
        CLEARH  i8080F
        CLEARC  i8080F
        SUB     COUNTER,0007h
        RET
@@EFh:                                  ; RST 5
        CMP     OP,0EFh
        JNE     @@F0h
        MOV     BX,i8080SP
        MOV     AX,i8080PC
        INC     AX
        DEC     BX
        WRITMEM AH
        DEC     BX
        WRITMEM AL
        DEC     i8080SP
        DEC     i8080SP
        MOV     AX,0028h
        MOV     i8080PC,AX
        DEC     i8080PC
        SUB     COUNTER,000Bh
        RET
@@F0h:                                  ; RP
        CMP     OP,0F8h
        JNB     @@F8h
        CMP     OP,0F0h
        JNE     @@F1h
        MOV     AL,i8080F
        AND     AL,10000000B
        JNZ     @@F0Minus
        RET8080 i8080SP,i8080PC
        SUB     COUNTER,000Bh
        RET
@@F0Minus:
        SUB     COUNTER,0005h
        RET
@@F1h:                                  ; POP PSW
        CMP     OP,0F1h
        JNE     @@F2h
        MOV     BX,i8080SP
        MOV     AX,WORD PTR ES:[BX]
        MOV     i8080AF,AX
        INC     i8080SP
        INC     i8080SP
        SUB     COUNTER,000Ah
        RET
@@F2h:                                  ; JP aa
        CMP     OP,0F2h
        JNE     @@F3h
        MOV     AL,i8080F
        AND     AL,10000000B
        JNZ     @@F2Minus 
        JMP8080 i8080PC
        SUB     COUNTER,000Ah
        RET
@@F2Minus:
        INC     i8080PC
        INC     i8080PC
        SUB     COUNTER,000Ah
        RET

@@F3h:                                  ; DI
        CMP     OP,0F3h
        JNE     @@F4h
        MOV     IEN,00h
        SUB     COUNTER,0004h
        RET
@@F4h:                                  ; CP aa
        CMP     OP,0F4h
        JNE     @@F5h
        MOV     AL,i8080F
        AND     AL,10000000B
        JNZ     @@F4Minus 
        CLL8080 i8080SP,i8080PC
        SUB     COUNTER,0011h
        RET
@@F4Minus:
        INC     i8080PC
        INC     i8080PC
        SUB     COUNTER,000Bh
        RET
@@F5h:                                  ; PUSH PSW
        CMP     OP,0F5h
        JNE     @@F6h
        MOV     BX,i8080SP
        MOV     AX,i8080AF
        DEC     BX
        WRITMEM AH
        DEC     BX
        WRITMEM AL
        DEC     i8080SP
        DEC     i8080SP
        SUB     COUNTER,000Bh
        RET
@@F6h:                                  ; ORI n
        CMP     OP,0F6h
        JNE     @@F7h
        INC     i8080PC
        MOV     BX,i8080PC
        MOV     AL,BYTE PTR ES:[BX]
        OR      i8080A,AL
        SZP     i8080F
        CLEARC  i8080F
        CLEARH  i8080F
        SUB     COUNTER,0007h
        RET
@@F7h:                                  ; RST 6
        CMP     OP,0F7h
        JNE     @@F8h
        MOV     BX,i8080SP
        MOV     AX,i8080PC
        INC     AX
        DEC     BX
        WRITMEM AH
        DEC     BX
        WRITMEM AL
        DEC     i8080SP
        DEC     i8080SP
        MOV     AX,0030h
        MOV     i8080PC,AX
        DEC     i8080PC
        SUB     COUNTER,000Bh
        RET
@@F8h:                                  ; RM
        CMP     OP,0F8h
        JNE     @@F9h
        MOV     AL,i8080F
        AND     AL,10000000B
        JZ      @@F8Plus 
        RET8080 i8080SP,i8080PC
        SUB     COUNTER,000Bh
        RET
@@F8Plus:
        SUB     COUNTER,0005h
        RET
@@F9h:                                  ; SPHL
        CMP     OP,0F9h
        JNE     @@FAh
        MOV     AX,i8080HL
        MOV     i8080SP,AX
        SUB     COUNTER,0005h
        RET
@@FAh:                                  ; JM aa                                  
        CMP     OP,0FAh
        JNE     @@FBh
        MOV     AL,i8080F
        AND     AL,10000000B
        JZ      @@FAPlus  
        JMP8080 i8080PC
        SUB     COUNTER,000Ah
        RET
@@FAPlus:
        INC     i8080PC
        INC     i8080PC
        SUB     COUNTER,000Ah
        RET
@@FBh:                                  ; EI
        CMP     OP,0FBh
        JNE     @@FCh
        MOV     IEN,0FFh
        CMP     ISK,00h
        JE      @@NoWaiting
        MOV     EIINT,0FFh
        MOVZX   AX,IRQ
        PUSH    AX
        MOV     IRQ,00h
        CALL    DOINT
        POP     AX
        MOV     IRQ,AL
@@NoWaiting:
        MOV     EIINT,00h
        SUB     COUNTER,0004h
        RET
@@FCh:                                  ; CM aa
        CMP     OP,0FCh
        JNE     @@FDh
        MOV     AL,i8080F
        AND     AL,10000000B
        JZ      @@FCPlus  
        CLL8080 i8080SP,i8080PC
        SUB     COUNTER,0011h
        RET
@@FCPlus:
        INC     i8080PC
        INC     i8080PC
        SUB     COUNTER,000Bh
        RET
@@FDh:                                  ; Invalid
        CMP     OP,0FDh
        JNE     @@FEh
        SUB     COUNTER,0004h
        RET                     
@@FEh:                                  ; CPI n
        CMP     OP,0FEh
        JNE     @@FFh
        INC     i8080PC
        MOV     BX,i8080PC
        MOV     DL,BYTE PTR ES:[BX]
        CMPREG  i8080A,DL,i8080F
        SUB     COUNTER,0007h
        RET
@@FFh:                                  ; RST 7
        MOV     BX,i8080SP
        MOV     AX,i8080PC
        INC     AX
        DEC     BX
        WRITMEM AH
        DEC     BX
        WRITMEM AL
        DEC     i8080SP
        DEC     i8080SP
        MOV     AX,0038h
        MOV     i8080PC,AX
        DEC     i8080PC
        SUB     COUNTER,000Bh
        RET
DECODE  ENDP

RR      PROC    NEAR
        MOV     CX,ROMNUM
        LEA     BX,RNAME
        LEA     DI,RLOC
@@ReadRoms:
        MOV     AX,RSIZE
        PUSH    AX
        PUSH    BX
        MOV     AX,WORD PTR[DI]
        PUSH    AX
        LEA     AX,NOEXIST
        PUSH    AX
        LEA     AX,SHORTER
        PUSH    AX
        LEA     AX,ERRORO
        PUSH    AX
        LEA     AX,TEMPBYT
        PUSH    AX
        CALL    READROM
        ADD     SP,000Eh
        ADD     BX,000Dh
        ADD     DI,0002h
        LOOP    @@ReadRoms
        RET
RR      ENDP

READROM PROC    NEAR
        PUSH    BP
        MOV     BP,SP
@@TempC EQU     [BP+04h]
@@OErr  EQU     [BP+06h]
@@Shrtr EQU     [BP+08h]
@@No    EQU     [BP+0Ah]
@@RAddy EQU     [BP+0Ch]
@@FName EQU     [BP+0Eh]
@@FSize EQU     [BP+10h]
@@FHndl EQU     [BP-02h]
@@ECode EQU     [BP-04h]
@@Bytes EQU     [BP-06h]
        SUB     SP,0008h
        PUSH    BX
        PUSH    CX
        PUSH    DX
        PUSH    DI
        MOV     AH,3Dh
        MOV     AL,00h                  
        MOV     DX,@@FName           
        MOV     CL,00h           
        INT     21h

        JNC     GotIt
        MOV     AH,09h
        MOV     DX,@@No
        INT     21h
        ENDPROG
GotIt:
        MOV     @@FHndl,AX
        MOV     DI,@@RAddy
        MOV     DX,0000h
GetIt:
        PUSH    DX
        MOV     AH,3Fh                  ; Request file or device read
        MOV     BX,@@FHndl
        MOV     CX,0001h
        MOV     DX,@@TempC
        INT     21h
        JC      BadErr

        CMP     AX,0001h
        JE      Cont
        MOV     AH,09h

        MOV     DX,@@Shrtr
        INT     21h
        ENDPROG
BadErr:
        MOV     AH,09h
        MOV     DX,@@OErr
        INT     21h
Cont:
        MOV     BX,@@TempC
        MOV     AL,BYTE PTR DS:[BX]
        MOV     BYTE PTR ES:[DI],AL
        POP     DX
        INC     DX
        INC     DI
        CMP     DX,@@FSize
        JE      Done
        JMP     GetIt
Done:
        MOV     AX,DI
        POP     DI
        POP     DX
        POP     CX
        POP     BX
        ADD     SP,0008h
        POP     BP
        RET
READROM ENDP

INTASC  PROC    NEAR
        LOCALS
        PUSH    BP
        MOV     BP,SP
@@Asc   EQU     [BP+04h]
@@Int   EQU     [BP+06h]
        PUSHA
        MOV     CX,0004h
        MOV     SI,@@Asc
        ADD     SI,0003h
@@FillZero:
        MOV     BYTE PTR[SI],30h
        DEC     SI
        LOOP    @@FillZero
        MOV     BX,@@Int
        MOV     CX,0010h
        MOV     SI,@@Asc
        ADD     SI,0003h
        MOV     AX,WORD PTR[BX]
@@ConvertIt:
        CMP     AX,CX
        JB      @@DoneConvert
        XOR     DX,DX
        DIV     CX
        CMP     DL,09h
        JA      @@HexConv
        OR      DL,30h
        MOV     [SI],DL
        DEC     SI
        JMP     @@ConvertIt
@@HexConv:
        ADD     DL,37h
        MOV     [SI],DL
        DEC     SI
        JMP     @@ConvertIt
@@DoneConvert:
        CMP     AL,09h
        JA      @@HexDone
        OR      AL,30h
        MOV     [SI],AL
        POPA
        POP     BP
        RET
@@HexDone:
        ADD     AL,37h
        MOV     [SI],AL
        POPA
        POP     BP
        RET
INTASC  ENDP

DREGS   PROC    NEAR
        PDIS    REGS,00h,00h        
        LEA     AX,i8080PC
        PUSH    AX
        LEA     AX,ASCNUM
        PUSH    AX
        CALL    INTASC
        ADD     SP,0004h
        PDIS    ASCNUM,00h,03h

        MOV     AH,i8080A
        MOV     AL,i8080F
        MOV     TEMPWRD,AX
        LEA     AX,TEMPWRD
        PUSH    AX
        LEA     AX,ASCNUM
        PUSH    AX
        CALL    INTASC
        ADD     SP,0004h
        PDIS    ASCNUM,00h,0Dh

        MOV     AH,i8080B
        MOV     AL,i8080C
        MOV     TEMPWRD,AX
        LEA     AX,TEMPWRD
        PUSH    AX
        LEA     AX,ASCNUM
        PUSH    AX
        CALL    INTASC
        ADD     SP,0004h
        PDIS    ASCNUM,00h,17h

        MOV     AH,i8080D
        MOV     AL,i8080E
        MOV     TEMPWRD,AX
        LEA     AX,TEMPWRD
        PUSH    AX
        LEA     AX,ASCNUM
        PUSH    AX
        CALL    INTASC
        ADD     SP,0004h
        PDIS    ASCNUM,00h,21h

        MOV     AH,i8080H
        MOV     AL,i8080L
        MOV     TEMPWRD,AX
        LEA     AX,TEMPWRD
        PUSH    AX
        LEA     AX,ASCNUM
        PUSH    AX
        CALL    INTASC
        ADD     SP,0004h
        PDIS    ASCNUM,01h,03h

        MOV     AX,i8080SP
        MOV     TEMPWRD,AX
        LEA     AX,TEMPWRD
        PUSH    AX
        LEA     AX,ASCNUM
        PUSH    AX
        CALL    INTASC
        ADD     SP,0004h
        PDIS    ASCNUM,01h,0Dh

        MOV     AL,OP
        MOV     AH,00h
        MOV     TEMPWRD,AX
        LEA     AX,TEMPWRD
        PUSH    AX
        LEA     AX,ASCNUM
        PUSH    AX
        CALL    INTASC
        ADD     SP,0004h
        PDIS    ASCNUM,01h,17h

        MOV     EAX,COUNTER
        MOV     TEMPWRD,AX
        LEA     AX,TEMPWRD
        PUSH    AX
        LEA     AX,ASCNUM
        PUSH    AX
        CALL    INTASC
        ADD     SP,0004h
        PDIS    ASCNUM,01h,21h

        MOV     AL,IEN
        MOV     AH,00h
        MOV     TEMPWRD,AX
        LEA     AX,TEMPWRD
        PUSH    AX
        LEA     AX,ASCNUM
        PUSH    AX
        CALL    INTASC
        ADD     SP,0004h
        PDIS    ASCNUM,02h,03h

        MOV     AL,IRQ
        MOV     AH,00h
        MOV     TEMPWRD,AX
        LEA     AX,TEMPWRD
        PUSH    AX
        LEA     AX,ASCNUM
        PUSH    AX
        CALL    INTASC
        ADD     SP,0004h
        PDIS    ASCNUM,02h,0Dh

        MOV     AL,ISK
        MOV     AH,00h
        MOV     TEMPWRD,AX
        LEA     AX,TEMPWRD
        PUSH    AX
        LEA     AX,ASCNUM
        PUSH    AX
        CALL    INTASC
        ADD     SP,0004h
        PDIS    ASCNUM,02h,17h

        MOV     AL,HALTED
        MOV     AH,00h
        MOV     TEMPWRD,AX
        LEA     AX,TEMPWRD
        PUSH    AX
        LEA     AX,ASCNUM
        PUSH    AX
        CALL    INTASC
        ADD     SP,0004h
        PDIS    ASCNUM,02h,21h
        RET
DREGS   ENDP

UPDATE  PROC    NEAR
        MOV     CX,00E0h
        MOV     BX,2400h
        MOV     AX,0A000h
        MOV     FS,AX
        MOV     DI,0000h
@@DoUpdate:
        MOV     DH,00h
        MOV     DL,20h
@@DrawScan:
        PUSH    DX
        MOV     DL,BYTE PTR ES:[BX]
        REVNUM  DL,REVTABL
        MOV     BYTE PTR FS:[DI],DL
        POP     DX
        INC     DI
        INC     BX
        DEC     DL
        JZ      @@DoneScan
        JMP     @@DrawScan
@@DoneScan:
        ADD     DI,0030h
        LOOP    @@DoUpdate
        RET
UPDATE  ENDP

DOINT   PROC    NEAR
        LOCALS
        CMP     IEN,00h
        JE      @@PushInt
        CMP     HALTED,00h
        JE      @@ContInt
        INC     i8080PC
        MOV     HALTED,00h
@@ContInt:
        CMP     ISK,00h
        JE      @@CallInt
        MOV     AL,ISK
        MOV     AH,IRQ
        MOV     ISK,AH
        MOV     IRQ,AL
@@CallInt:
        MOV     BX,i8080SP
        MOV     CX,i8080PC
        MOV     BYTE PTR ES:[BX-1],CH
        MOV     BYTE PTR ES:[BX-2],CL
        MOVZX   AX,IRQ
        MOV     i8080PC,AX
        DEC     i8080SP
        DEC     i8080SP
        CMP     EIINT,00h
        JE      @@NotAnEI
        DEC     i8080PC
@@NotAnEI:
        RET
@@PushInt:
        MOV     AL,IRQ
        MOV     ISK,AL
        RET
DOINT   ENDP

GETHEDR PROC    NEAR        
        SDIS    INSTRUC
        MOV     BX,0080h
        MOV     AH,BYTE PTR ES:[BX]
        OR      AH,AH
        JNZ     GotHName
        SDIS    NOFILEN
        ENDPROG
GotHName:
        INC     BX
        INC     BX
        DEC     AH
        LEA     DI,HDRNAME
        MOV     AL,0Ch
GetHeader:
        MOV     CL,BYTE PTR ES:[BX]
        CMP     CL,0Dh
        JE      InitNum
        MOV     BYTE PTR DS:[DI],CL
        
        INC     BX
        INC     DI
        DEC     AH
        JZ      InitNum

        DEC     AL
        JZ      TooLong
        JMP     GetHeader
InitNum:
        RET
TooLong:
        SDIS    F2LONG
        ENDPROG
GETHEDR ENDP

READHDR PROC    NEAR
        MOV     AH,3Dh
        MOV     AL,00h                  
        LEA     DX,HDRNAME           
        MOV     CL,00h           
        INT     21h
        JNC     LoadedHName

        SDIS    NOHEADR
        ENDPROG
LoadedHName:
        MOV     HHANDLE,AX
        LEA     DI,RNAME
        MOV     DX,0000h
GetHeaderData:
        PUSH    DX
        MOV     AH,3Fh                  ; Request file or device read
        MOV     BX,HHANDLE
        MOV     CX,0001h
        LEA     DX,TEMPBYT
        INT     21h
        JC      BadErr

        CMP     AX,0001h
        JE      ContinueLoad
        SDIS    HDRSHRT
        ENDPROG
ContinueLoad:
        MOV     AL,TEMPBYT
        MOV     BYTE PTR DS:[DI],AL
        POP     DX
        INC     DX
        INC     DI
        CMP     DX,015Eh
        JE      GetBitmapIn 
        JMP     GetHeaderData
GetBitmapIn:        
        MOV     AH,3Fh                  ; Request file or device read
        MOV     BX,HHANDLE
        MOV     CX,0001h
        LEA     DX,TEMPBYT
        INT     21h
        JC      BadErr

        CMP     AX,0001h
        JE      GetBitmapOut
        SDIS    HDRSHRT
        ENDPROG
GetBitmapOut:
        MOV     AL,TEMPBYT
        MOV     BTMPIN,AL
        MOV     AH,3Fh                  ; Request file or device read
        MOV     BX,HHANDLE
        MOV     CX,0001h
        LEA     DX,TEMPBYT
        INT     21h
        JC      BadErr

        CMP     AX,0001h
        JE      GetShiftOut
        SDIS    HDRSHRT
        ENDPROG
GetShiftOut:
        XOR     AX,AX
        MOV     AL,TEMPBYT
        MOV     BTMPOUT,AX
        MOV     AH,3Fh                  ; Request file or device read
        MOV     BX,HHANDLE
        MOV     CX,0001h
        LEA     DX,TEMPBYT
        INT     21h
        JC      BadErr

        CMP     AX,0001h
        JE      DoneHeader
        SDIS    HDRSHRT
        ENDPROG
DoneHeader:
        XOR     AX,AX
        MOV     AL,TEMPBYT
        MOV     SHFTOUT,AX
        RET
READHDR ENDP
        END     MAIN
