 /****************************************************************************\
 * CDiso PLUGIN for FPSE
 *
 *
 * AUTHOR: Xobro, mail: _xobro_@tin.it 
 *
 * WHAT'S NEW: It compiles and it seems to work! ;-)
 *
 * KNOWN ISSUES: If the "Select iso" dialog is moved it disappear
 *
 * TO DO: ?
 *
\****************************************************************************/

#include <windows.h>
#include <commdlg.h>
#include <stdio.h>
#include <memory.h>

#include "type.h"
#include "Win32Def.h"
#include "sdk.h"


// #define DEBUG_CDISO

/****************************************************************************\
 * Plugin Info
\****************************************************************************/

#define VERSION 0x0100	// Version must be in BCD format

static FPSEWin32About pluginInfo = {
	FPSE_CDROM,
	VERSION & 0xFF,
	VERSION >> 8,
	0,
	"Xobro",
	"CDiso",
	"CD-ROM Plugin to load ISO images."
};


/****************************************************************************\
 * Internal variables & defines
\****************************************************************************/

static HANDLE hinstance = (HANDLE)-1;

#define RAW_SECTOR_SIZE     2352
#define COOKED_SECTOR_SIZE  2048	// not used at the moment

#define MSF2SECT(m,s,f)	(((m)*60+(s)-2)*75+(f)) 

#define	INT2BCD(a)	((a)/10*16+(a)%10)

static HANDLE hISOFile = NULL;

#define MAXFILENAMELENGHT 512
char ISOFileName[MAXFILENAMELENGHT] = {0};

static int error = 0;

static UINT8 readBuffer[RAW_SECTOR_SIZE];
static UINT32 LastSector = -1;


/****************************************************************************\
 * Read: read data in the sector passed as param
\****************************************************************************/

UINT8 *CD_Read(UINT8 *param){
	DWORD nbytesRead;
	int Ret;

	//if no iso selected act as a null CD plugin
	if (hISOFile == NULL){
		error = 1;
		return readBuffer;
	}

	// Set the file pointer at the right sector and skip synch field (12 bytes)	
	SetFilePointer (hISOFile,
                    MSF2SECT(param[0],param[1],param[2])*RAW_SECTOR_SIZE+12,
                    NULL,
                    FILE_BEGIN);
	
	//read the data leaving room for the header
	Ret = ReadFile(hISOFile, readBuffer, RAW_SECTOR_SIZE-12, &nbytesRead, NULL);

#ifdef DEBUG_CDISO
    printf("Ret = %d - nu = %d\n", Ret, nbytesRead);
    if (!Ret) printf("Error = %08x\n",GetLastError());
#endif

	error = 0;
	//if (!Ret) error = 1; //? commented out also in CDCTRL.C

	// emulate header
	readBuffer[0] = INT2BCD(param[0]);
	readBuffer[1] = INT2BCD(param[1]);
	readBuffer[2] = INT2BCD(param[2]);

	return readBuffer;
}


/****************************************************************************\
 * Play CD Digital Audio
\****************************************************************************/

int CD_Play(UINT8 *param){
    return FPSE_OK;
}


/****************************************************************************\
 * Stop CD Digital Audio
\****************************************************************************/

int CD_Stop(void){
    return FPSE_OK;
}


/****************************************************************************\
 * CD_GetTN: Get track number
\****************************************************************************/

int CD_GetTN(UINT8 *result){
	// not sure about this...
	result[1] = 1; //maybe BCD2INT(1);?
	result[2] = 3; //maybe BCD2INT(1);?
	return FPSE_OK;
}


/****************************************************************************\
 * CD_GetTD: return track specs
\****************************************************************************/

int CD_GetTD(UINT8 *result,int track){
	// not sure about this...
	result[1] = 0;	//minute
	result[2] = 0;	//second
	result[3] = 0;	//frame
	return FPSE_OK;
}


/****************************************************************************\
 * CD_Open: init CD hardware
\****************************************************************************/

int CD_Open(UINT32 *par){
	FPSEWin32  *info=(FPSEWin32 *)(par);

	//initilaize OPENFILENAME structure
	OPENFILENAME ofn = {sizeof(OPENFILENAME),			// size
						NULL,							// owner
						NULL,							// hInstance
						"ISO images\0*.bin;*.iso\0",	// filter
						0,								// custom filter
						0,								// max custom filter
						0,								// filter index
						(char *)&ISOFileName,			// file name
						sizeof ISOFileName,				// max filename lenght
						0,								// file title
						0,								// max file title
						NULL,							// initial dir 
						"Select ISO",					// title
						OFN_FILEMUSTEXIST,				// flags
						0,								// file offset
						0,								// file extension
						0,								// def ext
						0,								// cust data
						0,								// hook
						0};								// template

	//Common open file dialog
	if(!GetOpenFileName(&ofn)){

#ifdef DEBUG_CDISO
	    printf("Acting as a null cd plugin\n");
#endif

		return FPSE_OK;
	}

	//open the selected file
	hISOFile = CreateFile(ISOFileName,				// FILE to open  
						  GENERIC_READ,             // open for reading 
						  FILE_SHARE_READ|FILE_SHARE_WRITE,	//? would be better 0 (do not share)? 
						  NULL,                     // no security 
						  OPEN_EXISTING,            // existing file only 
						  FILE_FLAG_SEQUENTIAL_SCAN,// flags 
						  NULL);                    // no attr. template 
	if (hISOFile == INVALID_HANDLE_VALUE){

#ifdef DEBUG_CDISO
    printf("error opening the file\n");
#endif

	return FPSE_ERR;
	}

	error = 0;
	return FPSE_OK;
}


/****************************************************************************\
 * Close: CD shutdown
\****************************************************************************/

void CD_Close(void){
	CD_Wait();
	CloseHandle(hISOFile);
}


/****************************************************************************\
 * Wait
\****************************************************************************/

int CD_Wait(){
	if (error){
		error = 0;
		return FPSE_ERR;
	}
	return FPSE_OK;
}


/****************************************************************************\
 * Configure
\****************************************************************************/

int CD_Configure(UINT32 *par){
	FPSEWin32 *info = (FPSEWin32 *)par;
    MessageBox(info->HWnd,"No configuration is required","CDISO config",MB_OK);
	return FPSE_OK;
}


/****************************************************************************\
 * About
\****************************************************************************/

void CD_About(UINT32 *par){
	memcpy(par, &pluginInfo, sizeof(FPSEWin32About));
    return ;
}



