/*
 * Decompiled with CFR 0.152.
 */
package jef.sound.chip;

import jef.map.WriteHandler;
import jef.sound.SoundChip;
import jef.sound.SoundChipEmulator;

public class SN76496
extends SoundChip
implements SoundChipEmulator {
    private int SN76496_FREQ;
    private static final int MAX_OUTPUT = Short.MAX_VALUE;
    private static final int STEP = 65536;
    private static final int FB_WNOISE = 81922;
    private static final int FB_PNOISE = 32768;
    private static final int NG_PRESET = 3893;
    private int gain = 16;
    private int Channel;
    private int SampleRate;
    private int UpdateStep;
    private int[] VolTable = new int[16];
    private int[] Register = new int[8];
    private int LastRegister;
    private int[] Volume = new int[4];
    private int RNG;
    private int NoiseFB;
    private int[] Period = new int[4];
    private int[] Count = new int[4];
    private int[] Output = new int[4];
    int[] vol = new int[4];
    private boolean changed = false;

    public SN76496(int clockFreq) {
        this.SN76496_FREQ = clockFreq;
    }

    public void init(boolean useJavaxSound, int sampRate, int buflen, int fps) {
        super.init(useJavaxSound, sampRate, buflen, fps);
        this.UpdateStep = 65536 * sampRate * 16 / (this.SN76496_FREQ / 16);
        int i = 0;
        while (i < 4) {
            this.Volume[i] = 0;
            ++i;
        }
        this.LastRegister = 0;
        i = 0;
        while (i < 8) {
            this.Register[i] = 0;
            this.Register[i + 1] = 15;
            i += 2;
        }
        i = 0;
        while (i < 4) {
            this.Output[i] = 0;
            this.Period[i] = this.Count[i] = this.UpdateStep;
            ++i;
        }
        this.RNG = 3893;
        this.Output[3] = this.RNG & 1;
        this.gain &= 0xFF;
        float out = 10922.0f;
        while (this.gain-- > 0) {
            out = (float)((double)out * 1.023292992);
        }
        i = 0;
        while (i < 15) {
            this.VolTable[i] = out > 10922.0f ? 10922 : (int)out;
            out = (float)((double)out / 1.258925412);
            ++i;
        }
        this.VolTable[15] = 0;
    }

    public void writeBuffer() {
        this.clearBuffer();
        int length = super.getBufferLength();
        int i = 0;
        while (i < 4) {
            if (this.Volume[i] == 0 && this.Count[i] <= length * 65536) {
                int n = i;
                this.Count[n] = this.Count[n] + length * 65536;
            }
            ++i;
        }
        int b = 0;
        while (b < length) {
            int nextevent;
            this.vol[3] = 0;
            this.vol[2] = 0;
            this.vol[1] = 0;
            this.vol[0] = 0;
            i = 0;
            while (i < 3) {
                if (this.Output[i] != 0) {
                    int n = i;
                    this.vol[n] = this.vol[n] + this.Count[i];
                }
                int n = i;
                this.Count[n] = this.Count[n] - 65536;
                while (this.Count[i] <= 0) {
                    int n2 = i;
                    this.Count[n2] = this.Count[n2] + this.Period[i];
                    if (this.Count[i] > 0) {
                        int n3 = i;
                        this.Output[n3] = this.Output[n3] ^ 1;
                        if (this.Output[i] == 0) break;
                        int n4 = i;
                        this.vol[n4] = this.vol[n4] + this.Period[i];
                        break;
                    }
                    int n5 = i;
                    this.Count[n5] = this.Count[n5] + this.Period[i];
                    int n6 = i;
                    this.vol[n6] = this.vol[n6] + this.Period[i];
                }
                if (this.Output[i] != 0) {
                    int n7 = i;
                    this.vol[n7] = this.vol[n7] - this.Count[i];
                }
                ++i;
            }
            int left = 65536;
            do {
                nextevent = this.Count[3] < left ? this.Count[3] : left;
                if (this.Output[3] != 0) {
                    this.vol[3] = this.vol[3] + this.Count[3];
                }
                this.Count[3] = this.Count[3] - nextevent;
                if (this.Count[3] <= 0) {
                    if ((this.RNG & 1) == 1) {
                        this.RNG ^= this.NoiseFB;
                    }
                    this.RNG >>= 1;
                    this.Output[3] = this.RNG & 1;
                    this.Count[3] = this.Count[3] + this.Period[3];
                    if (this.Output[3] != 0) {
                        this.vol[3] = this.vol[3] + this.Period[3];
                    }
                }
                if (this.Output[3] == 0) continue;
                this.vol[3] = this.vol[3] - this.Count[3];
            } while ((left -= nextevent) > 0);
            int out = this.vol[0] * this.Volume[0] + this.vol[1] * this.Volume[1] + this.vol[2] * this.Volume[2] + this.vol[3] * this.Volume[3];
            if (out > 0x7FFF0000) {
                out = 0x7FFF0000;
            }
            this.writeLinBuffer(b, out / 65536);
            ++b;
        }
    }

    public WriteHandler sn76496_command_w() {
        return new SN76496_command_w();
    }

    public void command_w(int data) {
        block12: {
            block11: {
                if ((data & 0x80) == 0) break block11;
                int r = (data & 0x70) >> 4;
                int c = r / 2;
                int n = 0;
                this.LastRegister = r;
                this.Register[r] = this.Register[r] & 0x3F0 | data & 0xF;
                switch (r) {
                    case 0: 
                    case 2: 
                    case 4: {
                        this.Period[c] = this.UpdateStep * this.Register[r];
                        if (this.Period[c] == 0) {
                            this.Period[c] = this.UpdateStep;
                        }
                        if (r == 4 && (this.Register[6] & 3) == 3) {
                            this.Period[3] = 2 * this.Period[2];
                            break;
                        }
                        break block12;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: {
                        this.Volume[c] = this.VolTable[data & 0xF];
                        break;
                    }
                    case 6: {
                        n = this.Register[6];
                        this.NoiseFB = (n & 4) != 0 ? 81922 : 32768;
                        this.Period[3] = (n &= 3) == 3 ? 2 * this.Period[2] : this.UpdateStep << 5 + n;
                        this.RNG = 3893;
                        this.Output[3] = this.RNG & 1;
                    }
                }
                break block12;
            }
            int r = this.LastRegister;
            int c = r / 2;
            switch (r) {
                case 0: 
                case 2: 
                case 4: {
                    this.Register[r] = this.Register[r] & 0xF | (data & 0x3F) << 4;
                    this.Period[c] = this.UpdateStep * this.Register[r];
                    if (this.Period[c] == 0) {
                        this.Period[c] = this.UpdateStep;
                    }
                    if (r != 4 || (this.Register[6] & 3) != 3) break;
                    this.Period[3] = 2 * this.Period[2];
                }
            }
        }
    }

    public class SN76496_command_w
    implements WriteHandler {
        public void write(int address, int data) {
            SN76496.this.command_w(data);
        }
    }
}

