/*
 * Decompiled with CFR 0.152.
 */
package jef.video;

import jef.video.GfxLayout;

public class GfxDecodeInfo {
    public int[] mem;
    public int offset;
    public GfxLayout gfx;
    public int colorOffset;
    public int numberOfColors;

    public boolean IS_FRAC(int offset) {
        return (offset & Integer.MIN_VALUE) != 0;
    }

    public int FRAC_NUM(int offset) {
        return offset >> 27 & 0xF;
    }

    public int FRAC_DEN(int offset) {
        return offset >> 23 & 0xF;
    }

    public int FRAC_OFFSET(int offset) {
        return offset & 0x7FFFFF;
    }

    public GfxDecodeInfo(int[] mem, int offset, GfxLayout gfx, int colorOffset, int numberOfColors) {
        this.mem = mem;
        this.offset = offset;
        this.gfx = gfx;
        this.colorOffset = colorOffset;
        this.numberOfColors = numberOfColors;
    }

    public GfxDecodeInfo(int[] mem, int offset, int[][] gfx, int colorOffset, int numberOfColors) {
        int den;
        int num;
        this.mem = mem;
        this.offset = offset;
        if (this.IS_FRAC(gfx[2][0])) {
            num = this.FRAC_NUM(gfx[2][0]);
            den = this.FRAC_DEN(gfx[2][0]);
            gfx[2][0] = 8 * mem.length * num / (den * gfx[7][0]);
        }
        int i = 0;
        while (i < gfx[4].length) {
            if (this.IS_FRAC(gfx[4][i])) {
                num = this.FRAC_NUM(gfx[4][i]);
                den = this.FRAC_DEN(gfx[4][i]);
                int ofs = this.FRAC_OFFSET(gfx[4][i]);
                gfx[4][i] = 8 * mem.length * num / den + ofs;
            }
            ++i;
        }
        this.gfx = new GfxLayout(gfx[0][0], gfx[1][0], gfx[2][0], gfx[3][0], gfx[4], gfx[5], gfx[6], gfx[7][0]);
        this.colorOffset = colorOffset;
        this.numberOfColors = numberOfColors;
    }
}

