/*
 * Decompiled with CFR 0.152.
 */
package cottage.vidhrdw;

import cottage.mame.MAMEVideo;
import jef.map.WriteHandler;
import jef.video.BitMap;
import jef.video.Vh_convert_color_proms;
import jef.video.VideoEmulator;

public class Bw8080
extends MAMEVideo
implements VideoEmulator {
    int[] REGION_PROMS;
    int[] pal = new int[2];
    int[][] gfx = new int[256][8];
    int[][] overlay = new int[65536][2];
    int screen_red_enabled = 0;
    int color_map_select = 0;
    int screen_red = 0;
    static final int BLACK = 0;
    static final int RED = 0xFF2020;
    static final int GREEN = 0x20FF20;
    static final int YELLOW = 0xFFFF20;
    static final int WHITE = 0xFFFFFF;
    static final int CYAN = 0x20FFFF;
    static final int PURPLE = 0xFF20FF;
    static final int ORANGE = 16748576;
    static final int YELLOW_GREEN = 9502496;
    static final int GREEN_CYAN = 2162576;

    public void setRegions(int[] proms) {
        this.REGION_PROMS = proms;
    }

    public int vh_start() {
        this.pal[0] = 0;
        this.pal[1] = 0xFFFFFF;
        int i = 0;
        while (i < 256) {
            this.gfx[i][7] = this.pal[i >> 7];
            this.gfx[i][6] = this.pal[(i & 0x40) >> 6];
            this.gfx[i][5] = this.pal[(i & 0x20) >> 5];
            this.gfx[i][4] = this.pal[(i & 0x10) >> 4];
            this.gfx[i][3] = this.pal[(i & 8) >> 3];
            this.gfx[i][2] = this.pal[(i & 4) >> 2];
            this.gfx[i][1] = this.pal[(i & 2) >> 1];
            this.gfx[i][0] = this.pal[i & 1];
            ++i;
        }
        return 0;
    }

    public void invadpt2_vh_convert_color_prom() {
        int ptr = 0;
        int i = 0;
        while (i < this.total_colors) {
            int r = 255 * (i >> 0 & 1);
            int g = 255 * (i >> 2 & 1);
            int b = 255 * (i >> 1 & 1);
            this.palette_set_color(ptr++, r, g, b);
            ++i;
        }
    }

    public void invadpt2_videoram_w(int offset, int data) {
        int y = (offset -= 9216) / 32;
        int x = 8 * (offset % 32);
        int col = this.screen_red == 0 ? this.REGION_PROMS[(this.color_map_select != 0 ? 1024 : 0) + (y + 32) / 8 * 32 + x / 8] & 7 : 1;
        int i = 0;
        while (i < 8) {
            int ix = (x + i) * 224 + y;
            this.pixels[ix] = (data & 1) != 0 ? col : 0;
            data >>= 1;
            ++i;
        }
    }

    public void schaser_videoram_w(int offset, int data) {
    }

    public void schaser_colorram_w(int offset, int data) {
    }

    public BitMap vh_refresh() {
        return this.bitmap;
    }

    public void writeVRAM(int layer, int address, int value) {
        if (this.rot == 0) {
            int i = (address - 9216) * 8;
            System.arraycopy(this.gfx[value], 0, this.pixels, i, 8);
        } else if (this.rot == 3) {
            int i = 7167 - (address - 9216);
            int x = (i & 0x1F) * 8;
            int y = 223 - (i >> 5);
            int n = 0;
            while (n < 8) {
                i = (x + n) * 224 + y;
                this.pixels[i] = this.overlay[i][this.gfx[value][7 - n] & 1];
                ++n;
            }
        } else {
            int i = address - 9216;
            int x = (i & 0x1F) * 8;
            int y = 223 - (i >> 5);
            i = x * 224 + y;
            this.pixels[i] = this.gfx[value][0];
            this.pixels[i + 224] = this.gfx[value][1];
            this.pixels[i + 448] = this.gfx[value][2];
            this.pixels[i + 672] = this.gfx[value][3];
            this.pixels[i + 896] = this.gfx[value][4];
            this.pixels[i + 1120] = this.gfx[value][5];
            this.pixels[i + 1344] = this.gfx[value][6];
            this.pixels[i + 1568] = this.gfx[value][7];
        }
    }

    private void invaders_overlay() {
        this.artwork_element(0, 255, 0, 255, 0xFFFFFF, 255);
        this.artwork_element(16, 71, 0, 255, 0x20FF20, 255);
        this.artwork_element(0, 15, 16, 133, 0x20FF20, 255);
        this.artwork_element(192, 223, 0, 255, 0xFF2020, 255);
    }

    private void invdpt2m_overlay() {
        this.artwork_element(0, 255, 0, 255, 0xFFFFFF, 255);
        this.artwork_element(16, 71, 0, 255, 0x20FF20, 255);
        this.artwork_element(0, 15, 16, 133, 0x20FF20, 255);
        this.artwork_element(72, 191, 0, 255, 0xFFFF20, 255);
        this.artwork_element(192, 223, 0, 255, 0xFF2020, 255);
    }

    private void invrvnge_overlay() {
        this.artwork_element(0, 255, 0, 255, 0xFFFFFF, 255);
        this.artwork_element(0, 71, 0, 255, 0x20FF20, 255);
        this.artwork_element(192, 223, 0, 255, 0xFF2020, 255);
    }

    private void invad2ct_overlay() {
        this.artwork_element(0, 24, 0, 255, 0xFFFF20, 255);
        this.artwork_element(25, 47, 0, 255, 9502496, 255);
        this.artwork_element(48, 70, 0, 255, 2162576, 255);
        this.artwork_element(71, 116, 0, 255, 0x20FFFF, 255);
        this.artwork_element(117, 139, 0, 255, 2162576, 255);
        this.artwork_element(140, 162, 0, 255, 0x20FF20, 255);
        this.artwork_element(163, 185, 0, 255, 9502496, 255);
        this.artwork_element(186, 208, 0, 255, 0xFFFF20, 255);
        this.artwork_element(209, 231, 0, 255, 16748576, 255);
        this.artwork_element(232, 255, 0, 255, 0xFF2020, 255);
    }

    public boolean bw8080() {
        this.artwork_element(0, 255, 0, 255, 0xFFFFFF, 255);
        this.color_map_select = 0;
        return true;
    }

    public boolean invaders() {
        this.bw8080();
        this.invaders_overlay();
        return true;
    }

    public boolean invadpt2() {
        this.bw8080();
        this.screen_red_enabled = 1;
        return true;
    }

    public boolean invdpt2m() {
        this.bw8080();
        this.invdpt2m_overlay();
        return true;
    }

    public boolean invrvnge() {
        this.bw8080();
        this.invrvnge_overlay();
        return true;
    }

    public boolean invad2ct() {
        this.bw8080();
        this.invad2ct_overlay();
        return true;
    }

    private void artwork_element(int y, int h, int x, int w, int c, int dontknowMaybeAlpha) {
        int col = (c & 0xFF) << 16 | c & 0xFF00 | (c & 0xFF0000) >> 16;
        if (w > 223) {
            w = 223;
        }
        int iy = y;
        while (iy <= h) {
            int ix = x;
            while (ix <= w) {
                this.overlay[(255 - iy) * 224 + ix][1] = col;
                if (col != 0xFFFFFF) {
                    this.overlay[(255 - iy) * 224 + ix][0] = col & 0xF0F0F;
                }
                ++ix;
            }
            ++iy;
        }
    }

    public WriteHandler invadpt2_videoram_w(int[] mem, Bw8080 video) {
        return new Invadpt2_videoram_w(mem, video);
    }

    public WriteHandler c8080bw_videoram_w(int[] mem, MAMEVideo video) {
        return new Invaders_videoram_w(mem, video);
    }

    public WriteHandler schaser_colorram_w(int[] mem, Bw8080 video) {
        return new Schaser_colorram_w(mem, video);
    }

    public Vh_convert_color_proms invadpt2_vh_convert_color_prom(Bw8080 video) {
        return new Invadpt2_vh_convert_color_prom(video);
    }

    public class Invadpt2_videoram_w
    implements WriteHandler {
        int[] mem;
        Bw8080 video;

        public Invadpt2_videoram_w(int[] mem, Bw8080 video) {
            this.mem = mem;
            this.video = video;
        }

        public void write(int address, int value) {
            this.mem[address] = value;
            this.video.invadpt2_videoram_w(address, value);
        }
    }

    public class Invaders_videoram_w
    implements WriteHandler {
        int[] mem;
        MAMEVideo video;

        public Invaders_videoram_w(int[] mem, MAMEVideo video) {
            this.mem = mem;
            this.video = video;
        }

        public void write(int address, int value) {
            this.mem[address] = value;
            ((Bw8080)this.video).writeVRAM(0, address, value);
        }
    }

    public class Schaser_colorram_w
    implements WriteHandler {
        int[] mem;
        Bw8080 video;

        public Schaser_colorram_w(int[] mem, Bw8080 video) {
            this.mem = mem;
            this.video = video;
        }

        public void write(int address, int value) {
            int offset = address - 41984;
            this.mem[41984 + (offset &= 0x1F1F)] = value;
            this.video.schaser_colorram_w(address, value);
        }
    }

    public class Invadpt2_vh_convert_color_prom
    implements Vh_convert_color_proms {
        Bw8080 video;

        public Invadpt2_vh_convert_color_prom(Bw8080 video) {
            this.video = video;
        }

        public void palette_init() {
            this.video.invadpt2_vh_convert_color_prom();
        }
    }
}

